/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObjectAdapter;
import org.jruby.RubyString;
import org.jruby.embed.BiVariable;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EmbedRubyObjectAdapter;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.internal.CallMethodType;
import org.jruby.embed.variable.InstanceVariable;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbedRubyObjectAdapterImpl
implements EmbedRubyObjectAdapter {
    private RubyObjectAdapter adapter = JavaEmbedUtils.newObjectAdapter();
    private ScriptingContainer container;

    public EmbedRubyObjectAdapterImpl(ScriptingContainer container) {
        this.container = container;
    }

    public boolean isKindOf(IRubyObject value, RubyModule rubyModule) {
        return this.adapter.isKindOf(value, rubyModule);
    }

    public IRubyObject[] convertToJavaArray(IRubyObject array) {
        return this.adapter.convertToJavaArray(array);
    }

    public RubyInteger convertToRubyInteger(IRubyObject obj) {
        return this.adapter.convertToRubyInteger(obj);
    }

    public RubyString convertToRubyString(IRubyObject obj) {
        return this.adapter.convertToRubyString(obj);
    }

    public synchronized IRubyObject setInstanceVariable(IRubyObject obj, String variableName, IRubyObject value) {
        BiVariableMap map = this.container.getVarMap();
        if (map.containsKey(variableName)) {
            BiVariable bv = map.getVariable(variableName);
            bv.setRubyObject(obj);
        } else {
            InstanceVariable iv = new InstanceVariable(variableName, value);
            map.update(variableName, iv);
        }
        return obj.getInstanceVariables().setInstanceVariable(variableName, value);
    }

    public IRubyObject getInstanceVariable(IRubyObject obj, String variableName) {
        BiVariableMap map = this.container.getVarMap();
        if (map.containsKey(variableName)) {
            BiVariable bv = map.getVariable(variableName);
            return bv.getRubyObject();
        }
        return null;
    }

    public IRubyObject callMethod(IRubyObject receiver, String methodName) {
        return this.adapter.callMethod(receiver, methodName);
    }

    public IRubyObject callMethod(IRubyObject receiver, String methodName, IRubyObject singleArg) {
        return this.adapter.callMethod(receiver, methodName, singleArg);
    }

    public IRubyObject callMethod(IRubyObject receiver, String methodName, IRubyObject[] args) {
        return this.adapter.callMethod(receiver, methodName, args);
    }

    public IRubyObject callMethod(IRubyObject receiver, String methodName, IRubyObject[] args, Block block) {
        return this.adapter.callMethod(receiver, methodName, args, block);
    }

    public IRubyObject callSuper(IRubyObject receiver, IRubyObject[] args) {
        return this.adapter.callSuper(receiver, args);
    }

    public IRubyObject callSuper(IRubyObject receiver, IRubyObject[] args, Block block) {
        return this.adapter.callSuper(receiver, args, block);
    }

    @Override
    @CallMethodType(methodType=0)
    public <T> T callMethod(Object receiver, String methodName, Class<T> returnType) {
        Class[] params = new Class[]{Object.class, String.class, Class.class};
        try {
            Method method = this.getClass().getMethod("callMethod", params);
            return this.call(returnType, method, receiver, methodName, null, null, new Object[0]);
        }
        catch (Exception e) {
            try {
                PrintWriter w = (PrintWriter)this.container.getErrorWriter();
                e.printStackTrace(w);
                this.container.getErrorWriter().write(e.getMessage());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    @CallMethodType(methodType=1)
    public <T> T callMethod(Object receiver, String methodName, Object singleArg, Class<T> returnType) {
        Class[] params = new Class[]{Object.class, String.class, Object.class, Class.class};
        try {
            Method method = this.getClass().getMethod("callMethod", params);
            return this.call(returnType, method, receiver, methodName, null, null, singleArg);
        }
        catch (Exception e) {
            try {
                PrintWriter w = (PrintWriter)this.container.getErrorWriter();
                e.printStackTrace(w);
                this.container.getErrorWriter().write(e.getMessage());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    @CallMethodType(methodType=2)
    public <T> T callMethod(Object receiver, String methodName, Object[] args, Class<T> returnType) {
        Class[] params = new Class[]{Object.class, String.class, Object[].class, Class.class};
        try {
            Method method = this.getClass().getMethod("callMethod", params);
            return this.call(returnType, method, receiver, methodName, null, null, args);
        }
        catch (Exception e) {
            try {
                PrintWriter w = (PrintWriter)this.container.getErrorWriter();
                e.printStackTrace(w);
                this.container.getErrorWriter().write(e.getMessage());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    @CallMethodType(methodType=3)
    public <T> T callMethod(Object receiver, String methodName, Object[] args, Block block, Class<T> returnType) {
        Class[] params = new Class[]{Object.class, String.class, Object[].class, Block.class, Class.class};
        try {
            Method method = this.getClass().getMethod("callMethod", params);
            return this.call(returnType, method, receiver, methodName, block, null, args);
        }
        catch (Exception e) {
            try {
                PrintWriter w = (PrintWriter)this.container.getErrorWriter();
                e.printStackTrace(w);
                this.container.getErrorWriter().write(e.getMessage());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    @CallMethodType(methodType=4)
    public <T> T callMethod(Object receiver, String methodName, Class<T> returnType, EmbedEvalUnit unit) {
        Class[] params = new Class[]{Object.class, String.class, Class.class, EmbedEvalUnit.class};
        try {
            Method method = this.getClass().getMethod("callMethod", params);
            return this.call(returnType, method, receiver, methodName, null, unit, new Object[0]);
        }
        catch (Exception e) {
            try {
                PrintWriter w = (PrintWriter)this.container.getErrorWriter();
                e.printStackTrace(w);
                this.container.getErrorWriter().write(e.getMessage());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    @CallMethodType(methodType=5)
    public <T> T callMethod(Object receiver, String methodName, Object[] args, Class<T> returnType, EmbedEvalUnit unit) {
        Class[] params = new Class[]{Object.class, String.class, Object[].class, Class.class, EmbedEvalUnit.class};
        try {
            Method method = this.getClass().getMethod("callMethod", params);
            return this.call(returnType, method, receiver, methodName, null, unit, args);
        }
        catch (Exception e) {
            try {
                PrintWriter w = (PrintWriter)this.container.getErrorWriter();
                e.printStackTrace(w);
                this.container.getErrorWriter().write(e.getMessage());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    @CallMethodType(methodType=6)
    public <T> T callMethod(Object receiver, String methodName, Object[] args, Block block, Class<T> returnType, EmbedEvalUnit unit) {
        Class[] params = new Class[]{Object.class, String.class, Object[].class, Block.class, Class.class, EmbedEvalUnit.class};
        try {
            Method method = this.getClass().getMethod("callMethod", params);
            return this.call(returnType, method, receiver, methodName, block, unit, args);
        }
        catch (Exception e) {
            try {
                PrintWriter w = (PrintWriter)this.container.getErrorWriter();
                e.printStackTrace(w);
                this.container.getErrorWriter().write(e.getMessage());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    @CallMethodType(methodType=7)
    public <T> T callSuper(Object receiver, Object[] args, Class<T> returnType) {
        Class[] params = new Class[]{Object.class, Object[].class, Class.class};
        try {
            Method method = this.getClass().getMethod("callSuper", params);
            return this.call(returnType, method, receiver, null, null, null, args);
        }
        catch (Exception e) {
            try {
                PrintWriter w = (PrintWriter)this.container.getErrorWriter();
                e.printStackTrace(w);
                this.container.getErrorWriter().write(e.getMessage());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    @CallMethodType(methodType=8)
    public <T> T callSuper(Object receiver, Object[] args, Block block, Class<T> returnType) {
        Class[] params = new Class[]{Object.class, Object[].class, Block.class, Class.class};
        try {
            Method method = this.getClass().getMethod("callSuper", params);
            return this.call(returnType, method, receiver, null, block, null, args);
        }
        catch (Exception e) {
            try {
                PrintWriter w = (PrintWriter)this.container.getErrorWriter();
                e.printStackTrace(w);
                this.container.getErrorWriter().write(e.getMessage());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(e);
        }
    }

    private <T> T call(Class<T> returnType, Method method, Object receiver, String methodName, Block block, EmbedEvalUnit unit, Object ... args) {
        if (methodName == null || methodName.length() == 0) {
            return null;
        }
        Ruby runtime = this.container.getRuntime();
        IRubyObject rubyReceiver = receiver != null ? JavaUtil.convertJavaToRuby((Ruby)runtime, (Object)receiver) : runtime.getTopSelf();
        try {
            ManyVarsDynamicScope scope = unit != null ? unit.getScope() : null;
            this.container.getVarMap().inject(scope, 0, rubyReceiver);
            runtime.getCurrentContext().pushScope((DynamicScope)scope);
            IRubyObject result = this.callEachType(method, rubyReceiver, methodName, block, args);
            this.container.getVarMap().retrieve(rubyReceiver);
            if (!(result instanceof RubyNil)) {
                Object ret = JavaEmbedUtils.rubyToJava((Ruby)runtime, (IRubyObject)result, returnType);
                T t = ret != null ? (T)returnType.cast(ret) : null;
                return t;
            }
            T t = null;
            return t;
        }
        catch (RaiseException e) {
            RubyException re = e.getException();
            runtime.printError(re);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            try {
                PrintWriter w = (PrintWriter)this.container.getErrorWriter();
                e.printStackTrace(w);
                this.container.getErrorWriter().write(e.getMessage());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            throw new RuntimeException(e);
        }
        finally {
            runtime.getCurrentContext().popScope();
            JavaEmbedUtils.terminate((Ruby)runtime);
        }
    }

    private IRubyObject callEachType(Method method, IRubyObject rubyReceiver, String methodName, Block block, Object ... args) {
        Ruby runtime = this.container.getRuntime();
        IRubyObject[] rubyArgs = null;
        if (args != null && args.length > 0) {
            rubyArgs = JavaUtil.convertJavaArrayToRuby((Ruby)runtime, (Object[])args);
            for (int i = 0; i < rubyArgs.length; ++i) {
                IRubyObject obj = rubyArgs[i];
                if (!(obj instanceof JavaObject)) continue;
                rubyArgs[i] = Java.wrap((Ruby)runtime, (IRubyObject)obj);
            }
        }
        ThreadContext context = runtime.getCurrentContext();
        CallMethodType type = method.getAnnotation(CallMethodType.class);
        if (type != null) {
            switch (type.methodType()) {
                case 0: 
                case 4: {
                    return RuntimeHelpers.invoke((ThreadContext)context, (IRubyObject)rubyReceiver, (String)methodName);
                }
                case 1: 
                case 2: 
                case 5: {
                    return RuntimeHelpers.invoke((ThreadContext)context, (IRubyObject)rubyReceiver, (String)methodName, (IRubyObject[])rubyArgs);
                }
                case 3: 
                case 6: {
                    return RuntimeHelpers.invoke((ThreadContext)context, (IRubyObject)rubyReceiver, (String)methodName, (IRubyObject[])rubyArgs, (Block)block);
                }
                case 7: {
                    return RuntimeHelpers.invokeSuper((ThreadContext)context, (IRubyObject)rubyReceiver, (IRubyObject[])rubyArgs, (Block)Block.NULL_BLOCK);
                }
                case 9: {
                    return RuntimeHelpers.invokeSuper((ThreadContext)context, (IRubyObject)rubyReceiver, (IRubyObject[])rubyArgs, (Block)block);
                }
            }
        }
        return null;
    }
}

