/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.ObjectBuffer;
import com.kenai.jffi.Platform;

public abstract class Invoker {
    private static final long ADDRESS_SIZE = Platform.getPlatform().addressSize();
    private static final long ADDRESS_MASK = Platform.getPlatform().addressMask();
    private final Foreign foreign = Foreign.getInstance();

    public static final Invoker getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private Invoker() {
    }

    public final int invokeVrI(Function function) {
        return this.foreign.invokeVrI(function.getContextAddress());
    }

    public final int invokeNoErrnoVrI(Function function) {
        return this.foreign.invokeNoErrnoVrI(function.getContextAddress());
    }

    public final int invokeIrI(Function function, int arg1) {
        return this.foreign.invokeIrI(function.getContextAddress(), arg1);
    }

    public final int invokeNoErrnoIrI(Function function, int arg1) {
        return this.foreign.invokeNoErrnoIrI(function.getContextAddress(), arg1);
    }

    public final int invokeIIrI(Function function, int arg1, int arg2) {
        return this.foreign.invokeIIrI(function.getContextAddress(), arg1, arg2);
    }

    public final int invokeNoErrnoIIrI(Function function, int arg1, int arg2) {
        return this.foreign.invokeNoErrnoIIrI(function.getContextAddress(), arg1, arg2);
    }

    public final int invokeIIIrI(Function function, int arg1, int arg2, int arg3) {
        return this.foreign.invokeIIIrI(function.getContextAddress(), arg1, arg2, arg3);
    }

    public final int invokeNoErrnoIIIrI(Function function, int arg1, int arg2, int arg3) {
        return this.foreign.invokeNoErrnoIIIrI(function.getContextAddress(), arg1, arg2, arg3);
    }

    public final long invokeVrL(Function function) {
        return this.foreign.invokeVrL(function.getContextAddress());
    }

    public final long invokeLrL(Function function, long arg1) {
        return this.foreign.invokeLrL(function.getContextAddress(), arg1);
    }

    public final long invokeLLrL(Function function, long arg1, long arg2) {
        return this.foreign.invokeLLrL(function.getContextAddress(), arg1, arg2);
    }

    public final long invokeLLLrL(Function function, long arg1, long arg2, long arg3) {
        return this.foreign.invokeLLLrL(function.getContextAddress(), arg1, arg2, arg3);
    }

    public abstract long invokeAddress(Function var1, HeapInvocationBuffer var2);

    public final int invokeInt(Function function, HeapInvocationBuffer buffer) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        return objectBuffer != null ? this.invokeArrayWithObjectsInt32(function, buffer, objectBuffer) : this.foreign.invokeArrayReturnInt(function.getContextAddress(), buffer.array());
    }

    public final long invokeLong(Function function, HeapInvocationBuffer buffer) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        return objectBuffer != null ? this.foreign.invokeArrayWithObjectsInt64(function.getContextAddress(), buffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects()) : this.foreign.invokeArrayReturnLong(function.getContextAddress(), buffer.array());
    }

    public final float invokeFloat(Function function, HeapInvocationBuffer buffer) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        return objectBuffer != null ? this.foreign.invokeArrayWithObjectsFloat(function.getContextAddress(), buffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects()) : this.foreign.invokeArrayReturnFloat(function.getContextAddress(), buffer.array());
    }

    public final double invokeDouble(Function function, HeapInvocationBuffer buffer) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        return objectBuffer != null ? this.foreign.invokeArrayWithObjectsDouble(function.getContextAddress(), buffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects()) : this.foreign.invokeArrayReturnDouble(function.getContextAddress(), buffer.array());
    }

    public final byte[] invokeStruct(Function function, HeapInvocationBuffer buffer) {
        byte[] returnBuffer = new byte[function.getReturnType().size()];
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        if (objectBuffer != null) {
            this.foreign.invokeArrayWithObjectsReturnStruct(function.getContextAddress(), buffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects(), returnBuffer, 0);
        } else {
            this.foreign.invokeArrayReturnStruct(function.getContextAddress(), buffer.array(), returnBuffer, 0);
        }
        return returnBuffer;
    }

    public final void invokeStruct(Function function, HeapInvocationBuffer buffer, byte[] returnBuffer, int offset) {
        this.foreign.invokeArrayReturnStruct(function.getContextAddress(), buffer.array(), returnBuffer, offset);
    }

    public final Object invokeObject(Function function, HeapInvocationBuffer buffer) {
        ObjectBuffer objectBuffer = buffer.objectBuffer();
        return this.foreign.invokeArrayWithObjectsReturnObject(function.getContextAddress(), buffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects());
    }

    public final void invoke(Function function, long returnBuffer, long[] parameters) {
        this.foreign.invokePointerParameterArray(function.getContextAddress(), returnBuffer, parameters);
    }

    private final int invokeArrayWithObjectsInt32(Function function, HeapInvocationBuffer buffer, ObjectBuffer objectBuffer) {
        Object[] objects = objectBuffer.objects();
        int[] info = objectBuffer.info();
        int objectCount = objectBuffer.objectCount();
        switch (objectCount) {
            case 1: {
                return this.foreign.invokeArrayO1Int32(function.getContextAddress(), buffer.array(), objects[0], info[0], info[1], info[2]);
            }
            case 2: {
                return this.foreign.invokeArrayO2Int32(function.getContextAddress(), buffer.array(), objects[0], info[0], info[1], info[2], objects[1], info[3], info[4], info[5]);
            }
        }
        return this.foreign.invokeArrayWithObjectsInt32(function.getContextAddress(), buffer.array(), objectCount, info, objects);
    }

    static /* synthetic */ long access$000() {
        return ADDRESS_SIZE;
    }

    private static final class LP64
    extends Invoker {
        private static final Invoker INSTANCE = new LP64();

        private LP64() {
        }

        public long invokeAddress(Function function, HeapInvocationBuffer buffer) {
            return this.invokeLong(function, buffer);
        }

        static /* synthetic */ Invoker access$100() {
            return INSTANCE;
        }
    }

    private static final class ILP32
    extends Invoker {
        private static final Invoker INSTANCE = new ILP32();

        private ILP32() {
        }

        public final long invokeAddress(Function function, HeapInvocationBuffer buffer) {
            return (long)this.invokeInt(function, buffer) & ADDRESS_MASK;
        }

        static /* synthetic */ Invoker access$200() {
            return INSTANCE;
        }
    }

    private static final class SingletonHolder {
        private static final Invoker INSTANCE = Invoker.access$000() == 64L ? LP64.access$100() : ILP32.access$200();

        private SingletonHolder() {
        }
    }
}

