/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.Collection;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.embed.BiVariable;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.runtime.builtin.IRubyObject;

public class Constant
extends AbstractVariable {
    private boolean initialized = false;

    public static BiVariable getInstance(Ruby runtime, String name, Object ... javaObject) {
        String pattern = "[A-Z]([a-zA-Z]|_)([a-zA-Z]|_|\\d)*";
        if (name.matches(pattern)) {
            return new Constant(runtime, name, javaObject);
        }
        return null;
    }

    private Constant(Ruby runtime, String name, Object ... javaObject) {
        super(runtime, name, javaObject);
    }

    Constant(String name, IRubyObject irubyObject) {
        super(name, irubyObject);
    }

    void markInitialized() {
        this.initialized = true;
    }

    public static void retrieve(Ruby runtime, IRubyObject receiver, BiVariableMap vars) {
        if (receiver == null) {
            receiver = runtime.getTopSelf();
        }
        Collection names = receiver.getMetaClass().getConstantNames();
        for (String name : names) {
            BiVariable var;
            IRubyObject value = receiver.getMetaClass().getConstant(name);
            if (vars.containsKey(name)) {
                var = vars.getVariable(name);
                var.setRubyObject(value);
                continue;
            }
            var = new Constant(name, value);
            ((Constant)var).markInitialized();
            vars.update(name, var);
        }
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.Constant;
    }

    public void inject(Ruby runtime, IRubyObject receiver) {
        if (this.initialized) {
            return;
        }
        RubyModule rubyClass = this.getRubyClass(runtime);
        if (rubyClass != null) {
            rubyClass.setConstant(this.name, this.irubyObject);
        } else {
            RubyModule module = runtime.getCurrentContext().getRubyClass();
            module.setConstant(this.name, this.irubyObject);
        }
        this.initialized = true;
    }

    public void remove(Ruby runtime) {
    }
}

