---
title: Docker
---

# Docker

Tasks for orchestrating Docker images and containers.


## Images

### ListImages <Badge text="task"/>

Task for listing Docker images.

[API Reference](/api/unreleased/tasks/docker.html#prefect-tasks-docker-listimages)

### PullImage <Badge text="task"/>

Task for pulling a Docker image.

[API Reference](/api/unreleased/tasks/docker.html#prefect-tasks-docker-pullimage)

### PushImage <Badge text="task"/>

Task for pushing a Docker image.

[API Reference](/api/unreleased/tasks/docker.html#prefect-tasks-docker-pushimage)

### RemoveImage <Badge text="task"/>

Task for removing a Docker image.

[API Reference](/api/unreleased/tasks/docker.html#prefect-tasks-docker-removeimage)

### TagImage <Badge text="task"/>

Task for tagging a Docker image.

[API Reference](/api/unreleased/tasks/docker.html#prefect-tasks-docker-tagimage)

### BuildImage <Badge text="task"/>

Task for building a Docker image.

[API Reference](/api/unreleased/tasks/docker.html#prefect-tasks-docker-buildimage)


## Containers

### CreateContainer <Badge text="task"/>

Task for creating a Docker container.

[API Reference](/api/unreleased/tasks/docker.html#prefect-tasks-docker-createcontainer)

### GetContainerLogs <Badge text="task"/>

Task for getting the logs of a Docker container.

[API Reference](/api/unreleased/tasks/docker.html#prefect-tasks-docker-getcontainerlogs)

### ListContainers <Badge text="task"/>

Task for listing Docker containers.

[API Reference](/api/unreleased/tasks/docker.html#prefect-tasks-docker-listcontainers)

### StartContainer <Badge text="task"/>

Task for starting a Docker container which runs the (optional) command it was created with.

[API Reference](/api/unreleased/tasks/docker.html#prefect-tasks-docker-startcontainer)

### StopContainer <Badge text="task"/>

Task for stopping a Docker container.

[API Reference](/api/unreleased/tasks/docker.html#prefect-tasks-docker-stopcontainer)
