---
sidebarDepth: 2
editLink: false
---
# Notifications and Callback Tools
---
Tools and utilities for notifications and callbacks.

For an in-depth guide to setting up your system for using Slack notifications, [please see our tutorial](/guide/tutorials/slack-notifications.html).

## Functions
|top-level functions: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-utilities-notifications-callback-factory'><p class="prefect-class">prefect.utilities.notifications.callback_factory</p>(fn, check)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/notifications.py#L26">[source]</a></span></div>
<p class="methods">Utility for generating state handlers that serve as callbacks, under arbitrary state-based checks.<br><br>**Args**:     <ul class="args"><li class="args">`fn (Callable)`: a function with signature `fn(obj, state: State) -> None`         that will be called anytime the associated state-check passes; in general,         it is expected that this function will have side effects (e.g., sends an email).  The first         argument to this function is the `Task` or `Flow` it is attached to.     </li><li class="args">`check (Callable)`: a function with signature `check(state: State) -> bool`         that is used for determining when the callback function should be called</li></ul>**Returns**:     <ul class="args"><li class="args">`state_handler (Callable)`: a state handler function that can be attached to both Tasks and Flows</li></ul>**Example**:     <br><pre class="language-python"><code class="language-python">    <span class="token keyword">from</span> prefect <span class="token keyword">import</span> Task<span class="token punctuation">,</span> Flow<br>    <span class="token keyword">from</span> prefect.utilities.notifications <span class="token keyword">import</span> callback_factory<br><br>    fn <span class="token operator">=</span> <span class="token keyword">lambda</span> obj<span class="token punctuation">,</span> state<span class="token punctuation">:</span> <span class="token builtin">print</span><span class="token punctuation">(</span>state<span class="token punctuation">)</span><br>    check <span class="token operator">=</span> <span class="token keyword">lambda</span> state<span class="token punctuation">:</span> state<span class="token operator">.</span>is_successful<span class="token punctuation">(</span><span class="token punctuation">)</span><br>    callback <span class="token operator">=</span> callback_factory<span class="token punctuation">(</span>fn<span class="token punctuation">,</span> check<span class="token punctuation">)</span><br><br>    t <span class="token operator">=</span> Task<span class="token punctuation">(</span>state_handlers<span class="token operator">=</span><span class="token punctuation">[</span>callback<span class="token punctuation">]</span><span class="token punctuation">)</span><br>    f <span class="token operator">=</span> Flow<span class="token punctuation">(</span>tasks<span class="token operator">=</span><span class="token punctuation">[</span>t<span class="token punctuation">]</span><span class="token punctuation">,</span> state_handlers<span class="token operator">=</span><span class="token punctuation">[</span>callback<span class="token punctuation">]</span><span class="token punctuation">)</span><br>    f<span class="token operator">.</span>run<span class="token punctuation">(</span><span class="token punctuation">)</span><br>    <span class="token comment"># prints:</span><br>    <span class="token comment"># Success("Task run succeeded.")</span><br>    <span class="token comment"># Success("All reference tasks succeeded.")</span><br>    <br></code></pre><br></p>|
 | <div class='method-sig' id='prefect-utilities-notifications-slack-notifier'><p class="prefect-class">prefect.utilities.notifications.slack_notifier</p>(tracked_obj, old_state, new_state, ignore_states=None, only_states=None, webhook_secret=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/notifications.py#L223">[source]</a></span></div>
<p class="methods">Slack state change handler; requires having the Prefect slack app installed. Works as a standalone state handler, or can be called from within a custom state handler.  This function is curried meaning that it can be called multiple times to partially bind any keyword arguments (see example below).<br><br>**Args**:     <ul class="args"><li class="args">`tracked_obj (Task or Flow)`: Task or Flow object the handler is         registered with     </li><li class="args">`old_state (State)`: previous state of tracked object     </li><li class="args">`new_state (State)`: new state of tracked object     </li><li class="args">`ignore_states ([State], optional)`: list of `State` classes to ignore,         e.g., `[Running, Scheduled]`. If `new_state` is an instance of one of the passed states, no notification will occur.     </li><li class="args">`only_states ([State], optional)`: similar to `ignore_states`, but         instead _only_ notifies you if the Task / Flow is in a state from the provided list of `State` classes     </li><li class="args">`webhook_secret (str, optional)`: the name of the Prefect Secret that stores your slack webhook URL;         defaults to `"SLACK_WEBHOOK_URL"`</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the `new_state` object that was provided</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the slack notification fails for any reason</li></ul>**Example**:     <br><pre class="language-python"><code class="language-python">    <span class="token keyword">from</span> prefect <span class="token keyword">import</span> task<br>    <span class="token keyword">from</span> prefect.utilities.notifications <span class="token keyword">import</span> slack_notifier<br><br>    <span class="token decorator">@task</span><span class="token punctuation">(</span>state_handlers<span class="token operator">=</span><span class="token punctuation">[</span>slack_notifier<span class="token punctuation">(</span>ignore_states<span class="token operator">=</span><span class="token punctuation">[</span>Running<span class="token punctuation">]</span><span class="token punctuation">)</span><span class="token punctuation">]</span><span class="token punctuation">)</span> <span class="token comment"># uses currying</span><br>    <span class="token keyword">def</span> <span class="token function">add</span><span class="token punctuation">(</span>x<span class="token punctuation">,</span> y<span class="token punctuation">)</span><span class="token punctuation">:</span><br>        <span class="token keyword">return</span> x <span class="token operator">+</span> y<br>    <br></code></pre><br></p>|
 | <div class='method-sig' id='prefect-utilities-notifications-gmail-notifier'><p class="prefect-class">prefect.utilities.notifications.gmail_notifier</p>(tracked_obj, old_state, new_state, ignore_states=None, only_states=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/notifications.py#L155">[source]</a></span></div>
<p class="methods">Email state change handler - configured to work solely with Gmail; works as a standalone state handler, or can be called from within a custom state handler.  This function is curried meaning that it can be called multiple times to partially bind any keyword arguments (see example below).<br><br>The username and password Gmail credentials will be taken from your `"EMAIL_USERNAME"` and `"EMAIL_PASSWORD"` secrets, respectively; note the username will also serve as the destination email address for the notification.<br><br>**Args**:     <ul class="args"><li class="args">`tracked_obj (Task or Flow)`: Task or Flow object the handler is         registered with     </li><li class="args">`old_state (State)`: previous state of tracked object     </li><li class="args">`new_state (State)`: new state of tracked object     </li><li class="args">`ignore_states ([State], optional)`: list of `State` classes to ignore,         e.g., `[Running, Scheduled]`. If `new_state` is an instance of one of the passed states, no notification will occur.     </li><li class="args">`only_states ([State], optional)`: similar to `ignore_states`, but         instead _only_ notifies you if the Task / Flow is in a state from the provided list of `State` classes</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the `new_state` object that was provided</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the email notification fails for any reason</li></ul>**Example**:     <br><pre class="language-python"><code class="language-python">    <span class="token keyword">from</span> prefect <span class="token keyword">import</span> task<br>    <span class="token keyword">from</span> prefect.utilities.notifications <span class="token keyword">import</span> gmail_notifier<br><br>    <span class="token decorator">@task</span><span class="token punctuation">(</span>state_handlers<span class="token operator">=</span><span class="token punctuation">[</span>gmail_notifier<span class="token punctuation">(</span>ignore_states<span class="token operator">=</span><span class="token punctuation">[</span>Running<span class="token punctuation">]</span><span class="token punctuation">)</span><span class="token punctuation">]</span><span class="token punctuation">)</span> <span class="token comment"># uses currying</span><br>    <span class="token keyword">def</span> <span class="token function">add</span><span class="token punctuation">(</span>x<span class="token punctuation">,</span> y<span class="token punctuation">)</span><span class="token punctuation">:</span><br>        <span class="token keyword">return</span> x <span class="token operator">+</span> y<br>    <br></code></pre><br></p>|

<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on August 8, 2019 at 15:41 UTC</p>