---
sidebarDepth: 2
editLink: false
---
# Task Utilities
---
 ## unmapped
 <div class='class-sig' id='prefect-utilities-tasks-unmapped'><p class="prefect-sig">class </p><p class="prefect-class">prefect.utilities.tasks.unmapped</p>(task)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/tasks.py#L179">[source]</a></span></div>

A container for specifying that a task should _not_ be mapped over when called with `task.map`.

**Args**:     <ul class="args"><li class="args">`task (Task)`: the task to mark as "unmapped"; if not a Task subclass,         Prefect will attempt to convert it to one.</li></ul>**Example**:     
```python
    from prefect import Flow, Task, unmapped

    class AddTask(Task):
        def run(self, x, y):
            return x + y

    class ListTask(Task):
        def run(self):
            return [1, 2, 3]

    with Flow("My Flow"):
        add = AddTask()
        ll = ListTask()
        result = add.map(x=ll, y=unmapped(5), upstream_tasks=[unmapped(Task())])

```


---
<br>


## Functions
|top-level functions: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-utilities-tasks-tags'><p class="prefect-class">prefect.utilities.tasks.tags</p>(*tags)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/tasks.py#L19">[source]</a></span></div>
<p class="methods">Context manager for setting task tags.<br><br>**Args**:     <ul class="args"><li class="args">`*tags ([str])`: a list of tags to apply to the tasks created within         the context manager</li></ul>**Example**: <br><pre class="language-python"><code class="language-python"><span class="token decorator">@task</span><br><span class="token keyword">def</span> <span class="token function">add</span><span class="token punctuation">(</span>x<span class="token punctuation">,</span> y<span class="token punctuation">)</span><span class="token punctuation">:</span><br>    <span class="token keyword">return</span> x <span class="token operator">+</span> y<br><br><span class="token keyword">with</span> Flow<span class="token punctuation">(</span><span class="token string">"</span><span class="token string">My Flow</span><span class="token string">"</span><span class="token punctuation">)</span> <span class="token keyword">as</span> f<span class="token punctuation">:</span><br>    <span class="token keyword">with</span> tags<span class="token punctuation">(</span><span class="token string">"</span><span class="token string">math</span><span class="token string">"</span><span class="token punctuation">,</span> <span class="token string">"</span><span class="token string">function</span><span class="token string">"</span><span class="token punctuation">)</span><span class="token punctuation">:</span><br>        result <span class="token operator">=</span> add<span class="token punctuation">(</span><span class="token number">1</span><span class="token punctuation">,</span> <span class="token number">5</span><span class="token punctuation">)</span><br><br><span class="token builtin">print</span><span class="token punctuation">(</span>result<span class="token operator">.</span>tags<span class="token punctuation">)</span> <span class="token comment"># {"function", "math"}</span><br></code></pre><br></p>|
 | <div class='method-sig' id='prefect-utilities-tasks-as-task'><p class="prefect-class">prefect.utilities.tasks.as_task</p>(x, flow=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/tasks.py#L47">[source]</a></span></div>
<p class="methods">Wraps a function, collection, or constant with the appropriate Task type.<br><br>**Args**:     <ul class="args"><li class="args">`x (object)`: any Python object to convert to a prefect Task     </li><li class="args">`flow (Flow, optional)`: Flow to which the prefect Task will be bound</li></ul>**Returns**:     <ul class="args"><li class="args">a prefect Task representing the passed object</li></ul></p>|
 | <div class='method-sig' id='prefect-utilities-tasks-pause-task'><p class="prefect-class">prefect.utilities.tasks.pause_task</p>(message=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/tasks.py#L88">[source]</a></span></div>
<p class="methods">Utility function for pausing a task during execution to wait for manual intervention. Note that the _entire task_ will be rerun if the user decides to run this task again! The only difference is that this utility will simply _not_ raise a `PAUSE` signal. To bypass a `PAUSE` signal being raised, simply put the task into a Resume state.<br><br>**Args**:     <ul class="args"><li class="args">`message (str)`: an optional message for the Pause state.</li></ul>**Example**:     <br><pre class="language-python"><code class="language-python">    <span class="token keyword">from</span> prefect <span class="token keyword">import</span> Flow<br>    <span class="token keyword">from</span> prefect.utilities.tasks <span class="token keyword">import</span> task<span class="token punctuation">,</span> pause_task<br><br>    <span class="token decorator">@task</span><br>    <span class="token keyword">def</span> <span class="token function">add</span><span class="token punctuation">(</span>x<span class="token punctuation">,</span> y<span class="token punctuation">)</span><span class="token punctuation">:</span><br>        z <span class="token operator">=</span> y <span class="token operator">-</span> x  <span class="token comment">## this code will be rerun after resuming from the pause!</span><br>        <span class="token keyword">if</span> z <span class="token operator">==</span> <span class="token number">0</span><span class="token punctuation">:</span> <span class="token comment">## this code will be rerun after resuming from the pause!</span><br>            pause_task<span class="token punctuation">(</span><span class="token punctuation">)</span><br>        <span class="token keyword">return</span> x <span class="token operator">+</span> y<br><br>    <span class="token keyword">with</span> Flow<span class="token punctuation">(</span><span class="token string">"</span><span class="token string">My Flow</span><span class="token string">"</span><span class="token punctuation">)</span> <span class="token keyword">as</span> f<span class="token punctuation">:</span><br>        res <span class="token operator">=</span> add<span class="token punctuation">(</span><span class="token number">4</span><span class="token punctuation">,</span> <span class="token number">4</span><span class="token punctuation">)</span><br><br>    state <span class="token operator">=</span> f<span class="token operator">.</span>run<span class="token punctuation">(</span><span class="token punctuation">)</span><br>    state<span class="token operator">.</span>result<span class="token punctuation">[</span>res<span class="token punctuation">]</span> <span class="token comment"># a Paused state</span><br><br>    state <span class="token operator">=</span> f<span class="token operator">.</span>run<span class="token punctuation">(</span>task_states<span class="token operator">=</span><span class="token punctuation">{</span>res<span class="token punctuation">:</span> Resume<span class="token punctuation">(</span><span class="token punctuation">)</span><span class="token punctuation">}</span><span class="token punctuation">)</span><br>    state<span class="token operator">.</span>result<span class="token punctuation">[</span>res<span class="token punctuation">]</span> <span class="token comment"># a Success state</span><br>    <br></code></pre><br></p>|
 | <div class='method-sig' id='prefect-utilities-tasks-task'><p class="prefect-class">prefect.utilities.tasks.task</p>(fn, **task_init_kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/tasks.py#L126">[source]</a></span></div>
<p class="methods">A decorator for creating Tasks from functions.<br><br>**Args**:     <ul class="args"><li class="args">`fn (Callable)`: the decorated function     </li><li class="args">`**task_init_kwargs (Any)`: keyword arguments that will be passed to the `Task`         constructor on initialization.</li></ul>**Returns**:     <ul class="args"><li class="args">`FunctionTask`: A instance of a FunctionTask</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the provided function violates signature requirements         for Task run methods</li></ul>Usage:<br><br><br><pre class="language-python"><code class="language-python"><span class="token decorator">@task</span><span class="token punctuation">(</span>name<span class="token operator">=</span><span class="token string">'</span><span class="token string">hello</span><span class="token string">'</span><span class="token punctuation">,</span> retries<span class="token operator">=</span><span class="token number">3</span><span class="token punctuation">)</span><br><span class="token keyword">def</span> <span class="token function">hello</span><span class="token punctuation">(</span>name<span class="token punctuation">)</span><span class="token punctuation">:</span><br>    <span class="token builtin">print</span><span class="token punctuation">(</span><span class="token string">'</span><span class="token string">hello, </span><span class="token string">{}</span><span class="token string">'</span><span class="token operator">.</span>format<span class="token punctuation">(</span>name<span class="token punctuation">)</span><span class="token punctuation">)</span><br><br><span class="token keyword">with</span> Flow<span class="token punctuation">(</span><span class="token string">"</span><span class="token string">My Flow</span><span class="token string">"</span><span class="token punctuation">)</span> <span class="token keyword">as</span> flow<span class="token punctuation">:</span><br>    t1 <span class="token operator">=</span> hello<span class="token punctuation">(</span><span class="token string">'</span><span class="token string">foo</span><span class="token string">'</span><span class="token punctuation">)</span><br>    t2 <span class="token operator">=</span> hello<span class="token punctuation">(</span><span class="token string">'</span><span class="token string">bar</span><span class="token string">'</span><span class="token punctuation">)</span><br></code></pre><br><br><br>The decorator is best suited to Prefect's functional API, but can also be used with the imperative API.<br><br><br><pre class="language-python"><code class="language-python"><span class="token decorator">@task</span><br><span class="token keyword">def</span> <span class="token function">fn_without_args</span><span class="token punctuation">(</span><span class="token punctuation">)</span><span class="token punctuation">:</span><br>    <span class="token keyword">return</span> <span class="token number">1</span><br><br><span class="token decorator">@task</span><br><span class="token keyword">def</span> <span class="token function">fn_with_args</span><span class="token punctuation">(</span>x<span class="token punctuation">)</span><span class="token punctuation">:</span><br>    <span class="token keyword">return</span> x<br><br><span class="token comment"># both tasks work inside a functional flow context</span><br><span class="token keyword">with</span> Flow<span class="token punctuation">(</span><span class="token string">"</span><span class="token string">My Flow</span><span class="token string">"</span><span class="token punctuation">)</span><span class="token punctuation">:</span><br>    fn_without_args<span class="token punctuation">(</span><span class="token punctuation">)</span><br>    fn_with_args<span class="token punctuation">(</span><span class="token number">1</span><span class="token punctuation">)</span><br></code></pre><br></p>|
 | <div class='method-sig' id='prefect-utilities-tasks-defaults-from-attrs'><p class="prefect-class">prefect.utilities.tasks.defaults_from_attrs</p>(*attr_args)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/tasks.py#L211">[source]</a></span></div>
<p class="methods">Helper decorator for dealing with Task classes with attributes that serve as defaults for `Task.run`.  Specifically, this decorator allows the author of a Task to identify certain keyword arguments to the run method which will fall back to `self.ATTR_NAME` if not explicitly provided to `self.run`.  This pattern allows users to create a Task "template", whose default settings can be created at initialization but overrided in individual instances when the Task is called.<br><br>**Args**:     <ul class="args"><li class="args">`*attr_args (str)`: a splatted list of strings specifying which         kwargs should fallback to attributes, if not provided at runtime. Note that         the strings provided here must match keyword arguments in the `run` call signature,         as well as the names of attributes of this Task.</li></ul>**Returns**:     <ul class="args"><li class="args">`Callable`: the decorated / altered `Task.run` method</li></ul>**Example**: <br><pre class="language-python"><code class="language-python"><span class="token keyword">class</span> <span class="token class-name">MyTask</span><span class="token punctuation">(</span>Task<span class="token punctuation">)</span><span class="token punctuation">:</span><br>    <span class="token keyword">def</span> <span class="token function">__init__</span><span class="token punctuation">(</span><span class="token builtin">self</span><span class="token punctuation">,</span> a<span class="token operator">=</span><span class="token keyword">None</span><span class="token punctuation">,</span> b<span class="token operator">=</span><span class="token keyword">None</span><span class="token punctuation">)</span><span class="token punctuation">:</span><br>        <span class="token builtin">self</span><span class="token operator">.</span>a <span class="token operator">=</span> a<br>        <span class="token builtin">self</span><span class="token operator">.</span>b <span class="token operator">=</span> b<br><br>    <span class="token decorator">@defaults_from_attrs</span><span class="token punctuation">(</span><span class="token string">'</span><span class="token string">a</span><span class="token string">'</span><span class="token punctuation">,</span> <span class="token string">'</span><span class="token string">b</span><span class="token string">'</span><span class="token punctuation">)</span><br>    <span class="token keyword">def</span> <span class="token function">run</span><span class="token punctuation">(</span><span class="token builtin">self</span><span class="token punctuation">,</span> a<span class="token operator">=</span><span class="token keyword">None</span><span class="token punctuation">,</span> b<span class="token operator">=</span><span class="token keyword">None</span><span class="token punctuation">)</span><span class="token punctuation">:</span><br>        <span class="token keyword">return</span> a<span class="token punctuation">,</span> b<br><br>task <span class="token operator">=</span> MyTask<span class="token punctuation">(</span>a<span class="token operator">=</span><span class="token number">1</span><span class="token punctuation">,</span> b<span class="token operator">=</span><span class="token number">2</span><span class="token punctuation">)</span><br><br>task<span class="token operator">.</span>run<span class="token punctuation">(</span><span class="token punctuation">)</span> <span class="token comment"># (1, 2)</span><br>task<span class="token operator">.</span>run<span class="token punctuation">(</span>a<span class="token operator">=</span><span class="token number">99</span><span class="token punctuation">)</span> <span class="token comment"># (99, 2)</span><br>task<span class="token operator">.</span>run<span class="token punctuation">(</span>a<span class="token operator">=</span><span class="token keyword">None</span><span class="token punctuation">,</span> b<span class="token operator">=</span><span class="token keyword">None</span><span class="token punctuation">)</span> <span class="token comment"># (None, None)</span><br></code></pre><br></p>|

<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on July 16, 2019 at 04:54 UTC</p>