---
sidebarDepth: 2
editLink: false
---
# Kubernetes Tasks
---
Tasks for interacting with various Kubernetes API objects.

Note that depending on how you choose to authenticate, tasks in this collection might require
a Prefect Secret called `"KUBERNETES_API_KEY"` that stores your Kubernetes API Key;
this Secret must be a string and in BearerToken format.
 ## CreateNamespacedDeployment
 <div class='class-sig' id='prefect-tasks-kubernetes-deployment-createnamespaceddeployment'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.deployment.CreateNamespacedDeployment</p>(body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L10">[source]</a></span></div>

Task for creating a namespaced deployment on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes         ExtensionsV1beta1Deployment specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to create this deployment in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-deployment-createnamespaceddeployment-run'><p class="prefect-class">prefect.tasks.kubernetes.deployment.CreateNamespacedDeployment.run</p>(body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L58">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes         ExtensionsV1beta1Deployment specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to create this deployment in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`</li></ul></p>|

---
<br>

 ## DeleteNamespacedDeployment
 <div class='class-sig' id='prefect-tasks-kubernetes-deployment-deletenamespaceddeployment'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.deployment.DeleteNamespacedDeployment</p>(deployment_name=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L112">[source]</a></span></div>

Task for deleting a namespaced deployment on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`deployment_name (str, optional)`: The name of a deployment to delete     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to delete this deployment from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-deployment-deletenamespaceddeployment-run'><p class="prefect-class">prefect.tasks.kubernetes.deployment.DeleteNamespacedDeployment.run</p>(deployment_name=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L159">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`deployment_name (str, optional)`: The name of a deployment to delete     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to delete this deployment in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `deployment_name` is `None`</li></ul></p>|

---
<br>

 ## ListNamespacedDeployment
 <div class='class-sig' id='prefect-tasks-kubernetes-deployment-listnamespaceddeployment'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.deployment.ListNamespacedDeployment</p>(namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L212">[source]</a></span></div>

Task for listing namespaced deployments on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`namespace (str, optional)`: The Kubernetes namespace to list deployments from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"field_selector": "...", "label_selector": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-deployment-listnamespaceddeployment-run'><p class="prefect-class">prefect.tasks.kubernetes.deployment.ListNamespacedDeployment.run</p>(namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L256">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`namespace (str, optional)`: The Kubernetes namespace to list deployments from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"field_selector": "...", "label_selector": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Returns**:     <ul class="args"><li class="args">`ExtensionsV1beta1DeploymentList`: a Kubernetes ExtensionsV1beta1DeploymentList         of the deployments which are found</li></ul></p>|

---
<br>

 ## PatchNamespacedDeployment
 <div class='class-sig' id='prefect-tasks-kubernetes-deployment-patchnamespaceddeployment'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.deployment.PatchNamespacedDeployment</p>(deployment_name=None, body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L298">[source]</a></span></div>

Task for patching a namespaced deployment on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`deployment_name (str, optional)`: The name of a deployment to patch     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes         ExtensionsV1beta1Deployment patch specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this deployment in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-deployment-patchnamespaceddeployment-run'><p class="prefect-class">prefect.tasks.kubernetes.deployment.PatchNamespacedDeployment.run</p>(deployment_name=None, body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L349">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`deployment_name (str, optional)`: The name of a deployment to patch     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes         ExtensionsV1beta1Deployment patch specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this deployment in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`     </li><li class="args">`ValueError`: if `deployment_name` is `None`</li></ul></p>|

---
<br>

 ## ReadNamespacedDeployment
 <div class='class-sig' id='prefect-tasks-kubernetes-deployment-readnamespaceddeployment'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.deployment.ReadNamespacedDeployment</p>(deployment_name=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L413">[source]</a></span></div>

Task for reading a namespaced deployment on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`deployment_name (str, optional)`: The name of a deployment to read     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to read this deployment from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "exact": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-deployment-readnamespaceddeployment-run'><p class="prefect-class">prefect.tasks.kubernetes.deployment.ReadNamespacedDeployment.run</p>(deployment_name=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L460">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`deployment_name (str, optional)`: The name of a deployment to read     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to read this deployment in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "exact": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Returns**:     <ul class="args"><li class="args">`ExtensionsV1beta1Deployment`: a Kubernetes ExtensionsV1beta1Deployment         matching the deployment that was found</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `deployment_name` is `None`</li></ul></p>|

---
<br>

 ## ReplaceNamespacedDeployment
 <div class='class-sig' id='prefect-tasks-kubernetes-deployment-replacenamespaceddeployment'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.deployment.ReplaceNamespacedDeployment</p>(deployment_name=None, body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L514">[source]</a></span></div>

Task for replacing a namespaced deployment on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`deployment_name (str, optional)`: The name of a deployment to replace     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes         ExtensionsV1beta1Deployment specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this deployment in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-deployment-replacenamespaceddeployment-run'><p class="prefect-class">prefect.tasks.kubernetes.deployment.ReplaceNamespacedDeployment.run</p>(deployment_name=None, body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/deployment.py#L565">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`deployment_name (str, optional)`: The name of a deployment to replace     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes         ExtensionsV1beta1Deployment specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this deployment in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`     </li><li class="args">`ValueError`: if `deployment_name` is `None`</li></ul></p>|

---
<br>

 ## CreateNamespacedJob
 <div class='class-sig' id='prefect-tasks-kubernetes-job-createnamespacedjob'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.job.CreateNamespacedJob</p>(body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L10">[source]</a></span></div>

Task for creating a namespaced job on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Job         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to create this job in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-job-createnamespacedjob-run'><p class="prefect-class">prefect.tasks.kubernetes.job.CreateNamespacedJob.run</p>(body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L58">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Job         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to create this job in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`</li></ul></p>|

---
<br>

 ## DeleteNamespacedJob
 <div class='class-sig' id='prefect-tasks-kubernetes-job-deletenamespacedjob'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.job.DeleteNamespacedJob</p>(job_name=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L108">[source]</a></span></div>

Task for deleting a namespaced job on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`job_name (str, optional)`: The name of a job to delete     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to delete this job from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-job-deletenamespacedjob-run'><p class="prefect-class">prefect.tasks.kubernetes.job.DeleteNamespacedJob.run</p>(job_name=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L155">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`job_name (str, optional)`: The name of a job to delete     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to delete this job in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `job_name` is `None`</li></ul></p>|

---
<br>

 ## ListNamespacedJob
 <div class='class-sig' id='prefect-tasks-kubernetes-job-listnamespacedjob'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.job.ListNamespacedJob</p>(namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L208">[source]</a></span></div>

Task for listing namespaced jobs on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`namespace (str, optional)`: The Kubernetes namespace to list jobs from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"field_selector": "...", "label_selector": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-job-listnamespacedjob-run'><p class="prefect-class">prefect.tasks.kubernetes.job.ListNamespacedJob.run</p>(namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L252">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`namespace (str, optional)`: The Kubernetes namespace to list jobs from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"field_selector": "...", "label_selector": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Returns**:     <ul class="args"><li class="args">`V1JobList`: a Kubernetes V1JobList of the jobs which are found</li></ul></p>|

---
<br>

 ## PatchNamespacedJob
 <div class='class-sig' id='prefect-tasks-kubernetes-job-patchnamespacedjob'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.job.PatchNamespacedJob</p>(job_name=None, body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L293">[source]</a></span></div>

Task for patching a namespaced job on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`job_name (str, optional)`: The name of a job to patch     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Job         patch specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this job in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-job-patchnamespacedjob-run'><p class="prefect-class">prefect.tasks.kubernetes.job.PatchNamespacedJob.run</p>(job_name=None, body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L344">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`job_name (str, optional)`: The name of a job to patch     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Job         patch specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this job in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`     </li><li class="args">`ValueError`: if `job_name` is `None`</li></ul></p>|

---
<br>

 ## ReadNamespacedJob
 <div class='class-sig' id='prefect-tasks-kubernetes-job-readnamespacedjob'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.job.ReadNamespacedJob</p>(job_name=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L404">[source]</a></span></div>

Task for reading a namespaced job on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`job_name (str, optional)`: The name of a job to read     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to read this job from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "exact": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-job-readnamespacedjob-run'><p class="prefect-class">prefect.tasks.kubernetes.job.ReadNamespacedJob.run</p>(job_name=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L451">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`job_name (str, optional)`: The name of a job to read     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to read this job in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "exact": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Returns**:     <ul class="args"><li class="args">`V1Job`: a Kubernetes V1Job matching the job that was found</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `job_name` is `None`</li></ul></p>|

---
<br>

 ## ReplaceNamespacedJob
 <div class='class-sig' id='prefect-tasks-kubernetes-job-replacenamespacedjob'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.job.ReplaceNamespacedJob</p>(job_name=None, body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L504">[source]</a></span></div>

Task for replacing a namespaced job on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`job_name (str, optional)`: The name of a job to replace     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Job         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this job in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-job-replacenamespacedjob-run'><p class="prefect-class">prefect.tasks.kubernetes.job.ReplaceNamespacedJob.run</p>(job_name=None, body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/job.py#L555">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`job_name (str, optional)`: The name of a job to replace     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Job         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this job in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`     </li><li class="args">`ValueError`: if `job_name` is `None`</li></ul></p>|

---
<br>

 ## CreateNamespacedPod
 <div class='class-sig' id='prefect-tasks-kubernetes-pod-createnamespacedpod'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.pod.CreateNamespacedPod</p>(body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L10">[source]</a></span></div>

Task for creating a namespaced pod on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Pod         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to create this pod in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-pod-createnamespacedpod-run'><p class="prefect-class">prefect.tasks.kubernetes.pod.CreateNamespacedPod.run</p>(body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L58">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Pod         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to create this pod in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`</li></ul></p>|

---
<br>

 ## DeleteNamespacedPod
 <div class='class-sig' id='prefect-tasks-kubernetes-pod-deletenamespacedpod'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.pod.DeleteNamespacedPod</p>(pod_name=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L108">[source]</a></span></div>

Task for deleting a namespaced pod on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod to delete     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to delete this pod from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-pod-deletenamespacedpod-run'><p class="prefect-class">prefect.tasks.kubernetes.pod.DeleteNamespacedPod.run</p>(pod_name=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L155">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod to delete     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to delete this pod in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `pod_name` is `None`</li></ul></p>|

---
<br>

 ## ListNamespacedPod
 <div class='class-sig' id='prefect-tasks-kubernetes-pod-listnamespacedpod'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.pod.ListNamespacedPod</p>(namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L208">[source]</a></span></div>

Task for listing namespaced pods on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`namespace (str, optional)`: The Kubernetes namespace to list pods from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"field_selector": "...", "label_selector": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-pod-listnamespacedpod-run'><p class="prefect-class">prefect.tasks.kubernetes.pod.ListNamespacedPod.run</p>(namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L252">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`namespace (str, optional)`: The Kubernetes namespace to list pods from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"field_selector": "...", "label_selector": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Returns**:     <ul class="args"><li class="args">`V1PodList`: a Kubernetes V1PodList of the pods which are found</li></ul></p>|

---
<br>

 ## PatchNamespacedPod
 <div class='class-sig' id='prefect-tasks-kubernetes-pod-patchnamespacedpod'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.pod.PatchNamespacedPod</p>(pod_name=None, body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L293">[source]</a></span></div>

Task for patching a namespaced pod on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod to patch     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Pod         patch specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this pod in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-pod-patchnamespacedpod-run'><p class="prefect-class">prefect.tasks.kubernetes.pod.PatchNamespacedPod.run</p>(pod_name=None, body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L344">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod to patch     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Pod         patch specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this pod in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`     </li><li class="args">`ValueError`: if `pod_name` is `None`</li></ul></p>|

---
<br>

 ## ReadNamespacedPod
 <div class='class-sig' id='prefect-tasks-kubernetes-pod-readnamespacedpod'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.pod.ReadNamespacedPod</p>(pod_name=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L404">[source]</a></span></div>

Task for reading a namespaced pod on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod to read     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to read this pod from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "exact": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-pod-readnamespacedpod-run'><p class="prefect-class">prefect.tasks.kubernetes.pod.ReadNamespacedPod.run</p>(pod_name=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L451">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod to read     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to read this pod in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "exact": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Returns**:     <ul class="args"><li class="args">`V1Pod`: a Kubernetes V1Pod matching the pod that was found</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `pod_name` is `None`</li></ul></p>|

---
<br>

 ## ReplaceNamespacedPod
 <div class='class-sig' id='prefect-tasks-kubernetes-pod-replacenamespacedpod'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.pod.ReplaceNamespacedPod</p>(pod_name=None, body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L504">[source]</a></span></div>

Task for replacing a namespaced pod on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Pod in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod to replace     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Pod         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this pod in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-pod-replacenamespacedpod-run'><p class="prefect-class">prefect.tasks.kubernetes.pod.ReplaceNamespacedPod.run</p>(pod_name=None, body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/pod.py#L555">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`pod_name (str, optional)`: The name of a pod to replace     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Pod         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this pod in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`     </li><li class="args">`ValueError`: if `pod_name` is `None`</li></ul></p>|

---
<br>

 ## CreateNamespacedService
 <div class='class-sig' id='prefect-tasks-kubernetes-service-createnamespacedservice'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.service.CreateNamespacedService</p>(body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L10">[source]</a></span></div>

Task for creating a namespaced service on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Service in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Service         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to create this service in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-service-createnamespacedservice-run'><p class="prefect-class">prefect.tasks.kubernetes.service.CreateNamespacedService.run</p>(body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L58">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Service         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to create this service in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`</li></ul></p>|

---
<br>

 ## DeleteNamespacedService
 <div class='class-sig' id='prefect-tasks-kubernetes-service-deletenamespacedservice'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.service.DeleteNamespacedService</p>(service_name=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L110">[source]</a></span></div>

Task for deleting a namespaced service on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Service in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`service_name (str, optional)`: The name of a service to delete     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to delete this service from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-service-deletenamespacedservice-run'><p class="prefect-class">prefect.tasks.kubernetes.service.DeleteNamespacedService.run</p>(service_name=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L157">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`service_name (str, optional)`: The name of a service to delete     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to delete this service in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `service_name` is `None`</li></ul></p>|

---
<br>

 ## ListNamespacedService
 <div class='class-sig' id='prefect-tasks-kubernetes-service-listnamespacedservice'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.service.ListNamespacedService</p>(namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L210">[source]</a></span></div>

Task for listing namespaced services on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Service in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`namespace (str, optional)`: The Kubernetes namespace to list services from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"field_selector": "...", "label_selector": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-service-listnamespacedservice-run'><p class="prefect-class">prefect.tasks.kubernetes.service.ListNamespacedService.run</p>(namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L254">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`namespace (str, optional)`: The Kubernetes namespace to list services from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"field_selector": "...", "label_selector": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Returns**:     <ul class="args"><li class="args">`V1ServiceList`: a Kubernetes V1ServiceList of the services which are found</li></ul></p>|

---
<br>

 ## PatchNamespacedService
 <div class='class-sig' id='prefect-tasks-kubernetes-service-patchnamespacedservice'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.service.PatchNamespacedService</p>(service_name=None, body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L295">[source]</a></span></div>

Task for patching a namespaced service on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Service in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`service_name (str, optional)`: The name of a service to patch     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Service         patch specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this service in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-service-patchnamespacedservice-run'><p class="prefect-class">prefect.tasks.kubernetes.service.PatchNamespacedService.run</p>(service_name=None, body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L346">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`service_name (str, optional)`: The name of a service to patch     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Service         patch specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this service in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`     </li><li class="args">`ValueError`: if `service_name` is `None`</li></ul></p>|

---
<br>

 ## ReadNamespacedService
 <div class='class-sig' id='prefect-tasks-kubernetes-service-readnamespacedservice'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.service.ReadNamespacedService</p>(service_name=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L406">[source]</a></span></div>

Task for reading a namespaced service on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Service in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The argument `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `kube_kwargs = {"info": "here"}` at instantiation and then provide `kube_kwargs = {"more": "info"}` at run time which will make `kube_kwargs = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`service_name (str, optional)`: The name of a service to read     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to read this service from,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "exact": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-service-readnamespacedservice-run'><p class="prefect-class">prefect.tasks.kubernetes.service.ReadNamespacedService.run</p>(service_name=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L453">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`service_name (str, optional)`: The name of a service to read     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to read this service in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "exact": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Returns**:     <ul class="args"><li class="args">`V1Service`: a Kubernetes V1Service matching the service that was found</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `service_name` is `None`</li></ul></p>|

---
<br>

 ## ReplaceNamespacedService
 <div class='class-sig' id='prefect-tasks-kubernetes-service-replacenamespacedservice'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.kubernetes.service.ReplaceNamespacedService</p>(service_name=None, body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L506">[source]</a></span></div>

Task for replacing a namespaced service on Kubernetes. Note that all initialization arguments can optionally be provided or overwritten at runtime.

This task will attempt to connect to a Kubernetes cluster in three steps with the first successful connection attempt becoming the mode of communication with a cluster.

1. Attempt to use a Prefect Secret that contains a Kubernetes API Key 2. Attempt in-cluster connection (will only work when running on a Service in a cluster) 3. Attempt out-of-cluster connection using the default location for a kube config file

The arguments `body` and `kube_kwargs` will perform an in-place update when the task is run. This means that it is possible to provide `body = {"info": "here"}` at instantiation and then provide `body = {"more": "info"}` at run time which will make `body = {"info": "here", "more": "info"}`. *Note*: Keys present in both instantiation and runtime will be replaced with the runtime value.

**Args**:     <ul class="args"><li class="args">`service_name (str, optional)`: The name of a service to replace     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Service         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this service in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-kubernetes-service-replacenamespacedservice-run'><p class="prefect-class">prefect.tasks.kubernetes.service.ReplaceNamespacedService.run</p>(service_name=None, body=None, namespace="default", kube_kwargs=None, kubernetes_api_key_secret="KUBERNETES_API_KEY")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/kubernetes/service.py#L557">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`service_name (str, optional)`: The name of a service to replace     </li><li class="args">`body (dict, optional)`: A dictionary representation of a Kubernetes V1Service         specification     </li><li class="args">`namespace (str, optional)`: The Kubernetes namespace to patch this service in,         defaults to the `default` namespace     </li><li class="args">`kube_kwargs (dict, optional)`: Optional extra keyword arguments to pass to the         Kubernetes API (e.g. `{"pretty": "...", "dry_run": "..."}`)     </li><li class="args">`kubernetes_api_key_secret (str, optional)`: the name of the Prefect Secret         which stored your Kubernetes API Key; this Secret must be a string and in         BearerToken format</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `body` is `None`     </li><li class="args">`ValueError`: if `service_name` is `None`</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on July 16, 2019 at 04:54 UTC</p>