---
sidebarDepth: 2
editLink: false
---
# AWS Tasks
---
This module contains a collection of tasks for interacting with AWS resources.

Note that all tasks require a Prefect Secret called `"AWS_CREDENTIALS"` that should be a JSON
document with two keys: `"ACCESS_KEY"` and `"SECRET_ACCESS_KEY"`.
 ## S3Download
 <div class='class-sig' id='prefect-tasks-aws-s3-s3download'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.aws.s3.S3Download</p>(aws_credentials_secret="AWS_CREDENTIALS", bucket=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/s3.py#L11">[source]</a></span></div>

Task for downloading data from an S3 bucket and returning it as a string. Note that all initialization arguments can optionally be provided or overwritten at runtime.

**Args**:     <ul class="args"><li class="args">`aws_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your AWS credentials; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY`     </li><li class="args">`bucket (str, optional)`: the name of the S3 Bucket to download from     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-aws-s3-s3download-run'><p class="prefect-class">prefect.tasks.aws.s3.S3Download.run</p>(key, aws_credentials_secret="AWS_CREDENTIALS", bucket=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/s3.py#L35">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`key (str)`: the name of the Key within this bucket to retrieve     </li><li class="args">`aws_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your AWS credentials; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY`     </li><li class="args">`bucket (str, optional)`: the name of the S3 Bucket to download from</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the contents of this Key / Bucket, as a string</li></ul></p>|

---
<br>

 ## S3Upload
 <div class='class-sig' id='prefect-tasks-aws-s3-s3upload'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.aws.s3.S3Upload</p>(aws_credentials_secret="AWS_CREDENTIALS", bucket=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/s3.py#L79">[source]</a></span></div>

Task for uploading string data (e.g., a JSON string) to an S3 bucket. Note that all initialization arguments can optionally be provided or overwritten at runtime.

**Args**:     <ul class="args"><li class="args">`aws_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your AWS credentials; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY`     </li><li class="args">`bucket (str, optional)`: the name of the S3 Bucket to upload to     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-aws-s3-s3upload-run'><p class="prefect-class">prefect.tasks.aws.s3.S3Upload.run</p>(data, key=None, aws_credentials_secret="AWS_CREDENTIALS", bucket=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/s3.py#L103">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`data (str)`: the data payload to upload     </li><li class="args">`key (str, optional)`: the Key to upload the data under; if not         provided, a random `uuid` will be created     </li><li class="args">`aws_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your AWS credentials; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY`     </li><li class="args">`bucket (str, optional)`: the name of the S3 Bucket to upload to</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the name of the Key the data payload was uploaded to</li></ul></p>|

---
<br>

 ## LambdaCreate
 <div class='class-sig' id='prefect-tasks-aws-lambda-function-lambdacreate'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.aws.lambda_function.LambdaCreate</p>(function_name, runtime, role, handler, zip_file=None, bucket="", bucket_key="", object_version=None, description="", function_timeout=3, memorysize=128, publish=True, subnet_ids=None, security_group_ids=None, dead_letter_config=None, environment_variables=None, kms_key_arn="", function_tags=None, tracing_config="PassThrough", layers=None, aws_credentials_secret="AWS_CREDENTIALS", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/lambda_function.py#L11">[source]</a></span></div>

Task for creating a Lambda function.

**Args**:     <ul class="args"><li class="args">`function_name (str)`: name of the Lambda function to create     </li><li class="args">`runtime (str)`: the identifier of the function's runtime     </li><li class="args">`role (str)`: the Amazon Resource Name of the function's execution role     </li><li class="args">`handler (str)`: the name of the method within your code that Lambda calls         to execute your function     </li><li class="args">`zip_file (str)`: path to zip file containing code for Lambda function,         either zip_file or (bucket and bucket_key) must be passed     </li><li class="args">`bucket (str)`: an S3 bucket in the same AWS region as your function     </li><li class="args">`bucket_key (str)`: the Amazon S3 key of the deployment package     </li><li class="args">`object_version (str, optional)`: for versioned S3 objects, the version of the         deployment package to use     </li><li class="args">`description (str, optional)`: description of Lambda function     </li><li class="args">`function_timeout (int, optional)`: Lambda function timeout in seconds, default is 3 seconds     </li><li class="args">`memorysize (int, optional)`: amount of memory that Lambda function has         access to in MB, must be a multiple of 64 MB, default is 128     </li><li class="args">`publish (bool, optional)`: set to True to publish the first version of the         function during creation, defaults to True     </li><li class="args">`subnet_ids (List[str], optional)`: list of subnet ids for vpc         configuration     </li><li class="args">`security_group_ids (List[str], optional)`: list of security         group ideas for vpc configuration     </li><li class="args">`dead_letter_config (dict, optional)`: a dead letter queue configuration that         specifies the queue or topic where Lambda sends asynchronous events         when they fail processing     </li><li class="args">`environment_variables (dict, optional)`: key-value pairs of environment         variables to pass to the Lambda function     </li><li class="args">`kms_key_arn (str, optional)`: the ARN of the AWS key management service used         to encrypt your function's environment variables, if not provided, AWS         Lambda uses a default service key     </li><li class="args">`function_tags (dict, optional)`: a list of tags to apply to the function, string         to string map     </li><li class="args">`tracing_config (str, optional)`: set to Active to samle and trace a         subset of incoming requests with Amazon X-Ray     </li><li class="args">`layers (List[str], optional)`: a list of function layers to add to         the function's execution environment, specify each layer by its ARN     </li><li class="args">`aws_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your AWS credentials; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY`     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-aws-lambda-function-lambdacreate-run'><p class="prefect-class">prefect.tasks.aws.lambda_function.LambdaCreate.run</p>(aws_credentials_secret="AWS_CREDENTIALS")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/lambda_function.py#L117">[source]</a></span></div>
<p class="methods">Task run method. Creates Lambda function.<br><br>**Args**:     <ul class="args"><li class="args">`aws_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your AWS credentials; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY`</li></ul>**Returns**:     <ul class="args"><li class="args">`json`: response from AWS CreateFunction endpoint</li></ul></p>|

---
<br>

 ## LambdaDelete
 <div class='class-sig' id='prefect-tasks-aws-lambda-function-lambdadelete'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.aws.lambda_function.LambdaDelete</p>(function_name, qualifier="", aws_credentials_secret="AWS_CREDENTIALS", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/lambda_function.py#L164">[source]</a></span></div>

Task for deleting a Lambda function.

**Args**:     <ul class="args"><li class="args">`function_name (str)`: name of teh Lambda function to delete     </li><li class="args">`qualifier (str, optional)`: specify a version to delete, if not         provided, the function will be deleted entirely     </li><li class="args">`aws_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your AWS credentials; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY`     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-aws-lambda-function-lambdadelete-run'><p class="prefect-class">prefect.tasks.aws.lambda_function.LambdaDelete.run</p>(aws_credentials_secret="AWS_CREDENTIALS")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/lambda_function.py#L191">[source]</a></span></div>
<p class="methods">Task run method. Deletes Lambda function.<br><br>**Args**:     <ul class="args"><li class="args">`aws_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your AWS credentials; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY`</li></ul>**Returns**:     <ul class="args"><li class="args">`dict`: response from AWS DeleteFunction endpoint</li></ul></p>|

---
<br>

 ## LambdaInvoke
 <div class='class-sig' id='prefect-tasks-aws-lambda-function-lambdainvoke'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.aws.lambda_function.LambdaInvoke</p>(function_name, invocation_type="RequestResponse", log_type="None", client_context=None, payload="null", qualifier="$LATEST", aws_credentials_secret="AWS_CREDENTIALS", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/lambda_function.py#L226">[source]</a></span></div>

Task to invoke a Lambda function.

**Args**:     <ul class="args"><li class="args">`function_name (str)`: the name of the Lambda funciton to invoke     </li><li class="args">`invocation_type (str, optional)`: the invocation type of Lambda         function, default is RequestResponse other options include         Event and DryRun     </li><li class="args">`log_type (str, optional)`: set to 'Tail' to include the execution         log in the response     </li><li class="args">`client_context (dict, optional)`: data to pass to the function in the         context object, dict object will be transformed into base64 encoded         json automatically     </li><li class="args">`payload (bytes or seekable file-like object)`: the JSON provided to         Lambda function as input     </li><li class="args">`qualifier (str, optional)`: specify a version or alias to invoke a         published version of the function, defaults to $LATEST     </li><li class="args">`aws_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your AWS credentials; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY`     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-aws-lambda-function-lambdainvoke-run'><p class="prefect-class">prefect.tasks.aws.lambda_function.LambdaInvoke.run</p>(function_name=None, payload=None, aws_credentials_secret="AWS_CREDENTIALS")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/lambda_function.py#L292">[source]</a></span></div>
<p class="methods">Task run method. Invokes Lambda function.<br><br>**Args**:     <ul class="args"><li class="args">`function_name (str)`: the name of the Lambda funciton to invoke     </li><li class="args">`payload (bytes or seekable file-like object)`: the JSON provided to         Lambda function as input     </li><li class="args">`aws_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your AWS credentials; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY`</li></ul>**Returns**:     <ul class="args"><li class="args">`dict `: response from AWS Invoke endpoint</li></ul></p>|

---
<br>

 ## LambdaList
 <div class='class-sig' id='prefect-tasks-aws-lambda-function-lambdalist'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.aws.lambda_function.LambdaList</p>(master_region="ALL", function_version="ALL", marker=None, max_items=50, aws_credentials_secret="AWS_CREDENTIALS", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/lambda_function.py#L337">[source]</a></span></div>

Task to list Lambda functions.

**Args**:     <ul class="args"><li class="args">`master_region (str, optional)`: for Lambda@Edge functions, the AWS         region of the master function     </li><li class="args">`function_version (str, optional)`: the version of a function,         default is 'ALL'     </li><li class="args">`marker (str, optional)`: specify the pagination token that's returned         by a previous request to retreive the next page of results     </li><li class="args">`max_items (int, optional)`: specify a value between 1 and 50 to limit         the number of functions in the response     </li><li class="args">`aws_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your AWS credentials; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY`     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-aws-lambda-function-lambdalist-run'><p class="prefect-class">prefect.tasks.aws.lambda_function.LambdaList.run</p>(aws_credentials_secret="AWS_CREDENTIALS")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/lambda_function.py#L373">[source]</a></span></div>
<p class="methods">Task fun method. Lists all Lambda functions.<br><br>**Args**:     <ul class="args"><li class="args">`aws_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your AWS credentials; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY`</li></ul>**Returns**:     <ul class="args"><li class="args">`dict `: a list of Lambda functions from AWS ListFunctions endpoint</li></ul></p>|

---
<br>

 ## StepActivate
 <div class='class-sig' id='prefect-tasks-aws-step-function-stepactivate'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.aws.step_function.StepActivate</p>(state_machine_arn, execution_name, execution_input="{}", aws_credentials_secret="AWS_CREDENTIALS", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/step_function.py#L8">[source]</a></span></div>

Task for activating an AWS Step Function.

**Args**:     <ul class="args"><li class="args">`state_machine_arn (str)`: the Amazon Resource Name (ARN) of the state machine         to execute     </li><li class="args">`execution_name (str)`: the name of the execution, this name must be unique for         your AWS account, region, and state machine for 90 days     </li><li class="args">`execution_input (str, optional)`: string that contains the JSON input data for         the execution     </li><li class="args">`aws_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your AWS credentials; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY`     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the         Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-aws-step-function-stepactivate-run'><p class="prefect-class">prefect.tasks.aws.step_function.StepActivate.run</p>(aws_credentials_secret="AWS_CREDENTIALS")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/aws/step_function.py#L40">[source]</a></span></div>
<p class="methods">Task run method. Activates AWS Step function.<br><br>**Args**:     <ul class="args"><li class="args">`aws_credentials_secret (str, optional)`: the name of the Prefect Secret         that stores your AWS credentials; this Secret must be a JSON string         with two keys: `ACCESS_KEY` and `SECRET_ACCESS_KEY`</li></ul>**Returns**:     <ul class="args"><li class="args">`dict`: response from AWS StartExecution endpoint</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on July 16, 2019 at 04:54 UTC</p>