---
sidebarDepth: 2
editLink: false
---
# Storage
---
The Prefect Storage interface encapsulates logic for storing, serializing and even running Flows.  Each storage unit is able to store _multiple_ flows (possibly with the constraint of name uniqueness within a given unit), and exposes the following methods and attributes:

- a name attribute
- a `flows` attribute that is a dictionary of Flows -> location
- an `add_flow(flow: Flow) -> str` method for adding flows to Storage, and that will return the location of the given flow in the Storage unit
- the `__contains__(self, obj) -> bool` special method for determining whether the Storage contains a given Flow
- one of `get_flow(flow_location: str)` or `get_env_runner(flow_location: str)` for retrieving a way of interfacing with either `flow.run` or a `FlowRunner` for the flow; `get_env_runner` is intended for situations where flow execution can only be interacted with via environment variables
- a `build() -> Storage` method for "building" the storage
- a `serialize() -> dict` method for serializing the relevant information about this Storage for later re-use.
 ## Storage
 <div class='class-sig' id='prefect-environments-storage-base-storage'><p class="prefect-sig">class </p><p class="prefect-class">prefect.environments.storage.base.Storage</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/base.py#L10">[source]</a></span></div>

Base interface for Storage objects.

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-environments-storage-base-storage-add-flow'><p class="prefect-class">prefect.environments.storage.base.Storage.add_flow</p>(flow)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/base.py#L48">[source]</a></span></div>
<p class="methods">Method for adding a new flow to this Storage object.<br><br>**Args**:     <ul class="args"><li class="args">`flow (Flow)`: a Prefect Flow to add</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the location of the newly added flow in this Storage object</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-base-storage-build'><p class="prefect-class">prefect.environments.storage.base.Storage.build</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/base.py#L75">[source]</a></span></div>
<p class="methods">Build the Storage object.<br><br>**Returns**:     <ul class="args"><li class="args">`Storage`: a Storage object that contains information about how and where         each flow is stored</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-base-storage-get-env-runner'><p class="prefect-class">prefect.environments.storage.base.Storage.get_env_runner</p>(flow_location)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/base.py#L21">[source]</a></span></div>
<p class="methods">Given a `flow_location` within this Storage object, returns something with a `run()` method that accepts a collection of environment variables for running the flow; for example, to specify an executor you would need to provide `{'PREFECT__ENGINE__EXECUTOR': ...}`.<br><br>**Args**:     <ul class="args"><li class="args">`flow_location (str)`: the location of a flow within this Storage</li></ul>**Returns**:     <ul class="args"><li class="args">a runner interface (something with a `run()` method for running the flow)</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-base-storage-get-flow'><p class="prefect-class">prefect.environments.storage.base.Storage.get_flow</p>(flow_location)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/base.py#L36">[source]</a></span></div>
<p class="methods">Given a flow_location within this Storage object, returns the underlying Flow (if possible).<br><br>**Args**:     <ul class="args"><li class="args">`flow_location (str)`: the location of a flow within this Storage</li></ul>**Returns**:     <ul class="args"><li class="args">`Flow`: the requested flow</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-base-storage-serialize'><p class="prefect-class">prefect.environments.storage.base.Storage.serialize</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/base.py#L86">[source]</a></span></div>
<p class="methods">Returns a serialized version of the Storage object<br><br>**Returns**:     <ul class="args"><li class="args">`dict`: the serialized Storage</li></ul></p>|

---
<br>

 ## Docker
 <div class='class-sig' id='prefect-environments-storage-docker-docker'><p class="prefect-sig">class </p><p class="prefect-class">prefect.environments.storage.docker.Docker</p>(registry_url=None, base_image=None, python_dependencies=None, image_name=None, image_tag=None, env_vars=None, files=None, base_url="unix://var/run/docker.sock", prefect_version=None, local_image=False)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/docker.py#L21">[source]</a></span></div>

Docker storage provides a mechanism for storing Prefect flows in Docker images and optionally pushing them to a registry.

A user specifies a `base_image` and other optional dependencies (e.g., `python_dependencies`) and `build()` will create a temporary Dockerfile that is used to build the image.

Note that the `base_image` must be capable of `pip` installing.

**Args**:     <ul class="args"><li class="args">`registry_url (str, optional)`: URL of a registry to push the image to; image will not be pushed if not provided     </li><li class="args">`base_image (str, optional)`: the base image for this environment (e.g. `python:3.6`), defaults to `python:3.6`     </li><li class="args">`python_dependencies (List[str], optional)`: list of pip installable dependencies for the image     </li><li class="args">`image_name (str, optional)`: name of the image to use when building, populated with a UUID after build     </li><li class="args">`image_tag (str, optional)`: tag of the image to use when building, populated with a UUID after build     </li><li class="args">`env_vars (dict, optional)`: a dictionary of environment variables to use when building     </li><li class="args">`files (dict, optional)`: a dictionary of files to copy into the image when building     </li><li class="args">`base_url`: (str, optional): a URL of a Docker daemon to use when for Docker related functionality     </li><li class="args">`prefect_version (str, optional)`: an optional branch, tag, or commit specifying the version of prefect         you want installed into the container; defaults to the version you are currently using or `"master"` if your version is ahead of         the latest tag     </li><li class="args">`local_image(bool, optional)`: an optional flag whether or not to use a local docker image, if True then a pull will not be attempted</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-environments-storage-docker-docker-add-flow'><p class="prefect-class">prefect.environments.storage.docker.Docker.add_flow</p>(flow)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/docker.py#L135">[source]</a></span></div>
<p class="methods">Method for adding a new flow to this Storage object.<br><br>**Args**:     <ul class="args"><li class="args">`flow (Flow)`: a Prefect Flow to add</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the location of the newly added flow in this Storage object</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-docker-docker-build'><p class="prefect-class">prefect.environments.storage.docker.Docker.build</p>(push=True)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/docker.py#L177">[source]</a></span></div>
<p class="methods">Build the Docker storage object.<br><br>**Args**:     <ul class="args"><li class="args">`push (bool, optional)`: Whether or not to push the built Docker image, this         requires the `registry_url` to be set</li></ul>**Returns**:     <ul class="args"><li class="args">`Docker`: a new Docker storage object that contains information about how and         where the flow is stored. Image name and tag are generated during the         build process.</li></ul>**Raises**:     <ul class="args"><li class="args">`InterruptedError`: if either pushing or pulling the image fails</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-docker-docker-build-image'><p class="prefect-class">prefect.environments.storage.docker.Docker.build_image</p>(push=True)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/docker.py#L199">[source]</a></span></div>
<p class="methods">Build a Docker image using the docker python library.<br><br>**Args**:     <ul class="args"><li class="args">`push (bool, optional)`: Whether or not to push the built Docker image, this         requires the `registry_url` to be set</li></ul>**Returns**:     <ul class="args"><li class="args">`tuple`: generated UUID strings `image_name`, `image_tag`</li></ul>**Raises**:     <ul class="args"><li class="args">`InterruptedError`: if either pushing or pulling the image fails</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-docker-docker-create-dockerfile-object'><p class="prefect-class">prefect.environments.storage.docker.Docker.create_dockerfile_object</p>(directory=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/docker.py#L263">[source]</a></span></div>
<p class="methods">Writes a dockerfile to the provided directory using the specified arguments on this Docker storage object.<br><br>In order for the docker python library to build a container it needs a Dockerfile that it can use to define the container. This function takes the specified arguments then writes them to a temporary file called Dockerfile.<br><br>*Note*: if `files` are added to this container, they will be copied to this directory as well.<br><br>**Args**:     <ul class="args"><li class="args">`directory (str, optional)`: A directory where the Dockerfile will be created,         if no directory is specified is will be created in the current working directory</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-docker-docker-get-env-runner'><p class="prefect-class">prefect.environments.storage.docker.Docker.get_env_runner</p>(flow_location)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/docker.py#L95">[source]</a></span></div>
<p class="methods">Given a flow_location within this Storage object, returns something with a `run()` method which accepts the standard runner kwargs and can run the flow.<br><br>**Args**:     <ul class="args"><li class="args">`flow_location (str)`: the location of a flow within this Storage</li></ul>**Returns**:     <ul class="args"><li class="args">a runner interface (something with a `run()` method for running the flow)</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-docker-docker-pull-image'><p class="prefect-class">prefect.environments.storage.docker.Docker.pull_image</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/docker.py#L390">[source]</a></span></div>
<p class="methods">Pull the image specified so it can be built.<br><br>In order for the docker python library to use a base image it must be pulled from either the main docker registry or a separate registry that must be set as `registry_url` on this class.<br><br>**Raises**:     <ul class="args"><li class="args">`InterruptedError`: if either pulling the image fails</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-docker-docker-push-image'><p class="prefect-class">prefect.environments.storage.docker.Docker.push_image</p>(image_name, image_tag)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/docker.py#L410">[source]</a></span></div>
<p class="methods">Push this environment to a registry<br><br>**Args**:     <ul class="args"><li class="args">`image_name (str)`: Name for the image     </li><li class="args">`image_tag (str)`: Tag for the image</li></ul>**Raises**:     <ul class="args"><li class="args">`InterruptedError`: if either pushing the image fails</li></ul></p>|

---
<br>

 ## Local
 <div class='class-sig' id='prefect-environments-storage-local-local'><p class="prefect-sig">class </p><p class="prefect-class">prefect.environments.storage.local.Local</p>(directory="~/.prefect/flows")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/local.py#L14">[source]</a></span></div>

Local storage class.  This class represents the Storage interface for Flows stored as bytes in the local filesystem.

**Args**:     <ul class="args"><li class="args">`directory (str, optional)`: the directory the flows will be stored in;         defaults to `~/.prefect/flows`.  If it doesn't already exist, it will be         created for you.</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-environments-storage-local-local-add-flow'><p class="prefect-class">prefect.environments.storage.local.Local.add_flow</p>(flow)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/local.py#L54">[source]</a></span></div>
<p class="methods">Method for storing a new flow as bytes in the local filesytem.<br><br>**Args**:     <ul class="args"><li class="args">`flow (Flow)`: a Prefect Flow to add</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the location of the newly added flow in this Storage object</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if a flow with the same name is already contained in this storage</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-local-local-build'><p class="prefect-class">prefect.environments.storage.local.Local.build</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/local.py#L90">[source]</a></span></div>
<p class="methods">Build the Storage object.<br><br>**Returns**:     <ul class="args"><li class="args">`Storage`: a Storage object that contains information about how and where         each flow is stored</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-local-local-get-flow'><p class="prefect-class">prefect.environments.storage.local.Local.get_flow</p>(flow_location)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/local.py#L33">[source]</a></span></div>
<p class="methods">Given a flow_location within this Storage object, returns the underlying Flow (if possible).<br><br>**Args**:     <ul class="args"><li class="args">`flow_location (str)`: the location of a flow within this Storage; in this case,         a file path where a Flow has been serialized to</li></ul>**Returns**:     <ul class="args"><li class="args">`Flow`: the requested flow</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the flow is not contained in this storage</li></ul></p>|

---
<br>

 ## Memory
 <div class='class-sig' id='prefect-environments-storage-memory-memory'><p class="prefect-sig">class </p><p class="prefect-class">prefect.environments.storage.memory.Memory</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/memory.py#L10">[source]</a></span></div>

Memory Storage class, mainly used for testing.  This class represents the Storage interface for Flows contained in memory, i.e., flows are simply stored as attributes of this class.

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-environments-storage-memory-memory-add-flow'><p class="prefect-class">prefect.environments.storage.memory.Memory.add_flow</p>(flow)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/memory.py#L38">[source]</a></span></div>
<p class="methods">Method for adding a new flow to this Storage object.<br><br>**Args**:     <ul class="args"><li class="args">`flow (Flow)`: a Prefect Flow to add</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the location of the newly added flow in this Storage object</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if a flow with the same name is already contained in this storage</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-memory-memory-build'><p class="prefect-class">prefect.environments.storage.memory.Memory.build</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/memory.py#L68">[source]</a></span></div>
<p class="methods">Build the Storage object.<br><br>**Returns**:     <ul class="args"><li class="args">`Storage`: a Storage object that contains information about how and where         each flow is stored</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-memory-memory-get-flow'><p class="prefect-class">prefect.environments.storage.memory.Memory.get_flow</p>(flow_location)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/memory.py#L21">[source]</a></span></div>
<p class="methods">Given a flow_location within this Storage object, returns the underlying Flow (if possible).<br><br>**Args**:     <ul class="args"><li class="args">`flow_location (str)`: the location of a flow within this Storage</li></ul>**Returns**:     <ul class="args"><li class="args">`Flow`: the requested flow</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the flow is not contained in this storage</li></ul></p>|

---
<br>

 ## Bytes
 <div class='class-sig' id='prefect-environments-storage-bytes-bytes'><p class="prefect-sig">class </p><p class="prefect-class">prefect.environments.storage.bytes.Bytes</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/bytes.py#L12">[source]</a></span></div>

Bytes Storage class, mainly used for testing.  This class represents the Storage interface for Flows stored directly as bytes.

The main difference between this class and `Memory` storage is that `Bytes` can be serialized and deserialized while preserving all relevant information.

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-environments-storage-bytes-bytes-add-flow'><p class="prefect-class">prefect.environments.storage.bytes.Bytes.add_flow</p>(flow)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/bytes.py#L44">[source]</a></span></div>
<p class="methods">Method for adding a new flow to this Storage object.<br><br>**Args**:     <ul class="args"><li class="args">`flow (Flow)`: a Prefect Flow to add</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the location of the newly added flow in this Storage object</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if a flow with the same name is already contained in this storage</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-bytes-bytes-build'><p class="prefect-class">prefect.environments.storage.bytes.Bytes.build</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/bytes.py#L74">[source]</a></span></div>
<p class="methods">Build the Storage object.<br><br>**Returns**:     <ul class="args"><li class="args">`Storage`: a Storage object that contains information about how and where         each flow is stored</li></ul></p>|
 | <div class='method-sig' id='prefect-environments-storage-bytes-bytes-get-flow'><p class="prefect-class">prefect.environments.storage.bytes.Bytes.get_flow</p>(flow_location)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/environments/storage/bytes.py#L25">[source]</a></span></div>
<p class="methods">Given a flow_location within this Storage object, returns the underlying Flow (if possible).<br><br>**Args**:     <ul class="args"><li class="args">`flow_location (str)`: the location of a flow within this Storage; in this case,         a flow location is simply a Flow's name</li></ul>**Returns**:     <ul class="args"><li class="args">`Flow`: the requested flow</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the flow is not contained in this storage</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on July 16, 2019 at 04:54 UTC</p>