---
sidebarDepth: 2
editLink: false
---
# Cache Validators
---
Cache validators are functions that determine if a task's output cache
is still valid, or whether that task should be re-run; they are provided at
Task creation via the `cache_validator` keyword argument (for more information
on instantiating Tasks see the [Task documentation](../core/task.html)).

Task caches are created at Task runtime if and only if the `cache_for` keyword
argument is provided to the Task, that specifies how long the output cache will be valid for
after its creation.  Cache validators come into play when a cached Task is re-run,
and are used to determine whether to re-run the Task or use the cache.

Note that _all_ validators take into account cache expiration.

A cache validator returns `True` if the cache is still valid, and `False` otherwise.

## Functions
|top-level functions: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-engine-cache-validators-never-use'><p class="prefect-class">prefect.engine.cache_validators.never_use</p>(state, inputs, parameters)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/cache_validators.py#L23">[source]</a></span></div>
<p class="methods">Never uses the cache.<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: a `Success` state from the last successful Task run that contains the cache     </li><li class="args">`inputs (dict)`: a `dict` of inputs that were available on the last         successful run of the cached Task     </li><li class="args">`parameters (dict)`: a `dict` of parameters that were available on the         last successful run of the cached Task</li></ul>**Returns**:     <ul class="args"><li class="args">boolean specifying whether or not the cache should be used</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-cache-validators-duration-only'><p class="prefect-class">prefect.engine.cache_validators.duration_only</p>(state, inputs, parameters)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/cache_validators.py#L44">[source]</a></span></div>
<p class="methods">Validates the cache based only on cache expiration.<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: a `Success` state from the last successful Task run that contains the cache     </li><li class="args">`inputs (dict)`: a `dict` of inputs that were available on the last         successful run of the cached Task     </li><li class="args">`parameters (dict)`: a `dict` of parameters that were available on the         last successful run of the cached Task</li></ul>**Returns**:     <ul class="args"><li class="args">boolean specifying whether or not the cache should be used</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-cache-validators-all-inputs'><p class="prefect-class">prefect.engine.cache_validators.all_inputs</p>(state, inputs, parameters)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/cache_validators.py#L70">[source]</a></span></div>
<p class="methods">Validates the cache based on cache expiration _and_ all inputs that were provided on the last successful run.<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: a `Success` state from the last successful Task run that contains the cache     </li><li class="args">`inputs (dict)`: a `dict` of inputs that were available on the last         successful run of the cached Task     </li><li class="args">`parameters (dict)`: a `dict` of parameters that were available on the         last successful run of the cached Task</li></ul>**Returns**:     <ul class="args"><li class="args">boolean specifying whether or not the cache should be used</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-cache-validators-all-parameters'><p class="prefect-class">prefect.engine.cache_validators.all_parameters</p>(state, inputs, parameters)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/cache_validators.py#L97">[source]</a></span></div>
<p class="methods">Validates the cache based on cache expiration _and_ all parameters that were provided on the last successful run.<br><br>**Args**:     <ul class="args"><li class="args">`state (State)`: a `Success` state from the last successful Task run that contains the cache     </li><li class="args">`inputs (dict)`: a `dict` of inputs that were available on the last         successful run of the cached Task     </li><li class="args">`parameters (dict)`: a `dict` of parameters that were available on the         last successful run of the cached Task</li></ul>**Returns**:     <ul class="args"><li class="args">boolean specifying whether or not the cache should be used</li></ul></p>|
 | <div class='method-sig' id='prefect-engine-cache-validators-partial-parameters-only'><p class="prefect-class">prefect.engine.cache_validators.partial_parameters_only</p>(validate_on=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/cache_validators.py#L124">[source]</a></span></div>
<p class="methods">Validates the cache based on cache expiration _and_ a subset of parameters (determined by the `validate_on` keyword) that were provided on the last successful run.<br><br>**Args**:     <ul class="args"><li class="args">`validate_on (list)`: a `list` of strings specifying the parameter names         to validate against</li></ul>**Returns**:     <ul class="args"><li class="args">`Callable`: the actual validation function specifying whether or not the cache should be used</li></ul>**Example**: <br><pre class="language-python"><code class="language-python"><span class="token keyword">from</span> datetime <span class="token keyword">import</span> timedelta<br><span class="token keyword">import</span> pendulum<br><span class="token keyword">from</span> prefect <span class="token keyword">import</span> Flow<span class="token punctuation">,</span> Parameter<span class="token punctuation">,</span> task<br><span class="token keyword">from</span> prefect.engine.cache_validators <span class="token keyword">import</span> partial_parameters_only<br><br><span class="token decorator">@task</span><span class="token punctuation">(</span>cache_for<span class="token operator">=</span>timedelta<span class="token punctuation">(</span>days<span class="token operator">=</span><span class="token number">1</span><span class="token punctuation">)</span><span class="token punctuation">,</span><br>      cache_validator<span class="token operator">=</span>partial_parameters_only<span class="token punctuation">(</span>validate_on<span class="token operator">=</span><span class="token punctuation">[</span><span class="token string">'</span><span class="token string">nrows</span><span class="token string">'</span><span class="token punctuation">]</span><span class="token punctuation">)</span><span class="token punctuation">)</span><br><span class="token keyword">def</span> <span class="token function">daily_db_refresh</span><span class="token punctuation">(</span>nrows<span class="token punctuation">,</span> runtime<span class="token punctuation">)</span><span class="token punctuation">:</span><br>    <span class="token keyword">pass</span><br><br><span class="token keyword">with</span> Flow<span class="token punctuation">(</span><span class="token string">"</span><span class="token string">My Flow</span><span class="token string">"</span><span class="token punctuation">)</span> <span class="token keyword">as</span> f<span class="token punctuation">:</span><br>    nrows <span class="token operator">=</span> Parameter<span class="token punctuation">(</span><span class="token string">"</span><span class="token string">nrows</span><span class="token string">"</span><span class="token punctuation">,</span> default<span class="token operator">=</span><span class="token number">500</span><span class="token punctuation">)</span><br>    runtime <span class="token operator">=</span> Parameter<span class="token punctuation">(</span><span class="token string">"</span><span class="token string">runtime</span><span class="token string">"</span><span class="token punctuation">)</span><br>    db_state <span class="token operator">=</span> daily_db_refresh<span class="token punctuation">(</span>nrows<span class="token punctuation">,</span> runtime<span class="token punctuation">)</span><br><br>state1 <span class="token operator">=</span> f<span class="token operator">.</span>run<span class="token punctuation">(</span>parameters<span class="token operator">=</span><span class="token builtin">dict</span><span class="token punctuation">(</span>nrows<span class="token operator">=</span><span class="token number">1000</span><span class="token punctuation">,</span> runtime<span class="token operator">=</span>pendulum<span class="token operator">.</span>now<span class="token punctuation">(</span><span class="token string">'</span><span class="token string">utc</span><span class="token string">'</span><span class="token punctuation">)</span><span class="token punctuation">)</span><span class="token punctuation">)</span><br><br><span class="token comment">## the second run will use the cache contained within state1.result[db_state]</span><br><span class="token comment">## even though `runtime` has changed</span><br>state2 <span class="token operator">=</span> f<span class="token operator">.</span>run<span class="token punctuation">(</span>parameters<span class="token operator">=</span><span class="token builtin">dict</span><span class="token punctuation">(</span>nrows<span class="token operator">=</span><span class="token number">1000</span><span class="token punctuation">,</span> runtime<span class="token operator">=</span>pendulum<span class="token operator">.</span>now<span class="token punctuation">(</span><span class="token string">'</span><span class="token string">utc</span><span class="token string">'</span><span class="token punctuation">)</span><span class="token punctuation">)</span><span class="token punctuation">,</span><br>               task_states<span class="token operator">=</span><span class="token punctuation">{</span>result<span class="token punctuation">:</span> state1<span class="token operator">.</span>result<span class="token punctuation">[</span>db_state<span class="token punctuation">]</span><span class="token punctuation">}</span><span class="token punctuation">)</span><br></code></pre><br></p>|
 | <div class='method-sig' id='prefect-engine-cache-validators-partial-inputs-only'><p class="prefect-class">prefect.engine.cache_validators.partial_inputs_only</p>(validate_on=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/engine/cache_validators.py#L200">[source]</a></span></div>
<p class="methods">Validates the cache based on cache expiration _and_ a subset of inputs (determined by the `validate_on` keyword) that were provided on the last successful run.<br><br>**Args**:     <ul class="args"><li class="args">`validate_on (list)`: a `list` of strings specifying the input names         to validate against</li></ul>**Returns**:     <ul class="args"><li class="args">`Callable`: the actual validation function specifying whether or not the cache should be used</li></ul>**Example**: <br><pre class="language-python"><code class="language-python"><span class="token keyword">import</span> random<br><span class="token keyword">from</span> datetime <span class="token keyword">import</span> timedelta<br><span class="token keyword">from</span> prefect <span class="token keyword">import</span> Flow<span class="token punctuation">,</span> task<br><span class="token keyword">from</span> prefect.engine.cache_validators <span class="token keyword">import</span> partial_inputs_only<br><br><span class="token decorator">@task</span><span class="token punctuation">(</span>cache_for<span class="token operator">=</span>timedelta<span class="token punctuation">(</span>days<span class="token operator">=</span><span class="token number">1</span><span class="token punctuation">)</span><span class="token punctuation">,</span><br>      cache_validator<span class="token operator">=</span>partial_inputs_only<span class="token punctuation">(</span>validate_on<span class="token operator">=</span><span class="token punctuation">[</span><span class="token string">'</span><span class="token string">x</span><span class="token string">'</span><span class="token punctuation">,</span> <span class="token string">'</span><span class="token string">y</span><span class="token string">'</span><span class="token punctuation">]</span><span class="token punctuation">)</span><span class="token punctuation">)</span><br><span class="token keyword">def</span> <span class="token function">add</span><span class="token punctuation">(</span>x<span class="token punctuation">,</span> y<span class="token punctuation">,</span> as_string<span class="token operator">=</span><span class="token keyword">False</span><span class="token punctuation">)</span><span class="token punctuation">:</span><br>    <span class="token keyword">if</span> as_string<span class="token punctuation">:</span><br>        <span class="token keyword">return</span> <span class="token string">'</span><span class="token string">{0}</span><span class="token string"> + </span><span class="token string">{1}</span><span class="token string">'</span><span class="token operator">.</span>format<span class="token punctuation">(</span>x<span class="token punctuation">,</span> y<span class="token punctuation">)</span><br>    <span class="token keyword">return</span> x <span class="token operator">+</span> y<br><br><span class="token decorator">@task</span><br><span class="token keyword">def</span> <span class="token function">rand_bool</span><span class="token punctuation">(</span><span class="token punctuation">)</span><span class="token punctuation">:</span><br>    <span class="token keyword">return</span> random<span class="token operator">.</span>random<span class="token punctuation">(</span><span class="token punctuation">)</span> <span class="token operator">></span> <span class="token number">0.5</span><br><br><span class="token keyword">with</span> Flow<span class="token punctuation">(</span><span class="token string">"</span><span class="token string">My Flow</span><span class="token string">"</span><span class="token punctuation">)</span> <span class="token keyword">as</span> f<span class="token punctuation">:</span><br>    ans <span class="token operator">=</span> add<span class="token punctuation">(</span><span class="token number">1</span><span class="token punctuation">,</span> <span class="token number">2</span><span class="token punctuation">,</span> rand_bool<span class="token punctuation">(</span><span class="token punctuation">)</span><span class="token punctuation">)</span><br><br>state1 <span class="token operator">=</span> f<span class="token operator">.</span>run<span class="token punctuation">(</span><span class="token punctuation">)</span><br><span class="token comment">## the second run will use the cache contained within state1.result[ans]</span><br><span class="token comment">## even though `rand_bool` might change</span><br>state2 <span class="token operator">=</span> f<span class="token operator">.</span>run<span class="token punctuation">(</span>task_states<span class="token operator">=</span><span class="token punctuation">{</span>result<span class="token punctuation">:</span> state1<span class="token operator">.</span>result<span class="token punctuation">[</span>ans<span class="token punctuation">]</span><span class="token punctuation">}</span><span class="token punctuation">)</span><br></code></pre><br></p>|

<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on July 16, 2019 at 04:54 UTC</p>