---
sidebarDepth: 2
editLink: false
---
# Triggers
---
Triggers are functions that determine if task state should change based on
the state of preceding tasks.

## Functions
|top-level functions: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-triggers-all-finished'><p class="prefect-class">prefect.triggers.all_finished</p>(upstream_states)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/triggers.py#L11">[source]</a></span></div>
<p class="methods">This task will run no matter what the upstream states are, as long as they are finished.<br><br>**Args**:     <ul class="args"><li class="args">`upstream_states (set[State])`: the set of all upstream states</li></ul></p>|
 | <div class='method-sig' id='prefect-triggers-manual-only'><p class="prefect-class">prefect.triggers.manual_only</p>(upstream_states)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/triggers.py#L26">[source]</a></span></div>
<p class="methods">This task will never run automatically, because this trigger will always place the task in a Paused state. The only exception is if the "resume" keyword is found in the Prefect context, which happens automatically when a task starts in a Resume state.<br><br>**Args**:     <ul class="args"><li class="args">`upstream_states (set[State])`: the set of all upstream states</li></ul></p>|
 | <div class='method-sig' id='prefect-triggers-all-finished'><p class="prefect-class">prefect.triggers.all_finished</p>(upstream_states)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/triggers.py#L11">[source]</a></span></div>
<p class="methods">This task will run no matter what the upstream states are, as long as they are finished.<br><br>**Args**:     <ul class="args"><li class="args">`upstream_states (set[State])`: the set of all upstream states</li></ul></p>|
 | <div class='method-sig' id='prefect-triggers-all-successful'><p class="prefect-class">prefect.triggers.all_successful</p>(upstream_states)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/triggers.py#L42">[source]</a></span></div>
<p class="methods">Runs if all upstream tasks were successful. Note that `SKIPPED` tasks are considered successes and `TRIGGER_FAILED` tasks are considered failures.<br><br>**Args**:     <ul class="args"><li class="args">`upstream_states (set[State])`: the set of all upstream states</li></ul></p>|
 | <div class='method-sig' id='prefect-triggers-all-failed'><p class="prefect-class">prefect.triggers.all_failed</p>(upstream_states)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/triggers.py#L58">[source]</a></span></div>
<p class="methods">Runs if all upstream tasks failed. Note that `SKIPPED` tasks are considered successes and `TRIGGER_FAILED` tasks are considered failures.<br><br>**Args**:     <ul class="args"><li class="args">`upstream_states (set[State])`: the set of all upstream states</li></ul></p>|
 | <div class='method-sig' id='prefect-triggers-any-successful'><p class="prefect-class">prefect.triggers.any_successful</p>(upstream_states)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/triggers.py#L74">[source]</a></span></div>
<p class="methods">Runs if any tasks were successful. Note that `SKIPPED` tasks are considered successes and `TRIGGER_FAILED` tasks are considered failures.<br><br>**Args**:     <ul class="args"><li class="args">`upstream_states (set[State])`: the set of all upstream states</li></ul></p>|
 | <div class='method-sig' id='prefect-triggers-any-failed'><p class="prefect-class">prefect.triggers.any_failed</p>(upstream_states)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/triggers.py#L90">[source]</a></span></div>
<p class="methods">Runs if any tasks failed. Note that `SKIPPED` tasks are considered successes and `TRIGGER_FAILED` tasks are considered failures.<br><br>**Args**:     <ul class="args"><li class="args">`upstream_states (set[State])`: the set of all upstream states</li></ul></p>|
 | <div class='method-sig' id='prefect-triggers-some-failed'><p class="prefect-class">prefect.triggers.some_failed</p>(at_least=None, at_most=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/triggers.py#L106">[source]</a></span></div>
<p class="methods">Runs if some amount of upstream tasks failed. This amount can be specified as an upper bound (`at_most`) or a lower bound (`at_least`), and can be provided as an absolute number or a percentage of upstream tasks.<br><br>Note that `SKIPPED` tasks are considered successes and `TRIGGER_FAILED` tasks are considered failures.<br><br>**Args**:     <ul class="args"><li class="args">`at_least (Union[int, float], optional)`: the minimum number of upstream failures that must occur for         this task to run.  If the provided number is less than 0, it will be interpreted as a percentage, otherwise as an         absolute number.     </li><li class="args">`at_most (Union[int, float], optional)`: the maximum number of upstream failures to allow for         this task to run.  If the provided number is less than 0, it will be interpreted as a percentage, otherwise as an         absolute number.</li></ul></p>|
 | <div class='method-sig' id='prefect-triggers-some-successful'><p class="prefect-class">prefect.triggers.some_successful</p>(at_least=None, at_most=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/triggers.py#L155">[source]</a></span></div>
<p class="methods">Runs if some amount of upstream tasks succeed. This amount can be specified as an upper bound (`at_most`) or a lower bound (`at_least`), and can be provided as an absolute number or a percentage of upstream tasks.<br><br>Note that `SKIPPED` tasks are considered successes and `TRIGGER_FAILED` tasks are considered failures.<br><br>**Args**:     <ul class="args"><li class="args">`at_least (Union[int, float], optional)`: the minimum number of upstream successes that must occur for         this task to run.  If the provided number is less than 0, it will be interpreted as a percentage, otherwise as an         absolute number.     </li><li class="args">`at_most (Union[int, float], optional)`: the maximum number of upstream successes to allow for         this task to run.  If the provided number is less than 0, it will be interpreted as a percentage, otherwise as an         absolute number.</li></ul></p>|

<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>by Prefect 0.5.2 on April 19, 2019 at 15:53 UTC</p>