---
sidebarDepth: 2
editLink: false
---
# Client
---
 ## Client
 <div class='class-sig' id='prefect-client-client-client'><p class="prefect-sig">class </p><p class="prefect-class">prefect.client.client.Client</p>(graphql_server=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L49">[source]</a></span></div>

Client for communication with Prefect Cloud

If the arguments aren't specified the client initialization first checks the prefect configuration and if the server is not set there it checks the current context. The token will only be present in the current context.

**Args**:     <ul class="args"><li class="args">`graphql_server (str, optional)`: the URL to send all GraphQL requests         to; if not provided, will be pulled from `cloud.graphql` config var</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-client-client-client-create-flow-run'><p class="prefect-class">prefect.client.client.Client.create_flow_run</p>(flow_id, context=None, parameters=None, scheduled_start_time=None, idempotency_key=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L398">[source]</a></span></div>
<p class="methods">Create a new flow run for the given flow id.  If `start_time` is not provided, the flow run will be scheduled to start immediately.<br><br>**Args**:     <ul class="args"><li class="args">`flow_id (str)`: the id of the Flow you wish to schedule     </li><li class="args">`context (dict, optional)`: the run context     </li><li class="args">`parameters (dict, optional)`: a dictionary of parameter values to pass to the flow run     </li><li class="args">`scheduled_start_time (datetime, optional)`: the time to schedule the execution for; if not provided, defaults to now     </li><li class="args">`idempotency_key (str, optional)`: an idempotency key; if provided, this run will be cached for 24         hours. Any subsequent attempts to create a run with the same idempotency key         will return the ID of the originally created run (no new run will be created after the first).         An error will be raised if parameters or context are provided and don't match the original.         Each subsequent request will reset the TTL for 24 hours.</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the ID of the newly-created flow run</li></ul>**Raises**:     <ul class="args"><li class="args">`ClientError`: if the GraphQL query is bad for any reason</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-create-project'><p class="prefect-class">prefect.client.client.Client.create_project</p>(project_name)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L375">[source]</a></span></div>
<p class="methods">Create a new Project<br><br>**Args**:     <ul class="args"><li class="args">`project_name (str)`: the project that should contain this flow.</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the ID of the newly-created project</li></ul>**Raises**:     <ul class="args"><li class="args">`ClientError`: if the project creation failed</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-deploy'><p class="prefect-class">prefect.client.client.Client.deploy</p>(flow, project_name, build=True, set_schedule_active=False)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L301">[source]</a></span></div>
<p class="methods">Push a new flow to Prefect Cloud<br><br>**Args**:     <ul class="args"><li class="args">`flow (Flow)`: a flow to deploy     </li><li class="args">`project_name (str)`: the project that should contain this flow.     </li><li class="args">`build (bool, optional)`: if `True`, the flow's environment is built         prior to serialization; defaults to `True`     </li><li class="args">`set_schedule_active (bool, optional)`: if `True`, will set the         schedule to active in the database and begin scheduling runs (if the Flow has a schedule).         Defaults to `False`. This can be changed later.</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the ID of the newly-deployed flow</li></ul>**Raises**:     <ul class="args"><li class="args">`ClientError`: if the deploy failed</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-get'><p class="prefect-class">prefect.client.client.Client.get</p>(path, server=None, **params)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L96">[source]</a></span></div>
<p class="methods">Convenience function for calling the Prefect API with token auth and GET request<br><br>**Args**:     <ul class="args"><li class="args">`path (str)`: the path of the API url. For example, to GET         http://prefect-server/v1/auth/login, path would be 'auth/login'.     </li><li class="args">`server (str, optional)`: the server to send the GET request to;         defaults to `self.graphql_server`     </li><li class="args">`**params (dict)`: GET parameters</li></ul>**Returns**:     <ul class="args"><li class="args">`dict`: Dictionary representation of the request made</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-get-flow-run-info'><p class="prefect-class">prefect.client.client.Client.get_flow_run_info</p>(flow_run_id)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L445">[source]</a></span></div>
<p class="methods">Retrieves version and current state information for the given flow run.<br><br>**Args**:     <ul class="args"><li class="args">`flow_run_id (str)`: the id of the flow run to get information for</li></ul>**Returns**:     <ul class="args"><li class="args">`GraphQLResult`: a `DotDict` representing information about the flow run</li></ul>**Raises**:     <ul class="args"><li class="args">`ClientError`: if the GraphQL mutation is bad for any reason</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-get-latest-cached-states'><p class="prefect-class">prefect.client.client.Client.get_latest_cached_states</p>(task_id, created_after)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L570">[source]</a></span></div>
<p class="methods">Pulls all Cached states for the given task which were created after the provided date.<br><br>**Args**:     <ul class="args"><li class="args">`task_id (str)`: the task id for this task run     </li><li class="args">`created_after (datetime.datetime)`: the earliest date the state should have been created at</li></ul>**Returns**:     <ul class="args"><li class="args">`List[State]`: a list of Cached states created after the given date</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-get-task-run-info'><p class="prefect-class">prefect.client.client.Client.get_task_run_info</p>(flow_run_id, task_id, map_index=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L599">[source]</a></span></div>
<p class="methods">Retrieves version and current state information for the given task run.<br><br>**Args**:     <ul class="args"><li class="args">`flow_run_id (str)`: the id of the flow run that this task run lives in     </li><li class="args">`task_id (str)`: the task id for this task run     </li><li class="args">`map_index (int, optional)`: the mapping index for this task run; if         `None`, it is assumed this task is _not_ mapped</li></ul>**Returns**:     <ul class="args"><li class="args">`NamedTuple`: a tuple containing `id, task_id, version, state`</li></ul>**Raises**:     <ul class="args"><li class="args">`ClientError`: if the GraphQL mutation is bad for any reason</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-graphql'><p class="prefect-class">prefect.client.client.Client.graphql</p>(query, raise_on_error=True, **variables)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L136">[source]</a></span></div>
<p class="methods">Convenience function for running queries against the Prefect GraphQL API<br><br>**Args**:     <ul class="args"><li class="args">`query (Any)`: A representation of a graphql query to be executed. It will be         parsed by prefect.utilities.graphql.parse_graphql().     </li><li class="args">`raise_on_error (bool)`: if True, a `ClientError` will be raised if the GraphQL         returns any `errors`.     </li><li class="args">`**variables (kwarg)`: Variables to be filled into a query with the key being         equivalent to the variables that are accepted by the query</li></ul>**Returns**:     <ul class="args"><li class="args">`dict`: Data returned from the GraphQL query</li></ul>**Raises**:     <ul class="args"><li class="args">ClientError if there are errors raised by the GraphQL mutation</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-login'><p class="prefect-class">prefect.client.client.Client.login</p>(email, password, account_slug=None, account_id=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L236">[source]</a></span></div>
<p class="methods">Login to the server in order to gain access<br><br>**Args**:     <ul class="args"><li class="args">`email (str)`: User's email on the platform     </li><li class="args">`password (str)`: User's password on the platform     </li><li class="args">`account_slug (str, optional)`: Slug that is unique to the user     </li><li class="args">`account_id (str, optional)`: Specific Account ID for this user to use</li></ul>**Raises**:     <ul class="args"><li class="args">AuthorizationError if unable to login to the server (request does not return `200`)</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-logout'><p class="prefect-class">prefect.client.client.Client.logout</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L278">[source]</a></span></div>
<p class="methods">Logs out by clearing all tokens, including deleting `~/.prefect/credentials/auth_token`</p>|
 | <div class='method-sig' id='prefect-client-client-client-post'><p class="prefect-class">prefect.client.client.Client.post</p>(path, server=None, **params)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L116">[source]</a></span></div>
<p class="methods">Convenience function for calling the Prefect API with token auth and POST request<br><br>**Args**:     <ul class="args"><li class="args">`path (str)`: the path of the API url. For example, to POST         http://prefect-server/v1/auth/login, path would be 'auth/login'.     </li><li class="args">`server (str, optional)`: the server to send the POST request to;         defaults to `self.graphql_server`     </li><li class="args">`**params (dict)`: POST parameters</li></ul>**Returns**:     <ul class="args"><li class="args">`dict`: Dictionary representation of the request made</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-refresh-token'><p class="prefect-class">prefect.client.client.Client.refresh_token</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L287">[source]</a></span></div>
<p class="methods">Refresh the auth token for this user on the server. It is only valid for fifteen minutes.</p>|
 | <div class='method-sig' id='prefect-client-client-client-set-flow-run-state'><p class="prefect-class">prefect.client.client.Client.set_flow_run_state</p>(flow_run_id, version, state)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L537">[source]</a></span></div>
<p class="methods">Sets new state for a flow run in the database.<br><br>**Args**:     <ul class="args"><li class="args">`flow_run_id (str)`: the id of the flow run to set state for     </li><li class="args">`version (int)`: the current version of the flow run state     </li><li class="args">`state (State)`: the new state for this flow run</li></ul>**Raises**:     <ul class="args"><li class="args">`ClientError`: if the GraphQL mutation is bad for any reason</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-set-secret'><p class="prefect-class">prefect.client.client.Client.set_secret</p>(name, value)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L678">[source]</a></span></div>
<p class="methods">Set a secret with the given name and value.<br><br>**Args**:     <ul class="args"><li class="args">`name (str)`: the name of the secret; used for retrieving the secret         during task runs     </li><li class="args">`value (Any)`: the value of the secret</li></ul>**Raises**:     <ul class="args"><li class="args">`ClientError`: if the GraphQL mutation is bad for any reason     </li><li class="args">`ValueError`: if the secret-setting was unsuccessful</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-set-task-run-state'><p class="prefect-class">prefect.client.client.Client.set_task_run_state</p>(task_run_id, version, state, cache_for=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L639">[source]</a></span></div>
<p class="methods">Sets new state for a task run.<br><br>**Args**:     <ul class="args"><li class="args">`task_run_id (str)`: the id of the task run to set state for     </li><li class="args">`version (int)`: the current version of the task run state     </li><li class="args">`state (State)`: the new state for this task run     </li><li class="args">`cache_for (timedelta, optional)`: how long to store the result of this task for, using the         serializer set in config; if not provided, no caching occurs</li></ul>**Raises**:     <ul class="args"><li class="args">`ClientError`: if the GraphQL mutation is bad for any reason</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-update-flow-run-heartbeat'><p class="prefect-class">prefect.client.client.Client.update_flow_run_heartbeat</p>(flow_run_id)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L499">[source]</a></span></div>
<p class="methods">Convenience method for heartbeating a flow run.<br><br>Does NOT raise an error if the update fails.<br><br>**Args**:     <ul class="args"><li class="args">`flow_run_id (str)`: the flow run ID to heartbeat</li></ul></p>|
 | <div class='method-sig' id='prefect-client-client-client-update-task-run-heartbeat'><p class="prefect-class">prefect.client.client.Client.update_task_run_heartbeat</p>(task_run_id)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/client/client.py#L518">[source]</a></span></div>
<p class="methods">Convenience method for heartbeating a task run.<br><br>Does NOT raise an error if the update fails.<br><br>**Args**:     <ul class="args"><li class="args">`task_run_id (str)`: the task run ID to heartbeat</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>by Prefect 0.5.1+0.g71829f4e.dirty on April 4, 2019 at 23:56 UTC</p>