---
sidebarDepth: 2
editLink: false
---
# GraphQL
---
 ## GraphQLResult
 <div class='class-sig' id='prefect-utilities-graphql-graphqlresult'><p class="prefect-sig">class </p><p class="prefect-class">prefect.utilities.graphql.GraphQLResult</p>(init_dict=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/graphql.py#L20">[source]</a></span></div>

A `dict` that also supports attribute ("dot") access. Think of this as an extension to the standard python `dict` object.  **Note**: while any hashable object can be added to a `DotDict`, _only_ valid Python identifiers can be accessed with the dot syntax; this excludes strings which begin in numbers, special characters, or double underscores.

**Args**:     <ul class="args"><li class="args">`init_dict (dict, optional)`: dictionary to initialize the `DotDict`     with     </li><li class="args">`**kwargs (optional)`: key, value pairs with which to initialize the     `DotDict`</li></ul>**Example**:     
```python
    dotdict = DotDict({'a': 34}, b=56, c=set())
    dotdict.a # 34
    dotdict['b'] # 56
    dotdict.c # set()

```


---
<br>

 ## EnumValue
 <div class='class-sig' id='prefect-utilities-graphql-enumvalue'><p class="prefect-sig">class </p><p class="prefect-class">prefect.utilities.graphql.EnumValue</p>(value)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/graphql.py#L30">[source]</a></span></div>

When parsing GraphQL arguments, strings can be wrapped in this class to be rendered as enum values, without quotation marks.

**Args**:     <ul class="args"><li class="args">`value (str)`: the value that should be represented as an enum value</li></ul>


---
<br>


## Functions
|top-level functions: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-utilities-graphql-parse-graphql'><p class="prefect-class">prefect.utilities.graphql.parse_graphql</p>(document)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/graphql.py#L68">[source]</a></span></div>
<p class="methods">Parses a document into a GraphQL-compliant query string.<br><br>Documents can be a mix of `strings`, `dicts`, `lists` (or other sequences), and `GQLObjects`.<br><br>The parser attempts to maintain the form of the Python objects in the resulting GQL query.<br><br>For example: <br><pre class="language-python"><code class="language-python">query <span class="token operator">=</span> parse_graphql<span class="token punctuation">(</span><span class="token punctuation">{</span><br>    <span class="token string">'</span><span class="token string">query</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token punctuation">{</span><br>        <span class="token string">'</span><span class="token string">books(published: </span><span class="token string">{gt: 1990}</span><span class="token string">)</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token punctuation">{</span><br>            <span class="token string">'</span><span class="token string">title</span><span class="token string">'</span><br>        <span class="token punctuation">}</span><span class="token punctuation">,</span><br>        <span class="token string">'</span><span class="token string">authors</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token punctuation">[</span><br>            <span class="token string">'</span><span class="token string">name</span><span class="token string">'</span><span class="token punctuation">,</span><br>            <span class="token string">'</span><span class="token string">books</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token punctuation">{</span><br>                <span class="token string">'</span><span class="token string">title</span><span class="token string">'</span><br>            <span class="token punctuation">}</span><span class="token punctuation">]</span><br>        <span class="token punctuation">}</span><br>    <span class="token punctuation">}</span><br><span class="token punctuation">}</span><span class="token punctuation">)</span><br></code></pre><br> results in: <br><pre class="language-python"><code class="language-python">query <span class="token punctuation">{</span><br>    books<span class="token punctuation">(</span>published<span class="token punctuation">:</span> <span class="token punctuation">{</span>gt<span class="token punctuation">:</span> <span class="token number">1990</span><span class="token punctuation">}</span><span class="token punctuation">)</span> <span class="token punctuation">{</span><br>        title<br>    <span class="token punctuation">}</span><br>    authors <span class="token punctuation">{</span><br>        name<br>        books <span class="token punctuation">{</span><br>            title<br>        <span class="token punctuation">}</span><br>    <span class="token punctuation">}</span><br><span class="token punctuation">}</span><br></code></pre><br><br><br>For convenience, if a dictionary key is True, it is ignored and the key alone is used as a field name<br><br><br><pre class="language-python"><code class="language-python"><span class="token punctuation">{</span><span class="token string">'</span><span class="token string">query</span><span class="token string">'</span><span class="token punctuation">:</span><span class="token punctuation">{</span><br>    <span class="token string">'</span><span class="token string">books</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token punctuation">{</span><br>        <span class="token string">'</span><span class="token string">id</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token keyword">True</span><span class="token punctuation">,</span><br>        <span class="token string">'</span><span class="token string">name</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token keyword">True</span><span class="token punctuation">,</span><br>        <span class="token string">'</span><span class="token string">author</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token punctuation">{</span><br>            <span class="token string">'</span><span class="token string">id</span><span class="token string">'</span><span class="token punctuation">,</span><br>            <span class="token string">'</span><span class="token string">name</span><span class="token string">'</span><span class="token punctuation">,</span><br>        <span class="token punctuation">}</span><br>    <span class="token punctuation">}</span><br><span class="token punctuation">}</span><span class="token punctuation">}</span><br></code></pre><br><br><br>is equivalent to:<br><br><br><pre class="language-python"><code class="language-python"><span class="token punctuation">{</span><span class="token string">'</span><span class="token string">query</span><span class="token string">'</span><span class="token punctuation">:</span><span class="token punctuation">{</span><br>    <span class="token string">'</span><span class="token string">books</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token punctuation">[</span><br>        <span class="token string">'</span><span class="token string">id</span><span class="token string">'</span><span class="token punctuation">,</span><br>        <span class="token string">'</span><span class="token string">name</span><span class="token string">'</span><span class="token punctuation">,</span><br>        <span class="token punctuation">{</span><span class="token string">'</span><span class="token string">author</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token punctuation">{</span><br>            <span class="token string">'</span><span class="token string">id</span><span class="token string">'</span><span class="token punctuation">,</span><br>            <span class="token string">'</span><span class="token string">name</span><span class="token string">'</span><span class="token punctuation">,</span><br>        <span class="token punctuation">}</span><span class="token punctuation">}</span><br>    <span class="token punctuation">]</span><br><span class="token punctuation">}</span><span class="token punctuation">}</span><br></code></pre><br><br><br>**Args**:     <ul class="args"><li class="args">`document (Any)`: A collection of Python objects complying with the general shape         of a GraphQL query. Generally, this will consist of (at least) a dictionary, but         also sequences and `GQLObjects`.</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: a GraphQL query compiled from the provided Python structures.</li></ul>**Raises**:     <ul class="args"><li class="args">`TypeError`: if the user provided a `GQLObject` class, rather than an instance.</li></ul></p>|
 | <div class='method-sig' id='prefect-utilities-graphql-parse-graphql-arguments'><p class="prefect-class">prefect.utilities.graphql.parse_graphql_arguments</p>(arguments)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/graphql.py#L189">[source]</a></span></div>
<p class="methods">Parses a dictionary of GraphQL arguments, returning a GraphQL-compliant string representation. If a string is passed, it is returned without modification.<br><br>This parser makes a few adjustments to the dictionary's usual string representation:     - `'` around keys are removed     - spaces added around curly braces     - leading and lagging braces are removed     - `True` becomes `true`, `False` becomes `false`, and `None` becomes `null`<br><br>**Args**:     <ul class="args"><li class="args">`arguments (Any)`: an object (usually a dictionary) representing the GraphQL arguments</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: a string representing the parsed GraphQL arguments</li></ul></p>|
 | <div class='method-sig' id='prefect-utilities-graphql-with-args'><p class="prefect-class">prefect.utilities.graphql.with_args</p>(field, arguments)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/graphql.py#L243">[source]</a></span></div>
<p class="methods">Given Python objects representing a field name and arguments, formats them as a single GraphQL compatible string.<br><br>**Example**:<br><br><br><pre class="language-python"><code class="language-python">query <span class="token operator">=</span> parse_graphql<span class="token punctuation">(</span><span class="token punctuation">{</span><br>    <span class="token string">'</span><span class="token string">query</span><span class="token string">'</span><span class="token punctuation">:</span> <span class="token punctuation">{</span><br>        with_args<span class="token punctuation">(</span><span class="token string">"</span><span class="token string">task</span><span class="token string">"</span><span class="token punctuation">,</span> <span class="token punctuation">{</span><span class="token string">"</span><span class="token string">where</span><span class="token string">"</span><span class="token punctuation">:</span> <span class="token punctuation">{</span><span class="token string">"</span><span class="token string">id</span><span class="token string">"</span><span class="token punctuation">:</span> <span class="token number">3</span><span class="token punctuation">}</span><span class="token punctuation">}</span><span class="token punctuation">)</span><span class="token punctuation">:</span> <span class="token punctuation">{</span><br>            <span class="token string">"</span><span class="token string">id</span><span class="token string">"</span><br>        <span class="token punctuation">}</span><br>    <span class="token punctuation">}</span><br><span class="token punctuation">}</span><span class="token punctuation">)</span><br><br><span class="token keyword">assert</span> query <span class="token operator">==</span> <span class="token string">'''</span><span class="token string"><br></span><span class="token string">    query </span><span class="token string">{</span><span class="token string"><br></span><span class="token string">        task(where: </span><span class="token string">{id: 3}</span><span class="token string">) </span><span class="token string">{</span><span class="token string"><br></span><span class="token string">            id</span><span class="token string"><br></span><span class="token string">        }</span><span class="token string"><br></span><span class="token string">    }</span><span class="token string"><br></span><span class="token string">    </span><span class="token string">'''</span><br></code></pre><br><br><br>**Args**:     <ul class="args"><li class="args">`field (Any)`: the GraphQL field that will be supplied with arguments     </li><li class="args">`arguments (Any)`: the arguments to be parsed and  supplied to the field</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the parsed field and arguments</li></ul></p>|

<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>by Prefect 0.5.0 on March 29, 2019 at 17:39 UTC</p>
