---
sidebarDepth: 2
editLink: false
---
# Executors
---

## Functions
|top-level functions: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-utilities-executors-main-thread-timeout'><p class="prefect-class">prefect.utilities.executors.main_thread_timeout</p>(fn, *args, timeout=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/executors.py#L104">[source]</a></span></div>
<p class="methods">Helper function for implementing timeouts on function executions. Implemented by setting a `signal` alarm on a timer. Must be run in the main thread.<br><br>**Args**:     <ul class="args"><li class="args">`fn (callable)`: the function to execute     </li><li class="args">`*args (Any)`: arguments to pass to the function     </li><li class="args">`timeout (int)`: the length of time to allow for         execution before raising a `TimeoutError`, represented as an integer in seconds     </li><li class="args">`**kwargs (Any)`: keyword arguments to pass to the function</li></ul>**Returns**:     <ul class="args"><li class="args">the result of `f(*args, **kwargs)`</li></ul>**Raises**:     <ul class="args"><li class="args">`TimeoutError`: if function execution exceeds the allowed timeout     </li><li class="args">`ValueError`: if run from outside the main thread</li></ul></p>|
 | <div class='method-sig' id='prefect-utilities-executors-multiprocessing-timeout'><p class="prefect-class">prefect.utilities.executors.multiprocessing_timeout</p>(fn, *args, timeout=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/utilities/executors.py#L55">[source]</a></span></div>
<p class="methods">Helper function for implementing timeouts on function executions. Implemented by spawning a new multiprocess.Process() and joining with timeout.<br><br>**Args**:     <ul class="args"><li class="args">`fn (callable)`: the function to execute     </li><li class="args">`*args (Any)`: arguments to pass to the function     </li><li class="args">`timeout (int)`: the length of time to allow for         execution before raising a `TimeoutError`, represented as an integer in seconds     </li><li class="args">`**kwargs (Any)`: keyword arguments to pass to the function</li></ul>**Returns**:     <ul class="args"><li class="args">the result of `f(*args, **kwargs)`</li></ul>**Raises**:     <ul class="args"><li class="args">`AssertionError`: if run from a daemonic process     </li><li class="args">`TimeoutError`: if function execution exceeds the allowed timeout</li></ul></p>|

<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>by Prefect 0.5.0 on March 29, 2019 at 17:39 UTC</p>
