---
sidebarDepth: 2
editLink: false
---
# Flow
---
 ## Flow
 <div class='class-sig' id='prefect-core-flow-flow'><p class="prefect-sig">class </p><p class="prefect-class">prefect.core.flow.Flow</p>(name, schedule=None, environment=None, tasks=None, edges=None, reference_tasks=None, state_handlers=None, on_failure=None, validate=None, result_handler=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L75">[source]</a></span></div>

The Flow class is used as the representation of a collection of dependent Tasks. Flows track Task dependencies, parameters and provide the main API for constructing and managing workflows.

Initializing Flow example: 
```python
class MyTask(Task):
    def run(self):
        return "hello"

task_1 = MyTask()
flow = Flow(name="my_flow", tasks=[task_1])

flow.run()

```

Initializing Flow as context manager example: 
```python
@task
def my_task():
    return "hello"

with Flow("my_flow") as flow:
    task_1 = my_task()

flow.run()

```

**Args**:     <ul class="args"><li class="args">`name (str)`: The name of the flow. Cannot be `None` or an empty string     </li><li class="args">`schedule (prefect.schedules.Schedule, optional)`: A default schedule for the flow     </li><li class="args">`environment (prefect.environments.Environment, optional)`: The environment         type that the flow should be run in. If None, a LocalEnvironment will be created.     </li><li class="args">`tasks ([Task], optional)`: If provided, a list of tasks that will initialize the flow     </li><li class="args">`edges ([Edge], optional)`: A list of edges between tasks     </li><li class="args">`reference_tasks ([Task], optional)`: A list of tasks which determine the final         state of a flow     </li><li class="args">`state_handlers (Iterable[Callable], optional)`: A list of state change handlers         that will be called whenever the flow changes state, providing an         opportunity to inspect or modify the new state. The handler         will be passed the flow instance, the old (prior) state, and the new         (current) state, with the following signature:             `state_handler(flow: Flow, old_state: State, new_state: State) -> Optional[State]`         If multiple functions are passed, then the `new_state` argument will be the         result of the previous handler.     </li><li class="args">`on_failure (Callable, optional)`: A function with signature `fn(flow: Flow, state: State) -> None`         which will be called anytime this Flow enters a failure state     </li><li class="args">`validate (bool, optional)`: Whether or not to check the validity of         the flow (e.g., presence of cycles and illegal keys) after adding the edges passed         in the `edges` argument. Defaults to the value of `eager_edge_validation` in         your prefect configuration file.     </li><li class="args">`result_handler (ResultHandler, optional)`: the handler to use for         retrieving and storing state results during execution; if not provided, will default         to the one specified in your config</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-core-flow-flow-add-edge'><p class="prefect-class">prefect.core.flow.Flow.add_edge</p>(upstream_task, downstream_task, key=None, mapped=False, validate=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L459">[source]</a></span></div>
<p class="methods">Add an edge in the flow between two tasks. All edges are directed beginning with an upstream task and ending with a downstream task.<br><br>**Args**:     <ul class="args"><li class="args">`upstream_task (Task)`: The task that the edge should start from     </li><li class="args">`downstream_task (Task)`: The task that the edge should end with     </li><li class="args">`key (str, optional)`: The key to be set for the new edge; this is         the argument name the result of the upstream task will be bound to in the         `run()` method of the downstream task     </li><li class="args">`mapped (bool, optional)`: Whether this edge represents a call to `Task.map()`; defaults to `False`     </li><li class="args">`validate (bool, optional)`: Whether or not to check the validity of         the flow (e.g., presence of cycles and illegal keys). Defaults to the value         of `eager_edge_validation` in your prefect configuration file.</li></ul>**Returns**:     <ul class="args"><li class="args">`prefect.core.edge.Edge`: The `Edge` object that was successfully added to the flow</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the `downstream_task` is of type `Parameter`     </li><li class="args">`ValueError`: if the edge exists with this `key` and `downstream_task`</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-add-task'><p class="prefect-class">prefect.core.flow.Flow.add_task</p>(task)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L427">[source]</a></span></div>
<p class="methods">Add a task to the flow if the task does not already exist. The tasks are uniquely identified by their `slug`.<br><br>**Args**:     <ul class="args"><li class="args">`task (Task)`: the new Task to be added to the flow</li></ul>**Returns**:     <ul class="args"><li class="args">`Task`: the `Task` object passed in if the task was successfully added</li></ul>**Raises**:     <ul class="args"><li class="args">`TypeError`: if the `task` is not of type `Task`     </li><li class="args">`ValueError`: if the `task.slug` matches that of a task already in the flow</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-all-downstream-edges'><p class="prefect-class">prefect.core.flow.Flow.all_downstream_edges</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L593">[source]</a></span></div>
<p class="methods">Returns a dictionary relating each task in the Flow to the set of all _downstream_ edges for the task<br><br>**Returns**:     <ul class="args"><li class="args">dict with the key as tasks and the value as a set of downstream edges</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-all-upstream-edges'><p class="prefect-class">prefect.core.flow.Flow.all_upstream_edges</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L579">[source]</a></span></div>
<p class="methods">Returns a dictionary relating each task in the Flow to the set of all _upstream_ edges for the task<br><br>**Returns**:     <ul class="args"><li class="args">dict with the key as tasks and the value as a set of upstream edges</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-chain'><p class="prefect-class">prefect.core.flow.Flow.chain</p>(*tasks, validate=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L532">[source]</a></span></div>
<p class="methods">Adds a sequence of dependent tasks to the flow; each task should be provided as an argument (or splatted from a list).<br><br>**Args**:     <ul class="args"><li class="args">`*tasks (list)`: A list of tasks to chain together     </li><li class="args">`validate (bool, optional)`: Whether or not to check the validity of         the flow (e.g., presence of cycles).  Defaults to the value of `eager_edge_validation`         in your prefect configuration file.</li></ul>**Returns**:     <ul class="args"><li class="args">A list of Edge objects added to the flow</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-copy'><p class="prefect-class">prefect.core.flow.Flow.copy</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L205">[source]</a></span></div>
<p class="methods">Create and returns a copy of the current Flow.</p>|
 | <div class='method-sig' id='prefect-core-flow-flow-deploy'><p class="prefect-class">prefect.core.flow.Flow.deploy</p>(project_name, set_schedule_active=False)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L1359">[source]</a></span></div>
<p class="methods">Deploy the flow to Prefect Cloud<br><br>**Args**:     <ul class="args"><li class="args">`project_name (str)`: the project that should contain this flow.     </li><li class="args">`set_schedule_active (bool, optional)`: if `True`, will set the         schedule to active in the database and begin scheduling runs (if the Flow has a schedule).         Defaults to `False`. This can be changed later.</li></ul>**Returns**:     <ul class="args"><li class="args">`str`: the ID of the flow that was deployed</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-downstream-tasks'><p class="prefect-class">prefect.core.flow.Flow.downstream_tasks</p>(task)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L659">[source]</a></span></div>
<p class="methods">Get all of the tasks downstream of a task<br><br>**Args**:     <ul class="args"><li class="args">`task (Task)`: The task that we want to find downstream tasks from</li></ul>**Returns**:     <ul class="args"><li class="args">set of Task objects which are downstream of `task`</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-edges-from'><p class="prefect-class">prefect.core.flow.Flow.edges_from</p>(task)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L627">[source]</a></span></div>
<p class="methods">Get all of the edges leading from a task (i.e., the downstream edges)<br><br>**Args**:     <ul class="args"><li class="args">`task (Task)`: The task that we want to find edges leading from</li></ul>**Returns**:     <ul class="args"><li class="args">dict with the key as the task passed in and the value as a set of all edges     leading from that task</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `task` is not found in this flow</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-edges-to'><p class="prefect-class">prefect.core.flow.Flow.edges_to</p>(task)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L607">[source]</a></span></div>
<p class="methods">Get all of the edges leading to a task (i.e., the upstream edges)<br><br>**Args**:     <ul class="args"><li class="args">`task (Task)`: The task that we want to find edges leading to</li></ul>**Returns**:     <ul class="args"><li class="args">dict with the key as the task passed in and the value as a set of all edges     leading to that task</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if `task` is not found in this flow</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-generate-local-task-ids'><p class="prefect-class">prefect.core.flow.Flow.generate_local_task_ids</p>(_debug_steps=False)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L1150">[source]</a></span></div>
<p class="methods">Generates stable IDs for each task that track across flow versions<br><br>If our goal was to create an ID for each task, we would simply produce a random hash. However, we would prefer to generate deterministic IDs. That way, identical flows will have the same task ids and near-identical flows will have overlapping task ids.<br><br>If all tasks were unique, we could simply produce unique IDs by hashing the tasks themselves. However, Prefect allows duplicate tasks in a flow. Therefore, we take a few steps to iteratively produce unique IDs. There are five steps, and tasks go through each step until they have a unique ID:<br><br>1. Generate an ID from the task's attributes.         This fingerprints a task in terms of its own attributes.     2. Generate an ID from the task's ancestors.         This fingerprints a task in terms of the computational graph leading to it.     3. Generate an ID from the task's descendents         This fingerprints a task in terms of how it is used in a computational graph.     4. Iteratively generate an ID from the task's neighbors         This fingerprints a task in terms of a widening concentric circle of its neighbors.     5. Adjust a root task's ID and recompute all non-unique descendents         This step is only reached if a flow contains more than one unconnected but         identical computational paths. The previous 4 steps are unable to distinguish         between those two paths, so we pick one at random and adjust the leading tasks'         IDs, as well as all following tasks. This is safe because we are sure that the         computational paths are identical.<br><br>**Args**:     <ul class="args"><li class="args">`_debug_steps (bool, optional)`: if True, the function will return a dictionary of         {step_number: ids_produced_at_step} pairs, where ids_produced_at_step is the         id dict following that step. This is used for debugging/testing only.</li></ul>**Returns**:     <ul class="args"><li class="args">`dict`: a dictionary of {task: task_id} pairs</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-get-tasks'><p class="prefect-class">prefect.core.flow.Flow.get_tasks</p>(name=None, slug=None, tags=None, task_type=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L221">[source]</a></span></div>
<p class="methods">Helper method for retrieving tasks from this flow based on certain attributes. The _intersection_ of all provided attributes is taken, i.e., only those tasks which match _all_ provided conditions are returned.<br><br>**Args**:     <ul class="args"><li class="args">`name (str, optional)`: the name of the task     </li><li class="args">`slug (str, optional)`: the slug of the task     </li><li class="args">`tags ([str], optional)`: an iterable of task tags     </li><li class="args">`task_type (type, optional)`: a possible task class type</li></ul>**Returns**:     <ul class="args"><li class="args">`[Task]`: a list of tasks which meet the required conditions</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-parameters'><p class="prefect-class">prefect.core.flow.Flow.parameters</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L372">[source]</a></span></div>
<p class="methods">Returns any parameters of the flow.<br><br>**Returns**:     <ul class="args"><li class="args">`set`: a set of any Parameters in this flow</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-reference-tasks'><p class="prefect-class">prefect.core.flow.Flow.reference_tasks</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L381">[source]</a></span></div>
<p class="methods">A flow's "reference tasks" are used to determine its state when it runs. If all the reference tasks are successful, then the flow run is considered successful. However, if any of the reference tasks fail, the flow is considered to fail. (Note that skips are counted as successes; see [the state documentation](../engine/state.html) for a full description of what is considered failure, success, etc.)<br><br>By default, a flow's reference tasks are its terminal tasks. This means the state of a flow is determined by those tasks which have no downstream dependencies.<br><br>In some situations, users may want to customize this behavior; for example, if a flow's terminal tasks are "clean up" tasks for the rest of the flow that only run if certain (more relevant) tasks fail, we might not want them determining the overall state of the flow run. The `flow.set_reference_tasks()` method can be used to set such custom `reference_tasks`.<br><br>Please note that even if `reference_tasks` are provided that are not terminal tasks, the flow will not be considered "finished" until all terminal tasks have completed. Only then will state be determined, using the reference tasks.<br><br>**Returns**:     <ul class="args"><li class="args">set of Task objects which are the reference tasks in the flow</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-replace'><p class="prefect-class">prefect.core.flow.Flow.replace</p>(old, new, validate=True)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L258">[source]</a></span></div>
<p class="methods">Performs an inplace replacement of the old task with the provided new task.<br><br>**Args**:     <ul class="args"><li class="args">`old (Task)`: the old task to replace     </li><li class="args">`new (Task)`: the new task to replace the old with; if not a Prefect         Task, Prefect will attempt to convert it to one     </li><li class="args">`validate (boolean, optional)`: whether to validate the Flow after         the replace has been completed; defaults to `True`</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if the `old` task is not a part of this flow</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-root-tasks'><p class="prefect-class">prefect.core.flow.Flow.root_tasks</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L351">[source]</a></span></div>
<p class="methods">Get the tasks in the flow that have no upstream dependencies; these are the tasks which, by default, flow execution begins with.<br><br>**Returns**:     <ul class="args"><li class="args">set of Task objects that have no upstream dependencies</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-run'><p class="prefect-class">prefect.core.flow.Flow.run</p>(parameters=None, runner_cls=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L921">[source]</a></span></div>
<p class="methods">Run the flow on its schedule using an instance of a FlowRunner.  If the Flow has no schedule, a single stateful run will occur (including retries).<br><br>Note that this command will block and run this Flow on its schedule indefinitely (if it has one); all task states will be stored in memory, and task retries will not occur until every Task in the Flow has had a chance to run.<br><br>**Args**:     <ul class="args"><li class="args">`parameters (Dict[str, Any], optional)`: values to pass into the runner     </li><li class="args">`runner_cls (type)`: an optional FlowRunner class (will use the default if not provided)     </li><li class="args">`**kwargs`: additional keyword arguments; if any provided keywords         match known parameter names, they will be used as such. Otherwise they will be passed to the         `FlowRunner.run()` method</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if this Flow has a Schedule with no more scheduled runs     </li><li class="args">`ValueError`: if the `return_tasks` keyword argument is provided</li></ul>**Returns**:     <ul class="args"><li class="args">`State`: the state of the flow after its final run</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-serialize'><p class="prefect-class">prefect.core.flow.Flow.serialize</p>(build=False)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L1121">[source]</a></span></div>
<p class="methods">Creates a serialized representation of the flow.<br><br>**Args**:     <ul class="args"><li class="args">`build (bool, optional)`: if `True`, the flow's environment is built         prior to serialization</li></ul>**Returns**:     <ul class="args"><li class="args">dict representing the flow</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-set-dependencies'><p class="prefect-class">prefect.core.flow.Flow.set_dependencies</p>(task, upstream_tasks=None, downstream_tasks=None, keyword_tasks=None, mapped=False, validate=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L769">[source]</a></span></div>
<p class="methods">Convenience function for adding task dependencies.<br><br>**Args**:     <ul class="args"><li class="args">`task (object)`: a Task that will become part of the Flow. If the task is not a         Task subclass, Prefect will attempt to convert it to one.     </li><li class="args">`upstream_tasks ([object], optional)`: Tasks that will run before the task runs. If any task         is not a Task subclass, Prefect will attempt to convert it to one.     </li><li class="args">`downstream_tasks ([object], optional)`: Tasks that will run after the task runs. If any task         is not a Task subclass, Prefect will attempt to convert it to one.     </li><li class="args">`keyword_tasks ({key: object}, optional)`: The results of these tasks         will be provided to the task under the specified keyword         arguments. If any task is not a Task subclass, Prefect will attempt to         convert it to one.     </li><li class="args">`mapped (bool, optional)`: Whether the upstream tasks (both keyed         and non-keyed) should be mapped over; defaults to `False`. If `True`, any         tasks wrapped in the `prefect.utilities.tasks.unmapped` container will         _not_ be mapped over.     </li><li class="args">`validate (bool, optional)`: Whether or not to check the validity of         the flow (e.g., presence of cycles).  Defaults to the value of `eager_edge_validation`         in your prefect configuration file.</li></ul>**Returns**:     <ul class="args"><li class="args">None</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-set-reference-tasks'><p class="prefect-class">prefect.core.flow.Flow.set_reference_tasks</p>(tasks)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L409">[source]</a></span></div>
<p class="methods">Sets the `reference_tasks` for the flow. See `flow.reference_tasks` for more details.<br><br>**Args**:     <ul class="args"><li class="args">`tasks ([Task])`: the tasks that should be set as a flow's reference tasks</li></ul>**Returns**:     <ul class="args"><li class="args">None</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-sorted-tasks'><p class="prefect-class">prefect.core.flow.Flow.sorted_tasks</p>(root_tasks=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L696">[source]</a></span></div>
<p class="methods">Get the tasks in this flow in a sorted manner. This allows us to find if any cycles exist in this flow's DAG.<br><br>**Args**:     <ul class="args"><li class="args">`root_tasks ([Tasks], optional)`: an `Iterable` of `Task` objects to     start the sorting from</li></ul>**Returns**:     <ul class="args"><li class="args">tuple of task objects that were sorted</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if a cycle is found in the flow's DAG</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-terminal-tasks'><p class="prefect-class">prefect.core.flow.Flow.terminal_tasks</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L362">[source]</a></span></div>
<p class="methods">Get the tasks in the flow that have no downstream dependencies<br><br>**Returns**:     <ul class="args"><li class="args">set of Task objects that have no downstream dependencies</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-to-environment-file'><p class="prefect-class">prefect.core.flow.Flow.to_environment_file</p>(path)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L1112">[source]</a></span></div>
<p class="methods">Serializes the flow as an environment file.<br><br>**Args**:     <ul class="args"><li class="args">`path (str)`: the path of the environment file to create</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-update'><p class="prefect-class">prefect.core.flow.Flow.update</p>(flow, validate=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L555">[source]</a></span></div>
<p class="methods">Take all tasks and edges in another flow and add it to this flow<br><br>**Args**:     <ul class="args"><li class="args">`flow (Flow)`: A flow which is used to update this flow     </li><li class="args">`validate (bool, optional)`: Whether or not to check the validity of the flow</li></ul>**Returns**:     <ul class="args"><li class="args">None</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-upstream-tasks'><p class="prefect-class">prefect.core.flow.Flow.upstream_tasks</p>(task)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L647">[source]</a></span></div>
<p class="methods">Get all of the tasks upstream of a task<br><br>**Args**:     <ul class="args"><li class="args">`task (Task)`: The task that we want to find upstream tasks of</li></ul>**Returns**:     <ul class="args"><li class="args">set of Task objects which are upstream of `task`</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-validate'><p class="prefect-class">prefect.core.flow.Flow.validate</p>()<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L671">[source]</a></span></div>
<p class="methods">Checks that the flow is valid.<br><br>**Returns**:     <ul class="args"><li class="args">None</li></ul>**Raises**:     <ul class="args"><li class="args">`ValueError`: if edges refer to tasks that are not in this flow     </li><li class="args">`ValueError`: if specified reference tasks are not in this flow     </li><li class="args">`ValueError`: if any tasks do not have assigned IDs</li></ul></p>|
 | <div class='method-sig' id='prefect-core-flow-flow-visualize'><p class="prefect-class">prefect.core.flow.Flow.visualize</p>(flow_state=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/core/flow.py#L1012">[source]</a></span></div>
<p class="methods">Creates graphviz object for representing the current flow; this graphviz object will be rendered inline if called from an IPython notebook, otherwise it will be rendered in a new window.<br><br>**Args**:     <ul class="args"><li class="args">`flow_state (State, optional)`: flow state object used to optionally color the nodes</li></ul>**Raises**:     <ul class="args"><li class="args">`ImportError`: if `graphviz` is not installed</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>by Prefect 0.5.0 on March 29, 2019 at 17:39 UTC</p>
