(function() {
  let prefixes = [
    'Accessibility',
    'Async',
    'Background',
    'Browser',
    'Child',
    'Common',
    'Core',
    'Internal',
    'Main',
    'Mock',
    'Platform',
    'Private',
    'Render',
    'Root',
    'Scoped',
    'Session',
    'Shared',
    'Stub',
    'Synchronous',
    'Test',
    'Web',
  ];

  let bases = [
    'Audio',
    'Auth',
    'Authentication',
    'Blob',
    'Bluetooth',
    'Box',
    'Cache',
    'Capture',
    'Compositor',
    'Connection',
    'Contents',
    'Context',
    'Cookie',
    'Cursor',
    'Devtools',
    'Download',
    'Drag',
    'Endpoint',
    'Execution',
    'File',
    'Frame',
    'Gesture',
    'Graphics',
    'Handle',
    'Handler',
    'Index',
    'Intersection',
    'Keyboard',
    'Layer',
    'Layout',
    'Loader',
    'Loop',
    'Mailbox',
    'Media',
    'Metrics',
    'Mouse',
    'Navigation',
    'Network',
    'Node',
    'Package',
    'Paint',
    'Partition',
    'Player',
    'Process',
    'Queue',
    'Quota',
    'Registry',
    'Request',
    'Response',
    'Sandbox',
    'Selection',
    'Service',
    'Site',
    'Storage',
    'Stream',
    'Tab',
    'Task',
    'Texture',
    'Theme',
    'Thread',
    'Throttling',
    'Tool',
    'Touch',
    'Tracker',
    'Transaction',
    'URL',
    'Video',
    'Widget',
    'Window',
    'Worker',
  ];

  let suffixes = [
    'Client',
    'Connector',
    'Delegate',
    'Dispatcher',
    'Factory',
    'FactoryFactory',
    'Helper',
    'Host',
    'Impl',
    'Injection',
    'Instance',
    'Mananger',
    'Monitor',
    'Observer',
    'Protocol',
    'Provider',
    'Proxy',
    'Reader',
    'Receiver',
    'Scope',
    'State',
    'Tree',
    'Util',
    'View',
    'Writer',
  ];

  window.generateChromeClassName = () => {
    let s = "";
    let count = Math.round(Math.random() * 2);
    for (let j = 0; j < count; j++)
      s += prefixes[Math.floor(Math.random() * prefixes.length)];
    count = Math.ceil(Math.random() * 3);
    for (let j = 0; j < count; j++)
      s += bases[Math.floor(Math.random() * bases.length)];
    count = Math.round(Math.random() * 4);
    for (let j = 0; j < count; j++)
      s += suffixes[Math.floor(Math.random() * suffixes.length)];
    return s;
  };
})();
