/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/. */

// https://w3c.github.io/webcrypto/#cryptokey-interface

enum KeyType { "public", "private", "secret" };

enum KeyUsage { "encrypt", "decrypt", "sign", "verify", "deriveKey", "deriveBits", "wrapKey", "unwrapKey" };

[SecureContext, Exposed=(Window,Worker), /*Serializable,*/ Pref="dom_crypto_subtle_enabled"]
interface CryptoKey {
  readonly attribute KeyType type;
  readonly attribute boolean extractable;
  readonly attribute object algorithm;
  readonly attribute object usages;
};

// https://w3c.github.io/webcrypto/#dfn-CryptoKeyPair

dictionary CryptoKeyPair {
  CryptoKey publicKey;
  CryptoKey privateKey;
};
