// META: script=/resources/testdriver.js?feature=bidi
// META: script=/resources/testdriver-vendor.js
// META: script=/common/gc.js
// META: script=/bluetooth/resources/bluetooth-test.js
// META: script=/bluetooth/resources/bluetooth-fake-devices.js
// META: timeout=long
// Generated by
// //bluetooth/bidi/generate.py
'use strict';
const test_desc = 'disconnect() called during a getPrimaryServices call that ' +
    'succeeds. Reject with NetworkError.';
const expected = new DOMException(
    'GATT Server is disconnected. Cannot retrieve services. (Re)connect ' +
        'first with `device.gatt.connect`.',
    'NetworkError');

bluetooth_bidi_test(
    () => getHealthThermometerDevice({
            filters: [{services: ['health_thermometer']}],
            optionalServices: ['generic_access']
          }).then(({device}) => {
      let promise = assert_promise_rejects_with_message(
          device.gatt.getPrimaryServices(), expected);
      device.gatt.disconnect();
      return promise;
    }),
    test_desc);
