/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/. */

// https://encoding.spec.whatwg.org/#interface-textdecoder
dictionary TextDecoderOptions {
  boolean fatal = false;
  boolean ignoreBOM = false;
};

dictionary TextDecodeOptions {
  boolean stream = false;
};

[Exposed=(Window,Worker)]
interface TextDecoder {
  [Throws] constructor(optional DOMString label = "utf-8", optional TextDecoderOptions options = {});

  [Throws]
  USVString decode(optional BufferSource input, optional TextDecodeOptions options = {});
};
TextDecoder includes TextDecoderCommon;
