package org.jruby.ext.ripper;

public class YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          200,  200,  273,   91,  276,  256,  256,  439,  307,  256, 
          623,  653,  635,  419,  652,  376,  101,  652,  199,  275, 
          270,  200,  240,  287,  546,  611,  118,  118,  522,    8, 
          576,  269,  547,  234,  237,  280,  118,  559,  475,    8, 
          213,  476,  215,  524,  584,  303,  200,  653,  292,  296, 
          566,  572,  286,  579,  580,  272,  610,  260,  260,  866, 
          213,  260,  215,  327,  313,  505,  236,  499,  359,   81, 
          505,  118,  798,  387,  326,  641,  605,  632,   72,  368, 
          505,  710,  272,  559,  381,  295,  559,  559,    8,  294, 
          297,  646,  676,  236,  560,  259,  259,  566,  572,  259, 
          559,  524,  522,  863,  505,   84,  679,  250,  803,  805, 
          240,  605,   84,  236,  118,  235,  269,  713,  409,  505, 
           81,  286,   70,   73,  324,  326,  559,  293,  391,   70, 
          792,   71,  519,  559,  559,  252,  559,  380,  465,  518, 
          554,  324,  235,  282,  605,  675,  813,  251,  499,  559, 
          524,   79,  263,  928,  352,   77,  698,  379,  554,  236, 
           78,   78,  235,  345,  350,  605,  519,  409,  559,  353, 
          472,  348,  351,   74,   73,  559,  346,  315,  472,  912, 
          866,  519,   69,  559,  268,  349,  385,   82,  596,  347, 
          386,   75,  499,  375,  439,  559,  485,  486,  487,   80, 
          735,  272,   79,  488,  471,  325,   77,  491,  235,  494, 
          824,  497,  474,  522,  618,  500,  829,  511,  265,  928, 
          501,  404,  325,  479,   74,  699,  315,  591,  940,  375, 
          653,  741,  511,  240,  740,  652,  652,  559,   82,  764, 
          268,  499,   75,   78,  559,  746,  375,  798,  240,  883, 
           80,  559,  369,  763,  278,  256,  961,  256,  256,  370, 
          408,  559,  375,  287,  424,  425,  817,  770,  338,  445, 
           83,   83,  119,  119,  284,  803,   83,  228,  228,  228, 
          407,  805,  244,  228,  228,  459,  398,  228,  431,  432, 
          433,  803,  286,  399,   78,  420,  779,  434,  499,  353, 
           76,  559,  434,  355,  356,  781,  782,  260,  783,  260, 
          559,  318,  388,   83,  228,  320,  366,  301,  522,  228, 
          450,   53,  118,  367,  690,  257,  263,  373,  581,  264, 
          585,  622,  364,  421,  595,  598,  372,  467,   81,  469, 
           70,  559,  524,  371,  835,  259,  559,  259,  559,  499, 
          559,   76,  287,  609,  529,  530,  531,  532,  256,  377, 
          301,  574,  336,  337,  638,  505,  280,  359,  378,  445, 
          410,  593,   59,   60,  271,  409,  568,  402,  401,  505, 
          228,  286,   83,  559,  256,  271,  546,  574,  559,  559, 
          680,    8,   73,  600,  547,  445,  524,  118,  773,  602, 
           81,  505,  568,  584,  621,  256,  624,  479,  574,   72, 
          588,  812,  389,  777,  597,  767,  445,  559,  626,  256, 
           79,  859,  574,  568,   77,  560,  634,  519,  560,  744, 
          445,  559,  524,  653,  505,  640,  640,  568,  250,  652, 
          619,  250,   74,  101,  485,  486,  409,  660,  907,  200, 
           14,  488,  559,  590,   73,  574,   82,  590,  588,   91, 
           75,  905,   71,  519,  559,  524,  252,  897,   80,  252, 
          568,  648,  650,  256,  282,  295,  574,  651,  251,  499, 
          519,  251,   79,  590,  445,  352,   77,   83,  213,  654, 
          215,  568,  101,  533,  345,  350,  519,  658,  659,   14, 
          353,  636,  348,  351,   74,  403,  118,  346,  650,  228, 
          228,  295,   78,  669,  667,  479,  349,  668,   82,  696, 
          347,  773,   75,  559,  537,  285,  709,  709,  931,  849, 
           80,  511,  409,  228,  788,  228,  228,  712,   78,  228, 
          285,  228,   90,   90,  499,  406,   83,  522,   90,  416, 
          686,  418,  725,   83,  246,  559,  417,  958,  559,  559, 
          559,  705,  423,  709,  936,  717,  625,  719,  301,   76, 
           95,  723,  285,  421,   78,  440,  716,  443,  726,  728, 
          719,  719,  722,  426,  605,   90,  725,  430,   16,  716, 
          716,  394,  434,  778,  706,  282,  283,   97,  435,  228, 
          228,  228,  228,   83,  228,  228,  719,  559,  725,  748, 
          200,  200,  738,  499,  118,  716,   78,  285,  722,  236, 
          730,  751,  725,  458,  755,  745,  739,  624,  747,  752, 
          904,   76,  559,  336,  337,  624,  228,   16,  438,  228, 
          734,  228,   83,  301,  277,  228,  228,  338,   83,  462, 
          213,  725,  215,  766,   90,  382,  383,  756,  622,  479, 
          464,  743,  228,   83,  228,  559,  559,  452,  235,  463, 
          771,  820,  822,  470,  100,  477,   83,  825,  827,   83, 
          466,  559,  478,  228,  780,  484,  772,   83,  495,  585, 
          499,  696,  118,  650,  295,  527,  559,  228,  774,  594, 
          101,  456,   14,   14,   14,  799,  800,  696,   14,   14, 
          775,   14,  709,  537,  622,  815,  627,  816,  415,  786, 
          819,  727,  729,  100,  228,  637,   83,  686,  789,  655, 
          485,  486,  490,  429,  453,  454,  656,  488,  791,  106, 
           64,   64,  657,  663,  670,  559,   64,   64,   64,   64, 
          838,  228,  301,   64,   64,  399,  681,   64,  118,   90, 
          850,  537,  682,  691,  913,  692,  693,  695,  537,  701, 
          834,  118,   97,  537,  856,  857,  858,  703,  415,  851, 
          714,   14,  640,   64,   64,  269,  733,  894,  106,   64, 
          485,  486,  492,  840,  537,  269,  683,  488,  503,  504, 
          505,  506,   14,  855,  715,  104,   97,  559,  559,  285, 
          696,  720,  559,  559,  721,  732,  285,  559,   90,  736, 
          277,  538,  483,   97,  891,   90,  742,  338,  392,  264, 
          749,  686,  106,  686,  753,  393,  862,  765,  759,  285, 
           16,   16,   16,  760,  269,  761,   16,   16,  762,   16, 
           64,  103,   64,  277,  285,  776,  903,  624,  353,  818, 
          301,  285,  355,  356,  357,  358,  538,  485,  486,  496, 
          896,  228,   83,  790,  488,   90,  410,   15,  830,  831, 
          839,  277,  841,   83,  559,  559,  559,  852,  277,  853, 
           83,  559,  256,  854,  102,  574,  860,  295,  861,  864, 
          103,  867,  118,  445,  404,  868,  902,  686,  914,  870, 
          568,  938,  725,  589,   90,  228,  871,  939,  872,   16, 
           90,  394,   87,   87,  120,  120,   15,  873,   87,  875, 
          877,  100,  538,  880,  245,   90,  881,  884,  301,  624, 
           16,  886,  574,  102,  399,   83,  888,  889,   90,  559, 
          559,   90,  890,  893,  686,  413,  686,   64,  899,   90, 
           89,  104,  414,  908,  923,   87,   83,   83,  909,  302, 
          427,  911,   90,  929,  930,  541,   83,  428,   83,   64, 
           64,   83,  228,  228,  686,  941,  943,  947,  228,  228, 
          950,  952,  399,  954,  957,  559,  106,  971,   90,  399, 
          228,  960,   98,   64,  301,   64,   64,  473,  559,   64, 
          104,   64,  302,  548,  546,  460,   64,  844,  547,  474, 
          548,   83,  461,   64,  228,  399,  683,  552,  503,  504, 
          505,  506,  552,  548,   87,   83,   83,   83,  438,  438, 
          438,   97,  285,   92,  559,  438,  554,  269,  269,  269, 
          548,   98,  269,  269,  269,  263,  269,  277,  559,  481, 
          428,  428,  428,   92,  277,  263,  482,  428,  329,   64, 
           64,   64,   64,   64,   64,   64,  559,   92,  269,  269, 
          269,  269,  269,  473,  316,   83,  485,  486,  123,  959, 
          277,  202,  898,  488,   92,   96,  493,  277,  228,  263, 
          226,  226,  226,   97,  802,   83,   64,  925,  103,   64, 
          537,   64,   64,  330,  263,   64,   64,   83,   64,  247, 
          787,  538,  937,  269,  537,  915,  269,  662,    0,   15, 
           15,   15,   64,   64,   64,   15,   15,  289,   15,   87, 
            0,    0,  286,  900,   90,    0,   64,  269,  921,   64, 
          901,  102,    0,   64,    0,   90,    0,   64,  392,    0, 
            0,    0,   90,    0,  541,  948,   83,   64,    0,  538, 
          228,    0,   83,    0,    0,    0,  538,    0,   83,    0, 
            0,  538,    0,    0,    0,   96,   96,  121,  121,  121, 
            0,   96,   99,    0,   64,   98,   64,  249,   87,    0, 
            0,    0,  538,  384,    0,   87,    0,   99,   15,    0, 
            0,    0,  541,    0,    0,   94,    0,   90,  104,  541, 
          302,   64,    0,    0,  537,  105,    0,    0,   96,   15, 
            0,    0,  304,  267,    0,    0,    0,    0,   90,   90, 
            0,   99,    0,  267,  473,  541,    0,    0,   90,   94, 
           90,  473,    0,   90,   95,   87,  474,    0,    0,   98, 
            0,    0,    0,  474,    0,  795,   94,  503,  504,  505, 
          506,    0,  589,  474,  105,  304,    0,  265,    0,  285, 
          801,    0,  804,    0,    0,  808,  285,    0,   95,  846, 
            0,  538,  267,   90,   87,  302,  538,   96,  101,  537, 
           87,    0,    0,    0,    0,   95,  286,   90,   90,   90, 
            0,    0,   92,  537,  183,   87,    0,  263,  263,  263, 
          473,    0,  263,  263,  263,    0,  263,  473,   87,    0, 
          105,   87,  226,  226,    0,  285,  263,  263,    0,   87, 
            0,   64,   64,    0,    0,  263,  263,  537,  263,  263, 
          263,  263,  263,   64,  537,    0,    0,   90,    0,  537, 
           64,  537,  449,  183,  451,    0,    0,    0,  537,    0, 
            0,    0,    0,  537,   92,    0,    0,   90,   87,  286, 
          537,    0,    0,    0,    0,   64,  286,   94,    0,   90, 
            0,    0,   93,    0,  537,    0,  263,    0,    0,  263, 
            0,  263,   96,    0,  302,  331,  332,  333,  334,  335, 
            0,   89,    0,    0,    0,   64,    0,  263,    0,    0, 
            0,    0,  226,  226,  226,  226,   93,  534,  535,   97, 
           97,  122,  122,  122,  538,   97,   64,   64,   90,    0, 
            0,  250,    0,   93,   90,   89,   64,    0,   64,   99, 
           90,   64,   64,   64,  917,    0,  541,    0,   64,   64, 
            0,   96,   89,  924,    0,  926,    0,    0,   96,    0, 
           64,  541,   97,  541,    0,    0,  305,    0,    0,    0, 
            0,   91,  105,  304,   94,  538,   90,  612,    0,    0, 
            0,   64,  473,    0,   64,  267,  267,  267,    0,    0, 
          267,  267,  267,  541,  267,   64,   64,   64,   95,   95, 
          474,    0,  302,    0,   95,   91,    0,  474,   96,  305, 
           90,    0,    0,   95,   87,   96,  267,  267,  267,  267, 
          267,  966,   91,  538,    0,   87,    0,   90,    0,    0, 
          538,   97,   87,  286,    0,  538,   94,  661,    0,    0, 
          286,   95,    0,   93,    0,   64,    0,   96,  304,   96, 
            0,   91,  399,   96,    0,    0,  538,  474,   64,    0, 
            0,  267,  285,    0,  267,   64,   96,    0,   96,  285, 
            0,  702,  704,    0,  538,   95,    0,   64,    0,    0, 
          302,   96,    0,    0,   96,  267,    0,   87,  785,    0, 
          541,    0,   96,    0,    0,    0,  286,    0,  399,    0, 
          183,    0,  183,  183,  183,  183,    0,    0,   87,   87, 
           95,    0,  103,  538,    0,    0,    0,    0,   87,    0, 
           87,    0,  467,   87,    0,    0,   64,    0,    0,  467, 
           64,   96,   64,  183,  183,    0,   97,    0,   64,    0, 
            0,  183,  183,  183,  183,    0,  302,    0,    0,    0, 
            0,   93,  541,    0,    0,  338,    0,  304,    0,  845, 
            0,  538,    0,   87,    0,    0,   49,    0,  538,    0, 
           89,  351,  352,  538,    0,    0,   49,   87,   87,   87, 
            0,    0,  541,    0,  226,    0,  353,    0,  354,    0, 
          355,  356,  357,  358,  538,   97,  361,    0,  362,    0, 
          541,    0,   97,    0,    0,    0,  683,  541,  503,  504, 
          505,  506,  537,   93,    0,   95,    0,  305,  683,  473, 
          503,  504,  505,  506,    0,   49,  473,   87,  226,    0, 
          541,    0,   89,  541,    0,    0,    0,  541,    0,  507, 
           91,  399,  537,    0,    0,   90,    0,   87,    0,  511, 
          512,  684,   97,    0,    0,    0,    0,    0,    0,   87, 
          541,    0,    0,  541,    0,  304,    0,    0,    0,    0, 
            0,    0,    0,   51,   95,    0,    0,   96,  102,  541, 
            0,   95,    0,   51,   96,    0,  100,  399,   96,  399, 
          120,   97,  305,    0,  474,   96,  399,   97,    0,    0, 
            0,  474,   91,    0,    0,    0,    0,   90,   87,    0, 
            0,    0,   97,    0,   87,    0,    0,    0,    0,    0, 
           87,    0,  399,    0,    0,   97,    0,  541,   97,    0, 
            0,   95,   51,  286,  541,  399,   97,  226,    0,  537, 
          286,    0,  399,  304,  869,    0,   96,    0,    0,    0, 
           96,    0,  874,  876,  695,  878,    0,  879,    0,  882, 
          541,  885,  887,    0,    0,    0,    0,    0,  399,    0, 
           95,   96,   96,    0,    0,   97,   95,    0,    0,    0, 
            0,   96,  176,   96,    0,    0,   96,    0,    0,    0, 
            0,   95,    0,  546,  546,  546,   50,    0,    0,  546, 
          546,  305,  546,    0,   95,    0,   50,   95,    0,  304, 
            0,    0,  547,  547,  547,   95,    0,    0,  547,  547, 
            0,  547,  847,    0,    0,    0,   96,    0,   49,   49, 
           49,  176,    0,   49,   49,   49,    0,   49,    0,    0, 
           96,   96,   96,    0,    0,    0,  683,   49,  503,  504, 
          505,  506,    0,    0,   95,   50,   49,   49,    0,   49, 
           49,   49,   49,   49,    0,    0,    0,  942,  944,  945, 
          946,  186,  546,  949,    0,  951,  953,  955,  956,  684, 
            0,    0,    0,    0,    0,    0,    0,  685,    0,    0, 
           96,  547,  683,  546,  503,  504,  505,  506,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   49,    0,  305, 
           96,    0,  547,  969,    0,    0,  970,  972,  973,  974, 
          186,   97,   96,  255,  255,  684,  976,  255,   49,    0, 
            0,    0,   97,  865,    0,   51,   51,   51,    0,   97, 
           51,   51,   51,    0,   51,    0,    0,    0,    0,  279, 
          281,    0,    0,  121,   51,  255,  255,    0,  306,  308, 
            0,    0,    0,   51,   51,    0,   51,   51,   51,   51, 
           51,   96,    0,    0,    0,    0,    0,   96,    0,    0, 
            0,    0,    0,   96,    0,    0,    0,  305,    0,    0, 
            0,    0,    0,    0,   97,    0,    0,    0,    0,    0, 
           95,  807,    0,  503,  504,  505,  506,    0,    0,    0, 
            0,   95,    0,    0,   51,   97,   97,    0,   95,    0, 
          171,    0,    0,    0,    0,   97,    0,   97,    0,    0, 
           97,    0,    0,    0,  507,   51,    0,    0,    0,    0, 
            0,    0,  509,  510,  511,  512,    0,    0,    0,    0, 
            0,    0,    0,  305,    0,    0,    0,    0,   50,   50, 
           50,    0,    0,   50,   50,   50,  848,   50,    0,  171, 
           97,    0,    0,   95,    0,    0,    0,   50,  176,    0, 
          176,  176,  176,  176,   97,   97,   97,    0,    0,   50, 
           50,   50,   50,   50,   95,   95,    0,    0,    0,    0, 
          466,    0,    0,    0,   95,    0,   95,  466,  338,   95, 
            0,  176,  176,    0,    0,    0,    0,    0,    0,  176, 
          176,  176,  176,    0,  351,  352,    0,    0,    0,    0, 
            0,  559,    0,    0,   97,    0,    0,   50,    0,  353, 
            0,  559,    0,  355,  356,  357,  358,    0,    0,   95, 
            0,    0,    0,    0,   97,    0,    0,    0,   50,  255, 
          255,  255,  308,   95,   95,   95,   97,  186,    0,  186, 
          186,  186,  186,  255,    0,  255,  255,    0,    0,    0, 
            0,    0,    0,    0,  457,    0,    0,  338,    0,  468, 
          559,    0,    0,    0,    0,    0,  468,  122,    0,    0, 
          186,  186,    0,  351,  352,    0,    0,    0,  186,  186, 
          186,  186,    0,   95,    0,   97,    0,    0,  353,    0, 
          354,   97,  355,  356,  357,  358,    0,   97,    0,  153, 
            0,    0,    0,   95,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   95,  536,  537,  538,  539, 
          540,  541,  542,  543,  544,  545,  546,  547,  548,  549, 
          550,  551,  552,  553,  554,  555,  556,  557,  558,  559, 
          560,  561,    0,    0,    0,    0,  255,    0,  153,  582, 
            0,  586,    0,    0,    0,  255,  599,    0,    0,    0, 
            0,    0,    0,    0,   95,    0,    0,    0,    0,    0, 
           95,    0,  255,    0,    0,    0,   95,    0,    0,    0, 
            0,  255,    0,    0,    0,    0,  171,  265,  171,  171, 
          171,  171,    0,  255,  582,  633,  599,  265,    0,  255, 
            0,    0,    0,    0,    0,    0,    0,  255,  469,    0, 
            0,    0,  255,  255,    0,  469,  255,    0,    0,  171, 
          171,    0,    0,    0,    0,    0,    0,  171,  171,  171, 
          171,  265,    0,    0,    0,    0,    0,    0,    0,    0, 
          664,  665,  666,    0,    0,    0,  265,    0,    0,  255, 
            0,    0,  255,    0,    0,    0,    0,    0,  258,  258, 
          258,  255,  258,  559,  559,  559,  258,  258,  559,  559, 
          559,  258,  559,  258,  258,  258,  258,  258,  258,  258, 
            0,    0,  559,    0,  258,  258,  258,  258,  258,  258, 
          258,  559,  559,  258,  559,  559,  559,  559,  559,    0, 
          258,    0,    0,  258,  258,  258,    0,  258,  258,  258, 
          258,  258,  258,  258,  258,  258,  258,  258,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  363,  559, 
            0,    0,    0,    0,    0,    0,  559,  258,    0,    0, 
          258,    0,  559,  258,  258,    0,  258,    0,  258,    0, 
          258,    0,  258,    0,    0,    0,    0,    0,    0,    0, 
          258,  255,    0,  559,    0,  258,  258,  258,  258,  258, 
          258,    0,    0,    0,  258,    0,  258,  258,    0,  258, 
          258,    0,  461,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  461,    0,    0,  153,    0,  153,  153,  153, 
          153,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  471,    0,    0, 
            0,    0,    0,    0,  471,    0,  461,  255,  153,  153, 
            0,    0,    0,    0,  255,  255,  153,  153,  153,  153, 
          461,  461,    0,  461,    0,  461,    0,    0,    0,  265, 
          265,  265,    0,    0,  265,  265,  265,    0,  265,    0, 
          255,  502,    0,  503,  504,  505,  506,    0,  265,  265, 
            0,    0,    0,  461,    0,    0,    0,  265,  265,    0, 
          265,  265,  265,  265,  265,    0,    0,    0,    0,    0, 
            0,    0,  821,  823,  507,  508,    0,    0,  826,  828, 
            0,    0,  509,  510,  511,  512,  464,    0,    0,  832, 
          633,  255,    0,    0,    0,  836,  464,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  265,    0, 
            0,  265,    0,  265,    0,    0,    0,  821,  823,  826, 
          828,    0,    0,    0,  255,    0,    0,    0,    0,  265, 
          464,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  731,    0,  464,  464,    0,  464,    0,  464, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  272,  338,  339,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,    0,  349,  350,  892,  464,  351,  352, 
            0,    0,    0,    0,    0,    0,    0,    0,  895,    0, 
            0,  255,    0,  353,    0,  354,    0,  355,  356,  357, 
          358,  359,  360,  361,    0,  362,    0,    0,    0,    0, 
            0,  895,    0,    0,  363,    0,    0,    0,  255,  534, 
          534,  534,    0,  534,  461,  461,  461,  534,  534,  461, 
          461,  461,  534,  461,  534,  534,  534,  534,  534,  534, 
          534,  461,  534,  461,  461,  534,  534,  534,  534,  534, 
          534,  534,  461,  461,  534,  461,  461,  461,  461,  461, 
          255,  534,    0,    0,  534,  534,  534,  461,  534,  534, 
          534,  534,  534,  534,  534,  534,  534,  534,  534,  461, 
          461,  461,  461,  461,  461,  461,  461,  461,  461,  461, 
          461,  461,  461,    0,    0,  461,  461,  461,  534,  461, 
          461,  534,  534,  461,  534,  534,  461,  534,  461,  534, 
          461,  534,  461,  534,  461,  461,  461,  461,  461,  461, 
          461,  534,  461,  534,  461,    0,  534,  534,  534,  534, 
          534,  534,    0,    0,    0,  534,  461,  534,  534,  363, 
          534,  534,    0,  535,  535,  535,    0,  535,  464,  464, 
          464,  535,  535,  464,  464,  464,  535,  464,  535,  535, 
          535,  535,  535,  535,  535,  464,  535,  464,  464,  535, 
          535,  535,  535,  535,  535,  535,  464,  464,  535,  464, 
          464,  464,  464,  464,    0,  535,    0,    0,  535,  535, 
          535,  464,  535,  535,  535,  535,  535,  535,  535,  535, 
          535,  535,  535,  464,  464,  464,  464,  464,  464,  464, 
          464,  464,  464,  464,  464,  464,  464,    0,    0,  464, 
          464,  464,  535,  464,  464,  535,  535,  464,  535,  535, 
          464,  535,  464,  535,  464,  535,  464,  535,  464,  464, 
          464,  464,  464,  464,  464,  535,  464,  535,  464,    0, 
          535,  535,  535,  535,  535,  535,  537,    0,    0,  535, 
          464,  535,  535,    0,  535,  535,  537,    0,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,    0, 
          349,  350,    0,    0,  351,  352,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  353, 
          537,  354,    0,  355,  356,  357,  358,  359,  360,  361, 
            0,  362,  563,  564,  537,  537,  565,  101,    0,  537, 
          169,  170,    0,  171,  172,  173,  174,  175,  176,  177, 
            0,    0,  178,  179,    0,    0,    0,  180,  181,  182, 
          183,    0,    0,    0,    0,    0,  268,  537,    0,    0, 
            0,    0,    0,  185,  186,    0,  187,  188,  189,  190, 
          191,  192,  193,  194,  195,  196,  197,    0,    0,  198, 
            0,    0,    0,  737,    0,    0,    0,    0,  502,  538, 
          503,  504,  505,  506,    0,    0,    0,    0,    0,  538, 
            0,    0,    0,  338,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,    0,  349,  350,    0,    0,  351, 
          352,  507,  613,    0,    0,    0,    0,    0,    0,  509, 
          510,  511,  512,  538,  353,    0,  354,    0,  355,  356, 
          357,  358,  359,  360,  361,    0,  362,  538,  538,    0, 
          103,    0,  538,    0,    0,    0,  569,  570,    0,    0, 
          571,    0,    0,    0,  169,  170,    0,  171,  172,  173, 
          174,  175,  176,  177,    0,    0,  178,  179,    0,    0, 
          538,  180,  181,  182,  183,    0,    0,    0,    0,    0, 
          268,    0,    0,    0,    0,    0,  154,  185,  186,    0, 
          187,  188,  189,  190,  191,  192,  193,  194,  195,  196, 
          197,    0,    0,  198,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  537,  537,  537,    0,  537,  537,  537, 
          537,  537,  537,  537,  537,  537,  537,  537,  537,  537, 
          537,  537,  537,  537,  537,  154,  537,  537,  537,  537, 
          537,  537,  537,  537,  537,  537,  537,  537,  537,  537, 
          537,  537,  537,  537,    0,  537,    0,    0,  537,  537, 
          537,  537,  537,  537,  537,  537,  537,  537,  537,  537, 
          537,  537,  537,  537,  537,  537,  537,  537,  537,  537, 
          537,  537,  537,  537,  537,  537,  537,    0,    0,  537, 
          537,  537,  537,    0,  537,  537,  537,  537,  537,  537, 
          537,  537,  537,  537,  537,  537,  537,  537,  537,  537, 
          537,  537,  537,  537,  537,  537,  537,  537,  537,    0, 
          537,  537,  537,  537,  537,  537,    0,    0,  155,  537, 
          537,  537,  537,    0,  537,  537,  538,  538,  538,    0, 
          538,  538,  538,  538,  538,  538,  538,  538,  538,  538, 
          538,  538,  538,  538,  538,  538,  538,  538,    0,  538, 
          538,  538,  538,  538,  538,  538,  538,  538,  538,  538, 
          538,  538,  538,  538,  538,  538,  538,  155,  538,    0, 
            0,  538,  538,  538,  538,  538,  538,  538,  538,  538, 
          538,  538,  538,  538,  538,  538,  538,  538,  538,  538, 
          538,  538,  538,  538,  538,  538,  538,  538,  538,  538, 
            0,    0,  538,  538,  538,  538,    0,  538,  538,  538, 
          538,  538,  538,  538,  538,  538,  538,  538,  538,  538, 
          538,  538,  538,  538,  538,  538,  538,  538,  538,  538, 
          538,  538,    0,  538,  538,  538,  538,  538,  538,  541, 
            0,    0,  538,  538,  538,  538,    0,  538,  538,  541, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  502,    0,  503,  504, 
          505,  506,  154,    0,  154,  154,  154,  154,    0,    0, 
            0,    0,    0,  541,  807,    0,  503,  504,  505,  506, 
            0,    0,    0,    0,  470,    0,    0,  541,  541,  507, 
          102,  470,  541,    0,    0,  154,  154,  509,  510,  511, 
          512,    0,    0,  154,  154,  154,  154,  507,    0,    0, 
            0,    0,    0,    0,    0,  509,  510,  511,  512,    0, 
          541,    0,  577,  564,    0,    0,  578,    0,    0,    0, 
          169,  170,    0,  171,  172,  173,  174,  175,  176,  177, 
            0,    0,  178,  179,    0,    0,    0,  180,  181,  182, 
          183,    0,  278,    0,    0,    0,  268,    0,    0,    0, 
            0,    0,  278,  185,  186,    0,  187,  188,  189,  190, 
          191,  192,  193,  194,  195,  196,  197,    0,    0,  198, 
            0,  338,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,    0,    0,    0,    0,  278,  351,  352,    0, 
            0,    0,    0,    0,  155,    0,  155,  155,  155,  155, 
          278,  278,  353,    0,  354,  278,  355,  356,  357,  358, 
          359,  360,  361,  338,  362,    0,  472,    0,  343,  344, 
            0,    0,    0,  472,    0,    0,    0,  155,  155,  351, 
          352,    0,    0,  278,    0,  155,  155,  155,  155,    0, 
            0,    0,    0,    0,  353,    0,  354,    0,  355,  356, 
          357,  358,  359,  360,  361,    0,  362,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  537,  537,  537,    0, 
          537,  541,  541,  541,  537,  537,  541,  541,  541,  537, 
          541,  537,  537,  537,  537,  537,  537,  537,    0,  541, 
          541,  541,  537,  537,  537,  537,  537,  537,  537,  541, 
          541,  537,  541,  541,  541,  541,  541,  272,  537,    0, 
            0,  537,  537,  537,  541,  537,  537,  537,  537,  537, 
          537,  537,  537,  537,  537,  537,  541,  541,  541,  541, 
          541,  541,  541,  541,  541,  541,  541,  541,  541,  541, 
            0,    0,  541,  541,  541,  537,    0,  541,  537,  537, 
          541,  537,  537,  541,  537,  541,  537,  541,  537,  541, 
          537,  541,  541,  541,  541,  541,  541,  541,  537,  541, 
          541,  541,    0,  537,  537,  537,  537,  537,  537,    0, 
            0,  112,  537,  541,  537,  537,    0,  537,  537,  536, 
          536,  536,    0,  536,  278,  278,  278,  536,  536,  278, 
          278,  278,  536,  278,  536,  536,  536,  536,  536,  536, 
          536,    0,  536,  278,  278,  536,  536,  536,  536,  536, 
          536,  536,  278,  278,  536,  278,  278,  278,  278,  278, 
          112,  536,    0,    0,  536,  536,  536,  278,  536,  536, 
          536,  536,  536,  536,  536,  536,  536,  536,  536,  278, 
          278,  278,  278,  278,  278,  278,  278,  278,  278,  278, 
          278,  278,  278,    0,    0,  278,  278,  278,  536,    0, 
          278,  536,  536,  278,  536,  536,  278,  536,  278,  536, 
          278,  536,  278,  536,  278,  278,  278,  278,  278,  278, 
          278,  536,  278,  536,  278,    0,  536,  536,  536,  536, 
          536,  536,  542,    0,    0,  536,  278,  536,  536,    0, 
          536,  536,  542,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  542,    0,    0,    0, 
            0,    0,    0,    0,    4,    5,    6,    0,    8,    0, 
          542,  542,    9,   10,    0,  542,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,  107, 
            0,    0,    0,  542,    0,    0,   28,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,  251, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  543,    0,    0,    0,    0, 
            0,    0,    0,  225,    0,  543,  114,    0,    0,   46, 
           47,    0,   48,    0,  252,    0,  253,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  254,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,  543, 
           58,    0,   59,   60,    0,   61,   62,  112,    0,  112, 
          112,  112,  112,  543,  543,    0,    0,    0,  543,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  461, 
            0,    0,    0,    0,    0,    0,  461,    0,    0,    0, 
          112,  112,    0,    0,    0,    0,  543,    0,  112,  112, 
          112,  112,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  113,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  539, 
          539,  539,    0,  539,  542,  542,  542,  539,  539,  542, 
          542,  542,  539,  542,  539,  539,  539,  539,  539,  539, 
          539,  113,  542,  542,  542,  539,  539,  539,  539,  539, 
          539,  539,  542,  542,  539,  542,  542,  542,  542,  542, 
            0,  539,    0,    0,  539,  539,  539,  542,  539,  539, 
          539,  539,  539,  539,  539,  539,  539,  539,  539,  542, 
          542,  542,  542,  542,  542,  542,  542,  542,  542,  542, 
          542,  542,  542,    0,    0,  542,  542,  542,  539,    0, 
          542,  539,  539,  542,  539,  539,  542,  539,  542,  539, 
          542,  539,  542,  539,  542,  542,  542,  542,  542,  542, 
          542,  539,  542,  542,  542,    0,  539,  539,  539,  539, 
          539,  539,    0,    0,    0,  539,  542,  539,  539,  363, 
          539,  539,  540,  540,  540,    0,  540,  543,  543,  543, 
          540,  540,  543,  543,  543,  540,  543,  540,  540,  540, 
          540,  540,  540,  540,    0,  543,  543,  543,  540,  540, 
          540,  540,  540,  540,  540,  543,  543,  540,  543,  543, 
          543,  543,  543,    0,  540,    0,    0,  540,  540,  540, 
          543,  540,  540,  540,  540,  540,  540,  540,  540,  540, 
          540,  540,  543,  543,  543,  543,  543,  543,  543,  543, 
          543,  543,  543,  543,  543,  543,    0,    0,  543,  543, 
          543,  540,    0,  543,  540,  540,  543,  540,  540,  543, 
          540,  543,  540,  543,  540,  543,  540,  543,  543,  543, 
          543,  543,  543,  543,  540,  543,  543,  543,    0,  540, 
          540,  540,  540,  540,  540,  285,    0,    0,  540,  543, 
          540,  540,    0,  540,  540,  285,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  113,    0, 
          113,  113,  113,  113,    0,    0,    0,    0,    0,  285, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          464,    0,    0,  285,  285,    0,  104,  464,  285,    0, 
            0,  113,  113,    0,    0,    0,    0,    0,    0,  113, 
          113,  113,  113,  338,  339,  340,  341,  342,  343,  344, 
          345,    0,  347,  348,    0,    0,  285,    0,    0,  351, 
          352,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  353,    0,  354,    0,  355,  356, 
          357,  358,  359,  360,  361,    0,  362,    0,  398,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  398,    0, 
            0,    0,    0,  338,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,    0,  349,  350,    0,    0,  351, 
          352,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  398,    0,  353,    0,  354,    0,  355,  356, 
          357,  358,  359,  360,  361,    0,  362,  398,  606,  570, 
            0,  398,  607,    0,    0,    0,  169,  170,    0,  171, 
          172,  173,  174,  175,  176,  177,    0,    0,  178,  179, 
            0,    0,    0,  180,  181,  182,  183,    0,    0,  398, 
            0,    0,  268,    0,    0,    0,    0,    0,    0,  185, 
          186,    0,  187,  188,  189,  190,  191,  192,  193,  194, 
          195,  196,  197,    0,    0,  198,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  538,  538,  538,    0,  538,  285,  285,  285, 
          538,  538,  285,  285,  285,  538,  285,  538,  538,  538, 
          538,  538,  538,  538,    0,    0,  285,  285,  538,  538, 
          538,  538,  538,  538,  538,  285,  285,  538,  285,  285, 
          285,  285,  285,  272,  538,    0,    0,  538,  538,  538, 
          285,  538,  538,  538,  538,  538,  538,  538,  538,  538, 
          538,  538,  285,  285,  285,  285,  285,  285,  285,  285, 
          285,  285,  285,  285,  285,  285,    0,    0,  285, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

          285,  285,  538,    0,  285,  538,  538,  285,  538,  538, 
          285,  538,  285,  538,  285,  538,  285,  538,  285,  285, 
          285,  285,  285,  285,  285,  538,  285,    0,  285,    0, 
          538,  538,  538,  538,  538,  538,    0,    0,    0,  538, 
          285,  538,  538,    0,  538,  538,  258,  258,  258,    0, 
          258,  398,  398,  398,  258,  258,  398,  398,  398,  258, 
          398,  258,  258,  258,  258,  258,  258,  258,    0,  398, 
          398,  398,  258,  258,  258,  258,  258,  258,  258,  398, 
          398,  258,  398,  398,  398,  398,  398,    0,  258,    0, 
            0,  258,  258,  258,    0,  258,  258,  258,  258,  258, 
          258,  258,  258,  258,  258,  258,  398,  398,  398,  398, 
          398,  398,  398,  398,  398,  398,  398,  398,  398,  398, 
            0,    0,  398,  398,  398,  258,    0,  398,  258,    0, 
          398,  258,  258,  398,  258,  398,  258,  398,  258,  398, 
          258,  398,  398,  398,  398,  398,  398,  398,  258,  398, 
          398,  398,    0,  258,  258,  258,  258,  258,  258,  559, 
            0,    0,  258,    0,  258,  258,    0,  258,  258,  559, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  559,    0,    0,    0,    0,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,    0,  559,    9, 
           10,    0,  559,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
          559,    0,    0,   28,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  292,    0,    0,    0,    0,    0,    0,    0, 
          225,    0,  292,  114,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,  292,   58,    0,   59, 
           60,    0,   61,   62,    0,  628,  564,    0,    0,  629, 
            0,  292,    0,  169,  170,  292,  171,  172,  173,  174, 
          175,  176,  177,    0,    0,  178,  179,    0,    0,    0, 
          180,  181,  182,  183,    0,    0,    0,    0,    0,  268, 
            0,    0,    0,  292,    0,    0,  185,  186,    0,  187, 
          188,  189,  190,  191,  192,  193,  194,  195,  196,  197, 
            0,    0,  198,    0,    0,    0,    0,    0,    0,    0, 
          560,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          560,    0,    0,    0,    0,    0,  258,  258,  258,    0, 
          258,  559,  559,  559,  258,  258,  559,  559,  559,  258, 
          559,  258,  258,  258,  258,  258,  258,  258,    0,  559, 
          559,  559,  258,  258,  258,  258,  258,  258,  258,  559, 
          559,  258,  559,  559,  559,  559,  559,    0,  258,  560, 
            0,  258,  258,  258,    0,  258,  258,  258,  258,  258, 
          258,  258,  258,  258,  258,  258,  559,  559,  559,  559, 
          559,  559,  559,  559,  559,  559,  559,  559,  559,  559, 
            0,    0,  559,  559,  559,  258,    0,  559,  258,    0, 
          559,  258,  258,  559,  258,  559,  258,  559,  258,  559, 
          258,  559,  559,  559,  559,  559,  559,  559,  258,  559, 
          559,  559,    0,  258,  258,  258,  258,  258,  258,    0, 
            0,    0,  258,    0,  258,  258,    0,  258,  258,  258, 
          258,  258,    0,  258,  292,  292,  292,  258,  258,  292, 
          292,  292,  258,  292,  258,  258,  258,  258,  258,  258, 
          258,    0,    0,  292,  292,  258,  258,  258,  258,  258, 
          258,  258,  292,  292,  258,  292,  292,  292,  292,  292, 
            0,  258,    0,    0,  258,  258,  258,    0,  258,  258, 
          258,  258,  258,  258,  258,  258,  258,  258,  258,  292, 
          292,  292,  292,  292,  292,  292,  292,  292,  292,  292, 
          292,  292,  292,    0,    0,  292,  292,  292,  258,    0, 
          292,  258,    0,  292,  258,  258,  292,  258,  292,  258, 
          292,  258,  292,  258,  292,  292,  292,  292,  292,  292, 
          292,  258,  292,  537,  292,    0,  258,  258,  258,  258, 
          258,  258,    0,  537,    0,  258,    0,  258,  258,    0, 
          258,  258,  560,  560,  560,    0,    0,  560,  560,  560, 
            0,  560,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  560,  560,    0,    0,    0,    0,   92,    0,    0, 
          560,  560,    0,  560,  560,  560,  560,  560,    0,    0, 
            0,    0,  537,    0,  101,    0,  537,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  537,    0,    0,    0,    0,    0, 
            0,  560,    0,    0,  560,    0,  560,    0,    0,    0, 
            0,    0,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,  560,    0,    0,   11,  538,   12,   13,   14, 
          102,  103,   17,   18,    0,    0,  538,    0,  104,  105, 
          106,   22,   23,   24,   25,    0,    0,  107,    0,    0, 
            0,    0,    0,    0,  108,    0,    0,   31,   32,   33, 
            0,  109,   35,   36,   37,  110,   39,    0,   40,    0, 
           94,  111,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  538,    0,  103,  112,  538, 
            0,  113,    0,    0,  114,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  538,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   41, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   41, 
          537,  537,  537,    0,  537,  537,  537,  537,  537,  537, 
            0,  537,  537,  537,  537,  537,  537,  537,  537,  537, 
          537,  537,    0,  537,    0,    0,  537,  537,  537,  537, 
          537,  537,  537,  537,  537,  537,  537,  537,  537,  537, 
          537,    0,  537,    0,    0,  537,  537,  537,   41,  537, 
          537,  537,  537,  537,  537,  537,  537,  537,  537,  537, 
          537,  537,  537,  537,  537,  537,  537,  537,  537,  537, 
          537,  537,  537,  537,    0,    0,  537,  537,  537,  537, 
            0,    0,  537,  537,  537,  537,  537,    0,  537,    0, 
          537,  537,  537,  537,  537,  537,  537,  537,  537,  537, 
          537,  537,  537,  537,  537,  537,    0,  537,  537,  537, 
          537,  537,  537,    0,    0,    0,  537,    0,  537,  537, 
            0,  537,  537,  538,  538,  538,    0,  538,  538,  538, 
          538,  538,  538,    0,  538,  538,  538,  538,  538,  538, 
          538,  538,  538,  538,  538,    0,  538,    0,    0,  538, 
          538,  538,  538,  538,  538,  538,  538,  538,  538,  538, 
          538,  538,  538,  538,    0,  538,    0,    0,  538,  538, 
          538,    0,  538,  538,  538,  538,  538,  538,  538,  538, 
          538,  538,  538,  538,  538,  538,  538,  538,  538,  538, 
          538,  538,  538,  538,  538,  538,  538,    0,    0,  538, 
          538,  538,  538,    0,    0,  538,  538,  538,  538,  538, 
            0,  538,    0,  538,  538,  538,  538,  538,  538,  538, 
          538,  538,  538,  538,  538,  538,  538,  538,  538,    0, 
          538,  538,  538,  538,  538,  538,  541,    0,    0,  538, 
            0,  538,  538,    0,  538,  538,  541,    0,    0,    0, 
            0,   41,   41,   41,    0,    0,    0,   41,   41,    0, 
           41,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           93,    0,   41,   41,   41,   41,   41,    0,    0,    0, 
            0,    0,    0,    0,    0,  541,    0,  102,    0,  541, 
          338,  339,  340,  341,  342,  343,  344,    0,    0,  347, 
          348,    0,    0,    0,    0,    0,  351,  352,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  541,    0,    0, 
           41,  353,    0,  354,    0,  355,  356,  357,  358,  359, 
          360,  361,    0,  362,    0,    4,    5,    6,    0,    8, 
            0,   41,    0,    9,   10,    0,    0,    0,   11,  285, 
           12,   13,   14,  102,  103,   17,   18,    0,    0,  285, 
            0,  104,  105,  106,   22,   23,   24,   25,    0,    0, 
          107,    0,    0,    0,    0,    0,    0,  108,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,    0,   95,  111,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  285,    0, 
          104,    0,  285,    0,  243,    0,    0,   45,    0,    0, 
           46,   47,    0,   48,    0,   49,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          285,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   58,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   58,    0, 
            0,    0,    0,  537,  537,  537,    0,  537,  541,  541, 
          541,  537,  537,    0,  541,  541,  537,  541,  537,  537, 
          537,  537,  537,  537,  537,    0,  541,    0,    0,  537, 
          537,  537,  537,  537,  537,  537,  541,  541,  537,  541, 
          541,  541,  541,  541,    0,  537,    0,   58,  537,  537, 
          537,    0,  537,  537,  537,  537,  537,  537,  537,  537, 
          537,  537,  537,  541,  541,  541,  541,  541,  541,  541, 
          541,  541,  541,  541,  541,  541,  541,    0,    0,  541, 
          541,  541,  537,    0,    0,  537,  537,  541,  537,  537, 
            0,  537,    0,  537,  541,  537,  541,  537,  541,  541, 
          541,  541,  541,  541,  541,  537,  541,  541,  541,    0, 
          537,  537,  537,  537,  537,  537,    0,    0,    0,  537, 
            0,  537,  537,    0,  537,  537,  538,  538,  538,    0, 
          538,  285,  285,  285,  538,  538,    0,  285,  285,  538, 
          285,  538,  538,  538,  538,  538,  538,  538,    0,    0, 
            0,    0,  538,  538,  538,  538,  538,  538,  538,  285, 
          285,  538,  285,  285,  285,  285,  285,    0,  538,    0, 
            0,  538,  538,  538,    0,  538,  538,  538,  538,  538, 
          538,  538,  538,  538,  538,  538,  285,  285,  285,  285, 
          285,  285,  285,  285,  285,  285,  285,  285,  285,  285, 
            0,    0,  285,  285,  285,  538,    0,    0,  538,  538, 
          285,  538,  538,    0,  538,    0,  538,  285,  538,  285, 
          538,  285,  285,  285,  285,  285,  285,  285,  538,  285, 
          399,  285,    0,  538,  538,  538,  538,  538,  538,    0, 
          399,    0,  538,    0,  538,  538,    0,  538,  538,    0, 
           58,   58,   58,    0,    0,   58,   58,   58,    0,   58, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   58, 
           58,    0,    0,    0,  399,    0,    0,    0,   58,   58, 
            0,   58,   58,   58,   58,   58,    0,    0,  399,  399, 
            0,  100,    0,  399,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  399,    0,    0,    0,    0,    0,    0,    0,   58, 
            0,  398,   58,    0,    0,    0,    0,    0,    0,    0, 
            0,  398,    0,    0,    0,    0,    0,    0,    0,    0, 
           58,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  102, 
          103,   17,   18,    0,    0,  398,    0,  104,  105,  106, 
           22,   23,   24,   25,    0,    0,  107,    0,    0,  398, 
          398,    0,    0,  108,  398,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,    0,    0, 
          111,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  793,  398,    0,    0,    0,    0,    0,    0,    0, 
          299,  806,    0,  374,  810,    0,   46,   47,    0,   48, 
            0,  375,    0,    0,    0,  473,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  473,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  473, 
            0,    0,  399,  399,  399,    0,    0,  399,  399,  399, 
            0,  399,    0,  473,  473,    0,   98,    0,  473,    0, 
          399,  399,  399,    0,    0,    0,    0,    0,    0,    0, 
          399,  399,    0,  399,  399,  399,  399,  399,    0,    0, 
            0,    0,    0,    0,    0,  399,  473,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  399,  399,  399, 
          399,  399,  399,  399,  399,  399,  399,  399,  399,  399, 
          399,    0,    0,  399,  399,  399,    0,    0,  399,    0, 
            0,  399,    0,    0,  399,    0,  399,    0,  399,  474, 
          399,    0,  399,  399,  399,  399,  399,  399,  399,  474, 
          399,  399,  399,  398,  398,  398,    0,    0,  398,  398, 
          398,  916,  398,  918,  399,  919,    0,    0,    0,  922, 
            0,  398,  398,  398,  927,    0,    0,    0,    0,    0, 
            0,  398,  398,  474,  398,  398,  398,  398,  398,    0, 
            0,    0,    0,    0,    0,    0,  398,  474,  474,    0, 
           99,    0,  474,    0,    0,    0,    0,    0,  398,  398, 
          398,  398,  398,  398,  398,  398,  398,  398,  398,  398, 
          398,  398,    0,    0,  398,  398,  398,    0,    0,  398, 
          474,  962,  398,    0,    0,  398,    0,  398,  965,  398, 
          967,  398,  968,  398,  398,  398,  398,  398,  398,  398, 
            0,  398,  398,  398,    0,    0,    0,    0,    0,  975, 
            0,    0,    0,    0,    0,  398,    0,  473,  473,  473, 
            0,    0,  473,  473,  473,    0,  473,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  473,  473,    0,    0, 
            0,    0,    0,    0,    0,  473,  473,    0,  473,  473, 
          473,  473,  473,    0,    0,    0,    0,    0,    0,    0, 
          473,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  473,  473,  473,  473,  473,  473,  473,  473, 
          473,  473,  473,  473,  473,  473,    0,  559,  473,  473, 
          473,    0,  475,  473,    0,    0,  473,  559,    0,  473, 
            0,  473,    0,  473,    0,  473,    0,  473,  473,  473, 
          473,  473,  473,  473,    0,  473,    0,  473,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  473, 
            0,  559,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  559,  559,    0,    0,    0, 
          559,  474,  474,  474,    0,    0,  474,  474,  474,    0, 
          474,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          474,  474,    0,    0,    0,    0,    0,    0,  559,  474, 
          474,    0,  474,  474,  474,  474,  474,    0,    0,    0, 
            0,    0,    0,    0,  474,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  474,  474,  474,  474, 
          474,  474,  474,  474,  474,  474,  474,  474,  474,  474, 
            0,  277,  474,  474,  474,    0,  476,  474,    0,    0, 
          474,  277,    0,  474,    0,  474,    0,  474,    0,  474, 
            0,  474,  474,  474,  474,  474,  474,  474,    0,  474, 
            0,  474,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  474,    0,  277,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  630,  570,  277, 
          277,  631,  106,    0,  277,  169,  170,    0,  171,  172, 
          173,  174,  175,  176,  177,    0,    0,  178,  179,    0, 
            0,    0,  180,  181,  182,  183,    0,    0,    0,    0, 
            0,  268,  277,    0,    0,    0,    0,    0,  185,  186, 
            0,  187,  188,  189,  190,  191,  192,  193,  194,  195, 
          196,  197,    0,    0,  198,  286,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  286,    0,    0,    0,  559, 
          559,  559,    0,    0,  559,  559,  559,    0,  559,    0, 
            0,    0,    0,    0,    0,    0,    0,  559,  559,  559, 
            0,    0,    0,    0,    0,    0,    0,  559,  559,  286, 
          559,  559,  559,  559,  559,    0,    0,    0,    0,    0, 
            0,    0,  559,  286,  286,    0,  105,    0,  286,    0, 
            0,    0,    0,    0,  559,  559,  559,  559,  559,  559, 
          559,  559,  559,  559,  559,  559,  559,  559,    0,    0, 
          559,  559,  559,    0,    0,  559,  286,    0,  559,    0, 
            0,  559,    0,  559,    0,  559,  419,  559,    0,  559, 
          559,  559,  559,  559,  559,  559,  419,  559,  559,  559, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  559,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          419,    0,    0,  277,  277,  277,    0,    0,  277,  277, 
          277,    0,  277,    0,  419,  419,    0,    0,    0,  419, 
            0,    0,  277,  277,    0,    0,    0,    0,    0,    0, 
            0,  277,  277,    0,  277,  277,  277,  277,  277,    0, 
            0,    0,    0,    0,    0,    0,  277,  419,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  277,  277, 
          277,  277,  277,  277,  277,  277,  277,  277,  277,  277, 
          277,  277,    0,    0,  277,  277,  277,    0,    0,  277, 
            0,    0,  277,    0,    0,  277,    0,  277,    0,  277, 
            0,  277,    0,  277,  277,  277,  277,  277,  277,  277, 
          297,  277,    0,  277,    0,    0,    0,    0,    0,    0, 
          297,    0,    0,    0,    0,  277,    0,  286,  286,  286, 
            0,    0,  286,  286,  286,    0,  286,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  286,  286,    0,    0, 
            0,    0,    0,    0,  297,  286,  286,    0,  286,  286, 
          286,  286,  286,    0,    0,    0,    0,    0,  297,  297, 
          286,    0,    0,  297,    0,    0,    0,    0,    0,    0, 
            0,    0,  286,  286,  286,  286,  286,  286,  286,  286, 
          286,  286,  286,  286,  286,  286,    0,    0,  286,  286, 
          286,  297,    0,  286,    0,    0,  286,    0,    0,  286, 
            0,  286,    0,  286,  239,  286,    0,  286,  286,  286, 
          286,  286,  286,  286,  239,  286,    0,  286,  419,  419, 
          419,    0,    0,  419,  419,  419,    0,  419,    0,  286, 
            0,    0,    0,    0,    0,    0,    0,  419,  419,    0, 
            0,    0,    0,    0,    0,    0,  419,  419,  239,  419, 
          419,  419,  419,  419,    0,    0,    0,    0,    0,    0, 
            0,  419,  239,  239,    0,    0,    0,  239,    0,    0, 
            0,    0,    0,  419,  419,  419,  419,  419,  419,  419, 
          419,  419,  419,  419,  419,  419,  419,    0,    0,  419, 
          419,  419,    0,    0,  419,  329,    0,  419,    0,    0, 
          419,    0,  419,    0,  419,    0,  419,    0,  419,  419, 
          419,  419,  419,  419,  419,    0,  419,  292,  419,    0, 
            0,    0,    0,    0,    0,    0,    0,  292,    0,    0, 
          419,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  292,  297,  297,  297,    0,    0,  297,  297,  297, 
            0,  297,    0,    0,    0,  292,  292,    0,    0,    0, 
          292,  297,  297,    0,    0,    0,    0,    0,    0,    0, 
          297,  297,    0,  297,  297,  297,  297,  297,    0,    0, 
            0,    0,    0,    0,    0,  297,    0,    0,  292,    0, 
            0,    0,    0,    0,    0,    0,    0,  297,  297,  297, 
          297,  297,  297,  297,  297,  297,  297,  297,  297,  297, 
          297,    0,    0,  297,  297,  297,    0,    0,  297,    0, 
            0,  297,    0,    0,  297,    0,  297,    0,  297,  459, 
          297,    0,  297,  297,  297,  297,  297,  297,  297,  459, 
          297,    0,  297,    0,    0,    0,  239,  239,  239,    0, 
            0,  239,  239,  239,  297,  239,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  239,  239,    0,    0,    0, 
            0,    0,    0,  459,  239,  239,    0,  239,  239,  239, 
          239,  239,    0,    0,    0,    0,    0,  459,  459,  239, 
            0,    0,  459,    0,    0,    0,    0,    0,    0,    0, 
            0,  239,  239,  239,  239,  239,  239,  239,  239,  239, 
          239,  239,  329,  239,  239,    0,    0,  239,  239,  329, 
          459,    0,  239,    0,    0,  239,    0,    0,  239,    0, 
          239,    0,  239,    0,  239,    0,  239,  239,  239,  239, 
          239,  239,  239,    0,  239,  460,  239,    0,    0,    0, 
            0,    0,    0,    0,    0,  460,    0,    0,  239,  292, 
          292,  292,    0,    0,  292,  292,  292,    0,  292,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  292,  292, 
            0,    0,    0,    0,    0,    0,    0,  292,  292,  460, 
          292,  292,  292,  292,  292,    0,    0,    0,    0,    0, 
            0,    0,  292,  460,  460,    0,    0,    0,  460,    0, 
            0,    0,    0,    0,  292,  292,  292,  292,  292,  292, 
          292,  292,  292,  292,  292,  292,  292,  292,    0,    0, 
          292,  292,  292,    0,    0,  292,  460,    0,  292,    0, 
            0,  292,    0,  292,    0,  292,  217,  292,    0,  292, 
          292,  292,  292,  292,  292,  292,  217,  292,    0,  292, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  292,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          217,  459,  459,  459,    0,    0,  459,  459,  459,    0, 
          459,    0,    0,    0,  217,  217,    0,    0,    0,  217, 
          459,  459,    0,    0,    0,    0,    0,    0,    0,  459, 
          459,    0,  459,  459,  459,  459,  459,    0,    0,    0, 
            0,    0,    0,    0,  459,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  459,  459,  459, 
          459,  459,  459,  459,  459,  459,  459,  459,  459,  459, 
            0,  213,  459,  459,  459,    0,    0,  459,    0,    0, 
          459,  213,    0,  459,    0,  459,    0,  459,    0,  459, 
            0,  459,  459,  459,  459,  459,  459,  459,    0,  459, 
            0,  459,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  459,    0,  213,    0,  460,  460,  460, 
            0,    0,  460,  460,  460,    0,  460,    0,    0,  213, 
          213,    0,    0,    0,  213,    0,  460,  460,    0,    0, 
            0,    0,    0,    0,    0,  460,  460,    0,  460,  460, 
          460,  460,  460,    0,    0,    0,    0,    0,    0,    0, 
          460,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  460,  460,  460,  460,  460,  460,  460, 
          460,  460,  460,  460,  460,  460,    0,    0,  460,  460, 
          460,    0,    0,  460,    0,    0,  460,    0,    0,  460, 
            0,  460,    0,  460,  210,  460,    0,  460,  460,  460, 
          460,  460,  460,  460,  210,  460,    0,  460,  217,  217, 
          217,    0,    0,  217,  217,  217,    0,  217,    0,  460, 
            0,    0,    0,    0,    0,    0,    0,  217,  217,    0, 
            0,    0,    0,    0,    0,    0,  217,  217,  210,  217, 
          217,  217,  217,  217,    0,    0,    0,    0,    0,    0, 
            0,  217,  210,  210,    0,    0,    0,  210,    0,    0, 
            0,    0,    0,    0,  217,  217,  217,  217,  217,  217, 
          217,  217,  217,  217,    0,  217,  217,    0,    0,  217, 
          217,    0,    0,    0,  217,    0,    0,  217,    0,    0, 
          217,    0,  217,    0,  217,    0,  217,    0,  217,  217, 
          217,  217,  217,  217,  217,    0,  217,    0,  217,  212, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  212, 
          217,    0,    0,  213,  213,  213,    0,    0,  213,  213, 
          213,    0,  213,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  213,  213,    0,    0,    0,    0,    0,    0, 
            0,  213,  213,  212,  213,  213,  213,  213,  213,    0, 
            0,    0,    0,    0,    0,    0,  213,  212,  212,    0, 
            0,    0,  212,    0,    0,    0,    0,    0,    0,  213, 
          213,  213,  213,  213,  213,  213,  213,  213,  213,    0, 
          213,  213,    0,    0,  213,  213,    0,    0,    0,  213, 
            0,    0,  213,    0,    0,  213,    0,  213,    0,  213, 
          211,  213,    0,  213,  213,  213,  213,  213,  213,  213, 
          211,  213,    0,  213,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  213,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  211,    0,  210,  210,  210,    0, 
            0,  210,  210,  210,    0,  210,    0,    0,  211,  211, 
            0,    0,    0,  211,    0,  210,  210,    0,    0,    0, 
            0,    0,    0,    0,  210,  210,    0,  210,  210,  210, 
          210,  210,    0,    0,    0,    0,    0,    0,    0,  210, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  210,  210,  210,  210,  210,  210,  210,  210, 
          210,  210,    0,  210,  210,    0,  214,  210,  210,    0, 
            0,    0,  210,    0,    0,  210,  214,    0,  210,    0, 
          210,    0,  210,    0,  210,    0,  210,  210,  210,  210, 
          210,  210,  210,    0,  210,    0,  210,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  210,    0, 
          214,  212,  212,  212,    0,    0,  212,  212,  212,    0, 
          212,    0,    0,    0,  214,  214,    0,    0,    0,  214, 
          212,  212,    0,    0,    0,    0,    0,    0,    0,  212, 
          212,    0,  212,  212,  212,  212,  212,    0,    0,    0, 
            0,    0,    0,    0,  212,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  212,  212,  212, 
          212,  212,  212,  212,  212,  212,  212,    0,  212,  212, 
            0,    0,  212,  212,    0,    0,    0,  212,    0,    0, 
          212,    0,    0,  212,    0,  212,    0,  212,  215,  212, 
            0,  212,  212,  212,  212,  212,  212,  212,  215,  212, 
            0,  212,  211,  211,  211,    0,    0,  211,  211,  211, 
            0,  211,    0,  212,    0,    0,    0,    0,    0,    0, 
            0,  211,  211,    0,    0,    0,    0,    0,    0,    0, 
          211,  211,  215,  211,  211,  211,  211,  211,    0,    0, 
            0,    0,    0,    0,    0,  211,  215,  215,    0,    0, 
            0,  215,    0,    0,    0,    0,    0,    0,  211,  211, 
          211,  211,  211,  211,  211,  211,  211,  211,    0,  211, 
          211,    0,    0,  211,  211,    0,    0,    0,  211,    0, 
            0,  211,    0,    0,  211,    0,  211,    0,  211,    0, 
          211,    0,  211,  211,  211,  211,  211,  211,  211,    0, 
          211,  208,  211,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,  211,    0,    0,    0,  214,  214, 
          214,    0,    0,  214,  214,  214,    0,  214,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  214,  214,    0, 
            0,    0,    0,    0,    0,  208,  214,  214,    0,  214, 
          214,  214,  214,  214,    0,    0,    0,    0,    0,  208, 
          208,  214,    0,    0,  208,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  214,  214,  214,  214,  214,  214, 
          214,  214,  214,  214,    0,  214,  214,    0,    0,  214, 
          214,    0,    0,    0,  214,    0,    0,  214,    0,    0, 
          214,    0,  214,    0,  214,  209,  214,    0,  214,  214, 
          214,  214,  214,  214,  214,  209,  214,    0,  214,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          214,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  209, 
          215,  215,  215,    0,    0,  215,  215,  215,    0,  215, 
            0,    0,    0,  209,  209,    0,    0,    0,  209,  215, 
          215,    0,    0,    0,    0,    0,    0,    0,  215,  215, 
            0,  215,  215,  215,  215,  215,    0,    0,    0,    0, 
            0,    0,    0,  215,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  215,  215,  215,  215, 
          215,  215,  215,  215,  215,  215,    0,  215,  215,    0, 
            0,  215,  215,    0,    0,    0,  215,  233,    0,  215, 
            0,    0,  215,    0,  215,    0,  215,  233,  215,    0, 
          215,  215,  215,  215,  215,  215,  215,    0,  215,    0, 
          215,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  215,  208,  208,  208,    0,    0,  208,  208, 
          208,  233,  208,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  208,  208,    0,  233,  233,    0,    0,    0, 
          233,  208,  208,    0,  208,  208,  208,  208,  208,    0, 
            0,    0,    0,    0,    0,    0,  208,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  208, 
          208,  208,  208,  208,  208,  208,  208,  208,  208,    0, 
          208,  208,    0,    0,  208,  208,    0,    0,    0,  208, 
            0,    0,  208,    0,    0,  208,    0,  208,    0,    0, 
          234,  208,    0,    0,    0,  208,  208,  208,  208,  208, 
          234,  208,    0,  208,    0,    0,    0,  209,  209,  209, 
            0,    0,  209,  209,  209,  208,  209,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  209,  209,    0,    0, 
            0,    0,    0,    0,  234,  209,  209,    0,  209,  209, 
          209,  209,  209,    0,    0,    0,    0,    0,  234,  234, 
          209,    0,    0,  234,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  209,  209,  209,  209,  209,  209,  209, 
          209,  209,  209,    0,  209,  209,    0,    0,  209,  209, 
            0,    0,    0,  209,    0,    0,  209,    0,    0,  209, 
            0,  209,    0,    0,    0,  209,    0,    0,    0,  209, 
          209,  209,  209,  209,    0,  209,    0,  209,  220,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  220,  209, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  233, 
          233,  233,    0,    0,  233,  233,  233,    0,  233,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  233,  233, 
            0,    0,  220,    0,    0,    0,    0,  233,  233,    0, 
          233,  233,  233,  233,  233,    0,  220,  220,    0,    0, 
            0,  220,  233,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  233,  233,  233,  233,  233, 
          233,  233,  233,  233,  233,    0,  233,  233,    0,    0, 
          233,  233,    0,    0,    0,  233,    0,    0,  233,    0, 
            0,  233,    0,  233,    0,    0,  218,  233,    0,    0, 
            0,    0,    0,  233,  233,  233,  218,  233,    0,  233, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  233,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  234,  234,  234,    0,    0,  234,  234,  234, 
          218,  234,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  234,  234,    0,  218,  218,    0,    0,    0,  218, 
          234,  234,    0,  234,  234,  234,  234,  234,    0,    0, 
            0,    0,    0,    0,    0,  234,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  234,  234, 
          234,  234,  234,  234,  234,  234,  234,  234,    0,  234, 
          234,    0,    0,  234,  234,  219,    0,    0,  234,    0, 
            0,  234,    0,    0,  234,  219,  234,    0,    0,    0, 
          234,    0,    0,    0,    0,    0,  234,  234,  234,    0, 
          234,    0,  234,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  234,    0,    0,    0,    0,  219, 
          220,  220,  220,    0,    0,  220,  220,  220,    0,  220, 
            0,    0,    0,  219,  219,    0,    0,    0,  219,  220, 
          220,    0,    0,    0,    0,    0,    0,    0,  220,  220, 
            0,  220,  220,  220,  220,  220,    0,    0,    0,    0, 
            0,    0,    0,  220,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  220,  220,  220,  220, 
          220,  220,  220,  220,  220,  220,    0,  220,  220,    0, 
            0,    0,    0,    0,    0,  223,  220,    0,    0,  220, 
            0,    0,  220,    0,  220,  223,    0,    0,  220,    0, 
            0,    0,    0,    0,  220,  220,  220,    0,  220,    0, 
          220,    0,    0,    0,    0,    0,    0,    0,  218,  218, 
          218,    0,  220,  218,  218,  218,    0,  218,    0,  223, 
            0,    0,    0,    0,    0,    0,    0,  218,  218,    0, 
            0,    0,    0,  223,  223,    0,  218,  218,  223,  218, 
          218,  218,  218,  218,    0,    0,    0,    0,    0,    0, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

            0,  218,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  218,  218,  218,  218,  218,  218, 
          218,  218,  218,  218,    0,  218,  218,    0,    0,    0, 
            0,    0,    0,    0,  218,    0,    0,  218,    0,    0, 
          218,    0,  218,    0,    0,  225,    0,    0,    0,    0, 
            0,    0,  218,  218,  218,  225,  218,    0,  218,    0, 
            0,    0,    0,    0,    0,    0,    0,  219,  219,  219, 
          218,    0,  219,  219,  219,    0,  219,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  219,  219,    0,  225, 
            0,    0,    0,    0,    0,  219,  219,    0,  219,  219, 
          219,  219,  219,  225,  225,    0,    0,    0,  225,    0, 
          219,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  219,  219,  219,  219,  219,  219,  219, 
          219,  219,  219,    0,  219,  219,    0,    0,    0,    0, 
            0,    0,  224,  219,    0,    0,  219,    0,    0,  219, 
            0,  219,  224,    0,    0,    0,    0,    0,    0,    0, 
            0,  219,  219,  219,    0,  219,    0,  219,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  219, 
            0,    0,    0,    0,    0,    0,  224,  223,  223,  223, 
            0,    0,  223,  223,  223,    0,  223,    0,    0,    0, 
          224,  224,    0,    0,    0,  224,  223,  223,    0,    0, 
            0,    0,    0,    0,    0,  223,  223,    0,  223,  223, 
          223,  223,  223,    0,    0,    0,    0,    0,    0,    0, 
          223,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  223,  223,  223,  223,  223,  223,  223, 
          223,  223,  223,    0,  223,  223,    0,    0,    0,    0, 
          222,    0,    0,  223,    0,    0,  223,    0,    0,  223, 
          222,  223,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  223,  223,    0,    0,    0,    0,  223,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  223, 
            0,    0,    0,    0,  222,    0,    0,  225,  225,  225, 
            0,    0,  225,  225,  225,    0,  225,    0,  222,  222, 
            0,    0,    0,  222,    0,    0,  225,  225,    0,    0, 
            0,    0,    0,    0,    0,  225,  225,    0,  225,  225, 
          225,  225,  225,    0,    0,    0,    0,    0,    0,    0, 
          225,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  225,  225,  225,  225,  225,  225,  225, 
          225,  225,  225,    0,  225,  225,    0,    0,    0,    0, 
            0,    0,  221,  225,    0,    0,  225,    0,    0,  225, 
            0,  225,  221,    0,    0,    0,    0,    0,    0,    0, 
            0,  225,  225,    0,  224,  224,  224,  225,    0,  224, 
          224,  224,    0,  224,    0,    0,    0,    0,    0,  225, 
            0,    0,    0,  224,  224,    0,  221,    0,    0,    0, 
            0,    0,  224,  224,    0,  224,  224,  224,  224,  224, 
          221,  221,    0,    0,    0,  221,    0,  224,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          224,  224,  224,  224,  224,  224,  224,  224,  224,  224, 
            0,  224,  224,    0,    0,    0,    0,    0,    0,    0, 
          224,    0,    0,  224,    0,    0,  224,    0,  224,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  224,  224, 
          226,    0,    0,    0,  224,    0,    0,    0,    0,    0, 
          226,    0,    0,    0,    0,    0,  224,    0,    0,    0, 
            0,    0,  222,  222,  222,    0,    0,  222,  222,  222, 
            0,  222,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  222,  222,    0,  226,    0,    0,    0,    0,    0, 
          222,  222,    0,  222,  222,  222,  222,  222,  226,  226, 
            0,    0,    0,  226,    0,  222,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  222,  222, 
          222,  222,  222,  222,  222,  222,  222,  222,    0,  222, 
          222,    0,    0,    0,    0,    0,    0,  227,  222,    0, 
            0,  222,    0,    0,  222,    0,  222,  227,    0,    0, 
            0,    0,    0,    0,    0,    0,  222,  222,    0,    0, 
            0,    0,  222,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  222,    0,    0,    0,    0,    0, 
            0,  227,    0,    0,  221,  221,  221,    0,    0,  221, 
          221,  221,    0,  221,    0,  227,  227,    0,    0,    0, 
          227,    0,    0,  221,  221,    0,    0,    0,    0,    0, 
            0,    0,  221,  221,    0,  221,  221,  221,  221,  221, 
            0,    0,    0,  228,    0,    0,    0,  221,    0,    0, 
            0,    0,    0,  228,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  221,  221,    0,    0, 
            0,  221,  221,    0,    0,    0,    0,    0,    0,    0, 
          221,    0,    0,  221,    0,    0,  221,  228,  221,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  228,  228,    0,  221,    0,  228,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  221,    0,    0,    0, 
            0,    0,  226,  226,  226,    0,    0,  226,  226,  226, 
            0,  226,    0,  235,    0,    0,    0,    0,    0,    0, 
            0,  226,  226,  235,    0,    0,    0,    0,    0,    0, 
          226,  226,    0,  226,  226,  226,  226,  226,    0,    0, 
            0,    0,    0,    0,    0,  226,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  235,    0,    0, 
            0,    0,    0,    0,  226,  226,    0,    0,    0,  226, 
          226,  235,  235,    0,    0,    0,  235,    0,  226,    0, 
            0,  226,    0,    0,  226,    0,  226,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  227, 
          227,  227,  226,    0,  227,  227,  227,    0,  227,    0, 
          229,    0,    0,    0,  226,    0,    0,    0,  227,  227, 
          229,    0,    0,    0,    0,    0,    0,  227,  227,    0, 
          227,  227,  227,  227,  227,    0,    0,    0,    0,    0, 
            0,    0,  227,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  229,    0,    0,    0,    0,    0, 
            0,  227,  227,    0,    0,    0,  227,  227,  229,  229, 
            0,    0,    0,  229,    0,  227,    0,    0,  227,    0, 
            0,  227,    0,  227,    0,  228,  228,  228,    0,    0, 
          228,  228,  228,    0,  228,    0,  230,    0,    0,  227, 
            0,    0,    0,    0,  228,  228,  230,    0,    0,    0, 
            0,  227,    0,  228,  228,    0,  228,  228,  228,  228, 
          228,    0,    0,    0,    0,    0,    0,    0,  228,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          230,    0,    0,    0,    0,    0,    0,  228,  228,    0, 
            0,    0,  228,  228,  230,  230,    0,    0,    0,  230, 
            0,  228,    0,    0,  228,    0,    0,  228,    0,  228, 
            0,    0,    0,    0,    0,  235,  235,  235,    0,    0, 
          235,  235,  235,    0,  235,  228,  236,    0,    0,    0, 
            0,    0,    0,    0,  235,  235,  236,  228,    0,    0, 
            0,    0,    0,  235,  235,    0,  235,  235,  235,  235, 
          235,    0,    0,    0,    0,    0,    0,    0,  235,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          236,    0,    0,    0,    0,    0,    0,  235,  235,    0, 
            0,    0,  235,  235,  236,  236,    0,    0,    0,  236, 
            0,  235,    0,    0,  235,    0,    0,  235,    0,  235, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  229,  229,  229,  235,    0,  229,  229,  229, 
            0,  229,    0,  206,    0,    0,    0,  235,    0,    0, 
            0,  229,  229,  206,    0,    0,    0,    0,    0,    0, 
          229,  229,    0,  229,  229,  229,  229,  229,    0,    0, 
            0,    0,    0,    0,    0,  229,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  206,    0,    0, 
            0,    0,    0,    0,  229,  229,    0,    0,    0,  229, 
          229,  206,  206,    0,    0,    0,  206,    0,  229,    0, 
            0,  229,    0,    0,  229,    0,  229,    0,  230,  230, 
          230,    0,    0,  230,  230,  230,    0,  230,    0,  207, 
            0,    0,  229,    0,    0,    0,    0,  230,  230,  207, 
            0,    0,    0,    0,  229,    0,  230,  230,    0,  230, 
          230,  230,  230,  230,    0,    0,    0,    0,    0,    0, 
            0,  230,    0,    0,    0,    0,    0,  195,    0,    0, 
            0,    0,    0,  207,    0,    0,    0,  195,    0,    0, 
          230,  230,    0,    0,    0,  230,  230,  207,  207,    0, 
            0,    0,  207,    0,  230,    0,    0,  230,    0,    0, 
          230,    0,  230,    0,    0,    0,    0,    0,  236,  236, 
          236,  240,    0,  236,  236,  236,    0,  236,  230,  237, 
            0,    0,    0,    0,    0,    0,  195,  236,  236,  237, 
          230,    0,    0,    0,    0,    0,  236,  236,    0,  236, 
          236,  236,  236,  236,    0,    0,    0,    0,    0,    0, 
            0,  236,    0,    0,    0,    0,    0,    0,    0,  205, 
            0,    0,    0,  237,    0,    0,    0,    0,    0,  205, 
            0,  236,    0,    0,    0,  236,  236,  237,  237,    0, 
            0,    0,    0,    0,  236,    0,    0,  236,    0,    0, 
          236,    0,  236,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  205,    0,  206,  206,  206,  236,    0, 
          206,  206,  206,    0,  206,    0,    0,  205,  205,    0, 
          236,    0,    0,    0,  206,  206,    0,    0,    0,    0, 
            0,    0,    0,  206,  206,    0,  206,  206,  206,  206, 
          206,    0,    0,    0,  204,    0,    0,    0,  206,    0, 
            0,    0,    0,    0,  204,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  206,    0,    0,  206,    0,    0,  206,  204,  206, 
            0,  207,  207,  207,    0,    0,  207,  207,  207,    0, 
          207,    0,  204,  204,    0,  206,    0,    0,    0,    0, 
          207,  207,    0,    0,    0,    0,    0,  206,    0,  207, 
          207,    0,  207,  207,  207,  207,  207,    0,    0,  195, 
          195,  195,    0,    0,  207,  195,  195,    0,  195,    0, 
          200,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          200,    0,    0,    0,    0,    0,    0,  195,  195,    0, 
          195,  195,  195,  195,    0,    0,    0,  207,    0,    0, 
          207,    0,    0,  207,    0,  207,    0,    0,    0,    0, 
            0,  237,  237,  237,  200,    0,  237,  237,  237,    0, 
          237,  207,    0,    0,    0,    0,    0,    0,  200,  200, 
          237,  237,    0,  207,    0,    0,    0,    0,  195,  237, 
          237,    0,  237,  237,  237,  237,  237,    0,    0,    0, 
            0,  205,  205,  205,  237,  201,  205,  205,  205,  195, 
          205,    0,    0,    0,    0,  201,    0,    0,    0,    0, 
          205,  205,    0,    0,    0,    0,    0,    0,    0,  205, 
          205,    0,  205,  205,  205,  205,  205,  237,    0,    0, 
          237,    0,    0,  237,  205,  237,    0,    0,    0,  201, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  237,    0,  201,  201,    0,  202,    0,    0,    0, 
            0,    0,    0,  237,    0,    0,  202,  205,    0,    0, 
          205,    0,    0,  205,    0,  205,  204,  204,  204,    0, 
            0,  204,  204,  204,    0,  204,    0,    0,    0,    0, 
            0,  205,    0,    0,    0,  204,  204,    0,    0,    0, 
          202,    0,    0,  205,  204,  204,    0,  204,  204,  204, 
          204,  204,    0,    0,  202,  202,    0,    0,    0,  204, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  204,  203,    0,  204,    0,    0,  204,    0, 
          204,    0,    0,  203,    0,    0,    0,    0,    0,    0, 
            0,    0,  200,  200,  200,    0,  204,  200,  200,  200, 
            0,  200,    0,    0,    0,    0,    0,    0,  204,    0, 
            0,  200,  200,    0,    0,    0,    0,  203,    0,    0, 
          200,  200,    0,  200,  200,  200,  200,  200,    0,    0, 
            0,  203,  203,    0,    0,  200,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  196, 
            0,    0,    0,    0,    0,    0,    0,    0,  200,  196, 
            0,  200,    0,    0,  200,    0,  200,  201,  201,  201, 
            0,    0,  201,  201,  201,    0,  201,    0,    0,    0, 
            0,    0,  200,    0,    0,    0,  201,  201,    0,    0, 
            0,    0,    0,  196,  200,  201,  201,    0,  201,  201, 
          201,  201,  201,    0,    0,    0,    0,  196,  196,    0, 
          201,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  202,  202, 
          202,    0,    0,  202,  202,  202,    0,  202,    0,    0, 
            0,    0,    0,  201,    0,    0,  201,  202,  202,  201, 
            0,  201,    0,    0,    0,    0,  202,  202,  198,  202, 
          202,  202,  202,  202,    0,    0,    0,  201,  198,    0, 
            0,  202,    0,    0,    0,    0,    0,    0,    0,  201, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  198,    0,  202,    0,    0,  202,    0,    0, 
          202,    0,  202,    0,    0,    0,  198,  198,    0,  238, 
            0,    0,    0,    0,    0,  203,  203,  203,  202,  238, 
          203,  203,  203,    0,  203,    0,    0,    0,    0,    0, 
          202,    0,    0,    0,  203,  203,    0,    0,    0,    0, 
            0,    0,    0,  203,  203,    0,  203,  203,  203,  203, 
          203,    0,    0,  238,    0,    0,    0,    0,  203,    0, 
            0,    0,    0,    0,    0,    0,    0,  238,  238,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  203,    0,    0,  203,  199,    0,  203,    0,  203, 
            0,  196,  196,  196,    0,  199,  196,  196,  196,    0, 
          196,    0,    0,    0,    0,  203,    0,    0,    0,    0, 
          196,  196,    0,    0,    0,    0,    0,  203,    0,  196, 
          196,    0,  196,  196,  196,  196,  196,    0,    0,  199, 
            0,    0,    0,    0,  196,    0,    0,    0,    0,    0, 
            0,    0,    0,  199,  199,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  196,    0,    0, 
          196,  240,    0,  196,    0,  196,    0,    0,    0,    0, 
            0,  240,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  196,    0,    0,    0,    0,    0,    0,    0,    0, 
          198,  198,  198,  196,    0,  198,  198,  198,    0,  198, 
            0,    0,    0,    0,    0,  240,    0,    0,    0,  198, 
          198,    0,    0,    0,    0,    0,    0,    0,  198,  198, 
          240,  198,  198,  198,  198,  198,    0,    0,    0,    0, 
            0,    0,   39,  198,    0,    0,    0,    0,    0,    0, 
            0,    0,   39,    0,    0,    0,    0,    0,    0,  197, 
            0,  238,  238,  238,    0,    0,  238,  238,  238,  197, 
          238,    0,    0,    0,    0,    0,  198,    0,    0,  198, 
          238,  238,  198,    0,  198,    0,  263,    0,    0,  238, 
          238,    0,  238,  238,  238,  238,  238,    0,    0,   22, 
          198,   39,    0,  197,  238,    0,    0,    0,    0,   22, 
            0,    0,  198,    0,    0,    0,    0,  197,  197,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  238,    0,    0, 
          238,    0,    0,  238,    0,  238,    0,  199,  199,  199, 
            0,    0,  199,  199,  199,  195,  199,    0,   22,    0, 
            0,  238,    0,    0,    0,  195,  199,  199,    0,    0, 
            0,    0,    0,  238,    0,  199,  199,    0,  199,  199, 
          199,  199,  199,    0,    0,    0,    0,    0,    0,    0, 
          199,    0,    0,    0,    0,    0,    0,    0,    0,  195, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  195,  195,    0,    0,    0,    0,    0, 
            0,    0,    0,  199,    0,    0,  199,    0,    0,  199, 
            0,  199,    0,  240,  240,  240,    0,    0,  240,  240, 
          240,    0,  240,    0,    0,    0,    0,  199,    0,    0, 
            0,    0,  240,  240,    0,    0,    0,    0,    0,  199, 
            0,  240,  240,    0,  240,  240,  240,  240,  240,    0, 
            0,    0,    0,    0,    0,    0,  240,    0,    0,    0, 
            0,    0,    0,    0,    0,  107,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   39,   39,   39,    0,    0,  240, 
           39,   39,  240,   39,    0,  240,    0,  240,    0,    0, 
            0,  197,  197,  197,    0,    0,  197,  197,  197,    0, 
          197,    0,    0,  240,  107,   39,   39,   39,   39,   39, 
          197,  197,    0,    0,    0,  240,    0,    0,    0,  197, 
          197,    0,  197,  197,  197,  197,    0,    0,    0,    0, 
            0,   22,   22,   22,  197,    0,  461,   22,   22,    0, 
           22,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   39,    0,    0,    0,    0,    0,    0, 
            0,    0,   22,   22,   22,   22,   22,  197,    0,    0, 
          197,    0,    0,  197,   39,  197,    0,    0,    0,  108, 
            0,    0,    0,    0,    0,    0,    0,  195,  195,  195, 
            0,  197,  195,  195,  195,    0,  195,    0,    0,    0, 
            0,    0,    0,  197,    0,    0,  195,  195,    0,    0, 
           22,    0,    0,    0,    0,  195,  195,    0,  195,  195, 
          195,  195,    0,    0,    0,    0,    0,    0,  108,    0, 
          195,   22,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          464,    0,    0,  195,    0,    0,  195,    0,    0,  195, 
            0,  195,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  195,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  195, 
            0,  107,  107,  107,  107,  107,  107,  107,  107,  107, 
          107,  107,    0,  107,  107,  107,    0,  107,  107,  107, 
          107,  107,  107,  107,    0,  534,    0,    0,  107,  107, 
          107,  107,  107,  107,  107,    0,    0,  107,    0,    0, 
            0,    0,    0,  107,  107,    0,  107,  107,  107,  107, 
            0,  107,  107,  107,  107,  107,  107,    0,  107,  107, 
          107,  107,  107,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  461,    0,    0,    0,    0,    0,    0, 
          461,  107,    0,    0,  107,  534,    0,  107,  107,    0, 
          107,    0,  107,    0,  541,    0,  107,    0,    0,    0, 
            0,  107,    0,    0,  107,    0,  534,    0,    0,  107, 
          107,  107,  107,  107,  107,    0,    0,    0,  107,    0, 
          107,  107,    0,  107,  107,  108,  108,  108,  108,  108, 
          108,  108,  108,  108,  108,  108,    0,  108,  108,  108, 
            0,  108,  108,  108,  108,  108,  108,  108,    0,  535, 
            0,    0,  108,  108,  108,  108,  108,  108,  108,    0, 
            0,  108,    0,    0,    0,    0,    0,  108,  108,    0, 
          108,  108,  108,  108,    0,  108,  108,  108,  108,  108, 
          108,    0,  108,  108,  108,  108,  108,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  464,    0,    0, 
            0,    0,    0,    0,  464,  108,    0,    0,  108,  535, 
            0,  108,  108,    0,  108,    0,  108,    0,  285,    0, 
          108,    0,    0,    0,    0,  108,    0,    0,  108,    0, 
          535,    0,    0,  108,  108,  108,  108,  108,  108,    0, 
            0,    0,  108,    0,  108,  108,    0,  108,  108,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  107, 
          107,  107,  107,  107,  107,  107,  107,  107,  107,  107, 
            0,  108,  107,  107,    0,  107,  107,  107,  107,  107, 
          107,  107,    0,  541,    0,    0,  107,  107,  107,  107, 
          107,  107,  107,    0,    0,  107,    0,    0,    0,    0, 
            0,  107,  107,    0,  107,  107,  107,  107,    0,  107, 
          107,  107,  107,  107,  107,    0,  107,  107,  107,  107, 
          108,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  541,    0,    0,    0,    0,    0,    0,  541,  107, 
            0,    0,  107,  537,    0,  107,  107,    0,  107,    0, 
          107,    0,  286,    0,  107,    0,    0,    0,    0,  107, 
            0,    0,  107,    0,  541,    0,    0,  107,  107,  107, 
          107,  107,  107,    0,    0,    0,  107,    0,  107,  107, 
            0,  107,  107,  108,  108,  108,  108,  108,  108,  108, 
          108,  108,  108,  108,    0,  330,  108,  108,    0,  108, 
          108,  108,  108,  108,  108,  108,    0,    0,    0,    0, 
          108,  108,  108,  108,  108,  108,  108,    0,    0,  108, 
            0,    0,    0,    0,    0,  108,  108,    0,  108,  108, 
          108,  108,    0,  108,  108,  108,  108,  108,  108,    0, 
          108,  108,  108,  108,  330,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  285,    0,    0,    0,    0, 
            0,    0,  285,  108,    0,    0,  108,  538,    0,  108, 
          108,    0,  108,    0,  108,    0,    0,    0,  108,    0, 
            0,    0,    0,  108,    0,    0,  108,    0,    0,    0, 
            0,  108,  108,  108,  108,  108,  108,    0,    0,    0, 
          108,    0,  108,  108,    0,  108,  108,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  108,  108,  108, 
          108,  108,  108,  108,  108,  108,  108,  108,    0,  559, 
          108,  108,    0,  108,  108,  108,  108,  108,  108,  108, 
            0,    0,    0,    0,  108,  108,  108,  108,  108,  108, 
          108,    0,    0,  108,    0,    0,    0,    0,    0,  108, 
          108,    0,  108,  108,  108,  108,    0,  108,  108,  108, 
          108,  108,  108,    0,  108,  108,  108,  108,  559,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  286, 
            0,    0,    0,    0,    0,    0,  286,  108,    0,    0, 
          108,    0,    0,  108,  108,    0,  108,    0,  108,    0, 
            0,    0,  108,    0,    0,    0,    0,  108,    0,    0, 
          108,    0,    0,    0,    0,  108,  108,  108,  108,  108, 
          108,    0,    0,    0,  108,    0,  108,  108,    0,  108, 
          108,  330,  330,  330,  330,  330,  330,  330,  330,  330, 
          330,  330,    0,  330,  330,  330,  330,  330,  330,  330, 
          330,  330,  330,  330,  559,    0,    0,    0,  330,  330, 
          330,  330,  330,  330,  330,    0,    0,  330,    0,    0, 
            0,    0,    0,  330,  330,    0,  330,  330,  330,  330, 
            0,  330,  330,  330,  330,  330,  330,    0,  330,  330, 
          330,  330,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  559,    0,    0,    0,    0,    0,    0, 
            0,  330,    0,    0,  330,    0,    0,  330,  330,    0, 
          330,    0,  330,    0,    0,    0,  330,    0,    0,    0, 
            0,    0,    0,    0,  330,    0,    0,    0,    0,  330, 
          330,  330,  330,  330,  330,    0,    0,    0,  330,    0, 
          330,  330,    0,  330,  330,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  559,  559,  559,  559,  559, 
          559,    0,    0,  559,  559,  559,    0,  236,    0,  559, 
            0,  559,  559,  559,  559,  559,  559,  559,    0,    0, 
            0,    0,  559,  559,  559,  559,  559,  559,  559,    0, 
            0,  559,    0,    0,    0,    0,    0,  559,  559,    0, 
          559,  559,  559,  559,    0,  559,  559,  559,  559,  559, 
          559,    0,  559,  559,  559,  559,  235,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  559,    0,    0,  559,    0, 
            0,  559,  559,    0,  559,    0,  559,    0,    0,    0, 
          559,    0,    0,    0,    0,    0,    0,    0,  559,    0, 
            0,    0,    0,  559,  559,  559,  559,  559,  559,    0, 
            0,    0,  559,    0,  559,  559,    0,  559,  559,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          559,  559,  559,  559,  559,  559,    0,    0,    0,  559, 
          559,    0,    0,    0,  559,    0,  559,  559,  559,  559, 
          559,  559,  559,    0,    0,  325,    0,  559,  559,  559, 
          559,  559,  559,  559,    0,  325,  559,    0,    0,    0, 
            0,    0,  559,  559,    0,  559,  559,  559,  559,    0, 
          559,  559,  559,  559,  559,  559,    0,  559,  559,  559, 
          559,    0,    0,    0,    0,    0,    0,    0,    0,  325, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          559,    0,    0,  559,  325,    0,  559,  559,  325,  559, 
            0,  559,    0,    0,    0,  559,    0,    0,    0,    0, 
            0,    0,    0,  559,    0,    0,  559,    0,  559,  559, 
          559,  559,  559,  559,    0,    0,  325,  559,    0,  559, 
          559,    0,  559,  559,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,  326,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,  326,   26, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,  326,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  225,    0,    0,  114,  326,    0,   46, 
           47,  326,   48,    0,    0,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,  326, 
           58,    0,   59,   60,    0,   61,   62,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  289,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  289,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  325,  325,  325, 
            0,    0,  325,  325,  325,    0,  325,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  325,  325,    0,  289, 
            0,    0,    0,    0,    0,  325,  325,    0,  325,  325, 
          325,  325,  325,    0,  289,    0,    0,    0,  289,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  325,  325,  325,  325,  325,  325,  325,  325, 
          325,  325,  325,  325,  325,  325,  289,    0,  325,  325, 
          325,    0,    0,  325,    0,    0,  325,    0,    0,  325, 
            0,  325,    0,  325,    0,  325,    0,  325,  325,  325, 
          325,  325,  325,  325,    0,  325,    0,  325,  399,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  399,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          326,  326,  326,    0,    0,  326,  326,  326,    0,  326, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  326, 
          326,    0,   91,    0,    0,    0,    0,    0,  326,  326, 
            0,  326,  326,  326,  326,  326,    0,  399,    0,  100, 
            0,  399,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  326,  326,  326,  326,  326, 
          326,  326,  326,  326,  326,  326,  326,  326,  326,  399, 
            0,  326,  326,  326,    0,    0,  326,    0,    0,  326, 
            0,    0,  326,    0,  326,    0,  326,    0,  326,    0, 
          326,  326,  326,  326,  326,  326,  326,    0,  326,    0, 
          326,    0,    0,  473,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  473,    0,    0,    0,  289,  289,  289, 
            0,    0,  289,  289,  289,    0,  289,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  289,  289,    0,    0, 
            0,    0,    0,    0,    0,  289,  289,   89,  289,  289, 
          289,  289,  289,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  473,    0,   98,    0,  473,    0,    0,    0, 
            0,    0,  289,  289,  289,  289,  289,  289,  289,  289, 
          289,  289,  289,  289,  289,  289,    0,    0,  289,  289, 
          289,    0,    0,  289,  473,    0,  289,    0,    0,  289, 
            0,  289,    0,  289,    0,  289,    0,  289,  289,  289, 
          289,  289,  289,  289,    0,  289,    0,  289,  474,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  474,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          399,  399,  399,    0,    0,    0,  399,  399,    0,  399, 
            0,    0,    0,    0,    0,    0,    0,    0,  399,    0, 
            0,    0,   90,    0,    0,    0,    0,    0,  399,  399, 
            0,  399,  399,  399,  399,  399,    0,  474,    0,   99, 
            0,  474,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  399,  399,  399,  399,  399, 
          399,  399,  399,  399,  399,  399,  399,  399,  399,  474, 
            0,  399,  399,  399,    0,    0,    0,    0,    0,  399, 
            0,    0,    0,    0,    0,    0,  399,    0,  399,    0, 
          399,  399,  399,  399,  399,  399,  399,    0,  399,  399, 
          399,    0,    0,  277,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  277,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  473,  473,  473,    0,    0, 
            0,  473,  473,    0,  473,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   97,    0,    0, 
            0,    0,    0,  473,  473,    0,  473,  473,  473,  473, 
          473,    0,  277,    0,  106,    0,  277,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          473,  473,  473,  473,  473,  473,  473,  473,  473,  473, 
          473,  473,  473,  473,  277,    0,  473,  473,  473,    0, 
          475,    0,    0,    0,  473,    0,    0,    0,    0,    0, 
            0,  473,    0,  473,    0,  473,  473,  473,  473,  473, 
          473,  473,    0,  473,    0,  473,  286,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  286,    0,    0,    0, 
          474,  474,  474,    0,    0,    0,  474,  474,    0,  474, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  474,  474, 
           96,  474,  474,  474,  474,  474,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  286,    0,  105,    0,  286, 
            0,    0,    0,    0,    0,  474,  474,  474,  474,  474, 
          474,  474,  474,  474,  474,  474,  474,  474,  474,    0, 
            0,  474,  474,  474,    0,  476,    0,  286,    0,  474, 
            0,    0,    0,    0,    0,    0,  474,   60,  474,    0, 
          474,  474,  474,  474,  474,  474,  474,   60,  474,    0, 
          474,    0,    0,  268,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  268,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  277,  277,  277,    0,    0, 
            0,  277,  277,    0,  277,    0,    0,    0,    0,    0, 
            0,    0,   62,    0,    0,    0,   60,  266,    0,    0, 
            0,    0,   62,  277,  277,    0,  277,  277,  277,  277, 
          277,    0,  268,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          277,  277,  277,  277,  277,  277,  277,  277,  277,  277, 
          277,  277,  277,  277,    0,    0,  277,  277,  277,   53, 
            0,   62,    0,    0,  277,    0,    0,    0,    0,   53, 
            0,  277,    0,  277,    0,  277,  277,  277,  277,  277, 
          277,  277,    0,  277,    0,  277,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  286,  286, 
          286,    0,    0,    0,  286,  286,    0,  286,   53,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  286,  286,    0,  286, 
          286,  286,  286,  286,  300,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  286,  286,  286,  286,  286,  286,  286, 
          286,  286,  286,  286,  286,  286,  286,    0,    0,  286, 
          286,  286,    0,    0,    0,    0,    0,  286,    0,    0, 
            0,    0,    0,    0,  286,    0,  286,    0,  286,  286, 
          286,  286,  286,  286,  286,    0,  286,    0,  286,   60, 
           60,   60,    0,    0,   60,   60,   60,    0,   60,    0, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

            0,    0,    0,    0,    0,  268,  268,  268,   60,   60, 
          268,  268,  268,    0,  268,    0,    0,   60,   60,    0, 
           60,   60,   60,   60,   60,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  268,  268,  268,  268, 
          268,    0,    0,    0,   62,   62,   62,  592,    0,   62, 
           62,   62,    0,   62,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   62,   62,    0,    0,    0,   60,    0, 
            0,   60,   62,   62,    0,   62,   62,   62,   62,   62, 
            0,  268,    0,    0,  268,    0,    0,    0,    0,   60, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   53,   53,   53,    0,  268,   53,   53,   53,    0, 
           53,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           53,    0,    0,   62,    0,    0,   62,    0,    0,   53, 
           53,    0,   53,   53,   53,   53,   53,    4,    5,    6, 
            0,    8,    0,    0,   62,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  102,  103,   17,   18,    0, 
            0,    0,    0,  104,  105,  106,   22,   23,   24,   25, 
            0,    0,  107,    0,    0,    0,    0,    0,    0,  108, 
           53,    0,   31,   32,   33,  423,   34,   35,   36,   37, 
           38,   39,    0,   40,    0,    0,  111,    0,    0,    0, 
            0,   53,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  299,    0,    0,  114, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  102,  103, 
           17,   18,    0,    0,    0,    0,  104,  105,  106,   22, 
           23,   24,   25,    0,    0,  107,    0,    0,    0,    0, 
            0,    0,  108,    0,    0,   31,   32,   33,  423,   34, 
           35,   36,   37,   38,   39,    0,   40,    0,    0,  111, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  299, 
            0,    0,  114,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,    4,    5,    6,    7,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,    0,    0,   19, 
           20,   21,   22,   23,   24,   25,    0,    0,   26,    0, 
            0,    0,    0,    0,   27,   28,   29,   30,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   44,    0,    0,   45,    0,    0,   46,   47, 
            0,   48,    0,   49,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,   51,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,    4,    5,    6,    7, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,   26,    0,    0,    0,    0,    0,   27,   28,    0, 
           30,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   44,    0,    0,   45,    0, 
            0,   46,   47,    0,   48,    0,   49,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,   51,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,    3, 
            4,    5,    6,    7,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,    0, 
            0,   27,   28,   29,   30,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   44, 
            0,    0,   45,    0,    0,   46,   47,    0,   48,    0, 
           49,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,  219,    4,    5,    6,    7,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,    0,   30,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   44,    0,    0,   45,    0,    0,   46, 
           47,    0,   48,    0,   49,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,  219,    4,    5, 
            6,    7,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,   27, 
           28,    0,   30,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   44,    0,    0, 
          285,    0,    0,   46,   47,    0,   48,    0,   49,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,    4,    5,    6,    7,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,   29,   30,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           44,    0,    0,   45,    0,    0,   46,   47,    0,   48, 
            0,   49,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    4,    5,    6,    7,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,    0,   30,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   44,    0,    0,   45,    0,    0,   46, 
           47,    0,   48,    0,   49,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,   22,   23,   24,   25, 
            0,    0,  107,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,  251,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  225,    0,    0,  114, 
            0,    0,   46,   47,    0,   48,    0,  252,    0,  253, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  254, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  102,  103, 
           17,   18,    0,    0,    0,    0,  104,  105,  106,   22, 
           23,   24,   25,    0,    0,  107,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,  251,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  225, 
            0,    0,  114,    0,    0,   46,   47,    0,   48,    0, 
          649,    0,  253,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  254,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,  258,  258,  258,    0,  258,    0,    0, 
            0,  258,  258,    0,    0,    0,  258,    0,  258,  258, 
          258,  258,  258,  258,  258,    0,    0,    0,    0,  258, 
          258,  258,  258,  258,  258,  258,    0,    0,  258,    0, 
            0,    0,    0,    0,    0,  258,    0,    0,  258,  258, 
          258,    0,  258,  258,  258,  258,  258,  258,  258,  258, 
          258,  258,  258,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  258,    0,    0,  258,    0,    0,  258,  258, 
            0,  258,    0,  258,    0,  258,    0,  258,    0,    0, 
            0,    0,    0,    0,    0,  258,    0,    0,    0,    0, 
          258,  258,  258,  258,  258,  258,    0,    0,    0,  258, 
            0,  258,  258,    0,  258,  258,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  102,  103,   17,   18,    0,    0, 
            0,    0,  104,  105,  106,   22,   23,   24,   25,    0, 
            0,  107,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,  251,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  225,    0,    0,  114,    0, 
            0,   46,   47,    0,   48,    0,  252,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  254,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  102,  103,   17, 
           18,    0,    0,    0,    0,  104,  105,  106,   22,   23, 
           24,   25,    0,    0,  107,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,  251,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  225,    0, 
            0,  114,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,  253,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  254,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          102,  103,   17,   18,    0,    0,    0,    0,  104,  105, 
          106,   22,   23,   24,   25,    0,    0,  107,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,  251,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  225,    0,    0,  114,    0,    0,   46,   47,    0, 
           48,    0,  649,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  254,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  102,  103,   17,   18,    0,    0,    0, 
            0,  104,  105,  106,   22,   23,   24,   25,    0,    0, 
          107,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
          251,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  225,    0,    0,  114,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  254,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  102,  103,   17,   18, 
            0,    0,    0,    0,  104,  105,  106,   22,   23,   24, 
           25,    0,    0,  107,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  225,    0,    0, 
          114,  456,    0,   46,   47,    0,   48,    0,    0,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          254,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,  107,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          225,    0,    0,  114,    0,    0,   46,   47,    0,   48, 
            0,  583,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  254,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  102,  103,   17,   18,    0,    0,    0,    0, 
          104,  105,  106,   22,   23,   24,   25,    0,    0,  107, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  225,    0,    0,  114,    0,    0,   46, 
           47,    0,   48,    0,  583,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  254,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  102,  103,   17,   18,    0, 
            0,    0,    0,  104,  105,  106,   22,   23,   24,   25, 
            0,    0,  107,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  225,    0,    0,  114, 
            0,    0,   46,   47,    0,   48,    0,  252,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  254, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  102,  103, 
           17,   18,    0,    0,    0,    0,  104,  105,  106,   22, 
           23,   24,   25,    0,    0,  107,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  225, 
            0,    0,  114,    0,    0,   46,   47,    0,   48,    0, 
          833,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  254,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  102,  103,   17,   18,    0,    0,    0,    0,  104, 
          105,  106,   22,   23,   24,   25,    0,    0,  107,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  225,    0,    0,  114,    0,    0,   46,   47, 
            0,   48,    0,  649,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  254,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,  548,  548,  548,    0, 
          548,    0,    0,    0,  548,  548,    0,    0,    0,  548, 
            0,  548,  548,  548,  548,  548,  548,  548,    0,    0, 
            0,    0,  548,  548,  548,  548,  548,  548,  548,    0, 
            0,  548,    0,    0,    0,    0,    0,    0,  548,    0, 
            0,  548,  548,  548,    0,  548,  548,  548,  548,  548, 
          548,    0,  548,  548,  548,  548,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  548,    0,    0,  548,  548, 
            0,  548,  548,    0,  548,    0,    0,    0,    0,    0, 
          548,    0,    0,    0,    0,    0,    0,    0,  548,    0, 
            0,    0,    0,  548,  548,  548,  548,  548,  548,    0, 
            0,    0,  548,    0,  548,  548,    0,  548,  548,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  225,    0, 
            0,  114,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          102,  103,   17,   18,    0,    0,    0,    0,  104,  105, 
          106,   22,   23,   24,   25,    0,    0,  107,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  225,    0,    0,  114,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  254,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
          107,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  225,    0,    0,  114,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  254,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,  548,  548, 
          548,    0,  548,    0,    0,    0,  548,  548,    0,    0, 
            0,  548,    0,  548,  548,  548,  548,  548,  548,  548, 
            0,    0,    0,    0,  548,  548,  548,  548,  548,  548, 
          548,    0,    0,  548,    0,    0,    0,    0,    0,    0, 
          548,    0,    0,  548,  548,  548,    0,  548,  548,  548, 
          548,  548,  548,    0,  548,  548,  548,  548,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  548,    0,    0, 
          548,    0,    0,  548,  548,    0,  548,    0,    0,    0, 
            0,    0,  548,    0,    0,    0,    0,    0,    0,    0, 
          548,    0,    0,    0,    0,  548,  548,  548,  548,  548, 
          548,    0,    0,    0,  548,    0,  548,  548,    0,  548, 
          548,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  102, 
          103,   17,   18,    0,    0,    0,    0,  104,  105,  106, 
           22,   23,   24,   25,    0,    0,  107,    0,    0,    0, 
            0,    0,    0,  108,    0,    0,   31,   32,   33,    0, 
          109,   35,   36,   37,  110,   39,    0,   40,    0,    0, 
          111,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          113,    0,    0,  114,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  102,  103,   17,   18,    0,    0,    0,    0, 
          104,  105,  106,   22,   23,   24,   25,    0,    0,  107, 
            0,    0,    0,    0,    0,    0,  108,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,    0,    0,  111,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  299,    0,    0,  374,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  102,  103,   17,   18,    0, 
            0,    0,    0,  104,  105,  106,   22,   23,   24,   25, 
            0,    0,  107,    0,    0,    0,    0,    0,    0,  108, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,    0,    0,  111,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  843,    0,    0,  114, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  102,  103, 
           17,   18,    0,    0,    0,    0,  104,  105,  106,   22, 
           23,   24,   25,    0,    0,  107,    0,    0,    0,    0, 
            0,    0,  108,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,    0,    0,  111, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  920, 
            0,    0,  114,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,  124,  125,  126,  127,  128,  129,  130, 
          131,    0,    0,  132,  133,  134,  135,  136,    0,    0, 
          137,  138,  139,  140,  141,  142,  143,    0,    0,  144, 
          145,  146,  204,  205,  206,  207,  151,  152,  153,  154, 
          155,  156,  157,  158,  159,  160,  161,  162,  208,  209, 
          210,    0,  211,  167,  274,    0,  212,    0,    0,    0, 
          169,  170,    0,  171,  172,  173,  174,  175,  176,  177, 
            0,    0,  178,  179,    0,    0,    0,  180,  181,  182, 
          183,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  185,  186,    0,  187,  188,  189,  190, 
          191,  192,  193,  194,  195,  196,  197,    0,    0,  198, 
           52,  124,  125,  126,  127,  128,  129,  130,  131,    0, 
            0,  132,  133,  134,  135,  136,    0,    0,  137,  138, 
          139,  140,  141,  142,  143,    0,    0,  144,  145,  146, 
          204,  205,  206,  207,  151,  152,  153,  154,  155,  156, 
          157,  158,  159,  160,  161,  162,  208,  209,  210,    0, 
          211,  167,    0,    0,  212,    0,    0,    0,  169,  170, 
            0,  171,  172,  173,  174,  175,  176,  177,    0,    0, 
          178,  179,    0,    0,    0,  180,  181,  182,  183,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  185,  186,    0,  187,  188,  189,  190,  191,  192, 
          193,  194,  195,  196,  197,    0,    0,  198,   52,  124, 
          125,  126,  127,  128,  129,  130,  131,    0,    0,  132, 
          133,  134,  135,  136,    0,    0,  137,  138,  139,  140, 
          141,  142,  143,    0,    0,  144,  145,  146,  147,  148, 
          149,  150,  151,  152,  153,  154,  155,  156,  157,  158, 
          159,  160,  161,  162,  163,  164,  165,    0,  166,  167, 
           36,   37,  168,   39,    0,    0,  169,  170,    0,  171, 
          172,  173,  174,  175,  176,  177,    0,    0,  178,  179, 
            0,    0,    0,  180,  181,  182,  183,    0,    0,    0, 
            0,    0,  184,    0,    0,    0,    0,    0,    0,  185, 
          186,    0,  187,  188,  189,  190,  191,  192,  193,  194, 
          195,  196,  197,    0,    0,  198,  124,  125,  126,  127, 
          128,  129,  130,  131,    0,    0,  132,  133,  134,  135, 
          136,    0,    0,  137,  138,  139,  140,  141,  142,  143, 
            0,    0,  144,  145,  146,  204,  205,  206,  207,  151, 
          152,  153,  154,  155,  156,  157,  158,  159,  160,  161, 
          162,  208,  209,  210,    0,  211,  167,  309,  310,  212, 
          311,    0,    0,  169,  170,    0,  171,  172,  173,  174, 
          175,  176,  177,    0,    0,  178,  179,    0,    0,    0, 
          180,  181,  182,  183,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  185,  186,    0,  187, 
          188,  189,  190,  191,  192,  193,  194,  195,  196,  197, 
            0,    0,  198,  124,  125,  126,  127,  128,  129,  130, 
          131,    0,    0,  132,  133,  134,  135,  136,    0,    0, 
          137,  138,  139,  140,  141,  142,  143,    0,    0,  144, 
          145,  146,  204,  205,  206,  207,  151,  152,  153,  154, 
          155,  156,  157,  158,  159,  160,  161,  162,  208,  209, 
          210,    0,  211,  167,    0,    0,  212,    0,    0,    0, 
          169,  170,    0,  171,  172,  173,  174,  175,  176,  177, 
            0,    0,  178,  179,    0,    0,    0,  180,  181,  182, 
          183,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  185,  186,    0,  187,  188,  189,  190, 
          191,  192,  193,  194,  195,  196,  197,  642,  564,  198, 
            0,  643,    0,    0,    0,  169,  170,    0,  171,  172, 
          173,  174,  175,  176,  177,    0,    0,  178,  179,    0, 
            0,    0,  180,  181,  182,  183,    0,    0,    0,    0, 
            0,  268,    0,    0,    0,    0,    0,    0,  185,  186, 
            0,  187,  188,  189,  190,  191,  192,  193,  194,  195, 
          196,  197,  644,  570,  198,    0,  645,    0,    0,    0, 
          169,  170,    0,  171,  172,  173,  174,  175,  176,  177, 
            0,    0,  178,  179,    0,    0,    0,  180,  181,  182, 
          183,    0,    0,    0,    0,    0,  268,    0,    0,    0, 
            0,    0,    0,  185,  186,    0,  187,  188,  189,  190, 
          191,  192,  193,  194,  195,  196,  197,  671,  564,  198, 
            0,  672,    0,    0,    0,  169,  170,    0,  171,  172, 
          173,  174,  175,  176,  177,    0,    0,  178,  179,    0, 
            0,    0,  180,  181,  182,  183,    0,    0,    0,    0, 
            0,  268,    0,    0,    0,    0,    0,    0,  185,  186, 
            0,  187,  188,  189,  190,  191,  192,  193,  194,  195, 
          196,  197,  673,  570,  198,    0,  674,    0,    0,    0, 
          169,  170,    0,  171,  172,  173,  174,  175,  176,  177, 
            0,    0,  178,  179,    0,    0,    0,  180,  181,  182, 
          183,    0,    0,    0,    0,    0,  268,    0,    0,    0, 
            0,    0,    0,  185,  186,    0,  187,  188,  189,  190, 
          191,  192,  193,  194,  195,  196,  197,  932,  564,  198, 
            0,  933,    0,    0,    0,  169,  170,    0,  171,  172, 
          173,  174,  175,  176,  177,    0,    0,  178,  179,    0, 
            0,    0,  180,  181,  182,  183,    0,    0,    0,    0, 
            0,  268,    0,    0,    0,    0,    0,    0,  185,  186, 
            0,  187,  188,  189,  190,  191,  192,  193,  194,  195, 
          196,  197,  934,  570,  198,    0,  935,    0,    0,    0, 
          169,  170,    0,  171,  172,  173,  174,  175,  176,  177, 
            0,    0,  178,  179,    0,    0,    0,  180,  181,  182, 
          183,    0,    0,    0,    0,    0,  268,    0,    0,    0, 
            0,    0,    0,  185,  186,    0,  187,  188,  189,  190, 
          191,  192,  193,  194,  195,  196,  197,  963,  570,  198, 
            0,  964,    0,    0,    0,  169,  170,    0,  171,  172, 
          173,  174,  175,  176,  177,    0,    0,  178,  179,    0, 
            0,    0,  180,  181,  182,  183,    0,    0,    0,    0, 
            0,  268,    0,    0,    0,    0,    0,    0,  185,  186, 
            0,  187,  188,  189,  190,  191,  192,  193,  194,  195, 
          196,  197,  577,  564,  198,    0,  578,    0,    0,    0, 
          169,  170,    0,  171,  172,  173,  174,  175,  176,  177, 
            0,    0,  178,  179,    0,    0,    0,  180,  181,  182, 
          183,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  185,  186,    0,  187,  188,  189,  190, 
          191,  192,  193,  194,  195,  196,  197,    0,    0,  198, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

            6,    7,   26,    2,   28,   15,   16,  260,   51,   19, 
          405,  438,  420,  234,  435,   92,    3,  438,    6,   27, 
           21,   27,   11,   45,    0,  395,    4,    5,  323,    0, 
          368,   21,    0,   10,   11,   10,   14,   10,  294,   10, 
            7,  297,    7,   59,  373,   49,   52,  474,   47,   48, 
          366,  367,   45,  369,  370,   10,  394,   15,   16,  790, 
           27,   19,   27,   64,   52,   44,   10,   59,   59,   10, 
           10,   49,  695,  113,   64,  425,  392,  415,   10,   91, 
           59,  526,   10,   10,  108,   48,   59,   10,   59,   47, 
           48,  429,  484,   10,   10,   15,   16,  413,  414,   19, 
           10,   10,  397,  788,   44,   44,   32,   10,  701,  703, 
           99,  427,   44,   10,   92,   59,  106,  562,   10,   59, 
           61,  114,   61,   10,  280,  115,   10,   47,  117,   61, 
          690,   10,   10,   10,   10,   10,   59,   99,  285,  323, 
          344,  280,   59,   10,  460,  483,  706,   10,   10,   59, 
           59,   10,   44,  886,   10,   10,  305,   99,  362,   10, 
            2,    3,   59,   10,   10,  481,   44,   59,  305,   10, 
           10,   10,   10,   10,   61,   59,   10,   10,   10,  864, 
          911,   59,   61,   59,  340,   10,  306,   10,  377,   10, 
          310,   10,   10,  305,  447,   10,  370,  371,  372,   10, 
          592,   10,   61,  377,   44,  361,   61,  315,   59,  317, 
          717,  319,   44,  508,  403,  372,  723,   44,  340,  952, 
          377,  220,  361,  300,   61,  374,   59,  374,  913,  341, 
          657,  610,   59,  222,  604,  656,  657,  374,   61,  634, 
          340,   59,   61,   10,   59,  615,  358,  870,  237,  809, 
           61,    0,  328,  632,  361,  265,  941,  267,  268,  335, 
          222,   10,  374,  285,  241,  242,  711,  646,  317,  268, 
            2,    3,    4,    5,  310,  868,    8,    9,   10,   11, 
          222,  875,   14,   15,   16,  278,  328,   19,  251,  252, 
          253,  884,  285,  335,   61,  237,  675,  372,   59,  348, 
           10,   10,  377,  352,  353,  308,  309,  265,  311,  267, 
           59,   32,  256,   45,   46,   32,  328,   49,  613,   51, 
          271,  365,  300,  335,  508,   15,   16,   61,  371,   19, 
          373,  269,  282,  271,  377,  378,   44,  288,  279,  290, 
          279,  264,  358,  337,  736,  265,  269,  267,  271,  341, 
           59,   61,  374,  393,  331,  332,  333,  334,  368,   61, 
           92,  367,  290,  291,  281,  305,  341,  358,  337,  368, 
          267,  375,  375,  376,  340,  267,  366,  219,   44,  358, 
          112,  374,  114,  267,  394,  340,  362,  393,  264,  362, 
          498,  362,  279,  380,  362,  394,  305,  375,  651,  388, 
          341,  341,  392,  732,  403,  415,  405,  484,  414,  341, 
          373,  706,  356,  669,  377,  636,  415,  344,  411,  429, 
          279,  771,  428,  413,  279,  341,  419,  305,  344,  613, 
          429,  341,  341,  860,  374,  424,  425,  427,  341,  860, 
          403,  344,  279,   10,  370,  371,  338,  455,  856,  455, 
           10,  377,  267,  373,  341,  461,  279,  377,  421,  458, 
          279,  856,  341,  341,  341,  374,  341,  837,  279,  344, 
          460,  434,  435,  483,  341,  438,  482,  435,  341,  341, 
          358,  344,  341,  403,  483,  341,  341,  219,  455,  440, 
          455,  481,   59,  335,  341,  341,  374,  448,  449,   59, 
          341,  421,  341,  341,  341,  262,  484,  341,  471,  241, 
          242,  474,  279,  471,  465,  592,  341,  468,  341,  518, 
          341,  774,  341,  338,   91,   44,  525,  526,  898,  750, 
          341,  358,  310,  265,   44,  267,  268,  561,  380,  271, 
           59,  273,    2,    3,  305,  264,  278,  842,    8,  337, 
          507,  337,  576,  285,   14,  264,   61,  936,   10,  268, 
          269,  325,   59,  562,  902,  566,  408,  566,  300,  279, 
           44,  572,   91,  271,  341,  265,  566,  267,  579,  580, 
          579,  580,  572,  310,  900,   45,  610,  279,   10,  579, 
          580,   91,  338,  670,  358,  378,  379,   44,   44,  331, 
          332,  333,  334,  335,  336,  337,  605,   59,  632,  617, 
          616,  617,  601,  374,  592,  605,  458,   91,  608,   10, 
          583,  620,  646,  361,  623,  614,  603,  626,  616,  622, 
          851,  341,   10,  290,  291,  634,  368,   59,   44,  371, 
          591,  373,  374,  375,   91,  377,  378,  317,  380,  317, 
          617,  675,  617,   44,  114,  378,  379,  268,  269,  736, 
          337,  612,  394,  395,  396,  263,  264,  308,   59,  317, 
          647,  714,  715,  344,   10,  362,  408,  720,  721,  411, 
          341,   59,  310,  415,  677,   44,  649,  419,  372,  732, 
          372,  690,  670,  656,  657,  346,   10,  429,  656,   44, 
          267,  340,  262,  263,  264,  698,  699,  706,  268,  269, 
          661,  271,  711,  280,  269,  708,  267,  710,   91,  682, 
          713,  579,  580,   59,  456,  264,  458,  684,  685,  341, 
          370,  371,  372,   91,  375,  376,   44,  377,  689,   10, 
            2,    3,   44,  362,   44,   59,    8,    9,   10,   11, 
          739,  483,  484,   15,   16,   91,   32,   19,  736,  219, 
          753,  328,   61,  306,   44,  306,   44,   59,  335,   44, 
          733,  749,   10,  340,  767,  768,  769,   44,   91,  756, 
          337,  341,  771,   45,   46,    0,   44,  830,   59,   51, 
          370,  371,  372,  744,  361,   10,  306,  377,  308,  309, 
          310,  311,  362,  766,  337,  279,   44,  263,  264,  328, 
          809,  337,  264,  269,  337,   61,  335,  269,  278,   44, 
           91,  340,   91,   61,  817,  285,  264,  317,  328,   44, 
          338,  788,  279,  790,  263,  335,  787,  264,  337,  358, 
          262,  263,  264,  337,   59,  337,  268,  269,  337,  271, 
          112,   10,  114,   91,  328,  362,  849,  856,  348,   58, 
          592,  335,  352,  353,  354,  355,  340,  370,  371,  372, 
          833,  603,  604,   44,  377,  335,  267,   10,  337,  344, 
          264,  328,  264,  615,  262,  263,  264,  264,  335,  337, 
          622,  269,  902,  264,   10,  901,   44,  860,  362,   44, 
           59,  341,  880,  902,  903,   44,   91,  864,  865,   44, 
          900,  904,  936,  373,  374,  647,  264,  910,  362,  341, 
          380,   91,    2,    3,    4,    5,   59,   44,    8,   44, 
           44,  267,   91,   61,   14,  395,   44,   44,  670,  938, 
          362,   44,  948,   59,  280,  677,  358,  264,  408,  263, 
          264,  411,  362,  264,  911,  328,  913,  219,  310,  419, 
           44,   10,  335,  264,  358,   45,  698,  699,  264,   49, 
          328,   44,   44,  362,  264,   91,  708,  335,  710,  241, 
          242,  713,  714,  715,  941,   44,   44,  310,  720,  721, 
           44,   44,  328,   44,  264,  344,  267,   44,  458,  335, 
          732,  264,   10,  265,  736,  267,  268,   91,  362,  271, 
           59,  273,   92,  340,  271,  328,  278,  749,  271,   91, 
          341,  753,  335,  285,  756,  361,  306,  362,  308,  309, 
          310,  311,  344,   58,  114,  767,  768,  769,  370,  371, 
          372,  279,   91,   10,  264,  377,  344,  262,  263,  264, 
          344,   59,  267,  268,  269,    0,  271,  328,  341,  328, 
          370,  371,  372,   44,  335,   10,  335,  377,   66,  331, 
          332,  333,  334,  335,  336,  337,  358,   44,  293,  294, 
          295,  296,  297,   91,   54,  817,  370,  371,    5,  938, 
          328,    6,  842,  377,   61,   44,  380,  335,  830,   44, 
            9,   10,   11,  341,  701,  837,  368,  884,  267,  371, 
           91,  373,  374,   70,   59,  377,  378,  849,  380,   14, 
          684,  280,  903,  338,   91,  870,  341,  458,   -1,  262, 
          263,  264,  394,  395,  396,  268,  269,   46,  271,  219, 
           -1,   -1,   91,  328,  604,   -1,  408,  362,  880,  411, 
          335,  267,   -1,  415,   -1,  615,   -1,  419,  328,   -1, 
           -1,   -1,  622,   -1,  280,  335,  898,  429,   -1,  328, 
          902,   -1,  904,   -1,   -1,   -1,  335,   -1,  910,   -1, 
           -1,  340,   -1,   -1,   -1,    2,    3,    4,    5,    6, 
           -1,    8,   10,   -1,  456,  279,  458,   14,  278,   -1, 
           -1,   -1,  361,  112,   -1,  285,   -1,  279,  341,   -1, 
           -1,   -1,  328,   -1,   -1,   10,   -1,  677,  267,  335, 
          300,  483,   -1,   -1,  340,   10,   -1,   -1,   45,  362, 
           -1,   -1,   49,    0,   -1,   -1,   -1,   -1,  698,  699, 
           -1,   59,   -1,   10,  328,  361,   -1,   -1,  708,   44, 
          710,  335,   -1,  713,   10,  335,  328,   -1,   -1,  267, 
           -1,   -1,   -1,  335,   -1,  306,   61,  308,  309,  310, 
          311,   -1,  732,   91,   59,   92,   -1,   44,   -1,  328, 
          701,   -1,  703,   -1,   -1,  706,  335,   -1,   44,  749, 
           -1,  340,   59,  753,  374,  375,   91,  114,  279,  280, 
          380,   -1,   -1,   -1,   -1,   61,   91,  767,  768,  769, 
           -1,   -1,  279,  280,   10,  395,   -1,  262,  263,  264, 
          328,   -1,  267,  268,  269,   -1,  271,  335,  408,   -1, 
          279,  411,  241,  242,   -1,   91,  281,  282,   -1,  419, 
           -1,  603,  604,   -1,   -1,  290,  291,  328,  293,  294, 
          295,  296,  297,  615,  335,   -1,   -1,  817,   -1,  340, 
          622,  328,  271,   59,  273,   -1,   -1,   -1,  335,   -1, 
           -1,   -1,   -1,  340,  341,   -1,   -1,  837,  458,  328, 
          361,   -1,   -1,   -1,   -1,  647,  335,   44,   -1,  849, 
           -1,   -1,   10,   -1,  361,   -1,  341,   -1,   -1,  344, 
           -1,  346,  219,   -1,  484,  293,  294,  295,  296,  297, 
           -1,   10,   -1,   -1,   -1,  677,   -1,  362,   -1,   -1, 
           -1,   -1,  331,  332,  333,  334,   44,  336,  337,    2, 
            3,    4,    5,    6,   91,    8,  698,  699,  898,   -1, 
           -1,   14,   -1,   61,  904,   44,  708,   -1,  710,  267, 
          910,  713,  714,  715,  875,   -1,   44,   -1,  720,  721, 
           -1,  278,   61,  884,   -1,  886,   -1,   -1,  285,   -1, 
          732,   59,   45,   91,   -1,   -1,   49,   -1,   -1,   -1, 
           -1,   10,  267,  300,  279,  280,   10,  396,   -1,   -1, 
           -1,  753,   91,   -1,  756,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   91,  271,  767,  768,  769,    2,    3, 
          328,   -1,  592,   -1,    8,   44,   -1,  335,  335,   92, 
           44,   -1,   -1,  279,  604,   10,  293,  294,  295,  296, 
          297,  952,   61,  328,   -1,  615,   -1,   61,   -1,   -1, 
          335,  114,  622,  328,   -1,  340,  341,  456,   -1,   -1, 
          335,   45,   -1,   44,   -1,  817,   -1,  374,  375,   44, 
           -1,   44,   91,  380,   -1,   -1,  361,   91,  830,   -1, 
           -1,  338,  328,   -1,  341,  837,   61,   -1,  395,  335, 
           -1,  520,  521,   -1,  340,  341,   -1,  849,   -1,   -1, 
          670,  408,   -1,   -1,  411,  362,   -1,  677,  678,   -1, 
           91,   -1,  419,   -1,   -1,   -1,   91,   -1,   91,   -1, 
          306,   -1,  308,  309,  310,  311,   -1,   -1,  698,  699, 
          114,   -1,  279,  280,   -1,   -1,   -1,   -1,  708,   -1, 
          710,   -1,  328,  713,   -1,   -1,  898,   -1,   -1,  335, 
          902,  458,  904,  339,  340,   -1,  219,   -1,  910,   -1, 
           -1,  347,  348,  349,  350,   -1,  736,   -1,   -1,   -1, 
           -1,  279,  280,   -1,   -1,  317,   -1,  484,   -1,  749, 
           -1,  328,   -1,  753,   -1,   -1,    0,   -1,  335,   -1, 
          279,  333,  334,  340,   -1,   -1,   10,  767,  768,  769, 
           -1,   -1,  280,   -1,  603,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  361,  278,  358,   -1,  360,   -1, 
          328,   -1,  285,   -1,   -1,   -1,  306,  335,  308,  309, 
          310,  311,  340,  341,   -1,  219,   -1,  300,  306,  328, 
          308,  309,  310,  311,   -1,   59,  335,  817,  647,   -1, 
          328,   -1,  341,  361,   -1,   -1,   -1,  335,   -1,  339, 
          279,  280,  340,   -1,   -1,  279,   -1,  837,   -1,  349, 
          350,  339,  335,   -1,   -1,   -1,   -1,   -1,   -1,  849, 
          358,   -1,   -1,  361,   -1,  592,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,  278,   -1,   -1,  604,  279,  280, 
           -1,  285,   -1,   10,  279,   -1,  279,  280,  615,  328, 
          880,  374,  375,   -1,  328,  622,  335,  380,   -1,   -1, 
           -1,  335,  341,   -1,   -1,   -1,   -1,  341,  898,   -1, 
           -1,   -1,  395,   -1,  904,   -1,   -1,   -1,   -1,   -1, 
          910,   -1,  361,   -1,   -1,  408,   -1,  328,  411,   -1, 
           -1,  335,   59,  328,  335,  328,  419,  756,   -1,  340, 
          335,   -1,  335,  670,  793,   -1,  341,   -1,   -1,   -1, 
          677,   -1,  801,  802,   59,  804,   -1,  806,   -1,  808, 
          361,  810,  811,   -1,   -1,   -1,   -1,   -1,  361,   -1, 
          374,  698,  699,   -1,   -1,  458,  380,   -1,   -1,   -1, 
           -1,  708,   10,  710,   -1,   -1,  713,   -1,   -1,   -1, 
           -1,  395,   -1,  262,  263,  264,    0,   -1,   -1,  268, 
          269,  484,  271,   -1,  408,   -1,   10,  411,   -1,  736, 
           -1,   -1,  262,  263,  264,  419,   -1,   -1,  268,  269, 
           -1,  271,  749,   -1,   -1,   -1,  753,   -1,  262,  263, 
          264,   59,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
          767,  768,  769,   -1,   -1,   -1,  306,  281,  308,  309, 
          310,  311,   -1,   -1,  458,   59,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,  916,  917,  918, 
          919,   10,  341,  922,   -1,  924,  925,  926,  927,  339, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,   -1,   -1, 
          817,  341,  306,  362,  308,  309,  310,  311,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,  592, 
          837,   -1,  362,  962,   -1,   -1,  965,  966,  967,  968, 
           59,  604,  849,   15,   16,  339,  975,   19,  362,   -1, 
           -1,   -1,  615,  347,   -1,  262,  263,  264,   -1,  622, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   41, 
           42,   -1,   -1,  880,  281,   47,   48,   -1,   50,   51, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,  898,   -1,   -1,   -1,   -1,   -1,  904,   -1,   -1, 
           -1,   -1,   -1,  910,   -1,   -1,   -1,  670,   -1,   -1, 
           -1,   -1,   -1,   -1,  677,   -1,   -1,   -1,   -1,   -1, 
          604,  306,   -1,  308,  309,  310,  311,   -1,   -1,   -1, 
           -1,  615,   -1,   -1,  341,  698,  699,   -1,  622,   -1, 
           10,   -1,   -1,   -1,   -1,  708,   -1,  710,   -1,   -1, 
          713,   -1,   -1,   -1,  339,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,  349,  350,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  736,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,  749,  271,   -1,   59, 
          753,   -1,   -1,  677,   -1,   -1,   -1,  281,  306,   -1, 
          308,  309,  310,  311,  767,  768,  769,   -1,   -1,  293, 
          294,  295,  296,  297,  698,  699,   -1,   -1,   -1,   -1, 
          328,   -1,   -1,   -1,  708,   -1,  710,  335,  317,  713, 
           -1,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,  349,  350,   -1,  333,  334,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,  817,   -1,   -1,  341,   -1,  348, 
           -1,   10,   -1,  352,  353,  354,  355,   -1,   -1,  753, 
           -1,   -1,   -1,   -1,  837,   -1,   -1,   -1,  362,  251, 
          252,  253,  254,  767,  768,  769,  849,  306,   -1,  308, 
          309,  310,  311,  265,   -1,  267,  268,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  276,   -1,   -1,  317,   -1,  328, 
           59,   -1,   -1,   -1,   -1,   -1,  335,  880,   -1,   -1, 
          339,  340,   -1,  333,  334,   -1,   -1,   -1,  347,  348, 
          349,  350,   -1,  817,   -1,  898,   -1,   -1,  348,   -1, 
          350,  904,  352,  353,  354,  355,   -1,  910,   -1,   10, 
           -1,   -1,   -1,  837,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  849,  338,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,   -1,   -1,   -1,   -1,  368,   -1,   59,  371, 
           -1,  373,   -1,   -1,   -1,  377,  378,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  898,   -1,   -1,   -1,   -1,   -1, 
          904,   -1,  394,   -1,   -1,   -1,  910,   -1,   -1,   -1, 
           -1,  403,   -1,   -1,   -1,   -1,  306,    0,  308,  309, 
          310,  311,   -1,  415,  416,  417,  418,   10,   -1,  421, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  429,  328,   -1, 
           -1,   -1,  434,  435,   -1,  335,  438,   -1,   -1,  339, 
          340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348,  349, 
          350,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          462,  463,  464,   -1,   -1,   -1,   59,   -1,   -1,  471, 
           -1,   -1,  474,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,  483,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,  281,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   63,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1, 
          339,   -1,  341,  342,  343,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,  583,   -1,  362,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,  306,   -1,  308,  309,  310, 
          311,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,   -1,   44,  649,  339,  340, 
           -1,   -1,   -1,   -1,  656,  657,  347,  348,  349,  350, 
           58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
          682,  306,   -1,  308,  309,  310,  311,   -1,  281,  282, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  714,  715,  339,  340,   -1,   -1,  720,  721, 
           -1,   -1,  347,  348,  349,  350,    0,   -1,   -1,  731, 
          732,  733,   -1,   -1,   -1,  737,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,   -1,  759,  760,  761, 
          762,   -1,   -1,   -1,  766,   -1,   -1,   -1,   -1,  362, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  297,   -1,   58,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,  818,   91,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  830,   -1, 
           -1,  833,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,   -1,   -1,   -1, 
           -1,  853,   -1,   -1,   63,   -1,   -1,   -1,  860,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,  279,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          902,  299,   -1,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,  337, 
          338,  339,  340,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,  374,  375,  376,   63, 
          378,  379,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,  279,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,  337,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,    0,   -1,   -1,  373, 
          374,  375,  376,   -1,  378,  379,   10,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
           44,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,  306,  307,   58,   59,  310,   61,   -1,   63, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,  340,   91,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,   -1,  363, 
           -1,   -1,   -1,  297,   -1,   -1,   -1,   -1,  306,    0, 
          308,  309,  310,  311,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,  349,  350,   44,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   58,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           91,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
          340,   -1,   -1,   -1,   -1,   -1,   10,  347,  348,   -1, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   59,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   10,  373, 
          374,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   59,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,   -1,  364,  365,  366,  367,  368,  369,    0, 
           -1,   -1,  373,  374,  375,  376,   -1,  378,  379,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  306,   -1,  308,  309, 
          310,  311,  306,   -1,  308,  309,  310,  311,   -1,   -1, 
           -1,   -1,   -1,   44,  306,   -1,  308,  309,  310,  311, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   58,   59,  339, 
           61,  335,   63,   -1,   -1,  339,  340,  347,  348,  349, 
          350,   -1,   -1,  347,  348,  349,  350,  339,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,  349,  350,   -1, 
           91,   -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,    0,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,   10,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,   -1,  363, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,   -1,   -1,   -1,   44,  333,  334,   -1, 
           -1,   -1,   -1,   -1,  306,   -1,  308,  309,  310,  311, 
           58,   59,  348,   -1,  350,   63,  352,  353,  354,  355, 
          356,  357,  358,  317,  360,   -1,  328,   -1,  322,  323, 
           -1,   -1,   -1,  335,   -1,   -1,   -1,  339,  340,  333, 
          334,   -1,   -1,   91,   -1,  347,  348,  349,  350,   -1, 
           -1,   -1,   -1,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   10,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   10,  373,  374,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           59,  299,   -1,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,  340,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,   -1,  364,  365,  366,  367, 
          368,  369,    0,   -1,   -1,  373,  374,  375,  376,   -1, 
          378,  379,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1, 
           58,   59,  265,  266,   -1,   63,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   91,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   10,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   44, 
          373,   -1,  375,  376,   -1,  378,  379,  306,   -1,  308, 
          309,  310,  311,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,   -1,   -1,   -1, 
          339,  340,   -1,   -1,   -1,   -1,   91,   -1,  347,  348, 
          349,  350,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   59,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,  340,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,  374,  375,  376,   63, 
          378,  379,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,   -1,  364, 
          365,  366,  367,  368,  369,    0,   -1,   -1,  373,  374, 
          375,  376,   -1,  378,  379,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,   -1, 
          308,  309,  310,  311,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          328,   -1,   -1,   58,   59,   -1,   61,  335,   63,   -1, 
           -1,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,  349,  350,  317,  318,  319,  320,  321,  322,  323, 
          324,   -1,  326,  327,   -1,   -1,   91,   -1,   -1,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   59,  306,  307, 
           -1,   63,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   91, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,   -1,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   10,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

          334,  335,  336,   -1,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
          374,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,   -1, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,   -1,  364,  365,  366,  367,  368,  369,    0, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,   -1,   59,  265, 
          266,   -1,   63,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           91,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   10,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   44,  373,   -1,  375, 
          376,   -1,  378,  379,   -1,  306,  307,   -1,   -1,  310, 
           -1,   59,   -1,  314,  315,   63,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340, 
           -1,   -1,   -1,   91,   -1,   -1,  347,  348,   -1,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
           -1,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   59, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,   -1, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,   -1,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,    0,  362,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   10,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,  362,   -1,   -1,  270,    0,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   10,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,   -1, 
           44,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   61,  333,   63, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
           -1,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,   59,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,  339,  340,  341,  342,  343,   -1,  345,   -1, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,   -1,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,  339,  340,  341,  342,  343, 
           -1,  345,   -1,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,    0,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,   10,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,   -1,   -1,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
          341,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  257,  258,  259,   -1,  261, 
           -1,  362,   -1,  265,  266,   -1,   -1,   -1,  270,    0, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   10, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   44,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           61,   -1,   63,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,   -1,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   59,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,  339,  340,  341,  342,  343, 
           -1,  345,   -1,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,   -1,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,   -1,  339,  340, 
          341,  342,  343,   -1,  345,   -1,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
            0,  362,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           10,   -1,  373,   -1,  375,  376,   -1,  378,  379,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   44,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   58,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
           -1,    0,  344,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          362,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   44,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   58, 
           59,   -1,   -1,  299,   63,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  693,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,  703,   -1,  339,  706,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   58,   59,   -1,   61,   -1,   63,   -1, 
          280,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348,    0, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   10, 
          360,  361,  362,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  873,  271,  875,  374,  877,   -1,   -1,   -1,  881, 
           -1,  280,  281,  282,  886,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   44,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   58,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,   -1,   -1,  338, 
           91,  943,  341,   -1,   -1,  344,   -1,  346,  950,  348, 
          952,  350,  954,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,  361,  362,   -1,   -1,   -1,   -1,   -1,  971, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,    0,  333,  334, 
          335,   -1,  337,  338,   -1,   -1,  341,   10,   -1,  344, 
           -1,  346,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   91,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,    0,  333,  334,  335,   -1,  337,  338,   -1,   -1, 
          341,   10,   -1,  344,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,  307,   58, 
           59,  310,   61,   -1,   63,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,  340,   91,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,   -1,  363,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  280,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   44, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   58,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,   -1,   -1,  338,   91,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,  361,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
            0,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,  374,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   58,   59, 
          305,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,   91,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,    0,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   10,  360,   -1,  362,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,  374, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   44,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,   -1,   -1,  338,   91,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,    0,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
          374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           63,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348,    0, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   10, 
          360,   -1,  362,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,  374,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   58,   59,  305, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
           91,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,    0,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  374,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   44, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,   -1,   -1,  338,   91,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,    0,  333,  334,  335,   -1,   -1,  338,   -1,   -1, 
          341,   10,   -1,  344,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   44,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,    0,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   10,  360,   -1,  362,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,  374, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   44,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   -1,  362,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
          374,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   44,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
            0,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,    0,  333,  334,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   10,   -1,  344,   -1, 
          346,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           44,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   44,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,    0,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,  374,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   58, 
           59,  305,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  348,    0,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   10,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,  338,    0,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,   10,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  374,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   44,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   58,   59,   -1,   -1,   -1, 
           63,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
            0,  350,   -1,   -1,   -1,  354,  355,  356,  357,  358, 
           10,  360,   -1,  362,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,  374,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   58,   59, 
          305,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,   -1,  350,   -1,   -1,   -1,  354, 
          355,  356,  357,  358,   -1,  360,   -1,  362,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  374, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   58,   59,   -1,   -1, 
           -1,   63,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,    0,  350,   -1,   -1, 
           -1,   -1,   -1,  356,  357,  358,   10,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           44,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   58,   59,   -1,   -1,   -1,   63, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,    0,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   10,  346,   -1,   -1,   -1, 
          350,   -1,   -1,   -1,   -1,   -1,  356,  357,  358,   -1, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   44, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   10,   -1,   -1,  350,   -1, 
           -1,   -1,   -1,   -1,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,  374,  267,  268,  269,   -1,  271,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   58,   59,   -1,  290,  291,   63,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,  356,  357,  358,   10,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
          374,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   58,   59,   -1,   -1,   -1,   63,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  356,  357,  358,   -1,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           10,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  356,  357,   -1,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  356,  357,   -1,  262,  263,  264,  362,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  356,  357, 
            0,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   58,   59, 
           -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,   -1,   -1,   -1,   -1,    0,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  356,  357,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   44,  346,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,  362,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329, 
          330,   58,   59,   -1,   -1,   -1,   63,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,  362,   -1,  267,  268,  269,   -1,  271,   -1, 
            0,   -1,   -1,   -1,  374,   -1,   -1,   -1,  281,  282, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,  324,  325,   -1,   -1,   -1,  329,  330,   58,   59, 
           -1,   -1,   -1,   63,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,    0,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,  281,  282,   10,   -1,   -1,   -1, 
           -1,  374,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1, 
           -1,   -1,  329,  330,   58,   59,   -1,   -1,   -1,   63, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,  362,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   10,  374,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1, 
           -1,   -1,  329,  330,   58,   59,   -1,   -1,   -1,   63, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,  362,   -1,  267,  268,  269, 
           -1,  271,   -1,    0,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,  281,  282,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329, 
          330,   58,   59,   -1,   -1,   -1,   63,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,    0, 
           -1,   -1,  362,   -1,   -1,   -1,   -1,  281,  282,   10, 
           -1,   -1,   -1,   -1,  374,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   10,   -1,   -1, 
          324,  325,   -1,   -1,   -1,  329,  330,   58,   59,   -1, 
           -1,   -1,   63,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   44,   -1,  267,  268,  269,   -1,  271,  362,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,  281,  282,   10, 
          374,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,  325,   -1,   -1,   -1,  329,  330,   58,   59,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,  262,  263,  264,  362,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   58,   59,   -1, 
          374,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,    0,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   44,  346, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   58,   59,   -1,  362,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,  374,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,  262, 
          263,  264,   -1,   -1,  305,  268,  269,   -1,  271,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   44,   -1,  267,  268,  269,   -1, 
          271,  362,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
          281,  282,   -1,  374,   -1,   -1,   -1,   -1,  341,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,  262,  263,  264,  305,    0,  267,  268,  269,  362, 
          271,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,  338,   -1,   -1, 
          341,   -1,   -1,  344,  305,  346,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  362,   -1,   58,   59,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,   10,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           44,   -1,   -1,  374,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   58,   59,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,    0,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,  362,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   58,   59,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   10, 
           -1,  341,   -1,   -1,  344,   -1,  346,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   44,  374,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   58,   59,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,  281,  282,  344, 
           -1,  346,   -1,   -1,   -1,   -1,  290,  291,    0,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,  362,   10,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,   -1,   -1,   58,   59,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,  362,   10, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   44,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,    0,   -1,  344,   -1,  346, 
           -1,  262,  263,  264,   -1,   10,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,  374,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,    0,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  374,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           59,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   10, 
          271,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
          281,  282,  344,   -1,  346,   -1,   44,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,    0, 
          362,   59,   -1,   44,  305,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,  374,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,    0,  271,   -1,   59,   -1, 
           -1,  362,   -1,   -1,   -1,   10,  281,  282,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  338, 
          268,  269,  341,  271,   -1,  344,   -1,  346,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,  362,   59,  293,  294,  295,  296,  297, 
          281,  282,   -1,   -1,   -1,  374,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,  305,   -1,   91,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  293,  294,  295,  296,  297,  338,   -1,   -1, 
          341,   -1,   -1,  344,  362,  346,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,  362,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,  281,  282,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
          305,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,   -1,   10,  269,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,  336,   -1,   -1,  339,  340,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   91,   -1,  351,   -1,   -1,   -1, 
           -1,  356,   -1,   -1,  359,   -1,  361,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,   10,  269,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,  339,  340, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   91,   -1, 
          351,   -1,   -1,   -1,   -1,  356,   -1,   -1,  359,   -1, 
          361,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
           -1,   10,  269,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,   -1,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336, 
           -1,   -1,  339,  340,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   91,   -1,  351,   -1,   -1,   -1,   -1,  356, 
           -1,   -1,  359,   -1,  361,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   10,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
           -1,   -1,  335,  336,   -1,   -1,  339,  340,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,  356,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,   -1,   10, 
          269,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   10,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259,  260, 
          261,   -1,   -1,  264,  265,  266,   -1,   10,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          256,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,    0,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   10,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,   -1,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   59,   -1,  342,  343,   63,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,  362,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   91,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,    0,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   10,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   59,   -1,  342, 
          343,   63,  345,   -1,   -1,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   91, 
          373,   -1,  375,  376,   -1,  378,  379,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   91,   -1,  333,  334, 
          335,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,  362,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   91, 
           -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   44,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,   -1,   -1,  338,   91,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,  362,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  280,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   91, 
           -1,  333,  334,  335,   -1,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,  361, 
          362,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   91,   -1,  333,  334,  335,   -1, 
          337,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           44,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,   -1,  337,   -1,   91,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
          362,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   59,   44,   -1,   -1, 
           -1,   -1,   10,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,    0, 
           -1,   59,   -1,   -1,  341,   -1,   -1,   -1,   -1,   10, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   -1,  362,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

           -1,   -1,   -1,   -1,   -1,  262,  263,  264,  281,  282, 
          267,  268,  269,   -1,  271,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,  262,  263,  264,   44,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,  341,   -1, 
           -1,  344,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,  338,   -1,   -1,  341,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,  362,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,   -1,   -1,  341,   -1,   -1,  344,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,  257,  258,  259, 
           -1,  261,   -1,   -1,  362,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
          341,   -1,  302,  303,  304,   59,  306,  307,  308,  309, 
          310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   59,  306, 
          307,  308,  309,  310,  311,   -1,  313,   -1,   -1,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,  260,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,  260, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  256, 
          257,  258,  259,  260,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  256,  257,  258,  259,  260,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  256,  257,  258, 
          259,  260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,  260,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,  349, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,  340,   -1,  342,  343,   -1,  345,   -1,   -1,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,  340, 
           -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,   -1,   -1,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,  260,  261,  262,  263, 
          264,   -1,   -1,  267,  268,  269,  270,  271,   -1,   -1, 
          274,  275,  276,  277,  278,  279,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,  308,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,   -1,  363, 
          364,  257,  258,  259,  260,  261,  262,  263,  264,   -1, 
           -1,  267,  268,  269,  270,  271,   -1,   -1,  274,  275, 
          276,  277,  278,  279,  280,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  347,  348,   -1,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,   -1,   -1,  363,  364,  257, 
          258,  259,  260,  261,  262,  263,  264,   -1,   -1,  267, 
          268,  269,  270,  271,   -1,   -1,  274,  275,  276,  277, 
          278,  279,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,  299,  300,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,   -1,  363,  257,  258,  259,  260, 
          261,  262,  263,  264,   -1,   -1,  267,  268,  269,  270, 
          271,   -1,   -1,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
           -1,   -1,  363,  257,  258,  259,  260,  261,  262,  263, 
          264,   -1,   -1,  267,  268,  269,  270,  271,   -1,   -1, 
          274,  275,  276,  277,  278,  279,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  306,  307,  363, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  306,  307,  363,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  306,  307,  363, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  306,  307,  363,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  306,  307,  363, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  306,  307,  363,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  306,  307,  363, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  306,  307,  363,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,   -1,  363, 
      };
   }

}
