[//]: <> "This file has been autogenerated, please do not edit"

% crio 8

# NAME

crio - OCI-based implementation of Kubernetes Container Runtime Interface

# SYNOPSIS

crio

```
[--additional-devices]=[value]
[--apparmor-profile]=[value]
[--big-files-temporary-dir]=[value]
[--bind-mount-prefix]=[value]
[--cgroup-manager]=[value]
[--clean-shutdown-file]=[value]
[--cni-config-dir]=[value]
[--cni-default-network]=[value]
[--cni-plugin-dir]=[value]
[--config-dir|-d]=[value]
[--config|-c]=[value]
[--conmon-cgroup]=[value]
[--conmon-env]=[value]
[--conmon]=[value]
[--container-attach-socket-dir]=[value]
[--container-exits-dir]=[value]
[--ctr-stop-timeout]=[value]
[--decryption-keys-path]=[value]
[--default-capabilities]=[value]
[--default-env]=[value]
[--default-mounts-file]=[value]
[--default-runtime]=[value]
[--default-sysctls]=[value]
[--default-transport]=[value]
[--default-ulimits]=[value]
[--drop-infra-ctr]
[--enable-metrics]
[--enable-profile-unix-socket]
[--gid-mappings]=[value]
[--global-auth-file]=[value]
[--grpc-max-recv-msg-size]=[value]
[--grpc-max-send-msg-size]=[value]
[--help|-h]
[--hooks-dir]=[value]
[--image-volumes]=[value]
[--infra-ctr-cpuset]=[value]
[--insecure-registry]=[value]
[--irqbalance-config-file]=[value]
[--listen]=[value]
[--log-dir]=[value]
[--log-filter]=[value]
[--log-format]=[value]
[--log-journald]
[--log-level|-l]=[value]
[--log-size-max]=[value]
[--log]=[value]
[--metrics-port]=[value]
[--metrics-socket]=[value]
[--namespaces-dir]=[value]
[--no-pivot]
[--pause-command]=[value]
[--pause-image-auth-file]=[value]
[--pause-image]=[value]
[--pids-limit]=[value]
[--pinns-path]=[value]
[--profile-port]=[value]
[--profile]
[--read-only]
[--registry]=[value]
[--root|-r]=[value]
[--runroot]=[value]
[--runtimes]=[value]
[--seccomp-profile]=[value]
[--seccomp-use-default-when-empty]=[value]
[--selinux]
[--separate-pull-cgroup]=[value]
[--signature-policy]=[value]
[--storage-driver|-s]=[value]
[--storage-opt]=[value]
[--stream-address]=[value]
[--stream-enable-tls]
[--stream-idle-timeout]=[value]
[--stream-port]=[value]
[--stream-tls-ca]=[value]
[--stream-tls-cert]=[value]
[--stream-tls-key]=[value]
[--uid-mappings]=[value]
[--version-file-persist]=[value]
[--version-file]=[value]
[--version|-v]
```

# DESCRIPTION

OCI-based implementation of Kubernetes Container Runtime Interface Daemon

crio is meant to provide an integration path between OCI conformant runtimes
and the kubelet. Specifically, it implements the Kubelet Container Runtime
Interface (CRI) using OCI conformant runtimes. The scope of crio is tied to the
scope of the CRI.

1. Support multiple image formats including the existing Docker and OCI image formats.
2. Support for multiple means to download images including trust & image verification.
3. Container image management (managing image layers, overlay filesystems, etc).
4. Container process lifecycle management.
5. Monitoring and logging required to satisfy the CRI.
6. Resource isolation as required by the CRI.

**Usage**:

```
crio [GLOBAL OPTIONS] command [COMMAND OPTIONS] [ARGUMENTS...]
```

# GLOBAL OPTIONS

**--additional-devices**="": Devices to add to the containers  (default: [])

**--apparmor-profile**="": Name of the apparmor profile to be used as the runtime's default. This only takes effect if the user does not specify a profile via the Kubernetes Pod's metadata annotation. (default: crio-default)

**--big-files-temporary-dir**="": Path to the temporary directory to use for storing big files, used to store image blobs and data streams related to containers image management.

**--bind-mount-prefix**="": A prefix to use for the source of the bind mounts. This option would be useful if you were running CRI-O in a container. And had `/` mounted on `/host` in your container. Then if you ran CRI-O with the `--bind-mount-prefix=/host` option, CRI-O would add /host to any bind mounts it is handed over CRI. If Kubernetes asked to have `/var/lib/foobar` bind mounted into the container, then CRI-O would bind mount `/host/var/lib/foobar`. Since CRI-O itself is running in a container with `/` or the host mounted on `/host`, the container would end up with `/var/lib/foobar` from the host mounted in the container rather then `/var/lib/foobar` from the CRI-O container. (default: "")

**--cgroup-manager**="": cgroup manager (cgroupfs or systemd) (default: systemd)

**--clean-shutdown-file**="": Location for CRI-O to lay down the clean shutdown file. It indicates whether we've had time to sync changes to disk before shutting down. If not found, crio wipe will clear the storage directory (default: /var/lib/crio/clean.shutdown)

**--cni-config-dir**="": CNI configuration files directory (default: /etc/cni/net.d/)

**--cni-default-network**="": Name of the default CNI network to select. If not set or "", then CRI-O will pick-up the first one found in --cni-config-dir.

**--cni-plugin-dir**="": CNI plugin binaries directory (default: [])

**--config, -c**="": Path to configuration file (default: /etc/crio/crio.conf)

**--config-dir, -d**="": Path to the configuration drop-in directory.
    This directory will be recursively iterated and each file gets applied
    to the configuration in their processing order. This means that a
    configuration file named '00-default' has a lower priority than a file
    named '01-my-overwrite'.
    The global config file, provided via '--config,-c' or per default in
    /etc/crio/crio.conf, always has a lower priority than the files in the directory specified
    by '--config-dir,-d'.
    Besides that, provided command line parameters have a higher priority
    than any configuration file. (default: /etc/crio/crio.conf.d)

**--conmon**="": Path to the conmon binary, used for monitoring the OCI runtime. Will be searched for using $PATH if empty. (default: "")

**--conmon-cgroup**="": cgroup to be used for conmon process (default: system.slice)

**--conmon-env**="": Environment variable list for the conmon process, used for passing necessary environment variables to conmon or the runtime (default: [PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin])

**--container-attach-socket-dir**="": Path to directory for container attach sockets (default: /var/run/crio)

**--container-exits-dir**="": Path to directory in which container exit files are written to by conmon (default: /var/run/crio/exits)

**--ctr-stop-timeout**="": The minimal amount of time in seconds to wait before issuing a timeout regarding the proper termination of the container. The lowest possible value is 30s, whereas lower values are not considered by CRI-O (default: 30)

**--decryption-keys-path**="": Path to load keys for image decryption. (default: /etc/crio/keys/)

**--default-capabilities**="": Capabilities to add to the containers (default: [CHOWN DAC_OVERRIDE FSETID FOWNER SETGID SETUID SETPCAP NET_BIND_SERVICE KILL])

**--default-env**="": Additional environment variables to set for all containers (default: [])

**--default-mounts-file**="": Path to default mounts file (default: "")

**--default-runtime**="": Default OCI runtime from the runtimes config (default: runc)

**--default-sysctls**="": Sysctls to add to the containers (default: [])

**--default-transport**="": A prefix to prepend to image names that cannot be pulled as-is (default: docker://)

**--default-ulimits**="": Ulimits to apply to containers by default (name=soft:hard) (default: []) (default: [])

**--drop-infra-ctr**: Determines whether pods are created without an infra container, when the pod is not using a pod level PID namespace (default: false)

**--enable-metrics**: Enable metrics endpoint for the server on localhost:9090

**--enable-profile-unix-socket**: Enable pprof profiler on crio unix domain socket

**--gid-mappings**="": Specify the GID mappings to use for the user namespace (default: "")

**--global-auth-file**="": Path to a file like /var/lib/kubelet/config.json holding credentials necessary for pulling images from secure registries (default: "")

**--grpc-max-recv-msg-size**="": Maximum grpc receive message size in bytes (default: 16777216)

**--grpc-max-send-msg-size**="": Maximum grpc receive message size (default: 16777216)

**--help, -h**: show help

**--hooks-dir**="": Set the OCI hooks directory path (may be set multiple times)
    If one of the directories does not exist, then CRI-O will automatically
    skip them.
    Each '\*.json' file in the path configures a hook for CRI-O
    containers. For more details on the syntax of the JSON files and
    the semantics of hook injection, see 'oci-hooks(5)'. CRI-O
    currently support both the 1.0.0 and 0.1.0 hook schemas, although
    the 0.1.0 schema is deprecated.
    This option may be set multiple times; paths from later options
    have higher precedence ('oci-hooks(5)' discusses directory
    precedence).
    For the annotation conditions, CRI-O uses the Kubernetes
    annotations, which are a subset of the annotations passed to the
    OCI runtime. For example, 'io.kubernetes.cri-o.Volumes' is part of
    the OCI runtime configuration annotations, but it is not part of
    the Kubernetes annotations being matched for hooks.
    For the bind-mount conditions, only mounts explicitly requested by
    Kubernetes configuration are considered. Bind mounts that CRI-O
    inserts by default (e.g. '/dev/shm') are not considered. (default: [/usr/share/containers/oci/hooks.d])

**--image-volumes**="": Image volume handling ('mkdir', 'bind', or 'ignore')
    1. mkdir: A directory is created inside the container root filesystem for
       the volumes.
    2. bind: A directory is created inside container state directory and bind
       mounted into the container for the volumes.
	3. ignore: All volumes are just ignored and no action is taken. (default: mkdir)

**--infra-ctr-cpuset**="": CPU set to run infra containers, if not specified CRI-O will use all online CPUs to run infra containers (default: '').

**--insecure-registry**="": Enable insecure registry communication, i.e., enable un-encrypted and/or untrusted communication.
    1. List of insecure registries can contain an element with CIDR notation to
       specify a whole subnet.
    2. Insecure registries accept HTTP or accept HTTPS with certificates from
       unknown CAs.
    3. Enabling '--insecure-registry' is useful when running a local registry.
       However, because its use creates security vulnerabilities, **it should ONLY
       be enabled for testing purposes**. For increased security, users should add
       their CA to their system's list of trusted CAs instead of using
       '--insecure-registry'. (default: [])

**--irqbalance-config-file**="": The irqbalance service config file which is used by CRI-O. (default: /etc/sysconfig/irqbalance)

**--listen**="": Path to the CRI-O socket (default: /var/run/crio/crio.sock)

**--log**="": Set the log file path where internal debug information is written

**--log-dir**="": Default log directory where all logs will go unless directly specified by the kubelet (default: /var/log/crio/pods)

**--log-filter**="": Filter the log messages by the provided regular expression. For example 'request.\*' filters all gRPC requests.

**--log-format**="": Set the format used by logs: 'text' or 'json' (default: text)

**--log-journald**: Log to systemd journal (journald) in addition to kubernetes log file (default: false)

**--log-level, -l**="": Log messages above specified level: trace, debug, info, warn, error, fatal or panic (default: info)

**--log-size-max**="": Maximum log size in bytes for a container. If it is positive, it must be >= 8192 to match/exceed conmon read buffer (default: -1)

**--metrics-port**="": Port for the metrics endpoint (default: 9090)

**--metrics-socket**="": Socket for the metrics endpoint

**--namespaces-dir**="": The directory where the state of the managed namespaces gets tracked. Only used when manage-ns-lifecycle is true (default: /var/run)

**--no-pivot**: If true, the runtime will not use `pivot_root`, but instead use `MS_MOVE` (default: false)

**--pause-command**="": Path to the pause executable in the pause image (default: /pause)

**--pause-image**="": Image which contains the pause executable (default: k8s.gcr.io/pause:3.5)

**--pause-image-auth-file**="": Path to a config file containing credentials for --pause-image (default: "")

**--pids-limit**="": Maximum number of processes allowed in a container (default: 1024)

**--pinns-path**="": The path to find the pinns binary, which is needed to manage namespace lifecycle. Will be searched for in $PATH if empty (default: "")

**--profile**: Enable pprof remote profiler on localhost:6060

**--profile-port**="": Port for the pprof profiler (default: 6060)

**--read-only**: Setup all unprivileged containers to run as read-only. Automatically mounts tmpfs on `/run`, `/tmp` and `/var/tmp`. (default: false)

**--registry**="": Registry to be prepended when pulling unqualified images, can be specified multiple times (default: [])

**--root, -r**="": The CRI-O root directory (default: /var/lib/containers/storage)

**--runroot**="": The CRI-O state directory (default: /run/containers/storage)

**--runtimes**="": OCI runtimes, format is runtime_name:runtime_path:runtime_root:runtime_type (default: [])

**--seccomp-profile**="": Path to the seccomp.json profile to be used as the runtime's default. If not specified, then the internal default seccomp profile will be used. (default: "")

**--seccomp-use-default-when-empty**="": Use the default seccomp profile when an empty one is specified (default: false)

**--selinux**: Enable selinux support (default: false)

**--separate-pull-cgroup**="": [EXPERIMENTAL] Pull in new cgroup (default: "")

**--signature-policy**="": Path to signature policy JSON file. (default: "", to use the system-wide default)

**--storage-driver, -s**="": OCI storage driver (default: "")

**--storage-opt**="": OCI storage driver option (default: [])

**--stream-address**="": Bind address for streaming socket (default: 127.0.0.1)

**--stream-enable-tls**: Enable encrypted TLS transport of the stream server (default: false)

**--stream-idle-timeout**="": Length of time until open streams terminate due to lack of activity

**--stream-port**="": Bind port for streaming socket. If the port is set to '0', then CRI-O will allocate a random free port number. (default: 0)

**--stream-tls-ca**="": Path to the x509 CA(s) file used to verify and authenticate client communication with the encrypted stream. This file can change and CRI-O will automatically pick up the changes within 5 minutes (default: "")

**--stream-tls-cert**="": Path to the x509 certificate file used to serve the encrypted stream. This file can change and CRI-O will automatically pick up the changes within 5 minutes (default: "")

**--stream-tls-key**="": Path to the key file used to serve the encrypted stream. This file can change and CRI-O will automatically pick up the changes within 5 minutes (default: "")

**--uid-mappings**="": Specify the UID mappings to use for the user namespace (default: "")

**--version, -v**: print the version

**--version-file**="": Location for CRI-O to lay down the temporary version file. It is used to check if crio wipe should wipe containers, which should always happen on a node reboot (default: /var/run/crio/version)

**--version-file-persist**="": Location for CRI-O to lay down the persistent version file. It is used to check if crio wipe should wipe images, which should only happen when CRI-O has been upgraded (default: /var/run/crio/version)


# COMMANDS

## complete, completion

Generate bash, fish or zsh completions.

## man

Generate the man page documentation.

## markdown, md

Generate the markdown documentation.

**--help, -h**: show help

## config

Outputs a commented version of the configuration file that could be used
by CRI-O. This allows you to save you current configuration setup and then load
it later with **--config**. Global options will modify the output.

**--default**: Output the default configuration (without taking into account any configuration options).

**--migrate-defaults, -m**="": Migrate the default config from a specified version.
    To run a config migration, just select the input config via the global
    '--config,-c' command line argument, for example:
    ```
    crio -c /etc/crio/crio.conf.d/00-default.conf config -m 1.17
    ```
    The migration will print converted configuration options to stderr and will
    output the resulting configuration to stdout.
    Please note that the migration will overwrite any fields that have changed
    defaults between versions. To save a custom configuration change, it should
    be in a drop-in configuration file instead.
    Possible values: "1.17" (default: 1.17)

## version

display detailed version information

**--json, -j**: print JSON instead of text

## wipe

wipe CRI-O's container and image storage

**--force, -f**: force wipe by skipping the version check

## help, h

Shows a list of commands or help for one command

## FILES

**crio.conf** (/etc/crio/crio.conf)
  cri-o configuration file for all of the available command-line options for
  the crio(8) program, but in a TOML format that can be more easily modified
  and versioned.

**policy.json** (/etc/containers/policy.json)
  Signature verification policy files are used to specify policy, e.g. trusted
  keys, applicable when deciding whether to accept an image, or individual
  signatures of that image, as valid.

**registries.conf** (/etc/containers/registries.conf)
  Registry configuration file specifies registries which are consulted when
  completing image names that do not include a registry or domain portion.

**storage.conf** (/etc/containers/storage.conf)
  Storage configuration file specifies all of the available container storage
  options for tools using shared container storage.

# SEE ALSO

crio.conf(5), crio.conf.d(5), oci-hooks(5), policy.json(5), registries.conf(5),
storage.conf(5)