/**
 * @name Use of a predictable seed in a secure random number generator
 * @description Using a predictable seed in a pseudo-random number generator can lead to predictability of the numbers generated by it.
 * @kind problem
 * @problem.severity error
 * @precision high
 * @id java/predictable-seed
 * @tags security
 */

import java
import semmle.code.java.security.Random

from GetRandomData da, RValue use, PredictableSeedExpr source
where
  da.getQualifier() = use and
  unsafelySeeded(use, source)
select da, "Usage of a SecureRandom number generator seeded with a $@.", source, "predictable value"
