/**
 * @name Filter out generated files
 * @description Only keep results from files that do not look like they are minified,
 *              generated by a module bundler or by Emscripten, or contain a source
 *              mapping comment.
 * @kind treemap
 * @id js/not-generated-file-metric-filter
 * @metricType file
 */

import semmle.javascript.GeneratedCode
import external.MetricFilter

from MetricResult res
where not isGeneratedCode(res.getFile())
select res, res.getValue()
