# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

# [2.3.0-alpha.14](https://github.com/doczjs/docz/compare/v2.3.0-alpha.13...v2.3.0-alpha.14) (2020-03-31)


### Bug Fixes

* **babel-plugin-export-metadata:** add case for export default… ([#1417](https://github.com/doczjs/docz/issues/1417)) ([31ebd08](https://github.com/doczjs/docz/commit/31ebd08))
* **docz-core:** always use custom prop filter if it's provided… ([#1415](https://github.com/doczjs/docz/issues/1415)) ([53063ff](https://github.com/doczjs/docz/commit/53063ff))
* **gatsby-theme-docz:** add pre-wrap to error ([#1406](https://github.com/doczjs/docz/issues/1406)) ([ca6b02d](https://github.com/doczjs/docz/commit/ca6b02d))
* **gatsby-theme-docz:** content overflowing issue ([#1437](https://github.com/doczjs/docz/issues/1437)) ([56f4cb8](https://github.com/doczjs/docz/commit/56f4cb8))


### Features

* **docz:** bump babel-preset-react-app to 9.1.2 ([#1435](https://github.com/doczjs/docz/issues/1435)) ([8f071eb](https://github.com/doczjs/docz/commit/8f071eb))
* **gatsby-theme-docz:** include MDX transclusion support ([#1436](https://github.com/doczjs/docz/issues/1436)) ([435001a](https://github.com/doczjs/docz/commit/435001a))





# [2.3.0-alpha.13](https://github.com/doczjs/docz/compare/v2.3.0-alpha.12...v2.3.0-alpha.13) (2020-02-13)


### Bug Fixes

* **docz:** pass useScoping to theme Playground ([6ec7315](https://github.com/doczjs/docz/commit/6ec7315)), closes [#1390](https://github.com/doczjs/docz/issues/1390)
* **gatsby-theme-docz:** flex component aligmItems -> alignItems ([#1391](https://github.com/doczjs/docz/issues/1391)) ([b80524f](https://github.com/doczjs/docz/commit/b80524f))





# [2.3.0-alpha.12](https://github.com/doczjs/docz/compare/v2.3.0-alpha.11...v2.3.0-alpha.12) (2020-02-12)


### Bug Fixes

* **docz-core:** pass down host when running serve ([#1384](https://github.com/doczjs/docz/issues/1384)) ([80a0e1e](https://github.com/doczjs/docz/commit/80a0e1e))
* **gatsby-theme-docz:** use sx instead of style prop in Playgro… ([#1389](https://github.com/doczjs/docz/issues/1389)) ([98f3311](https://github.com/doczjs/docz/commit/98f3311))





# [2.3.0-alpha.11](https://github.com/doczjs/docz/compare/v2.3.0-alpha.10...v2.3.0-alpha.11) (2020-02-07)


### Bug Fixes

* **docz-core:** be explicit about cli args ([6f5b4ee](https://github.com/doczjs/docz/commit/6f5b4ee))


### Features

* **docz-core:** pass down cli args to Gatsby + fix open flag ([385b006](https://github.com/doczjs/docz/commit/385b006))
* **gatsby-theme-docz:** create MainContainer component ([#1381](https://github.com/doczjs/docz/issues/1381)) ([e8d1c04](https://github.com/doczjs/docz/commit/e8d1c04))





# [2.3.0-alpha.10](https://github.com/doczjs/docz/compare/v2.3.0-alpha.9...v2.3.0-alpha.10) (2020-02-06)


### Bug Fixes

* **docz-core:** parse port when running serve ([29d0edd](https://github.com/doczjs/docz/commit/29d0edd))





# [2.3.0-alpha.9](https://github.com/doczjs/docz/compare/v2.3.0-alpha.8...v2.3.0-alpha.9) (2020-02-06)


### Bug Fixes

* **docz:** fix capitalization of ts interfaces ([9e950eb](https://github.com/doczjs/docz/commit/9e950eb))





# [2.3.0-alpha.8](https://github.com/doczjs/docz/compare/v2.3.0-alpha.7...v2.3.0-alpha.8) (2020-02-06)

**Note:** Version bump only for package docz





# [2.3.0-alpha.7](https://github.com/doczjs/docz/compare/v2.3.0-alpha.6...v2.3.0-alpha.7) (2020-02-04)


### Bug Fixes

* **gatsby-theme-docz:** removed unused gatsby-plugin-manifest ([#1368](https://github.com/doczjs/docz/issues/1368)) ([44edc68](https://github.com/doczjs/docz/commit/44edc68))
* warning in Alert component ([#1353](https://github.com/doczjs/docz/issues/1353)) ([8ee156d](https://github.com/doczjs/docz/commit/8ee156d))
* **gatsby-theme-docz:** fix playground react-resize-detector usage ([#1350](https://github.com/doczjs/docz/issues/1350)) ([f0baf67](https://github.com/doczjs/docz/commit/f0baf67))


### Features

* add hook to find docgen props ([#1371](https://github.com/doczjs/docz/issues/1371)) ([8fffa26](https://github.com/doczjs/docz/commit/8fffa26))
* add the ability to hide a document from the menu ([#1354](https://github.com/doczjs/docz/issues/1354)) ([95b0d7f](https://github.com/doczjs/docz/commit/95b0d7f))





# [2.3.0-alpha.6](https://github.com/doczjs/docz/compare/v2.3.0-alpha.5...v2.3.0-alpha.6) (2020-01-02)


### Bug Fixes

* **docz-core:** prevent falsy error code on cli ([#1332](https://github.com/doczjs/docz/issues/1332)) ([1437b59](https://github.com/doczjs/docz/commit/1437b59))
* **docz-core:** revert ts auto-detect ([f0ce584](https://github.com/doczjs/docz/commit/f0ce584))





# [2.3.0-alpha.5](https://github.com/doczjs/docz/compare/v2.3.0-alpha.4...v2.3.0-alpha.5) (2019-12-17)


### Bug Fixes

* **gatsby-theme-docz:** src -> gatsbyRoot for file system source ([71dd572](https://github.com/doczjs/docz/commit/71dd572))


### Features

* **docz-core:** introduce gatsbyRoot to use for fs sourcing ([8e89d64](https://github.com/doczjs/docz/commit/8e89d64))





# [2.3.0-alpha.4](https://github.com/doczjs/docz/compare/v2.3.0-alpha.3...v2.3.0-alpha.4) (2019-12-16)


### Bug Fixes

* **gatsby-theme-docz:** make Props isToggle work again ([#1326](https://github.com/doczjs/docz/issues/1326)) ([4921ef5](https://github.com/doczjs/docz/commit/4921ef5))
* update dev-env dependencies ([e1b185f](https://github.com/doczjs/docz/commit/e1b185f))





# [2.3.0-alpha.3](https://github.com/doczjs/docz/compare/v2.3.0-alpha.2...v2.3.0-alpha.3) (2019-12-16)


### Bug Fixes

* **gatsby-theme-docz:** fix preview padding ([ebebd1c](https://github.com/doczjs/docz/commit/ebebd1c)), closes [#1325](https://github.com/doczjs/docz/issues/1325)





# [2.3.0-alpha.2](https://github.com/doczjs/docz/compare/v2.3.0-alpha.1...v2.3.0-alpha.2) (2019-12-14)


### Bug Fixes

* **docz-core:** forward cli status code properly ([#1319](https://github.com/doczjs/docz/issues/1319)) ([99ebf82](https://github.com/doczjs/docz/commit/99ebf82))


### Features

* **docz-core:** allow custom pattern for globbing components with docgenConfig.searchPatterns ([#1316](https://github.com/doczjs/docz/issues/1316)) ([29e0165](https://github.com/doczjs/docz/commit/29e0165))
* **docz-core:** support kebab & pascal case component file name pattern ([#1314](https://github.com/doczjs/docz/issues/1314)) ([9d5b129](https://github.com/doczjs/docz/commit/9d5b129))
* **docz-utils:** add exports parser to add to Playground scope ([9c564d0](https://github.com/doczjs/docz/commit/9c564d0)), closes [#1247](https://github.com/doczjs/docz/issues/1247)
* **rehype-docz:** add mdx exports to Playground scope ([d902e2a](https://github.com/doczjs/docz/commit/d902e2a)), closes [#1247](https://github.com/doczjs/docz/issues/1247)





# [2.3.0-alpha.1](https://github.com/doczjs/docz/compare/v2.3.0-alpha.0...v2.3.0-alpha.1) (2019-12-13)


### Bug Fixes

* **docz-core:** properly support node_modules for multiple file patterns ([#1315](https://github.com/doczjs/docz/issues/1315)) ([4d9f9b3](https://github.com/doczjs/docz/commit/4d9f9b3))
* **docz-core:** use docz-utils for get and mergeWith ([f222083](https://github.com/doczjs/docz/commit/f222083))


### Features

* **docz-utils:** export mergeWith and get from lodash@4 ([53fbde0](https://github.com/doczjs/docz/commit/53fbde0)), closes [#1313](https://github.com/doczjs/docz/issues/1313)





# [2.3.0-alpha.0](https://github.com/doczjs/docz/compare/v2.2.1-alpha.1...v2.3.0-alpha.0) (2019-12-12)


### Features

* **docz-core:** detect typescript without config ([bbaecb2](https://github.com/doczjs/docz/commit/bbaecb2))





## [2.2.1-alpha.1](https://github.com/doczjs/docz/compare/v2.2.1-alpha.0...v2.2.1-alpha.1) (2019-12-12)


### Bug Fixes

* **docz-core:** add native styled-components support ([b072f78](https://github.com/doczjs/docz/commit/b072f78))





## [2.2.1-alpha.0](https://github.com/doczjs/docz/compare/v2.2.0...v2.2.1-alpha.0) (2019-12-11)


### Bug Fixes

* **gatsby-theme-docz:** fix mdx components theming from config ([3a9bdb7](https://github.com/doczjs/docz/commit/3a9bdb7)), closes [#1309](https://github.com/doczjs/docz/issues/1309)





# [2.2.0](https://github.com/doczjs/docz/compare/v2.2.0-alpha.8...v2.2.0) (2019-12-11)

**Note:** Version bump only for package docz





# [2.2.0-alpha.8](https://github.com/doczjs/docz/compare/v2.2.0-alpha.7...v2.2.0-alpha.8) (2019-12-06)


### Features

* **gatsby-theme-docz:** add optional iframe for preview and ed… ([#1305](https://github.com/doczjs/docz/issues/1305)) ([9c5082e](https://github.com/doczjs/docz/commit/9c5082e)), closes [#1306](https://github.com/doczjs/docz/issues/1306)





# [2.2.0-alpha.7](https://github.com/doczjs/docz/compare/v2.2.0-alpha.6...v2.2.0-alpha.7) (2019-12-03)


### Bug Fixes

* **gatsby-theme-docz:** fix infinite renders in playground on hot reload ([3451fd1](https://github.com/doczjs/docz/commit/3451fd1)), closes [#1299](https://github.com/doczjs/docz/issues/1299)





# [2.2.0-alpha.6](https://github.com/doczjs/docz/compare/v2.2.0-alpha.5...v2.2.0-alpha.6) (2019-12-03)


### Bug Fixes

* **gatsby-theme-docz:** fix horizontal code overflow ([a0b7823](https://github.com/doczjs/docz/commit/a0b7823))





# [2.2.0-alpha.5](https://github.com/doczjs/docz/compare/v2.2.0-alpha.4...v2.2.0-alpha.5) (2019-12-01)


### Bug Fixes

* **gatsby-theme-docz:** fix tsx parsing in code blocks ([b321ff8](https://github.com/doczjs/docz/commit/b321ff8))





# [2.2.0-alpha.4](https://github.com/doczjs/docz/compare/v2.2.0-alpha.3...v2.2.0-alpha.4) (2019-11-30)


### Features

* **gatsby-theme-docz:** add showMarkdownEditButton flag ([8fd04e8](https://github.com/doczjs/docz/commit/8fd04e8)), closes [#1291](https://github.com/doczjs/docz/issues/1291)





# [2.2.0-alpha.3](https://github.com/doczjs/docz/compare/v2.2.0-alpha.2...v2.2.0-alpha.3) (2019-11-29)


### Bug Fixes

* **docz-core:** re-sync .docz on build ([dfd4262](https://github.com/doczjs/docz/commit/dfd4262))





# [2.2.0-alpha.2](https://github.com/doczjs/docz/compare/v2.2.0-alpha.1...v2.2.0-alpha.2) (2019-11-29)


### Bug Fixes

* **docz-core:** log errors that happen in gatsby-config ([fe1e2da](https://github.com/doczjs/docz/commit/fe1e2da))


### Features

* **docz-core:** copy .env ([51f7027](https://github.com/doczjs/docz/commit/51f7027))





# [2.2.0-alpha.1](https://github.com/doczjs/docz/compare/v2.2.0-alpha.0...v2.2.0-alpha.1) (2019-11-28)


### Bug Fixes

* **gatsby-theme-docz:** remove typo from the theme styles ([a25da88](https://github.com/doczjs/docz/commit/a25da88))


### Features

* **docz-core:** add all gatsby node apis to generated gatsby-node ([918b44c](https://github.com/doczjs/docz/commit/918b44c)), closes [#1285](https://github.com/doczjs/docz/issues/1285)





# [2.2.0-alpha.0](https://github.com/doczjs/docz/compare/v2.1.1...v2.2.0-alpha.0) (2019-11-28)


### Bug Fixes

* **gatsby-theme-docz:** set gatsby root from doczrc src ([e6b1521](https://github.com/doczjs/docz/commit/e6b1521))


### Features

* **docz-core:** recommend commands on typo ([#1282](https://github.com/doczjs/docz/issues/1282)) ([0f8430d](https://github.com/doczjs/docz/commit/0f8430d))





## [2.1.1](https://github.com/doczjs/docz/compare/v2.1.0...v2.1.1) (2019-11-27)


### Bug Fixes

* **docz-core:** prepend dot to default mdx extensions ([18f78d6](https://github.com/doczjs/docz/commit/18f78d6))





# [2.1.0](https://github.com/doczjs/docz/compare/v2.0.0-rc.77...v2.1.0) (2019-11-27)


### Bug Fixes

* **docz:** remove lowercasing of enum ts prop type ([8f7b949](https://github.com/doczjs/docz/commit/8f7b949))
* **gatsby-theme-docz:** allow empty ts prop defaultValue ([2512aa1](https://github.com/doczjs/docz/commit/2512aa1))
* **gatsby-theme-docz:** fix min-height ([34fc31f](https://github.com/doczjs/docz/commit/34fc31f))


### Features

* **docz:** spread remaining props to Props component ([#1276](https://github.com/doczjs/docz/issues/1276)) ([531244f](https://github.com/doczjs/docz/commit/531244f))
* **docz-core:** add mdxExtensions to config ([77b84e8](https://github.com/doczjs/docz/commit/77b84e8))
* **gatsby-theme-docz:** use mdxExtensions from config ([7d405c5](https://github.com/doczjs/docz/commit/7d405c5))







### Bug Fixes



* **docz-core:** add docz init command ([43cdeca](https://github.com/pedronauck/docz/commit/43cdeca))
* **docz-core:** remove installation step in .docz 🎉 ([4d01ead](https://github.com/pedronauck/docz/commit/4d01ead))
* **docz-gatsby-monorepo:** add example showing docz usage in a monorepo ([241c757](https://github.com/pedronauck/docz/commit/241c757))
* add normalize for trailing slashes ([4b0a710](https://github.com/pedronauck/docz/commit/4b0a710))
* adds theme path overrrite option ([bb62c6b](https://github.com/pedronauck/docz/commit/bb62c6b))
* rewrite dest path for themeDir override ([7418e55](https://github.com/pedronauck/docz/commit/7418e55))





# [2.0.0-rc.33](https://github.com/pedronauck/docz/compare/v2.0.0-rc.32...v2.0.0-rc.33) (2019-09-04)


### Features

* **docz-core:** remove installation step in .docz 🎉 ([6790179](https://github.com/pedronauck/docz/commit/6790179))





# [2.0.0-rc.32](https://github.com/pedronauck/docz/compare/v2.0.0-rc.1...v2.0.0-rc.32) (2019-09-04)

### Bug Fixes

- **docz:** add @emotion/core dependency ([52126df](https://github.com/pedronauck/docz/commit/52126df))
- **docz:** better default playground component ([80b1c66](https://github.com/pedronauck/docz/commit/80b1c66))
- **docz:** bump docz-core version ([c56e0c6](https://github.com/pedronauck/docz/commit/c56e0c6))
- **docz:** initialize components context with defaultComponents ([a808795](https://github.com/pedronauck/docz/commit/a808795))
- **docz:** use playground from docz-components ([52874c4](https://github.com/pedronauck/docz/commit/52874c4))
- **docz-components:** better prop types for playground ([f35f3ca](https://github.com/pedronauck/docz/commit/f35f3ca))
- **docz-components:** fix development example ([faf2134](https://github.com/pedronauck/docz/commit/faf2134))
- **docz-components:** fix syntax highlighting in Playground ([c72c575](https://github.com/pedronauck/docz/commit/c72c575))
- **docz-components:** typo boder -> border ([1246b19](https://github.com/pedronauck/docz/commit/1246b19))
- **docz-core:** make onCreateWebpackConfig extendable ([8968a6c](https://github.com/pedronauck/docz/commit/8968a6c))
- **docz-core:** run init on build if docz is not initialized ([26aa7f6](https://github.com/pedronauck/docz/commit/26aa7f6))
- **docz-core:** set yarn production to false to download all deps ([2b4cc6b](https://github.com/pedronauck/docz/commit/2b4cc6b))
- **docz-core:** use react from parent directory ([#1053](https://github.com/pedronauck/docz/issues/1053)) ([b55b786](https://github.com/pedronauck/docz/commit/b55b786))
- **gatsby-theme-docz:** expose gatsby actions to plugin ([66546a4](https://github.com/pedronauck/docz/commit/66546a4))
- **gatsby-theme-docz:** fix style differences between dev and build ([9cb5237](https://github.com/pedronauck/docz/commit/9cb5237))
- **gatsby-theme-docz:** replace iframe in playground with div [#984](https://github.com/pedronauck/docz/issues/984) [#1035](https://github.com/pedronauck/docz/issues/1035) ([4214180](https://github.com/pedronauck/docz/commit/4214180))

### Features

- **docz-component:** initialize ([73fafd1](https://github.com/pedronauck/docz/commit/73fafd1))
- **docz-components:** working playground ([344ffbb](https://github.com/pedronauck/docz/commit/344ffbb))
- **docz-core:** add docz init command ([43cdeca](https://github.com/pedronauck/docz/commit/43cdeca))
- **docz-gatsby-monorepo:** add example showing docz usage in a monorepo ([241c757](https://github.com/pedronauck/docz/commit/241c757))

# [2.0.0-rc.31](https://github.com/pedronauck/docz/compare/v2.0.0-rc.1...v2.0.0-rc.31) (2019-09-03)

### Bug Fixes

- **docz:** add @emotion/core dependency ([52126df](https://github.com/pedronauck/docz/commit/52126df))
- **docz:** better default playground component ([80b1c66](https://github.com/pedronauck/docz/commit/80b1c66))
- **docz:** bump docz-core version ([c56e0c6](https://github.com/pedronauck/docz/commit/c56e0c6))
- **docz:** initialize components context with defaultComponents ([a808795](https://github.com/pedronauck/docz/commit/a808795))
- **docz:** use playground from docz-components ([52874c4](https://github.com/pedronauck/docz/commit/52874c4))
- **docz-components:** better prop types for playground ([f35f3ca](https://github.com/pedronauck/docz/commit/f35f3ca))
- **docz-components:** fix development example ([faf2134](https://github.com/pedronauck/docz/commit/faf2134))
- **docz-components:** fix syntax highlighting in Playground ([c72c575](https://github.com/pedronauck/docz/commit/c72c575))
- **docz-components:** typo boder -> border ([1246b19](https://github.com/pedronauck/docz/commit/1246b19))
- **docz-core:** make onCreateWebpackConfig extendable ([8968a6c](https://github.com/pedronauck/docz/commit/8968a6c))
- **docz-core:** run init on build if docz is not initialized ([fe984fd](https://github.com/pedronauck/docz/commit/fe984fd))
- **docz-core:** set yarn production to false to download all deps ([1258553](https://github.com/pedronauck/docz/commit/1258553))
- **docz-core:** use react from parent directory ([#1053](https://github.com/pedronauck/docz/issues/1053)) ([b55b786](https://github.com/pedronauck/docz/commit/b55b786))
- **gatsby-theme-docz:** fix style differences between dev and build ([9cb5237](https://github.com/pedronauck/docz/commit/9cb5237))
- **gatsby-theme-docz:** replace iframe in playground with div [#984](https://github.com/pedronauck/docz/issues/984) [#1035](https://github.com/pedronauck/docz/issues/1035) ([4214180](https://github.com/pedronauck/docz/commit/4214180))

### Features

- **docz-component:** initialize ([73fafd1](https://github.com/pedronauck/docz/commit/73fafd1))
- **docz-components:** working playground ([344ffbb](https://github.com/pedronauck/docz/commit/344ffbb))
- **docz-core:** add docz init command ([2cd87ee](https://github.com/pedronauck/docz/commit/2cd87ee))
- **docz-gatsby-monorepo:** add example showing docz usage in a monorepo ([241c757](https://github.com/pedronauck/docz/commit/241c757))

# [2.0.0-rc.30](https://github.com/pedronauck/docz/compare/v2.0.0-rc.29...v2.0.0-rc.30) (2019-09-03)

### Bug Fixes

- **docz-core:** set yarn production to false to download all deps ([c9db7f1](https://github.com/pedronauck/docz/commit/c9db7f1))

# [2.0.0-rc.29](https://github.com/pedronauck/docz/compare/v2.0.0-rc.1...v2.0.0-rc.29) (2019-09-03)

### Bug Fixes

- **docz:** add @emotion/core dependency ([52126df](https://github.com/pedronauck/docz/commit/52126df))
- **docz:** better default playground component ([80b1c66](https://github.com/pedronauck/docz/commit/80b1c66))
- **docz:** bump docz-core version ([c56e0c6](https://github.com/pedronauck/docz/commit/c56e0c6))
- **docz:** initialize components context with defaultComponents ([a808795](https://github.com/pedronauck/docz/commit/a808795))
- **docz:** use playground from docz-components ([52874c4](https://github.com/pedronauck/docz/commit/52874c4))
- **docz-components:** better prop types for playground ([f35f3ca](https://github.com/pedronauck/docz/commit/f35f3ca))
- **docz-components:** fix development example ([faf2134](https://github.com/pedronauck/docz/commit/faf2134))
- **docz-components:** fix syntax highlighting in Playground ([c72c575](https://github.com/pedronauck/docz/commit/c72c575))
- **docz-components:** typo boder -> border ([1246b19](https://github.com/pedronauck/docz/commit/1246b19))
- **docz-core:** make onCreateWebpackConfig extendable ([d2aff82](https://github.com/pedronauck/docz/commit/d2aff82))
- **docz-core:** run init on build if docz is not initialized ([23bc575](https://github.com/pedronauck/docz/commit/23bc575))
- **docz-core:** use react from parent directory ([#1053](https://github.com/pedronauck/docz/issues/1053)) ([b55b786](https://github.com/pedronauck/docz/commit/b55b786))
- **gatsby-theme-docz:** fix style differences between dev and build ([9cb5237](https://github.com/pedronauck/docz/commit/9cb5237))
- **gatsby-theme-docz:** replace iframe in playground with div [#984](https://github.com/pedronauck/docz/issues/984) [#1035](https://github.com/pedronauck/docz/issues/1035) ([4214180](https://github.com/pedronauck/docz/commit/4214180))

### Features

- **docz-component:** initialize ([73fafd1](https://github.com/pedronauck/docz/commit/73fafd1))
- **docz-components:** working playground ([344ffbb](https://github.com/pedronauck/docz/commit/344ffbb))
- **docz-core:** add docz init command ([6aaa3e4](https://github.com/pedronauck/docz/commit/6aaa3e4))
- **docz-gatsby-monorepo:** add example showing docz usage in a monorepo ([241c757](https://github.com/pedronauck/docz/commit/241c757))

# [2.0.0-rc.28](https://github.com/pedronauck/docz/compare/v2.0.0-rc.1...v2.0.0-rc.28) (2019-09-03)

### Bug Fixes

- **docz:** add @emotion/core dependency ([52126df](https://github.com/pedronauck/docz/commit/52126df))
- **docz:** better default playground component ([80b1c66](https://github.com/pedronauck/docz/commit/80b1c66))
- **docz:** bump docz-core version ([c56e0c6](https://github.com/pedronauck/docz/commit/c56e0c6))
- **docz:** initialize components context with defaultComponents ([a808795](https://github.com/pedronauck/docz/commit/a808795))
- **docz:** use playground from docz-components ([52874c4](https://github.com/pedronauck/docz/commit/52874c4))
- **docz-components:** better prop types for playground ([f35f3ca](https://github.com/pedronauck/docz/commit/f35f3ca))
- **docz-components:** fix development example ([faf2134](https://github.com/pedronauck/docz/commit/faf2134))
- **docz-components:** fix syntax highlighting in Playground ([c72c575](https://github.com/pedronauck/docz/commit/c72c575))
- **docz-components:** typo boder -> border ([1246b19](https://github.com/pedronauck/docz/commit/1246b19))
- **docz-core:** make onCreateWebpackConfig extendable ([d2aff82](https://github.com/pedronauck/docz/commit/d2aff82))
- **docz-core:** use react from parent directory ([#1053](https://github.com/pedronauck/docz/issues/1053)) ([b55b786](https://github.com/pedronauck/docz/commit/b55b786))
- **gatsby-theme-docz:** fix style differences between dev and build ([9cb5237](https://github.com/pedronauck/docz/commit/9cb5237))
- **gatsby-theme-docz:** replace iframe in playground with div [#984](https://github.com/pedronauck/docz/issues/984) [#1035](https://github.com/pedronauck/docz/issues/1035) ([4214180](https://github.com/pedronauck/docz/commit/4214180))

### Features

- **docz-component:** initialize ([73fafd1](https://github.com/pedronauck/docz/commit/73fafd1))
- **docz-components:** working playground ([344ffbb](https://github.com/pedronauck/docz/commit/344ffbb))
- **docz-gatsby-monorepo:** add example showing docz usage in a monorepo ([241c757](https://github.com/pedronauck/docz/commit/241c757))

### Bug Fixes

- **docz:** add @emotion/core dependency ([52126df](https://github.com/pedronauck/docz/commit/52126df))
- **docz:** better default playground component ([80b1c66](https://github.com/pedronauck/docz/commit/80b1c66))
- **docz:** bump docz-core version ([c56e0c6](https://github.com/pedronauck/docz/commit/c56e0c6))
- **docz:** initialize components context with defaultComponents ([a808795](https://github.com/pedronauck/docz/commit/a808795))
- **docz:** use playground from docz-components ([52874c4](https://github.com/pedronauck/docz/commit/52874c4))
- **docz-components:** better prop types for playground ([f35f3ca](https://github.com/pedronauck/docz/commit/f35f3ca))
- **docz-components:** fix development example ([faf2134](https://github.com/pedronauck/docz/commit/faf2134))
- **docz-components:** fix syntax highlighting in Playground ([c72c575](https://github.com/pedronauck/docz/commit/c72c575))
- **docz-components:** typo boder -> border ([1246b19](https://github.com/pedronauck/docz/commit/1246b19))
- **docz-core:** make onCreateWebpackConfig extendable ([d2aff82](https://github.com/pedronauck/docz/commit/d2aff82))
- **docz-core:** run init on build if docz is not initialized ([23bc575](https://github.com/pedronauck/docz/commit/23bc575))
- **docz-core:** use react from parent directory ([#1053](https://github.com/pedronauck/docz/issues/1053)) ([b55b786](https://github.com/pedronauck/docz/commit/b55b786))
- **gatsby-theme-docz:** fix style differences between dev and build ([9cb5237](https://github.com/pedronauck/docz/commit/9cb5237))
- **gatsby-theme-docz:** replace iframe in playground with div [#984](https://github.com/pedronauck/docz/issues/984) [#1035](https://github.com/pedronauck/docz/issues/1035) ([4214180](https://github.com/pedronauck/docz/commit/4214180))

### Features

- **docz-component:** initialize ([73fafd1](https://github.com/pedronauck/docz/commit/73fafd1))
- **docz-components:** working playground ([344ffbb](https://github.com/pedronauck/docz/commit/344ffbb))
- **docz-core:** add docz init command ([6aaa3e4](https://github.com/pedronauck/docz/commit/6aaa3e4))
- **docz-gatsby-monorepo:** add example showing docz usage in a monorepo ([241c757](https://github.com/pedronauck/docz/commit/241c757))

# [2.0.0-rc.27](https://github.com/pedronauck/docz/compare/v2.0.0-rc.1...v2.0.0-rc.27) (2019-09-02)

### Bug Fixes

- **docz:** add @emotion/core dependency ([52126df](https://github.com/pedronauck/docz/commit/52126df))
- **docz:** better default playground component ([80b1c66](https://github.com/pedronauck/docz/commit/80b1c66))
- **docz:** bump docz-core version ([c56e0c6](https://github.com/pedronauck/docz/commit/c56e0c6))
- **docz:** initialize components context with defaultComponents ([a808795](https://github.com/pedronauck/docz/commit/a808795))
- **docz:** use playground from docz-components ([52874c4](https://github.com/pedronauck/docz/commit/52874c4))
- **docz-components:** better prop types for playground ([f35f3ca](https://github.com/pedronauck/docz/commit/f35f3ca))
- **docz-components:** fix development example ([faf2134](https://github.com/pedronauck/docz/commit/faf2134))
- **docz-components:** fix syntax highlighting in Playground ([c72c575](https://github.com/pedronauck/docz/commit/c72c575))
- **docz-components:** typo boder -> border ([d101f9c](https://github.com/pedronauck/docz/commit/d101f9c))
- **docz-core:** use react from parent directory ([#1053](https://github.com/pedronauck/docz/issues/1053)) ([b55b786](https://github.com/pedronauck/docz/commit/b55b786))
- **gatsby-theme-docz:** fix style differences between dev and build ([45b7767](https://github.com/pedronauck/docz/commit/45b7767))
- **gatsby-theme-docz:** replace iframe in playground with div [#984](https://github.com/pedronauck/docz/issues/984) [#1035](https://github.com/pedronauck/docz/issues/1035) ([4214180](https://github.com/pedronauck/docz/commit/4214180))

### Features

- **docz-component:** initialize ([73fafd1](https://github.com/pedronauck/docz/commit/73fafd1))
- **docz-components:** working playground ([344ffbb](https://github.com/pedronauck/docz/commit/344ffbb))
- **docz-gatsby-monorepo:** add example showing docz usage in a monorepo ([241c757](https://github.com/pedronauck/docz/commit/241c757))

# [2.0.0-rc.9](https://github.com/pedronauck/docz/compare/v2.0.0-rc.7...v2.0.0-rc.9) (2019-08-30)

### Bug Fixes

- **docz:** better default playground component ([f90d7a9](https://github.com/pedronauck/docz/commit/f90d7a9))
- **docz:** bump docz-core version ([f60fce8](https://github.com/pedronauck/docz/commit/f60fce8))

# [2.0.0-rc.7](https://github.com/pedronauck/docz/compare/v2.0.0-rc.6...v2.0.0-rc.7) (2019-08-29)

### Bug Fixes

- **docz:** initialize components context with defaultComponents ([ceaafea](https://github.com/pedronauck/docz/commit/ceaafea))

# [2.0.0-rc.6](https://github.com/pedronauck/docz/compare/v2.0.0-rc.1...v2.0.0-rc.6) (2019-08-29)

### Bug Fixes

- **gatsby-theme-docz:** replace iframe in playground with div [#984](https://github.com/pedronauck/docz/issues/984) [#1035](https://github.com/pedronauck/docz/issues/1035) ([cf9ea90](https://github.com/pedronauck/docz/commit/cf9ea90))

# [2.0.0-rc.2](https://github.com/pedronauck/docz/compare/v2.0.0-rc.1...v2.0.0-rc.2) (2019-08-28)

### Bug Fixes

- **docz:** make scheduler dependency explicit ([84918d8](https://github.com/pedronauck/docz/commit/84918d8))
- **docz:** remove window check from useCurrentDoc fixes [#985](https://github.com/pedronauck/docz/issues/985) ([#1023](https://github.com/pedronauck/docz/issues/1023)) ([b90ea82](https://github.com/pedronauck/docz/commit/b90ea82))
- **docz-core:** extend base config instead of overwriting user config ([#1028](https://github.com/pedronauck/docz/issues/1028)) ([7b46c2b](https://github.com/pedronauck/docz/commit/7b46c2b))
- **docz-core:** wait for app to be ready before opening the browser ([c5cd14d](https://github.com/pedronauck/docz/commit/c5cd14d))
- **docz-example-basic:** add explicit dependency to scheduler ([a4c5f9c](https://github.com/pedronauck/docz/commit/a4c5f9c))
- **docz-example-flow:** add scheduler dep ([5063fc2](https://github.com/pedronauck/docz/commit/5063fc2))
- **docz-example-styled-components:** add scheduler and remove caaf ([1d66cad](https://github.com/pedronauck/docz/commit/1d66cad))
- **docz-example-typescript:** add extension of tsx file in mdx ([f43f454](https://github.com/pedronauck/docz/commit/f43f454))
- **docz-example-typescript:** add externally usable tsconfig ([1806abb](https://github.com/pedronauck/docz/commit/1806abb))
- **docz-example-typescript:** add scheduler dep and docs [#1020](https://github.com/pedronauck/docz/issues/1020) ([fbc8e89](https://github.com/pedronauck/docz/commit/fbc8e89))
- **gatsby-theme-docz:** add missing source sans pro font ([#991](https://github.com/pedronauck/docz/issues/991)) ([51240df](https://github.com/pedronauck/docz/commit/51240df))
- **gatsby-theme-docz:** replace fragment tag to the short syntax ([#992](https://github.com/pedronauck/docz/issues/992)) ([044f351](https://github.com/pedronauck/docz/commit/044f351))

### Features

- **docz-core:** setup jest and add first test ([bf02ac1](https://github.com/pedronauck/docz/commit/bf02ac1))

# [2.0.0-rc.1](https://github.com/pedronauck/docz/compare/v1.2.0...v2.0.0-rc.1) (2019-07-18)

### Bug Fixes

- bump version ([a346b59](https://github.com/pedronauck/docz/commit/a346b59))
- resizable props import ([2926896](https://github.com/pedronauck/docz/commit/2926896))
- **babel-plugin-export-metadata:** disable enumerable for \_\_filemeta ([38d10fc](https://github.com/pedronauck/docz/commit/38d10fc))
- **babel-plugin-export-metadata:** fix root relative path ([eccbac4](https://github.com/pedronauck/docz/commit/eccbac4))
- **babel-plugin-export-metadata:** transform to Unix slash ([#825](https://github.com/pedronauck/docz/issues/825)) ([#829](https://github.com/pedronauck/docz/issues/829)) ([f823cc6](https://github.com/pedronauck/docz/commit/f823cc6))
- **docz:** component Props false positives when looking in state ([baa9bb3](https://github.com/pedronauck/docz/commit/baa9bb3))
- **docz:** parse description of props ([0672c3e](https://github.com/pedronauck/docz/commit/0672c3e))
- **docz:** props markdown compiler ([99ba83c](https://github.com/pedronauck/docz/commit/99ba83c))
- **docz-core:** create deps algorithm ([a4b8eb9](https://github.com/pedronauck/docz/commit/a4b8eb9))
- **docz-core:** some adjustments ([86f95b5](https://github.com/pedronauck/docz/commit/86f95b5))
- **docz-core:** vendor react-docgen-external-proptypes-handler ([#866](https://github.com/pedronauck/docz/issues/866)) ([efb89ee](https://github.com/pedronauck/docz/commit/efb89ee)), closes [#727](https://github.com/pedronauck/docz/issues/727)
- **gatsby-theme-docz:** entry not in context ([e582221](https://github.com/pedronauck/docz/commit/e582221))
- **gatsby-theme-docz:** resizable import ([3916265](https://github.com/pedronauck/docz/commit/3916265))
- on create webpack plugin hook ([56e974a](https://github.com/pedronauck/docz/commit/56e974a))
- packages rollup config ([534d7bf](https://github.com/pedronauck/docz/commit/534d7bf))
- remove react & react-dom from dependencies [#924](https://github.com/pedronauck/docz/issues/924) ([faf4288](https://github.com/pedronauck/docz/commit/faf4288))
- **remark-docz:** fix alias in the src of a mdx's image [#897](https://github.com/pedronauck/docz/issues/897) ([058732d](https://github.com/pedronauck/docz/commit/058732d))
- some typescript adjustments ([4ba6eaf](https://github.com/pedronauck/docz/commit/4ba6eaf))
- **gatsby-theme-docz:** prisms theme by themeConfig ([c0b5c34](https://github.com/pedronauck/docz/commit/c0b5c34))
- eslint configs ([280981f](https://github.com/pedronauck/docz/commit/280981f))
- no-undef eslint rule ([125c5cf](https://github.com/pedronauck/docz/commit/125c5cf))

### Features

- **docz-core:** ensure files before running machine ([1876540](https://github.com/pedronauck/docz/commit/1876540))
- **docz-core:** watch custom theme files ([5ee7abe](https://github.com/pedronauck/docz/commit/5ee7abe))
- **docz-core:** watch gatsby config files ([1539378](https://github.com/pedronauck/docz/commit/1539378))
- **gatsby-theme-docz:** add blockquote styles ([b9f11a1](https://github.com/pedronauck/docz/commit/b9f11a1))
- **gatsby-theme-docz:** add custom logo support ([dec4b2b](https://github.com/pedronauck/docz/commit/dec4b2b))
- **gatsby-theme-docz:** add iframe and re-resizable on playground ([6922717](https://github.com/pedronauck/docz/commit/6922717))
- **gatsby-theme-docz:** add new Pre component ([a6be6a1](https://github.com/pedronauck/docz/commit/a6be6a1))
- **gatsby-theme-docz:** add new Props component ([8eb780d](https://github.com/pedronauck/docz/commit/8eb780d))
- **gatsby-theme-docz:** add showLiveError on Playground ([e593897](https://github.com/pedronauck/docz/commit/e593897))
- **gatsby-theme-docz:** add some improvements ([03d9fec](https://github.com/pedronauck/docz/commit/03d9fec))
- **gatsby-theme-docz:** improve documentation ([80b35f8](https://github.com/pedronauck/docz/commit/80b35f8))
- a lot of improvements ([64f75da](https://github.com/pedronauck/docz/commit/64f75da))
- adapt core plugins to gatsby hooks ([4caa47a](https://github.com/pedronauck/docz/commit/4caa47a))
- add main package improvements ([8c8005d](https://github.com/pedronauck/docz/commit/8c8005d))
- add markdown parsing on props description ([1087539](https://github.com/pedronauck/docz/commit/1087539))
- add new Playground component ([7bf03b2](https://github.com/pedronauck/docz/commit/7bf03b2))
- add new theme sidebar ([a01d100](https://github.com/pedronauck/docz/commit/a01d100))
- add typescript support (need fix) ([13947f9](https://github.com/pedronauck/docz/commit/13947f9))
- docz running using gatsby under the hood ([10ffd48](https://github.com/pedronauck/docz/commit/10ffd48))
- dynamic src and root path ([c071556](https://github.com/pedronauck/docz/commit/c071556))
- open browser integration ([132c472](https://github.com/pedronauck/docz/commit/132c472))
- some playground improvements ([afa00df](https://github.com/pedronauck/docz/commit/afa00df))
- **docz-core:** add build and serve command with gatsby ([e85c82b](https://github.com/pedronauck/docz/commit/e85c82b))
- **docz-core:** add doczrc config watcher on dev ([5aa0455](https://github.com/pedronauck/docz/commit/5aa0455))
- **docz-core:** add initial gatsby bundler algorithm ([9249e34](https://github.com/pedronauck/docz/commit/9249e34))
- **gatsby-theme-docz:** improve code highlight ([d265444](https://github.com/pedronauck/docz/commit/d265444))

# [1.2.0](https://github.com/pedronauck/docz/compare/v1.1.0...v1.2.0) (2019-05-08)

### Bug Fixes

- **docz-theme-default:** allow use of link component in ssr ([#854](https://github.com/pedronauck/docz/issues/854)) ([90c27e0](https://github.com/pedronauck/docz/commit/90c27e0)), closes [#832](https://github.com/pedronauck/docz/issues/832)
- **docz-theme-default:** useMemo with conditional ([3b653e5](https://github.com/pedronauck/docz/commit/3b653e5))

### Features

- **docz-core:** add config docgen ts resolver ([#848](https://github.com/pedronauck/docz/issues/848)) ([256b600](https://github.com/pedronauck/docz/commit/256b600))
- **docz-core:** add serve command ([#855](https://github.com/pedronauck/docz/issues/855)) ([73311bd](https://github.com/pedronauck/docz/commit/73311bd))
- resolve markdown images ([#851](https://github.com/pedronauck/docz/issues/851)) ([0fb41c8](https://github.com/pedronauck/docz/commit/0fb41c8))
- **docz-core:** add config not use specifiers ([#849](https://github.com/pedronauck/docz/issues/849)) ([d8595a9](https://github.com/pedronauck/docz/commit/d8595a9))

# [1.1.0](https://github.com/pedronauck/docz/compare/v1.0.4...v1.1.0) (2019-05-01)

### Bug Fixes

- correct props loading ([#836](https://github.com/pedronauck/docz/issues/836)) ([ed85f14](https://github.com/pedronauck/docz/commit/ed85f14))
- **docz:** non latin menu headings ([#840](https://github.com/pedronauck/docz/issues/840)) ([80b186c](https://github.com/pedronauck/docz/commit/80b186c))
- **docz-core:** prevent watch in production ([d673262](https://github.com/pedronauck/docz/commit/d673262))

### Features

- **docz-core:** extended path configuration for docgen ([#846](https://github.com/pedronauck/docz/issues/846)) ([aa96739](https://github.com/pedronauck/docz/commit/aa96739))
- **docz-core:** use react-dev-utils create compiler ([4d062de](https://github.com/pedronauck/docz/commit/4d062de))
- **docz-theme-default:** add options to the props component ([#823](https://github.com/pedronauck/docz/issues/823)) ([9edaac8](https://github.com/pedronauck/docz/commit/9edaac8))

## [1.0.4](https://github.com/pedronauck/docz/compare/v1.0.3...v1.0.4) (2019-04-18)

### Bug Fixes

- **babel-plugin-export-metadata:** avoid adding \_\_filemeta to non-extensible objects ([#798](https://github.com/pedronauck/docz/issues/798)) ([794ebc4](https://github.com/pedronauck/docz/commit/794ebc4))
- **babel-plugin-export-metadata:** re-export causes meta error ([#805](https://github.com/pedronauck/docz/issues/805)) ([9401676](https://github.com/pedronauck/docz/commit/9401676))
- **docz-rollup:** fixed rollup configs to be Windows tolerant ([#812](https://github.com/pedronauck/docz/issues/812)) ([10f6bfd](https://github.com/pedronauck/docz/commit/10f6bfd))
- **docz-theme-default:** logo link point to dynamic base ([#815](https://github.com/pedronauck/docz/issues/815)) ([f7cc750](https://github.com/pedronauck/docz/commit/f7cc750))

## [1.0.3](https://github.com/pedronauck/docz/compare/v1.0.2...v1.0.3) (2019-04-15)

### Bug Fixes

- **docz:** props parser for build ([31612e7](https://github.com/pedronauck/docz/commit/31612e7))

## [1.0.2](https://github.com/pedronauck/docz/compare/v1.0.1...v1.0.2) (2019-04-15)

### Bug Fixes

- **docz-theme-default:** overlay just for mobile resolutions ([a927389](https://github.com/pedronauck/docz/commit/a927389))
- pin typescript version ([8ae97d3](https://github.com/pedronauck/docz/commit/8ae97d3))
- window check ([cfbda29](https://github.com/pedronauck/docz/commit/cfbda29))

## [1.0.1](https://github.com/pedronauck/docz/compare/v1.0.0...v1.0.1) (2019-04-14)

### Bug Fixes

- **babel-plugin-export-metadata:** fix re-export default ([#790](https://github.com/pedronauck/docz/issues/790)) ([#791](https://github.com/pedronauck/docz/issues/791)) ([89b3928](https://github.com/pedronauck/docz/commit/89b3928))

# [1.0.0](https://github.com/pedronauck/docz/compare/v1.0.0-rc.8...v1.0.0) (2019-04-11)

### Bug Fixes

- **babel-plugin-export-metadata:** remove cache folders from parse ([2978a26](https://github.com/pedronauck/docz/commit/2978a26))
- **docz:** crash using suspense ([315f7ad](https://github.com/pedronauck/docz/commit/315f7ad))
- **docz-core:** typescript doesn't work with several exports ([#771](https://github.com/pedronauck/docz/issues/771)) ([c96878d](https://github.com/pedronauck/docz/commit/c96878d))
- **docz-theme-default:** styled error margin ([53104e8](https://github.com/pedronauck/docz/commit/53104e8))
- **docz-theme-default:** table media query style ([#782](https://github.com/pedronauck/docz/issues/782)) ([205ce75](https://github.com/pedronauck/docz/commit/205ce75))

### Features

- **docz-core:** auto open browser when start dev mode ([#774](https://github.com/pedronauck/docz/issues/774)) ([c0e6c13](https://github.com/pedronauck/docz/commit/c0e6c13))

# [1.0.0-rc.4](https://github.com/pedronauck/docz/compare/v1.0.0-rc.3...v1.0.0-rc.4) (2019-03-29)

### Bug Fixes

- **docz-core:** add src as prefix on ignore ([2bae93b](https://github.com/pedronauck/docz/commit/2bae93b))
- **docz-core:** remove DataServer from production build ([b8770ec](https://github.com/pedronauck/docz/commit/b8770ec))
- add missing dependency on examples ([af8ec2d](https://github.com/pedronauck/docz/commit/af8ec2d))
- get component filename relative (fix [#706](https://github.com/pedronauck/docz/issues/706)) ([84b23ea](https://github.com/pedronauck/docz/commit/84b23ea))
- remove data server from build ([8715129](https://github.com/pedronauck/docz/commit/8715129))
- remove modularized lodash packages ([d81c568](https://github.com/pedronauck/docz/commit/d81c568))
- **docz:** incompatible props on Link ([281cb13](https://github.com/pedronauck/docz/commit/281cb13))
- **docz-core:** base prop for router ([9ca39d7](https://github.com/pedronauck/docz/commit/9ca39d7))
- **docz-core:** entries not initialized on build ([#725](https://github.com/pedronauck/docz/issues/725)) ([3e99db0](https://github.com/pedronauck/docz/commit/3e99db0))
- **docz-core:** resolve symlinks right for the react-docgen ([#699](https://github.com/pedronauck/docz/issues/699)) ([783a836](https://github.com/pedronauck/docz/commit/783a836))
- **docz-theme-default:** allows hamburger menu to be opened on mobile ([#698](https://github.com/pedronauck/docz/issues/698)) ([fd06381](https://github.com/pedronauck/docz/commit/fd06381))
- **docz-theme-default:** apply ignore in props parsing ([#723](https://github.com/pedronauck/docz/issues/723)) ([6dd068c](https://github.com/pedronauck/docz/commit/6dd068c))
- **docz-theme-default:** mobile menu following anchor clicks ([#713](https://github.com/pedronauck/docz/issues/713)) ([e3bbf1a](https://github.com/pedronauck/docz/commit/e3bbf1a))
- **docz-theme-default:** stop nested ul from rendering flat ([#714](https://github.com/pedronauck/docz/issues/714)) ([2711e6d](https://github.com/pedronauck/docz/commit/2711e6d))

# [1.0.0-rc.3](https://github.com/pedronauck/docz/compare/v1.0.0-rc.2...v1.0.0-rc.3) (2019-03-21)

### Bug Fixes

- **gatsby-theme-docz:** menu field on entry source node ([05457f2](https://github.com/pedronauck/docz/commit/05457f2))

# [1.0.0-beta.0](https://github.com/pedronauck/docz/compare/v1.0.0-alpha.1...v1.0.0-beta.0) (2019-03-19)

**Note:** Version bump only for package docz

# [1.0.0-alpha.1](https://github.com/pedronauck/docz/compare/v1.0.0-alpha.0...v1.0.0-alpha.1) (2019-03-19)

### Bug Fixes

- bump internal versions ([1658aaf](https://github.com/pedronauck/docz/commit/1658aaf))

# [1.0.0-alpha.0](https://github.com/pedronauck/docz/compare/v0.13.5...v1.0.0-alpha.0) (2019-03-19)

### Bug Fixes

- **babel-plugin-export-metadata:** update snapshot test ([6ca7b87](https://github.com/pedronauck/docz/commit/6ca7b87))
- **docz:** add window check to useWindowSize hook ([#669](https://github.com/pedronauck/docz/issues/669)) ([e4d7cb4](https://github.com/pedronauck/docz/commit/e4d7cb4))
- **docz:** merge menus on useMenus ([af4afe2](https://github.com/pedronauck/docz/commit/af4afe2))
- **docz:** merge new config for useConfig hook ([c63bbc8](https://github.com/pedronauck/docz/commit/c63bbc8))
- **docz:** optional opts for useMenus() ([571ffcd](https://github.com/pedronauck/docz/commit/571ffcd))
- **docz:** remove config conditional from hooks ([6b6f134](https://github.com/pedronauck/docz/commit/6b6f134))
- **docz:** remove null return on routes ([5bbbbb3](https://github.com/pedronauck/docz/commit/5bbbbb3))
- **docz-core:** config passed on argv ([12f6385](https://github.com/pedronauck/docz/commit/12f6385))
- **docz-core:** hot loader and mdx plugins ([0531d65](https://github.com/pedronauck/docz/commit/0531d65))
- **docz-core:** initialize config state on data server start ([#678](https://github.com/pedronauck/docz/issues/678)) ([8c740b8](https://github.com/pedronauck/docz/commit/8c740b8))
- **docz-core:** remove dev things from prod build ([3f5b5d7](https://github.com/pedronauck/docz/commit/3f5b5d7))
- **docz-core:** remove order from Entry class ([e12c37d](https://github.com/pedronauck/docz/commit/e12c37d))
- **docz-core:** write first imports ([b856168](https://github.com/pedronauck/docz/commit/b856168))
- **docz-theme-default:** active menu link ([5e04e0d](https://github.com/pedronauck/docz/commit/5e04e0d))
- **docz-theme-default:** add active class manually for gatsby ([c3faed3](https://github.com/pedronauck/docz/commit/c3faed3))
- **docz-theme-default:** react live error size ([7f2e0ff](https://github.com/pedronauck/docz/commit/7f2e0ff))
- **docz-theme-default:** support absolute page elements ([#683](https://github.com/pedronauck/docz/issues/683)) ([a4ced2b](https://github.com/pedronauck/docz/commit/a4ced2b))
- **docz-theme-default:** toggle active links on location change ([#666](https://github.com/pedronauck/docz/issues/666)) ([1274b97](https://github.com/pedronauck/docz/commit/1274b97))
- **docz-utils:** add docz imports on react live scope ([01004ed](https://github.com/pedronauck/docz/commit/01004ed))
- **gatsby-theme-docz:** add null fields for entries ([b0409a8](https://github.com/pedronauck/docz/commit/b0409a8))
- **gatsby-theme-docz:** add ssr support for styled-components ([b490010](https://github.com/pedronauck/docz/commit/b490010))
- **gatsby-theme-docz:** check entries before find on it ([8565128](https://github.com/pedronauck/docz/commit/8565128))
- **gatsby-theme-docz:** create pages hook ([2f5765e](https://github.com/pedronauck/docz/commit/2f5765e))
- **gatsby-theme-docz:** readme typo ([9e3314a](https://github.com/pedronauck/docz/commit/9e3314a))
- **gatsby-theme-docz:** throws false for json stringify ([289ca75](https://github.com/pedronauck/docz/commit/289ca75))
- gatsby theme fixes ([dcc5f19](https://github.com/pedronauck/docz/commit/dcc5f19))
- **gatsby-theme-docz:** check data before access ([8f8ed12](https://github.com/pedronauck/docz/commit/8f8ed12))
- **gatsby-theme-docz:** use options from gatsby-config ([#665](https://github.com/pedronauck/docz/issues/665)) ([c694bdf](https://github.com/pedronauck/docz/commit/c694bdf))
- **rehype-docz:** update tests ([548f940](https://github.com/pedronauck/docz/commit/548f940))
- immutable merge with lodash ([2fe94d4](https://github.com/pedronauck/docz/commit/2fe94d4))
- **remark-docz:** visit correct nodes ([d5e243d](https://github.com/pedronauck/docz/commit/d5e243d))
- some general adjustments ([0c61f64](https://github.com/pedronauck/docz/commit/0c61f64))
- **load-cfg:** merge default config on load ([d3b4bc6](https://github.com/pedronauck/docz/commit/d3b4bc6))
- use lodash merge instead of deepmerge ([18ac37b](https://github.com/pedronauck/docz/commit/18ac37b))
- **docz-theme-default:** styles adjustments ([aca1bee](https://github.com/pedronauck/docz/commit/aca1bee))
- **gatsby-theme-docz:** add specific nodes for entries ([26f7f90](https://github.com/pedronauck/docz/commit/26f7f90))
- define right internal dependencies version ([30a91b4](https://github.com/pedronauck/docz/commit/30a91b4))
- prop types parser ([a3cc319](https://github.com/pedronauck/docz/commit/a3cc319))
- **babel-plugin-export-metadata:** just define pro non-primitive types ([ed78a13](https://github.com/pedronauck/docz/commit/ed78a13))
- **babel-plugin-export-metadata:** prettier fix script ([3a34b72](https://github.com/pedronauck/docz/commit/3a34b72))
- **docz:** remove deduplicated search results (thanks [@ivan-dalmet](https://github.com/ivan-dalmet)) ([1b456f7](https://github.com/pedronauck/docz/commit/1b456f7))
- **docz:** sort menu and submenus alphabetically ([fbbd51c](https://github.com/pedronauck/docz/commit/fbbd51c))
- **docz:** use @loadable/component instead of react-imported-component ([18f02f2](https://github.com/pedronauck/docz/commit/18f02f2))
- **docz-core:** add spaces when write db.json ([3a84af3](https://github.com/pedronauck/docz/commit/3a84af3))
- **docz-core:** add typescript as dependency ([9f314cd](https://github.com/pedronauck/docz/commit/9f314cd))
- **docz-core:** apply mdast plugins to entries parse too ([c2554b8](https://github.com/pedronauck/docz/commit/c2554b8))
- **docz-core:** docgen if file has not component definition ([b0fb846](https://github.com/pedronauck/docz/commit/b0fb846))
- **docz-core:** exclude node modules from source map loader ([1c7c9f7](https://github.com/pedronauck/docz/commit/1c7c9f7))
- **docz-core:** mdx loader options ([9114f9b](https://github.com/pedronauck/docz/commit/9114f9b))
- **docz-core:** props state parser ([87767e8](https://github.com/pedronauck/docz/commit/87767e8))
- **docz-core:** react docgen typescript performance ([2967e7c](https://github.com/pedronauck/docz/commit/2967e7c))
- **docz-core:** return http server on bundler.start() ([cdba3bf](https://github.com/pedronauck/docz/commit/cdba3bf))
- **docz-core:** run right hook name ([f500971](https://github.com/pedronauck/docz/commit/f500971))
- **docz-theme-default:** fix padding in Playground elements ([4af7376](https://github.com/pedronauck/docz/commit/4af7376)), closes [/github.com/pedronauck/docz/issues/398#issuecomment-453663552](https://github.com//github.com/pedronauck/docz/issues/398/issues/issuecomment-453663552)
- **docz-theme-default:** force codemirror to refresh ([#637](https://github.com/pedronauck/docz/issues/637)) ([#638](https://github.com/pedronauck/docz/issues/638)) ([e745c7d](https://github.com/pedronauck/docz/commit/e745c7d))
- **docz-theme-default:** show cursor on playground editor focus ([9f99c30](https://github.com/pedronauck/docz/commit/9f99c30))
- **docz-theme-default:** show heading anchor on hover ([3e453f5](https://github.com/pedronauck/docz/commit/3e453f5))
- **docz-utils:** extract headings from ast ([9f8565b](https://github.com/pedronauck/docz/commit/9f8565b))
- **docz-utils:** parser config for prettier ([54ad0fa](https://github.com/pedronauck/docz/commit/54ad0fa))
- **gatsby-theme-docz:** hot reload ([bf4e440](https://github.com/pedronauck/docz/commit/bf4e440))
- **gatsby-theme-docz:** use createPages instead of createPagesStatefully ([37b73c6](https://github.com/pedronauck/docz/commit/37b73c6))
- **load-cfg:** use babel register in order to require using es6 ([7ad3b64](https://github.com/pedronauck/docz/commit/7ad3b64))
- a lot of bug fixes ([c10a8bd](https://github.com/pedronauck/docz/commit/c10a8bd))
- scroll to anchor if url has hash ([389577f](https://github.com/pedronauck/docz/commit/389577f))
- trim whitespaces before and after class ([a184913](https://github.com/pedronauck/docz/commit/a184913))
- use custom rollup config to build instead of libundler ([ee42a5a](https://github.com/pedronauck/docz/commit/ee42a5a))
- wrapper property is ignored in <Playground> ([3cda0de](https://github.com/pedronauck/docz/commit/3cda0de))

### Features

- **docz:** add filter option for useMenus ([aeeb311](https://github.com/pedronauck/docz/commit/aeeb311))
- **docz:** use getInitialProps instead of getInitialData ([d4406e0](https://github.com/pedronauck/docz/commit/d4406e0))
- new Props component ([80451b1](https://github.com/pedronauck/docz/commit/80451b1))
- **docz:** hooks migrations ([f57f987](https://github.com/pedronauck/docz/commit/f57f987))
- **docz-core:** remove ordering deprecated field ([39660bb](https://github.com/pedronauck/docz/commit/39660bb))
- **docz-core:** support for configuring the separator during slugifying ([10bb134](https://github.com/pedronauck/docz/commit/10bb134))
- **docz-theme-default:** automatically render links with relative path ([624bbf0](https://github.com/pedronauck/docz/commit/624bbf0))
- **docz-theme-default:** use styled-components instead of emotion ([19047fd](https://github.com/pedronauck/docz/commit/19047fd))
- **gatsby-theme-docz:** add custom theme support ([fdfddcb](https://github.com/pedronauck/docz/commit/fdfddcb))
- **gatsby-theme-docz:** add wrapper support ([a99d62f](https://github.com/pedronauck/docz/commit/a99d62f))
- add initial gatsby integration ([#630](https://github.com/pedronauck/docz/issues/630)) ([70d40cc](https://github.com/pedronauck/docz/commit/70d40cc)), closes [#609](https://github.com/pedronauck/docz/issues/609)
- add playground component ([cde6511](https://github.com/pedronauck/docz/commit/cde6511))
- docgen refactoring ([#545](https://github.com/pedronauck/docz/issues/545)) ([85499a8](https://github.com/pedronauck/docz/commit/85499a8))
- split router logic from theme ([a9c26e6](https://github.com/pedronauck/docz/commit/a9c26e6))
- use @reach/router instead of react-router ([81a4a82](https://github.com/pedronauck/docz/commit/81a4a82))

### BREAKING CHANGES

- <Playground> does not wrap the component anymore before
  passing it to the renderer. Instead it passes the wrapper explicitly to
  the renderer, making it the renderer's duty to apply the wrapper.

## [0.13.6](https://github.com/pedronauck/docz/compare/v0.13.5...v0.13.6) (2018-12-26)

### Bug Fixes

- **docz-core:** default value for arguments ([5644343](https://github.com/pedronauck/docz/commit/5644343))
- **docz-core:** happypack plugin name ([cbf7692](https://github.com/pedronauck/docz/commit/cbf7692))

## [0.13.5](https://github.com/pedronauck/docz/compare/v0.13.4...v0.13.5) (2018-12-19)

### Bug Fixes

- **docz-core:** add react docgen loader inside happypack ([4433561](https://github.com/pedronauck/docz/commit/4433561))
- **docz-core:** close data server when need ([6a2b96a](https://github.com/pedronauck/docz/commit/6a2b96a))
- **docz-core:** escape template string in playground ([#529](https://github.com/pedronauck/docz/issues/529)) ([5ab2349](https://github.com/pedronauck/docz/commit/5ab2349))
- **docz-core:** public folder in dev mode ([abb3626](https://github.com/pedronauck/docz/commit/abb3626))
- **docz-core:** webpack dev server log level ([1d72539](https://github.com/pedronauck/docz/commit/1d72539))
- **docz-theme-default:** add default value for rgba of polished ([dcb74af](https://github.com/pedronauck/docz/commit/dcb74af))
- **docz-utils:** add missing dependency for codesandbox ([3a51066](https://github.com/pedronauck/docz/commit/3a51066))
- **docz-utils:** escape code for playground ([3fc4187](https://github.com/pedronauck/docz/commit/3fc4187))

## [0.13.4](https://github.com/pedronauck/docz/compare/v0.13.3...v0.13.4) (2018-12-17)

### Bug Fixes

- **docz-theme-default:** remove overflow from playground wrapper ([e007762](https://github.com/pedronauck/docz/commit/e007762))

## [0.13.3](https://github.com/pedronauck/docz/compare/v0.13.2...v0.13.3) (2018-12-17)

### Bug Fixes

- **docz-core:** react hot loader config for hooks ([444cac2](https://github.com/pedronauck/docz/commit/444cac2))

### Features

- **docz-core:** add sourcemap config argument ([3baad4a](https://github.com/pedronauck/docz/commit/3baad4a))

## [0.13.2](https://github.com/pedronauck/docz/compare/v0.13.1...v0.13.2) (2018-12-17)

### Bug Fixes

- **docz-core:** ensure dir for promise logger ([6240f21](https://github.com/pedronauck/docz/commit/6240f21))

## [0.13.1](https://github.com/pedronauck/docz/compare/v0.13.0...v0.13.1) (2018-12-17)

### Bug Fixes

- **docz-core:** typescript loader config ([01f568e](https://github.com/pedronauck/docz/commit/01f568e))

# [0.13.0](https://github.com/pedronauck/docz/compare/v0.12.17...v0.13.0) (2018-12-17)

### Bug Fixes

- **docz:** ts warning ([19ccc09](https://github.com/pedronauck/docz/commit/19ccc09))
- **docz-core:** add setMaxListener for chokidar watchers ([6053c16](https://github.com/pedronauck/docz/commit/6053c16))
- **docz-core:** log level based on debug argument ([507e149](https://github.com/pedronauck/docz/commit/507e149))
- **docz-core:** node path resolve modules merge ([27102fd](https://github.com/pedronauck/docz/commit/27102fd))
- **docz-core:** turn off htmlMinifier when loading from templates ([#518](https://github.com/pedronauck/docz/issues/518)) ([9cb0e1d](https://github.com/pedronauck/docz/commit/9cb0e1d))
- **docz-core:** use webpack-dev-server instead of webpack-serve ([4157e05](https://github.com/pedronauck/docz/commit/4157e05))

### Features

- **docz-core:** add onCreateWebpackChain hook ([70bb242](https://github.com/pedronauck/docz/commit/70bb242))
- **docz-core:** add promise logger using progress-estimator ([2797608](https://github.com/pedronauck/docz/commit/2797608))
- **docz-core:** use NODE_PATH to resolve modules ([#516](https://github.com/pedronauck/docz/issues/516)) ([cc86f93](https://github.com/pedronauck/docz/commit/cc86f93))
- **docz-theme-default:** set max lines before scroll editor ([#519](https://github.com/pedronauck/docz/issues/519)) ([698261b](https://github.com/pedronauck/docz/commit/698261b))

## [0.12.17](https://github.com/pedronauck/docz/compare/v0.12.16...v0.12.17) (2018-12-14)

### Bug Fixes

- **docz:** cycled dependency ([5132195](https://github.com/pedronauck/docz/commit/5132195))
- **docz-theme-default:** link color ([21d58fb](https://github.com/pedronauck/docz/commit/21d58fb))
- **docz-theme-default:** some fixes on styles ([a17e914](https://github.com/pedronauck/docz/commit/a17e914))
- **docz-theme-default:** use theme getter instead of literal obj access ([89e1d03](https://github.com/pedronauck/docz/commit/89e1d03))

## [0.12.16](https://github.com/pedronauck/docz/compare/v0.12.15...v0.12.16) (2018-12-13)

### Bug Fixes

- **docz-core:** correct koa mounting path on windows systems ([#491](https://github.com/pedronauck/docz/issues/491)) ([6addd32](https://github.com/pedronauck/docz/commit/6addd32))
- **docz-theme-default:** refresh editor after it's mounted ([#406](https://github.com/pedronauck/docz/issues/406)) ([#506](https://github.com/pedronauck/docz/issues/506)) ([c67fa41](https://github.com/pedronauck/docz/commit/c67fa41))
- edit page button is overlayed by github link ([341e03a](https://github.com/pedronauck/docz/commit/341e03a))
- **docz-theme-default:** ts warning ([452904b](https://github.com/pedronauck/docz/commit/452904b))

## [0.12.15](https://github.com/pedronauck/docz/compare/v0.12.14...v0.12.15) (2018-12-04)

### Bug Fixes

- babel class plugin update ([236331a](https://github.com/pedronauck/docz/commit/236331a))
- **docz-core:** add setMaxListener in the top of script ([2eef307](https://github.com/pedronauck/docz/commit/2eef307))
- **docz-core:** update react-hot-loader to support hooks ([4394a5b](https://github.com/pedronauck/docz/commit/4394a5b))

### Features

- add native support for react-native ([f998874](https://github.com/pedronauck/docz/commit/f998874))

## [0.12.14](https://github.com/pedronauck/docz/compare/v0.12.13...v0.12.14) (2018-12-04)

### Bug Fixes

- some typings warnings ([4afb87b](https://github.com/pedronauck/docz/commit/4afb87b))
- **docz-core:** set max listener ([898010b](https://github.com/pedronauck/docz/commit/898010b))
- **docz-core:** watcher close ([caa8151](https://github.com/pedronauck/docz/commit/caa8151))
- **docz-theme-default:** editor border-radius ([7a7d1f8](https://github.com/pedronauck/docz/commit/7a7d1f8))
- **docz-theme-default:** overlay logic ([8b3fdc9](https://github.com/pedronauck/docz/commit/8b3fdc9))
- **docz-theme-default:** playground relative position ([a097b5f](https://github.com/pedronauck/docz/commit/a097b5f))

### Features

- **docz:** add preload async route ([f800c70](https://github.com/pedronauck/docz/commit/f800c70))

## [0.12.13](https://github.com/pedronauck/docz/compare/v0.12.12...v0.12.13) (2018-11-23)

### Bug Fixes

- **docz:** resolve react warnings in ErrorReporter ([#465](https://github.com/pedronauck/docz/issues/465)) ([1b0e09d](https://github.com/pedronauck/docz/commit/1b0e09d))
- **docz-theme-default:** fixes flexbox text overflow issue ([#471](https://github.com/pedronauck/docz/issues/471)) ([b37f25e](https://github.com/pedronauck/docz/commit/b37f25e))
- **docz-theme-default:** fullscreen mode ([ac02c17](https://github.com/pedronauck/docz/commit/ac02c17))
- **rehype-docz:** scope for playground ([677a785](https://github.com/pedronauck/docz/commit/677a785))

## [0.12.12](https://github.com/pedronauck/docz/compare/v0.12.11...v0.12.12) (2018-11-16)

### Bug Fixes

- **docz-theme-default:** add theme provider around all theme ([5596446](https://github.com/pedronauck/docz/commit/5596446))
- **docz-utils:** add .scss to codesandbox assemble files ([59e8fa8](https://github.com/pedronauck/docz/commit/59e8fa8))

## [0.12.11](https://github.com/pedronauck/docz/compare/v0.12.10...v0.12.11) (2018-11-15)

### Bug Fixes

- **docz-core:** add happypack again :cry: ([f0e219e](https://github.com/pedronauck/docz/commit/f0e219e))
- **docz-core:** create app files before start server ([43bc3fd](https://github.com/pedronauck/docz/commit/43bc3fd))
- **docz-theme-default:** adjust z-index of menu ([ea9a864](https://github.com/pedronauck/docz/commit/ea9a864))
- **docz-theme-default:** font size of heading ([5cf6144](https://github.com/pedronauck/docz/commit/5cf6144))

## [0.12.10](https://github.com/pedronauck/docz/compare/v0.12.9...v0.12.10) (2018-11-15)

### Bug Fixes

- **docz-core:** add cache just for non-debug ([cede436](https://github.com/pedronauck/docz/commit/cede436))
- **docz-core:** add default favicon ([a0ed2ab](https://github.com/pedronauck/docz/commit/a0ed2ab))
- **docz-core:** add ignore md files by args ([d8c8045](https://github.com/pedronauck/docz/commit/d8c8045))
- **docz-core:** kill server on signals ([be0855f](https://github.com/pedronauck/docz/commit/be0855f))
- **docz-core:** use assets from public folder ([210c3a1](https://github.com/pedronauck/docz/commit/210c3a1))
- **docz-theme-default:** add styles or classname on playground ([01110d4](https://github.com/pedronauck/docz/commit/01110d4))
- **docz-utils:** resolve codesandbox code ([33dc6e5](https://github.com/pedronauck/docz/commit/33dc6e5))

### Features

- **docz-core:** add detect-one-changed in development ([#433](https://github.com/pedronauck/docz/issues/433)) ([0585b97](https://github.com/pedronauck/docz/commit/0585b97))
- **docz-core:** add two new plugin hooks ([#431](https://github.com/pedronauck/docz/issues/431)) ([f4a122f](https://github.com/pedronauck/docz/commit/f4a122f))
- **docz-theme-default:** show and hide playground ([b665f81](https://github.com/pedronauck/docz/commit/b665f81))

## [0.12.9](https://github.com/pedronauck/docz/compare/v0.12.8...v0.12.9) (2018-11-01)

### Bug Fixes

- **docz-theme-default:** table margin bottom ([36e322f](https://github.com/pedronauck/docz/commit/36e322f))
- **docz-theme-default:** use class inside playground ([cecbea1](https://github.com/pedronauck/docz/commit/cecbea1))

### Features

- **docz-theme-default:** add style for hr component ([5b24400](https://github.com/pedronauck/docz/commit/5b24400))
- **docz-theme-default:** hide playground editor by default ([0ccda92](https://github.com/pedronauck/docz/commit/0ccda92))

## [0.12.8](https://github.com/pedronauck/docz/compare/v0.12.7...v0.12.8) (2018-10-31)

### Bug Fixes

- **docz:** update to new react imported component api ([759160e](https://github.com/pedronauck/docz/commit/759160e))
- **docz-core:** add support to react hooks ([f26a990](https://github.com/pedronauck/docz/commit/f26a990))

## [0.12.7](https://github.com/pedronauck/docz/compare/v0.12.6...v0.12.7) (2018-10-30)

### Bug Fixes

- **docz-core:** webpack chain minimizer config ([ab13208](https://github.com/pedronauck/docz/commit/ab13208))

## [0.12.6](https://github.com/pedronauck/docz/compare/v0.12.5...v0.12.6) (2018-10-30)

### Bug Fixes

- **docz:** conditionally description column on PropsTable ([#385](https://github.com/pedronauck/docz/issues/385)) ([829a3aa](https://github.com/pedronauck/docz/commit/829a3aa)), closes [#427](https://github.com/pedronauck/docz/issues/427) [#421](https://github.com/pedronauck/docz/issues/421)
- **docz-theme-default:** fill adjustments ([119e4a7](https://github.com/pedronauck/docz/commit/119e4a7))
- **docz-theme-default:** rename playground container to avoid conflicts ([#429](https://github.com/pedronauck/docz/issues/429)) ([86845bf](https://github.com/pedronauck/docz/commit/86845bf))
- **docz-theme-default:** text alignment in table thead ([#403](https://github.com/pedronauck/docz/issues/403)) ([475eb52](https://github.com/pedronauck/docz/commit/475eb52))
- **docz-theme-default:** tooltip component ([9234b5e](https://github.com/pedronauck/docz/commit/9234b5e))

### Features

- add support to disable codesandbox ([be94b0e](https://github.com/pedronauck/docz/commit/be94b0e))
- **docz:** render [Empty String] on PropsTable ([#427](https://github.com/pedronauck/docz/issues/427)) ([10a3eda](https://github.com/pedronauck/docz/commit/10a3eda))
- **docz:** render [Empty String] on PropsTable ([#427](https://github.com/pedronauck/docz/issues/427)) ([2a9db98](https://github.com/pedronauck/docz/commit/2a9db98))
- **docz-theme-default:** add code editor toggle on playground ([#387](https://github.com/pedronauck/docz/issues/387)) ([f833eaa](https://github.com/pedronauck/docz/commit/f833eaa))
- **docz-theme-default:** add support to show/hide playground editor ([cacc6fb](https://github.com/pedronauck/docz/commit/cacc6fb))

<a name="0.12.5"></a>

## [0.12.5](https://github.com/pedronauck/docz/compare/v0.12.4...v0.12.5) (2018-09-30)

### Bug Fixes

- **docz-core:** close dataserver connection on build ([0f6bd7b](https://github.com/pedronauck/docz/commit/0f6bd7b))
- **docz-theme-default:** adjust theme colors ([eed7212](https://github.com/pedronauck/docz/commit/eed7212))

<a name="0.12.4"></a>

## [0.12.4](https://github.com/pedronauck/docz/compare/v0.12.3...v0.12.4) (2018-09-28)

### Bug Fixes

- **docz:** merge menus and submenus ([f8249da](https://github.com/pedronauck/docz/commit/f8249da))

<a name="0.12.3"></a>

## [0.12.3](https://github.com/pedronauck/docz/compare/v0.12.2...v0.12.3) (2018-09-28)

### Bug Fixes

- **docz:** remove Children.only ([656d8f1](https://github.com/pedronauck/docz/commit/656d8f1))

<a name="0.11.2"></a>

## [0.11.2](https://github.com/pedronauck/docz/compare/v0.11.1...v0.11.2) (2018-09-11)

### Bug Fixes

- **docz:** prevent crash when use imported props ([ef6de9d](https://github.com/pedronauck/docz/commit/ef6de9d))
- **docz-core:** add watcher outside of update method scope ([18c744d](https://github.com/pedronauck/docz/commit/18c744d))
- **docz-core:** prevent entries block when parse mdx crash ([07ae769](https://github.com/pedronauck/docz/commit/07ae769))
- **docz-core:** remove https option and fix message ([#321](https://github.com/pedronauck/docz/issues/321)) ([ea88841](https://github.com/pedronauck/docz/commit/ea88841))
- **docz-theme-default:** scrolling and overflows performance ([a28ab79](https://github.com/pedronauck/docz/commit/a28ab79))
- heading hash link with hash router config ([7d7f557](https://github.com/pedronauck/docz/commit/7d7f557))

### Features

- add native config for doczrc ([2580712](https://github.com/pedronauck/docz/commit/2580712))

<a name="0.11.1"></a>

## [0.11.1](https://github.com/pedronauck/docz/compare/v0.11.0...v0.11.1) (2018-09-07)

### Bug Fixes

- **docz:** add react router inside the docz bundle ([a293aa4](https://github.com/pedronauck/docz/commit/a293aa4))
- **docz-core:** basename configuration ([5fad743](https://github.com/pedronauck/docz/commit/5fad743))
- update no documents found text ([#289](https://github.com/pedronauck/docz/issues/289)) ([cb782f9](https://github.com/pedronauck/docz/commit/cb782f9))
- **docz-core:** chokidar performance improvements ([0c344d8](https://github.com/pedronauck/docz/commit/0c344d8))
- **docz-core:** literal value of headings for menus ([85e4083](https://github.com/pedronauck/docz/commit/85e4083))
- **docz-core:** open js and ts loader scope of files ([03c01b7](https://github.com/pedronauck/docz/commit/03c01b7))
- **docz-theme-default:** prevent sidebar toggle on desktop ([7a3b97d](https://github.com/pedronauck/docz/commit/7a3b97d))

### Features

- **docz-core:** add config as parameter for onPrebuild and onPostBuild ([98692bb](https://github.com/pedronauck/docz/commit/98692bb))

<a name="0.11.0"></a>

# [0.11.0](https://github.com/pedronauck/docz/compare/v0.10.3...v0.11.0) (2018-09-02)

### Bug Fixes

- **docz-core:** dispose hmr on imports ([ba51086](https://github.com/pedronauck/docz/commit/ba51086))
- **docz-core:** join head tags ([#255](https://github.com/pedronauck/docz/issues/255)) ([065e8b3](https://github.com/pedronauck/docz/commit/065e8b3))
- **docz-core:** update react-docgen-typescript-loader to fix props table ([34b2fdf](https://github.com/pedronauck/docz/commit/34b2fdf))
- **docz-plugin-css:** fix empty loaderOpts ([193367b](https://github.com/pedronauck/docz/commit/193367b))
- **docz-plugin-css:** fix empty loaderOpts ([bb9b946](https://github.com/pedronauck/docz/commit/bb9b946))
- **docz-theme-default:** add prop to keep codemirror last line ([5c1e813](https://github.com/pedronauck/docz/commit/5c1e813))
- **docz-theme-default:** add prop to keep codemirror last line ([bf19ad5](https://github.com/pedronauck/docz/commit/bf19ad5))
- **docz-theme-default:** codemirror line end bug ([9b07d27](https://github.com/pedronauck/docz/commit/9b07d27))
- **docz-theme-default:** fix mobile menu peaking ([#262](https://github.com/pedronauck/docz/issues/262)) ([77b627f](https://github.com/pedronauck/docz/commit/77b627f))
- **docz-theme-default:** remove react-breakpoints ([c8288b0](https://github.com/pedronauck/docz/commit/c8288b0))
- **docz-theme-default:** update the empty message ([9db9231](https://github.com/pedronauck/docz/commit/9db9231))
- **load-cfg:** use fs-extra to read json sync instead of JSON.parse ([04d1e1a](https://github.com/pedronauck/docz/commit/04d1e1a))
- base url and hash router making weird url ([f483638](https://github.com/pedronauck/docz/commit/f483638))

### Features

- add link of repository from website ([#245](https://github.com/pedronauck/docz/issues/245)) ([85cc9e7](https://github.com/pedronauck/docz/commit/85cc9e7))
- **babel-preset-docz:** add new babel preset ([5efb568](https://github.com/pedronauck/docz/commit/5efb568))
- **docz:** move docz/docz-core to dev dependency on examples ([e7153a4](https://github.com/pedronauck/docz/commit/e7153a4))
- integration with react native ([#271](https://github.com/pedronauck/docz/issues/271)) ([ac359ce](https://github.com/pedronauck/docz/commit/ac359ce))
- **docz-example-styled-components:** add new example ([0cef75e](https://github.com/pedronauck/docz/commit/0cef75e))
- **docz-theme-default:** add auto close tags on playground editor ([a6e5cf7](https://github.com/pedronauck/docz/commit/a6e5cf7))
- **docz-theme-default:** add blockquote component ([86ada87](https://github.com/pedronauck/docz/commit/86ada87))
- **docz-theme-default:** add refresh btn on playground ([#254](https://github.com/pedronauck/docz/issues/254)) ([ebefd91](https://github.com/pedronauck/docz/commit/ebefd91)), closes [#251](https://github.com/pedronauck/docz/issues/251)
- **docz-theme-default:** add scrollbar on playground ([#279](https://github.com/pedronauck/docz/issues/279)) ([0f6ea2a](https://github.com/pedronauck/docz/commit/0f6ea2a))

<a name="0.10.3"></a>

## [0.10.3](https://github.com/pedronauck/docz/compare/v0.9.6...v0.10.3) (2018-08-16)

### Bug Fixes

- **docz-core:** correct data server websocket port ([47fe714](https://github.com/pedronauck/docz/commit/47fe714))
- **docz-core:** try catch on get repo info ([2016736](https://github.com/pedronauck/docz/commit/2016736))
- **docz-example-typescript:** fix dependencies ([#222](https://github.com/pedronauck/docz/issues/222)) ([67e68aa](https://github.com/pedronauck/docz/commit/67e68aa))
- **docz-theme-default:** add playground min-height just on fullscreen ([a82903a](https://github.com/pedronauck/docz/commit/a82903a))
- **docz-theme-default:** use padding on link instead of margin ([b15457c](https://github.com/pedronauck/docz/commit/b15457c))

### Features

- **docz-core:** add editBranch option to mount repo link ([c619d9c](https://github.com/pedronauck/docz/commit/c619d9c))

<a name="0.10.2"></a>

## [0.10.2](https://github.com/pedronauck/docz/compare/v0.10.1...v0.10.2) (2018-08-13)

### Bug Fixes

- prevent codemirror bug on build ([3d0894e](https://github.com/pedronauck/docz/commit/3d0894e))
- **docz-core:** remove data server cache :confused: ([9683280](https://github.com/pedronauck/docz/commit/9683280))
- **docz-core:** try catch on get repo info ([bdfbf0b](https://github.com/pedronauck/docz/commit/bdfbf0b))

<a name="0.10.1"></a>

## [0.10.1](https://github.com/pedronauck/docz/compare/v0.10.0...v0.10.1) (2018-08-13)

### Bug Fixes

- **docz-core:** prevent crash when not have cache ([cd3609a](https://github.com/pedronauck/docz/commit/cd3609a))
- **docz-example-flow:** scale and outline props ([#211](https://github.com/pedronauck/docz/issues/211)) ([c8a4195](https://github.com/pedronauck/docz/commit/c8a4195))

<a name="0.10.0"></a>

# [0.10.0](https://github.com/pedronauck/docz/compare/v0.9.6...v0.10.0) (2018-08-13)

### Bug Fixes

- bug template typo ([#197](https://github.com/pedronauck/docz/issues/197)) ([497fcfb](https://github.com/pedronauck/docz/commit/497fcfb))
- bug template typo ([#197](https://github.com/pedronauck/docz/issues/197)) ([fce98c4](https://github.com/pedronauck/docz/commit/fce98c4))
- **docz:** add initial loading as true ([3f05536](https://github.com/pedronauck/docz/commit/3f05536))
- **docz-core:** prevent crash on delete entry ([28e1728](https://github.com/pedronauck/docz/commit/28e1728))
- **docz-core:** prevent delete entire app folder on build ([e345896](https://github.com/pedronauck/docz/commit/e345896))
- **docz-theme-default:** playground overflow on mobile ([db1eb5b](https://github.com/pedronauck/docz/commit/db1eb5b))
- **rehype-docz:** add props on playground scope ([ee4b6c0](https://github.com/pedronauck/docz/commit/ee4b6c0))
- **rehype-docz:** allow ticks and backticks inside playground ([#203](https://github.com/pedronauck/docz/issues/203)) ([fa4ff40](https://github.com/pedronauck/docz/commit/fa4ff40))

### Features

- **docz:** fetch data on documents ([04ff0d6](https://github.com/pedronauck/docz/commit/04ff0d6))
- **docz-core:** add cache system for entries ([b90e598](https://github.com/pedronauck/docz/commit/b90e598))
- **docz-core:** add htmlContext and mini-html-webpack-plugin ([4b6ec0f](https://github.com/pedronauck/docz/commit/4b6ec0f))
- **docz-core:** resolve markdown files by default ([#210](https://github.com/pedronauck/docz/issues/210)) ([e0a95b3](https://github.com/pedronauck/docz/commit/e0a95b3))
- add github repository link ([78a19f6](https://github.com/pedronauck/docz/commit/78a19f6))
- allow edit code inside playground ([#205](https://github.com/pedronauck/docz/issues/205)) ([4f948f7](https://github.com/pedronauck/docz/commit/4f948f7))

<a name="0.9.6"></a>

## [0.9.6](https://github.com/pedronauck/docz/compare/v0.9.5...v0.9.6) (2018-08-06)

### Bug Fixes

- **docz-core:** remove [@babel](https://github.com/babel)/runtime alias ([0dbd8f0](https://github.com/pedronauck/docz/commit/0dbd8f0))
- **docz-theme-default:** using lodash.get to prevent classname crash ([befc643](https://github.com/pedronauck/docz/commit/befc643))

<a name="0.9.5"></a>

## [0.9.5](https://github.com/pedronauck/docz/compare/v0.9.4...v0.9.5) (2018-08-04)

### Bug Fixes

- **docz-theme-default:** copy html output ([#189](https://github.com/pedronauck/docz/issues/189)) ([2cb834c](https://github.com/pedronauck/docz/commit/2cb834c))

<a name="0.9.4"></a>

## [0.9.4](https://github.com/pedronauck/docz/compare/v0.9.4-beta.1...v0.9.4) (2018-08-04)

### Bug Fixes

- **docz-core:** use of src config in edit button link ([#186](https://github.com/pedronauck/docz/issues/186)) ([553f90c](https://github.com/pedronauck/docz/commit/553f90c))
- remove external deps ([470bdd3](https://github.com/pedronauck/docz/commit/470bdd3))

<a name="0.9.3"></a>

## [0.9.3](https://github.com/pedronauck/docz/compare/v0.9.2...v0.9.3) (2018-08-03)

### Bug Fixes

- **docz-core:** use of src config in edit button link ([#186](https://github.com/pedronauck/docz/issues/186)) ([553f90c](https://github.com/pedronauck/docz/commit/553f90c))

<a name="0.9.2"></a>

## [0.9.2](https://github.com/pedronauck/docz/compare/v0.9.1...v0.9.2) (2018-08-02)

### Bug Fixes

- **docz-core:** add isProd to remove hot client overlay on build ([83f2e36](https://github.com/pedronauck/docz/commit/83f2e36))

<a name="0.9.1"></a>

## [0.9.1](https://github.com/pedronauck/docz/compare/v0.9.0...v0.9.1) (2018-08-02)

### Bug Fixes

- **docz:** finish process after build ([58bebb6](https://github.com/pedronauck/docz/commit/58bebb6))

<a name="0.9.0"></a>

# [0.9.0](https://github.com/pedronauck/docz/compare/v0.9.0-beta.1...v0.9.0) (2018-08-02)

### Bug Fixes

- **docz:** transform and merge theme config ([999ab73](https://github.com/pedronauck/docz/commit/999ab73))
- **docz:** using context for imports to prevent disposed hmr ([b37284c](https://github.com/pedronauck/docz/commit/b37284c))
- **docz-plugin-babel6:** change babel syntax dynamic import when needed ([8cb278a](https://github.com/pedronauck/docz/commit/8cb278a))
- **docz-plugin-css:** pass default parameter ([389979a](https://github.com/pedronauck/docz/commit/389979a))
- **docz-theme-default:** support chinese input method ([#182](https://github.com/pedronauck/docz/issues/182)) ([94544a6](https://github.com/pedronauck/docz/commit/94544a6))
- **docz-theme-default:** table layout adjustment ([e8e8ec8](https://github.com/pedronauck/docz/commit/e8e8ec8))
- **docz-theme-default:** use docz link when href is internal ([00deef5](https://github.com/pedronauck/docz/commit/00deef5))

<a name="0.9.0-beta.1"></a>

# [0.9.0-beta.1](https://github.com/pedronauck/docz/compare/v0.9.0-beta.0...v0.9.0-beta.1) (2018-08-01)

**Note:** Version bump only for package undefined

<a name="0.9.0-beta.0"></a>

# [0.9.0-beta.0](https://github.com/pedronauck/docz/compare/v0.8.0...v0.9.0-beta.0) (2018-08-01)

### Bug Fixes

- **docz:** add playground wrapper just around children ([66abfe8](https://github.com/pedronauck/docz/commit/66abfe8))
- **docz-core:** remove babel plugin/presets when needed ([011baad](https://github.com/pedronauck/docz/commit/011baad))
- **docz-theme-default:** hot reload on fullscreen mode ([1c68e2d](https://github.com/pedronauck/docz/commit/1c68e2d))
- **docz-theme-default:** not found typo ([#173](https://github.com/pedronauck/docz/issues/173)) ([8c9f74e](https://github.com/pedronauck/docz/commit/8c9f74e))
- **docz-theme-default:** resolve emotion theming conflict ([659cd79](https://github.com/pedronauck/docz/commit/659cd79))

### Features

- **docz-core:** add webpack-serve-overlay as error overlay ([263badf](https://github.com/pedronauck/docz/commit/263badf))
- **docz-core:** support env files to set configuration ([#171](https://github.com/pedronauck/docz/issues/171)) ([259b72d](https://github.com/pedronauck/docz/commit/259b72d)), closes [#140](https://github.com/pedronauck/docz/issues/140)
- **docz-plugin-svgr:** add initial version of plugin ([1ac1ea8](https://github.com/pedronauck/docz/commit/1ac1ea8))
- **docz-theme-default:** add edit button for document ([#180](https://github.com/pedronauck/docz/issues/180)) ([e125a4f](https://github.com/pedronauck/docz/commit/e125a4f))

<a name="0.8.0"></a>

# [0.8.0](https://github.com/pedronauck/docz/compare/v0.7.1...v0.8.0) (2018-07-28)

### Bug Fixes

- change link on readme ([#168](https://github.com/pedronauck/docz/issues/168)) ([30a9390](https://github.com/pedronauck/docz/commit/30a9390))
- **docz:** humanize array type of flow (fix [#167](https://github.com/pedronauck/docz/issues/167)) ([18798bc](https://github.com/pedronauck/docz/commit/18798bc))
- **docz-theme-default:** get fullscreen from localstorage ([0f8aa56](https://github.com/pedronauck/docz/commit/0f8aa56))

### Features

- **docz-theme-default:** add html output on playground ([be7a749](https://github.com/pedronauck/docz/commit/be7a749))

<a name="0.7.1"></a>

## [0.7.1](https://github.com/pedronauck/docz/compare/v0.7.0...v0.7.1) (2018-07-24)

### Bug Fixes

- **docz:** add wrapper prop on Playground ([566aaf8](https://github.com/pedronauck/docz/commit/566aaf8))
- **docz:** sort algorithm off docs and menus ([dad83ce](https://github.com/pedronauck/docz/commit/dad83ce))
- **docz-plugin-css:** allow css from node_modules ([c21929a](https://github.com/pedronauck/docz/commit/c21929a))

<a name="0.7.0"></a>

# [0.7.0](https://github.com/pedronauck/docz/compare/v0.6.2...v0.7.0) (2018-07-23)

### Bug Fixes

- **docz:** humanize prop types on PropTable ([c1f4c6f](https://github.com/pedronauck/docz/commit/c1f4c6f))
- **docz-plugin-css:** css modules applied logic ([c5fa378](https://github.com/pedronauck/docz/commit/c5fa378))
- **docz-theme-default:** not found page ([fb1ac49](https://github.com/pedronauck/docz/commit/fb1ac49))
- **docz-theme-default:** resize bar style ([df0ae82](https://github.com/pedronauck/docz/commit/df0ae82))

### Features

- **docz:** add rawCode for Playground ([70d4735](https://github.com/pedronauck/docz/commit/70d4735))
- **docz-theme-default:** add close on esc on playground fullscreen ([4ebf202](https://github.com/pedronauck/docz/commit/4ebf202))
- **docz-theme-default:** add copy to clipboard on pre ([78149ad](https://github.com/pedronauck/docz/commit/78149ad))
- **docz-theme-default:** add fullpage support for docs ([af88d0e](https://github.com/pedronauck/docz/commit/af88d0e))
- **docz-theme-default:** add line numbers on Playground ([204f1bb](https://github.com/pedronauck/docz/commit/204f1bb))
- **docz-theme-default:** add resize bar for fullscreen playground ([392009f](https://github.com/pedronauck/docz/commit/392009f))
- **docz-theme-default:** add responsive mode for playground ([e04452e](https://github.com/pedronauck/docz/commit/e04452e))

<a name="0.6.2"></a>

## [0.6.2](https://github.com/pedronauck/docz/compare/v0.6.1...v0.6.2) (2018-07-20)

### Bug Fixes

- **docz-core:** set env vars for commands ([29f0098](https://github.com/pedronauck/docz/commit/29f0098))

<a name="0.6.1"></a>

## [0.6.1](https://github.com/pedronauck/docz/compare/v0.6.0...v0.6.1) (2018-07-19)

### Bug Fixes

- **docz:** default DocPreview components ([ff7cf32](https://github.com/pedronauck/docz/commit/ff7cf32))
- **docz-theme-default:** add background and color on NotFound ([f0bd532](https://github.com/pedronauck/docz/commit/f0bd532))

<a name="0.6.0"></a>

# [0.6.0](https://github.com/pedronauck/docz/compare/v0.5.9...v0.6.0) (2018-07-19)

### Bug Fixes

- **docz:** prevent default components object with no render ([4535aef](https://github.com/pedronauck/docz/commit/4535aef))
- **docz-core:** add error when dest is working directory ([b1c87b5](https://github.com/pedronauck/docz/commit/b1c87b5))
- **docz-core:** process.env vars for scripts ([f6b6260](https://github.com/pedronauck/docz/commit/f6b6260))
- **docz-core:** serve static files from public ([c866856](https://github.com/pedronauck/docz/commit/c866856))
- **docz-theme-default:** open menu if has some link active ([8399aad](https://github.com/pedronauck/docz/commit/8399aad))

### Features

- **docz-core:** add onCreateApp plugin method ([13c07e7](https://github.com/pedronauck/docz/commit/13c07e7))

<a name="0.5.9"></a>

## [0.5.9](https://github.com/pedronauck/docz/compare/v0.5.8...v0.5.9) (2018-07-16)

### Bug Fixes

- **docz-theme-default:** add overflow config on Pre component ([#146](https://github.com/pedronauck/docz/issues/146)) ([9d4ce59](https://github.com/pedronauck/docz/commit/9d4ce59))

<a name="0.5.8"></a>

## [0.5.8](https://github.com/pedronauck/docz/compare/v0.5.7...v0.5.8) (2018-07-11)

### Bug Fixes

- **docz-theme-default:** config transform function ([fdb3118](https://github.com/pedronauck/docz/commit/fdb3118))

<a name="0.5.7"></a>

## [0.5.7](https://github.com/pedronauck/docz/compare/v0.5.6...v0.5.7) (2018-07-11)

### Bug Fixes

- **docz-plugin-babel6:** props parsing when typescript is enable ([0564bdf](https://github.com/pedronauck/docz/commit/0564bdf))

<a name="0.5.6"></a>

## [0.5.6](https://github.com/pedronauck/docz/compare/v0.5.5...v0.5.6) (2018-07-11)

### Bug Fixes

- **docz:** add theme config transform before merge ([dc3448a](https://github.com/pedronauck/docz/commit/dc3448a))
- **docz-theme-default:** sidebar search ([8fd77ec](https://github.com/pedronauck/docz/commit/8fd77ec))

### Features

- **docz:** add classname and style props for Playground ([1b64ed3](https://github.com/pedronauck/docz/commit/1b64ed3))
- **docz-core:** add webpack-serve-waitpage ([83c493b](https://github.com/pedronauck/docz/commit/83c493b))

<a name="0.5.5"></a>

## [0.5.5](https://github.com/pedronauck/docz/compare/v0.5.4...v0.5.5) (2018-07-07)

### Bug Fixes

- **docz-core:** add ordering to initial config data object ([2926ade](https://github.com/pedronauck/docz/commit/2926ade))
- **docz-theme-default:** padding on sidebar footer ([df25fa1](https://github.com/pedronauck/docz/commit/df25fa1))

<a name="0.5.4"></a>

## [0.5.4](https://github.com/pedronauck/docz/compare/v0.5.3...v0.5.4) (2018-07-07)

**Note:** Version bump only for package undefined

<a name="0.5.3"></a>

## [0.5.3](https://github.com/pedronauck/docz/compare/v0.5.2...v0.5.3) (2018-07-05)

### Bug Fixes

- **docz-theme-default:** link isActive logic ([205ea8d](https://github.com/pedronauck/docz/commit/205ea8d))

<a name="0.5.2"></a>

## [0.5.2](https://github.com/pedronauck/docz/compare/v0.5.1...v0.5.2) (2018-07-05)

### Bug Fixes

- props table css class ([#116](https://github.com/pedronauck/docz/issues/116)) ([065473c](https://github.com/pedronauck/docz/commit/065473c))
- **docz-core:** remove unnescessary Entry.check ([1871db8](https://github.com/pedronauck/docz/commit/1871db8))

<a name="0.5.1"></a>

## [0.5.1](https://github.com/pedronauck/docz/compare/v0.3.4...v0.5.1) (2018-07-03)

### Bug Fixes

- broken links to examples ([#101](https://github.com/pedronauck/docz/issues/101)) ([26458f2](https://github.com/pedronauck/docz/commit/26458f2))
- **docz-core:** add a fallback name on Entry ([ec38139](https://github.com/pedronauck/docz/commit/ec38139))
- **docz-core:** app running port message ([4aec595](https://github.com/pedronauck/docz/commit/4aec595))
- CHANGELOG.md ([8be3724](https://github.com/pedronauck/docz/commit/8be3724))
- **docz-core:** check name on package json ([6cdbebc](https://github.com/pedronauck/docz/commit/6cdbebc))
- **docz-theme-default:** add overflow auto to nav ([4cdbcfd](https://github.com/pedronauck/docz/commit/4cdbcfd))

### Features

- **docz-core:** add ordering property for config ([efd215e](https://github.com/pedronauck/docz/commit/efd215e))
- **docz-core:** read name from package.json to populate initial title ([1eeb049](https://github.com/pedronauck/docz/commit/1eeb049))
- **docz-theme-default:** add automatic table of content ([#106](https://github.com/pedronauck/docz/issues/106)) ([6ce9e84](https://github.com/pedronauck/docz/commit/6ce9e84))
- **docz-theme-default:** add sidebar search ([7886e75](https://github.com/pedronauck/docz/commit/7886e75))

<a name="0.5.0"></a>

# [0.5.0](https://github.com/pedronauck/docz/compare/v0.3.4...v0.5.0) (2018-07-03)

### Bug Fixes

- **docz-core:** app running port message ([1b94114](https://github.com/pedronauck/docz/commit/1b94114))

### Features

- **docz-core:** add ordering property for config ([a6c307d](https://github.com/pedronauck/docz/commit/a6c307d))
- **docz-core:** read name from package.json to populate initial title ([4f10a6d](https://github.com/pedronauck/docz/commit/4f10a6d))
- **docz-theme-default:** add automatic table of content ([#106](https://github.com/pedronauck/docz/issues/106)) ([6ce9e84](https://github.com/pedronauck/docz/commit/6ce9e84))
- **docz-theme-default:** add sidebar search ([8218dc1](https://github.com/pedronauck/docz/commit/8218dc1))

<a name="0.4.0"></a>

# [0.4.0](https://github.com/pedronauck/docz/compare/v0.3.4...v0.4.0) (2018-06-30)

### Bug Fixes

- broken links to examples ([#101](https://github.com/pedronauck/docz/issues/101)) ([26458f2](https://github.com/pedronauck/docz/commit/26458f2))
- **docz-core:** add a fallback name on Entry ([ec38139](https://github.com/pedronauck/docz/commit/ec38139))
- **docz-theme-default:** add overflow auto to nav ([4cdbcfd](https://github.com/pedronauck/docz/commit/4cdbcfd))

### Features

- **docz-theme-default:** add automatic table of content ([#106](https://github.com/pedronauck/docz/issues/106)) ([6ce9e84](https://github.com/pedronauck/docz/commit/6ce9e84))

<a name="0.3.4"></a>

## [0.3.4](https://github.com/pedronauck/docz/compare/v0.3.3...v0.3.4) (2018-06-26)

### Bug Fixes

- remove color transparent on body ([#93](https://github.com/pedronauck/docz/issues/93)) ([a1942ef](https://github.com/pedronauck/docz/commit/a1942ef))
- unclosed tag in README.md ([#89](https://github.com/pedronauck/docz/issues/89)) ([0552351](https://github.com/pedronauck/docz/commit/0552351))

<a name="0.3.0"></a>

# [0.3.0](https://github.com/pedronauck/docz/compare/v0.3.0-beta.0...v0.3.0) (2018-06-25)

### Bug Fixes

- **docz-theme-default:** prettier format ([cb5643d](https://github.com/pedronauck/docz/commit/cb5643d))

<a name="0.3.0-beta.0"></a>

# [0.3.0-beta.0](https://github.com/pedronauck/docz/compare/v0.2.11...v0.3.0-beta.0) (2018-06-25)

### Bug Fixes

- **docz-theme-default:** change background based on toggle ([2241f8b](https://github.com/pedronauck/docz/commit/2241f8b))
- **docz-theme-default:** change chevronDown to burguer icon with animation ([8649938](https://github.com/pedronauck/docz/commit/8649938))
- **docz-theme-default:** include breakpoints as const ([43490bb](https://github.com/pedronauck/docz/commit/43490bb))
- **docz-theme-default:** lint code ([7c97a41](https://github.com/pedronauck/docz/commit/7c97a41))
- **docz-theme-default:** made container responsive ([ddf078d](https://github.com/pedronauck/docz/commit/ddf078d))
- **docz-theme-default:** responsive position for wrapper ([bb56449](https://github.com/pedronauck/docz/commit/bb56449))
- **docz-theme-default:** sidebar toggle for links and sub-links ([9cd6321](https://github.com/pedronauck/docz/commit/9cd6321))

### Features

- **docz-theme-default:** add dark mode 🌚 ([#81](https://github.com/pedronauck/docz/issues/81)) ([964cf4d](https://github.com/pedronauck/docz/commit/964cf4d))
- **docz-theme-default:** include breakpoints reactive on sidebar ([d3911b4](https://github.com/pedronauck/docz/commit/d3911b4))
- **docz-theme-default:** include media queries facepaint ([5f78734](https://github.com/pedronauck/docz/commit/5f78734))
- **docz-theme-default:** include toggle to sidebar ([a94e517](https://github.com/pedronauck/docz/commit/a94e517))
- **docz-theme-default:** include ToggleBackground ([cac7ecd](https://github.com/pedronauck/docz/commit/cac7ecd))
- **docz-theme-default:** table responsive ([0580a77](https://github.com/pedronauck/docz/commit/0580a77))

<a name="0.3.3"></a>

## [0.3.3](https://github.com/pedronauck/docz/compare/v0.3.2...v0.3.3) (2018-06-26)

### Bug Fixes

- **docz-core:** copy templates files for dist ([#88](https://github.com/pedronauck/docz/issues/88)) ([5e4b98d](https://github.com/pedronauck/docz/commit/5e4b98d))

<a name="0.3.2"></a>

## [0.3.2](https://github.com/pedronauck/docz/compare/v0.3.1...v0.3.2) (2018-06-25)

### Bug Fixes

- **docz:** mdxtag import ([4ed20bf](https://github.com/pedronauck/docz/commit/4ed20bf))

<a name="0.3.1"></a>

## [0.3.1](https://github.com/pedronauck/docz/compare/v0.2.11...v0.3.1) (2018-06-25)

### Bug Fixes

- **docz:** mdx provider import ([ded8cbb](https://github.com/pedronauck/docz/commit/ded8cbb))
- use docz-theme-default as docz-core dependency ([1a2fb67](https://github.com/pedronauck/docz/commit/1a2fb67))

### Features

- **docz-default-theme:** dark mode and responsiveness ([#87](https://github.com/pedronauck/docz/issues/87)) ([a4db115](https://github.com/pedronauck/docz/commit/a4db115)), closes [#81](https://github.com/pedronauck/docz/issues/81)

<a name="0.3.0"></a>

# [0.3.0](https://github.com/pedronauck/docz/compare/v0.3.0-beta.0...v0.3.0) (2018-06-25)

### Bug Fixes

- **docz-theme-default:** prettier format ([cb5643d](https://github.com/pedronauck/docz/commit/cb5643d))

<a name="0.3.0-beta.0"></a>

# [0.3.0-beta.0](https://github.com/pedronauck/docz/compare/v0.2.11...v0.3.0-beta.0) (2018-06-25)

### Bug Fixes

- **docz-theme-default:** change background based on toggle ([2241f8b](https://github.com/pedronauck/docz/commit/2241f8b))
- **docz-theme-default:** change chevronDown to burguer icon with animation ([8649938](https://github.com/pedronauck/docz/commit/8649938))
- **docz-theme-default:** include breakpoints as const ([43490bb](https://github.com/pedronauck/docz/commit/43490bb))
- **docz-theme-default:** lint code ([7c97a41](https://github.com/pedronauck/docz/commit/7c97a41))
- **docz-theme-default:** made container responsive ([ddf078d](https://github.com/pedronauck/docz/commit/ddf078d))
- **docz-theme-default:** responsive position for wrapper ([bb56449](https://github.com/pedronauck/docz/commit/bb56449))
- **docz-theme-default:** sidebar toggle for links and sub-links ([9cd6321](https://github.com/pedronauck/docz/commit/9cd6321))

### Features

- **docz-theme-default:** add dark mode 🌚 ([#81](https://github.com/pedronauck/docz/issues/81)) ([964cf4d](https://github.com/pedronauck/docz/commit/964cf4d))
- **docz-theme-default:** include breakpoints reactive on sidebar ([d3911b4](https://github.com/pedronauck/docz/commit/d3911b4))
- **docz-theme-default:** include media queries facepaint ([5f78734](https://github.com/pedronauck/docz/commit/5f78734))
- **docz-theme-default:** include toggle to sidebar ([a94e517](https://github.com/pedronauck/docz/commit/a94e517))
- **docz-theme-default:** include ToggleBackground ([cac7ecd](https://github.com/pedronauck/docz/commit/cac7ecd))
- **docz-theme-default:** table responsive ([0580a77](https://github.com/pedronauck/docz/commit/0580a77))

<a name="0.2.11"></a>

## [0.2.11](https://github.com/pedronauck/docz/compare/v0.2.10...v0.2.11) (2018-06-22)

### Bug Fixes

- **docz-core:** node env for production ([615aa1f](https://github.com/pedronauck/docz/commit/615aa1f))
- **docz-plugin-css:** production build ([1a66d8a](https://github.com/pedronauck/docz/commit/1a66d8a))
- **docz-theme-default:** use webfontloader instead of css import ([5973969](https://github.com/pedronauck/docz/commit/5973969))
- some changes on css examples ([058660f](https://github.com/pedronauck/docz/commit/058660f))

<a name="0.2.10"></a>

## [0.2.10](https://github.com/pedronauck/docz/compare/v0.2.9...v0.2.10) (2018-06-21)

### Features

- **docz-plugin-css:** add initial version ([#78](https://github.com/pedronauck/docz/issues/78)) ([299372e](https://github.com/pedronauck/docz/commit/299372e))

<a name="0.2.9"></a>

## [0.2.9](https://github.com/pedronauck/docz/compare/v0.2.8...v0.2.9) (2018-06-21)

**Note:** Version bump only for package undefined

<a name="0.2.8"></a>

## [0.2.8](https://github.com/pedronauck/docz/compare/v0.2.7...v0.2.8) (2018-06-21)

### Bug Fixes

- **docz-core:** typescript resolve extensions ([689b057](https://github.com/pedronauck/docz/commit/689b057))

<a name="0.2.7"></a>

## [0.2.7](https://github.com/pedronauck/docz/compare/v0.2.6...v0.2.7) (2018-06-20)

### Bug Fixes

- **docz:** typo ([#63](https://github.com/pedronauck/docz/issues/63)) ([6af5db2](https://github.com/pedronauck/docz/commit/6af5db2))
- **docz-plugin-babel6:** documentation for babel plugin ([#60](https://github.com/pedronauck/docz/issues/60)) ([8a14e2a](https://github.com/pedronauck/docz/commit/8a14e2a))
- **docz-plugin-babel6:** readme typo ([b77e986](https://github.com/pedronauck/docz/commit/b77e986))
- **docz-plugin-babel6:** typo ([d2f92b7](https://github.com/pedronauck/docz/commit/d2f92b7))
- **docz-theme-default:** improve spacing on jsx attributes ([#54](https://github.com/pedronauck/docz/issues/54)) ([49fe0b8](https://github.com/pedronauck/docz/commit/49fe0b8))

<a name="0.2.6"></a>

## [0.2.6](https://github.com/pedronauck/docz/compare/v0.2.5...v0.2.6) (2018-06-17)

### Bug Fixes

- **docz-core:** change filepath entry for windows ([#31](https://github.com/pedronauck/docz/issues/31)) ([14bf0e2](https://github.com/pedronauck/docz/commit/14bf0e2))

### Features

- **docz-example-babel6:** add package ([92ead5a](https://github.com/pedronauck/docz/commit/92ead5a))
- **docz-plugin-babel6:** add package ([68e364a](https://github.com/pedronauck/docz/commit/68e364a))

<a name="0.2.5"></a>

## [0.2.5](https://github.com/pedronauck/docz/compare/v0.2.4...v0.2.5) (2018-06-15)

### Bug Fixes

- **docz:** add extractTypeDescribedValue to PropsTable ([#38](https://github.com/pedronauck/docz/issues/38)) ([cca862c](https://github.com/pedronauck/docz/commit/cca862c))
- **docz:** PropsTable component ([48638cc](https://github.com/pedronauck/docz/commit/48638cc))

<a name="0.2.4"></a>

## [0.2.4](https://github.com/pedronauck/docz/compare/v0.2.3...v0.2.4) (2018-06-13)

**Note:** Version bump only for package undefined

<a name="0.2.3"></a>

## [0.2.3](https://github.com/pedronauck/docz/compare/v0.2.2...v0.2.3) (2018-06-13)

### Bug Fixes

- **docz-core:** change config hosts to support windows os ([9e3c4f6](https://github.com/pedronauck/docz/commit/9e3c4f6))
- readme typo ([a13dc3c](https://github.com/pedronauck/docz/commit/a13dc3c))

<a name="0.2.2"></a>

## [0.2.2](https://github.com/pedronauck/docz/compare/v0.2.1...v0.2.2) (2018-06-12)

**Note:** Version bump only for package undefined

<a name="0.2.1"></a>

## [0.2.1](https://github.com/pedronauck/docz/compare/v0.2.0...v0.2.1) (2018-06-12)

### Bug Fixes

- corrections on readme [#2](https://github.com/pedronauck/docz/issues/2) ([bd1b7a6](https://github.com/pedronauck/docz/commit/bd1b7a6))
- playground component destructuring bug ([#4](https://github.com/pedronauck/docz/issues/4)) ([f9026cf](https://github.com/pedronauck/docz/commit/f9026cf))
- readme typos ([16662eb](https://github.com/pedronauck/docz/commit/16662eb))

<a name="0.2.0"></a>

# [0.2.0](https://github.com/pedronauck/docz/compare/v0.2.0-beta.2...v0.2.0) (2018-06-11)

### Bug Fixes

- readme image ([470b235](https://github.com/pedronauck/docz/commit/470b235))
- readme links ([61de7cd](https://github.com/pedronauck/docz/commit/61de7cd))
- readme links ([f7b1120](https://github.com/pedronauck/docz/commit/f7b1120))

<a name="0.2.0-beta.2"></a>

# [0.2.0-beta.2](https://github.com/doczjs/docz/compare/v0.2.0-beta.1...v0.2.0-beta.2) (2018-06-10)

### Bug Fixes

- **docz-core:** autolink headings ([0b8369d](https://github.com/doczjs/docz/commit/0b8369d))

<a name="0.2.0-beta.1"></a>

# [0.2.0-beta.1](https://github.com/doczjs/docz/compare/v0.2.0-beta.0...v0.2.0-beta.1) (2018-06-10)

### Features

- **docz-core:** add headings property for entries and autolink on headings ([7711c3c](https://github.com/doczjs/docz/commit/7711c3c))

<a name="0.2.0-beta.0"></a>

# [0.2.0-beta.0](https://github.com/doczjs/docz/compare/v0.1.2-beta.6...v0.2.0-beta.0) (2018-06-10)

### Features

- **docz-core:** add indexHtml property on project configuration ([6bb5167](https://github.com/doczjs/docz/commit/6bb5167))

<a name="0.1.2-beta.6"></a>

## [0.1.2-beta.6](https://github.com/doczjs/docz/compare/v0.1.2-beta.5...v0.1.2-beta.6) (2018-06-09)

### Bug Fixes

- **docz:** typing definition ([1a3648e](https://github.com/doczjs/docz/commit/1a3648e))

<a name="0.1.2-beta.5"></a>

## [0.1.2-beta.5](https://github.com/doczjs/docz/compare/v0.1.2-beta.4...v0.1.2-beta.5) (2018-06-09)

### Bug Fixes

- **docz-core:** build when base prop ([6001171](https://github.com/doczjs/docz/commit/6001171))
- **docz-theme-default:** loading component height ([b198075](https://github.com/doczjs/docz/commit/b198075))

<a name="0.1.2-beta.4"></a>

## [0.1.2-beta.4](https://github.com/doczjs/docz/compare/v0.1.2-beta.3...v0.1.2-beta.4) (2018-06-09)

**Note:** Version bump only for package undefined

<a name="0.1.2-beta.3"></a>

## [0.1.2-beta.3](https://github.com/doczjs/docz/compare/v0.1.2-beta.2...v0.1.2-beta.3) (2018-06-09)

**Note:** Version bump only for package undefined

<a name="0.1.2-beta.2"></a>

## [0.1.2-beta.2](https://github.com/doczjs/docz/compare/v0.1.2-beta.1...v0.1.2-beta.2) (2018-06-09)

### Features

- **docz:** add support for custom not found route ([455dcca](https://github.com/doczjs/docz/commit/455dcca))
- **docz-theme-default:** add custom not found component ([1773fe1](https://github.com/doczjs/docz/commit/1773fe1))

<a name="0.1.2-beta.1"></a>

## [0.1.2-beta.1](https://github.com/doczjs/docz/compare/v0.1.2-beta.0...v0.1.2-beta.1) (2018-06-09)

### Bug Fixes

- **docz-theme-default:** emotion typings ([270e38c](https://github.com/doczjs/docz/commit/270e38c))

### Features

- **docz:** add loading component setting for loadable ([4352ce3](https://github.com/doczjs/docz/commit/4352ce3))
- **docz-core:** add base config argument ([20f29c2](https://github.com/doczjs/docz/commit/20f29c2))
- **docz-core:** add dest config property ([d6c5506](https://github.com/doczjs/docz/commit/d6c5506))
- **docz-core:** add modifyBundlerConfig configuration property ([ec04bee](https://github.com/doczjs/docz/commit/ec04bee))
- **docz-core:** use html template as component ([b7a2dc0](https://github.com/doczjs/docz/commit/b7a2dc0))
- **docz-theme-default:** add Loading component for DocPreview ([97859e2](https://github.com/doczjs/docz/commit/97859e2))

<a name="0.1.2-beta.0"></a>

## [0.1.2-beta.0](https://github.com/doczjs/docz/compare/v0.1.1...v0.1.2-beta.0) (2018-06-02)

**Note:** Version bump only for package undefined

<a name="0.1.1-beta.6"></a>

## [0.1.1-beta.6](https://github.com/doczjs/docz/compare/v0.1.1-beta.5...v0.1.1-beta.6) (2018-06-01)

### Bug Fixes

- **docz:** add docz-theme-default as dependecy ([0dff6c0](https://github.com/doczjs/docz/commit/0dff6c0))

<a name="0.1.1-beta.5"></a>

## [0.1.1-beta.5](https://github.com/doczjs/docz/compare/v0.1.1-beta.4...v0.1.1-beta.5) (2018-06-01)

### Bug Fixes

- **docz:** link component ([7626982](https://github.com/doczjs/docz/commit/7626982))
- **load-cfg:** add namedExports options ([d36194d](https://github.com/doczjs/docz/commit/d36194d))

### Features

- **load-cfg:** add esm module loader ([12a7610](https://github.com/doczjs/docz/commit/12a7610))

<a name="0.1.1-beta.4"></a>

## [0.1.1-beta.4](https://github.com/doczjs/docz/compare/v0.1.1-beta.3...v0.1.1-beta.4) (2018-05-29)

### Bug Fixes

- **docz:** add isActive to Link components ([9cecc08](https://github.com/doczjs/docz/commit/9cecc08))
- **docz-core:** module rule test for typescript ([bdeffc1](https://github.com/doczjs/docz/commit/bdeffc1))

<a name="0.1.1-beta.3"></a>

## [0.1.1-beta.3](https://github.com/doczjs/docz/compare/v0.1.1-beta.2...v0.1.1-beta.3) (2018-05-29)

**Note:** Version bump only for package undefined

<a name="0.1.1-beta.2"></a>

## [0.1.1-beta.2](https://github.com/doczjs/docz/compare/v0.1.1-beta.0...v0.1.1-beta.2) (2018-05-29)

### Bug Fixes

- **docz:** set docz-core as dependency ([6c257e8](https://github.com/doczjs/docz/commit/6c257e8))

<a name="0.1.1-beta.1"></a>

## [0.1.1-beta.1](https://github.com/doczjs/docz/compare/v0.1.1-beta.0...v0.1.1-beta.1) (2018-05-29)

**Note:** Version bump only for package undefined

<a name="0.1.1-beta.0"></a>

## [0.1.1-beta.0](https://github.com/doczjs/docz/compare/v0.1.0...v0.1.1-beta.0) (2018-05-29)

### Bug Fixes

- **docz:** add bin folder for npm publish ([f463a98](https://github.com/doczjs/docz/commit/f463a98))

<a name="0.1.0"></a>

# 0.1.0 (2018-05-29)

### Bug Fixes

- **docz:** Docs render props orders and types ([d7e9ee2](https://github.com/doczjs/docz/commit/d7e9ee2))
- **docz:** docs categories for themes ([687720c](https://github.com/doczjs/docz/commit/687720c))
- **docz:** flow props parser integration ([5a83610](https://github.com/doczjs/docz/commit/5a83610))
- **docz:** validate route passed for docs.route() ([48a0484](https://github.com/doczjs/docz/commit/48a0484))
- **docz-core:** async plugin ([ddfbcf1](https://github.com/doczjs/docz/commit/ddfbcf1))
- **docz-core:** check if found name exist when parse entry ([f75881e](https://github.com/doczjs/docz/commit/f75881e))
- **docz-core:** config watch for directory operations ([43fa7ab](https://github.com/doczjs/docz/commit/43fa7ab))
- **docz-core:** create plugin to fix paragraph parse on mdx ([42b4f05](https://github.com/doczjs/docz/commit/42b4f05))
- **docz-core:** data server class ([12c0558](https://github.com/doczjs/docz/commit/12c0558))
- **docz-core:** don't exit when catch prettier ([5423d96](https://github.com/doczjs/docz/commit/5423d96))
- **docz-core:** entries filepath ([e45fea0](https://github.com/doczjs/docz/commit/e45fea0))
- webpack errors message ([90f6064](https://github.com/doczjs/docz/commit/90f6064))
- **docz-core:** entries rewrite ([986ba65](https://github.com/doczjs/docz/commit/986ba65))
- **docz-core:** entries updates ([7147ac1](https://github.com/doczjs/docz/commit/7147ac1))
- **docz-core:** packages splitting ([d2e74ee](https://github.com/doczjs/docz/commit/d2e74ee))
- **docz-core:** templates files ([a5cda97](https://github.com/doczjs/docz/commit/a5cda97))
- **docz-core:** throw error when parse ast ([05138bf](https://github.com/doczjs/docz/commit/05138bf))
- **docz-example-basic:** package name ([dec5713](https://github.com/doczjs/docz/commit/dec5713))

### Features

- **docz-core:** add title and description on settings ([ad9ee58](https://github.com/doczjs/docz/commit/ad9ee58))
- add basic monorepo structure ([5a977ed](https://github.com/doczjs/docz/commit/5a977ed))
- **docz:** add a mvp version of project ([05ac064](https://github.com/doczjs/docz/commit/05ac064))
- **docz:** add components parser ([a4127d9](https://github.com/doczjs/docz/commit/a4127d9))
- **docz:** add custom routes for docs ([8458d91](https://github.com/doczjs/docz/commit/8458d91))
- **docz:** add doc page wrapper as component ([1150373](https://github.com/doczjs/docz/commit/1150373))
- **docz:** add groups feature ([9652b30](https://github.com/doczjs/docz/commit/9652b30))
- **docz:** add module declarations for typescript ([ae597af](https://github.com/doczjs/docz/commit/ae597af))
- **docz:** add routes from parsed entries ([fc37f73](https://github.com/doczjs/docz/commit/fc37f73))
- **docz:** add some improvements for default package ([51188d4](https://github.com/doczjs/docz/commit/51188d4))
- **docz:** make server bundler api concise ([ae5f0c0](https://github.com/doczjs/docz/commit/ae5f0c0))
- **docz:** some refactors ([7f6660c](https://github.com/doczjs/docz/commit/7f6660c))
- **docz:** use webpack 4 instead of parcel ([1e5742c](https://github.com/doczjs/docz/commit/1e5742c))
- **docz-bundler-webpack:** add bundler as package ([d7be8a9](https://github.com/doczjs/docz/commit/d7be8a9))
- **docz-bundler-webpack:** improve webpack config ([964832a](https://github.com/doczjs/docz/commit/964832a))
- **docz-core:** add basic plugin logic ([add17ad](https://github.com/doczjs/docz/commit/add17ad))
- **docz-core:** add build command ([ef7abd2](https://github.com/doczjs/docz/commit/ef7abd2))
- **docz-core:** add chokidar to watch new entries ([2f073d5](https://github.com/doczjs/docz/commit/2f073d5))
- **docz-core:** add entry settings field ([2ec5d66](https://github.com/doczjs/docz/commit/2ec5d66))
- **docz-core:** add hot reload ([9ebe65d](https://github.com/doczjs/docz/commit/9ebe65d))
- **docz-core:** add playground code parse section ([6bbf158](https://github.com/doczjs/docz/commit/6bbf158))
- **docz-core:** add setConfig method for Plugin ([9ba6507](https://github.com/doczjs/docz/commit/9ba6507))
- **docz-core:** add some improvements to work with server config ([8bf33bc](https://github.com/doczjs/docz/commit/8bf33bc))
- **docz-core:** add support for custom head or scripts ([69f4d56](https://github.com/doczjs/docz/commit/69f4d56))
- **docz-core:** add support for load custom themes ([ade98ce](https://github.com/doczjs/docz/commit/ade98ce))
- **docz-core:** add support for parse sections via ast ([6db0cd8](https://github.com/doczjs/docz/commit/6db0cd8))
- **docz-core:** add template using art-template ([7484267](https://github.com/doczjs/docz/commit/7484267))
- **docz-core:** add typescript support ([17dae8b](https://github.com/doczjs/docz/commit/17dae8b))
- **docz-core:** improve plugin and add support to modify babel ([cf3ec4e](https://github.com/doczjs/docz/commit/cf3ec4e))
- **docz-core:** pass theme config via websockets for dev ([5222de7](https://github.com/doczjs/docz/commit/5222de7))
- **docz-core:** set babel on the fly ([672be49](https://github.com/doczjs/docz/commit/672be49))
- **docz-core:** split bundler logic ([a7db904](https://github.com/doczjs/docz/commit/a7db904))
- **docz-core:** use websockets instead of generate json to process entries ([e0773a0](https://github.com/doczjs/docz/commit/e0773a0))
- **docz-core:** webpack middlewares ([68cbcba](https://github.com/doczjs/docz/commit/68cbcba))
- **docz-example-flow:** add example folder ([27002d8](https://github.com/doczjs/docz/commit/27002d8))
- refac to use mdx ([04b59e5](https://github.com/doczjs/docz/commit/04b59e5))
- **docz-example-typescript:** add new example ([9052d0f](https://github.com/doczjs/docz/commit/9052d0f))
- **docz-theme-default:** add default theme as a package ([108dc4c](https://github.com/doczjs/docz/commit/108dc4c))
- **docz-theme-default:** add highlight code on theme ([1126e67](https://github.com/doczjs/docz/commit/1126e67))
- **docz-theme-default:** add logo option ([435da9b](https://github.com/doczjs/docz/commit/435da9b))
- **docz-theme-default:** add sidebar footer ([ffc4b18](https://github.com/doczjs/docz/commit/ffc4b18))
- **docz-theme-default:** add tooltip on props ([dc3c4cd](https://github.com/doczjs/docz/commit/dc3c4cd))
- **docz-theme-default:** improve theme styles ([2ca5e21](https://github.com/doczjs/docz/commit/2ca5e21))
- **docz-theme-default:** start logic to create theme feature ([900cf2b](https://github.com/doczjs/docz/commit/900cf2b))
- **docz-theme-default:** use typescript instead of javascript ([4de326a](https://github.com/doczjs/docz/commit/4de326a))
- use custom render method on section ([8ccf99c](https://github.com/doczjs/docz/commit/8ccf99c))
- **load-cfg:** add script as package ([11e409c](https://github.com/doczjs/docz/commit/11e409c))
- **load-cfg:** set cache to require file ([c49fc64](https://github.com/doczjs/docz/commit/c49fc64))
- add component props parse feature ([987627d](https://github.com/doczjs/docz/commit/987627d))
- add support for highlight code sections ([19bf7ea](https://github.com/doczjs/docz/commit/19bf7ea))
- improve docz theme to use theme config ([9207ed2](https://github.com/doczjs/docz/commit/9207ed2))
- parse doc class to object ([e7f9cf0](https://github.com/doczjs/docz/commit/e7f9cf0))
