<?php

use Utopia\App;
use Utopia\Config\Config;
use Appwrite\Database\Database;

$providers = Config::getParam('providers', []);
$auth = Config::getParam('auth', []);

$collections = [
    'console' => [
        '$id' => 'console',
        '$collection' => 'projects',
        '$permissions' => ['read' => ['*']],
        'name' => 'Appwrite',
        'description' => 'Appwrite core engine',
        'logo' => '',
        'teamId' => -1,
        'webhooks' => [],
        'keys' => [],
        'platforms' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_PLATFORMS,
                'name' => 'Production',
                'type' => 'web',
                'hostname' => 'appwrite.io',
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_PLATFORMS,
                'name' => 'Development',
                'type' => 'web',
                'hostname' => 'appwrite.test',
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_PLATFORMS,
                'name' => 'Localhost',
                'type' => 'web',
                'hostname' => 'localhost',
            ], // Current host is added on app init
        ],
        'legalName' => '',
        'legalCountry' => '',
        'legalState' => '',
        'legalCity' => '',
        'legalAddress' => '',
        'legalTaxId' => '',
        'authWhitelistEmails' => (!empty(App::getEnv('_APP_CONSOLE_WHITELIST_EMAILS', null))) ? \explode(',', App::getEnv('_APP_CONSOLE_WHITELIST_EMAILS', null)) : [],
        'authWhitelistIPs' => (!empty(App::getEnv('_APP_CONSOLE_WHITELIST_IPS', null))) ? \explode(',', App::getEnv('_APP_CONSOLE_WHITELIST_IPS', null)) : [],
        'usersAuthLimit' => (App::getEnv('_APP_CONSOLE_WHITELIST_ROOT', 'enabled') === 'enabled') ? 1 : 0, // limit signup to 1 user
    ],
    Database::SYSTEM_COLLECTION_COLLECTIONS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Collections',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Date Created',
                'key' => 'dateCreated',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Date Updated',
                'key' => 'dateUpdated',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Structure',
                'key' => 'structure',
                'type' => Database::SYSTEM_VAR_TYPE_BOOLEAN,
                'default' => false,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Rules',
                'key' => 'rules',
                'type' => Database::SYSTEM_VAR_TYPE_DOCUMENT,
                'default' => [],
                'required' => true,
                'array' => true,
                'list' => [Database::SYSTEM_COLLECTION_RULES],
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_RULES => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_RULES,
        '$permissions' => ['read' => ['*']],
        'name' => 'Collections Rule',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Label',
                'key' => 'label',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Key',
                'key' => 'key',
                'type' => Database::SYSTEM_VAR_TYPE_KEY,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Type',
                'key' => 'type',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Default',
                'key' => 'default',
                'type' => Database::SYSTEM_VAR_TYPE_WILDCARD,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Required',
                'key' => 'required',
                'type' => Database::SYSTEM_VAR_TYPE_BOOLEAN,
                'default' => true,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Array',
                'key' => 'array',
                'type' => Database::SYSTEM_VAR_TYPE_BOOLEAN,
                'default' => true,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'list',
                'key' => 'list',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                //'default' => '',
                'required' => false,
                'array' => true,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Filter',
                'key' => 'filter',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'required' => false,
                'array' => true,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_USERS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_USERS,
        '$permissions' => ['read' => ['*']],
        'name' => 'User',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Email',
                'key' => 'email',
                'type' => Database::SYSTEM_VAR_TYPE_EMAIL,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Status',
                'key' => 'status',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Password',
                'key' => 'password',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Password Update Date',
                'key' => 'passwordUpdate',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Prefs',
                'key' => 'prefs',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
                'filter' => ['json']
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Registration Date',
                'key' => 'registration',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Email Verification Status',
                'key' => 'emailVerification',
                'type' => Database::SYSTEM_VAR_TYPE_BOOLEAN,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Reset',
                'key' => 'reset',
                'type' => Database::SYSTEM_VAR_TYPE_BOOLEAN,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Sessions',
                'key' => 'sessions',
                'type' => Database::SYSTEM_VAR_TYPE_DOCUMENT,
                'default' => [],
                'required' => false,
                'array' => true,
                'list' => [Database::SYSTEM_COLLECTION_SESSIONS],
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Tokens',
                'key' => 'tokens',
                'type' => Database::SYSTEM_VAR_TYPE_DOCUMENT,
                'default' => [],
                'required' => false,
                'array' => true,
                'list' => [Database::SYSTEM_COLLECTION_TOKENS],
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Memberships',
                'key' => 'memberships',
                'type' => Database::SYSTEM_VAR_TYPE_DOCUMENT,
                'default' => [],
                'required' => false,
                'array' => true,
                'list' => [Database::SYSTEM_COLLECTION_MEMBERSHIPS],
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_SESSIONS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_SESSIONS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Session',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'User ID',
                'key' => 'userId',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Provider',
                'key' => 'provider',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Provider User Identifier',
                'key' => 'providerUid',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Provider Token',
                'key' => 'providerToken',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Secret',
                'key' => 'secret',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Expire',
                'key' => 'expire',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'User Agent',
                'key' => 'userAgent',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'IP',
                'key' => 'ip',
                'type' => Database::SYSTEM_VAR_TYPE_IP,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'OS Code',
                'key' => 'osCode',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'OS Name',
                'key' => 'osName',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'OS Version',
                'key' => 'osVersion',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Client Type',
                'key' => 'clientType',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Client Code',
                'key' => 'clientCode',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Client Name',
                'key' => 'clientName',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Client Version',
                'key' => 'clientVersion',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Client Engine',
                'key' => 'clientEngine',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Client Engine Version',
                'key' => 'clientEngineVersion',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Device Name',
                'key' => 'deviceName',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Device Brand',
                'key' => 'deviceBrand',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Device Model',
                'key' => 'deviceModel',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Country Code',
                'key' => 'countryCode',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_TOKENS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_TOKENS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Token',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'User ID',
                'key' => 'userId',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => null,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Type',
                'key' => 'type',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Secret',
                'key' => 'secret',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Expire',
                'key' => 'expire',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'User Agent',
                'key' => 'userAgent',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'IP',
                'key' => 'ip',
                'type' => Database::SYSTEM_VAR_TYPE_IP,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_MEMBERSHIPS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_MEMBERSHIPS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Membership',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Team ID',
                'key' => 'teamId',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'User ID',
                'key' => 'userId',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Roles',
                'key' => 'roles',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => true,
                'array' => true,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Invited',
                'key' => 'invited',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => false, //FIXME SHOULD BE REQUIRED
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Joined',
                'key' => 'joined',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Confirm',
                'key' => 'confirm',
                'type' => Database::SYSTEM_VAR_TYPE_BOOLEAN,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Secret',
                'key' => 'secret',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_TEAMS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_TEAMS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Team',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Date Created',
                'key' => 'dateCreated',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Sum',
                'key' => 'sum',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_PROJECTS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_PROJECTS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Project',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Description',
                'key' => 'description',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => null,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Logo',
                'key' => 'logo',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'URL',
                'key' => 'url',
                'type' => Database::SYSTEM_VAR_TYPE_URL,
                'default' => '',
                'required' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Team ID',
                'key' => 'teamId',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => 0,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Legal Name',
                'key' => 'legalName',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Legal Country',
                'key' => 'legalCountry',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Legal State',
                'key' => 'legalState',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Legal City',
                'key' => 'legalCity',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Legal Address',
                'key' => 'legalAddress',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Legal Tax ID',
                'key' => 'legalTaxId',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Max users allowed',
                'key' => 'usersAuthLimit',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Version',
                'key' => 'version',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => true,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Webhooks',
                'key' => 'webhooks',
                'type' => Database::SYSTEM_VAR_TYPE_DOCUMENT,
                'default' => [],
                'required' => false,
                'array' => true,
                'list' => [Database::SYSTEM_COLLECTION_WEBHOOKS],
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'API Keys',
                'key' => 'keys',
                'type' => Database::SYSTEM_VAR_TYPE_DOCUMENT,
                'default' => [],
                'required' => false,
                'array' => true,
                'list' => [Database::SYSTEM_COLLECTION_KEYS],
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Tasks',
                'key' => 'tasks',
                'type' => Database::SYSTEM_VAR_TYPE_DOCUMENT,
                'default' => [],
                'required' => false,
                'array' => true,
                'list' => [Database::SYSTEM_COLLECTION_TASKS],
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Platforms',
                'key' => 'platforms',
                'type' => Database::SYSTEM_VAR_TYPE_DOCUMENT,
                'default' => [],
                'required' => false,
                'array' => true,
                'list' => [Database::SYSTEM_COLLECTION_PLATFORMS],
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Domains',
                'key' => 'domains',
                'type' => Database::SYSTEM_VAR_TYPE_DOCUMENT,
                'default' => [],
                'required' => false,
                'array' => true,
                'list' => [Database::SYSTEM_COLLECTION_DOMAINS],
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_WEBHOOKS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_WEBHOOKS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Webhook',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Events',
                'key' => 'events',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => null,
                'required' => false,
                'array' => true,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'URL',
                'key' => 'url',
                'type' => Database::SYSTEM_VAR_TYPE_URL,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Security',
                'key' => 'security',
                'type' => Database::SYSTEM_VAR_TYPE_BOOLEAN,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'HTTP User',
                'key' => 'httpUser',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'HTTP Password',
                'key' => 'httpPass',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
                'filter' => ['encrypt'],
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_KEYS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_KEYS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Key',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Scopes',
                'key' => 'scopes',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => null,
                'required' => false,
                'array' => true,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Secret',
                'key' => 'secret',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'filter' => ['encrypt'],
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_TASKS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_TASKS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Task',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Status',
                'key' => 'status',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Updated',
                'key' => 'updated',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Schedule',
                'key' => 'schedule',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Previous',
                'key' => 'previous',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Next',
                'key' => 'next',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Duration',
                'key' => 'duration',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Delay',
                'key' => 'delay',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Security',
                'key' => 'security',
                'type' => Database::SYSTEM_VAR_TYPE_BOOLEAN,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'HTTP Method',
                'key' => 'httpMethod',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'HTTP URL',
                'key' => 'httpUrl',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'HTTP Headers',
                'key' => 'httpHeaders',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => null,
                'required' => false,
                'array' => true,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'HTTP User',
                'key' => 'httpUser',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'HTTP Password',
                'key' => 'httpPass',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
                'filter' => ['encrypt'],
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Log',
                'key' => 'log',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Failures',
                'key' => 'failures',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_PLATFORMS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_PLATFORMS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Platform',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Type',
                'key' => 'type',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Date Created',
                'key' => 'dateCreated',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Date Updated',
                'key' => 'dateUpdated',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Key',
                'key' => 'key',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Store',
                'key' => 'store',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Hostname',
                'key' => 'hostname',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_DOMAINS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_DOMAINS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Domains',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Domain',
                'key' => 'domain',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Updated',
                'key' => 'updated',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Top Level Domain',
                'key' => 'tld',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Registerable Domain',
                'key' => 'registerable',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Verification',
                'key' => 'verification',
                'type' => Database::SYSTEM_VAR_TYPE_BOOLEAN,
                'default' => false,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Certificate ID',
                'key' => 'certificateId',
                'type' => Database::SYSTEM_VAR_TYPE_KEY,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_CERTIFICATES => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_CERTIFICATES,
        '$permissions' => ['read' => ['*']],
        'name' => 'Certificates',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Domain',
                'key' => 'domain',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Issue Date',
                'key' => 'issueDate',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Renew Date',
                'key' => 'renewDate',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Attempts',
                'key' => 'attempts',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Log',
                'key' => 'log',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Updated Date',
                'key' => 'updated',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Certificate ID',
                'key' => 'certificateId',
                'type' => Database::SYSTEM_VAR_TYPE_KEY,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_FILES => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_FILES,
        '$permissions' => ['read' => ['*']],
        'name' => 'File',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Date Created',
                'key' => 'dateCreated',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Folder ID',
                'key' => 'folderId',
                'type' => Database::SYSTEM_VAR_TYPE_KEY,
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Path',
                'key' => 'path',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Signature',
                'key' => 'signature',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Mime Type',
                'key' => 'mimeType',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Original Size',
                'key' => 'sizeOriginal',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Actual Size',
                'key' => 'sizeActual',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Algorithm',
                'key' => 'algorithm',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Token',
                'key' => 'token',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Comment',
                'key' => 'comment',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'File OpenSSL Version',
                'key' => 'fileOpenSSLVersion',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'File OpenSSL Cipher',
                'key' => 'fileOpenSSLCipher',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'File OpenSSL Tag',
                'key' => 'fileOpenSSLTag',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'File OpenSSL IV',
                'key' => 'fileOpenSSLIV',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_FUNCTIONS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_FUNCTIONS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Functions',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Date Created',
                'key' => 'dateCreated',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Date Updated',
                'key' => 'dateUpdated',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Status',
                'key' => 'status',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Runtime',
                'key' => 'runtime',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Tag',
                'key' => 'tag',
                'type' => Database::SYSTEM_VAR_TYPE_KEY,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Vars',
                'key' => 'vars',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
                'filter' => ['json', 'encrypt']
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Events',
                'key' => 'events',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => true,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Schedule',
                'key' => 'schedule',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Schedule Previous Run',
                'key' => 'schedulePrevious',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Schedule Next Run',
                'key' => 'scheduleNext',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Timeout',
                'key' => 'timeout',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_TAGS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_TAGS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Tags',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Date Created',
                'key' => 'dateCreated',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Function ID',
                'key' => 'functionId',
                'type' => Database::SYSTEM_VAR_TYPE_KEY,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Command',
                'key' => 'command',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Code Path',
                'key' => 'path',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Code Size',
                'key' => 'size',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_EXECUTIONS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_EXECUTIONS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Executions',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Date Created',
                'key' => 'dateCreated',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Function ID',
                'key' => 'functionId',
                'type' => Database::SYSTEM_VAR_TYPE_KEY,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Tag ID',
                'key' => 'tagId',
                'type' => Database::SYSTEM_VAR_TYPE_KEY,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Trigger',
                'key' => 'trigger',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Status',
                'key' => 'status',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Exit Code',
                'key' => 'exitCode',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Stdout',
                'key' => 'stdout',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Stderr',
                'key' => 'stderr',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Time',
                'key' => 'time',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_CONNECTIONS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_CONNECTIONS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Realtime Connections',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_CONNECTIONS,
                'label' => 'Container',
                'key' => 'container',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_CONNECTIONS,
                'label' => 'Timestamp',
                'key' => 'timestamp',
                'type' => Database::SYSTEM_VAR_TYPE_NUMERIC,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_CONNECTIONS,
                'label' => 'Value',
                'key' => 'value',
                'type' => Database::SYSTEM_VAR_TYPE_TEXT,
                'required' => true,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_RESERVED => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_RESERVED,
        '$permissions' => ['read' => ['*']],
        'name' => 'Reserved',
        'structure' => true,
    ],
];

/*
 * Add enabled OAuth2 providers to default data rules
 */
foreach ($providers as $index => $provider) {
    if (!$provider['enabled']) {
        continue;
    }

    $collections[Database::SYSTEM_COLLECTION_PROJECTS]['rules'][] = [
        '$collection' => Database::SYSTEM_COLLECTION_RULES,
        'label' => 'OAuth2 '.\ucfirst($index).' ID',
        'key' => 'usersOauth2'.\ucfirst($index).'Appid',
        'type' => Database::SYSTEM_VAR_TYPE_TEXT,
        'default' => '',
        'required' => false,
        'array' => false,
    ];

    $collections[Database::SYSTEM_COLLECTION_PROJECTS]['rules'][] = [
        '$collection' => Database::SYSTEM_COLLECTION_RULES,
        'label' => 'OAuth2 '.\ucfirst($index).' Secret',
        'key' => 'usersOauth2'.\ucfirst($index).'Secret',
        'type' => Database::SYSTEM_VAR_TYPE_TEXT,
        'default' => '',
        'required' => false,
        'array' => false,
        'filter' => ['encrypt'],
    ];
}

foreach ($auth as $index => $method) {
    $collections[Database::SYSTEM_COLLECTION_PROJECTS]['rules'][] = [
        '$collection' => Database::SYSTEM_COLLECTION_RULES,
        'label' => $method['name'] || '',
        'key' => $method['key'] || '',
        'type' => Database::SYSTEM_VAR_TYPE_BOOLEAN,
        'default' => true,
        'required' => false,
    ];
}

return $collections;