# Overview

## Introduction

Quick walkthroughs to get you started with {{rbx}}.

<div class="grid cards" markdown>

-   :fontawesome-solid-box-open: **Get {{rbx}} running in a minute**

    ---

    Install {{rbx}} with `uv` on Linux or macOS.

    [:octicons-arrow-right-24: Installation](/intro/installation)

-   :fontawesome-solid-pen: **Edit a sample problem**

    ---

    Start from a simple example problem and learn the basics of {{rbx}}.

    [:octicons-arrow-right-24: First steps](/setters/first-steps)

</div>

## Feature Guide

Learn how to use the different features of {{rbx}}.

<div class="grid cards" markdown>

-   :fontawesome-solid-pen: **Build your own testset**

    ---

    Learn how to set samples, use generators and stress tests.

    [:octicons-arrow-right-24: Testset](/setters/testset)

-   :fontawesome-solid-code: **Define your constraints**

    ---

    Define variables and use them in validators,
    checkers and even in your statements.

    [:octicons-arrow-right-24: Variables](/setters/variables)

-   :fontawesome-solid-check: **Verify your problem**

    ---

    Ensure the correctness of your problem with validators and unit tests.

    [:octicons-arrow-right-24: Verification](/setters/verification)

-   :fontawesome-solid-person-running: **Run your solutions**

    ---

    Run your solutions and verify whether they're given the expected verdict or not.

    [:octicons-arrow-right-24: Running](/setters/running)

-   :fontawesome-solid-not-equal: **Grade with custom checkers**

    ---

    Learn how to write a custom checker for a problem.

    [:octicons-arrow-right-24: Checkers](/setters/grading/checkers)

-   :fontawesome-solid-right-left: **Write an interactive problem**

    ---

    Learn how to write an interactive problem from scratch.

    [:octicons-arrow-right-24: Interactors](/setters/grading/interactors)

-   :fontawesome-solid-language: **Write, format and translate**

    ---

    Learn how to write multiple statements and build them.

    <!-- TODO: add link -->
    [:octicons-arrow-right-24: Statements](/setters/packaging)

-   :fontawesome-solid-rocket: **Package and ship**

    ---

    Build, package and ship your problem to competitive programming platforms.

    [:octicons-arrow-right-24: Packaging](/setters/packaging)

</div>

## Reference

Reference documentation for {{rbx}}.

<div class="grid cards" markdown>

-   :fontawesome-solid-clipboard-list: **Cheatsheet**

    ---

    A one stop shop for all the commands and options available in {{rbx}}.

    [:octicons-arrow-right-24: Cheatsheet](/setters/cheatsheet)

-   :fontawesome-solid-gear: **Problem configuration**

    ---

    A summary of all the configuration options available in `problem.rbx.yml`.

    [:octicons-arrow-right-24: `problem.rbx.yml`](/setters/reference/package)    
</div>