package server

import (
	"fmt"

	"github.com/opencontainers/selinux/go-selinux/label"
	"github.com/pkg/errors"
	"golang.org/x/sys/unix"
)

func securityLabel(path, secLabel string, shared bool) error {
	if err := label.Relabel(path, secLabel, shared); err != nil && errors.Cause(err) != unix.ENOTSUP {
		return fmt.Errorf("relabel failed %s: %v", path, err)
	}
	return nil
}
