<!-- Generated by cargo-onedoc. DO NOT EDIT. -->

# iterchunks

[![Crates.io Version](https://img.shields.io/crates/v/iterchunks.svg)](https://crates.io/crates/iterchunks)
[![Docs.rs Latest](https://img.shields.io/badge/docs.rs-latest-blue.svg)](https://docs.rs/iterchunks)
[![Build Status](https://img.shields.io/github/workflow/status/rossmacarthur/itermore/build/trunk)](https://github.com/rossmacarthur/itermore/actions?query=workflow%3Abuild)

This crate provides an iterator adapter that yields N elements of the
iterator at a time.

This methods provided here have the corresponding nightly APIs:

- [Iterator::next_chunk](https://doc.rust-lang.org/stable/std/iter/trait.Iterator.html#method.next_chunk)
- [Iterator::array_chunks](https://doc.rust-lang.org/stable/std/iter/trait.Iterator.html#method.array_chunks)

The nightly APIs handle remainders better and will likely have better
performance, so they should be preferred if possible.

## Getting started

Add the crate to your Cargo manifest.

```sh
cargo add iterchunks
```

And bring the `IterArrayChunks` trait into scope.

```rust
use iterchunks::IterArrayChunks;
```

Now you can use the [`array_chunks`] method on any iterator.

```rust
for [a, b, c] in iter.array_chunks() {
    println!("{} {} {}", a, b, c)
}
```

Generally the size of `N` can be inferred by the compiler but you can also
specify it manually.

```rust
let c = iter.array_chunks::<3>();
```

[`array_chunks`]: IterArrayChunks::array_chunks

## License

This project is distributed under the terms of both the MIT license and the Apache License (Version 2.0).

See [LICENSE-APACHE](LICENSE-APACHE) and [LICENSE-MIT](LICENSE-MIT) for details.
