<!-- Generated by cargo-onedoc. DO NOT EDIT. -->

# itermore

[![Crates.io Version](https://img.shields.io/crates/v/itermore.svg)](https://crates.io/crates/itermore)
[![Docs.rs Latest](https://img.shields.io/badge/docs.rs-latest-blue.svg)](https://docs.rs/itermore)
[![Build Status](https://img.shields.io/github/workflow/status/rossmacarthur/itermore/build/trunk)](https://github.com/rossmacarthur/itermore/actions?query=workflow%3Abuild)

🤸‍♀️ More iterator adaptors.

This crate provides some useful iterator adaptors like [`array_chunks`] and
[`array_windows`]. Unlike [`itertools`](https://docs.rs/itertools) this
crate provides a separate extension trait for each adaptor. Additionally,
each type of adaptor is feature flagged so you only have to compile the
features you need.

## Getting started

Add the crate to Cargo manifest.

```sh
cargo add itermore
```

And bring the extension traits into scope.

```rust
use itermore::prelude::*;
```

Now you can use extension methods like [`array_windows`] on any iterator.

```rust
for [a, b, c] in iter.array_windows() {
    println!("{} {} {}", a, b, c)
}
// Outputs
//    1 2 3
//    2 3 4
//    3 4 5
```

It is recommended to only enable the features that you need, you can do this
by disabling all features and turning on the ones you want. For example if
you only want the [`array_combinations`] adaptor you would add the following
to your Cargo manifest.

```toml
[dependencies]
itermore = { version = "*",  default-features = false, features = ["array_combinations"]}
```

## Provided functionality

### Methods

- [`next_chunk`]: Returns the next `N` elements of the iterator as an array.
- [`sorted`] and friends: Returns a new iterator with all elements sorted.

### Adaptors

- [`array_chunks`] returns an iterator over `N` elements of the iterator at
  a time.
- [`array_windows`] returns an iterator over all contiguous windows of
  length \`N.
- [`array_combinations`] returns an iterator over `K` length combinations of
  all the elements in the underlying iterator.
- [`array_combinations_with_reps`] returns an iterator over `K` length
  combinations with repetitions/replacements of all the elements in the
  underlying iterator.

[`array_chunks`]: IterArrayChunks::array_chunks
[`array_windows`]: IterArrayWindows::array_windows
[`array_combinations`]: IterArrayCombinations::array_combinations
[`next_chunk`]: IterArrayChunks::next_chunk
[`sorted`]: IterSorted::sorted
[`array_combinations_with_reps`]: IterArrayCombinations::array_combinations_with_reps

## License

This project is distributed under the terms of both the MIT license and the Apache License (Version 2.0).

See [LICENSE-APACHE](LICENSE-APACHE) and [LICENSE-MIT](LICENSE-MIT) for details.
