// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: rpc.proto

package storepb

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	"github.com/grafana/mimir/pkg/mimirpb"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type SeriesRequest struct {
	MinTime  int64          `protobuf:"varint,1,opt,name=min_time,json=minTime,proto3" json:"min_time,omitempty"`
	MaxTime  int64          `protobuf:"varint,2,opt,name=max_time,json=maxTime,proto3" json:"max_time,omitempty"`
	Matchers []LabelMatcher `protobuf:"bytes,3,rep,name=matchers,proto3" json:"matchers"`
	// skip_chunks controls whether sending chunks or not in series responses.
	SkipChunks bool `protobuf:"varint,8,opt,name=skip_chunks,json=skipChunks,proto3" json:"skip_chunks,omitempty"`
	// hints is an opaque data structure that can be used to carry additional information.
	// The content of this field and whether it's supported depends on the
	// implementation of a specific store.
	Hints *types.Any `protobuf:"bytes,9,opt,name=hints,proto3" json:"hints,omitempty"`
	// If streaming_chunks_batch_size=0, the response must only contain one 'series' at a time
	// with the series labels and chunks data sent together.
	// If streaming_chunks_batch_size > 0
	// - The store may choose to send the streaming_series/streaming_chunks OR behave as
	//   if streaming_chunks_batch_size=0 if it does not support streaming series.
	// - The store must not send a mix of 'series' and streaming_series/streaming_chunks for a single request.
	// - If the store chooses to send streaming series, all the streaming_series must be sent before
	//   sending any streaming_chunks, with the last streaming_series response containing is_end_of_series_stream=true.
	//   The order of series in both streaming_series/streaming_chunks must match and the size of the batch must not
	//   cross streaming_chunks_batch_size, although it can be lower than that.
	// The proto field ID is 100 so that we have an option to bring back compatibility with Thanos' storage API.
	StreamingChunksBatchSize uint64 `protobuf:"varint,100,opt,name=streaming_chunks_batch_size,json=streamingChunksBatchSize,proto3" json:"streaming_chunks_batch_size,omitempty"`
}

func (m *SeriesRequest) Reset()      { *m = SeriesRequest{} }
func (*SeriesRequest) ProtoMessage() {}
func (*SeriesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_77a6da22d6a3feb1, []int{0}
}
func (m *SeriesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SeriesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SeriesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SeriesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SeriesRequest.Merge(m, src)
}
func (m *SeriesRequest) XXX_Size() int {
	return m.Size()
}
func (m *SeriesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SeriesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SeriesRequest proto.InternalMessageInfo

type Stats struct {
	// This is the sum of all fetched index bytes (postings + series) for a series request.
	FetchedIndexBytes uint64 `protobuf:"varint,1,opt,name=fetched_index_bytes,json=fetchedIndexBytes,proto3" json:"fetched_index_bytes,omitempty"`
}

func (m *Stats) Reset()      { *m = Stats{} }
func (*Stats) ProtoMessage() {}
func (*Stats) Descriptor() ([]byte, []int) {
	return fileDescriptor_77a6da22d6a3feb1, []int{1}
}
func (m *Stats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Stats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Stats.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Stats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Stats.Merge(m, src)
}
func (m *Stats) XXX_Size() int {
	return m.Size()
}
func (m *Stats) XXX_DiscardUnknown() {
	xxx_messageInfo_Stats.DiscardUnknown(m)
}

var xxx_messageInfo_Stats proto.InternalMessageInfo

type SeriesResponse struct {
	// Keep reference to buffer for unsafe references.
	mimirpb.BufferHolder

	// Types that are valid to be assigned to Result:
	//	*SeriesResponse_Series
	//	*SeriesResponse_Warning
	//	*SeriesResponse_Hints
	//	*SeriesResponse_Stats
	//	*SeriesResponse_StreamingSeries
	//	*SeriesResponse_StreamingChunks
	//	*SeriesResponse_StreamingChunksEstimate
	Result isSeriesResponse_Result `protobuf_oneof:"result"`
}

func (m *SeriesResponse) Reset()      { *m = SeriesResponse{} }
func (*SeriesResponse) ProtoMessage() {}
func (*SeriesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_77a6da22d6a3feb1, []int{2}
}
func (m *SeriesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SeriesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SeriesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SeriesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SeriesResponse.Merge(m, src)
}
func (m *SeriesResponse) XXX_Size() int {
	return m.Size()
}
func (m *SeriesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SeriesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SeriesResponse proto.InternalMessageInfo

type isSeriesResponse_Result interface {
	isSeriesResponse_Result()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type SeriesResponse_Series struct {
	Series *Series `protobuf:"bytes,1,opt,name=series,proto3,oneof" json:"series,omitempty"`
}
type SeriesResponse_Warning struct {
	Warning string `protobuf:"bytes,2,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}
type SeriesResponse_Hints struct {
	Hints *types.Any `protobuf:"bytes,3,opt,name=hints,proto3,oneof" json:"hints,omitempty"`
}
type SeriesResponse_Stats struct {
	Stats *Stats `protobuf:"bytes,4,opt,name=stats,proto3,oneof" json:"stats,omitempty"`
}
type SeriesResponse_StreamingSeries struct {
	StreamingSeries *StreamingSeriesBatch `protobuf:"bytes,5,opt,name=streaming_series,json=streamingSeries,proto3,oneof" json:"streaming_series,omitempty"`
}
type SeriesResponse_StreamingChunks struct {
	StreamingChunks *StreamingChunksBatch `protobuf:"bytes,6,opt,name=streaming_chunks,json=streamingChunks,proto3,oneof" json:"streaming_chunks,omitempty"`
}
type SeriesResponse_StreamingChunksEstimate struct {
	StreamingChunksEstimate *StreamingChunksEstimate `protobuf:"bytes,7,opt,name=streaming_chunks_estimate,json=streamingChunksEstimate,proto3,oneof" json:"streaming_chunks_estimate,omitempty"`
}

func (*SeriesResponse_Series) isSeriesResponse_Result()                  {}
func (*SeriesResponse_Warning) isSeriesResponse_Result()                 {}
func (*SeriesResponse_Hints) isSeriesResponse_Result()                   {}
func (*SeriesResponse_Stats) isSeriesResponse_Result()                   {}
func (*SeriesResponse_StreamingSeries) isSeriesResponse_Result()         {}
func (*SeriesResponse_StreamingChunks) isSeriesResponse_Result()         {}
func (*SeriesResponse_StreamingChunksEstimate) isSeriesResponse_Result() {}

func (m *SeriesResponse) GetResult() isSeriesResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *SeriesResponse) GetSeries() *Series {
	if x, ok := m.GetResult().(*SeriesResponse_Series); ok {
		return x.Series
	}
	return nil
}

func (m *SeriesResponse) GetWarning() string {
	if x, ok := m.GetResult().(*SeriesResponse_Warning); ok {
		return x.Warning
	}
	return ""
}

func (m *SeriesResponse) GetHints() *types.Any {
	if x, ok := m.GetResult().(*SeriesResponse_Hints); ok {
		return x.Hints
	}
	return nil
}

func (m *SeriesResponse) GetStats() *Stats {
	if x, ok := m.GetResult().(*SeriesResponse_Stats); ok {
		return x.Stats
	}
	return nil
}

func (m *SeriesResponse) GetStreamingSeries() *StreamingSeriesBatch {
	if x, ok := m.GetResult().(*SeriesResponse_StreamingSeries); ok {
		return x.StreamingSeries
	}
	return nil
}

func (m *SeriesResponse) GetStreamingChunks() *StreamingChunksBatch {
	if x, ok := m.GetResult().(*SeriesResponse_StreamingChunks); ok {
		return x.StreamingChunks
	}
	return nil
}

func (m *SeriesResponse) GetStreamingChunksEstimate() *StreamingChunksEstimate {
	if x, ok := m.GetResult().(*SeriesResponse_StreamingChunksEstimate); ok {
		return x.StreamingChunksEstimate
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SeriesResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SeriesResponse_Series)(nil),
		(*SeriesResponse_Warning)(nil),
		(*SeriesResponse_Hints)(nil),
		(*SeriesResponse_Stats)(nil),
		(*SeriesResponse_StreamingSeries)(nil),
		(*SeriesResponse_StreamingChunks)(nil),
		(*SeriesResponse_StreamingChunksEstimate)(nil),
	}
}

type LabelNamesRequest struct {
	Start int64 `protobuf:"varint,3,opt,name=start,proto3" json:"start,omitempty"`
	End   int64 `protobuf:"varint,4,opt,name=end,proto3" json:"end,omitempty"`
	// hints is an opaque data structure that can be used to carry additional information.
	// The content of this field and whether it's supported depends on the
	// implementation of a specific store.
	Hints    *types.Any     `protobuf:"bytes,5,opt,name=hints,proto3" json:"hints,omitempty"`
	Matchers []LabelMatcher `protobuf:"bytes,6,rep,name=matchers,proto3" json:"matchers"`
	Limit    int64          `protobuf:"varint,7,opt,name=limit,proto3" json:"limit,omitempty"`
}

func (m *LabelNamesRequest) Reset()      { *m = LabelNamesRequest{} }
func (*LabelNamesRequest) ProtoMessage() {}
func (*LabelNamesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_77a6da22d6a3feb1, []int{3}
}
func (m *LabelNamesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LabelNamesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LabelNamesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LabelNamesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelNamesRequest.Merge(m, src)
}
func (m *LabelNamesRequest) XXX_Size() int {
	return m.Size()
}
func (m *LabelNamesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelNamesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LabelNamesRequest proto.InternalMessageInfo

type LabelNamesResponse struct {
	Names    []string `protobuf:"bytes,1,rep,name=names,proto3" json:"names,omitempty"`
	Warnings []string `protobuf:"bytes,2,rep,name=warnings,proto3" json:"warnings,omitempty"`
	/// hints is an opaque data structure that can be used to carry additional information from
	/// the store. The content of this field and whether it's supported depends on the
	/// implementation of a specific store.
	Hints *types.Any `protobuf:"bytes,3,opt,name=hints,proto3" json:"hints,omitempty"`
}

func (m *LabelNamesResponse) Reset()      { *m = LabelNamesResponse{} }
func (*LabelNamesResponse) ProtoMessage() {}
func (*LabelNamesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_77a6da22d6a3feb1, []int{4}
}
func (m *LabelNamesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LabelNamesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LabelNamesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LabelNamesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelNamesResponse.Merge(m, src)
}
func (m *LabelNamesResponse) XXX_Size() int {
	return m.Size()
}
func (m *LabelNamesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelNamesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LabelNamesResponse proto.InternalMessageInfo

type LabelValuesRequest struct {
	Label string `protobuf:"bytes,1,opt,name=label,proto3" json:"label,omitempty"`
	Start int64  `protobuf:"varint,4,opt,name=start,proto3" json:"start,omitempty"`
	End   int64  `protobuf:"varint,5,opt,name=end,proto3" json:"end,omitempty"`
	// hints is an opaque data structure that can be used to carry additional information.
	// The content of this field and whether it's supported depends on the
	// implementation of a specific store.
	Hints    *types.Any     `protobuf:"bytes,6,opt,name=hints,proto3" json:"hints,omitempty"`
	Matchers []LabelMatcher `protobuf:"bytes,7,rep,name=matchers,proto3" json:"matchers"`
	Limit    int64          `protobuf:"varint,8,opt,name=limit,proto3" json:"limit,omitempty"`
}

func (m *LabelValuesRequest) Reset()      { *m = LabelValuesRequest{} }
func (*LabelValuesRequest) ProtoMessage() {}
func (*LabelValuesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_77a6da22d6a3feb1, []int{5}
}
func (m *LabelValuesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LabelValuesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LabelValuesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LabelValuesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelValuesRequest.Merge(m, src)
}
func (m *LabelValuesRequest) XXX_Size() int {
	return m.Size()
}
func (m *LabelValuesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelValuesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LabelValuesRequest proto.InternalMessageInfo

type LabelValuesResponse struct {
	Values   []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	Warnings []string `protobuf:"bytes,2,rep,name=warnings,proto3" json:"warnings,omitempty"`
	/// hints is an opaque data structure that can be used to carry additional information from
	/// the store. The content of this field and whether it's supported depends on the
	/// implementation of a specific store.
	Hints *types.Any `protobuf:"bytes,3,opt,name=hints,proto3" json:"hints,omitempty"`
}

func (m *LabelValuesResponse) Reset()      { *m = LabelValuesResponse{} }
func (*LabelValuesResponse) ProtoMessage() {}
func (*LabelValuesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_77a6da22d6a3feb1, []int{6}
}
func (m *LabelValuesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LabelValuesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LabelValuesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LabelValuesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelValuesResponse.Merge(m, src)
}
func (m *LabelValuesResponse) XXX_Size() int {
	return m.Size()
}
func (m *LabelValuesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelValuesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LabelValuesResponse proto.InternalMessageInfo

func init() {
	proto.RegisterType((*SeriesRequest)(nil), "thanos.SeriesRequest")
	proto.RegisterType((*Stats)(nil), "thanos.Stats")
	proto.RegisterType((*SeriesResponse)(nil), "thanos.SeriesResponse")
	proto.RegisterType((*LabelNamesRequest)(nil), "thanos.LabelNamesRequest")
	proto.RegisterType((*LabelNamesResponse)(nil), "thanos.LabelNamesResponse")
	proto.RegisterType((*LabelValuesRequest)(nil), "thanos.LabelValuesRequest")
	proto.RegisterType((*LabelValuesResponse)(nil), "thanos.LabelValuesResponse")
}

func init() { proto.RegisterFile("rpc.proto", fileDescriptor_77a6da22d6a3feb1) }

var fileDescriptor_77a6da22d6a3feb1 = []byte{
	// 740 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x93, 0x41, 0x6f, 0xd3, 0x3c,
	0x18, 0xc7, 0xe3, 0xc6, 0x49, 0x5d, 0x77, 0xdd, 0x9b, 0x65, 0xd5, 0x4b, 0x56, 0x50, 0x56, 0x55,
	0x42, 0xaa, 0x10, 0xea, 0xa4, 0x21, 0xc1, 0x89, 0xc3, 0x8a, 0x90, 0xba, 0x08, 0x38, 0x78, 0x88,
	0x03, 0x12, 0xaa, 0xd2, 0xd5, 0x6b, 0xad, 0x35, 0x49, 0x89, 0x5d, 0x58, 0x77, 0xe2, 0x23, 0xf0,
	0x31, 0x10, 0xdf, 0x80, 0x23, 0xb7, 0x1d, 0x77, 0xdc, 0x09, 0xd1, 0xee, 0xc2, 0x71, 0x1f, 0x01,
	0xc5, 0x76, 0xdb, 0x55, 0x6c, 0x9a, 0x86, 0xb8, 0xf9, 0xf9, 0xff, 0x1f, 0x3f, 0xf6, 0xf3, 0xf3,
	0x63, 0x5c, 0x48, 0x87, 0xfb, 0x8d, 0x61, 0x9a, 0x88, 0xc4, 0xb5, 0x45, 0x3f, 0x8c, 0x13, 0x5e,
	0x29, 0x8a, 0xf1, 0x90, 0x72, 0x25, 0x56, 0xca, 0xbd, 0xa4, 0x97, 0xc8, 0xe5, 0x56, 0xb6, 0xd2,
	0xea, 0x46, 0x2f, 0x49, 0x7a, 0x03, 0xba, 0x25, 0xa3, 0xce, 0xe8, 0x60, 0x2b, 0x8c, 0xc7, 0xca,
	0xaa, 0x7d, 0xcb, 0xe1, 0xd2, 0x1e, 0x4d, 0x19, 0xe5, 0x84, 0xbe, 0x1f, 0x51, 0x2e, 0xdc, 0x0d,
	0x8c, 0x22, 0x16, 0xb7, 0x05, 0x8b, 0xa8, 0x07, 0xaa, 0xa0, 0x6e, 0x92, 0x7c, 0xc4, 0xe2, 0xd7,
	0x2c, 0xa2, 0xd2, 0x0a, 0x8f, 0x94, 0x95, 0xd3, 0x56, 0x78, 0x24, 0xad, 0xc7, 0x99, 0x25, 0xf6,
	0xfb, 0x34, 0xe5, 0x9e, 0x59, 0x35, 0xeb, 0xc5, 0xed, 0x72, 0x43, 0x5d, 0xb0, 0xf1, 0x22, 0xec,
	0xd0, 0xc1, 0x4b, 0x65, 0x36, 0xe1, 0xc9, 0x8f, 0x4d, 0x83, 0xcc, 0x73, 0xdd, 0x4d, 0x5c, 0xe4,
	0x87, 0x6c, 0xd8, 0xde, 0xef, 0x8f, 0xe2, 0x43, 0xee, 0xa1, 0x2a, 0xa8, 0x23, 0x82, 0x33, 0xe9,
	0x99, 0x54, 0xdc, 0x07, 0xd8, 0xea, 0xb3, 0x58, 0x70, 0xaf, 0x50, 0x05, 0xb2, 0xaa, 0xea, 0xa5,
	0x31, 0xeb, 0xa5, 0xb1, 0x13, 0x8f, 0x89, 0x4a, 0x71, 0x9f, 0xe2, 0xbb, 0x5c, 0xa4, 0x34, 0x8c,
	0x58, 0xdc, 0xd3, 0x15, 0xdb, 0x9d, 0xec, 0xa4, 0x36, 0x67, 0xc7, 0xd4, 0xeb, 0x56, 0x41, 0x1d,
	0x12, 0x6f, 0x9e, 0xa2, 0x4e, 0x68, 0x66, 0x09, 0x7b, 0xec, 0x98, 0x06, 0x10, 0x41, 0xc7, 0x0a,
	0x20, 0xb2, 0x1c, 0x3b, 0x80, 0xc8, 0x76, 0xf2, 0x01, 0x44, 0x79, 0x07, 0x05, 0x10, 0x61, 0xa7,
	0x18, 0x40, 0x54, 0x74, 0x56, 0x02, 0x88, 0x56, 0x9c, 0x52, 0x00, 0x51, 0xc9, 0x59, 0xad, 0x3d,
	0xc1, 0xd6, 0x9e, 0x08, 0x05, 0x77, 0x1b, 0x78, 0xfd, 0x80, 0x66, 0x0d, 0x75, 0xdb, 0x2c, 0xee,
	0xd2, 0xa3, 0x76, 0x67, 0x2c, 0x28, 0x97, 0xf4, 0x20, 0x59, 0xd3, 0xd6, 0x6e, 0xe6, 0x34, 0x33,
	0xa3, 0xf6, 0xd5, 0xc4, 0xab, 0x33, 0xe8, 0x7c, 0x98, 0xc4, 0x9c, 0xba, 0x75, 0x6c, 0x73, 0xa9,
	0xc8, 0x5d, 0xc5, 0xed, 0xd5, 0x19, 0x3d, 0x95, 0xd7, 0x32, 0x88, 0xf6, 0xdd, 0x0a, 0xce, 0x7f,
	0x0c, 0xd3, 0x98, 0xc5, 0x3d, 0xf9, 0x06, 0x85, 0x96, 0x41, 0x66, 0x82, 0xfb, 0x70, 0x06, 0xcb,
	0xbc, 0x1e, 0x56, 0xcb, 0x98, 0xe1, 0xba, 0x8f, 0x2d, 0x9e, 0xdd, 0xdf, 0x83, 0x32, 0xbb, 0x34,
	0x3f, 0x32, 0x13, 0xb3, 0x34, 0xe9, 0xba, 0xbb, 0xd8, 0x59, 0x50, 0xd5, 0x97, 0xb4, 0xe4, 0x8e,
	0x7b, 0x8b, 0x1d, 0xda, 0x57, 0xb7, 0x95, 0x48, 0x5b, 0x06, 0xf9, 0x8f, 0x2f, 0xeb, 0xcb, 0xa5,
	0xf4, 0x93, 0xdb, 0xd7, 0x94, 0xba, 0xf4, 0x3a, 0x4b, 0xa5, 0xf4, 0x5c, 0xbc, 0xc3, 0x1b, 0x7f,
	0xbc, 0x35, 0xe5, 0x82, 0x45, 0xa1, 0xa0, 0x5e, 0x5e, 0xd6, 0xdc, 0xbc, 0xa6, 0xe6, 0x73, 0x9d,
	0xd6, 0x32, 0xc8, 0x1d, 0x7e, 0xb5, 0xd5, 0x44, 0xd8, 0x4e, 0x29, 0x1f, 0x0d, 0x44, 0xed, 0x3b,
	0xc0, 0x6b, 0x72, 0x84, 0x5f, 0x85, 0xd1, 0xe2, 0x97, 0x94, 0x25, 0xbb, 0x54, 0x48, 0xd2, 0x26,
	0x51, 0x81, 0xeb, 0x60, 0x93, 0xc6, 0x5d, 0xc9, 0xd3, 0x24, 0xd9, 0x72, 0x31, 0xbe, 0xd6, 0xcd,
	0xe3, 0x7b, 0xf9, 0x0f, 0xd9, 0xb7, 0xf8, 0x43, 0x65, 0x6c, 0x0d, 0x58, 0xc4, 0x84, 0x6c, 0xdb,
	0x24, 0x2a, 0x08, 0x20, 0x02, 0x4e, 0x2e, 0x80, 0x28, 0xe7, 0x98, 0xb5, 0x14, 0xbb, 0x97, 0x5b,
	0xd0, 0x33, 0x57, 0xc6, 0x56, 0x9c, 0x09, 0x1e, 0xa8, 0x9a, 0xf5, 0x02, 0x51, 0x81, 0x5b, 0xc1,
	0x48, 0x8f, 0x13, 0xf7, 0x72, 0xd2, 0x98, 0xc7, 0x8b, 0x6e, 0xcc, 0x1b, 0xbb, 0xa9, 0x9d, 0x01,
	0x7d, 0xe8, 0x9b, 0x70, 0x30, 0x5a, 0x02, 0x37, 0xc8, 0x54, 0x39, 0xe7, 0x05, 0xa2, 0x82, 0x05,
	0x4e, 0x78, 0x05, 0x4e, 0xeb, 0x0a, 0x9c, 0xf6, 0xed, 0x70, 0xe6, 0xff, 0x06, 0x27, 0x5a, 0xc6,
	0x99, 0x73, 0xcc, 0x00, 0x22, 0xd3, 0x81, 0xb5, 0x11, 0x5e, 0x5f, 0xea, 0x4c, 0xf3, 0xfc, 0x1f,
	0xdb, 0x1f, 0xa4, 0xa2, 0x81, 0xea, 0xe8, 0x5f, 0x11, 0x6d, 0xee, 0x9c, 0x4c, 0x7c, 0xe3, 0x74,
	0xe2, 0x1b, 0x67, 0x13, 0xdf, 0xb8, 0x98, 0xf8, 0xe0, 0xd3, 0xd4, 0x07, 0x5f, 0xa6, 0x3e, 0x38,
	0x99, 0xfa, 0xe0, 0x74, 0xea, 0x83, 0x9f, 0x53, 0x1f, 0xfc, 0x9a, 0xfa, 0xc6, 0xc5, 0xd4, 0x07,
	0x9f, 0xcf, 0x7d, 0xe3, 0xf4, 0xdc, 0x37, 0xce, 0xce, 0x7d, 0xe3, 0x6d, 0x9e, 0x8b, 0x24, 0xa5,
	0xc3, 0x4e, 0xc7, 0x96, 0x75, 0x1f, 0xfd, 0x0e, 0x00, 0x00, 0xff, 0xff, 0xe5, 0x44, 0xee, 0x5d,
	0x48, 0x06, 0x00, 0x00,
}

func (this *SeriesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SeriesRequest)
	if !ok {
		that2, ok := that.(SeriesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.MinTime != that1.MinTime {
		return false
	}
	if this.MaxTime != that1.MaxTime {
		return false
	}
	if len(this.Matchers) != len(that1.Matchers) {
		return false
	}
	for i := range this.Matchers {
		if !this.Matchers[i].Equal(&that1.Matchers[i]) {
			return false
		}
	}
	if this.SkipChunks != that1.SkipChunks {
		return false
	}
	if !this.Hints.Equal(that1.Hints) {
		return false
	}
	if this.StreamingChunksBatchSize != that1.StreamingChunksBatchSize {
		return false
	}
	return true
}
func (this *Stats) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Stats)
	if !ok {
		that2, ok := that.(Stats)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.FetchedIndexBytes != that1.FetchedIndexBytes {
		return false
	}
	return true
}
func (this *SeriesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SeriesResponse)
	if !ok {
		that2, ok := that.(SeriesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.Result == nil {
		if this.Result != nil {
			return false
		}
	} else if this.Result == nil {
		return false
	} else if !this.Result.Equal(that1.Result) {
		return false
	}
	return true
}
func (this *SeriesResponse_Series) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SeriesResponse_Series)
	if !ok {
		that2, ok := that.(SeriesResponse_Series)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Series.Equal(that1.Series) {
		return false
	}
	return true
}
func (this *SeriesResponse_Warning) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SeriesResponse_Warning)
	if !ok {
		that2, ok := that.(SeriesResponse_Warning)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Warning != that1.Warning {
		return false
	}
	return true
}
func (this *SeriesResponse_Hints) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SeriesResponse_Hints)
	if !ok {
		that2, ok := that.(SeriesResponse_Hints)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Hints.Equal(that1.Hints) {
		return false
	}
	return true
}
func (this *SeriesResponse_Stats) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SeriesResponse_Stats)
	if !ok {
		that2, ok := that.(SeriesResponse_Stats)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Stats.Equal(that1.Stats) {
		return false
	}
	return true
}
func (this *SeriesResponse_StreamingSeries) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SeriesResponse_StreamingSeries)
	if !ok {
		that2, ok := that.(SeriesResponse_StreamingSeries)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.StreamingSeries.Equal(that1.StreamingSeries) {
		return false
	}
	return true
}
func (this *SeriesResponse_StreamingChunks) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SeriesResponse_StreamingChunks)
	if !ok {
		that2, ok := that.(SeriesResponse_StreamingChunks)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.StreamingChunks.Equal(that1.StreamingChunks) {
		return false
	}
	return true
}
func (this *SeriesResponse_StreamingChunksEstimate) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SeriesResponse_StreamingChunksEstimate)
	if !ok {
		that2, ok := that.(SeriesResponse_StreamingChunksEstimate)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.StreamingChunksEstimate.Equal(that1.StreamingChunksEstimate) {
		return false
	}
	return true
}
func (this *LabelNamesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LabelNamesRequest)
	if !ok {
		that2, ok := that.(LabelNamesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Start != that1.Start {
		return false
	}
	if this.End != that1.End {
		return false
	}
	if !this.Hints.Equal(that1.Hints) {
		return false
	}
	if len(this.Matchers) != len(that1.Matchers) {
		return false
	}
	for i := range this.Matchers {
		if !this.Matchers[i].Equal(&that1.Matchers[i]) {
			return false
		}
	}
	if this.Limit != that1.Limit {
		return false
	}
	return true
}
func (this *LabelNamesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LabelNamesResponse)
	if !ok {
		that2, ok := that.(LabelNamesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Names) != len(that1.Names) {
		return false
	}
	for i := range this.Names {
		if this.Names[i] != that1.Names[i] {
			return false
		}
	}
	if len(this.Warnings) != len(that1.Warnings) {
		return false
	}
	for i := range this.Warnings {
		if this.Warnings[i] != that1.Warnings[i] {
			return false
		}
	}
	if !this.Hints.Equal(that1.Hints) {
		return false
	}
	return true
}
func (this *LabelValuesRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LabelValuesRequest)
	if !ok {
		that2, ok := that.(LabelValuesRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Label != that1.Label {
		return false
	}
	if this.Start != that1.Start {
		return false
	}
	if this.End != that1.End {
		return false
	}
	if !this.Hints.Equal(that1.Hints) {
		return false
	}
	if len(this.Matchers) != len(that1.Matchers) {
		return false
	}
	for i := range this.Matchers {
		if !this.Matchers[i].Equal(&that1.Matchers[i]) {
			return false
		}
	}
	if this.Limit != that1.Limit {
		return false
	}
	return true
}
func (this *LabelValuesResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LabelValuesResponse)
	if !ok {
		that2, ok := that.(LabelValuesResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Values) != len(that1.Values) {
		return false
	}
	for i := range this.Values {
		if this.Values[i] != that1.Values[i] {
			return false
		}
	}
	if len(this.Warnings) != len(that1.Warnings) {
		return false
	}
	for i := range this.Warnings {
		if this.Warnings[i] != that1.Warnings[i] {
			return false
		}
	}
	if !this.Hints.Equal(that1.Hints) {
		return false
	}
	return true
}
func (this *SeriesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&storepb.SeriesRequest{")
	s = append(s, "MinTime: "+fmt.Sprintf("%#v", this.MinTime)+",\n")
	s = append(s, "MaxTime: "+fmt.Sprintf("%#v", this.MaxTime)+",\n")
	if this.Matchers != nil {
		vs := make([]LabelMatcher, len(this.Matchers))
		for i := range vs {
			vs[i] = this.Matchers[i]
		}
		s = append(s, "Matchers: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "SkipChunks: "+fmt.Sprintf("%#v", this.SkipChunks)+",\n")
	if this.Hints != nil {
		s = append(s, "Hints: "+fmt.Sprintf("%#v", this.Hints)+",\n")
	}
	s = append(s, "StreamingChunksBatchSize: "+fmt.Sprintf("%#v", this.StreamingChunksBatchSize)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Stats) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&storepb.Stats{")
	s = append(s, "FetchedIndexBytes: "+fmt.Sprintf("%#v", this.FetchedIndexBytes)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SeriesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&storepb.SeriesResponse{")
	if this.Result != nil {
		s = append(s, "Result: "+fmt.Sprintf("%#v", this.Result)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SeriesResponse_Series) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&storepb.SeriesResponse_Series{` +
		`Series:` + fmt.Sprintf("%#v", this.Series) + `}`}, ", ")
	return s
}
func (this *SeriesResponse_Warning) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&storepb.SeriesResponse_Warning{` +
		`Warning:` + fmt.Sprintf("%#v", this.Warning) + `}`}, ", ")
	return s
}
func (this *SeriesResponse_Hints) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&storepb.SeriesResponse_Hints{` +
		`Hints:` + fmt.Sprintf("%#v", this.Hints) + `}`}, ", ")
	return s
}
func (this *SeriesResponse_Stats) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&storepb.SeriesResponse_Stats{` +
		`Stats:` + fmt.Sprintf("%#v", this.Stats) + `}`}, ", ")
	return s
}
func (this *SeriesResponse_StreamingSeries) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&storepb.SeriesResponse_StreamingSeries{` +
		`StreamingSeries:` + fmt.Sprintf("%#v", this.StreamingSeries) + `}`}, ", ")
	return s
}
func (this *SeriesResponse_StreamingChunks) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&storepb.SeriesResponse_StreamingChunks{` +
		`StreamingChunks:` + fmt.Sprintf("%#v", this.StreamingChunks) + `}`}, ", ")
	return s
}
func (this *SeriesResponse_StreamingChunksEstimate) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&storepb.SeriesResponse_StreamingChunksEstimate{` +
		`StreamingChunksEstimate:` + fmt.Sprintf("%#v", this.StreamingChunksEstimate) + `}`}, ", ")
	return s
}
func (this *LabelNamesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&storepb.LabelNamesRequest{")
	s = append(s, "Start: "+fmt.Sprintf("%#v", this.Start)+",\n")
	s = append(s, "End: "+fmt.Sprintf("%#v", this.End)+",\n")
	if this.Hints != nil {
		s = append(s, "Hints: "+fmt.Sprintf("%#v", this.Hints)+",\n")
	}
	if this.Matchers != nil {
		vs := make([]LabelMatcher, len(this.Matchers))
		for i := range vs {
			vs[i] = this.Matchers[i]
		}
		s = append(s, "Matchers: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "Limit: "+fmt.Sprintf("%#v", this.Limit)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LabelNamesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&storepb.LabelNamesResponse{")
	s = append(s, "Names: "+fmt.Sprintf("%#v", this.Names)+",\n")
	s = append(s, "Warnings: "+fmt.Sprintf("%#v", this.Warnings)+",\n")
	if this.Hints != nil {
		s = append(s, "Hints: "+fmt.Sprintf("%#v", this.Hints)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LabelValuesRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&storepb.LabelValuesRequest{")
	s = append(s, "Label: "+fmt.Sprintf("%#v", this.Label)+",\n")
	s = append(s, "Start: "+fmt.Sprintf("%#v", this.Start)+",\n")
	s = append(s, "End: "+fmt.Sprintf("%#v", this.End)+",\n")
	if this.Hints != nil {
		s = append(s, "Hints: "+fmt.Sprintf("%#v", this.Hints)+",\n")
	}
	if this.Matchers != nil {
		vs := make([]LabelMatcher, len(this.Matchers))
		for i := range vs {
			vs[i] = this.Matchers[i]
		}
		s = append(s, "Matchers: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "Limit: "+fmt.Sprintf("%#v", this.Limit)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LabelValuesResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&storepb.LabelValuesResponse{")
	s = append(s, "Values: "+fmt.Sprintf("%#v", this.Values)+",\n")
	s = append(s, "Warnings: "+fmt.Sprintf("%#v", this.Warnings)+",\n")
	if this.Hints != nil {
		s = append(s, "Hints: "+fmt.Sprintf("%#v", this.Hints)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringRpc(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *SeriesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SeriesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.StreamingChunksBatchSize != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.StreamingChunksBatchSize))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xa0
	}
	if m.Hints != nil {
		{
			size, err := m.Hints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.SkipChunks {
		i--
		if m.SkipChunks {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if len(m.Matchers) > 0 {
		for iNdEx := len(m.Matchers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Matchers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.MaxTime != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.MaxTime))
		i--
		dAtA[i] = 0x10
	}
	if m.MinTime != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.MinTime))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Stats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Stats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Stats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.FetchedIndexBytes != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.FetchedIndexBytes))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SeriesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SeriesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Result != nil {
		{
			size := m.Result.Size()
			i -= size
			if _, err := m.Result.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *SeriesResponse_Series) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesResponse_Series) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Series != nil {
		{
			size, err := m.Series.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *SeriesResponse_Warning) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesResponse_Warning) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Warning)
	copy(dAtA[i:], m.Warning)
	i = encodeVarintRpc(dAtA, i, uint64(len(m.Warning)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func (m *SeriesResponse_Hints) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesResponse_Hints) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Hints != nil {
		{
			size, err := m.Hints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *SeriesResponse_Stats) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesResponse_Stats) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Stats != nil {
		{
			size, err := m.Stats.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	return len(dAtA) - i, nil
}
func (m *SeriesResponse_StreamingSeries) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesResponse_StreamingSeries) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.StreamingSeries != nil {
		{
			size, err := m.StreamingSeries.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *SeriesResponse_StreamingChunks) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesResponse_StreamingChunks) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.StreamingChunks != nil {
		{
			size, err := m.StreamingChunks.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}
func (m *SeriesResponse_StreamingChunksEstimate) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesResponse_StreamingChunksEstimate) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.StreamingChunksEstimate != nil {
		{
			size, err := m.StreamingChunksEstimate.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *LabelNamesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LabelNamesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LabelNamesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Limit != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.Limit))
		i--
		dAtA[i] = 0x38
	}
	if len(m.Matchers) > 0 {
		for iNdEx := len(m.Matchers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Matchers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if m.Hints != nil {
		{
			size, err := m.Hints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.End != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.End))
		i--
		dAtA[i] = 0x20
	}
	if m.Start != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.Start))
		i--
		dAtA[i] = 0x18
	}
	return len(dAtA) - i, nil
}

func (m *LabelNamesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LabelNamesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LabelNamesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Hints != nil {
		{
			size, err := m.Hints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Warnings) > 0 {
		for iNdEx := len(m.Warnings) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Warnings[iNdEx])
			copy(dAtA[i:], m.Warnings[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.Warnings[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Names) > 0 {
		for iNdEx := len(m.Names) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Names[iNdEx])
			copy(dAtA[i:], m.Names[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.Names[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *LabelValuesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LabelValuesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LabelValuesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Limit != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.Limit))
		i--
		dAtA[i] = 0x40
	}
	if len(m.Matchers) > 0 {
		for iNdEx := len(m.Matchers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Matchers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.Hints != nil {
		{
			size, err := m.Hints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.End != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.End))
		i--
		dAtA[i] = 0x28
	}
	if m.Start != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.Start))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Label) > 0 {
		i -= len(m.Label)
		copy(dAtA[i:], m.Label)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Label)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LabelValuesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LabelValuesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LabelValuesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Hints != nil {
		{
			size, err := m.Hints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Warnings) > 0 {
		for iNdEx := len(m.Warnings) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Warnings[iNdEx])
			copy(dAtA[i:], m.Warnings[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.Warnings[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Values) > 0 {
		for iNdEx := len(m.Values) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Values[iNdEx])
			copy(dAtA[i:], m.Values[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.Values[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintRpc(dAtA []byte, offset int, v uint64) int {
	offset -= sovRpc(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *SeriesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MinTime != 0 {
		n += 1 + sovRpc(uint64(m.MinTime))
	}
	if m.MaxTime != 0 {
		n += 1 + sovRpc(uint64(m.MaxTime))
	}
	if len(m.Matchers) > 0 {
		for _, e := range m.Matchers {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if m.SkipChunks {
		n += 2
	}
	if m.Hints != nil {
		l = m.Hints.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.StreamingChunksBatchSize != 0 {
		n += 2 + sovRpc(uint64(m.StreamingChunksBatchSize))
	}
	return n
}

func (m *Stats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.FetchedIndexBytes != 0 {
		n += 1 + sovRpc(uint64(m.FetchedIndexBytes))
	}
	return n
}

func (m *SeriesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result != nil {
		n += m.Result.Size()
	}
	return n
}

func (m *SeriesResponse_Series) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Series != nil {
		l = m.Series.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}
func (m *SeriesResponse_Warning) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Warning)
	n += 1 + l + sovRpc(uint64(l))
	return n
}
func (m *SeriesResponse_Hints) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Hints != nil {
		l = m.Hints.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}
func (m *SeriesResponse_Stats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Stats != nil {
		l = m.Stats.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}
func (m *SeriesResponse_StreamingSeries) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StreamingSeries != nil {
		l = m.StreamingSeries.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}
func (m *SeriesResponse_StreamingChunks) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StreamingChunks != nil {
		l = m.StreamingChunks.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}
func (m *SeriesResponse_StreamingChunksEstimate) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.StreamingChunksEstimate != nil {
		l = m.StreamingChunksEstimate.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}
func (m *LabelNamesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Start != 0 {
		n += 1 + sovRpc(uint64(m.Start))
	}
	if m.End != 0 {
		n += 1 + sovRpc(uint64(m.End))
	}
	if m.Hints != nil {
		l = m.Hints.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	if len(m.Matchers) > 0 {
		for _, e := range m.Matchers {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if m.Limit != 0 {
		n += 1 + sovRpc(uint64(m.Limit))
	}
	return n
}

func (m *LabelNamesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Names) > 0 {
		for _, s := range m.Names {
			l = len(s)
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if len(m.Warnings) > 0 {
		for _, s := range m.Warnings {
			l = len(s)
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if m.Hints != nil {
		l = m.Hints.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}

func (m *LabelValuesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Label)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.Start != 0 {
		n += 1 + sovRpc(uint64(m.Start))
	}
	if m.End != 0 {
		n += 1 + sovRpc(uint64(m.End))
	}
	if m.Hints != nil {
		l = m.Hints.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	if len(m.Matchers) > 0 {
		for _, e := range m.Matchers {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if m.Limit != 0 {
		n += 1 + sovRpc(uint64(m.Limit))
	}
	return n
}

func (m *LabelValuesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			l = len(s)
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if len(m.Warnings) > 0 {
		for _, s := range m.Warnings {
			l = len(s)
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if m.Hints != nil {
		l = m.Hints.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}

func sovRpc(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozRpc(x uint64) (n int) {
	return sovRpc(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *SeriesRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForMatchers := "[]LabelMatcher{"
	for _, f := range this.Matchers {
		repeatedStringForMatchers += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForMatchers += "}"
	s := strings.Join([]string{`&SeriesRequest{`,
		`MinTime:` + fmt.Sprintf("%v", this.MinTime) + `,`,
		`MaxTime:` + fmt.Sprintf("%v", this.MaxTime) + `,`,
		`Matchers:` + repeatedStringForMatchers + `,`,
		`SkipChunks:` + fmt.Sprintf("%v", this.SkipChunks) + `,`,
		`Hints:` + strings.Replace(fmt.Sprintf("%v", this.Hints), "Any", "types.Any", 1) + `,`,
		`StreamingChunksBatchSize:` + fmt.Sprintf("%v", this.StreamingChunksBatchSize) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Stats) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Stats{`,
		`FetchedIndexBytes:` + fmt.Sprintf("%v", this.FetchedIndexBytes) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SeriesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SeriesResponse{`,
		`Result:` + fmt.Sprintf("%v", this.Result) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SeriesResponse_Series) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SeriesResponse_Series{`,
		`Series:` + strings.Replace(fmt.Sprintf("%v", this.Series), "Series", "Series", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SeriesResponse_Warning) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SeriesResponse_Warning{`,
		`Warning:` + fmt.Sprintf("%v", this.Warning) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SeriesResponse_Hints) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SeriesResponse_Hints{`,
		`Hints:` + strings.Replace(fmt.Sprintf("%v", this.Hints), "Any", "types.Any", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SeriesResponse_Stats) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SeriesResponse_Stats{`,
		`Stats:` + strings.Replace(fmt.Sprintf("%v", this.Stats), "Stats", "Stats", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SeriesResponse_StreamingSeries) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SeriesResponse_StreamingSeries{`,
		`StreamingSeries:` + strings.Replace(fmt.Sprintf("%v", this.StreamingSeries), "StreamingSeriesBatch", "StreamingSeriesBatch", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SeriesResponse_StreamingChunks) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SeriesResponse_StreamingChunks{`,
		`StreamingChunks:` + strings.Replace(fmt.Sprintf("%v", this.StreamingChunks), "StreamingChunksBatch", "StreamingChunksBatch", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SeriesResponse_StreamingChunksEstimate) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SeriesResponse_StreamingChunksEstimate{`,
		`StreamingChunksEstimate:` + strings.Replace(fmt.Sprintf("%v", this.StreamingChunksEstimate), "StreamingChunksEstimate", "StreamingChunksEstimate", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LabelNamesRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForMatchers := "[]LabelMatcher{"
	for _, f := range this.Matchers {
		repeatedStringForMatchers += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForMatchers += "}"
	s := strings.Join([]string{`&LabelNamesRequest{`,
		`Start:` + fmt.Sprintf("%v", this.Start) + `,`,
		`End:` + fmt.Sprintf("%v", this.End) + `,`,
		`Hints:` + strings.Replace(fmt.Sprintf("%v", this.Hints), "Any", "types.Any", 1) + `,`,
		`Matchers:` + repeatedStringForMatchers + `,`,
		`Limit:` + fmt.Sprintf("%v", this.Limit) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LabelNamesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LabelNamesResponse{`,
		`Names:` + fmt.Sprintf("%v", this.Names) + `,`,
		`Warnings:` + fmt.Sprintf("%v", this.Warnings) + `,`,
		`Hints:` + strings.Replace(fmt.Sprintf("%v", this.Hints), "Any", "types.Any", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LabelValuesRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForMatchers := "[]LabelMatcher{"
	for _, f := range this.Matchers {
		repeatedStringForMatchers += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForMatchers += "}"
	s := strings.Join([]string{`&LabelValuesRequest{`,
		`Label:` + fmt.Sprintf("%v", this.Label) + `,`,
		`Start:` + fmt.Sprintf("%v", this.Start) + `,`,
		`End:` + fmt.Sprintf("%v", this.End) + `,`,
		`Hints:` + strings.Replace(fmt.Sprintf("%v", this.Hints), "Any", "types.Any", 1) + `,`,
		`Matchers:` + repeatedStringForMatchers + `,`,
		`Limit:` + fmt.Sprintf("%v", this.Limit) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LabelValuesResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LabelValuesResponse{`,
		`Values:` + fmt.Sprintf("%v", this.Values) + `,`,
		`Warnings:` + fmt.Sprintf("%v", this.Warnings) + `,`,
		`Hints:` + strings.Replace(fmt.Sprintf("%v", this.Hints), "Any", "types.Any", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringRpc(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *SeriesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SeriesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SeriesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinTime", wireType)
			}
			m.MinTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinTime |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTime", wireType)
			}
			m.MaxTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTime |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Matchers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Matchers = append(m.Matchers, LabelMatcher{})
			if err := m.Matchers[len(m.Matchers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SkipChunks", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SkipChunks = bool(v != 0)
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Hints == nil {
				m.Hints = &types.Any{}
			}
			if err := m.Hints.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 100:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StreamingChunksBatchSize", wireType)
			}
			m.StreamingChunksBatchSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StreamingChunksBatchSize |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Stats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Stats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Stats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FetchedIndexBytes", wireType)
			}
			m.FetchedIndexBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FetchedIndexBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SeriesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SeriesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SeriesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Series", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Series{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &SeriesResponse_Series{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warning", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Result = &SeriesResponse_Warning{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Any{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &SeriesResponse_Hints{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Stats{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &SeriesResponse_Stats{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StreamingSeries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &StreamingSeriesBatch{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &SeriesResponse_StreamingSeries{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StreamingChunks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &StreamingChunksBatch{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &SeriesResponse_StreamingChunks{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StreamingChunksEstimate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &StreamingChunksEstimate{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &SeriesResponse_StreamingChunksEstimate{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LabelNamesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LabelNamesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LabelNamesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			m.Start = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Start |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			m.End = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.End |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Hints == nil {
				m.Hints = &types.Any{}
			}
			if err := m.Hints.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Matchers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Matchers = append(m.Matchers, LabelMatcher{})
			if err := m.Matchers[len(m.Matchers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LabelNamesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LabelNamesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LabelNamesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Names", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Names = append(m.Names, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Warnings = append(m.Warnings, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Hints == nil {
				m.Hints = &types.Any{}
			}
			if err := m.Hints.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LabelValuesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LabelValuesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LabelValuesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Label", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Label = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			m.Start = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Start |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			m.End = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.End |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Hints == nil {
				m.Hints = &types.Any{}
			}
			if err := m.Hints.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Matchers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Matchers = append(m.Matchers, LabelMatcher{})
			if err := m.Matchers[len(m.Matchers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LabelValuesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LabelValuesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LabelValuesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Warnings = append(m.Warnings, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Hints == nil {
				m.Hints = &types.Any{}
			}
			if err := m.Hints.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRpc(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRpc
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupRpc
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthRpc
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthRpc        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRpc          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupRpc = fmt.Errorf("proto: unexpected end of group")
)
