// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: frontend.proto

package frontendv2pb

import (
	bytes "bytes"
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	httpgrpc "github.com/grafana/dskit/httpgrpc"
	_ "github.com/grafana/mimir/pkg/querier/stats"
	github_com_grafana_mimir_pkg_querier_stats "github.com/grafana/mimir/pkg/querier/stats"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type QueryResultRequest struct {
	QueryID      uint64                                                `protobuf:"varint,1,opt,name=queryID,proto3" json:"queryID,omitempty"`
	HttpResponse *httpgrpc.HTTPResponse                                `protobuf:"bytes,2,opt,name=httpResponse,proto3" json:"httpResponse,omitempty"`
	Stats        *github_com_grafana_mimir_pkg_querier_stats.SafeStats `protobuf:"bytes,3,opt,name=stats,proto3,customtype=github.com/grafana/mimir/pkg/querier/stats.SafeStats" json:"stats,omitempty"`
}

func (m *QueryResultRequest) Reset()      { *m = QueryResultRequest{} }
func (*QueryResultRequest) ProtoMessage() {}
func (*QueryResultRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_eca3873955a29cfe, []int{0}
}
func (m *QueryResultRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryResultRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryResultRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryResultRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResultRequest.Merge(m, src)
}
func (m *QueryResultRequest) XXX_Size() int {
	return m.Size()
}
func (m *QueryResultRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResultRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResultRequest proto.InternalMessageInfo

func (m *QueryResultRequest) GetQueryID() uint64 {
	if m != nil {
		return m.QueryID
	}
	return 0
}

func (m *QueryResultRequest) GetHttpResponse() *httpgrpc.HTTPResponse {
	if m != nil {
		return m.HttpResponse
	}
	return nil
}

type QueryResultStreamRequest struct {
	QueryID uint64 `protobuf:"varint,1,opt,name=queryID,proto3" json:"queryID,omitempty"`
	// Types that are valid to be assigned to Data:
	//	*QueryResultStreamRequest_Metadata
	//	*QueryResultStreamRequest_Body
	Data isQueryResultStreamRequest_Data `protobuf_oneof:"data"`
}

func (m *QueryResultStreamRequest) Reset()      { *m = QueryResultStreamRequest{} }
func (*QueryResultStreamRequest) ProtoMessage() {}
func (*QueryResultStreamRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_eca3873955a29cfe, []int{1}
}
func (m *QueryResultStreamRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryResultStreamRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryResultStreamRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryResultStreamRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResultStreamRequest.Merge(m, src)
}
func (m *QueryResultStreamRequest) XXX_Size() int {
	return m.Size()
}
func (m *QueryResultStreamRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResultStreamRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResultStreamRequest proto.InternalMessageInfo

type isQueryResultStreamRequest_Data interface {
	isQueryResultStreamRequest_Data()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type QueryResultStreamRequest_Metadata struct {
	Metadata *QueryResultMetadata `protobuf:"bytes,2,opt,name=metadata,proto3,oneof" json:"metadata,omitempty"`
}
type QueryResultStreamRequest_Body struct {
	Body *QueryResultBody `protobuf:"bytes,3,opt,name=body,proto3,oneof" json:"body,omitempty"`
}

func (*QueryResultStreamRequest_Metadata) isQueryResultStreamRequest_Data() {}
func (*QueryResultStreamRequest_Body) isQueryResultStreamRequest_Data()     {}

func (m *QueryResultStreamRequest) GetData() isQueryResultStreamRequest_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *QueryResultStreamRequest) GetQueryID() uint64 {
	if m != nil {
		return m.QueryID
	}
	return 0
}

func (m *QueryResultStreamRequest) GetMetadata() *QueryResultMetadata {
	if x, ok := m.GetData().(*QueryResultStreamRequest_Metadata); ok {
		return x.Metadata
	}
	return nil
}

func (m *QueryResultStreamRequest) GetBody() *QueryResultBody {
	if x, ok := m.GetData().(*QueryResultStreamRequest_Body); ok {
		return x.Body
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*QueryResultStreamRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*QueryResultStreamRequest_Metadata)(nil),
		(*QueryResultStreamRequest_Body)(nil),
	}
}

type QueryResultMetadata struct {
	Code    int32                                                 `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	Headers []*httpgrpc.Header                                    `protobuf:"bytes,2,rep,name=headers,proto3" json:"headers,omitempty"`
	Stats   *github_com_grafana_mimir_pkg_querier_stats.SafeStats `protobuf:"bytes,3,opt,name=stats,proto3,customtype=github.com/grafana/mimir/pkg/querier/stats.SafeStats" json:"stats,omitempty"`
}

func (m *QueryResultMetadata) Reset()      { *m = QueryResultMetadata{} }
func (*QueryResultMetadata) ProtoMessage() {}
func (*QueryResultMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_eca3873955a29cfe, []int{2}
}
func (m *QueryResultMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryResultMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryResultMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryResultMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResultMetadata.Merge(m, src)
}
func (m *QueryResultMetadata) XXX_Size() int {
	return m.Size()
}
func (m *QueryResultMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResultMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResultMetadata proto.InternalMessageInfo

func (m *QueryResultMetadata) GetCode() int32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *QueryResultMetadata) GetHeaders() []*httpgrpc.Header {
	if m != nil {
		return m.Headers
	}
	return nil
}

type QueryResultBody struct {
	Chunk []byte `protobuf:"bytes,1,opt,name=chunk,proto3" json:"chunk,omitempty"`
}

func (m *QueryResultBody) Reset()      { *m = QueryResultBody{} }
func (*QueryResultBody) ProtoMessage() {}
func (*QueryResultBody) Descriptor() ([]byte, []int) {
	return fileDescriptor_eca3873955a29cfe, []int{3}
}
func (m *QueryResultBody) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryResultBody) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryResultBody.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryResultBody) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResultBody.Merge(m, src)
}
func (m *QueryResultBody) XXX_Size() int {
	return m.Size()
}
func (m *QueryResultBody) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResultBody.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResultBody proto.InternalMessageInfo

func (m *QueryResultBody) GetChunk() []byte {
	if m != nil {
		return m.Chunk
	}
	return nil
}

type QueryResultResponse struct {
}

func (m *QueryResultResponse) Reset()      { *m = QueryResultResponse{} }
func (*QueryResultResponse) ProtoMessage() {}
func (*QueryResultResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_eca3873955a29cfe, []int{4}
}
func (m *QueryResultResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryResultResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryResultResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryResultResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResultResponse.Merge(m, src)
}
func (m *QueryResultResponse) XXX_Size() int {
	return m.Size()
}
func (m *QueryResultResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResultResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResultResponse proto.InternalMessageInfo

func init() {
	proto.RegisterType((*QueryResultRequest)(nil), "frontendv2pb.QueryResultRequest")
	proto.RegisterType((*QueryResultStreamRequest)(nil), "frontendv2pb.QueryResultStreamRequest")
	proto.RegisterType((*QueryResultMetadata)(nil), "frontendv2pb.QueryResultMetadata")
	proto.RegisterType((*QueryResultBody)(nil), "frontendv2pb.QueryResultBody")
	proto.RegisterType((*QueryResultResponse)(nil), "frontendv2pb.QueryResultResponse")
}

func init() { proto.RegisterFile("frontend.proto", fileDescriptor_eca3873955a29cfe) }

var fileDescriptor_eca3873955a29cfe = []byte{
	// 501 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x54, 0xb1, 0x8e, 0xd3, 0x4c,
	0x10, 0xde, 0xbd, 0x4b, 0xee, 0x7e, 0x6d, 0xa2, 0x1f, 0x58, 0x0e, 0x64, 0x45, 0x62, 0xc9, 0xb9,
	0x80, 0x88, 0xc2, 0x46, 0x39, 0x84, 0x10, 0x0d, 0x92, 0x85, 0x4e, 0xa1, 0x40, 0xe2, 0x36, 0xa9,
	0x10, 0xcd, 0x3a, 0xde, 0x38, 0x56, 0xb0, 0xd7, 0xb7, 0x5e, 0x23, 0xa5, 0xe3, 0x11, 0x78, 0x0c,
	0x6a, 0x78, 0x89, 0xab, 0x50, 0xca, 0x13, 0x05, 0x22, 0x4e, 0x43, 0x79, 0x8f, 0x80, 0xbc, 0xb6,
	0x23, 0x07, 0x2e, 0x70, 0x0d, 0xcd, 0x6a, 0x46, 0xf3, 0x7d, 0xfb, 0xcd, 0x37, 0x3b, 0x36, 0xfa,
	0x7f, 0x22, 0x45, 0xa4, 0x78, 0xe4, 0x59, 0xb1, 0x14, 0x4a, 0xe0, 0x76, 0x95, 0xbf, 0xeb, 0xc7,
	0x6e, 0xe7, 0xc0, 0x17, 0xbe, 0xd0, 0x05, 0x3b, 0x8f, 0x0a, 0x4c, 0xe7, 0xa1, 0x1f, 0xa8, 0x69,
	0xea, 0x5a, 0x63, 0x11, 0xda, 0xbe, 0x64, 0x13, 0x16, 0x31, 0xdb, 0x4b, 0x66, 0x81, 0xb2, 0xa7,
	0x4a, 0xc5, 0xbe, 0x8c, 0xc7, 0xeb, 0xa0, 0x64, 0x3c, 0xbe, 0x84, 0x11, 0x06, 0x61, 0x20, 0xed,
	0x78, 0xe6, 0xdb, 0xa7, 0x29, 0x97, 0x01, 0x97, 0x76, 0xa2, 0x98, 0x4a, 0x8a, 0xb3, 0xe0, 0x99,
	0x67, 0x10, 0xe1, 0x93, 0x94, 0xcb, 0x39, 0xe5, 0x49, 0xfa, 0x56, 0x51, 0x7e, 0x9a, 0xf2, 0x44,
	0x61, 0x03, 0xed, 0xe7, 0x9c, 0xf9, 0x8b, 0xe7, 0x06, 0xec, 0xc2, 0x5e, 0x83, 0x56, 0x29, 0x7e,
	0x8a, 0xda, 0xb9, 0x34, 0xe5, 0x49, 0x2c, 0xa2, 0x84, 0x1b, 0x3b, 0x5d, 0xd8, 0x6b, 0xf5, 0x6f,
	0x5b, 0xeb, 0x7e, 0x06, 0xa3, 0xd1, 0xab, 0xaa, 0x4a, 0x37, 0xb0, 0xf8, 0x0d, 0x6a, 0x6a, 0x6d,
	0x63, 0x57, 0x93, 0xda, 0x56, 0xd1, 0xc9, 0x30, 0x3f, 0x9d, 0x27, 0x5f, 0xbf, 0xdd, 0x7d, 0x74,
	0x75, 0x17, 0xd6, 0x90, 0x4d, 0xb8, 0x66, 0xd2, 0xe2, 0x52, 0xf3, 0x13, 0x44, 0x46, 0xcd, 0xca,
	0x50, 0x49, 0xce, 0xc2, 0xbf, 0x1b, 0x7a, 0x86, 0xfe, 0x0b, 0xb9, 0x62, 0x1e, 0x53, 0xac, 0x34,
	0x73, 0x68, 0xd5, 0x9f, 0xc8, 0xaa, 0xdd, 0xf9, 0xb2, 0x04, 0x0e, 0x00, 0x5d, 0x93, 0xf0, 0x11,
	0x6a, 0xb8, 0xc2, 0x9b, 0x97, 0xa6, 0xee, 0x6c, 0x25, 0x3b, 0xc2, 0x9b, 0x0f, 0x00, 0xd5, 0x60,
	0x67, 0x0f, 0x35, 0x72, 0xb2, 0xf9, 0x19, 0xa2, 0x9b, 0x97, 0x08, 0x60, 0x8c, 0x1a, 0x63, 0xe1,
	0x71, 0xdd, 0x6c, 0x93, 0xea, 0x18, 0x3f, 0x40, 0xfb, 0x53, 0xce, 0x3c, 0x2e, 0x13, 0x63, 0xa7,
	0xbb, 0xdb, 0x6b, 0xf5, 0xaf, 0xd7, 0xa6, 0xae, 0x0b, 0xb4, 0x02, 0xfc, 0xe3, 0x51, 0xdf, 0x47,
	0xd7, 0x7e, 0x31, 0x86, 0x0f, 0x50, 0x73, 0x3c, 0x4d, 0xa3, 0x99, 0xee, 0xb8, 0x4d, 0x8b, 0xc4,
	0xbc, 0xb5, 0xe1, 0xae, 0x5a, 0x84, 0xfe, 0x17, 0x88, 0xf0, 0x71, 0x39, 0xa6, 0x63, 0x21, 0x4f,
	0x0a, 0x35, 0x3c, 0x42, 0xad, 0x1a, 0x1a, 0x77, 0xb7, 0x8e, 0xb2, 0x7c, 0xd5, 0xce, 0xe1, 0x1f,
	0x10, 0x85, 0x94, 0x09, 0xb0, 0x8b, 0x6e, 0xfc, 0xb6, 0x16, 0xf8, 0xde, 0x56, 0xe6, 0xc6, 0xde,
	0x5c, 0x49, 0xa1, 0x07, 0x1d, 0x67, 0xb1, 0x24, 0xe0, 0x7c, 0x49, 0xc0, 0xc5, 0x92, 0xc0, 0xf7,
	0x19, 0x81, 0x1f, 0x33, 0x02, 0xcf, 0x32, 0x02, 0x17, 0x19, 0x81, 0xdf, 0x33, 0x02, 0x7f, 0x64,
	0x04, 0x5c, 0x64, 0x04, 0x7e, 0x58, 0x11, 0xb0, 0x58, 0x11, 0x70, 0xbe, 0x22, 0xe0, 0xf5, 0xc6,
	0xaf, 0xc0, 0xdd, 0xd3, 0x5f, 0xe4, 0xd1, 0xcf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x47, 0x86, 0x6e,
	0x83, 0x31, 0x04, 0x00, 0x00,
}

func (this *QueryResultRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryResultRequest)
	if !ok {
		that2, ok := that.(QueryResultRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.QueryID != that1.QueryID {
		return false
	}
	if !this.HttpResponse.Equal(that1.HttpResponse) {
		return false
	}
	if that1.Stats == nil {
		if this.Stats != nil {
			return false
		}
	} else if !this.Stats.Equal(*that1.Stats) {
		return false
	}
	return true
}
func (this *QueryResultStreamRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryResultStreamRequest)
	if !ok {
		that2, ok := that.(QueryResultStreamRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.QueryID != that1.QueryID {
		return false
	}
	if that1.Data == nil {
		if this.Data != nil {
			return false
		}
	} else if this.Data == nil {
		return false
	} else if !this.Data.Equal(that1.Data) {
		return false
	}
	return true
}
func (this *QueryResultStreamRequest_Metadata) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryResultStreamRequest_Metadata)
	if !ok {
		that2, ok := that.(QueryResultStreamRequest_Metadata)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	return true
}
func (this *QueryResultStreamRequest_Body) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryResultStreamRequest_Body)
	if !ok {
		that2, ok := that.(QueryResultStreamRequest_Body)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Body.Equal(that1.Body) {
		return false
	}
	return true
}
func (this *QueryResultMetadata) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryResultMetadata)
	if !ok {
		that2, ok := that.(QueryResultMetadata)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Code != that1.Code {
		return false
	}
	if len(this.Headers) != len(that1.Headers) {
		return false
	}
	for i := range this.Headers {
		if !this.Headers[i].Equal(that1.Headers[i]) {
			return false
		}
	}
	if that1.Stats == nil {
		if this.Stats != nil {
			return false
		}
	} else if !this.Stats.Equal(*that1.Stats) {
		return false
	}
	return true
}
func (this *QueryResultBody) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryResultBody)
	if !ok {
		that2, ok := that.(QueryResultBody)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Chunk, that1.Chunk) {
		return false
	}
	return true
}
func (this *QueryResultResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryResultResponse)
	if !ok {
		that2, ok := that.(QueryResultResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *QueryResultRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&frontendv2pb.QueryResultRequest{")
	s = append(s, "QueryID: "+fmt.Sprintf("%#v", this.QueryID)+",\n")
	if this.HttpResponse != nil {
		s = append(s, "HttpResponse: "+fmt.Sprintf("%#v", this.HttpResponse)+",\n")
	}
	s = append(s, "Stats: "+fmt.Sprintf("%#v", this.Stats)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QueryResultStreamRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&frontendv2pb.QueryResultStreamRequest{")
	s = append(s, "QueryID: "+fmt.Sprintf("%#v", this.QueryID)+",\n")
	if this.Data != nil {
		s = append(s, "Data: "+fmt.Sprintf("%#v", this.Data)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QueryResultStreamRequest_Metadata) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&frontendv2pb.QueryResultStreamRequest_Metadata{` +
		`Metadata:` + fmt.Sprintf("%#v", this.Metadata) + `}`}, ", ")
	return s
}
func (this *QueryResultStreamRequest_Body) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&frontendv2pb.QueryResultStreamRequest_Body{` +
		`Body:` + fmt.Sprintf("%#v", this.Body) + `}`}, ", ")
	return s
}
func (this *QueryResultMetadata) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&frontendv2pb.QueryResultMetadata{")
	s = append(s, "Code: "+fmt.Sprintf("%#v", this.Code)+",\n")
	if this.Headers != nil {
		s = append(s, "Headers: "+fmt.Sprintf("%#v", this.Headers)+",\n")
	}
	s = append(s, "Stats: "+fmt.Sprintf("%#v", this.Stats)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QueryResultBody) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&frontendv2pb.QueryResultBody{")
	s = append(s, "Chunk: "+fmt.Sprintf("%#v", this.Chunk)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QueryResultResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&frontendv2pb.QueryResultResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringFrontend(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// FrontendForQuerierClient is the client API for FrontendForQuerier service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FrontendForQuerierClient interface {
	QueryResult(ctx context.Context, in *QueryResultRequest, opts ...grpc.CallOption) (*QueryResultResponse, error)
	QueryResultStream(ctx context.Context, opts ...grpc.CallOption) (FrontendForQuerier_QueryResultStreamClient, error)
}

type frontendForQuerierClient struct {
	cc *grpc.ClientConn
}

func NewFrontendForQuerierClient(cc *grpc.ClientConn) FrontendForQuerierClient {
	return &frontendForQuerierClient{cc}
}

func (c *frontendForQuerierClient) QueryResult(ctx context.Context, in *QueryResultRequest, opts ...grpc.CallOption) (*QueryResultResponse, error) {
	out := new(QueryResultResponse)
	err := c.cc.Invoke(ctx, "/frontendv2pb.FrontendForQuerier/QueryResult", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *frontendForQuerierClient) QueryResultStream(ctx context.Context, opts ...grpc.CallOption) (FrontendForQuerier_QueryResultStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_FrontendForQuerier_serviceDesc.Streams[0], "/frontendv2pb.FrontendForQuerier/QueryResultStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &frontendForQuerierQueryResultStreamClient{stream}
	return x, nil
}

type FrontendForQuerier_QueryResultStreamClient interface {
	Send(*QueryResultStreamRequest) error
	CloseAndRecv() (*QueryResultResponse, error)
	grpc.ClientStream
}

type frontendForQuerierQueryResultStreamClient struct {
	grpc.ClientStream
}

func (x *frontendForQuerierQueryResultStreamClient) Send(m *QueryResultStreamRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *frontendForQuerierQueryResultStreamClient) CloseAndRecv() (*QueryResultResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(QueryResultResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// FrontendForQuerierServer is the server API for FrontendForQuerier service.
type FrontendForQuerierServer interface {
	QueryResult(context.Context, *QueryResultRequest) (*QueryResultResponse, error)
	QueryResultStream(FrontendForQuerier_QueryResultStreamServer) error
}

// UnimplementedFrontendForQuerierServer can be embedded to have forward compatible implementations.
type UnimplementedFrontendForQuerierServer struct {
}

func (*UnimplementedFrontendForQuerierServer) QueryResult(ctx context.Context, req *QueryResultRequest) (*QueryResultResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryResult not implemented")
}
func (*UnimplementedFrontendForQuerierServer) QueryResultStream(srv FrontendForQuerier_QueryResultStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method QueryResultStream not implemented")
}

func RegisterFrontendForQuerierServer(s *grpc.Server, srv FrontendForQuerierServer) {
	s.RegisterService(&_FrontendForQuerier_serviceDesc, srv)
}

func _FrontendForQuerier_QueryResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FrontendForQuerierServer).QueryResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/frontendv2pb.FrontendForQuerier/QueryResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FrontendForQuerierServer).QueryResult(ctx, req.(*QueryResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FrontendForQuerier_QueryResultStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(FrontendForQuerierServer).QueryResultStream(&frontendForQuerierQueryResultStreamServer{stream})
}

type FrontendForQuerier_QueryResultStreamServer interface {
	SendAndClose(*QueryResultResponse) error
	Recv() (*QueryResultStreamRequest, error)
	grpc.ServerStream
}

type frontendForQuerierQueryResultStreamServer struct {
	grpc.ServerStream
}

func (x *frontendForQuerierQueryResultStreamServer) SendAndClose(m *QueryResultResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *frontendForQuerierQueryResultStreamServer) Recv() (*QueryResultStreamRequest, error) {
	m := new(QueryResultStreamRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _FrontendForQuerier_serviceDesc = grpc.ServiceDesc{
	ServiceName: "frontendv2pb.FrontendForQuerier",
	HandlerType: (*FrontendForQuerierServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "QueryResult",
			Handler:    _FrontendForQuerier_QueryResult_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "QueryResultStream",
			Handler:       _FrontendForQuerier_QueryResultStream_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "frontend.proto",
}

func (m *QueryResultRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryResultRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResultRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Stats != nil {
		{
			size := m.Stats.Size()
			i -= size
			if _, err := m.Stats.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintFrontend(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if m.HttpResponse != nil {
		{
			size, err := m.HttpResponse.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintFrontend(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.QueryID != 0 {
		i = encodeVarintFrontend(dAtA, i, uint64(m.QueryID))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *QueryResultStreamRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryResultStreamRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResultStreamRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Data != nil {
		{
			size := m.Data.Size()
			i -= size
			if _, err := m.Data.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.QueryID != 0 {
		i = encodeVarintFrontend(dAtA, i, uint64(m.QueryID))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *QueryResultStreamRequest_Metadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResultStreamRequest_Metadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Metadata != nil {
		{
			size, err := m.Metadata.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintFrontend(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *QueryResultStreamRequest_Body) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResultStreamRequest_Body) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Body != nil {
		{
			size, err := m.Body.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintFrontend(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *QueryResultMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryResultMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResultMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Stats != nil {
		{
			size := m.Stats.Size()
			i -= size
			if _, err := m.Stats.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
			i = encodeVarintFrontend(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Headers) > 0 {
		for iNdEx := len(m.Headers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Headers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintFrontend(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Code != 0 {
		i = encodeVarintFrontend(dAtA, i, uint64(m.Code))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *QueryResultBody) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryResultBody) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResultBody) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Chunk) > 0 {
		i -= len(m.Chunk)
		copy(dAtA[i:], m.Chunk)
		i = encodeVarintFrontend(dAtA, i, uint64(len(m.Chunk)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *QueryResultResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryResultResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryResultResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func encodeVarintFrontend(dAtA []byte, offset int, v uint64) int {
	offset -= sovFrontend(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *QueryResultRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.QueryID != 0 {
		n += 1 + sovFrontend(uint64(m.QueryID))
	}
	if m.HttpResponse != nil {
		l = m.HttpResponse.Size()
		n += 1 + l + sovFrontend(uint64(l))
	}
	if m.Stats != nil {
		l = m.Stats.Size()
		n += 1 + l + sovFrontend(uint64(l))
	}
	return n
}

func (m *QueryResultStreamRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.QueryID != 0 {
		n += 1 + sovFrontend(uint64(m.QueryID))
	}
	if m.Data != nil {
		n += m.Data.Size()
	}
	return n
}

func (m *QueryResultStreamRequest_Metadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovFrontend(uint64(l))
	}
	return n
}
func (m *QueryResultStreamRequest_Body) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Body != nil {
		l = m.Body.Size()
		n += 1 + l + sovFrontend(uint64(l))
	}
	return n
}
func (m *QueryResultMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Code != 0 {
		n += 1 + sovFrontend(uint64(m.Code))
	}
	if len(m.Headers) > 0 {
		for _, e := range m.Headers {
			l = e.Size()
			n += 1 + l + sovFrontend(uint64(l))
		}
	}
	if m.Stats != nil {
		l = m.Stats.Size()
		n += 1 + l + sovFrontend(uint64(l))
	}
	return n
}

func (m *QueryResultBody) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Chunk)
	if l > 0 {
		n += 1 + l + sovFrontend(uint64(l))
	}
	return n
}

func (m *QueryResultResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func sovFrontend(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozFrontend(x uint64) (n int) {
	return sovFrontend(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *QueryResultRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryResultRequest{`,
		`QueryID:` + fmt.Sprintf("%v", this.QueryID) + `,`,
		`HttpResponse:` + strings.Replace(fmt.Sprintf("%v", this.HttpResponse), "HTTPResponse", "httpgrpc.HTTPResponse", 1) + `,`,
		`Stats:` + fmt.Sprintf("%v", this.Stats) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryResultStreamRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryResultStreamRequest{`,
		`QueryID:` + fmt.Sprintf("%v", this.QueryID) + `,`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryResultStreamRequest_Metadata) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryResultStreamRequest_Metadata{`,
		`Metadata:` + strings.Replace(fmt.Sprintf("%v", this.Metadata), "QueryResultMetadata", "QueryResultMetadata", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryResultStreamRequest_Body) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryResultStreamRequest_Body{`,
		`Body:` + strings.Replace(fmt.Sprintf("%v", this.Body), "QueryResultBody", "QueryResultBody", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryResultMetadata) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForHeaders := "[]*Header{"
	for _, f := range this.Headers {
		repeatedStringForHeaders += strings.Replace(fmt.Sprintf("%v", f), "Header", "httpgrpc.Header", 1) + ","
	}
	repeatedStringForHeaders += "}"
	s := strings.Join([]string{`&QueryResultMetadata{`,
		`Code:` + fmt.Sprintf("%v", this.Code) + `,`,
		`Headers:` + repeatedStringForHeaders + `,`,
		`Stats:` + fmt.Sprintf("%v", this.Stats) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryResultBody) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryResultBody{`,
		`Chunk:` + fmt.Sprintf("%v", this.Chunk) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryResultResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryResultResponse{`,
		`}`,
	}, "")
	return s
}
func valueToStringFrontend(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *QueryResultRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFrontend
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryResultRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryResultRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryID", wireType)
			}
			m.QueryID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.QueryID |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HttpResponse == nil {
				m.HttpResponse = &httpgrpc.HTTPResponse{}
			}
			if err := m.HttpResponse.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Stats == nil {
				m.Stats = &github_com_grafana_mimir_pkg_querier_stats.SafeStats{}
			}
			if err := m.Stats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipFrontend(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthFrontend
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryResultStreamRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFrontend
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryResultStreamRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryResultStreamRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryID", wireType)
			}
			m.QueryID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.QueryID |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &QueryResultMetadata{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &QueryResultStreamRequest_Metadata{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Body", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &QueryResultBody{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Data = &QueryResultStreamRequest_Body{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipFrontend(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthFrontend
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryResultMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFrontend
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryResultMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryResultMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Headers = append(m.Headers, &httpgrpc.Header{})
			if err := m.Headers[len(m.Headers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Stats == nil {
				m.Stats = &github_com_grafana_mimir_pkg_querier_stats.SafeStats{}
			}
			if err := m.Stats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipFrontend(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthFrontend
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryResultBody) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFrontend
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryResultBody: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryResultBody: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Chunk", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthFrontend
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthFrontend
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Chunk = append(m.Chunk[:0], dAtA[iNdEx:postIndex]...)
			if m.Chunk == nil {
				m.Chunk = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipFrontend(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthFrontend
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryResultResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowFrontend
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryResultResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryResultResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipFrontend(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthFrontend
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipFrontend(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowFrontend
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowFrontend
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthFrontend
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupFrontend
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthFrontend
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthFrontend        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowFrontend          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupFrontend = fmt.Errorf("proto: unexpected end of group")
)
