// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: model.proto

// Uses queryrange package to offer backwards compatibility with cached extents.

package querymiddleware

import (
	bytes "bytes"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	github_com_grafana_mimir_pkg_mimirpb "github.com/grafana/mimir/pkg/mimirpb"
	mimirpb "github.com/grafana/mimir/pkg/mimirpb"
	stats "github.com/grafana/mimir/pkg/querier/stats"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type PrometheusHeader struct {
	Name   string   `protobuf:"bytes,1,opt,name=Name,proto3" json:"-"`
	Values []string `protobuf:"bytes,2,rep,name=Values,proto3" json:"-"`
}

func (m *PrometheusHeader) Reset()      { *m = PrometheusHeader{} }
func (*PrometheusHeader) ProtoMessage() {}
func (*PrometheusHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{0}
}
func (m *PrometheusHeader) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrometheusHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrometheusHeader.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrometheusHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrometheusHeader.Merge(m, src)
}
func (m *PrometheusHeader) XXX_Size() int {
	return m.Size()
}
func (m *PrometheusHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_PrometheusHeader.DiscardUnknown(m)
}

var xxx_messageInfo_PrometheusHeader proto.InternalMessageInfo

func (m *PrometheusHeader) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PrometheusHeader) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

type PrometheusResponse struct {
	// Keep reference to buffer for unsafe references.
	github_com_grafana_mimir_pkg_mimirpb.BufferHolder

	Status    string              `protobuf:"bytes,1,opt,name=Status,proto3" json:"status"`
	Data      *PrometheusData     `protobuf:"bytes,2,opt,name=Data,proto3" json:"data,omitempty"`
	ErrorType string              `protobuf:"bytes,3,opt,name=ErrorType,proto3" json:"errorType,omitempty"`
	Error     string              `protobuf:"bytes,4,opt,name=Error,proto3" json:"error,omitempty"`
	Headers   []*PrometheusHeader `protobuf:"bytes,5,rep,name=Headers,proto3" json:"-"`
	Warnings  []string            `protobuf:"bytes,6,rep,name=Warnings,proto3" json:"warnings,omitempty"`
	Infos     []string            `protobuf:"bytes,7,rep,name=Infos,proto3" json:"infos,omitempty"`
}

func (m *PrometheusResponse) Reset()      { *m = PrometheusResponse{} }
func (*PrometheusResponse) ProtoMessage() {}
func (*PrometheusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{1}
}
func (m *PrometheusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrometheusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrometheusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrometheusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrometheusResponse.Merge(m, src)
}
func (m *PrometheusResponse) XXX_Size() int {
	return m.Size()
}
func (m *PrometheusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PrometheusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PrometheusResponse proto.InternalMessageInfo

func (m *PrometheusResponse) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *PrometheusResponse) GetData() *PrometheusData {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *PrometheusResponse) GetErrorType() string {
	if m != nil {
		return m.ErrorType
	}
	return ""
}

func (m *PrometheusResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *PrometheusResponse) GetHeaders() []*PrometheusHeader {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *PrometheusResponse) GetWarnings() []string {
	if m != nil {
		return m.Warnings
	}
	return nil
}

func (m *PrometheusResponse) GetInfos() []string {
	if m != nil {
		return m.Infos
	}
	return nil
}

type PrometheusData struct {
	ResultType string         `protobuf:"bytes,1,opt,name=ResultType,proto3" json:"resultType"`
	Result     []SampleStream `protobuf:"bytes,2,rep,name=Result,proto3" json:"result"`
}

func (m *PrometheusData) Reset()      { *m = PrometheusData{} }
func (*PrometheusData) ProtoMessage() {}
func (*PrometheusData) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{2}
}
func (m *PrometheusData) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrometheusData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrometheusData.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrometheusData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrometheusData.Merge(m, src)
}
func (m *PrometheusData) XXX_Size() int {
	return m.Size()
}
func (m *PrometheusData) XXX_DiscardUnknown() {
	xxx_messageInfo_PrometheusData.DiscardUnknown(m)
}

var xxx_messageInfo_PrometheusData proto.InternalMessageInfo

func (m *PrometheusData) GetResultType() string {
	if m != nil {
		return m.ResultType
	}
	return ""
}

func (m *PrometheusData) GetResult() []SampleStream {
	if m != nil {
		return m.Result
	}
	return nil
}

type SampleStream struct {
	Labels     []github_com_grafana_mimir_pkg_mimirpb.LabelAdapter `protobuf:"bytes,1,rep,name=labels,proto3,customtype=github.com/grafana/mimir/pkg/mimirpb.LabelAdapter" json:"metric"`
	Samples    []mimirpb.Sample                                    `protobuf:"bytes,2,rep,name=samples,proto3" json:"values"`
	Histograms []mimirpb.FloatHistogramPair                        `protobuf:"bytes,3,rep,name=histograms,proto3" json:"histograms"`
}

func (m *SampleStream) Reset()      { *m = SampleStream{} }
func (*SampleStream) ProtoMessage() {}
func (*SampleStream) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{3}
}
func (m *SampleStream) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SampleStream) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SampleStream.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SampleStream) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SampleStream.Merge(m, src)
}
func (m *SampleStream) XXX_Size() int {
	return m.Size()
}
func (m *SampleStream) XXX_DiscardUnknown() {
	xxx_messageInfo_SampleStream.DiscardUnknown(m)
}

var xxx_messageInfo_SampleStream proto.InternalMessageInfo

func (m *SampleStream) GetSamples() []mimirpb.Sample {
	if m != nil {
		return m.Samples
	}
	return nil
}

func (m *SampleStream) GetHistograms() []mimirpb.FloatHistogramPair {
	if m != nil {
		return m.Histograms
	}
	return nil
}

type CachedError struct {
	Key          string `protobuf:"bytes,1,opt,name=key,proto3" json:"key"`
	ErrorType    string `protobuf:"bytes,2,opt,name=errorType,proto3" json:"errorType"`
	ErrorMessage string `protobuf:"bytes,3,opt,name=errorMessage,proto3" json:"errorMessage"`
}

func (m *CachedError) Reset()      { *m = CachedError{} }
func (*CachedError) ProtoMessage() {}
func (*CachedError) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{4}
}
func (m *CachedError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CachedError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CachedError.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CachedError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CachedError.Merge(m, src)
}
func (m *CachedError) XXX_Size() int {
	return m.Size()
}
func (m *CachedError) XXX_DiscardUnknown() {
	xxx_messageInfo_CachedError.DiscardUnknown(m)
}

var xxx_messageInfo_CachedError proto.InternalMessageInfo

func (m *CachedError) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *CachedError) GetErrorType() string {
	if m != nil {
		return m.ErrorType
	}
	return ""
}

func (m *CachedError) GetErrorMessage() string {
	if m != nil {
		return m.ErrorMessage
	}
	return ""
}

type CachedResponse struct {
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key"`
	// List of cached responses; non-overlapping and in order.
	Extents []Extent `protobuf:"bytes,2,rep,name=extents,proto3" json:"extents"`
}

func (m *CachedResponse) Reset()      { *m = CachedResponse{} }
func (*CachedResponse) ProtoMessage() {}
func (*CachedResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{5}
}
func (m *CachedResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CachedResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CachedResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CachedResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CachedResponse.Merge(m, src)
}
func (m *CachedResponse) XXX_Size() int {
	return m.Size()
}
func (m *CachedResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CachedResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CachedResponse proto.InternalMessageInfo

func (m *CachedResponse) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *CachedResponse) GetExtents() []Extent {
	if m != nil {
		return m.Extents
	}
	return nil
}

type Extent struct {
	Start    int64      `protobuf:"varint,1,opt,name=start,proto3" json:"start"`
	End      int64      `protobuf:"varint,2,opt,name=end,proto3" json:"end"`
	TraceId  string     `protobuf:"bytes,4,opt,name=trace_id,json=traceId,proto3" json:"-"`
	Response *types.Any `protobuf:"bytes,5,opt,name=response,proto3" json:"response"`
	// Unix timestamp when the query with this response was executed.
	// If the response is combination of multiple queries over time, all of which had timestamp set, this is the timestamp of oldest query.
	// When merging extents and some of them have 0 query timestamp, we keep non-zero timestamp, if possible.
	QueryTimestampMs int64 `protobuf:"varint,6,opt,name=query_timestamp_ms,json=queryTimestampMs,proto3" json:"query_timestamp_ms,omitempty"`
	// Number of samples processed per step to create this Extent. Should be sorted by timestamp in ascending order.
	SamplesProcessedPerStep []stats.StepStat `protobuf:"bytes,7,rep,name=samples_processed_per_step,json=samplesProcessedPerStep,proto3" json:"samples_processed_per_step"`
}

func (m *Extent) Reset()      { *m = Extent{} }
func (*Extent) ProtoMessage() {}
func (*Extent) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{6}
}
func (m *Extent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Extent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Extent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Extent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Extent.Merge(m, src)
}
func (m *Extent) XXX_Size() int {
	return m.Size()
}
func (m *Extent) XXX_DiscardUnknown() {
	xxx_messageInfo_Extent.DiscardUnknown(m)
}

var xxx_messageInfo_Extent proto.InternalMessageInfo

func (m *Extent) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *Extent) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

func (m *Extent) GetTraceId() string {
	if m != nil {
		return m.TraceId
	}
	return ""
}

func (m *Extent) GetResponse() *types.Any {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *Extent) GetQueryTimestampMs() int64 {
	if m != nil {
		return m.QueryTimestampMs
	}
	return 0
}

func (m *Extent) GetSamplesProcessedPerStep() []stats.StepStat {
	if m != nil {
		return m.SamplesProcessedPerStep
	}
	return nil
}

type Options struct {
	CacheDisabled        bool  `protobuf:"varint,1,opt,name=CacheDisabled,proto3" json:"CacheDisabled,omitempty"`
	ShardingDisabled     bool  `protobuf:"varint,2,opt,name=ShardingDisabled,proto3" json:"ShardingDisabled,omitempty"`
	TotalShards          int32 `protobuf:"varint,3,opt,name=TotalShards,proto3" json:"TotalShards,omitempty"`
	InstantSplitDisabled bool  `protobuf:"varint,4,opt,name=InstantSplitDisabled,proto3" json:"InstantSplitDisabled,omitempty"`
	// Instant split by time interval unit stored in nanoseconds (time.Duration unit in int64)
	InstantSplitInterval int64 `protobuf:"varint,5,opt,name=InstantSplitInterval,proto3" json:"InstantSplitInterval,omitempty"`
}

func (m *Options) Reset()      { *m = Options{} }
func (*Options) ProtoMessage() {}
func (*Options) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{7}
}
func (m *Options) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Options) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Options.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Options) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Options.Merge(m, src)
}
func (m *Options) XXX_Size() int {
	return m.Size()
}
func (m *Options) XXX_DiscardUnknown() {
	xxx_messageInfo_Options.DiscardUnknown(m)
}

var xxx_messageInfo_Options proto.InternalMessageInfo

func (m *Options) GetCacheDisabled() bool {
	if m != nil {
		return m.CacheDisabled
	}
	return false
}

func (m *Options) GetShardingDisabled() bool {
	if m != nil {
		return m.ShardingDisabled
	}
	return false
}

func (m *Options) GetTotalShards() int32 {
	if m != nil {
		return m.TotalShards
	}
	return 0
}

func (m *Options) GetInstantSplitDisabled() bool {
	if m != nil {
		return m.InstantSplitDisabled
	}
	return false
}

func (m *Options) GetInstantSplitInterval() int64 {
	if m != nil {
		return m.InstantSplitInterval
	}
	return 0
}

type QueryStatistics struct {
	EstimatedSeriesCount uint64 `protobuf:"varint,1,opt,name=EstimatedSeriesCount,proto3" json:"EstimatedSeriesCount,omitempty"`
	UserID               string `protobuf:"bytes,2,opt,name=UserID,proto3" json:"UserID,omitempty"`
}

func (m *QueryStatistics) Reset()      { *m = QueryStatistics{} }
func (*QueryStatistics) ProtoMessage() {}
func (*QueryStatistics) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{8}
}
func (m *QueryStatistics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryStatistics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryStatistics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryStatistics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryStatistics.Merge(m, src)
}
func (m *QueryStatistics) XXX_Size() int {
	return m.Size()
}
func (m *QueryStatistics) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryStatistics.DiscardUnknown(m)
}

var xxx_messageInfo_QueryStatistics proto.InternalMessageInfo

func (m *QueryStatistics) GetEstimatedSeriesCount() uint64 {
	if m != nil {
		return m.EstimatedSeriesCount
	}
	return 0
}

func (m *QueryStatistics) GetUserID() string {
	if m != nil {
		return m.UserID
	}
	return ""
}

// CachedHTTPResponse holds a generic HTTP response in the query results cache.
type CachedHTTPResponse struct {
	// cacheKey contains the non-hashed cache key, used to guarantee there haven't
	// been any hashed cache key collision.
	CacheKey string `protobuf:"bytes,1,opt,name=cache_key,json=cacheKey,proto3" json:"cache_key,omitempty"`
	// statusCode contains the HTTP response status code.
	StatusCode int32 `protobuf:"varint,2,opt,name=status_code,json=statusCode,proto3" json:"status_code,omitempty"`
	// headers contains the HTTP response headers.
	Headers []*CachedHTTPHeader `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty"`
	// body contains the HTTP response body.
	Body []byte `protobuf:"bytes,4,opt,name=body,proto3" json:"body,omitempty"`
}

func (m *CachedHTTPResponse) Reset()      { *m = CachedHTTPResponse{} }
func (*CachedHTTPResponse) ProtoMessage() {}
func (*CachedHTTPResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{9}
}
func (m *CachedHTTPResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CachedHTTPResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CachedHTTPResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CachedHTTPResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CachedHTTPResponse.Merge(m, src)
}
func (m *CachedHTTPResponse) XXX_Size() int {
	return m.Size()
}
func (m *CachedHTTPResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CachedHTTPResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CachedHTTPResponse proto.InternalMessageInfo

func (m *CachedHTTPResponse) GetCacheKey() string {
	if m != nil {
		return m.CacheKey
	}
	return ""
}

func (m *CachedHTTPResponse) GetStatusCode() int32 {
	if m != nil {
		return m.StatusCode
	}
	return 0
}

func (m *CachedHTTPResponse) GetHeaders() []*CachedHTTPHeader {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *CachedHTTPResponse) GetBody() []byte {
	if m != nil {
		return m.Body
	}
	return nil
}

// CachedHTTPHeader holds a HTTP header.
type CachedHTTPHeader struct {
	Name  string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *CachedHTTPHeader) Reset()      { *m = CachedHTTPHeader{} }
func (*CachedHTTPHeader) ProtoMessage() {}
func (*CachedHTTPHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_4c16552f9fdb66d8, []int{10}
}
func (m *CachedHTTPHeader) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CachedHTTPHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CachedHTTPHeader.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CachedHTTPHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CachedHTTPHeader.Merge(m, src)
}
func (m *CachedHTTPHeader) XXX_Size() int {
	return m.Size()
}
func (m *CachedHTTPHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_CachedHTTPHeader.DiscardUnknown(m)
}

var xxx_messageInfo_CachedHTTPHeader proto.InternalMessageInfo

func (m *CachedHTTPHeader) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CachedHTTPHeader) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func init() {
	proto.RegisterType((*PrometheusHeader)(nil), "queryrange.PrometheusHeader")
	proto.RegisterType((*PrometheusResponse)(nil), "queryrange.PrometheusResponse")
	proto.RegisterType((*PrometheusData)(nil), "queryrange.PrometheusData")
	proto.RegisterType((*SampleStream)(nil), "queryrange.SampleStream")
	proto.RegisterType((*CachedError)(nil), "queryrange.CachedError")
	proto.RegisterType((*CachedResponse)(nil), "queryrange.CachedResponse")
	proto.RegisterType((*Extent)(nil), "queryrange.Extent")
	proto.RegisterType((*Options)(nil), "queryrange.Options")
	proto.RegisterType((*QueryStatistics)(nil), "queryrange.QueryStatistics")
	proto.RegisterType((*CachedHTTPResponse)(nil), "queryrange.CachedHTTPResponse")
	proto.RegisterType((*CachedHTTPHeader)(nil), "queryrange.CachedHTTPHeader")
}

func init() { proto.RegisterFile("model.proto", fileDescriptor_4c16552f9fdb66d8) }

var fileDescriptor_4c16552f9fdb66d8 = []byte{
	// 1135 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x55, 0x4d, 0x8f, 0x1b, 0x45,
	0x13, 0xf6, 0xac, 0xbf, 0xcb, 0x9b, 0x5d, 0xab, 0xb3, 0x4a, 0x9c, 0x7d, 0x5f, 0x66, 0xac, 0x11,
	0x87, 0x05, 0x82, 0x0d, 0x06, 0x72, 0x40, 0x04, 0x11, 0x6f, 0x16, 0x65, 0x21, 0x01, 0xd3, 0x5e,
	0x40, 0x42, 0x42, 0x56, 0xdb, 0xd3, 0x19, 0x0f, 0x99, 0x2f, 0xba, 0xdb, 0x49, 0x7c, 0x43, 0x5c,
	0x91, 0x10, 0xbf, 0x80, 0x33, 0x27, 0x7e, 0x47, 0x8e, 0x39, 0x46, 0x1c, 0x46, 0xc4, 0x2b, 0x24,
	0x34, 0xa7, 0xfc, 0x00, 0x0e, 0xa8, 0xbb, 0x67, 0xc6, 0xde, 0x64, 0x15, 0x71, 0xb1, 0xbb, 0x9f,
	0x7a, 0x9e, 0xea, 0xea, 0xea, 0xaa, 0x1a, 0x68, 0x05, 0x91, 0x43, 0xfd, 0x5e, 0xcc, 0x22, 0x11,
	0x21, 0xf8, 0x7e, 0x41, 0xd9, 0x92, 0x91, 0xd0, 0xa5, 0xfb, 0x7b, 0x6e, 0xe4, 0x46, 0x0a, 0xee,
	0xcb, 0x95, 0x66, 0xec, 0x5f, 0x71, 0xa3, 0xc8, 0xf5, 0x69, 0x5f, 0xed, 0xa6, 0x8b, 0xbb, 0x7d,
	0x12, 0x2e, 0x33, 0xd3, 0x5b, 0xae, 0x27, 0xe6, 0x8b, 0x69, 0x6f, 0x16, 0x05, 0x7d, 0x97, 0x91,
	0xbb, 0x24, 0x24, 0xfd, 0xc0, 0x0b, 0x3c, 0xd6, 0x8f, 0xef, 0xb9, 0x7a, 0x15, 0x4f, 0xf5, 0x7f,
	0xa6, 0xb8, 0xf6, 0x52, 0x85, 0x8c, 0xc5, 0xa3, 0xac, 0xcf, 0x05, 0x11, 0x5c, 0xff, 0x6a, 0x9d,
	0x7d, 0x1b, 0xda, 0x23, 0x16, 0x05, 0x54, 0xcc, 0xe9, 0x82, 0xdf, 0xa2, 0xc4, 0xa1, 0x0c, 0x5d,
	0x81, 0xca, 0x67, 0x24, 0xa0, 0x1d, 0xa3, 0x6b, 0x1c, 0x34, 0x87, 0xd5, 0x34, 0xb1, 0x8c, 0x37,
	0xb1, 0x82, 0xd0, 0x2b, 0x50, 0xfb, 0x8a, 0xf8, 0x0b, 0xca, 0x3b, 0x5b, 0xdd, 0xf2, 0xda, 0x98,
	0x81, 0xf6, 0x3f, 0x5b, 0x80, 0xd6, 0xee, 0x30, 0xe5, 0x71, 0x14, 0x72, 0x8a, 0x6c, 0xa8, 0x8d,
	0x05, 0x11, 0x0b, 0x9e, 0xb9, 0x84, 0x34, 0xb1, 0x6a, 0x5c, 0x21, 0x38, 0xb3, 0xa0, 0x21, 0x54,
	0x6e, 0x12, 0x41, 0x3a, 0x5b, 0x5d, 0xe3, 0xa0, 0x35, 0xd8, 0xef, 0xad, 0xd3, 0xd7, 0x5b, 0x7b,
	0x94, 0x8c, 0x21, 0x4a, 0x13, 0x6b, 0xc7, 0x21, 0x82, 0x5c, 0x8d, 0x02, 0x4f, 0xd0, 0x20, 0x16,
	0x4b, 0xac, 0xb4, 0xe8, 0x3d, 0x68, 0x1e, 0x31, 0x16, 0xb1, 0x93, 0x65, 0x4c, 0x3b, 0x65, 0x75,
	0xd4, 0xe5, 0x34, 0xb1, 0x2e, 0xd2, 0x1c, 0xdc, 0x50, 0xac, 0x99, 0xe8, 0x35, 0xa8, 0xaa, 0x4d,
	0xa7, 0xa2, 0x24, 0x17, 0xd3, 0xc4, 0xda, 0x55, 0x92, 0x0d, 0xba, 0x66, 0xa0, 0xeb, 0x50, 0xd7,
	0x49, 0xe2, 0x9d, 0x6a, 0xb7, 0x7c, 0xd0, 0x1a, 0xfc, 0xff, 0xfc, 0x40, 0x35, 0x29, 0x4f, 0x4f,
	0xae, 0x41, 0x03, 0x68, 0x7c, 0x4d, 0x58, 0xe8, 0x85, 0x2e, 0xef, 0xd4, 0x54, 0x02, 0x2f, 0xa5,
	0x89, 0x85, 0x1e, 0x64, 0xd8, 0xc6, 0x79, 0x05, 0x4f, 0x46, 0x77, 0x1c, 0xde, 0x8d, 0x78, 0xa7,
	0xae, 0x04, 0x2a, 0x3a, 0x4f, 0x02, 0x9b, 0xd1, 0x29, 0x86, 0xfd, 0xa3, 0x01, 0x3b, 0x67, 0x93,
	0x85, 0x7a, 0x00, 0x98, 0xf2, 0x85, 0x2f, 0x54, 0x4e, 0x74, 0xfa, 0x77, 0xd2, 0xc4, 0x02, 0x56,
	0xa0, 0x78, 0x83, 0x81, 0x3e, 0x82, 0x9a, 0xde, 0xa9, 0x07, 0x6e, 0x0d, 0x3a, 0x9b, 0xf7, 0x1b,
	0x93, 0x20, 0xf6, 0xe9, 0x58, 0x30, 0x4a, 0x82, 0xe1, 0xce, 0xa3, 0xc4, 0x2a, 0xc9, 0x87, 0xd4,
	0x9e, 0x70, 0xa6, 0xb3, 0x7f, 0xde, 0x82, 0xed, 0x4d, 0x22, 0x8a, 0xa1, 0xe6, 0x93, 0x29, 0xf5,
	0xe5, 0xeb, 0x4b, 0x97, 0x17, 0x7b, 0xb3, 0x88, 0x09, 0xfa, 0x30, 0x9e, 0xf6, 0x6e, 0x4b, 0x7c,
	0x44, 0x3c, 0x36, 0x3c, 0x94, 0xde, 0xfe, 0x48, 0xac, 0xb7, 0xff, 0x4b, 0xe5, 0x6b, 0xdd, 0x0d,
	0x87, 0xc4, 0x82, 0x32, 0x19, 0x42, 0x40, 0x05, 0xf3, 0x66, 0x38, 0x3b, 0x07, 0xbd, 0x0f, 0x75,
	0xae, 0x22, 0xe0, 0xd9, 0x2d, 0xda, 0xeb, 0x23, 0x75, 0x68, 0xeb, 0xe8, 0xef, 0xab, 0xca, 0xc5,
	0xb9, 0x00, 0x8d, 0x00, 0xe6, 0x1e, 0x17, 0x91, 0xcb, 0x48, 0xc0, 0x3b, 0xe5, 0xec, 0x91, 0x0b,
	0xf9, 0xc7, 0x7e, 0x44, 0xc4, 0xad, 0x9c, 0xa0, 0x42, 0x47, 0x99, 0xab, 0x0d, 0x1d, 0xde, 0x58,
	0xdb, 0x3f, 0x19, 0xd0, 0x3a, 0x24, 0xb3, 0x39, 0x75, 0x74, 0x0d, 0x5d, 0x81, 0xf2, 0x3d, 0xba,
	0xcc, 0xde, 0xa2, 0x9e, 0x26, 0x96, 0xdc, 0x62, 0xf9, 0x83, 0xde, 0x80, 0x66, 0x51, 0xab, 0xaa,
	0x13, 0x9a, 0xc3, 0x0b, 0x69, 0x62, 0xad, 0x41, 0xbc, 0x5e, 0xa2, 0x77, 0x61, 0x5b, 0x6d, 0xee,
	0x50, 0xce, 0x89, 0x9b, 0x17, 0x7c, 0x3b, 0x4d, 0xac, 0x33, 0x38, 0x3e, 0xb3, 0xb3, 0xbf, 0x83,
	0x1d, 0x1d, 0x4c, 0xd1, 0x9d, 0x2f, 0x89, 0xe7, 0x3a, 0xd4, 0xe9, 0x43, 0x41, 0x43, 0x91, 0x27,
	0x12, 0x6d, 0x96, 0xc3, 0x91, 0x32, 0x0d, 0x77, 0xb3, 0xfb, 0xe7, 0x54, 0x9c, 0x2f, 0xec, 0xdf,
	0xb7, 0xa0, 0xa6, 0x49, 0xc8, 0x82, 0x2a, 0x17, 0x84, 0x09, 0x75, 0x4c, 0x79, 0xd8, 0x4c, 0x13,
	0x4b, 0x03, 0x58, 0xff, 0xc9, 0x28, 0x68, 0xe8, 0xa8, 0x4b, 0x97, 0x75, 0x14, 0x34, 0x74, 0xb0,
	0xfc, 0x41, 0x5d, 0x68, 0x08, 0x46, 0x66, 0x74, 0xe2, 0x39, 0x59, 0x8b, 0xe6, 0x7d, 0xa5, 0xe0,
	0x63, 0x07, 0x7d, 0x08, 0x0d, 0x96, 0x5d, 0xa7, 0x53, 0x55, 0x03, 0x64, 0xaf, 0xa7, 0xa7, 0x6b,
	0x2f, 0x9f, 0xae, 0xbd, 0x1b, 0xe1, 0x72, 0xb8, 0x9d, 0x26, 0x56, 0xc1, 0xc4, 0xc5, 0x0a, 0x5d,
	0x05, 0xa4, 0xee, 0x35, 0x11, 0x5e, 0x40, 0xb9, 0x20, 0x41, 0x3c, 0x09, 0x64, 0x87, 0x1a, 0x07,
	0x65, 0xdc, 0x56, 0x96, 0x93, 0xdc, 0x70, 0x87, 0x23, 0x0c, 0xfb, 0x59, 0xb5, 0x4c, 0x62, 0x16,
	0xcd, 0x28, 0xe7, 0xd4, 0x99, 0xc4, 0x94, 0x4d, 0xb8, 0xa0, 0xb1, 0x6a, 0xd3, 0xd6, 0x60, 0xb7,
	0xa7, 0xa7, 0xec, 0x58, 0xd0, 0x58, 0x4e, 0xb8, 0x61, 0x45, 0x66, 0x09, 0x5f, 0xce, 0x84, 0xa3,
	0x5c, 0x37, 0xa2, 0x4c, 0x52, 0x3e, 0xa9, 0x34, 0xca, 0xed, 0x8a, 0xfd, 0x97, 0x01, 0xf5, 0xcf,
	0x63, 0xe1, 0x45, 0x21, 0x47, 0xaf, 0xc2, 0x05, 0xf5, 0x50, 0x37, 0x3d, 0x4e, 0xa6, 0x3e, 0x75,
	0x54, 0xe6, 0x1a, 0xf8, 0x2c, 0x88, 0x5e, 0x87, 0xf6, 0x78, 0x4e, 0x98, 0xe3, 0x85, 0x6e, 0x41,
	0xdc, 0x52, 0xc4, 0x17, 0x70, 0xd4, 0x85, 0xd6, 0x49, 0x24, 0x88, 0xaf, 0x0c, 0x5c, 0xd5, 0x4b,
	0x15, 0x6f, 0x42, 0x68, 0x00, 0x7b, 0xc7, 0x21, 0x17, 0x24, 0x14, 0xe3, 0xd8, 0xf7, 0x44, 0xe1,
	0xb1, 0xa2, 0x3c, 0x9e, 0x6b, 0x7b, 0x5e, 0x73, 0x1c, 0x0a, 0xca, 0xee, 0x13, 0x5f, 0xbd, 0x43,
	0x19, 0x9f, 0x6b, 0xb3, 0xbf, 0x85, 0xdd, 0x2f, 0x64, 0x56, 0x65, 0x66, 0x3c, 0x2e, 0xbc, 0x99,
	0x3a, 0xfa, 0x88, 0x0b, 0x2f, 0x20, 0x82, 0x3a, 0x63, 0xf9, 0xb5, 0xe2, 0x87, 0xd1, 0x22, 0xd4,
	0xf5, 0x52, 0xc1, 0xe7, 0xda, 0xd0, 0x25, 0xa8, 0x7d, 0xc9, 0x29, 0x3b, 0xbe, 0xa9, 0x7b, 0x05,
	0x67, 0x3b, 0xfb, 0x57, 0x03, 0x90, 0x2e, 0xf2, 0x5b, 0x27, 0x27, 0xa3, 0xa2, 0xd0, 0xff, 0x07,
	0xcd, 0x99, 0x44, 0x27, 0x45, 0xb9, 0xe3, 0x86, 0x02, 0x3e, 0xa5, 0x4b, 0x64, 0x41, 0x4b, 0x7f,
	0x91, 0x26, 0xb3, 0xc8, 0xd1, 0xcd, 0x57, 0xc5, 0xa0, 0xa1, 0xc3, 0xc8, 0xa1, 0xe8, 0x1a, 0xd4,
	0xe7, 0xd9, 0xe8, 0x2f, 0xbf, 0x38, 0xfa, 0xd7, 0xc7, 0xe9, 0x59, 0x8f, 0x73, 0x32, 0x42, 0x50,
	0x99, 0x46, 0xce, 0x52, 0xe5, 0x70, 0x1b, 0xab, 0xb5, 0xfd, 0x01, 0xb4, 0x9f, 0x17, 0x48, 0x5e,
	0x58, 0x7c, 0x75, 0xb1, 0x5a, 0xa3, 0x3d, 0xa8, 0xaa, 0xf9, 0x94, 0xdd, 0x4f, 0x6f, 0x86, 0x47,
	0x8f, 0x9f, 0x9a, 0xa5, 0x27, 0x4f, 0xcd, 0xd2, 0xb3, 0xa7, 0xa6, 0xf1, 0xc3, 0xca, 0x34, 0x7e,
	0x5b, 0x99, 0xc6, 0xa3, 0x95, 0x69, 0x3c, 0x5e, 0x99, 0xc6, 0x9f, 0x2b, 0xd3, 0xf8, 0x7b, 0x65,
	0x96, 0x9e, 0xad, 0x4c, 0xe3, 0x97, 0x53, 0xb3, 0xf4, 0xf8, 0xd4, 0x2c, 0x3d, 0x39, 0x35, 0x4b,
	0xdf, 0xec, 0xaa, 0x68, 0x03, 0xcf, 0x71, 0x7c, 0xfa, 0x80, 0x30, 0x3a, 0xad, 0xa9, 0xd6, 0x78,
	0xe7, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x61, 0x02, 0x3e, 0xa7, 0xb7, 0x08, 0x00, 0x00,
}

func (this *PrometheusHeader) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PrometheusHeader)
	if !ok {
		that2, ok := that.(PrometheusHeader)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if len(this.Values) != len(that1.Values) {
		return false
	}
	for i := range this.Values {
		if this.Values[i] != that1.Values[i] {
			return false
		}
	}
	return true
}
func (this *PrometheusResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PrometheusResponse)
	if !ok {
		that2, ok := that.(PrometheusResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if !this.Data.Equal(that1.Data) {
		return false
	}
	if this.ErrorType != that1.ErrorType {
		return false
	}
	if this.Error != that1.Error {
		return false
	}
	if len(this.Headers) != len(that1.Headers) {
		return false
	}
	for i := range this.Headers {
		if !this.Headers[i].Equal(that1.Headers[i]) {
			return false
		}
	}
	if len(this.Warnings) != len(that1.Warnings) {
		return false
	}
	for i := range this.Warnings {
		if this.Warnings[i] != that1.Warnings[i] {
			return false
		}
	}
	if len(this.Infos) != len(that1.Infos) {
		return false
	}
	for i := range this.Infos {
		if this.Infos[i] != that1.Infos[i] {
			return false
		}
	}
	return true
}
func (this *PrometheusData) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PrometheusData)
	if !ok {
		that2, ok := that.(PrometheusData)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ResultType != that1.ResultType {
		return false
	}
	if len(this.Result) != len(that1.Result) {
		return false
	}
	for i := range this.Result {
		if !this.Result[i].Equal(&that1.Result[i]) {
			return false
		}
	}
	return true
}
func (this *SampleStream) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SampleStream)
	if !ok {
		that2, ok := that.(SampleStream)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Labels) != len(that1.Labels) {
		return false
	}
	for i := range this.Labels {
		if !this.Labels[i].Equal(that1.Labels[i]) {
			return false
		}
	}
	if len(this.Samples) != len(that1.Samples) {
		return false
	}
	for i := range this.Samples {
		if !this.Samples[i].Equal(&that1.Samples[i]) {
			return false
		}
	}
	if len(this.Histograms) != len(that1.Histograms) {
		return false
	}
	for i := range this.Histograms {
		if !this.Histograms[i].Equal(&that1.Histograms[i]) {
			return false
		}
	}
	return true
}
func (this *CachedError) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CachedError)
	if !ok {
		that2, ok := that.(CachedError)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Key != that1.Key {
		return false
	}
	if this.ErrorType != that1.ErrorType {
		return false
	}
	if this.ErrorMessage != that1.ErrorMessage {
		return false
	}
	return true
}
func (this *CachedResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CachedResponse)
	if !ok {
		that2, ok := that.(CachedResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Key != that1.Key {
		return false
	}
	if len(this.Extents) != len(that1.Extents) {
		return false
	}
	for i := range this.Extents {
		if !this.Extents[i].Equal(&that1.Extents[i]) {
			return false
		}
	}
	return true
}
func (this *Extent) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Extent)
	if !ok {
		that2, ok := that.(Extent)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Start != that1.Start {
		return false
	}
	if this.End != that1.End {
		return false
	}
	if this.TraceId != that1.TraceId {
		return false
	}
	if !this.Response.Equal(that1.Response) {
		return false
	}
	if this.QueryTimestampMs != that1.QueryTimestampMs {
		return false
	}
	if len(this.SamplesProcessedPerStep) != len(that1.SamplesProcessedPerStep) {
		return false
	}
	for i := range this.SamplesProcessedPerStep {
		if !this.SamplesProcessedPerStep[i].Equal(&that1.SamplesProcessedPerStep[i]) {
			return false
		}
	}
	return true
}
func (this *Options) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Options)
	if !ok {
		that2, ok := that.(Options)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.CacheDisabled != that1.CacheDisabled {
		return false
	}
	if this.ShardingDisabled != that1.ShardingDisabled {
		return false
	}
	if this.TotalShards != that1.TotalShards {
		return false
	}
	if this.InstantSplitDisabled != that1.InstantSplitDisabled {
		return false
	}
	if this.InstantSplitInterval != that1.InstantSplitInterval {
		return false
	}
	return true
}
func (this *QueryStatistics) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*QueryStatistics)
	if !ok {
		that2, ok := that.(QueryStatistics)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.EstimatedSeriesCount != that1.EstimatedSeriesCount {
		return false
	}
	if this.UserID != that1.UserID {
		return false
	}
	return true
}
func (this *CachedHTTPResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CachedHTTPResponse)
	if !ok {
		that2, ok := that.(CachedHTTPResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.CacheKey != that1.CacheKey {
		return false
	}
	if this.StatusCode != that1.StatusCode {
		return false
	}
	if len(this.Headers) != len(that1.Headers) {
		return false
	}
	for i := range this.Headers {
		if !this.Headers[i].Equal(that1.Headers[i]) {
			return false
		}
	}
	if !bytes.Equal(this.Body, that1.Body) {
		return false
	}
	return true
}
func (this *CachedHTTPHeader) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CachedHTTPHeader)
	if !ok {
		that2, ok := that.(CachedHTTPHeader)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *PrometheusHeader) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&querymiddleware.PrometheusHeader{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Values: "+fmt.Sprintf("%#v", this.Values)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PrometheusResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&querymiddleware.PrometheusResponse{")
	s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	if this.Data != nil {
		s = append(s, "Data: "+fmt.Sprintf("%#v", this.Data)+",\n")
	}
	s = append(s, "ErrorType: "+fmt.Sprintf("%#v", this.ErrorType)+",\n")
	s = append(s, "Error: "+fmt.Sprintf("%#v", this.Error)+",\n")
	if this.Headers != nil {
		s = append(s, "Headers: "+fmt.Sprintf("%#v", this.Headers)+",\n")
	}
	s = append(s, "Warnings: "+fmt.Sprintf("%#v", this.Warnings)+",\n")
	s = append(s, "Infos: "+fmt.Sprintf("%#v", this.Infos)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PrometheusData) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&querymiddleware.PrometheusData{")
	s = append(s, "ResultType: "+fmt.Sprintf("%#v", this.ResultType)+",\n")
	if this.Result != nil {
		vs := make([]SampleStream, len(this.Result))
		for i := range vs {
			vs[i] = this.Result[i]
		}
		s = append(s, "Result: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SampleStream) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&querymiddleware.SampleStream{")
	s = append(s, "Labels: "+fmt.Sprintf("%#v", this.Labels)+",\n")
	if this.Samples != nil {
		vs := make([]mimirpb.Sample, len(this.Samples))
		for i := range vs {
			vs[i] = this.Samples[i]
		}
		s = append(s, "Samples: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	if this.Histograms != nil {
		vs := make([]mimirpb.FloatHistogramPair, len(this.Histograms))
		for i := range vs {
			vs[i] = this.Histograms[i]
		}
		s = append(s, "Histograms: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CachedError) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&querymiddleware.CachedError{")
	s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	s = append(s, "ErrorType: "+fmt.Sprintf("%#v", this.ErrorType)+",\n")
	s = append(s, "ErrorMessage: "+fmt.Sprintf("%#v", this.ErrorMessage)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CachedResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&querymiddleware.CachedResponse{")
	s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	if this.Extents != nil {
		vs := make([]Extent, len(this.Extents))
		for i := range vs {
			vs[i] = this.Extents[i]
		}
		s = append(s, "Extents: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Extent) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 10)
	s = append(s, "&querymiddleware.Extent{")
	s = append(s, "Start: "+fmt.Sprintf("%#v", this.Start)+",\n")
	s = append(s, "End: "+fmt.Sprintf("%#v", this.End)+",\n")
	s = append(s, "TraceId: "+fmt.Sprintf("%#v", this.TraceId)+",\n")
	if this.Response != nil {
		s = append(s, "Response: "+fmt.Sprintf("%#v", this.Response)+",\n")
	}
	s = append(s, "QueryTimestampMs: "+fmt.Sprintf("%#v", this.QueryTimestampMs)+",\n")
	if this.SamplesProcessedPerStep != nil {
		vs := make([]stats.StepStat, len(this.SamplesProcessedPerStep))
		for i := range vs {
			vs[i] = this.SamplesProcessedPerStep[i]
		}
		s = append(s, "SamplesProcessedPerStep: "+fmt.Sprintf("%#v", vs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Options) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&querymiddleware.Options{")
	s = append(s, "CacheDisabled: "+fmt.Sprintf("%#v", this.CacheDisabled)+",\n")
	s = append(s, "ShardingDisabled: "+fmt.Sprintf("%#v", this.ShardingDisabled)+",\n")
	s = append(s, "TotalShards: "+fmt.Sprintf("%#v", this.TotalShards)+",\n")
	s = append(s, "InstantSplitDisabled: "+fmt.Sprintf("%#v", this.InstantSplitDisabled)+",\n")
	s = append(s, "InstantSplitInterval: "+fmt.Sprintf("%#v", this.InstantSplitInterval)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QueryStatistics) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&querymiddleware.QueryStatistics{")
	s = append(s, "EstimatedSeriesCount: "+fmt.Sprintf("%#v", this.EstimatedSeriesCount)+",\n")
	s = append(s, "UserID: "+fmt.Sprintf("%#v", this.UserID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CachedHTTPResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&querymiddleware.CachedHTTPResponse{")
	s = append(s, "CacheKey: "+fmt.Sprintf("%#v", this.CacheKey)+",\n")
	s = append(s, "StatusCode: "+fmt.Sprintf("%#v", this.StatusCode)+",\n")
	if this.Headers != nil {
		s = append(s, "Headers: "+fmt.Sprintf("%#v", this.Headers)+",\n")
	}
	s = append(s, "Body: "+fmt.Sprintf("%#v", this.Body)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CachedHTTPHeader) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&querymiddleware.CachedHTTPHeader{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringModel(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *PrometheusHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrometheusHeader) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrometheusHeader) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Values) > 0 {
		for iNdEx := len(m.Values) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Values[iNdEx])
			copy(dAtA[i:], m.Values[iNdEx])
			i = encodeVarintModel(dAtA, i, uint64(len(m.Values[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintModel(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PrometheusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrometheusResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrometheusResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Infos) > 0 {
		for iNdEx := len(m.Infos) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Infos[iNdEx])
			copy(dAtA[i:], m.Infos[iNdEx])
			i = encodeVarintModel(dAtA, i, uint64(len(m.Infos[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.Warnings) > 0 {
		for iNdEx := len(m.Warnings) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Warnings[iNdEx])
			copy(dAtA[i:], m.Warnings[iNdEx])
			i = encodeVarintModel(dAtA, i, uint64(len(m.Warnings[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Headers) > 0 {
		for iNdEx := len(m.Headers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Headers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintModel(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Error) > 0 {
		i -= len(m.Error)
		copy(dAtA[i:], m.Error)
		i = encodeVarintModel(dAtA, i, uint64(len(m.Error)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ErrorType) > 0 {
		i -= len(m.ErrorType)
		copy(dAtA[i:], m.ErrorType)
		i = encodeVarintModel(dAtA, i, uint64(len(m.ErrorType)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Data != nil {
		{
			size, err := m.Data.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintModel(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Status) > 0 {
		i -= len(m.Status)
		copy(dAtA[i:], m.Status)
		i = encodeVarintModel(dAtA, i, uint64(len(m.Status)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PrometheusData) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrometheusData) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrometheusData) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Result) > 0 {
		for iNdEx := len(m.Result) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Result[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintModel(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ResultType) > 0 {
		i -= len(m.ResultType)
		copy(dAtA[i:], m.ResultType)
		i = encodeVarintModel(dAtA, i, uint64(len(m.ResultType)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SampleStream) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SampleStream) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SampleStream) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Histograms) > 0 {
		for iNdEx := len(m.Histograms) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Histograms[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintModel(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Samples) > 0 {
		for iNdEx := len(m.Samples) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Samples[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintModel(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size := m.Labels[iNdEx].Size()
				i -= size
				if _, err := m.Labels[iNdEx].MarshalTo(dAtA[i:]); err != nil {
					return 0, err
				}
				i = encodeVarintModel(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *CachedError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CachedError) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CachedError) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ErrorMessage) > 0 {
		i -= len(m.ErrorMessage)
		copy(dAtA[i:], m.ErrorMessage)
		i = encodeVarintModel(dAtA, i, uint64(len(m.ErrorMessage)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ErrorType) > 0 {
		i -= len(m.ErrorType)
		copy(dAtA[i:], m.ErrorType)
		i = encodeVarintModel(dAtA, i, uint64(len(m.ErrorType)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintModel(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CachedResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CachedResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CachedResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Extents) > 0 {
		for iNdEx := len(m.Extents) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Extents[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintModel(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintModel(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Extent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Extent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Extent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SamplesProcessedPerStep) > 0 {
		for iNdEx := len(m.SamplesProcessedPerStep) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.SamplesProcessedPerStep[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintModel(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.QueryTimestampMs != 0 {
		i = encodeVarintModel(dAtA, i, uint64(m.QueryTimestampMs))
		i--
		dAtA[i] = 0x30
	}
	if m.Response != nil {
		{
			size, err := m.Response.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintModel(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.TraceId) > 0 {
		i -= len(m.TraceId)
		copy(dAtA[i:], m.TraceId)
		i = encodeVarintModel(dAtA, i, uint64(len(m.TraceId)))
		i--
		dAtA[i] = 0x22
	}
	if m.End != 0 {
		i = encodeVarintModel(dAtA, i, uint64(m.End))
		i--
		dAtA[i] = 0x10
	}
	if m.Start != 0 {
		i = encodeVarintModel(dAtA, i, uint64(m.Start))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Options) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Options) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Options) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.InstantSplitInterval != 0 {
		i = encodeVarintModel(dAtA, i, uint64(m.InstantSplitInterval))
		i--
		dAtA[i] = 0x28
	}
	if m.InstantSplitDisabled {
		i--
		if m.InstantSplitDisabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.TotalShards != 0 {
		i = encodeVarintModel(dAtA, i, uint64(m.TotalShards))
		i--
		dAtA[i] = 0x18
	}
	if m.ShardingDisabled {
		i--
		if m.ShardingDisabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.CacheDisabled {
		i--
		if m.CacheDisabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *QueryStatistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryStatistics) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryStatistics) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.UserID) > 0 {
		i -= len(m.UserID)
		copy(dAtA[i:], m.UserID)
		i = encodeVarintModel(dAtA, i, uint64(len(m.UserID)))
		i--
		dAtA[i] = 0x12
	}
	if m.EstimatedSeriesCount != 0 {
		i = encodeVarintModel(dAtA, i, uint64(m.EstimatedSeriesCount))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CachedHTTPResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CachedHTTPResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CachedHTTPResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Body) > 0 {
		i -= len(m.Body)
		copy(dAtA[i:], m.Body)
		i = encodeVarintModel(dAtA, i, uint64(len(m.Body)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Headers) > 0 {
		for iNdEx := len(m.Headers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Headers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintModel(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.StatusCode != 0 {
		i = encodeVarintModel(dAtA, i, uint64(m.StatusCode))
		i--
		dAtA[i] = 0x10
	}
	if len(m.CacheKey) > 0 {
		i -= len(m.CacheKey)
		copy(dAtA[i:], m.CacheKey)
		i = encodeVarintModel(dAtA, i, uint64(len(m.CacheKey)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CachedHTTPHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CachedHTTPHeader) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CachedHTTPHeader) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintModel(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintModel(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintModel(dAtA []byte, offset int, v uint64) int {
	offset -= sovModel(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *PrometheusHeader) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			l = len(s)
			n += 1 + l + sovModel(uint64(l))
		}
	}
	return n
}

func (m *PrometheusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Status)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	if m.Data != nil {
		l = m.Data.Size()
		n += 1 + l + sovModel(uint64(l))
	}
	l = len(m.ErrorType)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	if len(m.Headers) > 0 {
		for _, e := range m.Headers {
			l = e.Size()
			n += 1 + l + sovModel(uint64(l))
		}
	}
	if len(m.Warnings) > 0 {
		for _, s := range m.Warnings {
			l = len(s)
			n += 1 + l + sovModel(uint64(l))
		}
	}
	if len(m.Infos) > 0 {
		for _, s := range m.Infos {
			l = len(s)
			n += 1 + l + sovModel(uint64(l))
		}
	}
	return n
}

func (m *PrometheusData) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ResultType)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	if len(m.Result) > 0 {
		for _, e := range m.Result {
			l = e.Size()
			n += 1 + l + sovModel(uint64(l))
		}
	}
	return n
}

func (m *SampleStream) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovModel(uint64(l))
		}
	}
	if len(m.Samples) > 0 {
		for _, e := range m.Samples {
			l = e.Size()
			n += 1 + l + sovModel(uint64(l))
		}
	}
	if len(m.Histograms) > 0 {
		for _, e := range m.Histograms {
			l = e.Size()
			n += 1 + l + sovModel(uint64(l))
		}
	}
	return n
}

func (m *CachedError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	l = len(m.ErrorType)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	l = len(m.ErrorMessage)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	return n
}

func (m *CachedResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	if len(m.Extents) > 0 {
		for _, e := range m.Extents {
			l = e.Size()
			n += 1 + l + sovModel(uint64(l))
		}
	}
	return n
}

func (m *Extent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Start != 0 {
		n += 1 + sovModel(uint64(m.Start))
	}
	if m.End != 0 {
		n += 1 + sovModel(uint64(m.End))
	}
	l = len(m.TraceId)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	if m.Response != nil {
		l = m.Response.Size()
		n += 1 + l + sovModel(uint64(l))
	}
	if m.QueryTimestampMs != 0 {
		n += 1 + sovModel(uint64(m.QueryTimestampMs))
	}
	if len(m.SamplesProcessedPerStep) > 0 {
		for _, e := range m.SamplesProcessedPerStep {
			l = e.Size()
			n += 1 + l + sovModel(uint64(l))
		}
	}
	return n
}

func (m *Options) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CacheDisabled {
		n += 2
	}
	if m.ShardingDisabled {
		n += 2
	}
	if m.TotalShards != 0 {
		n += 1 + sovModel(uint64(m.TotalShards))
	}
	if m.InstantSplitDisabled {
		n += 2
	}
	if m.InstantSplitInterval != 0 {
		n += 1 + sovModel(uint64(m.InstantSplitInterval))
	}
	return n
}

func (m *QueryStatistics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.EstimatedSeriesCount != 0 {
		n += 1 + sovModel(uint64(m.EstimatedSeriesCount))
	}
	l = len(m.UserID)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	return n
}

func (m *CachedHTTPResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CacheKey)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	if m.StatusCode != 0 {
		n += 1 + sovModel(uint64(m.StatusCode))
	}
	if len(m.Headers) > 0 {
		for _, e := range m.Headers {
			l = e.Size()
			n += 1 + l + sovModel(uint64(l))
		}
	}
	l = len(m.Body)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	return n
}

func (m *CachedHTTPHeader) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovModel(uint64(l))
	}
	return n
}

func sovModel(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozModel(x uint64) (n int) {
	return sovModel(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *PrometheusHeader) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PrometheusHeader{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Values:` + fmt.Sprintf("%v", this.Values) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PrometheusResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForHeaders := "[]*PrometheusHeader{"
	for _, f := range this.Headers {
		repeatedStringForHeaders += strings.Replace(f.String(), "PrometheusHeader", "PrometheusHeader", 1) + ","
	}
	repeatedStringForHeaders += "}"
	s := strings.Join([]string{`&PrometheusResponse{`,
		`Status:` + fmt.Sprintf("%v", this.Status) + `,`,
		`Data:` + strings.Replace(this.Data.String(), "PrometheusData", "PrometheusData", 1) + `,`,
		`ErrorType:` + fmt.Sprintf("%v", this.ErrorType) + `,`,
		`Error:` + fmt.Sprintf("%v", this.Error) + `,`,
		`Headers:` + repeatedStringForHeaders + `,`,
		`Warnings:` + fmt.Sprintf("%v", this.Warnings) + `,`,
		`Infos:` + fmt.Sprintf("%v", this.Infos) + `,`,
		`}`,
	}, "")
	return s
}
func (this *PrometheusData) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForResult := "[]SampleStream{"
	for _, f := range this.Result {
		repeatedStringForResult += strings.Replace(strings.Replace(f.String(), "SampleStream", "SampleStream", 1), `&`, ``, 1) + ","
	}
	repeatedStringForResult += "}"
	s := strings.Join([]string{`&PrometheusData{`,
		`ResultType:` + fmt.Sprintf("%v", this.ResultType) + `,`,
		`Result:` + repeatedStringForResult + `,`,
		`}`,
	}, "")
	return s
}
func (this *SampleStream) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForSamples := "[]Sample{"
	for _, f := range this.Samples {
		repeatedStringForSamples += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForSamples += "}"
	repeatedStringForHistograms := "[]FloatHistogramPair{"
	for _, f := range this.Histograms {
		repeatedStringForHistograms += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForHistograms += "}"
	s := strings.Join([]string{`&SampleStream{`,
		`Labels:` + fmt.Sprintf("%v", this.Labels) + `,`,
		`Samples:` + repeatedStringForSamples + `,`,
		`Histograms:` + repeatedStringForHistograms + `,`,
		`}`,
	}, "")
	return s
}
func (this *CachedError) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CachedError{`,
		`Key:` + fmt.Sprintf("%v", this.Key) + `,`,
		`ErrorType:` + fmt.Sprintf("%v", this.ErrorType) + `,`,
		`ErrorMessage:` + fmt.Sprintf("%v", this.ErrorMessage) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CachedResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForExtents := "[]Extent{"
	for _, f := range this.Extents {
		repeatedStringForExtents += strings.Replace(strings.Replace(f.String(), "Extent", "Extent", 1), `&`, ``, 1) + ","
	}
	repeatedStringForExtents += "}"
	s := strings.Join([]string{`&CachedResponse{`,
		`Key:` + fmt.Sprintf("%v", this.Key) + `,`,
		`Extents:` + repeatedStringForExtents + `,`,
		`}`,
	}, "")
	return s
}
func (this *Extent) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForSamplesProcessedPerStep := "[]StepStat{"
	for _, f := range this.SamplesProcessedPerStep {
		repeatedStringForSamplesProcessedPerStep += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForSamplesProcessedPerStep += "}"
	s := strings.Join([]string{`&Extent{`,
		`Start:` + fmt.Sprintf("%v", this.Start) + `,`,
		`End:` + fmt.Sprintf("%v", this.End) + `,`,
		`TraceId:` + fmt.Sprintf("%v", this.TraceId) + `,`,
		`Response:` + strings.Replace(fmt.Sprintf("%v", this.Response), "Any", "types.Any", 1) + `,`,
		`QueryTimestampMs:` + fmt.Sprintf("%v", this.QueryTimestampMs) + `,`,
		`SamplesProcessedPerStep:` + repeatedStringForSamplesProcessedPerStep + `,`,
		`}`,
	}, "")
	return s
}
func (this *Options) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Options{`,
		`CacheDisabled:` + fmt.Sprintf("%v", this.CacheDisabled) + `,`,
		`ShardingDisabled:` + fmt.Sprintf("%v", this.ShardingDisabled) + `,`,
		`TotalShards:` + fmt.Sprintf("%v", this.TotalShards) + `,`,
		`InstantSplitDisabled:` + fmt.Sprintf("%v", this.InstantSplitDisabled) + `,`,
		`InstantSplitInterval:` + fmt.Sprintf("%v", this.InstantSplitInterval) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QueryStatistics) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QueryStatistics{`,
		`EstimatedSeriesCount:` + fmt.Sprintf("%v", this.EstimatedSeriesCount) + `,`,
		`UserID:` + fmt.Sprintf("%v", this.UserID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CachedHTTPResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForHeaders := "[]*CachedHTTPHeader{"
	for _, f := range this.Headers {
		repeatedStringForHeaders += strings.Replace(f.String(), "CachedHTTPHeader", "CachedHTTPHeader", 1) + ","
	}
	repeatedStringForHeaders += "}"
	s := strings.Join([]string{`&CachedHTTPResponse{`,
		`CacheKey:` + fmt.Sprintf("%v", this.CacheKey) + `,`,
		`StatusCode:` + fmt.Sprintf("%v", this.StatusCode) + `,`,
		`Headers:` + repeatedStringForHeaders + `,`,
		`Body:` + fmt.Sprintf("%v", this.Body) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CachedHTTPHeader) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CachedHTTPHeader{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringModel(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *PrometheusHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrometheusHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrometheusHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrometheusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrometheusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrometheusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Status = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Data == nil {
				m.Data = &PrometheusData{}
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Headers = append(m.Headers, &PrometheusHeader{})
			if err := m.Headers[len(m.Headers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Warnings = append(m.Warnings, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Infos", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Infos = append(m.Infos, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrometheusData) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrometheusData: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrometheusData: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResultType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResultType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Result = append(m.Result, SampleStream{})
			if err := m.Result[len(m.Result)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SampleStream) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SampleStream: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SampleStream: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, github_com_grafana_mimir_pkg_mimirpb.LabelAdapter{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Samples", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Samples = append(m.Samples, mimirpb.Sample{})
			if err := m.Samples[len(m.Samples)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Histograms", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Histograms = append(m.Histograms, mimirpb.FloatHistogramPair{})
			if err := m.Histograms[len(m.Histograms)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CachedError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CachedError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CachedError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorMessage = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CachedResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CachedResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CachedResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Extents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Extents = append(m.Extents, Extent{})
			if err := m.Extents[len(m.Extents)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Extent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Extent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Extent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			m.Start = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Start |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			m.End = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.End |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TraceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Response", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Response == nil {
				m.Response = &types.Any{}
			}
			if err := m.Response.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryTimestampMs", wireType)
			}
			m.QueryTimestampMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.QueryTimestampMs |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SamplesProcessedPerStep", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SamplesProcessedPerStep = append(m.SamplesProcessedPerStep, stats.StepStat{})
			if err := m.SamplesProcessedPerStep[len(m.SamplesProcessedPerStep)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Options) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Options: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Options: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CacheDisabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CacheDisabled = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShardingDisabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ShardingDisabled = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalShards", wireType)
			}
			m.TotalShards = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalShards |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstantSplitDisabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.InstantSplitDisabled = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstantSplitInterval", wireType)
			}
			m.InstantSplitInterval = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InstantSplitInterval |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryStatistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EstimatedSeriesCount", wireType)
			}
			m.EstimatedSeriesCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EstimatedSeriesCount |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CachedHTTPResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CachedHTTPResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CachedHTTPResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CacheKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CacheKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatusCode", wireType)
			}
			m.StatusCode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StatusCode |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Headers = append(m.Headers, &CachedHTTPHeader{})
			if err := m.Headers[len(m.Headers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Body", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Body = append(m.Body[:0], dAtA[iNdEx:postIndex]...)
			if m.Body == nil {
				m.Body = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CachedHTTPHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowModel
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CachedHTTPHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CachedHTTPHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowModel
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthModel
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthModel
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipModel(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthModel
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipModel(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowModel
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowModel
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowModel
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthModel
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupModel
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthModel
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthModel        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowModel          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupModel = fmt.Errorf("proto: unexpected end of group")
)
