// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: alerts.proto

package alertspb

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	clusterpb "github.com/prometheus/alertmanager/cluster/clusterpb"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type AlertConfigDesc struct {
	User      string          `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	RawConfig string          `protobuf:"bytes,2,opt,name=raw_config,json=rawConfig,proto3" json:"raw_config,omitempty"`
	Templates []*TemplateDesc `protobuf:"bytes,3,rep,name=templates,proto3" json:"templates,omitempty"`
}

func (m *AlertConfigDesc) Reset()      { *m = AlertConfigDesc{} }
func (*AlertConfigDesc) ProtoMessage() {}
func (*AlertConfigDesc) Descriptor() ([]byte, []int) {
	return fileDescriptor_20493709c38b81dc, []int{0}
}
func (m *AlertConfigDesc) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AlertConfigDesc) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AlertConfigDesc.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AlertConfigDesc) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AlertConfigDesc.Merge(m, src)
}
func (m *AlertConfigDesc) XXX_Size() int {
	return m.Size()
}
func (m *AlertConfigDesc) XXX_DiscardUnknown() {
	xxx_messageInfo_AlertConfigDesc.DiscardUnknown(m)
}

var xxx_messageInfo_AlertConfigDesc proto.InternalMessageInfo

func (m *AlertConfigDesc) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *AlertConfigDesc) GetRawConfig() string {
	if m != nil {
		return m.RawConfig
	}
	return ""
}

func (m *AlertConfigDesc) GetTemplates() []*TemplateDesc {
	if m != nil {
		return m.Templates
	}
	return nil
}

type TemplateDesc struct {
	Filename string `protobuf:"bytes,1,opt,name=filename,proto3" json:"filename,omitempty"`
	Body     string `protobuf:"bytes,2,opt,name=body,proto3" json:"body,omitempty"`
}

func (m *TemplateDesc) Reset()      { *m = TemplateDesc{} }
func (*TemplateDesc) ProtoMessage() {}
func (*TemplateDesc) Descriptor() ([]byte, []int) {
	return fileDescriptor_20493709c38b81dc, []int{1}
}
func (m *TemplateDesc) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TemplateDesc) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TemplateDesc.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TemplateDesc) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TemplateDesc.Merge(m, src)
}
func (m *TemplateDesc) XXX_Size() int {
	return m.Size()
}
func (m *TemplateDesc) XXX_DiscardUnknown() {
	xxx_messageInfo_TemplateDesc.DiscardUnknown(m)
}

var xxx_messageInfo_TemplateDesc proto.InternalMessageInfo

func (m *TemplateDesc) GetFilename() string {
	if m != nil {
		return m.Filename
	}
	return ""
}

func (m *TemplateDesc) GetBody() string {
	if m != nil {
		return m.Body
	}
	return ""
}

type FullStateDesc struct {
	State *clusterpb.FullState `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
}

func (m *FullStateDesc) Reset()      { *m = FullStateDesc{} }
func (*FullStateDesc) ProtoMessage() {}
func (*FullStateDesc) Descriptor() ([]byte, []int) {
	return fileDescriptor_20493709c38b81dc, []int{2}
}
func (m *FullStateDesc) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FullStateDesc) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FullStateDesc.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FullStateDesc) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FullStateDesc.Merge(m, src)
}
func (m *FullStateDesc) XXX_Size() int {
	return m.Size()
}
func (m *FullStateDesc) XXX_DiscardUnknown() {
	xxx_messageInfo_FullStateDesc.DiscardUnknown(m)
}

var xxx_messageInfo_FullStateDesc proto.InternalMessageInfo

func (m *FullStateDesc) GetState() *clusterpb.FullState {
	if m != nil {
		return m.State
	}
	return nil
}

type GrafanaAlertConfigDesc struct {
	User               string      `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	RawConfig          string      `protobuf:"bytes,2,opt,name=raw_config,json=rawConfig,proto3" json:"raw_config,omitempty"`
	Hash               string      `protobuf:"bytes,4,opt,name=hash,proto3" json:"hash,omitempty"`
	CreatedAtTimestamp int64       `protobuf:"varint,5,opt,name=created_at_timestamp,json=createdAtTimestamp,proto3" json:"created_at_timestamp,omitempty"`
	Default            bool        `protobuf:"varint,7,opt,name=default,proto3" json:"default,omitempty"`
	Promoted           bool        `protobuf:"varint,8,opt,name=promoted,proto3" json:"promoted,omitempty"`
	ExternalUrl        string      `protobuf:"bytes,9,opt,name=external_url,json=externalUrl,proto3" json:"external_url,omitempty"`
	SmtpConfig         *SmtpConfig `protobuf:"bytes,12,opt,name=smtp_config,json=smtpConfig,proto3" json:"smtp_config,omitempty"`
	// TODO: Deprecate and re-order once everything is sent in SmtpConfig.
	StaticHeaders map[string]string `protobuf:"bytes,10,rep,name=static_headers,json=staticHeaders,proto3" json:"static_headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	SmtpFrom      string            `protobuf:"bytes,11,opt,name=smtp_from,json=smtpFrom,proto3" json:"smtp_from,omitempty"`
}

func (m *GrafanaAlertConfigDesc) Reset()      { *m = GrafanaAlertConfigDesc{} }
func (*GrafanaAlertConfigDesc) ProtoMessage() {}
func (*GrafanaAlertConfigDesc) Descriptor() ([]byte, []int) {
	return fileDescriptor_20493709c38b81dc, []int{3}
}
func (m *GrafanaAlertConfigDesc) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GrafanaAlertConfigDesc) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GrafanaAlertConfigDesc.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GrafanaAlertConfigDesc) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GrafanaAlertConfigDesc.Merge(m, src)
}
func (m *GrafanaAlertConfigDesc) XXX_Size() int {
	return m.Size()
}
func (m *GrafanaAlertConfigDesc) XXX_DiscardUnknown() {
	xxx_messageInfo_GrafanaAlertConfigDesc.DiscardUnknown(m)
}

var xxx_messageInfo_GrafanaAlertConfigDesc proto.InternalMessageInfo

func (m *GrafanaAlertConfigDesc) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *GrafanaAlertConfigDesc) GetRawConfig() string {
	if m != nil {
		return m.RawConfig
	}
	return ""
}

func (m *GrafanaAlertConfigDesc) GetHash() string {
	if m != nil {
		return m.Hash
	}
	return ""
}

func (m *GrafanaAlertConfigDesc) GetCreatedAtTimestamp() int64 {
	if m != nil {
		return m.CreatedAtTimestamp
	}
	return 0
}

func (m *GrafanaAlertConfigDesc) GetDefault() bool {
	if m != nil {
		return m.Default
	}
	return false
}

func (m *GrafanaAlertConfigDesc) GetPromoted() bool {
	if m != nil {
		return m.Promoted
	}
	return false
}

func (m *GrafanaAlertConfigDesc) GetExternalUrl() string {
	if m != nil {
		return m.ExternalUrl
	}
	return ""
}

func (m *GrafanaAlertConfigDesc) GetSmtpConfig() *SmtpConfig {
	if m != nil {
		return m.SmtpConfig
	}
	return nil
}

func (m *GrafanaAlertConfigDesc) GetStaticHeaders() map[string]string {
	if m != nil {
		return m.StaticHeaders
	}
	return nil
}

func (m *GrafanaAlertConfigDesc) GetSmtpFrom() string {
	if m != nil {
		return m.SmtpFrom
	}
	return ""
}

type SmtpConfig struct {
	EhloIdentity   string            `protobuf:"bytes,1,opt,name=ehlo_identity,json=ehloIdentity,proto3" json:"ehlo_identity,omitempty"`
	FromAddress    string            `protobuf:"bytes,2,opt,name=from_address,json=fromAddress,proto3" json:"from_address,omitempty"`
	FromName       string            `protobuf:"bytes,3,opt,name=from_name,json=fromName,proto3" json:"from_name,omitempty"`
	Host           string            `protobuf:"bytes,4,opt,name=host,proto3" json:"host,omitempty"`
	Password       string            `protobuf:"bytes,5,opt,name=password,proto3" json:"password,omitempty"`
	SkipVerify     bool              `protobuf:"varint,6,opt,name=skip_verify,json=skipVerify,proto3" json:"skip_verify,omitempty"`
	StartTlsPolicy string            `protobuf:"bytes,7,opt,name=start_tls_policy,json=startTlsPolicy,proto3" json:"start_tls_policy,omitempty"`
	StaticHeaders  map[string]string `protobuf:"bytes,8,rep,name=static_headers,json=staticHeaders,proto3" json:"static_headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	User           string            `protobuf:"bytes,9,opt,name=user,proto3" json:"user,omitempty"`
}

func (m *SmtpConfig) Reset()      { *m = SmtpConfig{} }
func (*SmtpConfig) ProtoMessage() {}
func (*SmtpConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_20493709c38b81dc, []int{4}
}
func (m *SmtpConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SmtpConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SmtpConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SmtpConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SmtpConfig.Merge(m, src)
}
func (m *SmtpConfig) XXX_Size() int {
	return m.Size()
}
func (m *SmtpConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SmtpConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SmtpConfig proto.InternalMessageInfo

func (m *SmtpConfig) GetEhloIdentity() string {
	if m != nil {
		return m.EhloIdentity
	}
	return ""
}

func (m *SmtpConfig) GetFromAddress() string {
	if m != nil {
		return m.FromAddress
	}
	return ""
}

func (m *SmtpConfig) GetFromName() string {
	if m != nil {
		return m.FromName
	}
	return ""
}

func (m *SmtpConfig) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *SmtpConfig) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func (m *SmtpConfig) GetSkipVerify() bool {
	if m != nil {
		return m.SkipVerify
	}
	return false
}

func (m *SmtpConfig) GetStartTlsPolicy() string {
	if m != nil {
		return m.StartTlsPolicy
	}
	return ""
}

func (m *SmtpConfig) GetStaticHeaders() map[string]string {
	if m != nil {
		return m.StaticHeaders
	}
	return nil
}

func (m *SmtpConfig) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func init() {
	proto.RegisterType((*AlertConfigDesc)(nil), "alerts.AlertConfigDesc")
	proto.RegisterType((*TemplateDesc)(nil), "alerts.TemplateDesc")
	proto.RegisterType((*FullStateDesc)(nil), "alerts.FullStateDesc")
	proto.RegisterType((*GrafanaAlertConfigDesc)(nil), "alerts.GrafanaAlertConfigDesc")
	proto.RegisterMapType((map[string]string)(nil), "alerts.GrafanaAlertConfigDesc.StaticHeadersEntry")
	proto.RegisterType((*SmtpConfig)(nil), "alerts.SmtpConfig")
	proto.RegisterMapType((map[string]string)(nil), "alerts.SmtpConfig.StaticHeadersEntry")
}

func init() { proto.RegisterFile("alerts.proto", fileDescriptor_20493709c38b81dc) }

var fileDescriptor_20493709c38b81dc = []byte{
	// 695 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x54, 0x4f, 0x4f, 0xdb, 0x4a,
	0x10, 0x8f, 0x71, 0x80, 0x78, 0x12, 0x78, 0x68, 0x15, 0x3d, 0x59, 0x79, 0x7a, 0x26, 0x2f, 0x4f,
	0x95, 0xa2, 0x1e, 0x92, 0x16, 0x2e, 0x15, 0x07, 0xd4, 0xd0, 0x96, 0xfe, 0x51, 0x55, 0x55, 0x86,
	0x56, 0x55, 0x2f, 0xd6, 0x26, 0xde, 0x24, 0x16, 0xeb, 0xac, 0xb5, 0xbb, 0x06, 0x72, 0xeb, 0x47,
	0xe0, 0x23, 0xf4, 0xd8, 0x8f, 0xd2, 0x23, 0x47, 0x8e, 0xc5, 0xf4, 0xc0, 0x91, 0x8f, 0x50, 0xed,
	0xae, 0xed, 0x20, 0xd1, 0x43, 0xa5, 0xf6, 0x94, 0x99, 0xdf, 0xcc, 0x6f, 0x76, 0x66, 0x7e, 0xe3,
	0x40, 0x03, 0x53, 0xc2, 0xa5, 0xe8, 0x25, 0x9c, 0x49, 0x86, 0x56, 0x8c, 0xd7, 0x6a, 0x4e, 0xd8,
	0x84, 0x69, 0xa8, 0xaf, 0x2c, 0x13, 0x6d, 0xed, 0x4d, 0x22, 0x39, 0x4d, 0x87, 0xbd, 0x11, 0x8b,
	0xfb, 0x09, 0x67, 0x31, 0x91, 0x53, 0x92, 0x8a, 0xbe, 0xe6, 0xc4, 0x78, 0x86, 0x27, 0x84, 0xf7,
	0x47, 0x34, 0x15, 0x72, 0xf1, 0x9b, 0x0c, 0x0b, 0xcb, 0xd4, 0xe8, 0x9c, 0xc2, 0x5f, 0x03, 0x95,
	0xff, 0x84, 0xcd, 0xc6, 0xd1, 0xe4, 0x29, 0x11, 0x23, 0x84, 0xa0, 0x9a, 0x0a, 0xc2, 0x5d, 0xab,
	0x6d, 0x75, 0x1d, 0x5f, 0xdb, 0xe8, 0x5f, 0x00, 0x8e, 0x4f, 0x82, 0x91, 0xce, 0x72, 0x97, 0x74,
	0xc4, 0xe1, 0xf8, 0xc4, 0xd0, 0xd0, 0x16, 0x38, 0x92, 0xc4, 0x09, 0xc5, 0x92, 0x08, 0xd7, 0x6e,
	0xdb, 0xdd, 0xfa, 0x56, 0xb3, 0x97, 0x4f, 0x72, 0x98, 0x07, 0x54, 0x6d, 0x7f, 0x91, 0xd6, 0xd9,
	0x85, 0xc6, 0xed, 0x10, 0x6a, 0x41, 0x6d, 0x1c, 0x51, 0x32, 0xc3, 0x31, 0xc9, 0x9f, 0x2e, 0x7d,
	0xd5, 0xd2, 0x90, 0x85, 0xf3, 0xfc, 0x61, 0x6d, 0x77, 0x06, 0xb0, 0xb6, 0x9f, 0x52, 0x7a, 0x20,
	0x8b, 0x02, 0xf7, 0x61, 0x59, 0x28, 0x47, 0xb3, 0x55, 0x03, 0xe5, 0xcc, 0xbd, 0x32, 0xd1, 0x37,
	0x29, 0x3b, 0xd5, 0xeb, 0xcf, 0x9b, 0x95, 0xce, 0x77, 0x1b, 0xfe, 0x7e, 0xce, 0xf1, 0x18, 0xcf,
	0xf0, 0x1f, 0x58, 0x02, 0x82, 0xea, 0x14, 0x8b, 0xa9, 0x5b, 0x35, 0x14, 0x65, 0xa3, 0x07, 0xd0,
	0x1c, 0x71, 0x82, 0x25, 0x09, 0x03, 0x2c, 0x03, 0x19, 0xc5, 0x44, 0x48, 0x1c, 0x27, 0xee, 0x72,
	0xdb, 0xea, 0xda, 0x3e, 0xca, 0x63, 0x03, 0x79, 0x58, 0x44, 0x90, 0x0b, 0xab, 0x21, 0x19, 0xe3,
	0x94, 0x4a, 0x77, 0xb5, 0x6d, 0x75, 0x6b, 0x7e, 0xe1, 0xaa, 0x05, 0x29, 0x95, 0x99, 0x24, 0xa1,
	0x5b, 0xd3, 0xa1, 0xd2, 0x47, 0xff, 0x41, 0x83, 0x9c, 0x4a, 0xc2, 0x67, 0x98, 0x06, 0x29, 0xa7,
	0xae, 0xa3, 0x7b, 0xa8, 0x17, 0xd8, 0x3b, 0x4e, 0xd1, 0x36, 0xd4, 0x45, 0x2c, 0x93, 0xa2, 0xfd,
	0x86, 0x5e, 0x12, 0x2a, 0x54, 0x3a, 0x88, 0x65, 0x62, 0xe6, 0xf0, 0x41, 0x94, 0x36, 0xfa, 0x00,
	0xeb, 0x6a, 0x61, 0xd1, 0x28, 0x98, 0x12, 0x1c, 0x12, 0x2e, 0x5c, 0xd0, 0xea, 0x3e, 0x2c, 0x78,
	0x3f, 0x5f, 0x5f, 0xef, 0x40, 0x93, 0x5e, 0x18, 0xce, 0xb3, 0x99, 0xe4, 0x73, 0x7f, 0x4d, 0xdc,
	0xc6, 0xd0, 0x3f, 0xe0, 0xe8, 0x76, 0xc6, 0x9c, 0xc5, 0x6e, 0xdd, 0xe8, 0xad, 0x80, 0x7d, 0xce,
	0xe2, 0xd6, 0x63, 0x40, 0x77, 0x2b, 0xa0, 0x0d, 0xb0, 0x8f, 0xc8, 0x3c, 0x97, 0x44, 0x99, 0xa8,
	0x09, 0xcb, 0xc7, 0x98, 0xa6, 0x24, 0x17, 0xc3, 0x38, 0x3b, 0x4b, 0x8f, 0x2c, 0x23, 0xf0, 0xab,
	0x6a, 0xcd, 0xde, 0xa8, 0x76, 0xce, 0x6c, 0x80, 0xc5, 0x7c, 0xe8, 0x7f, 0x58, 0x23, 0x53, 0xca,
	0x82, 0x28, 0x24, 0x33, 0x19, 0xc9, 0xa2, 0x60, 0x43, 0x81, 0x2f, 0x73, 0x4c, 0x2d, 0x54, 0x75,
	0x16, 0xe0, 0x30, 0xe4, 0x44, 0x88, 0xfc, 0x81, 0xba, 0xc2, 0x06, 0x06, 0x52, 0x13, 0xe8, 0x14,
	0x7d, 0xb1, 0x76, 0x7e, 0xb1, 0x9c, 0xc5, 0x6f, 0xf2, 0x8b, 0x9d, 0x32, 0x21, 0xcb, 0x63, 0x60,
	0xc2, 0x08, 0x88, 0x85, 0x38, 0x61, 0x3c, 0xd4, 0x07, 0xe0, 0xf8, 0xa5, 0x8f, 0x36, 0xa1, 0x2e,
	0x8e, 0xa2, 0x24, 0x38, 0x26, 0x3c, 0x1a, 0xcf, 0xdd, 0x15, 0xad, 0x2f, 0x28, 0xe8, 0xbd, 0x46,
	0x50, 0x17, 0x36, 0x84, 0xc4, 0x5c, 0x06, 0x92, 0x8a, 0x20, 0x61, 0x34, 0x1a, 0xcd, 0xf5, 0x81,
	0x38, 0xfe, 0xba, 0xc6, 0x0f, 0xa9, 0x78, 0xab, 0x51, 0xf4, 0xfa, 0x8e, 0x66, 0x35, 0xad, 0xd9,
	0xbd, 0xbb, 0x5a, 0xff, 0x82, 0x4e, 0xc5, 0x87, 0xe0, 0x2c, 0x3e, 0x84, 0xdf, 0x97, 0x67, 0x6f,
	0xf7, 0xfc, 0xd2, 0xab, 0x5c, 0x5c, 0x7a, 0x95, 0x9b, 0x4b, 0xcf, 0xfa, 0x94, 0x79, 0xd6, 0x97,
	0xcc, 0xb3, 0xbe, 0x66, 0x9e, 0x75, 0x9e, 0x79, 0xd6, 0xb7, 0xcc, 0xb3, 0xae, 0x33, 0xaf, 0x72,
	0x93, 0x79, 0xd6, 0xd9, 0x95, 0x57, 0x39, 0xbf, 0xf2, 0x2a, 0x17, 0x57, 0x5e, 0xe5, 0x63, 0xcd,
	0x0c, 0x90, 0x0c, 0x87, 0x2b, 0xfa, 0xdf, 0x6b, 0xfb, 0x47, 0x00, 0x00, 0x00, 0xff, 0xff, 0x07,
	0x3c, 0xb3, 0xad, 0x2f, 0x05, 0x00, 0x00,
}

func (this *AlertConfigDesc) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AlertConfigDesc)
	if !ok {
		that2, ok := that.(AlertConfigDesc)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.User != that1.User {
		return false
	}
	if this.RawConfig != that1.RawConfig {
		return false
	}
	if len(this.Templates) != len(that1.Templates) {
		return false
	}
	for i := range this.Templates {
		if !this.Templates[i].Equal(that1.Templates[i]) {
			return false
		}
	}
	return true
}
func (this *TemplateDesc) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TemplateDesc)
	if !ok {
		that2, ok := that.(TemplateDesc)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Filename != that1.Filename {
		return false
	}
	if this.Body != that1.Body {
		return false
	}
	return true
}
func (this *SmtpConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SmtpConfig)
	if !ok {
		that2, ok := that.(SmtpConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.EhloIdentity != that1.EhloIdentity {
		return false
	}
	if this.FromAddress != that1.FromAddress {
		return false
	}
	if this.FromName != that1.FromName {
		return false
	}
	if this.Host != that1.Host {
		return false
	}
	if this.Password != that1.Password {
		return false
	}
	if this.SkipVerify != that1.SkipVerify {
		return false
	}
	if this.StartTlsPolicy != that1.StartTlsPolicy {
		return false
	}
	if len(this.StaticHeaders) != len(that1.StaticHeaders) {
		return false
	}
	for i := range this.StaticHeaders {
		if this.StaticHeaders[i] != that1.StaticHeaders[i] {
			return false
		}
	}
	if this.User != that1.User {
		return false
	}
	return true
}
func (this *AlertConfigDesc) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&alertspb.AlertConfigDesc{")
	s = append(s, "User: "+fmt.Sprintf("%#v", this.User)+",\n")
	s = append(s, "RawConfig: "+fmt.Sprintf("%#v", this.RawConfig)+",\n")
	if this.Templates != nil {
		s = append(s, "Templates: "+fmt.Sprintf("%#v", this.Templates)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TemplateDesc) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&alertspb.TemplateDesc{")
	s = append(s, "Filename: "+fmt.Sprintf("%#v", this.Filename)+",\n")
	s = append(s, "Body: "+fmt.Sprintf("%#v", this.Body)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *FullStateDesc) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&alertspb.FullStateDesc{")
	if this.State != nil {
		s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GrafanaAlertConfigDesc) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 14)
	s = append(s, "&alertspb.GrafanaAlertConfigDesc{")
	s = append(s, "User: "+fmt.Sprintf("%#v", this.User)+",\n")
	s = append(s, "RawConfig: "+fmt.Sprintf("%#v", this.RawConfig)+",\n")
	s = append(s, "Hash: "+fmt.Sprintf("%#v", this.Hash)+",\n")
	s = append(s, "CreatedAtTimestamp: "+fmt.Sprintf("%#v", this.CreatedAtTimestamp)+",\n")
	s = append(s, "Default: "+fmt.Sprintf("%#v", this.Default)+",\n")
	s = append(s, "Promoted: "+fmt.Sprintf("%#v", this.Promoted)+",\n")
	s = append(s, "ExternalUrl: "+fmt.Sprintf("%#v", this.ExternalUrl)+",\n")
	if this.SmtpConfig != nil {
		s = append(s, "SmtpConfig: "+fmt.Sprintf("%#v", this.SmtpConfig)+",\n")
	}
	keysForStaticHeaders := make([]string, 0, len(this.StaticHeaders))
	for k, _ := range this.StaticHeaders {
		keysForStaticHeaders = append(keysForStaticHeaders, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForStaticHeaders)
	mapStringForStaticHeaders := "map[string]string{"
	for _, k := range keysForStaticHeaders {
		mapStringForStaticHeaders += fmt.Sprintf("%#v: %#v,", k, this.StaticHeaders[k])
	}
	mapStringForStaticHeaders += "}"
	if this.StaticHeaders != nil {
		s = append(s, "StaticHeaders: "+mapStringForStaticHeaders+",\n")
	}
	s = append(s, "SmtpFrom: "+fmt.Sprintf("%#v", this.SmtpFrom)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SmtpConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 13)
	s = append(s, "&alertspb.SmtpConfig{")
	s = append(s, "EhloIdentity: "+fmt.Sprintf("%#v", this.EhloIdentity)+",\n")
	s = append(s, "FromAddress: "+fmt.Sprintf("%#v", this.FromAddress)+",\n")
	s = append(s, "FromName: "+fmt.Sprintf("%#v", this.FromName)+",\n")
	s = append(s, "Host: "+fmt.Sprintf("%#v", this.Host)+",\n")
	s = append(s, "Password: "+fmt.Sprintf("%#v", this.Password)+",\n")
	s = append(s, "SkipVerify: "+fmt.Sprintf("%#v", this.SkipVerify)+",\n")
	s = append(s, "StartTlsPolicy: "+fmt.Sprintf("%#v", this.StartTlsPolicy)+",\n")
	keysForStaticHeaders := make([]string, 0, len(this.StaticHeaders))
	for k, _ := range this.StaticHeaders {
		keysForStaticHeaders = append(keysForStaticHeaders, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForStaticHeaders)
	mapStringForStaticHeaders := "map[string]string{"
	for _, k := range keysForStaticHeaders {
		mapStringForStaticHeaders += fmt.Sprintf("%#v: %#v,", k, this.StaticHeaders[k])
	}
	mapStringForStaticHeaders += "}"
	if this.StaticHeaders != nil {
		s = append(s, "StaticHeaders: "+mapStringForStaticHeaders+",\n")
	}
	s = append(s, "User: "+fmt.Sprintf("%#v", this.User)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringAlerts(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *AlertConfigDesc) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AlertConfigDesc) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AlertConfigDesc) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Templates) > 0 {
		for iNdEx := len(m.Templates) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Templates[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAlerts(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.RawConfig) > 0 {
		i -= len(m.RawConfig)
		copy(dAtA[i:], m.RawConfig)
		i = encodeVarintAlerts(dAtA, i, uint64(len(m.RawConfig)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.User) > 0 {
		i -= len(m.User)
		copy(dAtA[i:], m.User)
		i = encodeVarintAlerts(dAtA, i, uint64(len(m.User)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TemplateDesc) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TemplateDesc) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TemplateDesc) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Body) > 0 {
		i -= len(m.Body)
		copy(dAtA[i:], m.Body)
		i = encodeVarintAlerts(dAtA, i, uint64(len(m.Body)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Filename) > 0 {
		i -= len(m.Filename)
		copy(dAtA[i:], m.Filename)
		i = encodeVarintAlerts(dAtA, i, uint64(len(m.Filename)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *FullStateDesc) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FullStateDesc) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FullStateDesc) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.State != nil {
		{
			size, err := m.State.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlerts(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GrafanaAlertConfigDesc) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GrafanaAlertConfigDesc) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GrafanaAlertConfigDesc) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.SmtpConfig != nil {
		{
			size, err := m.SmtpConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAlerts(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if len(m.SmtpFrom) > 0 {
		i -= len(m.SmtpFrom)
		copy(dAtA[i:], m.SmtpFrom)
		i = encodeVarintAlerts(dAtA, i, uint64(len(m.SmtpFrom)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.StaticHeaders) > 0 {
		for k := range m.StaticHeaders {
			v := m.StaticHeaders[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintAlerts(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAlerts(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAlerts(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x52
		}
	}
	if len(m.ExternalUrl) > 0 {
		i -= len(m.ExternalUrl)
		copy(dAtA[i:], m.ExternalUrl)
		i = encodeVarintAlerts(dAtA, i, uint64(len(m.ExternalUrl)))
		i--
		dAtA[i] = 0x4a
	}
	if m.Promoted {
		i--
		if m.Promoted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.Default {
		i--
		if m.Default {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.CreatedAtTimestamp != 0 {
		i = encodeVarintAlerts(dAtA, i, uint64(m.CreatedAtTimestamp))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Hash) > 0 {
		i -= len(m.Hash)
		copy(dAtA[i:], m.Hash)
		i = encodeVarintAlerts(dAtA, i, uint64(len(m.Hash)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.RawConfig) > 0 {
		i -= len(m.RawConfig)
		copy(dAtA[i:], m.RawConfig)
		i = encodeVarintAlerts(dAtA, i, uint64(len(m.RawConfig)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.User) > 0 {
		i -= len(m.User)
		copy(dAtA[i:], m.User)
		i = encodeVarintAlerts(dAtA, i, uint64(len(m.User)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SmtpConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SmtpConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SmtpConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.User) > 0 {
		i -= len(m.User)
		copy(dAtA[i:], m.User)
		i = encodeVarintAlerts(dAtA, i, uint64(len(m.User)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.StaticHeaders) > 0 {
		for k := range m.StaticHeaders {
			v := m.StaticHeaders[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintAlerts(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAlerts(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAlerts(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.StartTlsPolicy) > 0 {
		i -= len(m.StartTlsPolicy)
		copy(dAtA[i:], m.StartTlsPolicy)
		i = encodeVarintAlerts(dAtA, i, uint64(len(m.StartTlsPolicy)))
		i--
		dAtA[i] = 0x3a
	}
	if m.SkipVerify {
		i--
		if m.SkipVerify {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if len(m.Password) > 0 {
		i -= len(m.Password)
		copy(dAtA[i:], m.Password)
		i = encodeVarintAlerts(dAtA, i, uint64(len(m.Password)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Host) > 0 {
		i -= len(m.Host)
		copy(dAtA[i:], m.Host)
		i = encodeVarintAlerts(dAtA, i, uint64(len(m.Host)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.FromName) > 0 {
		i -= len(m.FromName)
		copy(dAtA[i:], m.FromName)
		i = encodeVarintAlerts(dAtA, i, uint64(len(m.FromName)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.FromAddress) > 0 {
		i -= len(m.FromAddress)
		copy(dAtA[i:], m.FromAddress)
		i = encodeVarintAlerts(dAtA, i, uint64(len(m.FromAddress)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.EhloIdentity) > 0 {
		i -= len(m.EhloIdentity)
		copy(dAtA[i:], m.EhloIdentity)
		i = encodeVarintAlerts(dAtA, i, uint64(len(m.EhloIdentity)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintAlerts(dAtA []byte, offset int, v uint64) int {
	offset -= sovAlerts(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *AlertConfigDesc) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.User)
	if l > 0 {
		n += 1 + l + sovAlerts(uint64(l))
	}
	l = len(m.RawConfig)
	if l > 0 {
		n += 1 + l + sovAlerts(uint64(l))
	}
	if len(m.Templates) > 0 {
		for _, e := range m.Templates {
			l = e.Size()
			n += 1 + l + sovAlerts(uint64(l))
		}
	}
	return n
}

func (m *TemplateDesc) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Filename)
	if l > 0 {
		n += 1 + l + sovAlerts(uint64(l))
	}
	l = len(m.Body)
	if l > 0 {
		n += 1 + l + sovAlerts(uint64(l))
	}
	return n
}

func (m *FullStateDesc) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.State != nil {
		l = m.State.Size()
		n += 1 + l + sovAlerts(uint64(l))
	}
	return n
}

func (m *GrafanaAlertConfigDesc) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.User)
	if l > 0 {
		n += 1 + l + sovAlerts(uint64(l))
	}
	l = len(m.RawConfig)
	if l > 0 {
		n += 1 + l + sovAlerts(uint64(l))
	}
	l = len(m.Hash)
	if l > 0 {
		n += 1 + l + sovAlerts(uint64(l))
	}
	if m.CreatedAtTimestamp != 0 {
		n += 1 + sovAlerts(uint64(m.CreatedAtTimestamp))
	}
	if m.Default {
		n += 2
	}
	if m.Promoted {
		n += 2
	}
	l = len(m.ExternalUrl)
	if l > 0 {
		n += 1 + l + sovAlerts(uint64(l))
	}
	if len(m.StaticHeaders) > 0 {
		for k, v := range m.StaticHeaders {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAlerts(uint64(len(k))) + 1 + len(v) + sovAlerts(uint64(len(v)))
			n += mapEntrySize + 1 + sovAlerts(uint64(mapEntrySize))
		}
	}
	l = len(m.SmtpFrom)
	if l > 0 {
		n += 1 + l + sovAlerts(uint64(l))
	}
	if m.SmtpConfig != nil {
		l = m.SmtpConfig.Size()
		n += 1 + l + sovAlerts(uint64(l))
	}
	return n
}

func (m *SmtpConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.EhloIdentity)
	if l > 0 {
		n += 1 + l + sovAlerts(uint64(l))
	}
	l = len(m.FromAddress)
	if l > 0 {
		n += 1 + l + sovAlerts(uint64(l))
	}
	l = len(m.FromName)
	if l > 0 {
		n += 1 + l + sovAlerts(uint64(l))
	}
	l = len(m.Host)
	if l > 0 {
		n += 1 + l + sovAlerts(uint64(l))
	}
	l = len(m.Password)
	if l > 0 {
		n += 1 + l + sovAlerts(uint64(l))
	}
	if m.SkipVerify {
		n += 2
	}
	l = len(m.StartTlsPolicy)
	if l > 0 {
		n += 1 + l + sovAlerts(uint64(l))
	}
	if len(m.StaticHeaders) > 0 {
		for k, v := range m.StaticHeaders {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAlerts(uint64(len(k))) + 1 + len(v) + sovAlerts(uint64(len(v)))
			n += mapEntrySize + 1 + sovAlerts(uint64(mapEntrySize))
		}
	}
	l = len(m.User)
	if l > 0 {
		n += 1 + l + sovAlerts(uint64(l))
	}
	return n
}

func sovAlerts(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozAlerts(x uint64) (n int) {
	return sovAlerts(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *AlertConfigDesc) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForTemplates := "[]*TemplateDesc{"
	for _, f := range this.Templates {
		repeatedStringForTemplates += strings.Replace(f.String(), "TemplateDesc", "TemplateDesc", 1) + ","
	}
	repeatedStringForTemplates += "}"
	s := strings.Join([]string{`&AlertConfigDesc{`,
		`User:` + fmt.Sprintf("%v", this.User) + `,`,
		`RawConfig:` + fmt.Sprintf("%v", this.RawConfig) + `,`,
		`Templates:` + repeatedStringForTemplates + `,`,
		`}`,
	}, "")
	return s
}
func (this *TemplateDesc) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TemplateDesc{`,
		`Filename:` + fmt.Sprintf("%v", this.Filename) + `,`,
		`Body:` + fmt.Sprintf("%v", this.Body) + `,`,
		`}`,
	}, "")
	return s
}
func (this *FullStateDesc) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&FullStateDesc{`,
		`State:` + strings.Replace(fmt.Sprintf("%v", this.State), "FullState", "clusterpb.FullState", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GrafanaAlertConfigDesc) String() string {
	if this == nil {
		return "nil"
	}
	keysForStaticHeaders := make([]string, 0, len(this.StaticHeaders))
	for k, _ := range this.StaticHeaders {
		keysForStaticHeaders = append(keysForStaticHeaders, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForStaticHeaders)
	mapStringForStaticHeaders := "map[string]string{"
	for _, k := range keysForStaticHeaders {
		mapStringForStaticHeaders += fmt.Sprintf("%v: %v,", k, this.StaticHeaders[k])
	}
	mapStringForStaticHeaders += "}"
	s := strings.Join([]string{`&GrafanaAlertConfigDesc{`,
		`User:` + fmt.Sprintf("%v", this.User) + `,`,
		`RawConfig:` + fmt.Sprintf("%v", this.RawConfig) + `,`,
		`Hash:` + fmt.Sprintf("%v", this.Hash) + `,`,
		`CreatedAtTimestamp:` + fmt.Sprintf("%v", this.CreatedAtTimestamp) + `,`,
		`Default:` + fmt.Sprintf("%v", this.Default) + `,`,
		`Promoted:` + fmt.Sprintf("%v", this.Promoted) + `,`,
		`ExternalUrl:` + fmt.Sprintf("%v", this.ExternalUrl) + `,`,
		`StaticHeaders:` + mapStringForStaticHeaders + `,`,
		`SmtpFrom:` + fmt.Sprintf("%v", this.SmtpFrom) + `,`,
		`SmtpConfig:` + strings.Replace(this.SmtpConfig.String(), "SmtpConfig", "SmtpConfig", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SmtpConfig) String() string {
	if this == nil {
		return "nil"
	}
	keysForStaticHeaders := make([]string, 0, len(this.StaticHeaders))
	for k, _ := range this.StaticHeaders {
		keysForStaticHeaders = append(keysForStaticHeaders, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForStaticHeaders)
	mapStringForStaticHeaders := "map[string]string{"
	for _, k := range keysForStaticHeaders {
		mapStringForStaticHeaders += fmt.Sprintf("%v: %v,", k, this.StaticHeaders[k])
	}
	mapStringForStaticHeaders += "}"
	s := strings.Join([]string{`&SmtpConfig{`,
		`EhloIdentity:` + fmt.Sprintf("%v", this.EhloIdentity) + `,`,
		`FromAddress:` + fmt.Sprintf("%v", this.FromAddress) + `,`,
		`FromName:` + fmt.Sprintf("%v", this.FromName) + `,`,
		`Host:` + fmt.Sprintf("%v", this.Host) + `,`,
		`Password:` + fmt.Sprintf("%v", this.Password) + `,`,
		`SkipVerify:` + fmt.Sprintf("%v", this.SkipVerify) + `,`,
		`StartTlsPolicy:` + fmt.Sprintf("%v", this.StartTlsPolicy) + `,`,
		`StaticHeaders:` + mapStringForStaticHeaders + `,`,
		`User:` + fmt.Sprintf("%v", this.User) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringAlerts(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *AlertConfigDesc) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlerts
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AlertConfigDesc: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AlertConfigDesc: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawConfig", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RawConfig = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Templates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Templates = append(m.Templates, &TemplateDesc{})
			if err := m.Templates[len(m.Templates)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlerts(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlerts
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TemplateDesc) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlerts
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TemplateDesc: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TemplateDesc: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filename", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filename = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Body", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Body = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlerts(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlerts
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FullStateDesc) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlerts
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FullStateDesc: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FullStateDesc: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.State == nil {
				m.State = &clusterpb.FullState{}
			}
			if err := m.State.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlerts(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlerts
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GrafanaAlertConfigDesc) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlerts
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GrafanaAlertConfigDesc: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GrafanaAlertConfigDesc: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawConfig", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RawConfig = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hash", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hash = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAtTimestamp", wireType)
			}
			m.CreatedAtTimestamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CreatedAtTimestamp |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Default", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Default = bool(v != 0)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Promoted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Promoted = bool(v != 0)
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExternalUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExternalUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StaticHeaders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StaticHeaders == nil {
				m.StaticHeaders = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAlerts
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAlerts
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAlerts
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthAlerts
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAlerts
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthAlerts
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthAlerts
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAlerts(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthAlerts
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.StaticHeaders[mapkey] = mapvalue
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SmtpFrom", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SmtpFrom = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SmtpConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SmtpConfig == nil {
				m.SmtpConfig = &SmtpConfig{}
			}
			if err := m.SmtpConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlerts(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlerts
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SmtpConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAlerts
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SmtpConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SmtpConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EhloIdentity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EhloIdentity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FromAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FromAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FromName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FromName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Host", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Host = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Password", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Password = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SkipVerify", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SkipVerify = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTlsPolicy", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTlsPolicy = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StaticHeaders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StaticHeaders == nil {
				m.StaticHeaders = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAlerts
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAlerts
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAlerts
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthAlerts
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAlerts
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthAlerts
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthAlerts
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAlerts(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthAlerts
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.StaticHeaders[mapkey] = mapvalue
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAlerts
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAlerts
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAlerts(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthAlerts
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAlerts(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAlerts
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAlerts
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthAlerts
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupAlerts
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthAlerts
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthAlerts        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAlerts          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupAlerts = fmt.Errorf("proto: unexpected end of group")
)
