---
description: Release notes for Grafana Mimir version 2.8
menuTitle: V2.8 release notes
title: Grafana Mimir version 2.8 release notes
weight: 300
---

# Grafana Mimir version 2.8 release notes

Grafana Labs is excited to announce version 2.8 of Grafana Mimir.

The highlights that follow include the top features, enhancements, and bugfixes in this release. For the complete list of changes, see the [changelog](https://github.com/grafana/mimir/blob/main/CHANGELOG.md).

## Features and enhancements

- **Experimental support for using Redis as cache** Mimir now can use Redis for caching results, chunks, index and metadata.
- **Experimental support for fetching secret from Vault for TLS configuration**.
- **Experimental support for querying native histograms**. This support is not finalized as the related Prometheus API is also experimental, thus the exact behavior might change in future releases.
- **Query-frontend and ruler now use protobuf internal query result payload format by default** This reduces the CPU and memory utilisation of the querier, query-frontend and ruler, as well as reducing network bandwidth consumed between these components.
- **Query-frontend cached results now contain timestamp** This allows Mimir to check if cached results are still valid based on current TTL configured for tenant. Results cached by previous Mimir version are used until they expire from cache, which can take up to 7 days. If you need to use per-tenant TTL sooner, please flush results cache manually.
- **Optimized regular expression label matchers** This reduces CPU utilisation in ingesters and store-gateways when running queries containing regular expression label matchers.
- **Store-gateway now use streaming for LabelNames RPC** This improves memory utilization in store-gateway when calling LabelNames RPC.

### Helm chart improvements

The Grafana Mimir and Grafana Enterprise Metrics Helm chart is now released independently. See the [Grafana Mimir Helm chart documentation](/docs/helm-charts/mimir-distributed/latest/).

## Important changes

In Grafana Mimir 2.8 we have removed the following previously deprecated or experimental metrics:

- `cortex_bucket_store_series_get_all_duration_seconds`
- `cortex_bucket_store_series_merge_duration_seconds`
- `cortex_ingester_tsdb_wal_replay_duration_seconds`

The following configuration options are deprecated and will be removed in Grafana Mimir 2.10:

- The CLI flag `-blocks-storage.tsdb.max-tsdb-opening-concurrency-on-startup` and its respective YAML configuration option `tsdb.max_tsdb_opening_concurrency_on_startup`.

The following configuration options that were deprecated in 2.6 are removed:

- The CLI flag `-store.max-query-length` and its respective YAML configuration option `limits.max_query_length`.

The following configuration options that were deprecated in 2.5 are removed:

- The CLI flag `-azure.msi-resource`.

The following experimental options and features are now stable:

- The protobuf internal query result payload format, which is now enabled by default

We changed default value of block storage retention period. The default value for `-blocks-storage.tsdb.retention-period` was `24h` and now is `13h`

## Bug fixes

- Querier: Streaming remote read will now continue to return multiple chunks per frame after the first frame. [PR 4423](https://github.com/grafana/mimir/pull/4423)
- Query-frontend: don't retry queries which error inside PromQL. [PR 4643](https://github.com/grafana/mimir/pull/4643)
- Store-gateway & query-frontend: report more consistent statistics for fetched index bytes. [PR 4671](https://github.com/grafana/mimir/pull/4671)
