---
title: "Grafana Mimir Helm chart version 5.0 release notes"
menuTitle: "V5.0 release notes"
description: "Release notes for Grafana Mimir Helm chart version 5.0"
weight: 300
---

# Grafana Mimir Helm chart version 5.0 release notes

Grafana Labs is excited to announce version 5.0 of the Grafana Mimir Helm chart, which is compatible with Grafana Mimir v2.9 or Grafana Enterprise Metrics (GEM) v2.9. The `mimir-distributed` Helm chart is the best way to install Mimir on Kubernetes.

The highlights that follow include the top features, enhancements, and bugfixes in this release. For a comprehensive list of changes, see the [Helm chart changelog](https://github.com/grafana/mimir/tree/main/operations/helm/charts/mimir-distributed/CHANGELOG.md).

> **Note:** For a migration guide from `mimir-distributed` version 4.X to 5.0, see [Migrate the Helm chart from version 4.x to 5.0](../../migration-guides/migrate-helm-chart-4.x-to-5.0/).

## Important changes

- **Breaking change: PodSecurityPolicy objects are no longer rendered on Kubernetes versions 1.24 or higher.** This resource type was deprecated in Kubernetes version 1.21 and was removed in version 1.25. Due to how Helm manages release histories, the `mimir-distributed` Helm chart can no longer be upgraded if a PodSecurityPolicy was present during a Kubernetes upgrade from 1.24 to 1.25. In order to remediate this, `mimir-distributed` no longer renders the PodSecurityPolicy on Kubernetes 1.24. For a migration guide from `mimir-distributed` version 4.X to 5.0, see [Migrate the Helm chart from version 4.x to 5.0](../../migration-guides/migrate-helm-chart-4.x-to-5.0/).

## Features and enhancements

Notable enhancements are as follows:

- Use metadata cache for ruler bucket scans. This greatly reduces pressure to the object store by the ruler.
- Support metricRelabelings in the monitoring serviceMonitor resources via `metaMonitoring.serviceMonitor.metricRelabelings`.
- Increase the default number of ingester Pods that can restart at a time in a multi-zone deployment. This speeds up deployments with more than 25 ingesters per zone.
