---
description: Release notes for Grafana Mimir version 2.6
menuTitle: V2.6 release notes
title: Grafana Mimir version 2.6 release notes
weight: 300
---

# Grafana Mimir version 2.6 release notes

Grafana Labs is excited to announce version 2.6 of Grafana Mimir.

The highlights that follow include the top features, enhancements, and bugfixes in this release. For the complete list of changes, see the [changelog](https://github.com/grafana/mimir/blob/main/CHANGELOG.md).

## Features and enhancements

- **Lower memory usage in store-gateway by streaming series results**
  The store-gateway can now stream results back to the querier instead of buffering them. This is expected to greatly reduce peak memory consumption while keeping latency the same. This is still an **experimental feature** but Grafana Labs is already running it in production and there's no known issue. This feature can be enabled setting the `-blocks-storage.bucket-store.batch-series-size` configuration option (if you want to try it out, we recommend you setting to 5000).

- **Improved stability in store-gateway by removing mmap usage**
  The store-gateway can now use an alternate code path to read index-headers that does not use memory mapped files. This is expected to improve stability of the store-gateway. This is still an **experimental feature** but Grafana Labs is already running it in production and there's no known issue. This feature can be enabled setting `-blocks-storage.bucket-store.index-header.stream-reader-enabled=true`.

### Alertmanager improvements

- **Webex support** Alertmanager can now use Webex to send alerts.

- **tenantID template function** A new template function `tenantID`, returning the ID of the tenant owning the alert, has been added.

- **grafanaExploreURL template function** A new template function `grafanaExploreURL`, returning the URL to the Grafana explore page with range query, has been added.

### Helm chart improvements

The Grafana Mimir and Grafana Enterprise Metrics Helm chart is now released independently. See the [corresponding documentation](/docs/helm-charts/mimir-distributed/latest/) for more information.

## Important changes

In Grafana Mimir 2.6 we have removed the following previously deprecated or experimental configuration options:

- The CLI flag `-blocks-storage.bucket-store.max-concurrent-reject-over-limit` and its respective YAML configuration option `blocks_storage.bucket_store.max_concurrent_reject_over_limit`.
- The CLI flag `-query-frontend.align-querier-with-step` and its respective YAML configuration option `frontend.align_querier_with_step`.

The following configuration options are deprecated and will be removed in Grafana Mimir 2.8:

- The CLI flag `-store.max-query-length` and its respective YAML configuration option `limits.max_query_length` have been replaced with `-querier.max-partial-query-length` and `limits.max_partial_query_length`.

The following experimental options and features are now stable:

- The CLI flag `-query-frontend.max-total-query-length` and its respective YAML configuration option `limits.max_total_query_length`.
- The CLI flags `-distributor.request-rate-limit` and `-distributor.request-burst-limit` and their respective YAML configuration options `limits.request_rate_limit` and `limits.request_rate_burst`.
- The CLI flag `-ingester.max-global-exemplars-per-user` and its respective YAML configuration option `limits.max_global_exemplars_per_user`.
- The CLI flag `-ingester.tsdb-config-update-period` its respective YAML configuration option `ingester.tsdb_config_update_period`.
- The API endpoint `/api/v1/query_exemplars`.

## Bug fixes

- Alertmanager: Fix template spurious deletion with relative data dir. [PR 3604](https://github.com/grafana/mimir/pull/3604)
- Security: Update prometheus/exporter-toolkit for CVE-2022-46146. [PR 3675](https://github.com/grafana/mimir/pull/3675)
- Security: Update golang.org/x/net for CVE-2022-41717. [PR 3755](https://github.com/grafana/mimir/pull/3755)
- Debian package: Fix post-install, environment file path and user creation. [PR 3720](https://github.com/grafana/mimir/pull/3720)
- Memberlist: Fix panic during Mimir startup when Mimir receives gossip message before it's ready. [PR 3746](https://github.com/grafana/mimir/pull/3746)
- Update `github.com/thanos-io/objstore` to address issue with Multipart PUT on s3-compatible Object Storage. [PR 3802](https://github.com/grafana/mimir/pull/3802) [PR 3821](https://github.com/grafana/mimir/pull/3821)
- Querier: Canceled requests are no longer reported as "consistency check" failures. [PR 3837](https://github.com/grafana/mimir/pull/3837) [PR 3927](https://github.com/grafana/mimir/pull/3927)
- Distributor: Don't panic when `metric_relabel_configs` in overrides contains null element. [PR 3868](https://github.com/grafana/mimir/pull/3868)
- Ingester, Compactor: Fix panic that can occur when compaction fails. [PR 3955](https://github.com/grafana/mimir/pull/3955)

### 2.6.1

- Security: updated the Go version to 1.20.3 to fix CVE-2023-24538. [PR 4798](https://github.com/grafana/mimir/pull/4798)

### 2.6.2

- Security: updated Go to version 1.20.4 to fix CVE-2023-24539, CVE-2023-24540, CVE-2023-29400. [PR 4903](https://github.com/grafana/mimir/pull/4903)
