{
  inputs,
  pkgs,
  system,
  ...
}:

let
  apiKeyFilepath = "file.token";
  result = inputs.home-manager-unstable.lib.homeManagerConfiguration {
    pkgs = import inputs.nixpkgs-unstable {
      inherit system;
      config.allowUnfree = true;
      overlays = [
        inputs.self.overlays.flake
      ];
    };
    modules = [
      inputs.self.homeManagerModules.mcps
      {
        home.stateVersion = "25.11";
        home.username = "jdoe";
        home.homeDirectory = "/test";
        programs.claude-code = {
          enable = true;
          mcps.buildkite = {
            enable = true;
            inherit apiKeyFilepath;
          };
        };
      }
    ];
  };
in
{
  tests = [
    {
      name = "command";
      type = "script";
      script = ''
        ${(inputs.nixtest.lib { inherit pkgs; }).helpers.scriptHelpers}
        # Gather the mcp config file that gets generated by home-manager claude-code module.
        MCP_CONFIG="$(cat ${result.config.programs.claude-code.finalPackage}/bin/claude | grep mcp-config | awk '{ print $6 }')"
        CMD_ACTUAL="$(jq -r .mcpServers.buildkite.command $MCP_CONFIG)"
        CMD_EXPECTED="${result.config.programs.claude-code.mcpServers.buildkite.command}"
        if [[ "$CMD_ACTUAL" != "$CMD_EXPECTED" ]]; then
           echo "claude does not have mcp server configured"
           exit 1
        fi 
      '';
    }
    {
      name = "environment vars";
      type = "unit";
      expected = {
        "BUILDKITE_API_TOKEN_FILEPATH" = apiKeyFilepath;
      };
      actual = result.config.programs.claude-code.mcpServers.buildkite.env;
    }
    {
      name = "args";
      type = "unit";
      expected = [ "stdio" ];
      actual = result.config.programs.claude-code.mcpServers.buildkite.args;
    }
  ];
}
