# Metro

[![MIT licensed](https://img.shields.io/badge/license-MIT-blue.svg)](https://github.com/facebook/metro/blob/HEAD/LICENSE)
[![npm package version](https://img.shields.io/npm/v/metro?color=brightgreen)](https://www.npmjs.com/package/metro)
[![Build status](https://circleci.com/gh/facebook/metro.svg?style=shield)](https://circleci.com/gh/facebook/metro)
[![Code coverage](https://codecov.io/gh/facebook/metro/branch/main/graph/badge.svg?token=oMHdoKhFZB)](https://codecov.io/gh/facebook/metro)
[![Follow @MetroBundler on Twitter](https://img.shields.io/twitter/follow/MetroBundler?style=social)](https://twitter.com/intent/follow?screen_name=MetroBundler)

🚇 The JavaScript bundler for React Native.

- **🚅 Fast**: We aim for sub-second reload cycles, fast startup and quick bundling speeds.
- **⚖️ Scalable**: Works with thousands of modules in a single application.
- **⚛️ Integrated**: Supports every React Native project out of the box.

## Installation

Metro is included with React Native — see the [React Native docs](https://reactnative.dev/docs/getting-started) to quickly get started ⏱️.

To add Metro to an existing project, see our [Getting Started guide](https://facebook.github.io/metro/docs/getting-started).

## Documentation

All available documentation, including on [configuring Metro](https://facebook.github.io/metro/docs/configuration), can be found on the [Metro website](https://facebook.github.io/metro/docs/getting-started).

Source code for documentation is located in this repository under `docs/`.

## Contributing

Metro was previously part of the [react-native](https://github.com/facebook/react-native) repository. In this standalone repository it is easier for the team working on Metro to respond to issues and pull requests. See [react-native#13976](https://github.com/facebook/react-native/issues/13976) for the initial announcement.

### [Code of Conduct](https://code.fb.com/codeofconduct)

Meta has adopted a Code of Conduct that we expect project participants to adhere to. Please read [the full text](https://code.fb.com/codeofconduct) so that you can understand what actions will and will not be tolerated.

### [Contributing guide](https://github.com/facebook/metro/blob/main/CONTRIBUTING.md)

Read our [contributing guide](https://github.com/facebook/metro/blob/main/CONTRIBUTING.md) to learn about our development process, how to propose bug fixes and improvements, and how to build and test your changes to Metro.

### Discussions

Larger discussions and proposals concerning React Native and Metro are discussed in [**@react-native-community/discussions-and-proposals**](https://github.com/react-native-community/discussions-and-proposals).

## License

Metro is MIT licensed, as found in the LICENSE file.
