
(function(exports,isomorphicFormData,crossFetch){'use strict';function __awaiter(thisArg,_arguments,P,generator){function adopt(value){return value instanceof P?value:new P(function(resolve){resolve(value);});}
return new(P||(P=Promise))(function(resolve,reject){function fulfilled(value){try{step(generator.next(value));}catch(e){reject(e);}}
function rejected(value){try{step(generator["throw"](value));}catch(e){reject(e);}}
function step(result){result.done?resolve(result.value):adopt(result.value).then(fulfilled,rejected);}
step((generator=generator.apply(thisArg,_arguments||[])).next());});}
class AppwriteException extends Error{constructor(message,code=0,response=''){super(message);this.name='AppwriteException';this.message=message;this.code=code;this.response=response;}}
class Appwrite{constructor(){this.config={endpoint:'https://appwrite.io/v1',endpointRealtime:'',project:'',key:'',jwt:'',locale:'',mode:'',};this.headers={'x-sdk-version':'appwrite:web:2.1.0','X-Appwrite-Response-Format':'0.9.0',};this.realtime={socket:undefined,timeout:undefined,channels:{},lastMessage:undefined,createSocket:()=>{var _a,_b;const channels=new URLSearchParams();channels.set('project',this.config.project);for(const property in this.realtime.channels){channels.append('channels[]',property);}
if(((_a=this.realtime.socket)===null||_a===void 0?void 0:_a.readyState)===WebSocket.OPEN){this.realtime.socket.close();}
this.realtime.socket=new WebSocket(this.config.endpointRealtime+'/realtime?'+channels.toString());(_b=this.realtime.socket)===null||_b===void 0?void 0:_b.addEventListener('message',this.realtime.authenticate);for(const channel in this.realtime.channels){this.realtime.channels[channel].forEach(callback=>{var _a;(_a=this.realtime.socket)===null||_a===void 0?void 0:_a.addEventListener('message',callback);});}
this.realtime.socket.addEventListener('close',event=>{var _a,_b,_c;if(((_b=(_a=this.realtime)===null||_a===void 0?void 0:_a.lastMessage)===null||_b===void 0?void 0:_b.type)==='error'&&((_c=this.realtime)===null||_c===void 0?void 0:_c.lastMessage.data).code===1008){return;}
console.error('Realtime got disconnected. Reconnect will be attempted in 1 second.',event.reason);setTimeout(()=>{this.realtime.createSocket();},1000);});},authenticate:(event)=>{var _a,_b;const message=JSON.parse(event.data);if(message.type==='connected'){const cookie=JSON.parse((_a=window.localStorage.getItem('cookieFallback'))!==null&&_a!==void 0?_a:"{}");const session=cookie===null||cookie===void 0?void 0:cookie[`a_session_${this.config.project}`];const data=message.data;if(session&&!data.user){(_b=this.realtime.socket)===null||_b===void 0?void 0:_b.send(JSON.stringify({type:"authentication",data:{session}}));}}},onMessage:(channel,callback)=>(event)=>{try{const message=JSON.parse(event.data);this.realtime.lastMessage=message;if(message.type==='event'){let data=message.data;if(data.channels&&data.channels.includes(channel)){callback(data);}}
else if(message.type==='error'){throw message.data;}}
catch(e){console.error(e);}}};this.account={get:()=>__awaiter(this,void 0,void 0,function*(){let path='/account';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),create:(email,password,name)=>__awaiter(this,void 0,void 0,function*(){if(typeof email==='undefined'){throw new AppwriteException('Missing required parameter: "email"');}
if(typeof password==='undefined'){throw new AppwriteException('Missing required parameter: "password"');}
let path='/account';let payload={};if(typeof email!=='undefined'){payload['email']=email;}
if(typeof password!=='undefined'){payload['password']=password;}
if(typeof name!=='undefined'){payload['name']=name;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),delete:()=>__awaiter(this,void 0,void 0,function*(){let path='/account';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);}),updateEmail:(email,password)=>__awaiter(this,void 0,void 0,function*(){if(typeof email==='undefined'){throw new AppwriteException('Missing required parameter: "email"');}
if(typeof password==='undefined'){throw new AppwriteException('Missing required parameter: "password"');}
let path='/account/email';let payload={};if(typeof email!=='undefined'){payload['email']=email;}
if(typeof password!=='undefined'){payload['password']=password;}
const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);}),createJWT:()=>__awaiter(this,void 0,void 0,function*(){let path='/account/jwt';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),getLogs:()=>__awaiter(this,void 0,void 0,function*(){let path='/account/logs';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),updateName:(name)=>__awaiter(this,void 0,void 0,function*(){if(typeof name==='undefined'){throw new AppwriteException('Missing required parameter: "name"');}
let path='/account/name';let payload={};if(typeof name!=='undefined'){payload['name']=name;}
const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);}),updatePassword:(password,oldPassword)=>__awaiter(this,void 0,void 0,function*(){if(typeof password==='undefined'){throw new AppwriteException('Missing required parameter: "password"');}
let path='/account/password';let payload={};if(typeof password!=='undefined'){payload['password']=password;}
if(typeof oldPassword!=='undefined'){payload['oldPassword']=oldPassword;}
const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);}),getPrefs:()=>__awaiter(this,void 0,void 0,function*(){let path='/account/prefs';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),updatePrefs:(prefs)=>__awaiter(this,void 0,void 0,function*(){if(typeof prefs==='undefined'){throw new AppwriteException('Missing required parameter: "prefs"');}
let path='/account/prefs';let payload={};if(typeof prefs!=='undefined'){payload['prefs']=prefs;}
const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);}),createRecovery:(email,url)=>__awaiter(this,void 0,void 0,function*(){if(typeof email==='undefined'){throw new AppwriteException('Missing required parameter: "email"');}
if(typeof url==='undefined'){throw new AppwriteException('Missing required parameter: "url"');}
let path='/account/recovery';let payload={};if(typeof email!=='undefined'){payload['email']=email;}
if(typeof url!=='undefined'){payload['url']=url;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),updateRecovery:(userId,secret,password,passwordAgain)=>__awaiter(this,void 0,void 0,function*(){if(typeof userId==='undefined'){throw new AppwriteException('Missing required parameter: "userId"');}
if(typeof secret==='undefined'){throw new AppwriteException('Missing required parameter: "secret"');}
if(typeof password==='undefined'){throw new AppwriteException('Missing required parameter: "password"');}
if(typeof passwordAgain==='undefined'){throw new AppwriteException('Missing required parameter: "passwordAgain"');}
let path='/account/recovery';let payload={};if(typeof userId!=='undefined'){payload['userId']=userId;}
if(typeof secret!=='undefined'){payload['secret']=secret;}
if(typeof password!=='undefined'){payload['password']=password;}
if(typeof passwordAgain!=='undefined'){payload['passwordAgain']=passwordAgain;}
const uri=new URL(this.config.endpoint+path);return yield this.call('put',uri,{'content-type':'application/json',},payload);}),getSessions:()=>__awaiter(this,void 0,void 0,function*(){let path='/account/sessions';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),createSession:(email,password)=>__awaiter(this,void 0,void 0,function*(){if(typeof email==='undefined'){throw new AppwriteException('Missing required parameter: "email"');}
if(typeof password==='undefined'){throw new AppwriteException('Missing required parameter: "password"');}
let path='/account/sessions';let payload={};if(typeof email!=='undefined'){payload['email']=email;}
if(typeof password!=='undefined'){payload['password']=password;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),deleteSessions:()=>__awaiter(this,void 0,void 0,function*(){let path='/account/sessions';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);}),createAnonymousSession:()=>__awaiter(this,void 0,void 0,function*(){let path='/account/sessions/anonymous';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),createOAuth2Session:(provider,success,failure,scopes)=>{if(typeof provider==='undefined'){throw new AppwriteException('Missing required parameter: "provider"');}
let path='/account/sessions/oauth2/{provider}'.replace('{provider}',provider);let payload={};if(typeof success!=='undefined'){payload['success']=success;}
if(typeof failure!=='undefined'){payload['failure']=failure;}
if(typeof scopes!=='undefined'){payload['scopes']=scopes;}
const uri=new URL(this.config.endpoint+path);payload['project']=this.config.project;for(const[key,value]of Object.entries(this.flatten(payload))){uri.searchParams.append(key,value);}
if(typeof window!=='undefined'&&(window===null||window===void 0?void 0:window.location)){window.location.href=uri.toString();}
else{return uri;}},getSession:(sessionId)=>__awaiter(this,void 0,void 0,function*(){if(typeof sessionId==='undefined'){throw new AppwriteException('Missing required parameter: "sessionId"');}
let path='/account/sessions/{sessionId}'.replace('{sessionId}',sessionId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),deleteSession:(sessionId)=>__awaiter(this,void 0,void 0,function*(){if(typeof sessionId==='undefined'){throw new AppwriteException('Missing required parameter: "sessionId"');}
let path='/account/sessions/{sessionId}'.replace('{sessionId}',sessionId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);}),createVerification:(url)=>__awaiter(this,void 0,void 0,function*(){if(typeof url==='undefined'){throw new AppwriteException('Missing required parameter: "url"');}
let path='/account/verification';let payload={};if(typeof url!=='undefined'){payload['url']=url;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),updateVerification:(userId,secret)=>__awaiter(this,void 0,void 0,function*(){if(typeof userId==='undefined'){throw new AppwriteException('Missing required parameter: "userId"');}
if(typeof secret==='undefined'){throw new AppwriteException('Missing required parameter: "secret"');}
let path='/account/verification';let payload={};if(typeof userId!=='undefined'){payload['userId']=userId;}
if(typeof secret!=='undefined'){payload['secret']=secret;}
const uri=new URL(this.config.endpoint+path);return yield this.call('put',uri,{'content-type':'application/json',},payload);})};this.avatars={getBrowser:(code,width,height,quality)=>{if(typeof code==='undefined'){throw new AppwriteException('Missing required parameter: "code"');}
let path='/avatars/browsers/{code}'.replace('{code}',code);let payload={};if(typeof width!=='undefined'){payload['width']=width;}
if(typeof height!=='undefined'){payload['height']=height;}
if(typeof quality!=='undefined'){payload['quality']=quality;}
const uri=new URL(this.config.endpoint+path);payload['project']=this.config.project;for(const[key,value]of Object.entries(this.flatten(payload))){uri.searchParams.append(key,value);}
return uri;},getCreditCard:(code,width,height,quality)=>{if(typeof code==='undefined'){throw new AppwriteException('Missing required parameter: "code"');}
let path='/avatars/credit-cards/{code}'.replace('{code}',code);let payload={};if(typeof width!=='undefined'){payload['width']=width;}
if(typeof height!=='undefined'){payload['height']=height;}
if(typeof quality!=='undefined'){payload['quality']=quality;}
const uri=new URL(this.config.endpoint+path);payload['project']=this.config.project;for(const[key,value]of Object.entries(this.flatten(payload))){uri.searchParams.append(key,value);}
return uri;},getFavicon:(url)=>{if(typeof url==='undefined'){throw new AppwriteException('Missing required parameter: "url"');}
let path='/avatars/favicon';let payload={};if(typeof url!=='undefined'){payload['url']=url;}
const uri=new URL(this.config.endpoint+path);payload['project']=this.config.project;for(const[key,value]of Object.entries(this.flatten(payload))){uri.searchParams.append(key,value);}
return uri;},getFlag:(code,width,height,quality)=>{if(typeof code==='undefined'){throw new AppwriteException('Missing required parameter: "code"');}
let path='/avatars/flags/{code}'.replace('{code}',code);let payload={};if(typeof width!=='undefined'){payload['width']=width;}
if(typeof height!=='undefined'){payload['height']=height;}
if(typeof quality!=='undefined'){payload['quality']=quality;}
const uri=new URL(this.config.endpoint+path);payload['project']=this.config.project;for(const[key,value]of Object.entries(this.flatten(payload))){uri.searchParams.append(key,value);}
return uri;},getImage:(url,width,height)=>{if(typeof url==='undefined'){throw new AppwriteException('Missing required parameter: "url"');}
let path='/avatars/image';let payload={};if(typeof url!=='undefined'){payload['url']=url;}
if(typeof width!=='undefined'){payload['width']=width;}
if(typeof height!=='undefined'){payload['height']=height;}
const uri=new URL(this.config.endpoint+path);payload['project']=this.config.project;for(const[key,value]of Object.entries(this.flatten(payload))){uri.searchParams.append(key,value);}
return uri;},getInitials:(name,width,height,color,background)=>{let path='/avatars/initials';let payload={};if(typeof name!=='undefined'){payload['name']=name;}
if(typeof width!=='undefined'){payload['width']=width;}
if(typeof height!=='undefined'){payload['height']=height;}
if(typeof color!=='undefined'){payload['color']=color;}
if(typeof background!=='undefined'){payload['background']=background;}
const uri=new URL(this.config.endpoint+path);payload['project']=this.config.project;for(const[key,value]of Object.entries(this.flatten(payload))){uri.searchParams.append(key,value);}
return uri;},getQR:(text,size,margin,download)=>{if(typeof text==='undefined'){throw new AppwriteException('Missing required parameter: "text"');}
let path='/avatars/qr';let payload={};if(typeof text!=='undefined'){payload['text']=text;}
if(typeof size!=='undefined'){payload['size']=size;}
if(typeof margin!=='undefined'){payload['margin']=margin;}
if(typeof download!=='undefined'){payload['download']=download;}
const uri=new URL(this.config.endpoint+path);payload['project']=this.config.project;for(const[key,value]of Object.entries(this.flatten(payload))){uri.searchParams.append(key,value);}
return uri;}};this.database={listCollections:(search,limit,offset,orderType)=>__awaiter(this,void 0,void 0,function*(){let path='/database/collections';let payload={};if(typeof search!=='undefined'){payload['search']=search;}
if(typeof limit!=='undefined'){payload['limit']=limit;}
if(typeof offset!=='undefined'){payload['offset']=offset;}
if(typeof orderType!=='undefined'){payload['orderType']=orderType;}
const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),createCollection:(name,read,write,rules)=>__awaiter(this,void 0,void 0,function*(){if(typeof name==='undefined'){throw new AppwriteException('Missing required parameter: "name"');}
if(typeof read==='undefined'){throw new AppwriteException('Missing required parameter: "read"');}
if(typeof write==='undefined'){throw new AppwriteException('Missing required parameter: "write"');}
if(typeof rules==='undefined'){throw new AppwriteException('Missing required parameter: "rules"');}
let path='/database/collections';let payload={};if(typeof name!=='undefined'){payload['name']=name;}
if(typeof read!=='undefined'){payload['read']=read;}
if(typeof write!=='undefined'){payload['write']=write;}
if(typeof rules!=='undefined'){payload['rules']=rules;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),getCollection:(collectionId)=>__awaiter(this,void 0,void 0,function*(){if(typeof collectionId==='undefined'){throw new AppwriteException('Missing required parameter: "collectionId"');}
let path='/database/collections/{collectionId}'.replace('{collectionId}',collectionId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),updateCollection:(collectionId,name,read,write,rules)=>__awaiter(this,void 0,void 0,function*(){if(typeof collectionId==='undefined'){throw new AppwriteException('Missing required parameter: "collectionId"');}
if(typeof name==='undefined'){throw new AppwriteException('Missing required parameter: "name"');}
let path='/database/collections/{collectionId}'.replace('{collectionId}',collectionId);let payload={};if(typeof name!=='undefined'){payload['name']=name;}
if(typeof read!=='undefined'){payload['read']=read;}
if(typeof write!=='undefined'){payload['write']=write;}
if(typeof rules!=='undefined'){payload['rules']=rules;}
const uri=new URL(this.config.endpoint+path);return yield this.call('put',uri,{'content-type':'application/json',},payload);}),deleteCollection:(collectionId)=>__awaiter(this,void 0,void 0,function*(){if(typeof collectionId==='undefined'){throw new AppwriteException('Missing required parameter: "collectionId"');}
let path='/database/collections/{collectionId}'.replace('{collectionId}',collectionId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);}),listDocuments:(collectionId,filters,limit,offset,orderField,orderType,orderCast,search)=>__awaiter(this,void 0,void 0,function*(){if(typeof collectionId==='undefined'){throw new AppwriteException('Missing required parameter: "collectionId"');}
let path='/database/collections/{collectionId}/documents'.replace('{collectionId}',collectionId);let payload={};if(typeof filters!=='undefined'){payload['filters']=filters;}
if(typeof limit!=='undefined'){payload['limit']=limit;}
if(typeof offset!=='undefined'){payload['offset']=offset;}
if(typeof orderField!=='undefined'){payload['orderField']=orderField;}
if(typeof orderType!=='undefined'){payload['orderType']=orderType;}
if(typeof orderCast!=='undefined'){payload['orderCast']=orderCast;}
if(typeof search!=='undefined'){payload['search']=search;}
const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),createDocument:(collectionId,data,read,write,parentDocument,parentProperty,parentPropertyType)=>__awaiter(this,void 0,void 0,function*(){if(typeof collectionId==='undefined'){throw new AppwriteException('Missing required parameter: "collectionId"');}
if(typeof data==='undefined'){throw new AppwriteException('Missing required parameter: "data"');}
let path='/database/collections/{collectionId}/documents'.replace('{collectionId}',collectionId);let payload={};if(typeof data!=='undefined'){payload['data']=data;}
if(typeof read!=='undefined'){payload['read']=read;}
if(typeof write!=='undefined'){payload['write']=write;}
if(typeof parentDocument!=='undefined'){payload['parentDocument']=parentDocument;}
if(typeof parentProperty!=='undefined'){payload['parentProperty']=parentProperty;}
if(typeof parentPropertyType!=='undefined'){payload['parentPropertyType']=parentPropertyType;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),getDocument:(collectionId,documentId)=>__awaiter(this,void 0,void 0,function*(){if(typeof collectionId==='undefined'){throw new AppwriteException('Missing required parameter: "collectionId"');}
if(typeof documentId==='undefined'){throw new AppwriteException('Missing required parameter: "documentId"');}
let path='/database/collections/{collectionId}/documents/{documentId}'.replace('{collectionId}',collectionId).replace('{documentId}',documentId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),updateDocument:(collectionId,documentId,data,read,write)=>__awaiter(this,void 0,void 0,function*(){if(typeof collectionId==='undefined'){throw new AppwriteException('Missing required parameter: "collectionId"');}
if(typeof documentId==='undefined'){throw new AppwriteException('Missing required parameter: "documentId"');}
if(typeof data==='undefined'){throw new AppwriteException('Missing required parameter: "data"');}
let path='/database/collections/{collectionId}/documents/{documentId}'.replace('{collectionId}',collectionId).replace('{documentId}',documentId);let payload={};if(typeof data!=='undefined'){payload['data']=data;}
if(typeof read!=='undefined'){payload['read']=read;}
if(typeof write!=='undefined'){payload['write']=write;}
const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);}),deleteDocument:(collectionId,documentId)=>__awaiter(this,void 0,void 0,function*(){if(typeof collectionId==='undefined'){throw new AppwriteException('Missing required parameter: "collectionId"');}
if(typeof documentId==='undefined'){throw new AppwriteException('Missing required parameter: "documentId"');}
let path='/database/collections/{collectionId}/documents/{documentId}'.replace('{collectionId}',collectionId).replace('{documentId}',documentId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);})};this.functions={list:(search,limit,offset,orderType)=>__awaiter(this,void 0,void 0,function*(){let path='/functions';let payload={};if(typeof search!=='undefined'){payload['search']=search;}
if(typeof limit!=='undefined'){payload['limit']=limit;}
if(typeof offset!=='undefined'){payload['offset']=offset;}
if(typeof orderType!=='undefined'){payload['orderType']=orderType;}
const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),create:(name,execute,runtime,vars,events,schedule,timeout)=>__awaiter(this,void 0,void 0,function*(){if(typeof name==='undefined'){throw new AppwriteException('Missing required parameter: "name"');}
if(typeof execute==='undefined'){throw new AppwriteException('Missing required parameter: "execute"');}
if(typeof runtime==='undefined'){throw new AppwriteException('Missing required parameter: "runtime"');}
let path='/functions';let payload={};if(typeof name!=='undefined'){payload['name']=name;}
if(typeof execute!=='undefined'){payload['execute']=execute;}
if(typeof runtime!=='undefined'){payload['runtime']=runtime;}
if(typeof vars!=='undefined'){payload['vars']=vars;}
if(typeof events!=='undefined'){payload['events']=events;}
if(typeof schedule!=='undefined'){payload['schedule']=schedule;}
if(typeof timeout!=='undefined'){payload['timeout']=timeout;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),get:(functionId)=>__awaiter(this,void 0,void 0,function*(){if(typeof functionId==='undefined'){throw new AppwriteException('Missing required parameter: "functionId"');}
let path='/functions/{functionId}'.replace('{functionId}',functionId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),update:(functionId,name,execute,vars,events,schedule,timeout)=>__awaiter(this,void 0,void 0,function*(){if(typeof functionId==='undefined'){throw new AppwriteException('Missing required parameter: "functionId"');}
if(typeof name==='undefined'){throw new AppwriteException('Missing required parameter: "name"');}
if(typeof execute==='undefined'){throw new AppwriteException('Missing required parameter: "execute"');}
let path='/functions/{functionId}'.replace('{functionId}',functionId);let payload={};if(typeof name!=='undefined'){payload['name']=name;}
if(typeof execute!=='undefined'){payload['execute']=execute;}
if(typeof vars!=='undefined'){payload['vars']=vars;}
if(typeof events!=='undefined'){payload['events']=events;}
if(typeof schedule!=='undefined'){payload['schedule']=schedule;}
if(typeof timeout!=='undefined'){payload['timeout']=timeout;}
const uri=new URL(this.config.endpoint+path);return yield this.call('put',uri,{'content-type':'application/json',},payload);}),delete:(functionId)=>__awaiter(this,void 0,void 0,function*(){if(typeof functionId==='undefined'){throw new AppwriteException('Missing required parameter: "functionId"');}
let path='/functions/{functionId}'.replace('{functionId}',functionId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);}),listExecutions:(functionId,search,limit,offset,orderType)=>__awaiter(this,void 0,void 0,function*(){if(typeof functionId==='undefined'){throw new AppwriteException('Missing required parameter: "functionId"');}
let path='/functions/{functionId}/executions'.replace('{functionId}',functionId);let payload={};if(typeof search!=='undefined'){payload['search']=search;}
if(typeof limit!=='undefined'){payload['limit']=limit;}
if(typeof offset!=='undefined'){payload['offset']=offset;}
if(typeof orderType!=='undefined'){payload['orderType']=orderType;}
const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),createExecution:(functionId,data)=>__awaiter(this,void 0,void 0,function*(){if(typeof functionId==='undefined'){throw new AppwriteException('Missing required parameter: "functionId"');}
let path='/functions/{functionId}/executions'.replace('{functionId}',functionId);let payload={};if(typeof data!=='undefined'){payload['data']=data;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),getExecution:(functionId,executionId)=>__awaiter(this,void 0,void 0,function*(){if(typeof functionId==='undefined'){throw new AppwriteException('Missing required parameter: "functionId"');}
if(typeof executionId==='undefined'){throw new AppwriteException('Missing required parameter: "executionId"');}
let path='/functions/{functionId}/executions/{executionId}'.replace('{functionId}',functionId).replace('{executionId}',executionId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),updateTag:(functionId,tag)=>__awaiter(this,void 0,void 0,function*(){if(typeof functionId==='undefined'){throw new AppwriteException('Missing required parameter: "functionId"');}
if(typeof tag==='undefined'){throw new AppwriteException('Missing required parameter: "tag"');}
let path='/functions/{functionId}/tag'.replace('{functionId}',functionId);let payload={};if(typeof tag!=='undefined'){payload['tag']=tag;}
const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);}),listTags:(functionId,search,limit,offset,orderType)=>__awaiter(this,void 0,void 0,function*(){if(typeof functionId==='undefined'){throw new AppwriteException('Missing required parameter: "functionId"');}
let path='/functions/{functionId}/tags'.replace('{functionId}',functionId);let payload={};if(typeof search!=='undefined'){payload['search']=search;}
if(typeof limit!=='undefined'){payload['limit']=limit;}
if(typeof offset!=='undefined'){payload['offset']=offset;}
if(typeof orderType!=='undefined'){payload['orderType']=orderType;}
const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),createTag:(functionId,command,code)=>__awaiter(this,void 0,void 0,function*(){if(typeof functionId==='undefined'){throw new AppwriteException('Missing required parameter: "functionId"');}
if(typeof command==='undefined'){throw new AppwriteException('Missing required parameter: "command"');}
if(typeof code==='undefined'){throw new AppwriteException('Missing required parameter: "code"');}
let path='/functions/{functionId}/tags'.replace('{functionId}',functionId);let payload={};if(typeof command!=='undefined'){payload['command']=command;}
if(typeof code!=='undefined'){payload['code']=code;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'multipart/form-data',},payload);}),getTag:(functionId,tagId)=>__awaiter(this,void 0,void 0,function*(){if(typeof functionId==='undefined'){throw new AppwriteException('Missing required parameter: "functionId"');}
if(typeof tagId==='undefined'){throw new AppwriteException('Missing required parameter: "tagId"');}
let path='/functions/{functionId}/tags/{tagId}'.replace('{functionId}',functionId).replace('{tagId}',tagId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),deleteTag:(functionId,tagId)=>__awaiter(this,void 0,void 0,function*(){if(typeof functionId==='undefined'){throw new AppwriteException('Missing required parameter: "functionId"');}
if(typeof tagId==='undefined'){throw new AppwriteException('Missing required parameter: "tagId"');}
let path='/functions/{functionId}/tags/{tagId}'.replace('{functionId}',functionId).replace('{tagId}',tagId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);}),getUsage:(functionId,range)=>__awaiter(this,void 0,void 0,function*(){if(typeof functionId==='undefined'){throw new AppwriteException('Missing required parameter: "functionId"');}
let path='/functions/{functionId}/usage'.replace('{functionId}',functionId);let payload={};if(typeof range!=='undefined'){payload['range']=range;}
const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);})};this.health={get:()=>__awaiter(this,void 0,void 0,function*(){let path='/health';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),getAntiVirus:()=>__awaiter(this,void 0,void 0,function*(){let path='/health/anti-virus';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),getCache:()=>__awaiter(this,void 0,void 0,function*(){let path='/health/cache';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),getDB:()=>__awaiter(this,void 0,void 0,function*(){let path='/health/db';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),getQueueCertificates:()=>__awaiter(this,void 0,void 0,function*(){let path='/health/queue/certificates';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),getQueueFunctions:()=>__awaiter(this,void 0,void 0,function*(){let path='/health/queue/functions';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),getQueueLogs:()=>__awaiter(this,void 0,void 0,function*(){let path='/health/queue/logs';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),getQueueTasks:()=>__awaiter(this,void 0,void 0,function*(){let path='/health/queue/tasks';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),getQueueUsage:()=>__awaiter(this,void 0,void 0,function*(){let path='/health/queue/usage';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),getQueueWebhooks:()=>__awaiter(this,void 0,void 0,function*(){let path='/health/queue/webhooks';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),getStorageLocal:()=>__awaiter(this,void 0,void 0,function*(){let path='/health/storage/local';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),getTime:()=>__awaiter(this,void 0,void 0,function*(){let path='/health/time';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);})};this.locale={get:()=>__awaiter(this,void 0,void 0,function*(){let path='/locale';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),getContinents:()=>__awaiter(this,void 0,void 0,function*(){let path='/locale/continents';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),getCountries:()=>__awaiter(this,void 0,void 0,function*(){let path='/locale/countries';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),getCountriesEU:()=>__awaiter(this,void 0,void 0,function*(){let path='/locale/countries/eu';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),getCountriesPhones:()=>__awaiter(this,void 0,void 0,function*(){let path='/locale/countries/phones';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),getCurrencies:()=>__awaiter(this,void 0,void 0,function*(){let path='/locale/currencies';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),getLanguages:()=>__awaiter(this,void 0,void 0,function*(){let path='/locale/languages';let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);})};this.projects={list:(search,limit,offset,orderType)=>__awaiter(this,void 0,void 0,function*(){let path='/projects';let payload={};if(typeof search!=='undefined'){payload['search']=search;}
if(typeof limit!=='undefined'){payload['limit']=limit;}
if(typeof offset!=='undefined'){payload['offset']=offset;}
if(typeof orderType!=='undefined'){payload['orderType']=orderType;}
const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),create:(name,teamId,description,logo,url,legalName,legalCountry,legalState,legalCity,legalAddress,legalTaxId)=>__awaiter(this,void 0,void 0,function*(){if(typeof name==='undefined'){throw new AppwriteException('Missing required parameter: "name"');}
if(typeof teamId==='undefined'){throw new AppwriteException('Missing required parameter: "teamId"');}
let path='/projects';let payload={};if(typeof name!=='undefined'){payload['name']=name;}
if(typeof teamId!=='undefined'){payload['teamId']=teamId;}
if(typeof description!=='undefined'){payload['description']=description;}
if(typeof logo!=='undefined'){payload['logo']=logo;}
if(typeof url!=='undefined'){payload['url']=url;}
if(typeof legalName!=='undefined'){payload['legalName']=legalName;}
if(typeof legalCountry!=='undefined'){payload['legalCountry']=legalCountry;}
if(typeof legalState!=='undefined'){payload['legalState']=legalState;}
if(typeof legalCity!=='undefined'){payload['legalCity']=legalCity;}
if(typeof legalAddress!=='undefined'){payload['legalAddress']=legalAddress;}
if(typeof legalTaxId!=='undefined'){payload['legalTaxId']=legalTaxId;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),get:(projectId)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
let path='/projects/{projectId}'.replace('{projectId}',projectId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),update:(projectId,name,description,logo,url,legalName,legalCountry,legalState,legalCity,legalAddress,legalTaxId)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof name==='undefined'){throw new AppwriteException('Missing required parameter: "name"');}
let path='/projects/{projectId}'.replace('{projectId}',projectId);let payload={};if(typeof name!=='undefined'){payload['name']=name;}
if(typeof description!=='undefined'){payload['description']=description;}
if(typeof logo!=='undefined'){payload['logo']=logo;}
if(typeof url!=='undefined'){payload['url']=url;}
if(typeof legalName!=='undefined'){payload['legalName']=legalName;}
if(typeof legalCountry!=='undefined'){payload['legalCountry']=legalCountry;}
if(typeof legalState!=='undefined'){payload['legalState']=legalState;}
if(typeof legalCity!=='undefined'){payload['legalCity']=legalCity;}
if(typeof legalAddress!=='undefined'){payload['legalAddress']=legalAddress;}
if(typeof legalTaxId!=='undefined'){payload['legalTaxId']=legalTaxId;}
const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);}),delete:(projectId,password)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof password==='undefined'){throw new AppwriteException('Missing required parameter: "password"');}
let path='/projects/{projectId}'.replace('{projectId}',projectId);let payload={};if(typeof password!=='undefined'){payload['password']=password;}
const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);}),updateAuthLimit:(projectId,limit)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof limit==='undefined'){throw new AppwriteException('Missing required parameter: "limit"');}
let path='/projects/{projectId}/auth/limit'.replace('{projectId}',projectId);let payload={};if(typeof limit!=='undefined'){payload['limit']=limit;}
const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);}),updateAuthStatus:(projectId,method,status)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof method==='undefined'){throw new AppwriteException('Missing required parameter: "method"');}
if(typeof status==='undefined'){throw new AppwriteException('Missing required parameter: "status"');}
let path='/projects/{projectId}/auth/{method}'.replace('{projectId}',projectId).replace('{method}',method);let payload={};if(typeof status!=='undefined'){payload['status']=status;}
const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);}),listDomains:(projectId)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
let path='/projects/{projectId}/domains'.replace('{projectId}',projectId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),createDomain:(projectId,domain)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof domain==='undefined'){throw new AppwriteException('Missing required parameter: "domain"');}
let path='/projects/{projectId}/domains'.replace('{projectId}',projectId);let payload={};if(typeof domain!=='undefined'){payload['domain']=domain;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),getDomain:(projectId,domainId)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof domainId==='undefined'){throw new AppwriteException('Missing required parameter: "domainId"');}
let path='/projects/{projectId}/domains/{domainId}'.replace('{projectId}',projectId).replace('{domainId}',domainId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),deleteDomain:(projectId,domainId)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof domainId==='undefined'){throw new AppwriteException('Missing required parameter: "domainId"');}
let path='/projects/{projectId}/domains/{domainId}'.replace('{projectId}',projectId).replace('{domainId}',domainId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);}),updateDomainVerification:(projectId,domainId)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof domainId==='undefined'){throw new AppwriteException('Missing required parameter: "domainId"');}
let path='/projects/{projectId}/domains/{domainId}/verification'.replace('{projectId}',projectId).replace('{domainId}',domainId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);}),listKeys:(projectId)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
let path='/projects/{projectId}/keys'.replace('{projectId}',projectId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),createKey:(projectId,name,scopes)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof name==='undefined'){throw new AppwriteException('Missing required parameter: "name"');}
if(typeof scopes==='undefined'){throw new AppwriteException('Missing required parameter: "scopes"');}
let path='/projects/{projectId}/keys'.replace('{projectId}',projectId);let payload={};if(typeof name!=='undefined'){payload['name']=name;}
if(typeof scopes!=='undefined'){payload['scopes']=scopes;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),getKey:(projectId,keyId)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof keyId==='undefined'){throw new AppwriteException('Missing required parameter: "keyId"');}
let path='/projects/{projectId}/keys/{keyId}'.replace('{projectId}',projectId).replace('{keyId}',keyId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),updateKey:(projectId,keyId,name,scopes)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof keyId==='undefined'){throw new AppwriteException('Missing required parameter: "keyId"');}
if(typeof name==='undefined'){throw new AppwriteException('Missing required parameter: "name"');}
if(typeof scopes==='undefined'){throw new AppwriteException('Missing required parameter: "scopes"');}
let path='/projects/{projectId}/keys/{keyId}'.replace('{projectId}',projectId).replace('{keyId}',keyId);let payload={};if(typeof name!=='undefined'){payload['name']=name;}
if(typeof scopes!=='undefined'){payload['scopes']=scopes;}
const uri=new URL(this.config.endpoint+path);return yield this.call('put',uri,{'content-type':'application/json',},payload);}),deleteKey:(projectId,keyId)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof keyId==='undefined'){throw new AppwriteException('Missing required parameter: "keyId"');}
let path='/projects/{projectId}/keys/{keyId}'.replace('{projectId}',projectId).replace('{keyId}',keyId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);}),updateOAuth2:(projectId,provider,appId,secret)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof provider==='undefined'){throw new AppwriteException('Missing required parameter: "provider"');}
let path='/projects/{projectId}/oauth2'.replace('{projectId}',projectId);let payload={};if(typeof provider!=='undefined'){payload['provider']=provider;}
if(typeof appId!=='undefined'){payload['appId']=appId;}
if(typeof secret!=='undefined'){payload['secret']=secret;}
const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);}),listPlatforms:(projectId)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
let path='/projects/{projectId}/platforms'.replace('{projectId}',projectId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),createPlatform:(projectId,type,name,key,store,hostname)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof type==='undefined'){throw new AppwriteException('Missing required parameter: "type"');}
if(typeof name==='undefined'){throw new AppwriteException('Missing required parameter: "name"');}
let path='/projects/{projectId}/platforms'.replace('{projectId}',projectId);let payload={};if(typeof type!=='undefined'){payload['type']=type;}
if(typeof name!=='undefined'){payload['name']=name;}
if(typeof key!=='undefined'){payload['key']=key;}
if(typeof store!=='undefined'){payload['store']=store;}
if(typeof hostname!=='undefined'){payload['hostname']=hostname;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),getPlatform:(projectId,platformId)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof platformId==='undefined'){throw new AppwriteException('Missing required parameter: "platformId"');}
let path='/projects/{projectId}/platforms/{platformId}'.replace('{projectId}',projectId).replace('{platformId}',platformId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),updatePlatform:(projectId,platformId,name,key,store,hostname)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof platformId==='undefined'){throw new AppwriteException('Missing required parameter: "platformId"');}
if(typeof name==='undefined'){throw new AppwriteException('Missing required parameter: "name"');}
let path='/projects/{projectId}/platforms/{platformId}'.replace('{projectId}',projectId).replace('{platformId}',platformId);let payload={};if(typeof name!=='undefined'){payload['name']=name;}
if(typeof key!=='undefined'){payload['key']=key;}
if(typeof store!=='undefined'){payload['store']=store;}
if(typeof hostname!=='undefined'){payload['hostname']=hostname;}
const uri=new URL(this.config.endpoint+path);return yield this.call('put',uri,{'content-type':'application/json',},payload);}),deletePlatform:(projectId,platformId)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof platformId==='undefined'){throw new AppwriteException('Missing required parameter: "platformId"');}
let path='/projects/{projectId}/platforms/{platformId}'.replace('{projectId}',projectId).replace('{platformId}',platformId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);}),listTasks:(projectId)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
let path='/projects/{projectId}/tasks'.replace('{projectId}',projectId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),createTask:(projectId,name,status,schedule,security,httpMethod,httpUrl,httpHeaders,httpUser,httpPass)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof name==='undefined'){throw new AppwriteException('Missing required parameter: "name"');}
if(typeof status==='undefined'){throw new AppwriteException('Missing required parameter: "status"');}
if(typeof schedule==='undefined'){throw new AppwriteException('Missing required parameter: "schedule"');}
if(typeof security==='undefined'){throw new AppwriteException('Missing required parameter: "security"');}
if(typeof httpMethod==='undefined'){throw new AppwriteException('Missing required parameter: "httpMethod"');}
if(typeof httpUrl==='undefined'){throw new AppwriteException('Missing required parameter: "httpUrl"');}
let path='/projects/{projectId}/tasks'.replace('{projectId}',projectId);let payload={};if(typeof name!=='undefined'){payload['name']=name;}
if(typeof status!=='undefined'){payload['status']=status;}
if(typeof schedule!=='undefined'){payload['schedule']=schedule;}
if(typeof security!=='undefined'){payload['security']=security;}
if(typeof httpMethod!=='undefined'){payload['httpMethod']=httpMethod;}
if(typeof httpUrl!=='undefined'){payload['httpUrl']=httpUrl;}
if(typeof httpHeaders!=='undefined'){payload['httpHeaders']=httpHeaders;}
if(typeof httpUser!=='undefined'){payload['httpUser']=httpUser;}
if(typeof httpPass!=='undefined'){payload['httpPass']=httpPass;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),getTask:(projectId,taskId)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof taskId==='undefined'){throw new AppwriteException('Missing required parameter: "taskId"');}
let path='/projects/{projectId}/tasks/{taskId}'.replace('{projectId}',projectId).replace('{taskId}',taskId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),updateTask:(projectId,taskId,name,status,schedule,security,httpMethod,httpUrl,httpHeaders,httpUser,httpPass)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof taskId==='undefined'){throw new AppwriteException('Missing required parameter: "taskId"');}
if(typeof name==='undefined'){throw new AppwriteException('Missing required parameter: "name"');}
if(typeof status==='undefined'){throw new AppwriteException('Missing required parameter: "status"');}
if(typeof schedule==='undefined'){throw new AppwriteException('Missing required parameter: "schedule"');}
if(typeof security==='undefined'){throw new AppwriteException('Missing required parameter: "security"');}
if(typeof httpMethod==='undefined'){throw new AppwriteException('Missing required parameter: "httpMethod"');}
if(typeof httpUrl==='undefined'){throw new AppwriteException('Missing required parameter: "httpUrl"');}
let path='/projects/{projectId}/tasks/{taskId}'.replace('{projectId}',projectId).replace('{taskId}',taskId);let payload={};if(typeof name!=='undefined'){payload['name']=name;}
if(typeof status!=='undefined'){payload['status']=status;}
if(typeof schedule!=='undefined'){payload['schedule']=schedule;}
if(typeof security!=='undefined'){payload['security']=security;}
if(typeof httpMethod!=='undefined'){payload['httpMethod']=httpMethod;}
if(typeof httpUrl!=='undefined'){payload['httpUrl']=httpUrl;}
if(typeof httpHeaders!=='undefined'){payload['httpHeaders']=httpHeaders;}
if(typeof httpUser!=='undefined'){payload['httpUser']=httpUser;}
if(typeof httpPass!=='undefined'){payload['httpPass']=httpPass;}
const uri=new URL(this.config.endpoint+path);return yield this.call('put',uri,{'content-type':'application/json',},payload);}),deleteTask:(projectId,taskId)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof taskId==='undefined'){throw new AppwriteException('Missing required parameter: "taskId"');}
let path='/projects/{projectId}/tasks/{taskId}'.replace('{projectId}',projectId).replace('{taskId}',taskId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);}),getUsage:(projectId,range)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
let path='/projects/{projectId}/usage'.replace('{projectId}',projectId);let payload={};if(typeof range!=='undefined'){payload['range']=range;}
const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),listWebhooks:(projectId)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
let path='/projects/{projectId}/webhooks'.replace('{projectId}',projectId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),createWebhook:(projectId,name,events,url,security,httpUser,httpPass)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof name==='undefined'){throw new AppwriteException('Missing required parameter: "name"');}
if(typeof events==='undefined'){throw new AppwriteException('Missing required parameter: "events"');}
if(typeof url==='undefined'){throw new AppwriteException('Missing required parameter: "url"');}
if(typeof security==='undefined'){throw new AppwriteException('Missing required parameter: "security"');}
let path='/projects/{projectId}/webhooks'.replace('{projectId}',projectId);let payload={};if(typeof name!=='undefined'){payload['name']=name;}
if(typeof events!=='undefined'){payload['events']=events;}
if(typeof url!=='undefined'){payload['url']=url;}
if(typeof security!=='undefined'){payload['security']=security;}
if(typeof httpUser!=='undefined'){payload['httpUser']=httpUser;}
if(typeof httpPass!=='undefined'){payload['httpPass']=httpPass;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),getWebhook:(projectId,webhookId)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof webhookId==='undefined'){throw new AppwriteException('Missing required parameter: "webhookId"');}
let path='/projects/{projectId}/webhooks/{webhookId}'.replace('{projectId}',projectId).replace('{webhookId}',webhookId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),updateWebhook:(projectId,webhookId,name,events,url,security,httpUser,httpPass)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof webhookId==='undefined'){throw new AppwriteException('Missing required parameter: "webhookId"');}
if(typeof name==='undefined'){throw new AppwriteException('Missing required parameter: "name"');}
if(typeof events==='undefined'){throw new AppwriteException('Missing required parameter: "events"');}
if(typeof url==='undefined'){throw new AppwriteException('Missing required parameter: "url"');}
if(typeof security==='undefined'){throw new AppwriteException('Missing required parameter: "security"');}
let path='/projects/{projectId}/webhooks/{webhookId}'.replace('{projectId}',projectId).replace('{webhookId}',webhookId);let payload={};if(typeof name!=='undefined'){payload['name']=name;}
if(typeof events!=='undefined'){payload['events']=events;}
if(typeof url!=='undefined'){payload['url']=url;}
if(typeof security!=='undefined'){payload['security']=security;}
if(typeof httpUser!=='undefined'){payload['httpUser']=httpUser;}
if(typeof httpPass!=='undefined'){payload['httpPass']=httpPass;}
const uri=new URL(this.config.endpoint+path);return yield this.call('put',uri,{'content-type':'application/json',},payload);}),deleteWebhook:(projectId,webhookId)=>__awaiter(this,void 0,void 0,function*(){if(typeof projectId==='undefined'){throw new AppwriteException('Missing required parameter: "projectId"');}
if(typeof webhookId==='undefined'){throw new AppwriteException('Missing required parameter: "webhookId"');}
let path='/projects/{projectId}/webhooks/{webhookId}'.replace('{projectId}',projectId).replace('{webhookId}',webhookId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);})};this.storage={listFiles:(search,limit,offset,orderType)=>__awaiter(this,void 0,void 0,function*(){let path='/storage/files';let payload={};if(typeof search!=='undefined'){payload['search']=search;}
if(typeof limit!=='undefined'){payload['limit']=limit;}
if(typeof offset!=='undefined'){payload['offset']=offset;}
if(typeof orderType!=='undefined'){payload['orderType']=orderType;}
const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),createFile:(file,read,write)=>__awaiter(this,void 0,void 0,function*(){if(typeof file==='undefined'){throw new AppwriteException('Missing required parameter: "file"');}
let path='/storage/files';let payload={};if(typeof file!=='undefined'){payload['file']=file;}
if(typeof read!=='undefined'){payload['read']=read;}
if(typeof write!=='undefined'){payload['write']=write;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'multipart/form-data',},payload);}),getFile:(fileId)=>__awaiter(this,void 0,void 0,function*(){if(typeof fileId==='undefined'){throw new AppwriteException('Missing required parameter: "fileId"');}
let path='/storage/files/{fileId}'.replace('{fileId}',fileId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),updateFile:(fileId,read,write)=>__awaiter(this,void 0,void 0,function*(){if(typeof fileId==='undefined'){throw new AppwriteException('Missing required parameter: "fileId"');}
if(typeof read==='undefined'){throw new AppwriteException('Missing required parameter: "read"');}
if(typeof write==='undefined'){throw new AppwriteException('Missing required parameter: "write"');}
let path='/storage/files/{fileId}'.replace('{fileId}',fileId);let payload={};if(typeof read!=='undefined'){payload['read']=read;}
if(typeof write!=='undefined'){payload['write']=write;}
const uri=new URL(this.config.endpoint+path);return yield this.call('put',uri,{'content-type':'application/json',},payload);}),deleteFile:(fileId)=>__awaiter(this,void 0,void 0,function*(){if(typeof fileId==='undefined'){throw new AppwriteException('Missing required parameter: "fileId"');}
let path='/storage/files/{fileId}'.replace('{fileId}',fileId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);}),getFileDownload:(fileId)=>{if(typeof fileId==='undefined'){throw new AppwriteException('Missing required parameter: "fileId"');}
let path='/storage/files/{fileId}/download'.replace('{fileId}',fileId);let payload={};const uri=new URL(this.config.endpoint+path);payload['project']=this.config.project;for(const[key,value]of Object.entries(this.flatten(payload))){uri.searchParams.append(key,value);}
return uri;},getFilePreview:(fileId,width,height,gravity,quality,borderWidth,borderColor,borderRadius,opacity,rotation,background,output)=>{if(typeof fileId==='undefined'){throw new AppwriteException('Missing required parameter: "fileId"');}
let path='/storage/files/{fileId}/preview'.replace('{fileId}',fileId);let payload={};if(typeof width!=='undefined'){payload['width']=width;}
if(typeof height!=='undefined'){payload['height']=height;}
if(typeof gravity!=='undefined'){payload['gravity']=gravity;}
if(typeof quality!=='undefined'){payload['quality']=quality;}
if(typeof borderWidth!=='undefined'){payload['borderWidth']=borderWidth;}
if(typeof borderColor!=='undefined'){payload['borderColor']=borderColor;}
if(typeof borderRadius!=='undefined'){payload['borderRadius']=borderRadius;}
if(typeof opacity!=='undefined'){payload['opacity']=opacity;}
if(typeof rotation!=='undefined'){payload['rotation']=rotation;}
if(typeof background!=='undefined'){payload['background']=background;}
if(typeof output!=='undefined'){payload['output']=output;}
const uri=new URL(this.config.endpoint+path);payload['project']=this.config.project;for(const[key,value]of Object.entries(this.flatten(payload))){uri.searchParams.append(key,value);}
return uri;},getFileView:(fileId)=>{if(typeof fileId==='undefined'){throw new AppwriteException('Missing required parameter: "fileId"');}
let path='/storage/files/{fileId}/view'.replace('{fileId}',fileId);let payload={};const uri=new URL(this.config.endpoint+path);payload['project']=this.config.project;for(const[key,value]of Object.entries(this.flatten(payload))){uri.searchParams.append(key,value);}
return uri;}};this.teams={list:(search,limit,offset,orderType)=>__awaiter(this,void 0,void 0,function*(){let path='/teams';let payload={};if(typeof search!=='undefined'){payload['search']=search;}
if(typeof limit!=='undefined'){payload['limit']=limit;}
if(typeof offset!=='undefined'){payload['offset']=offset;}
if(typeof orderType!=='undefined'){payload['orderType']=orderType;}
const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),create:(name,roles)=>__awaiter(this,void 0,void 0,function*(){if(typeof name==='undefined'){throw new AppwriteException('Missing required parameter: "name"');}
let path='/teams';let payload={};if(typeof name!=='undefined'){payload['name']=name;}
if(typeof roles!=='undefined'){payload['roles']=roles;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),get:(teamId)=>__awaiter(this,void 0,void 0,function*(){if(typeof teamId==='undefined'){throw new AppwriteException('Missing required parameter: "teamId"');}
let path='/teams/{teamId}'.replace('{teamId}',teamId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),update:(teamId,name)=>__awaiter(this,void 0,void 0,function*(){if(typeof teamId==='undefined'){throw new AppwriteException('Missing required parameter: "teamId"');}
if(typeof name==='undefined'){throw new AppwriteException('Missing required parameter: "name"');}
let path='/teams/{teamId}'.replace('{teamId}',teamId);let payload={};if(typeof name!=='undefined'){payload['name']=name;}
const uri=new URL(this.config.endpoint+path);return yield this.call('put',uri,{'content-type':'application/json',},payload);}),delete:(teamId)=>__awaiter(this,void 0,void 0,function*(){if(typeof teamId==='undefined'){throw new AppwriteException('Missing required parameter: "teamId"');}
let path='/teams/{teamId}'.replace('{teamId}',teamId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);}),getMemberships:(teamId,search,limit,offset,orderType)=>__awaiter(this,void 0,void 0,function*(){if(typeof teamId==='undefined'){throw new AppwriteException('Missing required parameter: "teamId"');}
let path='/teams/{teamId}/memberships'.replace('{teamId}',teamId);let payload={};if(typeof search!=='undefined'){payload['search']=search;}
if(typeof limit!=='undefined'){payload['limit']=limit;}
if(typeof offset!=='undefined'){payload['offset']=offset;}
if(typeof orderType!=='undefined'){payload['orderType']=orderType;}
const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),createMembership:(teamId,email,roles,url,name)=>__awaiter(this,void 0,void 0,function*(){if(typeof teamId==='undefined'){throw new AppwriteException('Missing required parameter: "teamId"');}
if(typeof email==='undefined'){throw new AppwriteException('Missing required parameter: "email"');}
if(typeof roles==='undefined'){throw new AppwriteException('Missing required parameter: "roles"');}
if(typeof url==='undefined'){throw new AppwriteException('Missing required parameter: "url"');}
let path='/teams/{teamId}/memberships'.replace('{teamId}',teamId);let payload={};if(typeof email!=='undefined'){payload['email']=email;}
if(typeof name!=='undefined'){payload['name']=name;}
if(typeof roles!=='undefined'){payload['roles']=roles;}
if(typeof url!=='undefined'){payload['url']=url;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),updateMembershipRoles:(teamId,membershipId,roles)=>__awaiter(this,void 0,void 0,function*(){if(typeof teamId==='undefined'){throw new AppwriteException('Missing required parameter: "teamId"');}
if(typeof membershipId==='undefined'){throw new AppwriteException('Missing required parameter: "membershipId"');}
if(typeof roles==='undefined'){throw new AppwriteException('Missing required parameter: "roles"');}
let path='/teams/{teamId}/memberships/{membershipId}'.replace('{teamId}',teamId).replace('{membershipId}',membershipId);let payload={};if(typeof roles!=='undefined'){payload['roles']=roles;}
const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);}),deleteMembership:(teamId,membershipId)=>__awaiter(this,void 0,void 0,function*(){if(typeof teamId==='undefined'){throw new AppwriteException('Missing required parameter: "teamId"');}
if(typeof membershipId==='undefined'){throw new AppwriteException('Missing required parameter: "membershipId"');}
let path='/teams/{teamId}/memberships/{membershipId}'.replace('{teamId}',teamId).replace('{membershipId}',membershipId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);}),updateMembershipStatus:(teamId,membershipId,userId,secret)=>__awaiter(this,void 0,void 0,function*(){if(typeof teamId==='undefined'){throw new AppwriteException('Missing required parameter: "teamId"');}
if(typeof membershipId==='undefined'){throw new AppwriteException('Missing required parameter: "membershipId"');}
if(typeof userId==='undefined'){throw new AppwriteException('Missing required parameter: "userId"');}
if(typeof secret==='undefined'){throw new AppwriteException('Missing required parameter: "secret"');}
let path='/teams/{teamId}/memberships/{membershipId}/status'.replace('{teamId}',teamId).replace('{membershipId}',membershipId);let payload={};if(typeof userId!=='undefined'){payload['userId']=userId;}
if(typeof secret!=='undefined'){payload['secret']=secret;}
const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);})};this.users={list:(search,limit,offset,orderType)=>__awaiter(this,void 0,void 0,function*(){let path='/users';let payload={};if(typeof search!=='undefined'){payload['search']=search;}
if(typeof limit!=='undefined'){payload['limit']=limit;}
if(typeof offset!=='undefined'){payload['offset']=offset;}
if(typeof orderType!=='undefined'){payload['orderType']=orderType;}
const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),create:(email,password,name)=>__awaiter(this,void 0,void 0,function*(){if(typeof email==='undefined'){throw new AppwriteException('Missing required parameter: "email"');}
if(typeof password==='undefined'){throw new AppwriteException('Missing required parameter: "password"');}
let path='/users';let payload={};if(typeof email!=='undefined'){payload['email']=email;}
if(typeof password!=='undefined'){payload['password']=password;}
if(typeof name!=='undefined'){payload['name']=name;}
const uri=new URL(this.config.endpoint+path);return yield this.call('post',uri,{'content-type':'application/json',},payload);}),get:(userId)=>__awaiter(this,void 0,void 0,function*(){if(typeof userId==='undefined'){throw new AppwriteException('Missing required parameter: "userId"');}
let path='/users/{userId}'.replace('{userId}',userId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),delete:(userId)=>__awaiter(this,void 0,void 0,function*(){if(typeof userId==='undefined'){throw new AppwriteException('Missing required parameter: "userId"');}
let path='/users/{userId}'.replace('{userId}',userId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);}),updateEmail:(userId,email)=>__awaiter(this,void 0,void 0,function*(){if(typeof userId==='undefined'){throw new AppwriteException('Missing required parameter: "userId"');}
if(typeof email==='undefined'){throw new AppwriteException('Missing required parameter: "email"');}
let path='/users/{userId}/email'.replace('{userId}',userId);let payload={};if(typeof email!=='undefined'){payload['email']=email;}
const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);}),getLogs:(userId)=>__awaiter(this,void 0,void 0,function*(){if(typeof userId==='undefined'){throw new AppwriteException('Missing required parameter: "userId"');}
let path='/users/{userId}/logs'.replace('{userId}',userId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),updateName:(userId,name)=>__awaiter(this,void 0,void 0,function*(){if(typeof userId==='undefined'){throw new AppwriteException('Missing required parameter: "userId"');}
if(typeof name==='undefined'){throw new AppwriteException('Missing required parameter: "name"');}
let path='/users/{userId}/name'.replace('{userId}',userId);let payload={};if(typeof name!=='undefined'){payload['name']=name;}
const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);}),updatePassword:(userId,password)=>__awaiter(this,void 0,void 0,function*(){if(typeof userId==='undefined'){throw new AppwriteException('Missing required parameter: "userId"');}
if(typeof password==='undefined'){throw new AppwriteException('Missing required parameter: "password"');}
let path='/users/{userId}/password'.replace('{userId}',userId);let payload={};if(typeof password!=='undefined'){payload['password']=password;}
const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);}),getPrefs:(userId)=>__awaiter(this,void 0,void 0,function*(){if(typeof userId==='undefined'){throw new AppwriteException('Missing required parameter: "userId"');}
let path='/users/{userId}/prefs'.replace('{userId}',userId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),updatePrefs:(userId,prefs)=>__awaiter(this,void 0,void 0,function*(){if(typeof userId==='undefined'){throw new AppwriteException('Missing required parameter: "userId"');}
if(typeof prefs==='undefined'){throw new AppwriteException('Missing required parameter: "prefs"');}
let path='/users/{userId}/prefs'.replace('{userId}',userId);let payload={};if(typeof prefs!=='undefined'){payload['prefs']=prefs;}
const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);}),getSessions:(userId)=>__awaiter(this,void 0,void 0,function*(){if(typeof userId==='undefined'){throw new AppwriteException('Missing required parameter: "userId"');}
let path='/users/{userId}/sessions'.replace('{userId}',userId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('get',uri,{'content-type':'application/json',},payload);}),deleteSessions:(userId)=>__awaiter(this,void 0,void 0,function*(){if(typeof userId==='undefined'){throw new AppwriteException('Missing required parameter: "userId"');}
let path='/users/{userId}/sessions'.replace('{userId}',userId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);}),deleteSession:(userId,sessionId)=>__awaiter(this,void 0,void 0,function*(){if(typeof userId==='undefined'){throw new AppwriteException('Missing required parameter: "userId"');}
if(typeof sessionId==='undefined'){throw new AppwriteException('Missing required parameter: "sessionId"');}
let path='/users/{userId}/sessions/{sessionId}'.replace('{userId}',userId).replace('{sessionId}',sessionId);let payload={};const uri=new URL(this.config.endpoint+path);return yield this.call('delete',uri,{'content-type':'application/json',},payload);}),updateStatus:(userId,status)=>__awaiter(this,void 0,void 0,function*(){if(typeof userId==='undefined'){throw new AppwriteException('Missing required parameter: "userId"');}
if(typeof status==='undefined'){throw new AppwriteException('Missing required parameter: "status"');}
let path='/users/{userId}/status'.replace('{userId}',userId);let payload={};if(typeof status!=='undefined'){payload['status']=status;}
const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);}),updateVerification:(userId,emailVerification)=>__awaiter(this,void 0,void 0,function*(){if(typeof userId==='undefined'){throw new AppwriteException('Missing required parameter: "userId"');}
if(typeof emailVerification==='undefined'){throw new AppwriteException('Missing required parameter: "emailVerification"');}
let path='/users/{userId}/verification'.replace('{userId}',userId);let payload={};if(typeof emailVerification!=='undefined'){payload['emailVerification']=emailVerification;}
const uri=new URL(this.config.endpoint+path);return yield this.call('patch',uri,{'content-type':'application/json',},payload);})};}
setEndpoint(endpoint){this.config.endpoint=endpoint;this.config.endpointRealtime=this.config.endpointRealtime||this.config.endpoint.replace("https://","wss://").replace("http://","ws://");return this;}
setEndpointRealtime(endpointRealtime){this.config.endpointRealtime=endpointRealtime;return this;}
setProject(value){this.headers['X-Appwrite-Project']=value;this.config.project=value;return this;}
setKey(value){this.headers['X-Appwrite-Key']=value;this.config.key=value;return this;}
setJWT(value){this.headers['X-Appwrite-JWT']=value;this.config.jwt=value;return this;}
setLocale(value){this.headers['X-Appwrite-Locale']=value;this.config.locale=value;return this;}
setMode(value){this.headers['X-Appwrite-Mode']=value;this.config.mode=value;return this;}
subscribe(channels,callback){let channelArray=typeof channels==='string'?[channels]:channels;let savedChannels=[];channelArray.forEach((channel,index)=>{if(!(channel in this.realtime.channels)){this.realtime.channels[channel]=[];}
savedChannels[index]={name:channel,index:(this.realtime.channels[channel].push(this.realtime.onMessage(channel,callback))-1)};clearTimeout(this.realtime.timeout);this.realtime.timeout=window===null||window===void 0?void 0:window.setTimeout(()=>{this.realtime.createSocket();},1);});return()=>{savedChannels.forEach(channel=>{var _a;(_a=this.realtime.socket)===null||_a===void 0?void 0:_a.removeEventListener('message',this.realtime.channels[channel.name][channel.index]);this.realtime.channels[channel.name].splice(channel.index,1);});};}
call(method,url,headers={},params={}){var _a,_b;return __awaiter(this,void 0,void 0,function*(){method=method.toUpperCase();headers=Object.assign(Object.assign({},headers),this.headers);let options={method,headers,credentials:'include'};if(typeof window!=='undefined'&&window.localStorage){headers['X-Fallback-Cookies']=(_a=window.localStorage.getItem('cookieFallback'))!==null&&_a!==void 0?_a:"";}
if(method==='GET'){for(const[key,value]of Object.entries(this.flatten(params))){url.searchParams.append(key,value);}}
else{switch(headers['content-type']){case'application/json':options.body=JSON.stringify(params);break;case'multipart/form-data':let formData=new FormData();for(const key in params){if(Array.isArray(params[key])){formData.append(key+'[]',params[key].join(','));}
else{formData.append(key,params[key]);}}
options.body=formData;delete headers['content-type'];break;}}
try{let data=null;const response=yield crossFetch.fetch(url.toString(),options);if((_b=response.headers.get("content-type"))===null||_b===void 0?void 0:_b.includes("application/json")){data=yield response.json();}
else{data={message:yield response.text()};}
if(400<=response.status){throw new AppwriteException(data===null||data===void 0?void 0:data.message,response.status,data);}
const cookieFallback=response.headers.get('X-Fallback-Cookies');if(typeof window!=='undefined'&&window.localStorage&&cookieFallback){window.console.warn('Appwrite is using localStorage for session management. Increase your security by adding a custom domain as your API endpoint.');window.localStorage.setItem('cookieFallback',cookieFallback);}
return data;}
catch(e){throw new AppwriteException(e.message);}});}
flatten(data,prefix=''){let output={};for(const key in data){let value=data[key];let finalKey=prefix?`${prefix}[${key}]`:key;if(Array.isArray(value)){output=Object.assign(output,this.flatten(value,finalKey));}
else{output[finalKey]=value;}}
return output;}}
exports.Appwrite=Appwrite;Object.defineProperty(exports,'__esModule',{value:true});}(this.window=this.window||{},null,window));(function(global,factory){typeof exports==='object'&&typeof module!=='undefined'?module.exports=factory(function(){try{return require('moment');}catch(e){}}()):typeof define==='function'&&define.amd?define(['require'],function(require){return factory(function(){try{return require('moment');}catch(e){}}());}):(global=global||self,global.Chart=factory(global.moment));}(this,(function(moment){'use strict';moment=moment&&moment.hasOwnProperty('default')?moment['default']:moment;function createCommonjsModule(fn,module){return module={exports:{}},fn(module,module.exports),module.exports;}
function getCjsExportFromNamespace(n){return n&&n['default']||n;}
var colorName={"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aqua":[0,255,255],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"black":[0,0,0],"blanchedalmond":[255,235,205],"blue":[0,0,255],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"fuchsia":[255,0,255],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"gray":[128,128,128],"green":[0,128,0],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"lime":[0,255,0],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"maroon":[128,0,0],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"navy":[0,0,128],"oldlace":[253,245,230],"olive":[128,128,0],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"purple":[128,0,128],"rebeccapurple":[102,51,153],"red":[255,0,0],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"silver":[192,192,192],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"teal":[0,128,128],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"white":[255,255,255],"whitesmoke":[245,245,245],"yellow":[255,255,0],"yellowgreen":[154,205,50]};var conversions=createCommonjsModule(function(module){var reverseKeywords={};for(var key in colorName){if(colorName.hasOwnProperty(key)){reverseKeywords[colorName[key]]=key;}}
var convert=module.exports={rgb:{channels:3,labels:'rgb'},hsl:{channels:3,labels:'hsl'},hsv:{channels:3,labels:'hsv'},hwb:{channels:3,labels:'hwb'},cmyk:{channels:4,labels:'cmyk'},xyz:{channels:3,labels:'xyz'},lab:{channels:3,labels:'lab'},lch:{channels:3,labels:'lch'},hex:{channels:1,labels:['hex']},keyword:{channels:1,labels:['keyword']},ansi16:{channels:1,labels:['ansi16']},ansi256:{channels:1,labels:['ansi256']},hcg:{channels:3,labels:['h','c','g']},apple:{channels:3,labels:['r16','g16','b16']},gray:{channels:1,labels:['gray']}};for(var model in convert){if(convert.hasOwnProperty(model)){if(!('channels'in convert[model])){throw new Error('missing channels property: '+model);}
if(!('labels'in convert[model])){throw new Error('missing channel labels property: '+model);}
if(convert[model].labels.length!==convert[model].channels){throw new Error('channel and label counts mismatch: '+model);}
var channels=convert[model].channels;var labels=convert[model].labels;delete convert[model].channels;delete convert[model].labels;Object.defineProperty(convert[model],'channels',{value:channels});Object.defineProperty(convert[model],'labels',{value:labels});}}
convert.rgb.hsl=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var min=Math.min(r,g,b);var max=Math.max(r,g,b);var delta=max-min;var h;var s;var l;if(max===min){h=0;}else if(r===max){h=(g-b)/delta;}else if(g===max){h=2+(b-r)/delta;}else if(b===max){h=4+(r-g)/delta;}
h=Math.min(h*60,360);if(h<0){h+=360;}
l=(min+max)/2;if(max===min){s=0;}else if(l<=0.5){s=delta/(max+min);}else{s=delta/(2-max-min);}
return[h,s*100,l*100];};convert.rgb.hsv=function(rgb){var rdif;var gdif;var bdif;var h;var s;var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var v=Math.max(r,g,b);var diff=v-Math.min(r,g,b);var diffc=function(c){return(v-c)/6/diff+1/2;};if(diff===0){h=s=0;}else{s=diff/v;rdif=diffc(r);gdif=diffc(g);bdif=diffc(b);if(r===v){h=bdif-gdif;}else if(g===v){h=(1/3)+rdif-bdif;}else if(b===v){h=(2/3)+gdif-rdif;}
if(h<0){h+=1;}else if(h>1){h-=1;}}
return[h*360,s*100,v*100];};convert.rgb.hwb=function(rgb){var r=rgb[0];var g=rgb[1];var b=rgb[2];var h=convert.rgb.hsl(rgb)[0];var w=1/255*Math.min(r,Math.min(g,b));b=1-1/255*Math.max(r,Math.max(g,b));return[h,w*100,b*100];};convert.rgb.cmyk=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var c;var m;var y;var k;k=Math.min(1-r,1-g,1-b);c=(1-r-k)/(1-k)||0;m=(1-g-k)/(1-k)||0;y=(1-b-k)/(1-k)||0;return[c*100,m*100,y*100,k*100];};function comparativeDistance(x,y){return(Math.pow(x[0]-y[0],2)+
Math.pow(x[1]-y[1],2)+
Math.pow(x[2]-y[2],2));}
convert.rgb.keyword=function(rgb){var reversed=reverseKeywords[rgb];if(reversed){return reversed;}
var currentClosestDistance=Infinity;var currentClosestKeyword;for(var keyword in colorName){if(colorName.hasOwnProperty(keyword)){var value=colorName[keyword];var distance=comparativeDistance(rgb,value);if(distance<currentClosestDistance){currentClosestDistance=distance;currentClosestKeyword=keyword;}}}
return currentClosestKeyword;};convert.keyword.rgb=function(keyword){return colorName[keyword];};convert.rgb.xyz=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;r=r>0.04045?Math.pow(((r+0.055)/1.055),2.4):(r/12.92);g=g>0.04045?Math.pow(((g+0.055)/1.055),2.4):(g/12.92);b=b>0.04045?Math.pow(((b+0.055)/1.055),2.4):(b/12.92);var x=(r*0.4124)+(g*0.3576)+(b*0.1805);var y=(r*0.2126)+(g*0.7152)+(b*0.0722);var z=(r*0.0193)+(g*0.1192)+(b*0.9505);return[x*100,y*100,z*100];};convert.rgb.lab=function(rgb){var xyz=convert.rgb.xyz(rgb);var x=xyz[0];var y=xyz[1];var z=xyz[2];var l;var a;var b;x/=95.047;y/=100;z/=108.883;x=x>0.008856?Math.pow(x,1/3):(7.787*x)+(16/116);y=y>0.008856?Math.pow(y,1/3):(7.787*y)+(16/116);z=z>0.008856?Math.pow(z,1/3):(7.787*z)+(16/116);l=(116*y)-16;a=500*(x-y);b=200*(y-z);return[l,a,b];};convert.hsl.rgb=function(hsl){var h=hsl[0]/360;var s=hsl[1]/100;var l=hsl[2]/100;var t1;var t2;var t3;var rgb;var val;if(s===0){val=l*255;return[val,val,val];}
if(l<0.5){t2=l*(1+s);}else{t2=l+s-l*s;}
t1=2*l-t2;rgb=[0,0,0];for(var i=0;i<3;i++){t3=h+1/3*-(i-1);if(t3<0){t3++;}
if(t3>1){t3--;}
if(6*t3<1){val=t1+(t2-t1)*6*t3;}else if(2*t3<1){val=t2;}else if(3*t3<2){val=t1+(t2-t1)*(2/3-t3)*6;}else{val=t1;}
rgb[i]=val*255;}
return rgb;};convert.hsl.hsv=function(hsl){var h=hsl[0];var s=hsl[1]/100;var l=hsl[2]/100;var smin=s;var lmin=Math.max(l,0.01);var sv;var v;l*=2;s*=(l<=1)?l:2-l;smin*=lmin<=1?lmin:2-lmin;v=(l+s)/2;sv=l===0?(2*smin)/(lmin+smin):(2*s)/(l+s);return[h,sv*100,v*100];};convert.hsv.rgb=function(hsv){var h=hsv[0]/60;var s=hsv[1]/100;var v=hsv[2]/100;var hi=Math.floor(h)%6;var f=h-Math.floor(h);var p=255*v*(1-s);var q=255*v*(1-(s*f));var t=255*v*(1-(s*(1-f)));v*=255;switch(hi){case 0:return[v,t,p];case 1:return[q,v,p];case 2:return[p,v,t];case 3:return[p,q,v];case 4:return[t,p,v];case 5:return[v,p,q];}};convert.hsv.hsl=function(hsv){var h=hsv[0];var s=hsv[1]/100;var v=hsv[2]/100;var vmin=Math.max(v,0.01);var lmin;var sl;var l;l=(2-s)*v;lmin=(2-s)*vmin;sl=s*vmin;sl/=(lmin<=1)?lmin:2-lmin;sl=sl||0;l/=2;return[h,sl*100,l*100];};convert.hwb.rgb=function(hwb){var h=hwb[0]/360;var wh=hwb[1]/100;var bl=hwb[2]/100;var ratio=wh+bl;var i;var v;var f;var n;if(ratio>1){wh/=ratio;bl/=ratio;}
i=Math.floor(6*h);v=1-bl;f=6*h-i;if((i&0x01)!==0){f=1-f;}
n=wh+f*(v-wh);var r;var g;var b;switch(i){default:case 6:case 0:r=v;g=n;b=wh;break;case 1:r=n;g=v;b=wh;break;case 2:r=wh;g=v;b=n;break;case 3:r=wh;g=n;b=v;break;case 4:r=n;g=wh;b=v;break;case 5:r=v;g=wh;b=n;break;}
return[r*255,g*255,b*255];};convert.cmyk.rgb=function(cmyk){var c=cmyk[0]/100;var m=cmyk[1]/100;var y=cmyk[2]/100;var k=cmyk[3]/100;var r;var g;var b;r=1-Math.min(1,c*(1-k)+k);g=1-Math.min(1,m*(1-k)+k);b=1-Math.min(1,y*(1-k)+k);return[r*255,g*255,b*255];};convert.xyz.rgb=function(xyz){var x=xyz[0]/100;var y=xyz[1]/100;var z=xyz[2]/100;var r;var g;var b;r=(x*3.2406)+(y*-1.5372)+(z*-0.4986);g=(x*-0.9689)+(y*1.8758)+(z*0.0415);b=(x*0.0557)+(y*-0.2040)+(z*1.0570);r=r>0.0031308?((1.055*Math.pow(r,1.0/2.4))-0.055):r*12.92;g=g>0.0031308?((1.055*Math.pow(g,1.0/2.4))-0.055):g*12.92;b=b>0.0031308?((1.055*Math.pow(b,1.0/2.4))-0.055):b*12.92;r=Math.min(Math.max(0,r),1);g=Math.min(Math.max(0,g),1);b=Math.min(Math.max(0,b),1);return[r*255,g*255,b*255];};convert.xyz.lab=function(xyz){var x=xyz[0];var y=xyz[1];var z=xyz[2];var l;var a;var b;x/=95.047;y/=100;z/=108.883;x=x>0.008856?Math.pow(x,1/3):(7.787*x)+(16/116);y=y>0.008856?Math.pow(y,1/3):(7.787*y)+(16/116);z=z>0.008856?Math.pow(z,1/3):(7.787*z)+(16/116);l=(116*y)-16;a=500*(x-y);b=200*(y-z);return[l,a,b];};convert.lab.xyz=function(lab){var l=lab[0];var a=lab[1];var b=lab[2];var x;var y;var z;y=(l+16)/116;x=a/500+y;z=y-b/200;var y2=Math.pow(y,3);var x2=Math.pow(x,3);var z2=Math.pow(z,3);y=y2>0.008856?y2:(y-16/116)/7.787;x=x2>0.008856?x2:(x-16/116)/7.787;z=z2>0.008856?z2:(z-16/116)/7.787;x*=95.047;y*=100;z*=108.883;return[x,y,z];};convert.lab.lch=function(lab){var l=lab[0];var a=lab[1];var b=lab[2];var hr;var h;var c;hr=Math.atan2(b,a);h=hr*360/2/Math.PI;if(h<0){h+=360;}
c=Math.sqrt(a*a+b*b);return[l,c,h];};convert.lch.lab=function(lch){var l=lch[0];var c=lch[1];var h=lch[2];var a;var b;var hr;hr=h/360*2*Math.PI;a=c*Math.cos(hr);b=c*Math.sin(hr);return[l,a,b];};convert.rgb.ansi16=function(args){var r=args[0];var g=args[1];var b=args[2];var value=1 in arguments?arguments[1]:convert.rgb.hsv(args)[2];value=Math.round(value/50);if(value===0){return 30;}
var ansi=30
+((Math.round(b/255)<<2)|(Math.round(g/255)<<1)|Math.round(r/255));if(value===2){ansi+=60;}
return ansi;};convert.hsv.ansi16=function(args){return convert.rgb.ansi16(convert.hsv.rgb(args),args[2]);};convert.rgb.ansi256=function(args){var r=args[0];var g=args[1];var b=args[2];if(r===g&&g===b){if(r<8){return 16;}
if(r>248){return 231;}
return Math.round(((r-8)/247)*24)+232;}
var ansi=16
+(36*Math.round(r/255*5))
+(6*Math.round(g/255*5))
+Math.round(b/255*5);return ansi;};convert.ansi16.rgb=function(args){var color=args%10;if(color===0||color===7){if(args>50){color+=3.5;}
color=color/10.5*255;return[color,color,color];}
var mult=(~~(args>50)+1)*0.5;var r=((color&1)*mult)*255;var g=(((color>>1)&1)*mult)*255;var b=(((color>>2)&1)*mult)*255;return[r,g,b];};convert.ansi256.rgb=function(args){if(args>=232){var c=(args-232)*10+8;return[c,c,c];}
args-=16;var rem;var r=Math.floor(args/36)/5*255;var g=Math.floor((rem=args%36)/6)/5*255;var b=(rem%6)/5*255;return[r,g,b];};convert.rgb.hex=function(args){var integer=((Math.round(args[0])&0xFF)<<16)
+((Math.round(args[1])&0xFF)<<8)
+(Math.round(args[2])&0xFF);var string=integer.toString(16).toUpperCase();return'000000'.substring(string.length)+string;};convert.hex.rgb=function(args){var match=args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);if(!match){return[0,0,0];}
var colorString=match[0];if(match[0].length===3){colorString=colorString.split('').map(function(char){return char+char;}).join('');}
var integer=parseInt(colorString,16);var r=(integer>>16)&0xFF;var g=(integer>>8)&0xFF;var b=integer&0xFF;return[r,g,b];};convert.rgb.hcg=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var max=Math.max(Math.max(r,g),b);var min=Math.min(Math.min(r,g),b);var chroma=(max-min);var grayscale;var hue;if(chroma<1){grayscale=min/(1-chroma);}else{grayscale=0;}
if(chroma<=0){hue=0;}else
if(max===r){hue=((g-b)/chroma)%6;}else
if(max===g){hue=2+(b-r)/chroma;}else{hue=4+(r-g)/chroma+4;}
hue/=6;hue%=1;return[hue*360,chroma*100,grayscale*100];};convert.hsl.hcg=function(hsl){var s=hsl[1]/100;var l=hsl[2]/100;var c=1;var f=0;if(l<0.5){c=2.0*s*l;}else{c=2.0*s*(1.0-l);}
if(c<1.0){f=(l-0.5*c)/(1.0-c);}
return[hsl[0],c*100,f*100];};convert.hsv.hcg=function(hsv){var s=hsv[1]/100;var v=hsv[2]/100;var c=s*v;var f=0;if(c<1.0){f=(v-c)/(1-c);}
return[hsv[0],c*100,f*100];};convert.hcg.rgb=function(hcg){var h=hcg[0]/360;var c=hcg[1]/100;var g=hcg[2]/100;if(c===0.0){return[g*255,g*255,g*255];}
var pure=[0,0,0];var hi=(h%1)*6;var v=hi%1;var w=1-v;var mg=0;switch(Math.floor(hi)){case 0:pure[0]=1;pure[1]=v;pure[2]=0;break;case 1:pure[0]=w;pure[1]=1;pure[2]=0;break;case 2:pure[0]=0;pure[1]=1;pure[2]=v;break;case 3:pure[0]=0;pure[1]=w;pure[2]=1;break;case 4:pure[0]=v;pure[1]=0;pure[2]=1;break;default:pure[0]=1;pure[1]=0;pure[2]=w;}
mg=(1.0-c)*g;return[(c*pure[0]+mg)*255,(c*pure[1]+mg)*255,(c*pure[2]+mg)*255];};convert.hcg.hsv=function(hcg){var c=hcg[1]/100;var g=hcg[2]/100;var v=c+g*(1.0-c);var f=0;if(v>0.0){f=c/v;}
return[hcg[0],f*100,v*100];};convert.hcg.hsl=function(hcg){var c=hcg[1]/100;var g=hcg[2]/100;var l=g*(1.0-c)+0.5*c;var s=0;if(l>0.0&&l<0.5){s=c/(2*l);}else
if(l>=0.5&&l<1.0){s=c/(2*(1-l));}
return[hcg[0],s*100,l*100];};convert.hcg.hwb=function(hcg){var c=hcg[1]/100;var g=hcg[2]/100;var v=c+g*(1.0-c);return[hcg[0],(v-c)*100,(1-v)*100];};convert.hwb.hcg=function(hwb){var w=hwb[1]/100;var b=hwb[2]/100;var v=1-b;var c=v-w;var g=0;if(c<1){g=(v-c)/(1-c);}
return[hwb[0],c*100,g*100];};convert.apple.rgb=function(apple){return[(apple[0]/65535)*255,(apple[1]/65535)*255,(apple[2]/65535)*255];};convert.rgb.apple=function(rgb){return[(rgb[0]/255)*65535,(rgb[1]/255)*65535,(rgb[2]/255)*65535];};convert.gray.rgb=function(args){return[args[0]/100*255,args[0]/100*255,args[0]/100*255];};convert.gray.hsl=convert.gray.hsv=function(args){return[0,0,args[0]];};convert.gray.hwb=function(gray){return[0,100,gray[0]];};convert.gray.cmyk=function(gray){return[0,0,0,gray[0]];};convert.gray.lab=function(gray){return[gray[0],0,0];};convert.gray.hex=function(gray){var val=Math.round(gray[0]/100*255)&0xFF;var integer=(val<<16)+(val<<8)+val;var string=integer.toString(16).toUpperCase();return'000000'.substring(string.length)+string;};convert.rgb.gray=function(rgb){var val=(rgb[0]+rgb[1]+rgb[2])/3;return[val/255*100];};});var conversions_1=conversions.rgb;var conversions_2=conversions.hsl;var conversions_3=conversions.hsv;var conversions_4=conversions.hwb;var conversions_5=conversions.cmyk;var conversions_6=conversions.xyz;var conversions_7=conversions.lab;var conversions_8=conversions.lch;var conversions_9=conversions.hex;var conversions_10=conversions.keyword;var conversions_11=conversions.ansi16;var conversions_12=conversions.ansi256;var conversions_13=conversions.hcg;var conversions_14=conversions.apple;var conversions_15=conversions.gray;function buildGraph(){var graph={};var models=Object.keys(conversions);for(var len=models.length,i=0;i<len;i++){graph[models[i]]={distance:-1,parent:null};}
return graph;}
function deriveBFS(fromModel){var graph=buildGraph();var queue=[fromModel];graph[fromModel].distance=0;while(queue.length){var current=queue.pop();var adjacents=Object.keys(conversions[current]);for(var len=adjacents.length,i=0;i<len;i++){var adjacent=adjacents[i];var node=graph[adjacent];if(node.distance===-1){node.distance=graph[current].distance+1;node.parent=current;queue.unshift(adjacent);}}}
return graph;}
function link(from,to){return function(args){return to(from(args));};}
function wrapConversion(toModel,graph){var path=[graph[toModel].parent,toModel];var fn=conversions[graph[toModel].parent][toModel];var cur=graph[toModel].parent;while(graph[cur].parent){path.unshift(graph[cur].parent);fn=link(conversions[graph[cur].parent][cur],fn);cur=graph[cur].parent;}
fn.conversion=path;return fn;}
var route=function(fromModel){var graph=deriveBFS(fromModel);var conversion={};var models=Object.keys(graph);for(var len=models.length,i=0;i<len;i++){var toModel=models[i];var node=graph[toModel];if(node.parent===null){continue;}
conversion[toModel]=wrapConversion(toModel,graph);}
return conversion;};var convert={};var models=Object.keys(conversions);function wrapRaw(fn){var wrappedFn=function(args){if(args===undefined||args===null){return args;}
if(arguments.length>1){args=Array.prototype.slice.call(arguments);}
return fn(args);};if('conversion'in fn){wrappedFn.conversion=fn.conversion;}
return wrappedFn;}
function wrapRounded(fn){var wrappedFn=function(args){if(args===undefined||args===null){return args;}
if(arguments.length>1){args=Array.prototype.slice.call(arguments);}
var result=fn(args);if(typeof result==='object'){for(var len=result.length,i=0;i<len;i++){result[i]=Math.round(result[i]);}}
return result;};if('conversion'in fn){wrappedFn.conversion=fn.conversion;}
return wrappedFn;}
models.forEach(function(fromModel){convert[fromModel]={};Object.defineProperty(convert[fromModel],'channels',{value:conversions[fromModel].channels});Object.defineProperty(convert[fromModel],'labels',{value:conversions[fromModel].labels});var routes=route(fromModel);var routeModels=Object.keys(routes);routeModels.forEach(function(toModel){var fn=routes[toModel];convert[fromModel][toModel]=wrapRounded(fn);convert[fromModel][toModel].raw=wrapRaw(fn);});});var colorConvert=convert;var colorName$1={"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aqua":[0,255,255],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"black":[0,0,0],"blanchedalmond":[255,235,205],"blue":[0,0,255],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"fuchsia":[255,0,255],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"gray":[128,128,128],"green":[0,128,0],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"lime":[0,255,0],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"maroon":[128,0,0],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"navy":[0,0,128],"oldlace":[253,245,230],"olive":[128,128,0],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"purple":[128,0,128],"rebeccapurple":[102,51,153],"red":[255,0,0],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"silver":[192,192,192],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"teal":[0,128,128],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"white":[255,255,255],"whitesmoke":[245,245,245],"yellow":[255,255,0],"yellowgreen":[154,205,50]};var colorString={getRgba:getRgba,getHsla:getHsla,getRgb:getRgb,getHsl:getHsl,getHwb:getHwb,getAlpha:getAlpha,hexString:hexString,rgbString:rgbString,rgbaString:rgbaString,percentString:percentString,percentaString:percentaString,hslString:hslString,hslaString:hslaString,hwbString:hwbString,keyword:keyword};function getRgba(string){if(!string){return;}
var abbr=/^#([a-fA-F0-9]{3,4})$/i,hex=/^#([a-fA-F0-9]{6}([a-fA-F0-9]{2})?)$/i,rgba=/^rgba?\(\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/i,per=/^rgba?\(\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/i,keyword=/(\w+)/;var rgb=[0,0,0],a=1,match=string.match(abbr),hexAlpha="";if(match){match=match[1];hexAlpha=match[3];for(var i=0;i<rgb.length;i++){rgb[i]=parseInt(match[i]+match[i],16);}
if(hexAlpha){a=Math.round((parseInt(hexAlpha+hexAlpha,16)/255)*100)/100;}}
else if(match=string.match(hex)){hexAlpha=match[2];match=match[1];for(var i=0;i<rgb.length;i++){rgb[i]=parseInt(match.slice(i*2,i*2+2),16);}
if(hexAlpha){a=Math.round((parseInt(hexAlpha,16)/255)*100)/100;}}
else if(match=string.match(rgba)){for(var i=0;i<rgb.length;i++){rgb[i]=parseInt(match[i+1]);}
a=parseFloat(match[4]);}
else if(match=string.match(per)){for(var i=0;i<rgb.length;i++){rgb[i]=Math.round(parseFloat(match[i+1])*2.55);}
a=parseFloat(match[4]);}
else if(match=string.match(keyword)){if(match[1]=="transparent"){return[0,0,0,0];}
rgb=colorName$1[match[1]];if(!rgb){return;}}
for(var i=0;i<rgb.length;i++){rgb[i]=scale(rgb[i],0,255);}
if(!a&&a!=0){a=1;}
else{a=scale(a,0,1);}
rgb[3]=a;return rgb;}
function getHsla(string){if(!string){return;}
var hsl=/^hsla?\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/;var match=string.match(hsl);if(match){var alpha=parseFloat(match[4]);var h=scale(parseInt(match[1]),0,360),s=scale(parseFloat(match[2]),0,100),l=scale(parseFloat(match[3]),0,100),a=scale(isNaN(alpha)?1:alpha,0,1);return[h,s,l,a];}}
function getHwb(string){if(!string){return;}
var hwb=/^hwb\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/;var match=string.match(hwb);if(match){var alpha=parseFloat(match[4]);var h=scale(parseInt(match[1]),0,360),w=scale(parseFloat(match[2]),0,100),b=scale(parseFloat(match[3]),0,100),a=scale(isNaN(alpha)?1:alpha,0,1);return[h,w,b,a];}}
function getRgb(string){var rgba=getRgba(string);return rgba&&rgba.slice(0,3);}
function getHsl(string){var hsla=getHsla(string);return hsla&&hsla.slice(0,3);}
function getAlpha(string){var vals=getRgba(string);if(vals){return vals[3];}
else if(vals=getHsla(string)){return vals[3];}
else if(vals=getHwb(string)){return vals[3];}}
function hexString(rgba,a){var a=(a!==undefined&&rgba.length===3)?a:rgba[3];return"#"+hexDouble(rgba[0])
+hexDouble(rgba[1])
+hexDouble(rgba[2])
+((a>=0&&a<1)?hexDouble(Math.round(a*255)):"");}
function rgbString(rgba,alpha){if(alpha<1||(rgba[3]&&rgba[3]<1)){return rgbaString(rgba,alpha);}
return"rgb("+rgba[0]+", "+rgba[1]+", "+rgba[2]+")";}
function rgbaString(rgba,alpha){if(alpha===undefined){alpha=(rgba[3]!==undefined?rgba[3]:1);}
return"rgba("+rgba[0]+", "+rgba[1]+", "+rgba[2]
+", "+alpha+")";}
function percentString(rgba,alpha){if(alpha<1||(rgba[3]&&rgba[3]<1)){return percentaString(rgba,alpha);}
var r=Math.round(rgba[0]/255*100),g=Math.round(rgba[1]/255*100),b=Math.round(rgba[2]/255*100);return"rgb("+r+"%, "+g+"%, "+b+"%)";}
function percentaString(rgba,alpha){var r=Math.round(rgba[0]/255*100),g=Math.round(rgba[1]/255*100),b=Math.round(rgba[2]/255*100);return"rgba("+r+"%, "+g+"%, "+b+"%, "+(alpha||rgba[3]||1)+")";}
function hslString(hsla,alpha){if(alpha<1||(hsla[3]&&hsla[3]<1)){return hslaString(hsla,alpha);}
return"hsl("+hsla[0]+", "+hsla[1]+"%, "+hsla[2]+"%)";}
function hslaString(hsla,alpha){if(alpha===undefined){alpha=(hsla[3]!==undefined?hsla[3]:1);}
return"hsla("+hsla[0]+", "+hsla[1]+"%, "+hsla[2]+"%, "
+alpha+")";}
function hwbString(hwb,alpha){if(alpha===undefined){alpha=(hwb[3]!==undefined?hwb[3]:1);}
return"hwb("+hwb[0]+", "+hwb[1]+"%, "+hwb[2]+"%"
+(alpha!==undefined&&alpha!==1?", "+alpha:"")+")";}
function keyword(rgb){return reverseNames[rgb.slice(0,3)];}
function scale(num,min,max){return Math.min(Math.max(min,num),max);}
function hexDouble(num){var str=num.toString(16).toUpperCase();return(str.length<2)?"0"+str:str;}
var reverseNames={};for(var name in colorName$1){reverseNames[colorName$1[name]]=name;}
var Color=function(obj){if(obj instanceof Color){return obj;}
if(!(this instanceof Color)){return new Color(obj);}
this.valid=false;this.values={rgb:[0,0,0],hsl:[0,0,0],hsv:[0,0,0],hwb:[0,0,0],cmyk:[0,0,0,0],alpha:1};var vals;if(typeof obj==='string'){vals=colorString.getRgba(obj);if(vals){this.setValues('rgb',vals);}else if(vals=colorString.getHsla(obj)){this.setValues('hsl',vals);}else if(vals=colorString.getHwb(obj)){this.setValues('hwb',vals);}}else if(typeof obj==='object'){vals=obj;if(vals.r!==undefined||vals.red!==undefined){this.setValues('rgb',vals);}else if(vals.l!==undefined||vals.lightness!==undefined){this.setValues('hsl',vals);}else if(vals.v!==undefined||vals.value!==undefined){this.setValues('hsv',vals);}else if(vals.w!==undefined||vals.whiteness!==undefined){this.setValues('hwb',vals);}else if(vals.c!==undefined||vals.cyan!==undefined){this.setValues('cmyk',vals);}}};Color.prototype={isValid:function(){return this.valid;},rgb:function(){return this.setSpace('rgb',arguments);},hsl:function(){return this.setSpace('hsl',arguments);},hsv:function(){return this.setSpace('hsv',arguments);},hwb:function(){return this.setSpace('hwb',arguments);},cmyk:function(){return this.setSpace('cmyk',arguments);},rgbArray:function(){return this.values.rgb;},hslArray:function(){return this.values.hsl;},hsvArray:function(){return this.values.hsv;},hwbArray:function(){var values=this.values;if(values.alpha!==1){return values.hwb.concat([values.alpha]);}
return values.hwb;},cmykArray:function(){return this.values.cmyk;},rgbaArray:function(){var values=this.values;return values.rgb.concat([values.alpha]);},hslaArray:function(){var values=this.values;return values.hsl.concat([values.alpha]);},alpha:function(val){if(val===undefined){return this.values.alpha;}
this.setValues('alpha',val);return this;},red:function(val){return this.setChannel('rgb',0,val);},green:function(val){return this.setChannel('rgb',1,val);},blue:function(val){return this.setChannel('rgb',2,val);},hue:function(val){if(val){val%=360;val=val<0?360+val:val;}
return this.setChannel('hsl',0,val);},saturation:function(val){return this.setChannel('hsl',1,val);},lightness:function(val){return this.setChannel('hsl',2,val);},saturationv:function(val){return this.setChannel('hsv',1,val);},whiteness:function(val){return this.setChannel('hwb',1,val);},blackness:function(val){return this.setChannel('hwb',2,val);},value:function(val){return this.setChannel('hsv',2,val);},cyan:function(val){return this.setChannel('cmyk',0,val);},magenta:function(val){return this.setChannel('cmyk',1,val);},yellow:function(val){return this.setChannel('cmyk',2,val);},black:function(val){return this.setChannel('cmyk',3,val);},hexString:function(){return colorString.hexString(this.values.rgb);},rgbString:function(){return colorString.rgbString(this.values.rgb,this.values.alpha);},rgbaString:function(){return colorString.rgbaString(this.values.rgb,this.values.alpha);},percentString:function(){return colorString.percentString(this.values.rgb,this.values.alpha);},hslString:function(){return colorString.hslString(this.values.hsl,this.values.alpha);},hslaString:function(){return colorString.hslaString(this.values.hsl,this.values.alpha);},hwbString:function(){return colorString.hwbString(this.values.hwb,this.values.alpha);},keyword:function(){return colorString.keyword(this.values.rgb,this.values.alpha);},rgbNumber:function(){var rgb=this.values.rgb;return(rgb[0]<<16)|(rgb[1]<<8)|rgb[2];},luminosity:function(){var rgb=this.values.rgb;var lum=[];for(var i=0;i<rgb.length;i++){var chan=rgb[i]/255;lum[i]=(chan<=0.03928)?chan/12.92:Math.pow(((chan+0.055)/1.055),2.4);}
return 0.2126*lum[0]+0.7152*lum[1]+0.0722*lum[2];},contrast:function(color2){var lum1=this.luminosity();var lum2=color2.luminosity();if(lum1>lum2){return(lum1+0.05)/(lum2+0.05);}
return(lum2+0.05)/(lum1+0.05);},level:function(color2){var contrastRatio=this.contrast(color2);if(contrastRatio>=7.1){return'AAA';}
return(contrastRatio>=4.5)?'AA':'';},dark:function(){var rgb=this.values.rgb;var yiq=(rgb[0]*299+rgb[1]*587+rgb[2]*114)/1000;return yiq<128;},light:function(){return!this.dark();},negate:function(){var rgb=[];for(var i=0;i<3;i++){rgb[i]=255-this.values.rgb[i];}
this.setValues('rgb',rgb);return this;},lighten:function(ratio){var hsl=this.values.hsl;hsl[2]+=hsl[2]*ratio;this.setValues('hsl',hsl);return this;},darken:function(ratio){var hsl=this.values.hsl;hsl[2]-=hsl[2]*ratio;this.setValues('hsl',hsl);return this;},saturate:function(ratio){var hsl=this.values.hsl;hsl[1]+=hsl[1]*ratio;this.setValues('hsl',hsl);return this;},desaturate:function(ratio){var hsl=this.values.hsl;hsl[1]-=hsl[1]*ratio;this.setValues('hsl',hsl);return this;},whiten:function(ratio){var hwb=this.values.hwb;hwb[1]+=hwb[1]*ratio;this.setValues('hwb',hwb);return this;},blacken:function(ratio){var hwb=this.values.hwb;hwb[2]+=hwb[2]*ratio;this.setValues('hwb',hwb);return this;},greyscale:function(){var rgb=this.values.rgb;var val=rgb[0]*0.3+rgb[1]*0.59+rgb[2]*0.11;this.setValues('rgb',[val,val,val]);return this;},clearer:function(ratio){var alpha=this.values.alpha;this.setValues('alpha',alpha-(alpha*ratio));return this;},opaquer:function(ratio){var alpha=this.values.alpha;this.setValues('alpha',alpha+(alpha*ratio));return this;},rotate:function(degrees){var hsl=this.values.hsl;var hue=(hsl[0]+degrees)%360;hsl[0]=hue<0?360+hue:hue;this.setValues('hsl',hsl);return this;},mix:function(mixinColor,weight){var color1=this;var color2=mixinColor;var p=weight===undefined?0.5:weight;var w=2*p-1;var a=color1.alpha()-color2.alpha();var w1=(((w*a===-1)?w:(w+a)/(1+w*a))+1)/2.0;var w2=1-w1;return this.rgb(w1*color1.red()+w2*color2.red(),w1*color1.green()+w2*color2.green(),w1*color1.blue()+w2*color2.blue()).alpha(color1.alpha()*p+color2.alpha()*(1-p));},toJSON:function(){return this.rgb();},clone:function(){var result=new Color();var source=this.values;var target=result.values;var value,type;for(var prop in source){if(source.hasOwnProperty(prop)){value=source[prop];type=({}).toString.call(value);if(type==='[object Array]'){target[prop]=value.slice(0);}else if(type==='[object Number]'){target[prop]=value;}else{console.error('unexpected color value:',value);}}}
return result;}};Color.prototype.spaces={rgb:['red','green','blue'],hsl:['hue','saturation','lightness'],hsv:['hue','saturation','value'],hwb:['hue','whiteness','blackness'],cmyk:['cyan','magenta','yellow','black']};Color.prototype.maxes={rgb:[255,255,255],hsl:[360,100,100],hsv:[360,100,100],hwb:[360,100,100],cmyk:[100,100,100,100]};Color.prototype.getValues=function(space){var values=this.values;var vals={};for(var i=0;i<space.length;i++){vals[space.charAt(i)]=values[space][i];}
if(values.alpha!==1){vals.a=values.alpha;}
return vals;};Color.prototype.setValues=function(space,vals){var values=this.values;var spaces=this.spaces;var maxes=this.maxes;var alpha=1;var i;this.valid=true;if(space==='alpha'){alpha=vals;}else if(vals.length){values[space]=vals.slice(0,space.length);alpha=vals[space.length];}else if(vals[space.charAt(0)]!==undefined){for(i=0;i<space.length;i++){values[space][i]=vals[space.charAt(i)];}
alpha=vals.a;}else if(vals[spaces[space][0]]!==undefined){var chans=spaces[space];for(i=0;i<space.length;i++){values[space][i]=vals[chans[i]];}
alpha=vals.alpha;}
values.alpha=Math.max(0,Math.min(1,(alpha===undefined?values.alpha:alpha)));if(space==='alpha'){return false;}
var capped;for(i=0;i<space.length;i++){capped=Math.max(0,Math.min(maxes[space][i],values[space][i]));values[space][i]=Math.round(capped);}
for(var sname in spaces){if(sname!==space){values[sname]=colorConvert[space][sname](values[space]);}}
return true;};Color.prototype.setSpace=function(space,args){var vals=args[0];if(vals===undefined){return this.getValues(space);}
if(typeof vals==='number'){vals=Array.prototype.slice.call(args);}
this.setValues(space,vals);return this;};Color.prototype.setChannel=function(space,index,val){var svalues=this.values[space];if(val===undefined){return svalues[index];}else if(val===svalues[index]){return this;}
svalues[index]=val;this.setValues(space,svalues);return this;};if(typeof window!=='undefined'){window.Color=Color;}
var chartjsColor=Color;var helpers={noop:function(){},uid:(function(){var id=0;return function(){return id++;};}()),isNullOrUndef:function(value){return value===null||typeof value==='undefined';},isArray:function(value){if(Array.isArray&&Array.isArray(value)){return true;}
var type=Object.prototype.toString.call(value);if(type.substr(0,7)==='[object'&&type.substr(-6)==='Array]'){return true;}
return false;},isObject:function(value){return value!==null&&Object.prototype.toString.call(value)==='[object Object]';},isFinite:function(value){return(typeof value==='number'||value instanceof Number)&&isFinite(value);},valueOrDefault:function(value,defaultValue){return typeof value==='undefined'?defaultValue:value;},valueAtIndexOrDefault:function(value,index,defaultValue){return helpers.valueOrDefault(helpers.isArray(value)?value[index]:value,defaultValue);},callback:function(fn,args,thisArg){if(fn&&typeof fn.call==='function'){return fn.apply(thisArg,args);}},each:function(loopable,fn,thisArg,reverse){var i,len,keys;if(helpers.isArray(loopable)){len=loopable.length;if(reverse){for(i=len-1;i>=0;i--){fn.call(thisArg,loopable[i],i);}}else{for(i=0;i<len;i++){fn.call(thisArg,loopable[i],i);}}}else if(helpers.isObject(loopable)){keys=Object.keys(loopable);len=keys.length;for(i=0;i<len;i++){fn.call(thisArg,loopable[keys[i]],keys[i]);}}},arrayEquals:function(a0,a1){var i,ilen,v0,v1;if(!a0||!a1||a0.length!==a1.length){return false;}
for(i=0,ilen=a0.length;i<ilen;++i){v0=a0[i];v1=a1[i];if(v0 instanceof Array&&v1 instanceof Array){if(!helpers.arrayEquals(v0,v1)){return false;}}else if(v0!==v1){return false;}}
return true;},clone:function(source){if(helpers.isArray(source)){return source.map(helpers.clone);}
if(helpers.isObject(source)){var target={};var keys=Object.keys(source);var klen=keys.length;var k=0;for(;k<klen;++k){target[keys[k]]=helpers.clone(source[keys[k]]);}
return target;}
return source;},_merger:function(key,target,source,options){var tval=target[key];var sval=source[key];if(helpers.isObject(tval)&&helpers.isObject(sval)){helpers.merge(tval,sval,options);}else{target[key]=helpers.clone(sval);}},_mergerIf:function(key,target,source){var tval=target[key];var sval=source[key];if(helpers.isObject(tval)&&helpers.isObject(sval)){helpers.mergeIf(tval,sval);}else if(!target.hasOwnProperty(key)){target[key]=helpers.clone(sval);}},merge:function(target,source,options){var sources=helpers.isArray(source)?source:[source];var ilen=sources.length;var merge,i,keys,klen,k;if(!helpers.isObject(target)){return target;}
options=options||{};merge=options.merger||helpers._merger;for(i=0;i<ilen;++i){source=sources[i];if(!helpers.isObject(source)){continue;}
keys=Object.keys(source);for(k=0,klen=keys.length;k<klen;++k){merge(keys[k],target,source,options);}}
return target;},mergeIf:function(target,source){return helpers.merge(target,source,{merger:helpers._mergerIf});},extend:Object.assign||function(target){return helpers.merge(target,[].slice.call(arguments,1),{merger:function(key,dst,src){dst[key]=src[key];}});},inherits:function(extensions){var me=this;var ChartElement=(extensions&&extensions.hasOwnProperty('constructor'))?extensions.constructor:function(){return me.apply(this,arguments);};var Surrogate=function(){this.constructor=ChartElement;};Surrogate.prototype=me.prototype;ChartElement.prototype=new Surrogate();ChartElement.extend=helpers.inherits;if(extensions){helpers.extend(ChartElement.prototype,extensions);}
ChartElement.__super__=me.prototype;return ChartElement;},_deprecated:function(scope,value,previous,current){if(value!==undefined){console.warn(scope+': "'+previous+'" is deprecated. Please use "'+current+'" instead');}}};var helpers_core=helpers;helpers.callCallback=helpers.callback;helpers.indexOf=function(array,item,fromIndex){return Array.prototype.indexOf.call(array,item,fromIndex);};helpers.getValueOrDefault=helpers.valueOrDefault;helpers.getValueAtIndexOrDefault=helpers.valueAtIndexOrDefault;var effects={linear:function(t){return t;},easeInQuad:function(t){return t*t;},easeOutQuad:function(t){return-t*(t-2);},easeInOutQuad:function(t){if((t/=0.5)<1){return 0.5*t*t;}
return-0.5*((--t)*(t-2)-1);},easeInCubic:function(t){return t*t*t;},easeOutCubic:function(t){return(t=t-1)*t*t+1;},easeInOutCubic:function(t){if((t/=0.5)<1){return 0.5*t*t*t;}
return 0.5*((t-=2)*t*t+2);},easeInQuart:function(t){return t*t*t*t;},easeOutQuart:function(t){return-((t=t-1)*t*t*t-1);},easeInOutQuart:function(t){if((t/=0.5)<1){return 0.5*t*t*t*t;}
return-0.5*((t-=2)*t*t*t-2);},easeInQuint:function(t){return t*t*t*t*t;},easeOutQuint:function(t){return(t=t-1)*t*t*t*t+1;},easeInOutQuint:function(t){if((t/=0.5)<1){return 0.5*t*t*t*t*t;}
return 0.5*((t-=2)*t*t*t*t+2);},easeInSine:function(t){return-Math.cos(t*(Math.PI/2))+1;},easeOutSine:function(t){return Math.sin(t*(Math.PI/2));},easeInOutSine:function(t){return-0.5*(Math.cos(Math.PI*t)-1);},easeInExpo:function(t){return(t===0)?0:Math.pow(2,10*(t-1));},easeOutExpo:function(t){return(t===1)?1:-Math.pow(2,-10*t)+1;},easeInOutExpo:function(t){if(t===0){return 0;}
if(t===1){return 1;}
if((t/=0.5)<1){return 0.5*Math.pow(2,10*(t-1));}
return 0.5*(-Math.pow(2,-10*--t)+2);},easeInCirc:function(t){if(t>=1){return t;}
return-(Math.sqrt(1-t*t)-1);},easeOutCirc:function(t){return Math.sqrt(1-(t=t-1)*t);},easeInOutCirc:function(t){if((t/=0.5)<1){return-0.5*(Math.sqrt(1-t*t)-1);}
return 0.5*(Math.sqrt(1-(t-=2)*t)+1);},easeInElastic:function(t){var s=1.70158;var p=0;var a=1;if(t===0){return 0;}
if(t===1){return 1;}
if(!p){p=0.3;}
if(a<1){a=1;s=p/4;}else{s=p/(2*Math.PI)*Math.asin(1/a);}
return-(a*Math.pow(2,10*(t-=1))*Math.sin((t-s)*(2*Math.PI)/p));},easeOutElastic:function(t){var s=1.70158;var p=0;var a=1;if(t===0){return 0;}
if(t===1){return 1;}
if(!p){p=0.3;}
if(a<1){a=1;s=p/4;}else{s=p/(2*Math.PI)*Math.asin(1/a);}
return a*Math.pow(2,-10*t)*Math.sin((t-s)*(2*Math.PI)/p)+1;},easeInOutElastic:function(t){var s=1.70158;var p=0;var a=1;if(t===0){return 0;}
if((t/=0.5)===2){return 1;}
if(!p){p=0.45;}
if(a<1){a=1;s=p/4;}else{s=p/(2*Math.PI)*Math.asin(1/a);}
if(t<1){return-0.5*(a*Math.pow(2,10*(t-=1))*Math.sin((t-s)*(2*Math.PI)/p));}
return a*Math.pow(2,-10*(t-=1))*Math.sin((t-s)*(2*Math.PI)/p)*0.5+1;},easeInBack:function(t){var s=1.70158;return t*t*((s+1)*t-s);},easeOutBack:function(t){var s=1.70158;return(t=t-1)*t*((s+1)*t+s)+1;},easeInOutBack:function(t){var s=1.70158;if((t/=0.5)<1){return 0.5*(t*t*(((s*=(1.525))+1)*t-s));}
return 0.5*((t-=2)*t*(((s*=(1.525))+1)*t+s)+2);},easeInBounce:function(t){return 1-effects.easeOutBounce(1-t);},easeOutBounce:function(t){if(t<(1/2.75)){return 7.5625*t*t;}
if(t<(2/2.75)){return 7.5625*(t-=(1.5/2.75))*t+0.75;}
if(t<(2.5/2.75)){return 7.5625*(t-=(2.25/2.75))*t+0.9375;}
return 7.5625*(t-=(2.625/2.75))*t+0.984375;},easeInOutBounce:function(t){if(t<0.5){return effects.easeInBounce(t*2)*0.5;}
return effects.easeOutBounce(t*2-1)*0.5+0.5;}};var helpers_easing={effects:effects};helpers_core.easingEffects=effects;var PI=Math.PI;var RAD_PER_DEG=PI/180;var DOUBLE_PI=PI*2;var HALF_PI=PI/2;var QUARTER_PI=PI/4;var TWO_THIRDS_PI=PI*2/3;var exports$1={clear:function(chart){chart.ctx.clearRect(0,0,chart.width,chart.height);},roundedRect:function(ctx,x,y,width,height,radius){if(radius){var r=Math.min(radius,height/2,width/2);var left=x+r;var top=y+r;var right=x+width-r;var bottom=y+height-r;ctx.moveTo(x,top);if(left<right&&top<bottom){ctx.arc(left,top,r,-PI,-HALF_PI);ctx.arc(right,top,r,-HALF_PI,0);ctx.arc(right,bottom,r,0,HALF_PI);ctx.arc(left,bottom,r,HALF_PI,PI);}else if(left<right){ctx.moveTo(left,y);ctx.arc(right,top,r,-HALF_PI,HALF_PI);ctx.arc(left,top,r,HALF_PI,PI+HALF_PI);}else if(top<bottom){ctx.arc(left,top,r,-PI,0);ctx.arc(left,bottom,r,0,PI);}else{ctx.arc(left,top,r,-PI,PI);}
ctx.closePath();ctx.moveTo(x,y);}else{ctx.rect(x,y,width,height);}},drawPoint:function(ctx,style,radius,x,y,rotation){var type,xOffset,yOffset,size,cornerRadius;var rad=(rotation||0)*RAD_PER_DEG;if(style&&typeof style==='object'){type=style.toString();if(type==='[object HTMLImageElement]'||type==='[object HTMLCanvasElement]'){ctx.save();ctx.translate(x,y);ctx.rotate(rad);ctx.drawImage(style,-style.width/2,-style.height/2,style.width,style.height);ctx.restore();return;}}
if(isNaN(radius)||radius<=0){return;}
ctx.beginPath();switch(style){default:ctx.arc(x,y,radius,0,DOUBLE_PI);ctx.closePath();break;case'triangle':ctx.moveTo(x+Math.sin(rad)*radius,y-Math.cos(rad)*radius);rad+=TWO_THIRDS_PI;ctx.lineTo(x+Math.sin(rad)*radius,y-Math.cos(rad)*radius);rad+=TWO_THIRDS_PI;ctx.lineTo(x+Math.sin(rad)*radius,y-Math.cos(rad)*radius);ctx.closePath();break;case'rectRounded':cornerRadius=radius*0.516;size=radius-cornerRadius;xOffset=Math.cos(rad+QUARTER_PI)*size;yOffset=Math.sin(rad+QUARTER_PI)*size;ctx.arc(x-xOffset,y-yOffset,cornerRadius,rad-PI,rad-HALF_PI);ctx.arc(x+yOffset,y-xOffset,cornerRadius,rad-HALF_PI,rad);ctx.arc(x+xOffset,y+yOffset,cornerRadius,rad,rad+HALF_PI);ctx.arc(x-yOffset,y+xOffset,cornerRadius,rad+HALF_PI,rad+PI);ctx.closePath();break;case'rect':if(!rotation){size=Math.SQRT1_2*radius;ctx.rect(x-size,y-size,2*size,2*size);break;}
rad+=QUARTER_PI;case'rectRot':xOffset=Math.cos(rad)*radius;yOffset=Math.sin(rad)*radius;ctx.moveTo(x-xOffset,y-yOffset);ctx.lineTo(x+yOffset,y-xOffset);ctx.lineTo(x+xOffset,y+yOffset);ctx.lineTo(x-yOffset,y+xOffset);ctx.closePath();break;case'crossRot':rad+=QUARTER_PI;case'cross':xOffset=Math.cos(rad)*radius;yOffset=Math.sin(rad)*radius;ctx.moveTo(x-xOffset,y-yOffset);ctx.lineTo(x+xOffset,y+yOffset);ctx.moveTo(x+yOffset,y-xOffset);ctx.lineTo(x-yOffset,y+xOffset);break;case'star':xOffset=Math.cos(rad)*radius;yOffset=Math.sin(rad)*radius;ctx.moveTo(x-xOffset,y-yOffset);ctx.lineTo(x+xOffset,y+yOffset);ctx.moveTo(x+yOffset,y-xOffset);ctx.lineTo(x-yOffset,y+xOffset);rad+=QUARTER_PI;xOffset=Math.cos(rad)*radius;yOffset=Math.sin(rad)*radius;ctx.moveTo(x-xOffset,y-yOffset);ctx.lineTo(x+xOffset,y+yOffset);ctx.moveTo(x+yOffset,y-xOffset);ctx.lineTo(x-yOffset,y+xOffset);break;case'line':xOffset=Math.cos(rad)*radius;yOffset=Math.sin(rad)*radius;ctx.moveTo(x-xOffset,y-yOffset);ctx.lineTo(x+xOffset,y+yOffset);break;case'dash':ctx.moveTo(x,y);ctx.lineTo(x+Math.cos(rad)*radius,y+Math.sin(rad)*radius);break;}
ctx.fill();ctx.stroke();},_isPointInArea:function(point,area){var epsilon=1e-6;return point.x>area.left-epsilon&&point.x<area.right+epsilon&&point.y>area.top-epsilon&&point.y<area.bottom+epsilon;},clipArea:function(ctx,area){ctx.save();ctx.beginPath();ctx.rect(area.left,area.top,area.right-area.left,area.bottom-area.top);ctx.clip();},unclipArea:function(ctx){ctx.restore();},lineTo:function(ctx,previous,target,flip){var stepped=target.steppedLine;if(stepped){if(stepped==='middle'){var midpoint=(previous.x+target.x)/2.0;ctx.lineTo(midpoint,flip?target.y:previous.y);ctx.lineTo(midpoint,flip?previous.y:target.y);}else if((stepped==='after'&&!flip)||(stepped!=='after'&&flip)){ctx.lineTo(previous.x,target.y);}else{ctx.lineTo(target.x,previous.y);}
ctx.lineTo(target.x,target.y);return;}
if(!target.tension){ctx.lineTo(target.x,target.y);return;}
ctx.bezierCurveTo(flip?previous.controlPointPreviousX:previous.controlPointNextX,flip?previous.controlPointPreviousY:previous.controlPointNextY,flip?target.controlPointNextX:target.controlPointPreviousX,flip?target.controlPointNextY:target.controlPointPreviousY,target.x,target.y);}};var helpers_canvas=exports$1;helpers_core.clear=exports$1.clear;helpers_core.drawRoundedRectangle=function(ctx){ctx.beginPath();exports$1.roundedRect.apply(exports$1,arguments);};var defaults={_set:function(scope,values){return helpers_core.merge(this[scope]||(this[scope]={}),values);}};defaults._set('global',{defaultColor:'rgba(0,0,0,0.1)',defaultFontColor:'#666',defaultFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",defaultFontSize:12,defaultFontStyle:'normal',defaultLineHeight:1.2,showLines:true});var core_defaults=defaults;var valueOrDefault=helpers_core.valueOrDefault;function toFontString(font){if(!font||helpers_core.isNullOrUndef(font.size)||helpers_core.isNullOrUndef(font.family)){return null;}
return(font.style?font.style+' ':'')
+(font.weight?font.weight+' ':'')
+font.size+'px '
+font.family;}
var helpers_options={toLineHeight:function(value,size){var matches=(''+value).match(/^(normal|(\d+(?:\.\d+)?)(px|em|%)?)$/);if(!matches||matches[1]==='normal'){return size*1.2;}
value=+matches[2];switch(matches[3]){case'px':return value;case'%':value/=100;break;}
return size*value;},toPadding:function(value){var t,r,b,l;if(helpers_core.isObject(value)){t=+value.top||0;r=+value.right||0;b=+value.bottom||0;l=+value.left||0;}else{t=r=b=l=+value||0;}
return{top:t,right:r,bottom:b,left:l,height:t+b,width:l+r};},_parseFont:function(options){var globalDefaults=core_defaults.global;var size=valueOrDefault(options.fontSize,globalDefaults.defaultFontSize);var font={family:valueOrDefault(options.fontFamily,globalDefaults.defaultFontFamily),lineHeight:helpers_core.options.toLineHeight(valueOrDefault(options.lineHeight,globalDefaults.defaultLineHeight),size),size:size,style:valueOrDefault(options.fontStyle,globalDefaults.defaultFontStyle),weight:null,string:''};font.string=toFontString(font);return font;},resolve:function(inputs,context,index,info){var cacheable=true;var i,ilen,value;for(i=0,ilen=inputs.length;i<ilen;++i){value=inputs[i];if(value===undefined){continue;}
if(context!==undefined&&typeof value==='function'){value=value(context);cacheable=false;}
if(index!==undefined&&helpers_core.isArray(value)){value=value[index];cacheable=false;}
if(value!==undefined){if(info&&!cacheable){info.cacheable=false;}
return value;}}}};var exports$2={_factorize:function(value){var result=[];var sqrt=Math.sqrt(value);var i;for(i=1;i<sqrt;i++){if(value%i===0){result.push(i);result.push(value/i);}}
if(sqrt===(sqrt|0)){result.push(sqrt);}
result.sort(function(a,b){return a-b;}).pop();return result;},log10:Math.log10||function(x){var exponent=Math.log(x)*Math.LOG10E;var powerOf10=Math.round(exponent);var isPowerOf10=x===Math.pow(10,powerOf10);return isPowerOf10?powerOf10:exponent;}};var helpers_math=exports$2;helpers_core.log10=exports$2.log10;var getRtlAdapter=function(rectX,width){return{x:function(x){return rectX+rectX+width-x;},setWidth:function(w){width=w;},textAlign:function(align){if(align==='center'){return align;}
return align==='right'?'left':'right';},xPlus:function(x,value){return x-value;},leftForLtr:function(x,itemWidth){return x-itemWidth;},};};var getLtrAdapter=function(){return{x:function(x){return x;},setWidth:function(w){},textAlign:function(align){return align;},xPlus:function(x,value){return x+value;},leftForLtr:function(x,_itemWidth){return x;},};};var getAdapter=function(rtl,rectX,width){return rtl?getRtlAdapter(rectX,width):getLtrAdapter();};var overrideTextDirection=function(ctx,direction){var style,original;if(direction==='ltr'||direction==='rtl'){style=ctx.canvas.style;original=[style.getPropertyValue('direction'),style.getPropertyPriority('direction'),];style.setProperty('direction',direction,'important');ctx.prevTextDirection=original;}};var restoreTextDirection=function(ctx){var original=ctx.prevTextDirection;if(original!==undefined){delete ctx.prevTextDirection;ctx.canvas.style.setProperty('direction',original[0],original[1]);}};var helpers_rtl={getRtlAdapter:getAdapter,overrideTextDirection:overrideTextDirection,restoreTextDirection:restoreTextDirection,};var helpers$1=helpers_core;var easing=helpers_easing;var canvas=helpers_canvas;var options=helpers_options;var math=helpers_math;var rtl=helpers_rtl;helpers$1.easing=easing;helpers$1.canvas=canvas;helpers$1.options=options;helpers$1.math=math;helpers$1.rtl=rtl;function interpolate(start,view,model,ease){var keys=Object.keys(model);var i,ilen,key,actual,origin,target,type,c0,c1;for(i=0,ilen=keys.length;i<ilen;++i){key=keys[i];target=model[key];if(!view.hasOwnProperty(key)){view[key]=target;}
actual=view[key];if(actual===target||key[0]==='_'){continue;}
if(!start.hasOwnProperty(key)){start[key]=actual;}
origin=start[key];type=typeof target;if(type===typeof origin){if(type==='string'){c0=chartjsColor(origin);if(c0.valid){c1=chartjsColor(target);if(c1.valid){view[key]=c1.mix(c0,ease).rgbString();continue;}}}else if(helpers$1.isFinite(origin)&&helpers$1.isFinite(target)){view[key]=origin+(target-origin)*ease;continue;}}
view[key]=target;}}
var Element=function(configuration){helpers$1.extend(this,configuration);this.initialize.apply(this,arguments);};helpers$1.extend(Element.prototype,{_type:undefined,initialize:function(){this.hidden=false;},pivot:function(){var me=this;if(!me._view){me._view=helpers$1.extend({},me._model);}
me._start={};return me;},transition:function(ease){var me=this;var model=me._model;var start=me._start;var view=me._view;if(!model||ease===1){me._view=helpers$1.extend({},model);me._start=null;return me;}
if(!view){view=me._view={};}
if(!start){start=me._start={};}
interpolate(start,view,model,ease);return me;},tooltipPosition:function(){return{x:this._model.x,y:this._model.y};},hasValue:function(){return helpers$1.isNumber(this._model.x)&&helpers$1.isNumber(this._model.y);}});Element.extend=helpers$1.inherits;var core_element=Element;var exports$3=core_element.extend({chart:null,currentStep:0,numSteps:60,easing:'',render:null,onAnimationProgress:null,onAnimationComplete:null,});var core_animation=exports$3;Object.defineProperty(exports$3.prototype,'animationObject',{get:function(){return this;}});Object.defineProperty(exports$3.prototype,'chartInstance',{get:function(){return this.chart;},set:function(value){this.chart=value;}});core_defaults._set('global',{animation:{duration:1000,easing:'easeOutQuart',onProgress:helpers$1.noop,onComplete:helpers$1.noop}});var core_animations={animations:[],request:null,addAnimation:function(chart,animation,duration,lazy){var animations=this.animations;var i,ilen;animation.chart=chart;animation.startTime=Date.now();animation.duration=duration;if(!lazy){chart.animating=true;}
for(i=0,ilen=animations.length;i<ilen;++i){if(animations[i].chart===chart){animations[i]=animation;return;}}
animations.push(animation);if(animations.length===1){this.requestAnimationFrame();}},cancelAnimation:function(chart){var index=helpers$1.findIndex(this.animations,function(animation){return animation.chart===chart;});if(index!==-1){this.animations.splice(index,1);chart.animating=false;}},requestAnimationFrame:function(){var me=this;if(me.request===null){me.request=helpers$1.requestAnimFrame.call(window,function(){me.request=null;me.startDigest();});}},startDigest:function(){var me=this;me.advance();if(me.animations.length>0){me.requestAnimationFrame();}},advance:function(){var animations=this.animations;var animation,chart,numSteps,nextStep;var i=0;while(i<animations.length){animation=animations[i];chart=animation.chart;numSteps=animation.numSteps;nextStep=Math.floor((Date.now()-animation.startTime)/animation.duration*numSteps)+1;animation.currentStep=Math.min(nextStep,numSteps);helpers$1.callback(animation.render,[chart,animation],chart);helpers$1.callback(animation.onAnimationProgress,[animation],chart);if(animation.currentStep>=numSteps){helpers$1.callback(animation.onAnimationComplete,[animation],chart);chart.animating=false;animations.splice(i,1);}else{++i;}}}};var resolve=helpers$1.options.resolve;var arrayEvents=['push','pop','shift','splice','unshift'];function listenArrayEvents(array,listener){if(array._chartjs){array._chartjs.listeners.push(listener);return;}
Object.defineProperty(array,'_chartjs',{configurable:true,enumerable:false,value:{listeners:[listener]}});arrayEvents.forEach(function(key){var method='onData'+key.charAt(0).toUpperCase()+key.slice(1);var base=array[key];Object.defineProperty(array,key,{configurable:true,enumerable:false,value:function(){var args=Array.prototype.slice.call(arguments);var res=base.apply(this,args);helpers$1.each(array._chartjs.listeners,function(object){if(typeof object[method]==='function'){object[method].apply(object,args);}});return res;}});});}
function unlistenArrayEvents(array,listener){var stub=array._chartjs;if(!stub){return;}
var listeners=stub.listeners;var index=listeners.indexOf(listener);if(index!==-1){listeners.splice(index,1);}
if(listeners.length>0){return;}
arrayEvents.forEach(function(key){delete array[key];});delete array._chartjs;}
var DatasetController=function(chart,datasetIndex){this.initialize(chart,datasetIndex);};helpers$1.extend(DatasetController.prototype,{datasetElementType:null,dataElementType:null,_datasetElementOptions:['backgroundColor','borderCapStyle','borderColor','borderDash','borderDashOffset','borderJoinStyle','borderWidth'],_dataElementOptions:['backgroundColor','borderColor','borderWidth','pointStyle'],initialize:function(chart,datasetIndex){var me=this;me.chart=chart;me.index=datasetIndex;me.linkScales();me.addElements();me._type=me.getMeta().type;},updateIndex:function(datasetIndex){this.index=datasetIndex;},linkScales:function(){var me=this;var meta=me.getMeta();var chart=me.chart;var scales=chart.scales;var dataset=me.getDataset();var scalesOpts=chart.options.scales;if(meta.xAxisID===null||!(meta.xAxisID in scales)||dataset.xAxisID){meta.xAxisID=dataset.xAxisID||scalesOpts.xAxes[0].id;}
if(meta.yAxisID===null||!(meta.yAxisID in scales)||dataset.yAxisID){meta.yAxisID=dataset.yAxisID||scalesOpts.yAxes[0].id;}},getDataset:function(){return this.chart.data.datasets[this.index];},getMeta:function(){return this.chart.getDatasetMeta(this.index);},getScaleForId:function(scaleID){return this.chart.scales[scaleID];},_getValueScaleId:function(){return this.getMeta().yAxisID;},_getIndexScaleId:function(){return this.getMeta().xAxisID;},_getValueScale:function(){return this.getScaleForId(this._getValueScaleId());},_getIndexScale:function(){return this.getScaleForId(this._getIndexScaleId());},reset:function(){this._update(true);},destroy:function(){if(this._data){unlistenArrayEvents(this._data,this);}},createMetaDataset:function(){var me=this;var type=me.datasetElementType;return type&&new type({_chart:me.chart,_datasetIndex:me.index});},createMetaData:function(index){var me=this;var type=me.dataElementType;return type&&new type({_chart:me.chart,_datasetIndex:me.index,_index:index});},addElements:function(){var me=this;var meta=me.getMeta();var data=me.getDataset().data||[];var metaData=meta.data;var i,ilen;for(i=0,ilen=data.length;i<ilen;++i){metaData[i]=metaData[i]||me.createMetaData(i);}
meta.dataset=meta.dataset||me.createMetaDataset();},addElementAndReset:function(index){var element=this.createMetaData(index);this.getMeta().data.splice(index,0,element);this.updateElement(element,index,true);},buildOrUpdateElements:function(){var me=this;var dataset=me.getDataset();var data=dataset.data||(dataset.data=[]);if(me._data!==data){if(me._data){unlistenArrayEvents(me._data,me);}
if(data&&Object.isExtensible(data)){listenArrayEvents(data,me);}
me._data=data;}
me.resyncElements();},_configure:function(){var me=this;me._config=helpers$1.merge({},[me.chart.options.datasets[me._type],me.getDataset(),],{merger:function(key,target,source){if(key!=='_meta'&&key!=='data'){helpers$1._merger(key,target,source);}}});},_update:function(reset){var me=this;me._configure();me._cachedDataOpts=null;me.update(reset);},update:helpers$1.noop,transition:function(easingValue){var meta=this.getMeta();var elements=meta.data||[];var ilen=elements.length;var i=0;for(;i<ilen;++i){elements[i].transition(easingValue);}
if(meta.dataset){meta.dataset.transition(easingValue);}},draw:function(){var meta=this.getMeta();var elements=meta.data||[];var ilen=elements.length;var i=0;if(meta.dataset){meta.dataset.draw();}
for(;i<ilen;++i){elements[i].draw();}},getStyle:function(index){var me=this;var meta=me.getMeta();var dataset=meta.dataset;var style;me._configure();if(dataset&&index===undefined){style=me._resolveDatasetElementOptions(dataset||{});}else{index=index||0;style=me._resolveDataElementOptions(meta.data[index]||{},index);}
if(style.fill===false||style.fill===null){style.backgroundColor=style.borderColor;}
return style;},_resolveDatasetElementOptions:function(element,hover){var me=this;var chart=me.chart;var datasetOpts=me._config;var custom=element.custom||{};var options=chart.options.elements[me.datasetElementType.prototype._type]||{};var elementOptions=me._datasetElementOptions;var values={};var i,ilen,key,readKey;var context={chart:chart,dataset:me.getDataset(),datasetIndex:me.index,hover:hover};for(i=0,ilen=elementOptions.length;i<ilen;++i){key=elementOptions[i];readKey=hover?'hover'+key.charAt(0).toUpperCase()+key.slice(1):key;values[key]=resolve([custom[readKey],datasetOpts[readKey],options[readKey]],context);}
return values;},_resolveDataElementOptions:function(element,index){var me=this;var custom=element&&element.custom;var cached=me._cachedDataOpts;if(cached&&!custom){return cached;}
var chart=me.chart;var datasetOpts=me._config;var options=chart.options.elements[me.dataElementType.prototype._type]||{};var elementOptions=me._dataElementOptions;var values={};var context={chart:chart,dataIndex:index,dataset:me.getDataset(),datasetIndex:me.index};var info={cacheable:!custom};var keys,i,ilen,key;custom=custom||{};if(helpers$1.isArray(elementOptions)){for(i=0,ilen=elementOptions.length;i<ilen;++i){key=elementOptions[i];values[key]=resolve([custom[key],datasetOpts[key],options[key]],context,index,info);}}else{keys=Object.keys(elementOptions);for(i=0,ilen=keys.length;i<ilen;++i){key=keys[i];values[key]=resolve([custom[key],datasetOpts[elementOptions[key]],datasetOpts[key],options[key]],context,index,info);}}
if(info.cacheable){me._cachedDataOpts=Object.freeze(values);}
return values;},removeHoverStyle:function(element){helpers$1.merge(element._model,element.$previousStyle||{});delete element.$previousStyle;},setHoverStyle:function(element){var dataset=this.chart.data.datasets[element._datasetIndex];var index=element._index;var custom=element.custom||{};var model=element._model;var getHoverColor=helpers$1.getHoverColor;element.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth};model.backgroundColor=resolve([custom.hoverBackgroundColor,dataset.hoverBackgroundColor,getHoverColor(model.backgroundColor)],undefined,index);model.borderColor=resolve([custom.hoverBorderColor,dataset.hoverBorderColor,getHoverColor(model.borderColor)],undefined,index);model.borderWidth=resolve([custom.hoverBorderWidth,dataset.hoverBorderWidth,model.borderWidth],undefined,index);},_removeDatasetHoverStyle:function(){var element=this.getMeta().dataset;if(element){this.removeHoverStyle(element);}},_setDatasetHoverStyle:function(){var element=this.getMeta().dataset;var prev={};var i,ilen,key,keys,hoverOptions,model;if(!element){return;}
model=element._model;hoverOptions=this._resolveDatasetElementOptions(element,true);keys=Object.keys(hoverOptions);for(i=0,ilen=keys.length;i<ilen;++i){key=keys[i];prev[key]=model[key];model[key]=hoverOptions[key];}
element.$previousStyle=prev;},resyncElements:function(){var me=this;var meta=me.getMeta();var data=me.getDataset().data;var numMeta=meta.data.length;var numData=data.length;if(numData<numMeta){meta.data.splice(numData,numMeta-numData);}else if(numData>numMeta){me.insertElements(numMeta,numData-numMeta);}},insertElements:function(start,count){for(var i=0;i<count;++i){this.addElementAndReset(start+i);}},onDataPush:function(){var count=arguments.length;this.insertElements(this.getDataset().data.length-count,count);},onDataPop:function(){this.getMeta().data.pop();},onDataShift:function(){this.getMeta().data.shift();},onDataSplice:function(start,count){this.getMeta().data.splice(start,count);this.insertElements(start,arguments.length-2);},onDataUnshift:function(){this.insertElements(0,arguments.length);}});DatasetController.extend=helpers$1.inherits;var core_datasetController=DatasetController;var TAU=Math.PI*2;core_defaults._set('global',{elements:{arc:{backgroundColor:core_defaults.global.defaultColor,borderColor:'#fff',borderWidth:2,borderAlign:'center'}}});function clipArc(ctx,arc){var startAngle=arc.startAngle;var endAngle=arc.endAngle;var pixelMargin=arc.pixelMargin;var angleMargin=pixelMargin/arc.outerRadius;var x=arc.x;var y=arc.y;ctx.beginPath();ctx.arc(x,y,arc.outerRadius,startAngle-angleMargin,endAngle+angleMargin);if(arc.innerRadius>pixelMargin){angleMargin=pixelMargin/arc.innerRadius;ctx.arc(x,y,arc.innerRadius-pixelMargin,endAngle+angleMargin,startAngle-angleMargin,true);}else{ctx.arc(x,y,pixelMargin,endAngle+Math.PI/2,startAngle-Math.PI/2);}
ctx.closePath();ctx.clip();}
function drawFullCircleBorders(ctx,vm,arc,inner){var endAngle=arc.endAngle;var i;if(inner){arc.endAngle=arc.startAngle+TAU;clipArc(ctx,arc);arc.endAngle=endAngle;if(arc.endAngle===arc.startAngle&&arc.fullCircles){arc.endAngle+=TAU;arc.fullCircles--;}}
ctx.beginPath();ctx.arc(arc.x,arc.y,arc.innerRadius,arc.startAngle+TAU,arc.startAngle,true);for(i=0;i<arc.fullCircles;++i){ctx.stroke();}
ctx.beginPath();ctx.arc(arc.x,arc.y,vm.outerRadius,arc.startAngle,arc.startAngle+TAU);for(i=0;i<arc.fullCircles;++i){ctx.stroke();}}
function drawBorder(ctx,vm,arc){var inner=vm.borderAlign==='inner';if(inner){ctx.lineWidth=vm.borderWidth*2;ctx.lineJoin='round';}else{ctx.lineWidth=vm.borderWidth;ctx.lineJoin='bevel';}
if(arc.fullCircles){drawFullCircleBorders(ctx,vm,arc,inner);}
if(inner){clipArc(ctx,arc);}
ctx.beginPath();ctx.arc(arc.x,arc.y,vm.outerRadius,arc.startAngle,arc.endAngle);ctx.arc(arc.x,arc.y,arc.innerRadius,arc.endAngle,arc.startAngle,true);ctx.closePath();ctx.stroke();}
var element_arc=core_element.extend({_type:'arc',inLabelRange:function(mouseX){var vm=this._view;if(vm){return(Math.pow(mouseX-vm.x,2)<Math.pow(vm.radius+vm.hoverRadius,2));}
return false;},inRange:function(chartX,chartY){var vm=this._view;if(vm){var pointRelativePosition=helpers$1.getAngleFromPoint(vm,{x:chartX,y:chartY});var angle=pointRelativePosition.angle;var distance=pointRelativePosition.distance;var startAngle=vm.startAngle;var endAngle=vm.endAngle;while(endAngle<startAngle){endAngle+=TAU;}
while(angle>endAngle){angle-=TAU;}
while(angle<startAngle){angle+=TAU;}
var betweenAngles=(angle>=startAngle&&angle<=endAngle);var withinRadius=(distance>=vm.innerRadius&&distance<=vm.outerRadius);return(betweenAngles&&withinRadius);}
return false;},getCenterPoint:function(){var vm=this._view;var halfAngle=(vm.startAngle+vm.endAngle)/2;var halfRadius=(vm.innerRadius+vm.outerRadius)/2;return{x:vm.x+Math.cos(halfAngle)*halfRadius,y:vm.y+Math.sin(halfAngle)*halfRadius};},getArea:function(){var vm=this._view;return Math.PI*((vm.endAngle-vm.startAngle)/(2*Math.PI))*(Math.pow(vm.outerRadius,2)-Math.pow(vm.innerRadius,2));},tooltipPosition:function(){var vm=this._view;var centreAngle=vm.startAngle+((vm.endAngle-vm.startAngle)/2);var rangeFromCentre=(vm.outerRadius-vm.innerRadius)/2+vm.innerRadius;return{x:vm.x+(Math.cos(centreAngle)*rangeFromCentre),y:vm.y+(Math.sin(centreAngle)*rangeFromCentre)};},draw:function(){var ctx=this._chart.ctx;var vm=this._view;var pixelMargin=(vm.borderAlign==='inner')?0.33:0;var arc={x:vm.x,y:vm.y,innerRadius:vm.innerRadius,outerRadius:Math.max(vm.outerRadius-pixelMargin,0),pixelMargin:pixelMargin,startAngle:vm.startAngle,endAngle:vm.endAngle,fullCircles:Math.floor(vm.circumference/TAU)};var i;ctx.save();ctx.fillStyle=vm.backgroundColor;ctx.strokeStyle=vm.borderColor;if(arc.fullCircles){arc.endAngle=arc.startAngle+TAU;ctx.beginPath();ctx.arc(arc.x,arc.y,arc.outerRadius,arc.startAngle,arc.endAngle);ctx.arc(arc.x,arc.y,arc.innerRadius,arc.endAngle,arc.startAngle,true);ctx.closePath();for(i=0;i<arc.fullCircles;++i){ctx.fill();}
arc.endAngle=arc.startAngle+vm.circumference%TAU;}
ctx.beginPath();ctx.arc(arc.x,arc.y,arc.outerRadius,arc.startAngle,arc.endAngle);ctx.arc(arc.x,arc.y,arc.innerRadius,arc.endAngle,arc.startAngle,true);ctx.closePath();ctx.fill();if(vm.borderWidth){drawBorder(ctx,vm,arc);}
ctx.restore();}});var valueOrDefault$1=helpers$1.valueOrDefault;var defaultColor=core_defaults.global.defaultColor;core_defaults._set('global',{elements:{line:{tension:0.4,backgroundColor:defaultColor,borderWidth:3,borderColor:defaultColor,borderCapStyle:'butt',borderDash:[],borderDashOffset:0.0,borderJoinStyle:'miter',capBezierPoints:true,fill:true,}}});var element_line=core_element.extend({_type:'line',draw:function(){var me=this;var vm=me._view;var ctx=me._chart.ctx;var spanGaps=vm.spanGaps;var points=me._children.slice();var globalDefaults=core_defaults.global;var globalOptionLineElements=globalDefaults.elements.line;var lastDrawnIndex=-1;var closePath=me._loop;var index,previous,currentVM;if(!points.length){return;}
if(me._loop){for(index=0;index<points.length;++index){previous=helpers$1.previousItem(points,index);if(!points[index]._view.skip&&previous._view.skip){points=points.slice(index).concat(points.slice(0,index));closePath=spanGaps;break;}}
if(closePath){points.push(points[0]);}}
ctx.save();ctx.lineCap=vm.borderCapStyle||globalOptionLineElements.borderCapStyle;if(ctx.setLineDash){ctx.setLineDash(vm.borderDash||globalOptionLineElements.borderDash);}
ctx.lineDashOffset=valueOrDefault$1(vm.borderDashOffset,globalOptionLineElements.borderDashOffset);ctx.lineJoin=vm.borderJoinStyle||globalOptionLineElements.borderJoinStyle;ctx.lineWidth=valueOrDefault$1(vm.borderWidth,globalOptionLineElements.borderWidth);ctx.strokeStyle=vm.borderColor||globalDefaults.defaultColor;ctx.beginPath();currentVM=points[0]._view;if(!currentVM.skip){ctx.moveTo(currentVM.x,currentVM.y);lastDrawnIndex=0;}
for(index=1;index<points.length;++index){currentVM=points[index]._view;previous=lastDrawnIndex===-1?helpers$1.previousItem(points,index):points[lastDrawnIndex];if(!currentVM.skip){if((lastDrawnIndex!==(index-1)&&!spanGaps)||lastDrawnIndex===-1){ctx.moveTo(currentVM.x,currentVM.y);}else{helpers$1.canvas.lineTo(ctx,previous._view,currentVM);}
lastDrawnIndex=index;}}
if(closePath){ctx.closePath();}
ctx.stroke();ctx.restore();}});var valueOrDefault$2=helpers$1.valueOrDefault;var defaultColor$1=core_defaults.global.defaultColor;core_defaults._set('global',{elements:{point:{radius:3,pointStyle:'circle',backgroundColor:defaultColor$1,borderColor:defaultColor$1,borderWidth:1,hitRadius:1,hoverRadius:4,hoverBorderWidth:1}}});function xRange(mouseX){var vm=this._view;return vm?(Math.abs(mouseX-vm.x)<vm.radius+vm.hitRadius):false;}
function yRange(mouseY){var vm=this._view;return vm?(Math.abs(mouseY-vm.y)<vm.radius+vm.hitRadius):false;}
var element_point=core_element.extend({_type:'point',inRange:function(mouseX,mouseY){var vm=this._view;return vm?((Math.pow(mouseX-vm.x,2)+Math.pow(mouseY-vm.y,2))<Math.pow(vm.hitRadius+vm.radius,2)):false;},inLabelRange:xRange,inXRange:xRange,inYRange:yRange,getCenterPoint:function(){var vm=this._view;return{x:vm.x,y:vm.y};},getArea:function(){return Math.PI*Math.pow(this._view.radius,2);},tooltipPosition:function(){var vm=this._view;return{x:vm.x,y:vm.y,padding:vm.radius+vm.borderWidth};},draw:function(chartArea){var vm=this._view;var ctx=this._chart.ctx;var pointStyle=vm.pointStyle;var rotation=vm.rotation;var radius=vm.radius;var x=vm.x;var y=vm.y;var globalDefaults=core_defaults.global;var defaultColor=globalDefaults.defaultColor;if(vm.skip){return;}
if(chartArea===undefined||helpers$1.canvas._isPointInArea(vm,chartArea)){ctx.strokeStyle=vm.borderColor||defaultColor;ctx.lineWidth=valueOrDefault$2(vm.borderWidth,globalDefaults.elements.point.borderWidth);ctx.fillStyle=vm.backgroundColor||defaultColor;helpers$1.canvas.drawPoint(ctx,pointStyle,radius,x,y,rotation);}}});var defaultColor$2=core_defaults.global.defaultColor;core_defaults._set('global',{elements:{rectangle:{backgroundColor:defaultColor$2,borderColor:defaultColor$2,borderSkipped:'bottom',borderWidth:0}}});function isVertical(vm){return vm&&vm.width!==undefined;}
function getBarBounds(vm){var x1,x2,y1,y2,half;if(isVertical(vm)){half=vm.width/2;x1=vm.x-half;x2=vm.x+half;y1=Math.min(vm.y,vm.base);y2=Math.max(vm.y,vm.base);}else{half=vm.height/2;x1=Math.min(vm.x,vm.base);x2=Math.max(vm.x,vm.base);y1=vm.y-half;y2=vm.y+half;}
return{left:x1,top:y1,right:x2,bottom:y2};}
function swap(orig,v1,v2){return orig===v1?v2:orig===v2?v1:orig;}
function parseBorderSkipped(vm){var edge=vm.borderSkipped;var res={};if(!edge){return res;}
if(vm.horizontal){if(vm.base>vm.x){edge=swap(edge,'left','right');}}else if(vm.base<vm.y){edge=swap(edge,'bottom','top');}
res[edge]=true;return res;}
function parseBorderWidth(vm,maxW,maxH){var value=vm.borderWidth;var skip=parseBorderSkipped(vm);var t,r,b,l;if(helpers$1.isObject(value)){t=+value.top||0;r=+value.right||0;b=+value.bottom||0;l=+value.left||0;}else{t=r=b=l=+value||0;}
return{t:skip.top||(t<0)?0:t>maxH?maxH:t,r:skip.right||(r<0)?0:r>maxW?maxW:r,b:skip.bottom||(b<0)?0:b>maxH?maxH:b,l:skip.left||(l<0)?0:l>maxW?maxW:l};}
function boundingRects(vm){var bounds=getBarBounds(vm);var width=bounds.right-bounds.left;var height=bounds.bottom-bounds.top;var border=parseBorderWidth(vm,width/2,height/2);return{outer:{x:bounds.left,y:bounds.top,w:width,h:height},inner:{x:bounds.left+border.l,y:bounds.top+border.t,w:width-border.l-border.r,h:height-border.t-border.b}};}
function inRange(vm,x,y){var skipX=x===null;var skipY=y===null;var bounds=!vm||(skipX&&skipY)?false:getBarBounds(vm);return bounds&&(skipX||x>=bounds.left&&x<=bounds.right)&&(skipY||y>=bounds.top&&y<=bounds.bottom);}
var element_rectangle=core_element.extend({_type:'rectangle',draw:function(){var ctx=this._chart.ctx;var vm=this._view;var rects=boundingRects(vm);var outer=rects.outer;var inner=rects.inner;ctx.fillStyle=vm.backgroundColor;ctx.fillRect(outer.x,outer.y,outer.w,outer.h);if(outer.w===inner.w&&outer.h===inner.h){return;}
ctx.save();ctx.beginPath();ctx.rect(outer.x,outer.y,outer.w,outer.h);ctx.clip();ctx.fillStyle=vm.borderColor;ctx.rect(inner.x,inner.y,inner.w,inner.h);ctx.fill('evenodd');ctx.restore();},height:function(){var vm=this._view;return vm.base-vm.y;},inRange:function(mouseX,mouseY){return inRange(this._view,mouseX,mouseY);},inLabelRange:function(mouseX,mouseY){var vm=this._view;return isVertical(vm)?inRange(vm,mouseX,null):inRange(vm,null,mouseY);},inXRange:function(mouseX){return inRange(this._view,mouseX,null);},inYRange:function(mouseY){return inRange(this._view,null,mouseY);},getCenterPoint:function(){var vm=this._view;var x,y;if(isVertical(vm)){x=vm.x;y=(vm.y+vm.base)/2;}else{x=(vm.x+vm.base)/2;y=vm.y;}
return{x:x,y:y};},getArea:function(){var vm=this._view;return isVertical(vm)?vm.width*Math.abs(vm.y-vm.base):vm.height*Math.abs(vm.x-vm.base);},tooltipPosition:function(){var vm=this._view;return{x:vm.x,y:vm.y};}});var elements={};var Arc=element_arc;var Line=element_line;var Point=element_point;var Rectangle=element_rectangle;elements.Arc=Arc;elements.Line=Line;elements.Point=Point;elements.Rectangle=Rectangle;var deprecated=helpers$1._deprecated;var valueOrDefault$3=helpers$1.valueOrDefault;core_defaults._set('bar',{hover:{mode:'label'},scales:{xAxes:[{type:'category',offset:true,gridLines:{offsetGridLines:true}}],yAxes:[{type:'linear'}]}});core_defaults._set('global',{datasets:{bar:{categoryPercentage:0.8,barPercentage:0.9}}});function computeMinSampleSize(scale,pixels){var min=scale._length;var prev,curr,i,ilen;for(i=1,ilen=pixels.length;i<ilen;++i){min=Math.min(min,Math.abs(pixels[i]-pixels[i-1]));}
for(i=0,ilen=scale.getTicks().length;i<ilen;++i){curr=scale.getPixelForTick(i);min=i>0?Math.min(min,Math.abs(curr-prev)):min;prev=curr;}
return min;}
function computeFitCategoryTraits(index,ruler,options){var thickness=options.barThickness;var count=ruler.stackCount;var curr=ruler.pixels[index];var min=helpers$1.isNullOrUndef(thickness)?computeMinSampleSize(ruler.scale,ruler.pixels):-1;var size,ratio;if(helpers$1.isNullOrUndef(thickness)){size=min*options.categoryPercentage;ratio=options.barPercentage;}else{size=thickness*count;ratio=1;}
return{chunk:size/count,ratio:ratio,start:curr-(size/2)};}
function computeFlexCategoryTraits(index,ruler,options){var pixels=ruler.pixels;var curr=pixels[index];var prev=index>0?pixels[index-1]:null;var next=index<pixels.length-1?pixels[index+1]:null;var percent=options.categoryPercentage;var start,size;if(prev===null){prev=curr-(next===null?ruler.end-ruler.start:next-curr);}
if(next===null){next=curr+curr-prev;}
start=curr-(curr-Math.min(prev,next))/2*percent;size=Math.abs(next-prev)/2*percent;return{chunk:size/ruler.stackCount,ratio:options.barPercentage,start:start};}
var controller_bar=core_datasetController.extend({dataElementType:elements.Rectangle,_dataElementOptions:['backgroundColor','borderColor','borderSkipped','borderWidth','barPercentage','barThickness','categoryPercentage','maxBarThickness','minBarLength'],initialize:function(){var me=this;var meta,scaleOpts;core_datasetController.prototype.initialize.apply(me,arguments);meta=me.getMeta();meta.stack=me.getDataset().stack;meta.bar=true;scaleOpts=me._getIndexScale().options;deprecated('bar chart',scaleOpts.barPercentage,'scales.[x/y]Axes.barPercentage','dataset.barPercentage');deprecated('bar chart',scaleOpts.barThickness,'scales.[x/y]Axes.barThickness','dataset.barThickness');deprecated('bar chart',scaleOpts.categoryPercentage,'scales.[x/y]Axes.categoryPercentage','dataset.categoryPercentage');deprecated('bar chart',me._getValueScale().options.minBarLength,'scales.[x/y]Axes.minBarLength','dataset.minBarLength');deprecated('bar chart',scaleOpts.maxBarThickness,'scales.[x/y]Axes.maxBarThickness','dataset.maxBarThickness');},update:function(reset){var me=this;var rects=me.getMeta().data;var i,ilen;me._ruler=me.getRuler();for(i=0,ilen=rects.length;i<ilen;++i){me.updateElement(rects[i],i,reset);}},updateElement:function(rectangle,index,reset){var me=this;var meta=me.getMeta();var dataset=me.getDataset();var options=me._resolveDataElementOptions(rectangle,index);rectangle._xScale=me.getScaleForId(meta.xAxisID);rectangle._yScale=me.getScaleForId(meta.yAxisID);rectangle._datasetIndex=me.index;rectangle._index=index;rectangle._model={backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderSkipped:options.borderSkipped,borderWidth:options.borderWidth,datasetLabel:dataset.label,label:me.chart.data.labels[index]};if(helpers$1.isArray(dataset.data[index])){rectangle._model.borderSkipped=null;}
me._updateElementGeometry(rectangle,index,reset,options);rectangle.pivot();},_updateElementGeometry:function(rectangle,index,reset,options){var me=this;var model=rectangle._model;var vscale=me._getValueScale();var base=vscale.getBasePixel();var horizontal=vscale.isHorizontal();var ruler=me._ruler||me.getRuler();var vpixels=me.calculateBarValuePixels(me.index,index,options);var ipixels=me.calculateBarIndexPixels(me.index,index,ruler,options);model.horizontal=horizontal;model.base=reset?base:vpixels.base;model.x=horizontal?reset?base:vpixels.head:ipixels.center;model.y=horizontal?ipixels.center:reset?base:vpixels.head;model.height=horizontal?ipixels.size:undefined;model.width=horizontal?undefined:ipixels.size;},_getStacks:function(last){var me=this;var scale=me._getIndexScale();var metasets=scale._getMatchingVisibleMetas(me._type);var stacked=scale.options.stacked;var ilen=metasets.length;var stacks=[];var i,meta;for(i=0;i<ilen;++i){meta=metasets[i];if(stacked===false||stacks.indexOf(meta.stack)===-1||(stacked===undefined&&meta.stack===undefined)){stacks.push(meta.stack);}
if(meta.index===last){break;}}
return stacks;},getStackCount:function(){return this._getStacks().length;},getStackIndex:function(datasetIndex,name){var stacks=this._getStacks(datasetIndex);var index=(name!==undefined)?stacks.indexOf(name):-1;return(index===-1)?stacks.length-1:index;},getRuler:function(){var me=this;var scale=me._getIndexScale();var pixels=[];var i,ilen;for(i=0,ilen=me.getMeta().data.length;i<ilen;++i){pixels.push(scale.getPixelForValue(null,i,me.index));}
return{pixels:pixels,start:scale._startPixel,end:scale._endPixel,stackCount:me.getStackCount(),scale:scale};},calculateBarValuePixels:function(datasetIndex,index,options){var me=this;var chart=me.chart;var scale=me._getValueScale();var isHorizontal=scale.isHorizontal();var datasets=chart.data.datasets;var metasets=scale._getMatchingVisibleMetas(me._type);var value=scale._parseValue(datasets[datasetIndex].data[index]);var minBarLength=options.minBarLength;var stacked=scale.options.stacked;var stack=me.getMeta().stack;var start=value.start===undefined?0:value.max>=0&&value.min>=0?value.min:value.max;var length=value.start===undefined?value.end:value.max>=0&&value.min>=0?value.max-value.min:value.min-value.max;var ilen=metasets.length;var i,imeta,ivalue,base,head,size,stackLength;if(stacked||(stacked===undefined&&stack!==undefined)){for(i=0;i<ilen;++i){imeta=metasets[i];if(imeta.index===datasetIndex){break;}
if(imeta.stack===stack){stackLength=scale._parseValue(datasets[imeta.index].data[index]);ivalue=stackLength.start===undefined?stackLength.end:stackLength.min>=0&&stackLength.max>=0?stackLength.max:stackLength.min;if((value.min<0&&ivalue<0)||(value.max>=0&&ivalue>0)){start+=ivalue;}}}}
base=scale.getPixelForValue(start);head=scale.getPixelForValue(start+length);size=head-base;if(minBarLength!==undefined&&Math.abs(size)<minBarLength){size=minBarLength;if(length>=0&&!isHorizontal||length<0&&isHorizontal){head=base-minBarLength;}else{head=base+minBarLength;}}
return{size:size,base:base,head:head,center:head+size/2};},calculateBarIndexPixels:function(datasetIndex,index,ruler,options){var me=this;var range=options.barThickness==='flex'?computeFlexCategoryTraits(index,ruler,options):computeFitCategoryTraits(index,ruler,options);var stackIndex=me.getStackIndex(datasetIndex,me.getMeta().stack);var center=range.start+(range.chunk*stackIndex)+(range.chunk/2);var size=Math.min(valueOrDefault$3(options.maxBarThickness,Infinity),range.chunk*range.ratio);return{base:center-size/2,head:center+size/2,center:center,size:size};},draw:function(){var me=this;var chart=me.chart;var scale=me._getValueScale();var rects=me.getMeta().data;var dataset=me.getDataset();var ilen=rects.length;var i=0;helpers$1.canvas.clipArea(chart.ctx,chart.chartArea);for(;i<ilen;++i){var val=scale._parseValue(dataset.data[i]);if(!isNaN(val.min)&&!isNaN(val.max)){rects[i].draw();}}
helpers$1.canvas.unclipArea(chart.ctx);},_resolveDataElementOptions:function(){var me=this;var values=helpers$1.extend({},core_datasetController.prototype._resolveDataElementOptions.apply(me,arguments));var indexOpts=me._getIndexScale().options;var valueOpts=me._getValueScale().options;values.barPercentage=valueOrDefault$3(indexOpts.barPercentage,values.barPercentage);values.barThickness=valueOrDefault$3(indexOpts.barThickness,values.barThickness);values.categoryPercentage=valueOrDefault$3(indexOpts.categoryPercentage,values.categoryPercentage);values.maxBarThickness=valueOrDefault$3(indexOpts.maxBarThickness,values.maxBarThickness);values.minBarLength=valueOrDefault$3(valueOpts.minBarLength,values.minBarLength);return values;}});var valueOrDefault$4=helpers$1.valueOrDefault;var resolve$1=helpers$1.options.resolve;core_defaults._set('bubble',{hover:{mode:'single'},scales:{xAxes:[{type:'linear',position:'bottom',id:'x-axis-0'}],yAxes:[{type:'linear',position:'left',id:'y-axis-0'}]},tooltips:{callbacks:{title:function(){return'';},label:function(item,data){var datasetLabel=data.datasets[item.datasetIndex].label||'';var dataPoint=data.datasets[item.datasetIndex].data[item.index];return datasetLabel+': ('+item.xLabel+', '+item.yLabel+', '+dataPoint.r+')';}}}});var controller_bubble=core_datasetController.extend({dataElementType:elements.Point,_dataElementOptions:['backgroundColor','borderColor','borderWidth','hoverBackgroundColor','hoverBorderColor','hoverBorderWidth','hoverRadius','hitRadius','pointStyle','rotation'],update:function(reset){var me=this;var meta=me.getMeta();var points=meta.data;helpers$1.each(points,function(point,index){me.updateElement(point,index,reset);});},updateElement:function(point,index,reset){var me=this;var meta=me.getMeta();var custom=point.custom||{};var xScale=me.getScaleForId(meta.xAxisID);var yScale=me.getScaleForId(meta.yAxisID);var options=me._resolveDataElementOptions(point,index);var data=me.getDataset().data[index];var dsIndex=me.index;var x=reset?xScale.getPixelForDecimal(0.5):xScale.getPixelForValue(typeof data==='object'?data:NaN,index,dsIndex);var y=reset?yScale.getBasePixel():yScale.getPixelForValue(data,index,dsIndex);point._xScale=xScale;point._yScale=yScale;point._options=options;point._datasetIndex=dsIndex;point._index=index;point._model={backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,hitRadius:options.hitRadius,pointStyle:options.pointStyle,rotation:options.rotation,radius:reset?0:options.radius,skip:custom.skip||isNaN(x)||isNaN(y),x:x,y:y,};point.pivot();},setHoverStyle:function(point){var model=point._model;var options=point._options;var getHoverColor=helpers$1.getHoverColor;point.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth,radius:model.radius};model.backgroundColor=valueOrDefault$4(options.hoverBackgroundColor,getHoverColor(options.backgroundColor));model.borderColor=valueOrDefault$4(options.hoverBorderColor,getHoverColor(options.borderColor));model.borderWidth=valueOrDefault$4(options.hoverBorderWidth,options.borderWidth);model.radius=options.radius+options.hoverRadius;},_resolveDataElementOptions:function(point,index){var me=this;var chart=me.chart;var dataset=me.getDataset();var custom=point.custom||{};var data=dataset.data[index]||{};var values=core_datasetController.prototype._resolveDataElementOptions.apply(me,arguments);var context={chart:chart,dataIndex:index,dataset:dataset,datasetIndex:me.index};if(me._cachedDataOpts===values){values=helpers$1.extend({},values);}
values.radius=resolve$1([custom.radius,data.r,me._config.radius,chart.options.elements.point.radius],context,index);return values;}});var valueOrDefault$5=helpers$1.valueOrDefault;var PI$1=Math.PI;var DOUBLE_PI$1=PI$1*2;var HALF_PI$1=PI$1/2;core_defaults._set('doughnut',{animation:{animateRotate:true,animateScale:false},hover:{mode:'single'},legendCallback:function(chart){var list=document.createElement('ul');var data=chart.data;var datasets=data.datasets;var labels=data.labels;var i,ilen,listItem,listItemSpan;list.setAttribute('class',chart.id+'-legend');if(datasets.length){for(i=0,ilen=datasets[0].data.length;i<ilen;++i){listItem=list.appendChild(document.createElement('li'));listItemSpan=listItem.appendChild(document.createElement('span'));listItemSpan.style.backgroundColor=datasets[0].backgroundColor[i];if(labels[i]){listItem.appendChild(document.createTextNode(labels[i]));}}}
return list.outerHTML;},legend:{labels:{generateLabels:function(chart){var data=chart.data;if(data.labels.length&&data.datasets.length){return data.labels.map(function(label,i){var meta=chart.getDatasetMeta(0);var style=meta.controller.getStyle(i);return{text:label,fillStyle:style.backgroundColor,strokeStyle:style.borderColor,lineWidth:style.borderWidth,hidden:isNaN(data.datasets[0].data[i])||meta.data[i].hidden,index:i};});}
return[];}},onClick:function(e,legendItem){var index=legendItem.index;var chart=this.chart;var i,ilen,meta;for(i=0,ilen=(chart.data.datasets||[]).length;i<ilen;++i){meta=chart.getDatasetMeta(i);if(meta.data[index]){meta.data[index].hidden=!meta.data[index].hidden;}}
chart.update();}},cutoutPercentage:50,rotation:-HALF_PI$1,circumference:DOUBLE_PI$1,tooltips:{callbacks:{title:function(){return'';},label:function(tooltipItem,data){var dataLabel=data.labels[tooltipItem.index];var value=': '+data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];if(helpers$1.isArray(dataLabel)){dataLabel=dataLabel.slice();dataLabel[0]+=value;}else{dataLabel+=value;}
return dataLabel;}}}});var controller_doughnut=core_datasetController.extend({dataElementType:elements.Arc,linkScales:helpers$1.noop,_dataElementOptions:['backgroundColor','borderColor','borderWidth','borderAlign','hoverBackgroundColor','hoverBorderColor','hoverBorderWidth',],getRingIndex:function(datasetIndex){var ringIndex=0;for(var j=0;j<datasetIndex;++j){if(this.chart.isDatasetVisible(j)){++ringIndex;}}
return ringIndex;},update:function(reset){var me=this;var chart=me.chart;var chartArea=chart.chartArea;var opts=chart.options;var ratioX=1;var ratioY=1;var offsetX=0;var offsetY=0;var meta=me.getMeta();var arcs=meta.data;var cutout=opts.cutoutPercentage/100||0;var circumference=opts.circumference;var chartWeight=me._getRingWeight(me.index);var maxWidth,maxHeight,i,ilen;if(circumference<DOUBLE_PI$1){var startAngle=opts.rotation%DOUBLE_PI$1;startAngle+=startAngle>=PI$1?-DOUBLE_PI$1:startAngle<-PI$1?DOUBLE_PI$1:0;var endAngle=startAngle+circumference;var startX=Math.cos(startAngle);var startY=Math.sin(startAngle);var endX=Math.cos(endAngle);var endY=Math.sin(endAngle);var contains0=(startAngle<=0&&endAngle>=0)||endAngle>=DOUBLE_PI$1;var contains90=(startAngle<=HALF_PI$1&&endAngle>=HALF_PI$1)||endAngle>=DOUBLE_PI$1+HALF_PI$1;var contains180=startAngle===-PI$1||endAngle>=PI$1;var contains270=(startAngle<=-HALF_PI$1&&endAngle>=-HALF_PI$1)||endAngle>=PI$1+HALF_PI$1;var minX=contains180?-1:Math.min(startX,startX*cutout,endX,endX*cutout);var minY=contains270?-1:Math.min(startY,startY*cutout,endY,endY*cutout);var maxX=contains0?1:Math.max(startX,startX*cutout,endX,endX*cutout);var maxY=contains90?1:Math.max(startY,startY*cutout,endY,endY*cutout);ratioX=(maxX-minX)/2;ratioY=(maxY-minY)/2;offsetX=-(maxX+minX)/2;offsetY=-(maxY+minY)/2;}
for(i=0,ilen=arcs.length;i<ilen;++i){arcs[i]._options=me._resolveDataElementOptions(arcs[i],i);}
chart.borderWidth=me.getMaxBorderWidth();maxWidth=(chartArea.right-chartArea.left-chart.borderWidth)/ratioX;maxHeight=(chartArea.bottom-chartArea.top-chart.borderWidth)/ratioY;chart.outerRadius=Math.max(Math.min(maxWidth,maxHeight)/2,0);chart.innerRadius=Math.max(chart.outerRadius*cutout,0);chart.radiusLength=(chart.outerRadius-chart.innerRadius)/(me._getVisibleDatasetWeightTotal()||1);chart.offsetX=offsetX*chart.outerRadius;chart.offsetY=offsetY*chart.outerRadius;meta.total=me.calculateTotal();me.outerRadius=chart.outerRadius-chart.radiusLength*me._getRingWeightOffset(me.index);me.innerRadius=Math.max(me.outerRadius-chart.radiusLength*chartWeight,0);for(i=0,ilen=arcs.length;i<ilen;++i){me.updateElement(arcs[i],i,reset);}},updateElement:function(arc,index,reset){var me=this;var chart=me.chart;var chartArea=chart.chartArea;var opts=chart.options;var animationOpts=opts.animation;var centerX=(chartArea.left+chartArea.right)/2;var centerY=(chartArea.top+chartArea.bottom)/2;var startAngle=opts.rotation;var endAngle=opts.rotation;var dataset=me.getDataset();var circumference=reset&&animationOpts.animateRotate?0:arc.hidden?0:me.calculateCircumference(dataset.data[index])*(opts.circumference/DOUBLE_PI$1);var innerRadius=reset&&animationOpts.animateScale?0:me.innerRadius;var outerRadius=reset&&animationOpts.animateScale?0:me.outerRadius;var options=arc._options||{};helpers$1.extend(arc,{_datasetIndex:me.index,_index:index,_model:{backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,borderAlign:options.borderAlign,x:centerX+chart.offsetX,y:centerY+chart.offsetY,startAngle:startAngle,endAngle:endAngle,circumference:circumference,outerRadius:outerRadius,innerRadius:innerRadius,label:helpers$1.valueAtIndexOrDefault(dataset.label,index,chart.data.labels[index])}});var model=arc._model;if(!reset||!animationOpts.animateRotate){if(index===0){model.startAngle=opts.rotation;}else{model.startAngle=me.getMeta().data[index-1]._model.endAngle;}
model.endAngle=model.startAngle+model.circumference;}
arc.pivot();},calculateTotal:function(){var dataset=this.getDataset();var meta=this.getMeta();var total=0;var value;helpers$1.each(meta.data,function(element,index){value=dataset.data[index];if(!isNaN(value)&&!element.hidden){total+=Math.abs(value);}});return total;},calculateCircumference:function(value){var total=this.getMeta().total;if(total>0&&!isNaN(value)){return DOUBLE_PI$1*(Math.abs(value)/total);}
return 0;},getMaxBorderWidth:function(arcs){var me=this;var max=0;var chart=me.chart;var i,ilen,meta,arc,controller,options,borderWidth,hoverWidth;if(!arcs){for(i=0,ilen=chart.data.datasets.length;i<ilen;++i){if(chart.isDatasetVisible(i)){meta=chart.getDatasetMeta(i);arcs=meta.data;if(i!==me.index){controller=meta.controller;}
break;}}}
if(!arcs){return 0;}
for(i=0,ilen=arcs.length;i<ilen;++i){arc=arcs[i];if(controller){controller._configure();options=controller._resolveDataElementOptions(arc,i);}else{options=arc._options;}
if(options.borderAlign!=='inner'){borderWidth=options.borderWidth;hoverWidth=options.hoverBorderWidth;max=borderWidth>max?borderWidth:max;max=hoverWidth>max?hoverWidth:max;}}
return max;},setHoverStyle:function(arc){var model=arc._model;var options=arc._options;var getHoverColor=helpers$1.getHoverColor;arc.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth,};model.backgroundColor=valueOrDefault$5(options.hoverBackgroundColor,getHoverColor(options.backgroundColor));model.borderColor=valueOrDefault$5(options.hoverBorderColor,getHoverColor(options.borderColor));model.borderWidth=valueOrDefault$5(options.hoverBorderWidth,options.borderWidth);},_getRingWeightOffset:function(datasetIndex){var ringWeightOffset=0;for(var i=0;i<datasetIndex;++i){if(this.chart.isDatasetVisible(i)){ringWeightOffset+=this._getRingWeight(i);}}
return ringWeightOffset;},_getRingWeight:function(dataSetIndex){return Math.max(valueOrDefault$5(this.chart.data.datasets[dataSetIndex].weight,1),0);},_getVisibleDatasetWeightTotal:function(){return this._getRingWeightOffset(this.chart.data.datasets.length);}});core_defaults._set('horizontalBar',{hover:{mode:'index',axis:'y'},scales:{xAxes:[{type:'linear',position:'bottom'}],yAxes:[{type:'category',position:'left',offset:true,gridLines:{offsetGridLines:true}}]},elements:{rectangle:{borderSkipped:'left'}},tooltips:{mode:'index',axis:'y'}});core_defaults._set('global',{datasets:{horizontalBar:{categoryPercentage:0.8,barPercentage:0.9}}});var controller_horizontalBar=controller_bar.extend({_getValueScaleId:function(){return this.getMeta().xAxisID;},_getIndexScaleId:function(){return this.getMeta().yAxisID;}});var valueOrDefault$6=helpers$1.valueOrDefault;var resolve$2=helpers$1.options.resolve;var isPointInArea=helpers$1.canvas._isPointInArea;core_defaults._set('line',{showLines:true,spanGaps:false,hover:{mode:'label'},scales:{xAxes:[{type:'category',id:'x-axis-0'}],yAxes:[{type:'linear',id:'y-axis-0'}]}});function scaleClip(scale,halfBorderWidth){var tickOpts=scale&&scale.options.ticks||{};var reverse=tickOpts.reverse;var min=tickOpts.min===undefined?halfBorderWidth:0;var max=tickOpts.max===undefined?halfBorderWidth:0;return{start:reverse?max:min,end:reverse?min:max};}
function defaultClip(xScale,yScale,borderWidth){var halfBorderWidth=borderWidth/2;var x=scaleClip(xScale,halfBorderWidth);var y=scaleClip(yScale,halfBorderWidth);return{top:y.end,right:x.end,bottom:y.start,left:x.start};}
function toClip(value){var t,r,b,l;if(helpers$1.isObject(value)){t=value.top;r=value.right;b=value.bottom;l=value.left;}else{t=r=b=l=value;}
return{top:t,right:r,bottom:b,left:l};}
var controller_line=core_datasetController.extend({datasetElementType:elements.Line,dataElementType:elements.Point,_datasetElementOptions:['backgroundColor','borderCapStyle','borderColor','borderDash','borderDashOffset','borderJoinStyle','borderWidth','cubicInterpolationMode','fill'],_dataElementOptions:{backgroundColor:'pointBackgroundColor',borderColor:'pointBorderColor',borderWidth:'pointBorderWidth',hitRadius:'pointHitRadius',hoverBackgroundColor:'pointHoverBackgroundColor',hoverBorderColor:'pointHoverBorderColor',hoverBorderWidth:'pointHoverBorderWidth',hoverRadius:'pointHoverRadius',pointStyle:'pointStyle',radius:'pointRadius',rotation:'pointRotation'},update:function(reset){var me=this;var meta=me.getMeta();var line=meta.dataset;var points=meta.data||[];var options=me.chart.options;var config=me._config;var showLine=me._showLine=valueOrDefault$6(config.showLine,options.showLines);var i,ilen;me._xScale=me.getScaleForId(meta.xAxisID);me._yScale=me.getScaleForId(meta.yAxisID);if(showLine){if(config.tension!==undefined&&config.lineTension===undefined){config.lineTension=config.tension;}
line._scale=me._yScale;line._datasetIndex=me.index;line._children=points;line._model=me._resolveDatasetElementOptions(line);line.pivot();}
for(i=0,ilen=points.length;i<ilen;++i){me.updateElement(points[i],i,reset);}
if(showLine&&line._model.tension!==0){me.updateBezierControlPoints();}
for(i=0,ilen=points.length;i<ilen;++i){points[i].pivot();}},updateElement:function(point,index,reset){var me=this;var meta=me.getMeta();var custom=point.custom||{};var dataset=me.getDataset();var datasetIndex=me.index;var value=dataset.data[index];var xScale=me._xScale;var yScale=me._yScale;var lineModel=meta.dataset._model;var x,y;var options=me._resolveDataElementOptions(point,index);x=xScale.getPixelForValue(typeof value==='object'?value:NaN,index,datasetIndex);y=reset?yScale.getBasePixel():me.calculatePointY(value,index,datasetIndex);point._xScale=xScale;point._yScale=yScale;point._options=options;point._datasetIndex=datasetIndex;point._index=index;point._model={x:x,y:y,skip:custom.skip||isNaN(x)||isNaN(y),radius:options.radius,pointStyle:options.pointStyle,rotation:options.rotation,backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,tension:valueOrDefault$6(custom.tension,lineModel?lineModel.tension:0),steppedLine:lineModel?lineModel.steppedLine:false,hitRadius:options.hitRadius};},_resolveDatasetElementOptions:function(element){var me=this;var config=me._config;var custom=element.custom||{};var options=me.chart.options;var lineOptions=options.elements.line;var values=core_datasetController.prototype._resolveDatasetElementOptions.apply(me,arguments);values.spanGaps=valueOrDefault$6(config.spanGaps,options.spanGaps);values.tension=valueOrDefault$6(config.lineTension,lineOptions.tension);values.steppedLine=resolve$2([custom.steppedLine,config.steppedLine,lineOptions.stepped]);values.clip=toClip(valueOrDefault$6(config.clip,defaultClip(me._xScale,me._yScale,values.borderWidth)));return values;},calculatePointY:function(value,index,datasetIndex){var me=this;var chart=me.chart;var yScale=me._yScale;var sumPos=0;var sumNeg=0;var i,ds,dsMeta,stackedRightValue,rightValue,metasets,ilen;if(yScale.options.stacked){rightValue=+yScale.getRightValue(value);metasets=chart._getSortedVisibleDatasetMetas();ilen=metasets.length;for(i=0;i<ilen;++i){dsMeta=metasets[i];if(dsMeta.index===datasetIndex){break;}
ds=chart.data.datasets[dsMeta.index];if(dsMeta.type==='line'&&dsMeta.yAxisID===yScale.id){stackedRightValue=+yScale.getRightValue(ds.data[index]);if(stackedRightValue<0){sumNeg+=stackedRightValue||0;}else{sumPos+=stackedRightValue||0;}}}
if(rightValue<0){return yScale.getPixelForValue(sumNeg+rightValue);}
return yScale.getPixelForValue(sumPos+rightValue);}
return yScale.getPixelForValue(value);},updateBezierControlPoints:function(){var me=this;var chart=me.chart;var meta=me.getMeta();var lineModel=meta.dataset._model;var area=chart.chartArea;var points=meta.data||[];var i,ilen,model,controlPoints;if(lineModel.spanGaps){points=points.filter(function(pt){return!pt._model.skip;});}
function capControlPoint(pt,min,max){return Math.max(Math.min(pt,max),min);}
if(lineModel.cubicInterpolationMode==='monotone'){helpers$1.splineCurveMonotone(points);}else{for(i=0,ilen=points.length;i<ilen;++i){model=points[i]._model;controlPoints=helpers$1.splineCurve(helpers$1.previousItem(points,i)._model,model,helpers$1.nextItem(points,i)._model,lineModel.tension);model.controlPointPreviousX=controlPoints.previous.x;model.controlPointPreviousY=controlPoints.previous.y;model.controlPointNextX=controlPoints.next.x;model.controlPointNextY=controlPoints.next.y;}}
if(chart.options.elements.line.capBezierPoints){for(i=0,ilen=points.length;i<ilen;++i){model=points[i]._model;if(isPointInArea(model,area)){if(i>0&&isPointInArea(points[i-1]._model,area)){model.controlPointPreviousX=capControlPoint(model.controlPointPreviousX,area.left,area.right);model.controlPointPreviousY=capControlPoint(model.controlPointPreviousY,area.top,area.bottom);}
if(i<points.length-1&&isPointInArea(points[i+1]._model,area)){model.controlPointNextX=capControlPoint(model.controlPointNextX,area.left,area.right);model.controlPointNextY=capControlPoint(model.controlPointNextY,area.top,area.bottom);}}}}},draw:function(){var me=this;var chart=me.chart;var meta=me.getMeta();var points=meta.data||[];var area=chart.chartArea;var canvas=chart.canvas;var i=0;var ilen=points.length;var clip;if(me._showLine){clip=meta.dataset._model.clip;helpers$1.canvas.clipArea(chart.ctx,{left:clip.left===false?0:area.left-clip.left,right:clip.right===false?canvas.width:area.right+clip.right,top:clip.top===false?0:area.top-clip.top,bottom:clip.bottom===false?canvas.height:area.bottom+clip.bottom});meta.dataset.draw();helpers$1.canvas.unclipArea(chart.ctx);}
for(;i<ilen;++i){points[i].draw(area);}},setHoverStyle:function(point){var model=point._model;var options=point._options;var getHoverColor=helpers$1.getHoverColor;point.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth,radius:model.radius};model.backgroundColor=valueOrDefault$6(options.hoverBackgroundColor,getHoverColor(options.backgroundColor));model.borderColor=valueOrDefault$6(options.hoverBorderColor,getHoverColor(options.borderColor));model.borderWidth=valueOrDefault$6(options.hoverBorderWidth,options.borderWidth);model.radius=valueOrDefault$6(options.hoverRadius,options.radius);},});var resolve$3=helpers$1.options.resolve;core_defaults._set('polarArea',{scale:{type:'radialLinear',angleLines:{display:false},gridLines:{circular:true},pointLabels:{display:false},ticks:{beginAtZero:true}},animation:{animateRotate:true,animateScale:true},startAngle:-0.5*Math.PI,legendCallback:function(chart){var list=document.createElement('ul');var data=chart.data;var datasets=data.datasets;var labels=data.labels;var i,ilen,listItem,listItemSpan;list.setAttribute('class',chart.id+'-legend');if(datasets.length){for(i=0,ilen=datasets[0].data.length;i<ilen;++i){listItem=list.appendChild(document.createElement('li'));listItemSpan=listItem.appendChild(document.createElement('span'));listItemSpan.style.backgroundColor=datasets[0].backgroundColor[i];if(labels[i]){listItem.appendChild(document.createTextNode(labels[i]));}}}
return list.outerHTML;},legend:{labels:{generateLabels:function(chart){var data=chart.data;if(data.labels.length&&data.datasets.length){return data.labels.map(function(label,i){var meta=chart.getDatasetMeta(0);var style=meta.controller.getStyle(i);return{text:label,fillStyle:style.backgroundColor,strokeStyle:style.borderColor,lineWidth:style.borderWidth,hidden:isNaN(data.datasets[0].data[i])||meta.data[i].hidden,index:i};});}
return[];}},onClick:function(e,legendItem){var index=legendItem.index;var chart=this.chart;var i,ilen,meta;for(i=0,ilen=(chart.data.datasets||[]).length;i<ilen;++i){meta=chart.getDatasetMeta(i);meta.data[index].hidden=!meta.data[index].hidden;}
chart.update();}},tooltips:{callbacks:{title:function(){return'';},label:function(item,data){return data.labels[item.index]+': '+item.yLabel;}}}});var controller_polarArea=core_datasetController.extend({dataElementType:elements.Arc,linkScales:helpers$1.noop,_dataElementOptions:['backgroundColor','borderColor','borderWidth','borderAlign','hoverBackgroundColor','hoverBorderColor','hoverBorderWidth',],_getIndexScaleId:function(){return this.chart.scale.id;},_getValueScaleId:function(){return this.chart.scale.id;},update:function(reset){var me=this;var dataset=me.getDataset();var meta=me.getMeta();var start=me.chart.options.startAngle||0;var starts=me._starts=[];var angles=me._angles=[];var arcs=meta.data;var i,ilen,angle;me._updateRadius();meta.count=me.countVisibleElements();for(i=0,ilen=dataset.data.length;i<ilen;i++){starts[i]=start;angle=me._computeAngle(i);angles[i]=angle;start+=angle;}
for(i=0,ilen=arcs.length;i<ilen;++i){arcs[i]._options=me._resolveDataElementOptions(arcs[i],i);me.updateElement(arcs[i],i,reset);}},_updateRadius:function(){var me=this;var chart=me.chart;var chartArea=chart.chartArea;var opts=chart.options;var minSize=Math.min(chartArea.right-chartArea.left,chartArea.bottom-chartArea.top);chart.outerRadius=Math.max(minSize/2,0);chart.innerRadius=Math.max(opts.cutoutPercentage?(chart.outerRadius/100)*(opts.cutoutPercentage):1,0);chart.radiusLength=(chart.outerRadius-chart.innerRadius)/chart.getVisibleDatasetCount();me.outerRadius=chart.outerRadius-(chart.radiusLength*me.index);me.innerRadius=me.outerRadius-chart.radiusLength;},updateElement:function(arc,index,reset){var me=this;var chart=me.chart;var dataset=me.getDataset();var opts=chart.options;var animationOpts=opts.animation;var scale=chart.scale;var labels=chart.data.labels;var centerX=scale.xCenter;var centerY=scale.yCenter;var datasetStartAngle=opts.startAngle;var distance=arc.hidden?0:scale.getDistanceFromCenterForValue(dataset.data[index]);var startAngle=me._starts[index];var endAngle=startAngle+(arc.hidden?0:me._angles[index]);var resetRadius=animationOpts.animateScale?0:scale.getDistanceFromCenterForValue(dataset.data[index]);var options=arc._options||{};helpers$1.extend(arc,{_datasetIndex:me.index,_index:index,_scale:scale,_model:{backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,borderAlign:options.borderAlign,x:centerX,y:centerY,innerRadius:0,outerRadius:reset?resetRadius:distance,startAngle:reset&&animationOpts.animateRotate?datasetStartAngle:startAngle,endAngle:reset&&animationOpts.animateRotate?datasetStartAngle:endAngle,label:helpers$1.valueAtIndexOrDefault(labels,index,labels[index])}});arc.pivot();},countVisibleElements:function(){var dataset=this.getDataset();var meta=this.getMeta();var count=0;helpers$1.each(meta.data,function(element,index){if(!isNaN(dataset.data[index])&&!element.hidden){count++;}});return count;},setHoverStyle:function(arc){var model=arc._model;var options=arc._options;var getHoverColor=helpers$1.getHoverColor;var valueOrDefault=helpers$1.valueOrDefault;arc.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth,};model.backgroundColor=valueOrDefault(options.hoverBackgroundColor,getHoverColor(options.backgroundColor));model.borderColor=valueOrDefault(options.hoverBorderColor,getHoverColor(options.borderColor));model.borderWidth=valueOrDefault(options.hoverBorderWidth,options.borderWidth);},_computeAngle:function(index){var me=this;var count=this.getMeta().count;var dataset=me.getDataset();var meta=me.getMeta();if(isNaN(dataset.data[index])||meta.data[index].hidden){return 0;}
var context={chart:me.chart,dataIndex:index,dataset:dataset,datasetIndex:me.index};return resolve$3([me.chart.options.elements.arc.angle,(2*Math.PI)/count],context,index);}});core_defaults._set('pie',helpers$1.clone(core_defaults.doughnut));core_defaults._set('pie',{cutoutPercentage:0});var controller_pie=controller_doughnut;var valueOrDefault$7=helpers$1.valueOrDefault;core_defaults._set('radar',{spanGaps:false,scale:{type:'radialLinear'},elements:{line:{fill:'start',tension:0}}});var controller_radar=core_datasetController.extend({datasetElementType:elements.Line,dataElementType:elements.Point,linkScales:helpers$1.noop,_datasetElementOptions:['backgroundColor','borderWidth','borderColor','borderCapStyle','borderDash','borderDashOffset','borderJoinStyle','fill'],_dataElementOptions:{backgroundColor:'pointBackgroundColor',borderColor:'pointBorderColor',borderWidth:'pointBorderWidth',hitRadius:'pointHitRadius',hoverBackgroundColor:'pointHoverBackgroundColor',hoverBorderColor:'pointHoverBorderColor',hoverBorderWidth:'pointHoverBorderWidth',hoverRadius:'pointHoverRadius',pointStyle:'pointStyle',radius:'pointRadius',rotation:'pointRotation'},_getIndexScaleId:function(){return this.chart.scale.id;},_getValueScaleId:function(){return this.chart.scale.id;},update:function(reset){var me=this;var meta=me.getMeta();var line=meta.dataset;var points=meta.data||[];var scale=me.chart.scale;var config=me._config;var i,ilen;if(config.tension!==undefined&&config.lineTension===undefined){config.lineTension=config.tension;}
line._scale=scale;line._datasetIndex=me.index;line._children=points;line._loop=true;line._model=me._resolveDatasetElementOptions(line);line.pivot();for(i=0,ilen=points.length;i<ilen;++i){me.updateElement(points[i],i,reset);}
me.updateBezierControlPoints();for(i=0,ilen=points.length;i<ilen;++i){points[i].pivot();}},updateElement:function(point,index,reset){var me=this;var custom=point.custom||{};var dataset=me.getDataset();var scale=me.chart.scale;var pointPosition=scale.getPointPositionForValue(index,dataset.data[index]);var options=me._resolveDataElementOptions(point,index);var lineModel=me.getMeta().dataset._model;var x=reset?scale.xCenter:pointPosition.x;var y=reset?scale.yCenter:pointPosition.y;point._scale=scale;point._options=options;point._datasetIndex=me.index;point._index=index;point._model={x:x,y:y,skip:custom.skip||isNaN(x)||isNaN(y),radius:options.radius,pointStyle:options.pointStyle,rotation:options.rotation,backgroundColor:options.backgroundColor,borderColor:options.borderColor,borderWidth:options.borderWidth,tension:valueOrDefault$7(custom.tension,lineModel?lineModel.tension:0),hitRadius:options.hitRadius};},_resolveDatasetElementOptions:function(){var me=this;var config=me._config;var options=me.chart.options;var values=core_datasetController.prototype._resolveDatasetElementOptions.apply(me,arguments);values.spanGaps=valueOrDefault$7(config.spanGaps,options.spanGaps);values.tension=valueOrDefault$7(config.lineTension,options.elements.line.tension);return values;},updateBezierControlPoints:function(){var me=this;var meta=me.getMeta();var area=me.chart.chartArea;var points=meta.data||[];var i,ilen,model,controlPoints;if(meta.dataset._model.spanGaps){points=points.filter(function(pt){return!pt._model.skip;});}
function capControlPoint(pt,min,max){return Math.max(Math.min(pt,max),min);}
for(i=0,ilen=points.length;i<ilen;++i){model=points[i]._model;controlPoints=helpers$1.splineCurve(helpers$1.previousItem(points,i,true)._model,model,helpers$1.nextItem(points,i,true)._model,model.tension);model.controlPointPreviousX=capControlPoint(controlPoints.previous.x,area.left,area.right);model.controlPointPreviousY=capControlPoint(controlPoints.previous.y,area.top,area.bottom);model.controlPointNextX=capControlPoint(controlPoints.next.x,area.left,area.right);model.controlPointNextY=capControlPoint(controlPoints.next.y,area.top,area.bottom);}},setHoverStyle:function(point){var model=point._model;var options=point._options;var getHoverColor=helpers$1.getHoverColor;point.$previousStyle={backgroundColor:model.backgroundColor,borderColor:model.borderColor,borderWidth:model.borderWidth,radius:model.radius};model.backgroundColor=valueOrDefault$7(options.hoverBackgroundColor,getHoverColor(options.backgroundColor));model.borderColor=valueOrDefault$7(options.hoverBorderColor,getHoverColor(options.borderColor));model.borderWidth=valueOrDefault$7(options.hoverBorderWidth,options.borderWidth);model.radius=valueOrDefault$7(options.hoverRadius,options.radius);}});core_defaults._set('scatter',{hover:{mode:'single'},scales:{xAxes:[{id:'x-axis-1',type:'linear',position:'bottom'}],yAxes:[{id:'y-axis-1',type:'linear',position:'left'}]},tooltips:{callbacks:{title:function(){return'';},label:function(item){return'('+item.xLabel+', '+item.yLabel+')';}}}});core_defaults._set('global',{datasets:{scatter:{showLine:false}}});var controller_scatter=controller_line;var controllers={bar:controller_bar,bubble:controller_bubble,doughnut:controller_doughnut,horizontalBar:controller_horizontalBar,line:controller_line,polarArea:controller_polarArea,pie:controller_pie,radar:controller_radar,scatter:controller_scatter};function getRelativePosition(e,chart){if(e.native){return{x:e.x,y:e.y};}
return helpers$1.getRelativePosition(e,chart);}
function parseVisibleItems(chart,handler){var metasets=chart._getSortedVisibleDatasetMetas();var metadata,i,j,ilen,jlen,element;for(i=0,ilen=metasets.length;i<ilen;++i){metadata=metasets[i].data;for(j=0,jlen=metadata.length;j<jlen;++j){element=metadata[j];if(!element._view.skip){handler(element);}}}}
function getIntersectItems(chart,position){var elements=[];parseVisibleItems(chart,function(element){if(element.inRange(position.x,position.y)){elements.push(element);}});return elements;}
function getNearestItems(chart,position,intersect,distanceMetric){var minDistance=Number.POSITIVE_INFINITY;var nearestItems=[];parseVisibleItems(chart,function(element){if(intersect&&!element.inRange(position.x,position.y)){return;}
var center=element.getCenterPoint();var distance=distanceMetric(position,center);if(distance<minDistance){nearestItems=[element];minDistance=distance;}else if(distance===minDistance){nearestItems.push(element);}});return nearestItems;}
function getDistanceMetricForAxis(axis){var useX=axis.indexOf('x')!==-1;var useY=axis.indexOf('y')!==-1;return function(pt1,pt2){var deltaX=useX?Math.abs(pt1.x-pt2.x):0;var deltaY=useY?Math.abs(pt1.y-pt2.y):0;return Math.sqrt(Math.pow(deltaX,2)+Math.pow(deltaY,2));};}
function indexMode(chart,e,options){var position=getRelativePosition(e,chart);options.axis=options.axis||'x';var distanceMetric=getDistanceMetricForAxis(options.axis);var items=options.intersect?getIntersectItems(chart,position):getNearestItems(chart,position,false,distanceMetric);var elements=[];if(!items.length){return[];}
chart._getSortedVisibleDatasetMetas().forEach(function(meta){var element=meta.data[items[0]._index];if(element&&!element._view.skip){elements.push(element);}});return elements;}
var core_interaction={modes:{single:function(chart,e){var position=getRelativePosition(e,chart);var elements=[];parseVisibleItems(chart,function(element){if(element.inRange(position.x,position.y)){elements.push(element);return elements;}});return elements.slice(0,1);},label:indexMode,index:indexMode,dataset:function(chart,e,options){var position=getRelativePosition(e,chart);options.axis=options.axis||'xy';var distanceMetric=getDistanceMetricForAxis(options.axis);var items=options.intersect?getIntersectItems(chart,position):getNearestItems(chart,position,false,distanceMetric);if(items.length>0){items=chart.getDatasetMeta(items[0]._datasetIndex).data;}
return items;},'x-axis':function(chart,e){return indexMode(chart,e,{intersect:false});},point:function(chart,e){var position=getRelativePosition(e,chart);return getIntersectItems(chart,position);},nearest:function(chart,e,options){var position=getRelativePosition(e,chart);options.axis=options.axis||'xy';var distanceMetric=getDistanceMetricForAxis(options.axis);return getNearestItems(chart,position,options.intersect,distanceMetric);},x:function(chart,e,options){var position=getRelativePosition(e,chart);var items=[];var intersectsItem=false;parseVisibleItems(chart,function(element){if(element.inXRange(position.x)){items.push(element);}
if(element.inRange(position.x,position.y)){intersectsItem=true;}});if(options.intersect&&!intersectsItem){items=[];}
return items;},y:function(chart,e,options){var position=getRelativePosition(e,chart);var items=[];var intersectsItem=false;parseVisibleItems(chart,function(element){if(element.inYRange(position.y)){items.push(element);}
if(element.inRange(position.x,position.y)){intersectsItem=true;}});if(options.intersect&&!intersectsItem){items=[];}
return items;}}};var extend=helpers$1.extend;function filterByPosition(array,position){return helpers$1.where(array,function(v){return v.pos===position;});}
function sortByWeight(array,reverse){return array.sort(function(a,b){var v0=reverse?b:a;var v1=reverse?a:b;return v0.weight===v1.weight?v0.index-v1.index:v0.weight-v1.weight;});}
function wrapBoxes(boxes){var layoutBoxes=[];var i,ilen,box;for(i=0,ilen=(boxes||[]).length;i<ilen;++i){box=boxes[i];layoutBoxes.push({index:i,box:box,pos:box.position,horizontal:box.isHorizontal(),weight:box.weight});}
return layoutBoxes;}
function setLayoutDims(layouts,params){var i,ilen,layout;for(i=0,ilen=layouts.length;i<ilen;++i){layout=layouts[i];layout.width=layout.horizontal?layout.box.fullWidth&&params.availableWidth:params.vBoxMaxWidth;layout.height=layout.horizontal&&params.hBoxMaxHeight;}}
function buildLayoutBoxes(boxes){var layoutBoxes=wrapBoxes(boxes);var left=sortByWeight(filterByPosition(layoutBoxes,'left'),true);var right=sortByWeight(filterByPosition(layoutBoxes,'right'));var top=sortByWeight(filterByPosition(layoutBoxes,'top'),true);var bottom=sortByWeight(filterByPosition(layoutBoxes,'bottom'));return{leftAndTop:left.concat(top),rightAndBottom:right.concat(bottom),chartArea:filterByPosition(layoutBoxes,'chartArea'),vertical:left.concat(right),horizontal:top.concat(bottom)};}
function getCombinedMax(maxPadding,chartArea,a,b){return Math.max(maxPadding[a],chartArea[a])+Math.max(maxPadding[b],chartArea[b]);}
function updateDims(chartArea,params,layout){var box=layout.box;var maxPadding=chartArea.maxPadding;var newWidth,newHeight;if(layout.size){chartArea[layout.pos]-=layout.size;}
layout.size=layout.horizontal?box.height:box.width;chartArea[layout.pos]+=layout.size;if(box.getPadding){var boxPadding=box.getPadding();maxPadding.top=Math.max(maxPadding.top,boxPadding.top);maxPadding.left=Math.max(maxPadding.left,boxPadding.left);maxPadding.bottom=Math.max(maxPadding.bottom,boxPadding.bottom);maxPadding.right=Math.max(maxPadding.right,boxPadding.right);}
newWidth=params.outerWidth-getCombinedMax(maxPadding,chartArea,'left','right');newHeight=params.outerHeight-getCombinedMax(maxPadding,chartArea,'top','bottom');if(newWidth!==chartArea.w||newHeight!==chartArea.h){chartArea.w=newWidth;chartArea.h=newHeight;return layout.horizontal?newWidth!==chartArea.w:newHeight!==chartArea.h;}}
function handleMaxPadding(chartArea){var maxPadding=chartArea.maxPadding;function updatePos(pos){var change=Math.max(maxPadding[pos]-chartArea[pos],0);chartArea[pos]+=change;return change;}
chartArea.y+=updatePos('top');chartArea.x+=updatePos('left');updatePos('right');updatePos('bottom');}
function getMargins(horizontal,chartArea){var maxPadding=chartArea.maxPadding;function marginForPositions(positions){var margin={left:0,top:0,right:0,bottom:0};positions.forEach(function(pos){margin[pos]=Math.max(chartArea[pos],maxPadding[pos]);});return margin;}
return horizontal?marginForPositions(['left','right']):marginForPositions(['top','bottom']);}
function fitBoxes(boxes,chartArea,params){var refitBoxes=[];var i,ilen,layout,box,refit,changed;for(i=0,ilen=boxes.length;i<ilen;++i){layout=boxes[i];box=layout.box;box.update(layout.width||chartArea.w,layout.height||chartArea.h,getMargins(layout.horizontal,chartArea));if(updateDims(chartArea,params,layout)){changed=true;if(refitBoxes.length){refit=true;}}
if(!box.fullWidth){refitBoxes.push(layout);}}
return refit?fitBoxes(refitBoxes,chartArea,params)||changed:changed;}
function placeBoxes(boxes,chartArea,params){var userPadding=params.padding;var x=chartArea.x;var y=chartArea.y;var i,ilen,layout,box;for(i=0,ilen=boxes.length;i<ilen;++i){layout=boxes[i];box=layout.box;if(layout.horizontal){box.left=box.fullWidth?userPadding.left:chartArea.left;box.right=box.fullWidth?params.outerWidth-userPadding.right:chartArea.left+chartArea.w;box.top=y;box.bottom=y+box.height;box.width=box.right-box.left;y=box.bottom;}else{box.left=x;box.right=x+box.width;box.top=chartArea.top;box.bottom=chartArea.top+chartArea.h;box.height=box.bottom-box.top;x=box.right;}}
chartArea.x=x;chartArea.y=y;}
core_defaults._set('global',{layout:{padding:{top:0,right:0,bottom:0,left:0}}});var core_layouts={defaults:{},addBox:function(chart,item){if(!chart.boxes){chart.boxes=[];}
item.fullWidth=item.fullWidth||false;item.position=item.position||'top';item.weight=item.weight||0;item._layers=item._layers||function(){return[{z:0,draw:function(){item.draw.apply(item,arguments);}}];};chart.boxes.push(item);},removeBox:function(chart,layoutItem){var index=chart.boxes?chart.boxes.indexOf(layoutItem):-1;if(index!==-1){chart.boxes.splice(index,1);}},configure:function(chart,item,options){var props=['fullWidth','position','weight'];var ilen=props.length;var i=0;var prop;for(;i<ilen;++i){prop=props[i];if(options.hasOwnProperty(prop)){item[prop]=options[prop];}}},update:function(chart,width,height){if(!chart){return;}
var layoutOptions=chart.options.layout||{};var padding=helpers$1.options.toPadding(layoutOptions.padding);var availableWidth=width-padding.width;var availableHeight=height-padding.height;var boxes=buildLayoutBoxes(chart.boxes);var verticalBoxes=boxes.vertical;var horizontalBoxes=boxes.horizontal;var params=Object.freeze({outerWidth:width,outerHeight:height,padding:padding,availableWidth:availableWidth,vBoxMaxWidth:availableWidth/2/verticalBoxes.length,hBoxMaxHeight:availableHeight/2});var chartArea=extend({maxPadding:extend({},padding),w:availableWidth,h:availableHeight,x:padding.left,y:padding.top},padding);setLayoutDims(verticalBoxes.concat(horizontalBoxes),params);fitBoxes(verticalBoxes,chartArea,params);if(fitBoxes(horizontalBoxes,chartArea,params)){fitBoxes(verticalBoxes,chartArea,params);}
handleMaxPadding(chartArea);placeBoxes(boxes.leftAndTop,chartArea,params);chartArea.x+=chartArea.w;chartArea.y+=chartArea.h;placeBoxes(boxes.rightAndBottom,chartArea,params);chart.chartArea={left:chartArea.left,top:chartArea.top,right:chartArea.left+chartArea.w,bottom:chartArea.top+chartArea.h};helpers$1.each(boxes.chartArea,function(layout){var box=layout.box;extend(box,chart.chartArea);box.update(chartArea.w,chartArea.h);});}};var platform_basic={acquireContext:function(item){if(item&&item.canvas){item=item.canvas;}
return item&&item.getContext('2d')||null;}};var platform_dom="/*\n * DOM element rendering detection\n * https://davidwalsh.name/detect-node-insertion\n */\n@keyframes chartjs-render-animation {\n\tfrom { opacity: 0.99; }\n\tto { opacity: 1; }\n}\n\n.chartjs-render-monitor {\n\tanimation: chartjs-render-animation 0.001s;\n}\n\n/*\n * DOM element resizing detection\n * https://github.com/marcj/css-element-queries\n */\n.chartjs-size-monitor,\n.chartjs-size-monitor-expand,\n.chartjs-size-monitor-shrink {\n\tposition: absolute;\n\tdirection: ltr;\n\tleft: 0;\n\ttop: 0;\n\tright: 0;\n\tbottom: 0;\n\toverflow: hidden;\n\tpointer-events: none;\n\tvisibility: hidden;\n\tz-index: -1;\n}\n\n.chartjs-size-monitor-expand > div {\n\tposition: absolute;\n\twidth: 1000000px;\n\theight: 1000000px;\n\tleft: 0;\n\ttop: 0;\n}\n\n.chartjs-size-monitor-shrink > div {\n\tposition: absolute;\n\twidth: 200%;\n\theight: 200%;\n\tleft: 0;\n\ttop: 0;\n}\n";var platform_dom$1=Object.freeze({__proto__:null,'default':platform_dom});var stylesheet=getCjsExportFromNamespace(platform_dom$1);var EXPANDO_KEY='$chartjs';var CSS_PREFIX='chartjs-';var CSS_SIZE_MONITOR=CSS_PREFIX+'size-monitor';var CSS_RENDER_MONITOR=CSS_PREFIX+'render-monitor';var CSS_RENDER_ANIMATION=CSS_PREFIX+'render-animation';var ANIMATION_START_EVENTS=['animationstart','webkitAnimationStart'];var EVENT_TYPES={touchstart:'mousedown',touchmove:'mousemove',touchend:'mouseup',pointerenter:'mouseenter',pointerdown:'mousedown',pointermove:'mousemove',pointerup:'mouseup',pointerleave:'mouseout',pointerout:'mouseout'};function readUsedSize(element,property){var value=helpers$1.getStyle(element,property);var matches=value&&value.match(/^(\d+)(\.\d+)?px$/);return matches?Number(matches[1]):undefined;}
function initCanvas(canvas,config){var style=canvas.style;var renderHeight=canvas.getAttribute('height');var renderWidth=canvas.getAttribute('width');canvas[EXPANDO_KEY]={initial:{height:renderHeight,width:renderWidth,style:{display:style.display,height:style.height,width:style.width}}};style.display=style.display||'block';if(renderWidth===null||renderWidth===''){var displayWidth=readUsedSize(canvas,'width');if(displayWidth!==undefined){canvas.width=displayWidth;}}
if(renderHeight===null||renderHeight===''){if(canvas.style.height===''){canvas.height=canvas.width/(config.options.aspectRatio||2);}else{var displayHeight=readUsedSize(canvas,'height');if(displayWidth!==undefined){canvas.height=displayHeight;}}}
return canvas;}
var supportsEventListenerOptions=(function(){var supports=false;try{var options=Object.defineProperty({},'passive',{get:function(){supports=true;}});window.addEventListener('e',null,options);}catch(e){}
return supports;}());var eventListenerOptions=supportsEventListenerOptions?{passive:true}:false;function addListener(node,type,listener){node.addEventListener(type,listener,eventListenerOptions);}
function removeListener(node,type,listener){node.removeEventListener(type,listener,eventListenerOptions);}
function createEvent(type,chart,x,y,nativeEvent){return{type:type,chart:chart,native:nativeEvent||null,x:x!==undefined?x:null,y:y!==undefined?y:null,};}
function fromNativeEvent(event,chart){var type=EVENT_TYPES[event.type]||event.type;var pos=helpers$1.getRelativePosition(event,chart);return createEvent(type,chart,pos.x,pos.y,event);}
function throttled(fn,thisArg){var ticking=false;var args=[];return function(){args=Array.prototype.slice.call(arguments);thisArg=thisArg||this;if(!ticking){ticking=true;helpers$1.requestAnimFrame.call(window,function(){ticking=false;fn.apply(thisArg,args);});}};}
function createDiv(cls){var el=document.createElement('div');el.className=cls||'';return el;}
function createResizer(handler){var maxSize=1000000;var resizer=createDiv(CSS_SIZE_MONITOR);var expand=createDiv(CSS_SIZE_MONITOR+'-expand');var shrink=createDiv(CSS_SIZE_MONITOR+'-shrink');expand.appendChild(createDiv());shrink.appendChild(createDiv());resizer.appendChild(expand);resizer.appendChild(shrink);resizer._reset=function(){expand.scrollLeft=maxSize;expand.scrollTop=maxSize;shrink.scrollLeft=maxSize;shrink.scrollTop=maxSize;};var onScroll=function(){resizer._reset();handler();};addListener(expand,'scroll',onScroll.bind(expand,'expand'));addListener(shrink,'scroll',onScroll.bind(shrink,'shrink'));return resizer;}
function watchForRender(node,handler){var expando=node[EXPANDO_KEY]||(node[EXPANDO_KEY]={});var proxy=expando.renderProxy=function(e){if(e.animationName===CSS_RENDER_ANIMATION){handler();}};helpers$1.each(ANIMATION_START_EVENTS,function(type){addListener(node,type,proxy);});expando.reflow=!!node.offsetParent;node.classList.add(CSS_RENDER_MONITOR);}
function unwatchForRender(node){var expando=node[EXPANDO_KEY]||{};var proxy=expando.renderProxy;if(proxy){helpers$1.each(ANIMATION_START_EVENTS,function(type){removeListener(node,type,proxy);});delete expando.renderProxy;}
node.classList.remove(CSS_RENDER_MONITOR);}
function addResizeListener(node,listener,chart){var expando=node[EXPANDO_KEY]||(node[EXPANDO_KEY]={});var resizer=expando.resizer=createResizer(throttled(function(){if(expando.resizer){var container=chart.options.maintainAspectRatio&&node.parentNode;var w=container?container.clientWidth:0;listener(createEvent('resize',chart));if(container&&container.clientWidth<w&&chart.canvas){listener(createEvent('resize',chart));}}}));watchForRender(node,function(){if(expando.resizer){var container=node.parentNode;if(container&&container!==resizer.parentNode){container.insertBefore(resizer,container.firstChild);}
resizer._reset();}});}
function removeResizeListener(node){var expando=node[EXPANDO_KEY]||{};var resizer=expando.resizer;delete expando.resizer;unwatchForRender(node);if(resizer&&resizer.parentNode){resizer.parentNode.removeChild(resizer);}}
function injectCSS(rootNode,css){var expando=rootNode[EXPANDO_KEY]||(rootNode[EXPANDO_KEY]={});if(!expando.containsStyles){expando.containsStyles=true;css='/* Chart.js */\n'+css;var style=document.createElement('style');style.setAttribute('type','text/css');style.appendChild(document.createTextNode(css));rootNode.appendChild(style);}}
var platform_dom$2={disableCSSInjection:false,_enabled:typeof window!=='undefined'&&typeof document!=='undefined',_ensureLoaded:function(canvas){if(!this.disableCSSInjection){var root=canvas.getRootNode?canvas.getRootNode():document;var targetNode=root.host?root:document.head;injectCSS(targetNode,stylesheet);}},acquireContext:function(item,config){if(typeof item==='string'){item=document.getElementById(item);}else if(item.length){item=item[0];}
if(item&&item.canvas){item=item.canvas;}
var context=item&&item.getContext&&item.getContext('2d');if(context&&context.canvas===item){this._ensureLoaded(item);initCanvas(item,config);return context;}
return null;},releaseContext:function(context){var canvas=context.canvas;if(!canvas[EXPANDO_KEY]){return;}
var initial=canvas[EXPANDO_KEY].initial;['height','width'].forEach(function(prop){var value=initial[prop];if(helpers$1.isNullOrUndef(value)){canvas.removeAttribute(prop);}else{canvas.setAttribute(prop,value);}});helpers$1.each(initial.style||{},function(value,key){canvas.style[key]=value;});canvas.width=canvas.width;delete canvas[EXPANDO_KEY];},addEventListener:function(chart,type,listener){var canvas=chart.canvas;if(type==='resize'){addResizeListener(canvas,listener,chart);return;}
var expando=listener[EXPANDO_KEY]||(listener[EXPANDO_KEY]={});var proxies=expando.proxies||(expando.proxies={});var proxy=proxies[chart.id+'_'+type]=function(event){listener(fromNativeEvent(event,chart));};addListener(canvas,type,proxy);},removeEventListener:function(chart,type,listener){var canvas=chart.canvas;if(type==='resize'){removeResizeListener(canvas);return;}
var expando=listener[EXPANDO_KEY]||{};var proxies=expando.proxies||{};var proxy=proxies[chart.id+'_'+type];if(!proxy){return;}
removeListener(canvas,type,proxy);}};helpers$1.addEvent=addListener;helpers$1.removeEvent=removeListener;var implementation=platform_dom$2._enabled?platform_dom$2:platform_basic;var platform=helpers$1.extend({initialize:function(){},acquireContext:function(){},releaseContext:function(){},addEventListener:function(){},removeEventListener:function(){}},implementation);core_defaults._set('global',{plugins:{}});var core_plugins={_plugins:[],_cacheId:0,register:function(plugins){var p=this._plugins;([]).concat(plugins).forEach(function(plugin){if(p.indexOf(plugin)===-1){p.push(plugin);}});this._cacheId++;},unregister:function(plugins){var p=this._plugins;([]).concat(plugins).forEach(function(plugin){var idx=p.indexOf(plugin);if(idx!==-1){p.splice(idx,1);}});this._cacheId++;},clear:function(){this._plugins=[];this._cacheId++;},count:function(){return this._plugins.length;},getAll:function(){return this._plugins;},notify:function(chart,hook,args){var descriptors=this.descriptors(chart);var ilen=descriptors.length;var i,descriptor,plugin,params,method;for(i=0;i<ilen;++i){descriptor=descriptors[i];plugin=descriptor.plugin;method=plugin[hook];if(typeof method==='function'){params=[chart].concat(args||[]);params.push(descriptor.options);if(method.apply(plugin,params)===false){return false;}}}
return true;},descriptors:function(chart){var cache=chart.$plugins||(chart.$plugins={});if(cache.id===this._cacheId){return cache.descriptors;}
var plugins=[];var descriptors=[];var config=(chart&&chart.config)||{};var options=(config.options&&config.options.plugins)||{};this._plugins.concat(config.plugins||[]).forEach(function(plugin){var idx=plugins.indexOf(plugin);if(idx!==-1){return;}
var id=plugin.id;var opts=options[id];if(opts===false){return;}
if(opts===true){opts=helpers$1.clone(core_defaults.global.plugins[id]);}
plugins.push(plugin);descriptors.push({plugin:plugin,options:opts||{}});});cache.descriptors=descriptors;cache.id=this._cacheId;return descriptors;},_invalidate:function(chart){delete chart.$plugins;}};var core_scaleService={constructors:{},defaults:{},registerScaleType:function(type,scaleConstructor,scaleDefaults){this.constructors[type]=scaleConstructor;this.defaults[type]=helpers$1.clone(scaleDefaults);},getScaleConstructor:function(type){return this.constructors.hasOwnProperty(type)?this.constructors[type]:undefined;},getScaleDefaults:function(type){return this.defaults.hasOwnProperty(type)?helpers$1.merge({},[core_defaults.scale,this.defaults[type]]):{};},updateScaleDefaults:function(type,additions){var me=this;if(me.defaults.hasOwnProperty(type)){me.defaults[type]=helpers$1.extend(me.defaults[type],additions);}},addScalesToLayout:function(chart){helpers$1.each(chart.scales,function(scale){scale.fullWidth=scale.options.fullWidth;scale.position=scale.options.position;scale.weight=scale.options.weight;core_layouts.addBox(chart,scale);});}};var valueOrDefault$8=helpers$1.valueOrDefault;var getRtlHelper=helpers$1.rtl.getRtlAdapter;core_defaults._set('global',{tooltips:{enabled:true,custom:null,mode:'nearest',position:'average',intersect:true,backgroundColor:'rgba(0,0,0,0.8)',titleFontStyle:'bold',titleSpacing:2,titleMarginBottom:6,titleFontColor:'#fff',titleAlign:'left',bodySpacing:2,bodyFontColor:'#fff',bodyAlign:'left',footerFontStyle:'bold',footerSpacing:2,footerMarginTop:6,footerFontColor:'#fff',footerAlign:'left',yPadding:6,xPadding:6,caretPadding:2,caretSize:5,cornerRadius:6,multiKeyBackground:'#fff',displayColors:true,borderColor:'rgba(0,0,0,0)',borderWidth:0,callbacks:{beforeTitle:helpers$1.noop,title:function(tooltipItems,data){var title='';var labels=data.labels;var labelCount=labels?labels.length:0;if(tooltipItems.length>0){var item=tooltipItems[0];if(item.label){title=item.label;}else if(item.xLabel){title=item.xLabel;}else if(labelCount>0&&item.index<labelCount){title=labels[item.index];}}
return title;},afterTitle:helpers$1.noop,beforeBody:helpers$1.noop,beforeLabel:helpers$1.noop,label:function(tooltipItem,data){var label=data.datasets[tooltipItem.datasetIndex].label||'';if(label){label+=': ';}
if(!helpers$1.isNullOrUndef(tooltipItem.value)){label+=tooltipItem.value;}else{label+=tooltipItem.yLabel;}
return label;},labelColor:function(tooltipItem,chart){var meta=chart.getDatasetMeta(tooltipItem.datasetIndex);var activeElement=meta.data[tooltipItem.index];var view=activeElement._view;return{borderColor:view.borderColor,backgroundColor:view.backgroundColor};},labelTextColor:function(){return this._options.bodyFontColor;},afterLabel:helpers$1.noop,afterBody:helpers$1.noop,beforeFooter:helpers$1.noop,footer:helpers$1.noop,afterFooter:helpers$1.noop}}});var positioners={average:function(elements){if(!elements.length){return false;}
var i,len;var x=0;var y=0;var count=0;for(i=0,len=elements.length;i<len;++i){var el=elements[i];if(el&&el.hasValue()){var pos=el.tooltipPosition();x+=pos.x;y+=pos.y;++count;}}
return{x:x/count,y:y/count};},nearest:function(elements,eventPosition){var x=eventPosition.x;var y=eventPosition.y;var minDistance=Number.POSITIVE_INFINITY;var i,len,nearestElement;for(i=0,len=elements.length;i<len;++i){var el=elements[i];if(el&&el.hasValue()){var center=el.getCenterPoint();var d=helpers$1.distanceBetweenPoints(eventPosition,center);if(d<minDistance){minDistance=d;nearestElement=el;}}}
if(nearestElement){var tp=nearestElement.tooltipPosition();x=tp.x;y=tp.y;}
return{x:x,y:y};}};function pushOrConcat(base,toPush){if(toPush){if(helpers$1.isArray(toPush)){Array.prototype.push.apply(base,toPush);}else{base.push(toPush);}}
return base;}
function splitNewlines(str){if((typeof str==='string'||str instanceof String)&&str.indexOf('\n')>-1){return str.split('\n');}
return str;}
function createTooltipItem(element){var xScale=element._xScale;var yScale=element._yScale||element._scale;var index=element._index;var datasetIndex=element._datasetIndex;var controller=element._chart.getDatasetMeta(datasetIndex).controller;var indexScale=controller._getIndexScale();var valueScale=controller._getValueScale();return{xLabel:xScale?xScale.getLabelForIndex(index,datasetIndex):'',yLabel:yScale?yScale.getLabelForIndex(index,datasetIndex):'',label:indexScale?''+indexScale.getLabelForIndex(index,datasetIndex):'',value:valueScale?''+valueScale.getLabelForIndex(index,datasetIndex):'',index:index,datasetIndex:datasetIndex,x:element._model.x,y:element._model.y};}
function getBaseModel(tooltipOpts){var globalDefaults=core_defaults.global;return{xPadding:tooltipOpts.xPadding,yPadding:tooltipOpts.yPadding,xAlign:tooltipOpts.xAlign,yAlign:tooltipOpts.yAlign,rtl:tooltipOpts.rtl,textDirection:tooltipOpts.textDirection,bodyFontColor:tooltipOpts.bodyFontColor,_bodyFontFamily:valueOrDefault$8(tooltipOpts.bodyFontFamily,globalDefaults.defaultFontFamily),_bodyFontStyle:valueOrDefault$8(tooltipOpts.bodyFontStyle,globalDefaults.defaultFontStyle),_bodyAlign:tooltipOpts.bodyAlign,bodyFontSize:valueOrDefault$8(tooltipOpts.bodyFontSize,globalDefaults.defaultFontSize),bodySpacing:tooltipOpts.bodySpacing,titleFontColor:tooltipOpts.titleFontColor,_titleFontFamily:valueOrDefault$8(tooltipOpts.titleFontFamily,globalDefaults.defaultFontFamily),_titleFontStyle:valueOrDefault$8(tooltipOpts.titleFontStyle,globalDefaults.defaultFontStyle),titleFontSize:valueOrDefault$8(tooltipOpts.titleFontSize,globalDefaults.defaultFontSize),_titleAlign:tooltipOpts.titleAlign,titleSpacing:tooltipOpts.titleSpacing,titleMarginBottom:tooltipOpts.titleMarginBottom,footerFontColor:tooltipOpts.footerFontColor,_footerFontFamily:valueOrDefault$8(tooltipOpts.footerFontFamily,globalDefaults.defaultFontFamily),_footerFontStyle:valueOrDefault$8(tooltipOpts.footerFontStyle,globalDefaults.defaultFontStyle),footerFontSize:valueOrDefault$8(tooltipOpts.footerFontSize,globalDefaults.defaultFontSize),_footerAlign:tooltipOpts.footerAlign,footerSpacing:tooltipOpts.footerSpacing,footerMarginTop:tooltipOpts.footerMarginTop,caretSize:tooltipOpts.caretSize,cornerRadius:tooltipOpts.cornerRadius,backgroundColor:tooltipOpts.backgroundColor,opacity:0,legendColorBackground:tooltipOpts.multiKeyBackground,displayColors:tooltipOpts.displayColors,borderColor:tooltipOpts.borderColor,borderWidth:tooltipOpts.borderWidth};}
function getTooltipSize(tooltip,model){var ctx=tooltip._chart.ctx;var height=model.yPadding*2;var width=0;var body=model.body;var combinedBodyLength=body.reduce(function(count,bodyItem){return count+bodyItem.before.length+bodyItem.lines.length+bodyItem.after.length;},0);combinedBodyLength+=model.beforeBody.length+model.afterBody.length;var titleLineCount=model.title.length;var footerLineCount=model.footer.length;var titleFontSize=model.titleFontSize;var bodyFontSize=model.bodyFontSize;var footerFontSize=model.footerFontSize;height+=titleLineCount*titleFontSize;height+=titleLineCount?(titleLineCount-1)*model.titleSpacing:0;height+=titleLineCount?model.titleMarginBottom:0;height+=combinedBodyLength*bodyFontSize;height+=combinedBodyLength?(combinedBodyLength-1)*model.bodySpacing:0;height+=footerLineCount?model.footerMarginTop:0;height+=footerLineCount*(footerFontSize);height+=footerLineCount?(footerLineCount-1)*model.footerSpacing:0;var widthPadding=0;var maxLineWidth=function(line){width=Math.max(width,ctx.measureText(line).width+widthPadding);};ctx.font=helpers$1.fontString(titleFontSize,model._titleFontStyle,model._titleFontFamily);helpers$1.each(model.title,maxLineWidth);ctx.font=helpers$1.fontString(bodyFontSize,model._bodyFontStyle,model._bodyFontFamily);helpers$1.each(model.beforeBody.concat(model.afterBody),maxLineWidth);widthPadding=model.displayColors?(bodyFontSize+2):0;helpers$1.each(body,function(bodyItem){helpers$1.each(bodyItem.before,maxLineWidth);helpers$1.each(bodyItem.lines,maxLineWidth);helpers$1.each(bodyItem.after,maxLineWidth);});widthPadding=0;ctx.font=helpers$1.fontString(footerFontSize,model._footerFontStyle,model._footerFontFamily);helpers$1.each(model.footer,maxLineWidth);width+=2*model.xPadding;return{width:width,height:height};}
function determineAlignment(tooltip,size){var model=tooltip._model;var chart=tooltip._chart;var chartArea=tooltip._chart.chartArea;var xAlign='center';var yAlign='center';if(model.y<size.height){yAlign='top';}else if(model.y>(chart.height-size.height)){yAlign='bottom';}
var lf,rf;var olf,orf;var yf;var midX=(chartArea.left+chartArea.right)/2;var midY=(chartArea.top+chartArea.bottom)/2;if(yAlign==='center'){lf=function(x){return x<=midX;};rf=function(x){return x>midX;};}else{lf=function(x){return x<=(size.width/2);};rf=function(x){return x>=(chart.width-(size.width/2));};}
olf=function(x){return x+size.width+model.caretSize+model.caretPadding>chart.width;};orf=function(x){return x-size.width-model.caretSize-model.caretPadding<0;};yf=function(y){return y<=midY?'top':'bottom';};if(lf(model.x)){xAlign='left';if(olf(model.x)){xAlign='center';yAlign=yf(model.y);}}else if(rf(model.x)){xAlign='right';if(orf(model.x)){xAlign='center';yAlign=yf(model.y);}}
var opts=tooltip._options;return{xAlign:opts.xAlign?opts.xAlign:xAlign,yAlign:opts.yAlign?opts.yAlign:yAlign};}
function getBackgroundPoint(vm,size,alignment,chart){var x=vm.x;var y=vm.y;var caretSize=vm.caretSize;var caretPadding=vm.caretPadding;var cornerRadius=vm.cornerRadius;var xAlign=alignment.xAlign;var yAlign=alignment.yAlign;var paddingAndSize=caretSize+caretPadding;var radiusAndPadding=cornerRadius+caretPadding;if(xAlign==='right'){x-=size.width;}else if(xAlign==='center'){x-=(size.width/2);if(x+size.width>chart.width){x=chart.width-size.width;}
if(x<0){x=0;}}
if(yAlign==='top'){y+=paddingAndSize;}else if(yAlign==='bottom'){y-=size.height+paddingAndSize;}else{y-=(size.height/2);}
if(yAlign==='center'){if(xAlign==='left'){x+=paddingAndSize;}else if(xAlign==='right'){x-=paddingAndSize;}}else if(xAlign==='left'){x-=radiusAndPadding;}else if(xAlign==='right'){x+=radiusAndPadding;}
return{x:x,y:y};}
function getAlignedX(vm,align){return align==='center'?vm.x+vm.width/2:align==='right'?vm.x+vm.width-vm.xPadding:vm.x+vm.xPadding;}
function getBeforeAfterBodyLines(callback){return pushOrConcat([],splitNewlines(callback));}
var exports$4=core_element.extend({initialize:function(){this._model=getBaseModel(this._options);this._lastActive=[];},getTitle:function(){var me=this;var opts=me._options;var callbacks=opts.callbacks;var beforeTitle=callbacks.beforeTitle.apply(me,arguments);var title=callbacks.title.apply(me,arguments);var afterTitle=callbacks.afterTitle.apply(me,arguments);var lines=[];lines=pushOrConcat(lines,splitNewlines(beforeTitle));lines=pushOrConcat(lines,splitNewlines(title));lines=pushOrConcat(lines,splitNewlines(afterTitle));return lines;},getBeforeBody:function(){return getBeforeAfterBodyLines(this._options.callbacks.beforeBody.apply(this,arguments));},getBody:function(tooltipItems,data){var me=this;var callbacks=me._options.callbacks;var bodyItems=[];helpers$1.each(tooltipItems,function(tooltipItem){var bodyItem={before:[],lines:[],after:[]};pushOrConcat(bodyItem.before,splitNewlines(callbacks.beforeLabel.call(me,tooltipItem,data)));pushOrConcat(bodyItem.lines,callbacks.label.call(me,tooltipItem,data));pushOrConcat(bodyItem.after,splitNewlines(callbacks.afterLabel.call(me,tooltipItem,data)));bodyItems.push(bodyItem);});return bodyItems;},getAfterBody:function(){return getBeforeAfterBodyLines(this._options.callbacks.afterBody.apply(this,arguments));},getFooter:function(){var me=this;var callbacks=me._options.callbacks;var beforeFooter=callbacks.beforeFooter.apply(me,arguments);var footer=callbacks.footer.apply(me,arguments);var afterFooter=callbacks.afterFooter.apply(me,arguments);var lines=[];lines=pushOrConcat(lines,splitNewlines(beforeFooter));lines=pushOrConcat(lines,splitNewlines(footer));lines=pushOrConcat(lines,splitNewlines(afterFooter));return lines;},update:function(changed){var me=this;var opts=me._options;var existingModel=me._model;var model=me._model=getBaseModel(opts);var active=me._active;var data=me._data;var alignment={xAlign:existingModel.xAlign,yAlign:existingModel.yAlign};var backgroundPoint={x:existingModel.x,y:existingModel.y};var tooltipSize={width:existingModel.width,height:existingModel.height};var tooltipPosition={x:existingModel.caretX,y:existingModel.caretY};var i,len;if(active.length){model.opacity=1;var labelColors=[];var labelTextColors=[];tooltipPosition=positioners[opts.position].call(me,active,me._eventPosition);var tooltipItems=[];for(i=0,len=active.length;i<len;++i){tooltipItems.push(createTooltipItem(active[i]));}
if(opts.filter){tooltipItems=tooltipItems.filter(function(a){return opts.filter(a,data);});}
if(opts.itemSort){tooltipItems=tooltipItems.sort(function(a,b){return opts.itemSort(a,b,data);});}
helpers$1.each(tooltipItems,function(tooltipItem){labelColors.push(opts.callbacks.labelColor.call(me,tooltipItem,me._chart));labelTextColors.push(opts.callbacks.labelTextColor.call(me,tooltipItem,me._chart));});model.title=me.getTitle(tooltipItems,data);model.beforeBody=me.getBeforeBody(tooltipItems,data);model.body=me.getBody(tooltipItems,data);model.afterBody=me.getAfterBody(tooltipItems,data);model.footer=me.getFooter(tooltipItems,data);model.x=tooltipPosition.x;model.y=tooltipPosition.y;model.caretPadding=opts.caretPadding;model.labelColors=labelColors;model.labelTextColors=labelTextColors;model.dataPoints=tooltipItems;tooltipSize=getTooltipSize(this,model);alignment=determineAlignment(this,tooltipSize);backgroundPoint=getBackgroundPoint(model,tooltipSize,alignment,me._chart);}else{model.opacity=0;}
model.xAlign=alignment.xAlign;model.yAlign=alignment.yAlign;model.x=backgroundPoint.x;model.y=backgroundPoint.y;model.width=tooltipSize.width;model.height=tooltipSize.height;model.caretX=tooltipPosition.x;model.caretY=tooltipPosition.y;me._model=model;if(changed&&opts.custom){opts.custom.call(me,model);}
return me;},drawCaret:function(tooltipPoint,size){var ctx=this._chart.ctx;var vm=this._view;var caretPosition=this.getCaretPosition(tooltipPoint,size,vm);ctx.lineTo(caretPosition.x1,caretPosition.y1);ctx.lineTo(caretPosition.x2,caretPosition.y2);ctx.lineTo(caretPosition.x3,caretPosition.y3);},getCaretPosition:function(tooltipPoint,size,vm){var x1,x2,x3,y1,y2,y3;var caretSize=vm.caretSize;var cornerRadius=vm.cornerRadius;var xAlign=vm.xAlign;var yAlign=vm.yAlign;var ptX=tooltipPoint.x;var ptY=tooltipPoint.y;var width=size.width;var height=size.height;if(yAlign==='center'){y2=ptY+(height/2);if(xAlign==='left'){x1=ptX;x2=x1-caretSize;x3=x1;y1=y2+caretSize;y3=y2-caretSize;}else{x1=ptX+width;x2=x1+caretSize;x3=x1;y1=y2-caretSize;y3=y2+caretSize;}}else{if(xAlign==='left'){x2=ptX+cornerRadius+(caretSize);x1=x2-caretSize;x3=x2+caretSize;}else if(xAlign==='right'){x2=ptX+width-cornerRadius-caretSize;x1=x2-caretSize;x3=x2+caretSize;}else{x2=vm.caretX;x1=x2-caretSize;x3=x2+caretSize;}
if(yAlign==='top'){y1=ptY;y2=y1-caretSize;y3=y1;}else{y1=ptY+height;y2=y1+caretSize;y3=y1;var tmp=x3;x3=x1;x1=tmp;}}
return{x1:x1,x2:x2,x3:x3,y1:y1,y2:y2,y3:y3};},drawTitle:function(pt,vm,ctx){var title=vm.title;var length=title.length;var titleFontSize,titleSpacing,i;if(length){var rtlHelper=getRtlHelper(vm.rtl,vm.x,vm.width);pt.x=getAlignedX(vm,vm._titleAlign);ctx.textAlign=rtlHelper.textAlign(vm._titleAlign);ctx.textBaseline='middle';titleFontSize=vm.titleFontSize;titleSpacing=vm.titleSpacing;ctx.fillStyle=vm.titleFontColor;ctx.font=helpers$1.fontString(titleFontSize,vm._titleFontStyle,vm._titleFontFamily);for(i=0;i<length;++i){ctx.fillText(title[i],rtlHelper.x(pt.x),pt.y+titleFontSize/2);pt.y+=titleFontSize+titleSpacing;if(i+1===length){pt.y+=vm.titleMarginBottom-titleSpacing;}}}},drawBody:function(pt,vm,ctx){var bodyFontSize=vm.bodyFontSize;var bodySpacing=vm.bodySpacing;var bodyAlign=vm._bodyAlign;var body=vm.body;var drawColorBoxes=vm.displayColors;var xLinePadding=0;var colorX=drawColorBoxes?getAlignedX(vm,'left'):0;var rtlHelper=getRtlHelper(vm.rtl,vm.x,vm.width);var fillLineOfText=function(line){ctx.fillText(line,rtlHelper.x(pt.x+xLinePadding),pt.y+bodyFontSize/2);pt.y+=bodyFontSize+bodySpacing;};var bodyItem,textColor,labelColors,lines,i,j,ilen,jlen;var bodyAlignForCalculation=rtlHelper.textAlign(bodyAlign);ctx.textAlign=bodyAlign;ctx.textBaseline='middle';ctx.font=helpers$1.fontString(bodyFontSize,vm._bodyFontStyle,vm._bodyFontFamily);pt.x=getAlignedX(vm,bodyAlignForCalculation);ctx.fillStyle=vm.bodyFontColor;helpers$1.each(vm.beforeBody,fillLineOfText);xLinePadding=drawColorBoxes&&bodyAlignForCalculation!=='right'?bodyAlign==='center'?(bodyFontSize/2+1):(bodyFontSize+2):0;for(i=0,ilen=body.length;i<ilen;++i){bodyItem=body[i];textColor=vm.labelTextColors[i];labelColors=vm.labelColors[i];ctx.fillStyle=textColor;helpers$1.each(bodyItem.before,fillLineOfText);lines=bodyItem.lines;for(j=0,jlen=lines.length;j<jlen;++j){if(drawColorBoxes){var rtlColorX=rtlHelper.x(colorX);ctx.fillStyle=vm.legendColorBackground;ctx.fillRect(rtlHelper.leftForLtr(rtlColorX,bodyFontSize),pt.y,bodyFontSize,bodyFontSize);ctx.lineWidth=1;ctx.strokeStyle=labelColors.borderColor;ctx.strokeRect(rtlHelper.leftForLtr(rtlColorX,bodyFontSize),pt.y,bodyFontSize,bodyFontSize);ctx.fillStyle=labelColors.backgroundColor;ctx.fillRect(rtlHelper.leftForLtr(rtlHelper.xPlus(rtlColorX,1),bodyFontSize-2),pt.y+1,bodyFontSize-2,bodyFontSize-2);ctx.fillStyle=textColor;}
fillLineOfText(lines[j]);}
helpers$1.each(bodyItem.after,fillLineOfText);}
xLinePadding=0;helpers$1.each(vm.afterBody,fillLineOfText);pt.y-=bodySpacing;},drawFooter:function(pt,vm,ctx){var footer=vm.footer;var length=footer.length;var footerFontSize,i;if(length){var rtlHelper=getRtlHelper(vm.rtl,vm.x,vm.width);pt.x=getAlignedX(vm,vm._footerAlign);pt.y+=vm.footerMarginTop;ctx.textAlign=rtlHelper.textAlign(vm._footerAlign);ctx.textBaseline='middle';footerFontSize=vm.footerFontSize;ctx.fillStyle=vm.footerFontColor;ctx.font=helpers$1.fontString(footerFontSize,vm._footerFontStyle,vm._footerFontFamily);for(i=0;i<length;++i){ctx.fillText(footer[i],rtlHelper.x(pt.x),pt.y+footerFontSize/2);pt.y+=footerFontSize+vm.footerSpacing;}}},drawBackground:function(pt,vm,ctx,tooltipSize){ctx.fillStyle=vm.backgroundColor;ctx.strokeStyle=vm.borderColor;ctx.lineWidth=vm.borderWidth;var xAlign=vm.xAlign;var yAlign=vm.yAlign;var x=pt.x;var y=pt.y;var width=tooltipSize.width;var height=tooltipSize.height;var radius=vm.cornerRadius;ctx.beginPath();ctx.moveTo(x+radius,y);if(yAlign==='top'){this.drawCaret(pt,tooltipSize);}
ctx.lineTo(x+width-radius,y);ctx.quadraticCurveTo(x+width,y,x+width,y+radius);if(yAlign==='center'&&xAlign==='right'){this.drawCaret(pt,tooltipSize);}
ctx.lineTo(x+width,y+height-radius);ctx.quadraticCurveTo(x+width,y+height,x+width-radius,y+height);if(yAlign==='bottom'){this.drawCaret(pt,tooltipSize);}
ctx.lineTo(x+radius,y+height);ctx.quadraticCurveTo(x,y+height,x,y+height-radius);if(yAlign==='center'&&xAlign==='left'){this.drawCaret(pt,tooltipSize);}
ctx.lineTo(x,y+radius);ctx.quadraticCurveTo(x,y,x+radius,y);ctx.closePath();ctx.fill();if(vm.borderWidth>0){ctx.stroke();}},draw:function(){var ctx=this._chart.ctx;var vm=this._view;if(vm.opacity===0){return;}
var tooltipSize={width:vm.width,height:vm.height};var pt={x:vm.x,y:vm.y};var opacity=Math.abs(vm.opacity<1e-3)?0:vm.opacity;var hasTooltipContent=vm.title.length||vm.beforeBody.length||vm.body.length||vm.afterBody.length||vm.footer.length;if(this._options.enabled&&hasTooltipContent){ctx.save();ctx.globalAlpha=opacity;this.drawBackground(pt,vm,ctx,tooltipSize);pt.y+=vm.yPadding;helpers$1.rtl.overrideTextDirection(ctx,vm.textDirection);this.drawTitle(pt,vm,ctx);this.drawBody(pt,vm,ctx);this.drawFooter(pt,vm,ctx);helpers$1.rtl.restoreTextDirection(ctx,vm.textDirection);ctx.restore();}},handleEvent:function(e){var me=this;var options=me._options;var changed=false;me._lastActive=me._lastActive||[];if(e.type==='mouseout'){me._active=[];}else{me._active=me._chart.getElementsAtEventForMode(e,options.mode,options);if(options.reverse){me._active.reverse();}}
changed=!helpers$1.arrayEquals(me._active,me._lastActive);if(changed){me._lastActive=me._active;if(options.enabled||options.custom){me._eventPosition={x:e.x,y:e.y};me.update(true);me.pivot();}}
return changed;}});var positioners_1=positioners;var core_tooltip=exports$4;core_tooltip.positioners=positioners_1;var valueOrDefault$9=helpers$1.valueOrDefault;core_defaults._set('global',{elements:{},events:['mousemove','mouseout','click','touchstart','touchmove'],hover:{onHover:null,mode:'nearest',intersect:true,animationDuration:400},onClick:null,maintainAspectRatio:true,responsive:true,responsiveAnimationDuration:0});function mergeScaleConfig(){return helpers$1.merge({},[].slice.call(arguments),{merger:function(key,target,source,options){if(key==='xAxes'||key==='yAxes'){var slen=source[key].length;var i,type,scale;if(!target[key]){target[key]=[];}
for(i=0;i<slen;++i){scale=source[key][i];type=valueOrDefault$9(scale.type,key==='xAxes'?'category':'linear');if(i>=target[key].length){target[key].push({});}
if(!target[key][i].type||(scale.type&&scale.type!==target[key][i].type)){helpers$1.merge(target[key][i],[core_scaleService.getScaleDefaults(type),scale]);}else{helpers$1.merge(target[key][i],scale);}}}else{helpers$1._merger(key,target,source,options);}}});}
function mergeConfig(){return helpers$1.merge({},[].slice.call(arguments),{merger:function(key,target,source,options){var tval=target[key]||{};var sval=source[key];if(key==='scales'){target[key]=mergeScaleConfig(tval,sval);}else if(key==='scale'){target[key]=helpers$1.merge(tval,[core_scaleService.getScaleDefaults(sval.type),sval]);}else{helpers$1._merger(key,target,source,options);}}});}
function initConfig(config){config=config||{};var data=config.data=config.data||{};data.datasets=data.datasets||[];data.labels=data.labels||[];config.options=mergeConfig(core_defaults.global,core_defaults[config.type],config.options||{});return config;}
function updateConfig(chart){var newOptions=chart.options;helpers$1.each(chart.scales,function(scale){core_layouts.removeBox(chart,scale);});newOptions=mergeConfig(core_defaults.global,core_defaults[chart.config.type],newOptions);chart.options=chart.config.options=newOptions;chart.ensureScalesHaveIDs();chart.buildOrUpdateScales();chart.tooltip._options=newOptions.tooltips;chart.tooltip.initialize();}
function nextAvailableScaleId(axesOpts,prefix,index){var id;var hasId=function(obj){return obj.id===id;};do{id=prefix+index++;}while(helpers$1.findIndex(axesOpts,hasId)>=0);return id;}
function positionIsHorizontal(position){return position==='top'||position==='bottom';}
function compare2Level(l1,l2){return function(a,b){return a[l1]===b[l1]?a[l2]-b[l2]:a[l1]-b[l1];};}
var Chart=function(item,config){this.construct(item,config);return this;};helpers$1.extend(Chart.prototype,{construct:function(item,config){var me=this;config=initConfig(config);var context=platform.acquireContext(item,config);var canvas=context&&context.canvas;var height=canvas&&canvas.height;var width=canvas&&canvas.width;me.id=helpers$1.uid();me.ctx=context;me.canvas=canvas;me.config=config;me.width=width;me.height=height;me.aspectRatio=height?width/height:null;me.options=config.options;me._bufferedRender=false;me._layers=[];me.chart=me;me.controller=me;Chart.instances[me.id]=me;Object.defineProperty(me,'data',{get:function(){return me.config.data;},set:function(value){me.config.data=value;}});if(!context||!canvas){console.error("Failed to create chart: can't acquire context from the given item");return;}
me.initialize();me.update();},initialize:function(){var me=this;core_plugins.notify(me,'beforeInit');helpers$1.retinaScale(me,me.options.devicePixelRatio);me.bindEvents();if(me.options.responsive){me.resize(true);}
me.initToolTip();core_plugins.notify(me,'afterInit');return me;},clear:function(){helpers$1.canvas.clear(this);return this;},stop:function(){core_animations.cancelAnimation(this);return this;},resize:function(silent){var me=this;var options=me.options;var canvas=me.canvas;var aspectRatio=(options.maintainAspectRatio&&me.aspectRatio)||null;var newWidth=Math.max(0,Math.floor(helpers$1.getMaximumWidth(canvas)));var newHeight=Math.max(0,Math.floor(aspectRatio?newWidth/aspectRatio:helpers$1.getMaximumHeight(canvas)));if(me.width===newWidth&&me.height===newHeight){return;}
canvas.width=me.width=newWidth;canvas.height=me.height=newHeight;canvas.style.width=newWidth+'px';canvas.style.height=newHeight+'px';helpers$1.retinaScale(me,options.devicePixelRatio);if(!silent){var newSize={width:newWidth,height:newHeight};core_plugins.notify(me,'resize',[newSize]);if(options.onResize){options.onResize(me,newSize);}
me.stop();me.update({duration:options.responsiveAnimationDuration});}},ensureScalesHaveIDs:function(){var options=this.options;var scalesOptions=options.scales||{};var scaleOptions=options.scale;helpers$1.each(scalesOptions.xAxes,function(xAxisOptions,index){if(!xAxisOptions.id){xAxisOptions.id=nextAvailableScaleId(scalesOptions.xAxes,'x-axis-',index);}});helpers$1.each(scalesOptions.yAxes,function(yAxisOptions,index){if(!yAxisOptions.id){yAxisOptions.id=nextAvailableScaleId(scalesOptions.yAxes,'y-axis-',index);}});if(scaleOptions){scaleOptions.id=scaleOptions.id||'scale';}},buildOrUpdateScales:function(){var me=this;var options=me.options;var scales=me.scales||{};var items=[];var updated=Object.keys(scales).reduce(function(obj,id){obj[id]=false;return obj;},{});if(options.scales){items=items.concat((options.scales.xAxes||[]).map(function(xAxisOptions){return{options:xAxisOptions,dtype:'category',dposition:'bottom'};}),(options.scales.yAxes||[]).map(function(yAxisOptions){return{options:yAxisOptions,dtype:'linear',dposition:'left'};}));}
if(options.scale){items.push({options:options.scale,dtype:'radialLinear',isDefault:true,dposition:'chartArea'});}
helpers$1.each(items,function(item){var scaleOptions=item.options;var id=scaleOptions.id;var scaleType=valueOrDefault$9(scaleOptions.type,item.dtype);if(positionIsHorizontal(scaleOptions.position)!==positionIsHorizontal(item.dposition)){scaleOptions.position=item.dposition;}
updated[id]=true;var scale=null;if(id in scales&&scales[id].type===scaleType){scale=scales[id];scale.options=scaleOptions;scale.ctx=me.ctx;scale.chart=me;}else{var scaleClass=core_scaleService.getScaleConstructor(scaleType);if(!scaleClass){return;}
scale=new scaleClass({id:id,type:scaleType,options:scaleOptions,ctx:me.ctx,chart:me});scales[scale.id]=scale;}
scale.mergeTicksOptions();if(item.isDefault){me.scale=scale;}});helpers$1.each(updated,function(hasUpdated,id){if(!hasUpdated){delete scales[id];}});me.scales=scales;core_scaleService.addScalesToLayout(this);},buildOrUpdateControllers:function(){var me=this;var newControllers=[];var datasets=me.data.datasets;var i,ilen;for(i=0,ilen=datasets.length;i<ilen;i++){var dataset=datasets[i];var meta=me.getDatasetMeta(i);var type=dataset.type||me.config.type;if(meta.type&&meta.type!==type){me.destroyDatasetMeta(i);meta=me.getDatasetMeta(i);}
meta.type=type;meta.order=dataset.order||0;meta.index=i;if(meta.controller){meta.controller.updateIndex(i);meta.controller.linkScales();}else{var ControllerClass=controllers[meta.type];if(ControllerClass===undefined){throw new Error('"'+meta.type+'" is not a chart type.');}
meta.controller=new ControllerClass(me,i);newControllers.push(meta.controller);}}
return newControllers;},resetElements:function(){var me=this;helpers$1.each(me.data.datasets,function(dataset,datasetIndex){me.getDatasetMeta(datasetIndex).controller.reset();},me);},reset:function(){this.resetElements();this.tooltip.initialize();},update:function(config){var me=this;var i,ilen;if(!config||typeof config!=='object'){config={duration:config,lazy:arguments[1]};}
updateConfig(me);core_plugins._invalidate(me);if(core_plugins.notify(me,'beforeUpdate')===false){return;}
me.tooltip._data=me.data;var newControllers=me.buildOrUpdateControllers();for(i=0,ilen=me.data.datasets.length;i<ilen;i++){me.getDatasetMeta(i).controller.buildOrUpdateElements();}
me.updateLayout();if(me.options.animation&&me.options.animation.duration){helpers$1.each(newControllers,function(controller){controller.reset();});}
me.updateDatasets();me.tooltip.initialize();me.lastActive=[];core_plugins.notify(me,'afterUpdate');me._layers.sort(compare2Level('z','_idx'));if(me._bufferedRender){me._bufferedRequest={duration:config.duration,easing:config.easing,lazy:config.lazy};}else{me.render(config);}},updateLayout:function(){var me=this;if(core_plugins.notify(me,'beforeLayout')===false){return;}
core_layouts.update(this,this.width,this.height);me._layers=[];helpers$1.each(me.boxes,function(box){if(box._configure){box._configure();}
me._layers.push.apply(me._layers,box._layers());},me);me._layers.forEach(function(item,index){item._idx=index;});core_plugins.notify(me,'afterScaleUpdate');core_plugins.notify(me,'afterLayout');},updateDatasets:function(){var me=this;if(core_plugins.notify(me,'beforeDatasetsUpdate')===false){return;}
for(var i=0,ilen=me.data.datasets.length;i<ilen;++i){me.updateDataset(i);}
core_plugins.notify(me,'afterDatasetsUpdate');},updateDataset:function(index){var me=this;var meta=me.getDatasetMeta(index);var args={meta:meta,index:index};if(core_plugins.notify(me,'beforeDatasetUpdate',[args])===false){return;}
meta.controller._update();core_plugins.notify(me,'afterDatasetUpdate',[args]);},render:function(config){var me=this;if(!config||typeof config!=='object'){config={duration:config,lazy:arguments[1]};}
var animationOptions=me.options.animation;var duration=valueOrDefault$9(config.duration,animationOptions&&animationOptions.duration);var lazy=config.lazy;if(core_plugins.notify(me,'beforeRender')===false){return;}
var onComplete=function(animation){core_plugins.notify(me,'afterRender');helpers$1.callback(animationOptions&&animationOptions.onComplete,[animation],me);};if(animationOptions&&duration){var animation=new core_animation({numSteps:duration/16.66,easing:config.easing||animationOptions.easing,render:function(chart,animationObject){var easingFunction=helpers$1.easing.effects[animationObject.easing];var currentStep=animationObject.currentStep;var stepDecimal=currentStep/animationObject.numSteps;chart.draw(easingFunction(stepDecimal),stepDecimal,currentStep);},onAnimationProgress:animationOptions.onProgress,onAnimationComplete:onComplete});core_animations.addAnimation(me,animation,duration,lazy);}else{me.draw();onComplete(new core_animation({numSteps:0,chart:me}));}
return me;},draw:function(easingValue){var me=this;var i,layers;me.clear();if(helpers$1.isNullOrUndef(easingValue)){easingValue=1;}
me.transition(easingValue);if(me.width<=0||me.height<=0){return;}
if(core_plugins.notify(me,'beforeDraw',[easingValue])===false){return;}
layers=me._layers;for(i=0;i<layers.length&&layers[i].z<=0;++i){layers[i].draw(me.chartArea);}
me.drawDatasets(easingValue);for(;i<layers.length;++i){layers[i].draw(me.chartArea);}
me._drawTooltip(easingValue);core_plugins.notify(me,'afterDraw',[easingValue]);},transition:function(easingValue){var me=this;for(var i=0,ilen=(me.data.datasets||[]).length;i<ilen;++i){if(me.isDatasetVisible(i)){me.getDatasetMeta(i).controller.transition(easingValue);}}
me.tooltip.transition(easingValue);},_getSortedDatasetMetas:function(filterVisible){var me=this;var datasets=me.data.datasets||[];var result=[];var i,ilen;for(i=0,ilen=datasets.length;i<ilen;++i){if(!filterVisible||me.isDatasetVisible(i)){result.push(me.getDatasetMeta(i));}}
result.sort(compare2Level('order','index'));return result;},_getSortedVisibleDatasetMetas:function(){return this._getSortedDatasetMetas(true);},drawDatasets:function(easingValue){var me=this;var metasets,i;if(core_plugins.notify(me,'beforeDatasetsDraw',[easingValue])===false){return;}
metasets=me._getSortedVisibleDatasetMetas();for(i=metasets.length-1;i>=0;--i){me.drawDataset(metasets[i],easingValue);}
core_plugins.notify(me,'afterDatasetsDraw',[easingValue]);},drawDataset:function(meta,easingValue){var me=this;var args={meta:meta,index:meta.index,easingValue:easingValue};if(core_plugins.notify(me,'beforeDatasetDraw',[args])===false){return;}
meta.controller.draw(easingValue);core_plugins.notify(me,'afterDatasetDraw',[args]);},_drawTooltip:function(easingValue){var me=this;var tooltip=me.tooltip;var args={tooltip:tooltip,easingValue:easingValue};if(core_plugins.notify(me,'beforeTooltipDraw',[args])===false){return;}
tooltip.draw();core_plugins.notify(me,'afterTooltipDraw',[args]);},getElementAtEvent:function(e){return core_interaction.modes.single(this,e);},getElementsAtEvent:function(e){return core_interaction.modes.label(this,e,{intersect:true});},getElementsAtXAxis:function(e){return core_interaction.modes['x-axis'](this,e,{intersect:true});},getElementsAtEventForMode:function(e,mode,options){var method=core_interaction.modes[mode];if(typeof method==='function'){return method(this,e,options);}
return[];},getDatasetAtEvent:function(e){return core_interaction.modes.dataset(this,e,{intersect:true});},getDatasetMeta:function(datasetIndex){var me=this;var dataset=me.data.datasets[datasetIndex];if(!dataset._meta){dataset._meta={};}
var meta=dataset._meta[me.id];if(!meta){meta=dataset._meta[me.id]={type:null,data:[],dataset:null,controller:null,hidden:null,xAxisID:null,yAxisID:null,order:dataset.order||0,index:datasetIndex};}
return meta;},getVisibleDatasetCount:function(){var count=0;for(var i=0,ilen=this.data.datasets.length;i<ilen;++i){if(this.isDatasetVisible(i)){count++;}}
return count;},isDatasetVisible:function(datasetIndex){var meta=this.getDatasetMeta(datasetIndex);return typeof meta.hidden==='boolean'?!meta.hidden:!this.data.datasets[datasetIndex].hidden;},generateLegend:function(){return this.options.legendCallback(this);},destroyDatasetMeta:function(datasetIndex){var id=this.id;var dataset=this.data.datasets[datasetIndex];var meta=dataset._meta&&dataset._meta[id];if(meta){meta.controller.destroy();delete dataset._meta[id];}},destroy:function(){var me=this;var canvas=me.canvas;var i,ilen;me.stop();for(i=0,ilen=me.data.datasets.length;i<ilen;++i){me.destroyDatasetMeta(i);}
if(canvas){me.unbindEvents();helpers$1.canvas.clear(me);platform.releaseContext(me.ctx);me.canvas=null;me.ctx=null;}
core_plugins.notify(me,'destroy');delete Chart.instances[me.id];},toBase64Image:function(){return this.canvas.toDataURL.apply(this.canvas,arguments);},initToolTip:function(){var me=this;me.tooltip=new core_tooltip({_chart:me,_chartInstance:me,_data:me.data,_options:me.options.tooltips},me);},bindEvents:function(){var me=this;var listeners=me._listeners={};var listener=function(){me.eventHandler.apply(me,arguments);};helpers$1.each(me.options.events,function(type){platform.addEventListener(me,type,listener);listeners[type]=listener;});if(me.options.responsive){listener=function(){me.resize();};platform.addEventListener(me,'resize',listener);listeners.resize=listener;}},unbindEvents:function(){var me=this;var listeners=me._listeners;if(!listeners){return;}
delete me._listeners;helpers$1.each(listeners,function(listener,type){platform.removeEventListener(me,type,listener);});},updateHoverStyle:function(elements,mode,enabled){var prefix=enabled?'set':'remove';var element,i,ilen;for(i=0,ilen=elements.length;i<ilen;++i){element=elements[i];if(element){this.getDatasetMeta(element._datasetIndex).controller[prefix+'HoverStyle'](element);}}
if(mode==='dataset'){this.getDatasetMeta(elements[0]._datasetIndex).controller['_'+prefix+'DatasetHoverStyle']();}},eventHandler:function(e){var me=this;var tooltip=me.tooltip;if(core_plugins.notify(me,'beforeEvent',[e])===false){return;}
me._bufferedRender=true;me._bufferedRequest=null;var changed=me.handleEvent(e);if(tooltip){changed=tooltip._start?tooltip.handleEvent(e):changed|tooltip.handleEvent(e);}
core_plugins.notify(me,'afterEvent',[e]);var bufferedRequest=me._bufferedRequest;if(bufferedRequest){me.render(bufferedRequest);}else if(changed&&!me.animating){me.stop();me.render({duration:me.options.hover.animationDuration,lazy:true});}
me._bufferedRender=false;me._bufferedRequest=null;return me;},handleEvent:function(e){var me=this;var options=me.options||{};var hoverOptions=options.hover;var changed=false;me.lastActive=me.lastActive||[];if(e.type==='mouseout'){me.active=[];}else{me.active=me.getElementsAtEventForMode(e,hoverOptions.mode,hoverOptions);}
helpers$1.callback(options.onHover||options.hover.onHover,[e.native,me.active],me);if(e.type==='mouseup'||e.type==='click'){if(options.onClick){options.onClick.call(me,e.native,me.active);}}
if(me.lastActive.length){me.updateHoverStyle(me.lastActive,hoverOptions.mode,false);}
if(me.active.length&&hoverOptions.mode){me.updateHoverStyle(me.active,hoverOptions.mode,true);}
changed=!helpers$1.arrayEquals(me.active,me.lastActive);me.lastActive=me.active;return changed;}});Chart.instances={};var core_controller=Chart;Chart.Controller=Chart;Chart.types={};helpers$1.configMerge=mergeConfig;helpers$1.scaleMerge=mergeScaleConfig;var core_helpers=function(){helpers$1.where=function(collection,filterCallback){if(helpers$1.isArray(collection)&&Array.prototype.filter){return collection.filter(filterCallback);}
var filtered=[];helpers$1.each(collection,function(item){if(filterCallback(item)){filtered.push(item);}});return filtered;};helpers$1.findIndex=Array.prototype.findIndex?function(array,callback,scope){return array.findIndex(callback,scope);}:function(array,callback,scope){scope=scope===undefined?array:scope;for(var i=0,ilen=array.length;i<ilen;++i){if(callback.call(scope,array[i],i,array)){return i;}}
return-1;};helpers$1.findNextWhere=function(arrayToSearch,filterCallback,startIndex){if(helpers$1.isNullOrUndef(startIndex)){startIndex=-1;}
for(var i=startIndex+1;i<arrayToSearch.length;i++){var currentItem=arrayToSearch[i];if(filterCallback(currentItem)){return currentItem;}}};helpers$1.findPreviousWhere=function(arrayToSearch,filterCallback,startIndex){if(helpers$1.isNullOrUndef(startIndex)){startIndex=arrayToSearch.length;}
for(var i=startIndex-1;i>=0;i--){var currentItem=arrayToSearch[i];if(filterCallback(currentItem)){return currentItem;}}};helpers$1.isNumber=function(n){return!isNaN(parseFloat(n))&&isFinite(n);};helpers$1.almostEquals=function(x,y,epsilon){return Math.abs(x-y)<epsilon;};helpers$1.almostWhole=function(x,epsilon){var rounded=Math.round(x);return((rounded-epsilon)<=x)&&((rounded+epsilon)>=x);};helpers$1.max=function(array){return array.reduce(function(max,value){if(!isNaN(value)){return Math.max(max,value);}
return max;},Number.NEGATIVE_INFINITY);};helpers$1.min=function(array){return array.reduce(function(min,value){if(!isNaN(value)){return Math.min(min,value);}
return min;},Number.POSITIVE_INFINITY);};helpers$1.sign=Math.sign?function(x){return Math.sign(x);}:function(x){x=+x;if(x===0||isNaN(x)){return x;}
return x>0?1:-1;};helpers$1.toRadians=function(degrees){return degrees*(Math.PI/180);};helpers$1.toDegrees=function(radians){return radians*(180/Math.PI);};helpers$1._decimalPlaces=function(x){if(!helpers$1.isFinite(x)){return;}
var e=1;var p=0;while(Math.round(x*e)/e!==x){e*=10;p++;}
return p;};helpers$1.getAngleFromPoint=function(centrePoint,anglePoint){var distanceFromXCenter=anglePoint.x-centrePoint.x;var distanceFromYCenter=anglePoint.y-centrePoint.y;var radialDistanceFromCenter=Math.sqrt(distanceFromXCenter*distanceFromXCenter+distanceFromYCenter*distanceFromYCenter);var angle=Math.atan2(distanceFromYCenter,distanceFromXCenter);if(angle<(-0.5*Math.PI)){angle+=2.0*Math.PI;}
return{angle:angle,distance:radialDistanceFromCenter};};helpers$1.distanceBetweenPoints=function(pt1,pt2){return Math.sqrt(Math.pow(pt2.x-pt1.x,2)+Math.pow(pt2.y-pt1.y,2));};helpers$1.aliasPixel=function(pixelWidth){return(pixelWidth%2===0)?0:0.5;};helpers$1._alignPixel=function(chart,pixel,width){var devicePixelRatio=chart.currentDevicePixelRatio;var halfWidth=width/2;return Math.round((pixel-halfWidth)*devicePixelRatio)/devicePixelRatio+halfWidth;};helpers$1.splineCurve=function(firstPoint,middlePoint,afterPoint,t){var previous=firstPoint.skip?middlePoint:firstPoint;var current=middlePoint;var next=afterPoint.skip?middlePoint:afterPoint;var d01=Math.sqrt(Math.pow(current.x-previous.x,2)+Math.pow(current.y-previous.y,2));var d12=Math.sqrt(Math.pow(next.x-current.x,2)+Math.pow(next.y-current.y,2));var s01=d01/(d01+d12);var s12=d12/(d01+d12);s01=isNaN(s01)?0:s01;s12=isNaN(s12)?0:s12;var fa=t*s01;var fb=t*s12;return{previous:{x:current.x-fa*(next.x-previous.x),y:current.y-fa*(next.y-previous.y)},next:{x:current.x+fb*(next.x-previous.x),y:current.y+fb*(next.y-previous.y)}};};helpers$1.EPSILON=Number.EPSILON||1e-14;helpers$1.splineCurveMonotone=function(points){var pointsWithTangents=(points||[]).map(function(point){return{model:point._model,deltaK:0,mK:0};});var pointsLen=pointsWithTangents.length;var i,pointBefore,pointCurrent,pointAfter;for(i=0;i<pointsLen;++i){pointCurrent=pointsWithTangents[i];if(pointCurrent.model.skip){continue;}
pointBefore=i>0?pointsWithTangents[i-1]:null;pointAfter=i<pointsLen-1?pointsWithTangents[i+1]:null;if(pointAfter&&!pointAfter.model.skip){var slopeDeltaX=(pointAfter.model.x-pointCurrent.model.x);pointCurrent.deltaK=slopeDeltaX!==0?(pointAfter.model.y-pointCurrent.model.y)/slopeDeltaX:0;}
if(!pointBefore||pointBefore.model.skip){pointCurrent.mK=pointCurrent.deltaK;}else if(!pointAfter||pointAfter.model.skip){pointCurrent.mK=pointBefore.deltaK;}else if(this.sign(pointBefore.deltaK)!==this.sign(pointCurrent.deltaK)){pointCurrent.mK=0;}else{pointCurrent.mK=(pointBefore.deltaK+pointCurrent.deltaK)/2;}}
var alphaK,betaK,tauK,squaredMagnitude;for(i=0;i<pointsLen-1;++i){pointCurrent=pointsWithTangents[i];pointAfter=pointsWithTangents[i+1];if(pointCurrent.model.skip||pointAfter.model.skip){continue;}
if(helpers$1.almostEquals(pointCurrent.deltaK,0,this.EPSILON)){pointCurrent.mK=pointAfter.mK=0;continue;}
alphaK=pointCurrent.mK/pointCurrent.deltaK;betaK=pointAfter.mK/pointCurrent.deltaK;squaredMagnitude=Math.pow(alphaK,2)+Math.pow(betaK,2);if(squaredMagnitude<=9){continue;}
tauK=3/Math.sqrt(squaredMagnitude);pointCurrent.mK=alphaK*tauK*pointCurrent.deltaK;pointAfter.mK=betaK*tauK*pointCurrent.deltaK;}
var deltaX;for(i=0;i<pointsLen;++i){pointCurrent=pointsWithTangents[i];if(pointCurrent.model.skip){continue;}
pointBefore=i>0?pointsWithTangents[i-1]:null;pointAfter=i<pointsLen-1?pointsWithTangents[i+1]:null;if(pointBefore&&!pointBefore.model.skip){deltaX=(pointCurrent.model.x-pointBefore.model.x)/3;pointCurrent.model.controlPointPreviousX=pointCurrent.model.x-deltaX;pointCurrent.model.controlPointPreviousY=pointCurrent.model.y-deltaX*pointCurrent.mK;}
if(pointAfter&&!pointAfter.model.skip){deltaX=(pointAfter.model.x-pointCurrent.model.x)/3;pointCurrent.model.controlPointNextX=pointCurrent.model.x+deltaX;pointCurrent.model.controlPointNextY=pointCurrent.model.y+deltaX*pointCurrent.mK;}}};helpers$1.nextItem=function(collection,index,loop){if(loop){return index>=collection.length-1?collection[0]:collection[index+1];}
return index>=collection.length-1?collection[collection.length-1]:collection[index+1];};helpers$1.previousItem=function(collection,index,loop){if(loop){return index<=0?collection[collection.length-1]:collection[index-1];}
return index<=0?collection[0]:collection[index-1];};helpers$1.niceNum=function(range,round){var exponent=Math.floor(helpers$1.log10(range));var fraction=range/Math.pow(10,exponent);var niceFraction;if(round){if(fraction<1.5){niceFraction=1;}else if(fraction<3){niceFraction=2;}else if(fraction<7){niceFraction=5;}else{niceFraction=10;}}else if(fraction<=1.0){niceFraction=1;}else if(fraction<=2){niceFraction=2;}else if(fraction<=5){niceFraction=5;}else{niceFraction=10;}
return niceFraction*Math.pow(10,exponent);};helpers$1.requestAnimFrame=(function(){if(typeof window==='undefined'){return function(callback){callback();};}
return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(callback){return window.setTimeout(callback,1000/60);};}());helpers$1.getRelativePosition=function(evt,chart){var mouseX,mouseY;var e=evt.originalEvent||evt;var canvas=evt.target||evt.srcElement;var boundingRect=canvas.getBoundingClientRect();var touches=e.touches;if(touches&&touches.length>0){mouseX=touches[0].clientX;mouseY=touches[0].clientY;}else{mouseX=e.clientX;mouseY=e.clientY;}
var paddingLeft=parseFloat(helpers$1.getStyle(canvas,'padding-left'));var paddingTop=parseFloat(helpers$1.getStyle(canvas,'padding-top'));var paddingRight=parseFloat(helpers$1.getStyle(canvas,'padding-right'));var paddingBottom=parseFloat(helpers$1.getStyle(canvas,'padding-bottom'));var width=boundingRect.right-boundingRect.left-paddingLeft-paddingRight;var height=boundingRect.bottom-boundingRect.top-paddingTop-paddingBottom;mouseX=Math.round((mouseX-boundingRect.left-paddingLeft)/(width)*canvas.width/chart.currentDevicePixelRatio);mouseY=Math.round((mouseY-boundingRect.top-paddingTop)/(height)*canvas.height/chart.currentDevicePixelRatio);return{x:mouseX,y:mouseY};};function parseMaxStyle(styleValue,node,parentProperty){var valueInPixels;if(typeof styleValue==='string'){valueInPixels=parseInt(styleValue,10);if(styleValue.indexOf('%')!==-1){valueInPixels=valueInPixels/100*node.parentNode[parentProperty];}}else{valueInPixels=styleValue;}
return valueInPixels;}
function isConstrainedValue(value){return value!==undefined&&value!==null&&value!=='none';}
function getConstraintDimension(domNode,maxStyle,percentageProperty){var view=document.defaultView;var parentNode=helpers$1._getParentNode(domNode);var constrainedNode=view.getComputedStyle(domNode)[maxStyle];var constrainedContainer=view.getComputedStyle(parentNode)[maxStyle];var hasCNode=isConstrainedValue(constrainedNode);var hasCContainer=isConstrainedValue(constrainedContainer);var infinity=Number.POSITIVE_INFINITY;if(hasCNode||hasCContainer){return Math.min(hasCNode?parseMaxStyle(constrainedNode,domNode,percentageProperty):infinity,hasCContainer?parseMaxStyle(constrainedContainer,parentNode,percentageProperty):infinity);}
return'none';}
helpers$1.getConstraintWidth=function(domNode){return getConstraintDimension(domNode,'max-width','clientWidth');};helpers$1.getConstraintHeight=function(domNode){return getConstraintDimension(domNode,'max-height','clientHeight');};helpers$1._calculatePadding=function(container,padding,parentDimension){padding=helpers$1.getStyle(container,padding);return padding.indexOf('%')>-1?parentDimension*parseInt(padding,10)/100:parseInt(padding,10);};helpers$1._getParentNode=function(domNode){var parent=domNode.parentNode;if(parent&&parent.toString()==='[object ShadowRoot]'){parent=parent.host;}
return parent;};helpers$1.getMaximumWidth=function(domNode){var container=helpers$1._getParentNode(domNode);if(!container){return domNode.clientWidth;}
var clientWidth=container.clientWidth;var paddingLeft=helpers$1._calculatePadding(container,'padding-left',clientWidth);var paddingRight=helpers$1._calculatePadding(container,'padding-right',clientWidth);var w=clientWidth-paddingLeft-paddingRight;var cw=helpers$1.getConstraintWidth(domNode);return isNaN(cw)?w:Math.min(w,cw);};helpers$1.getMaximumHeight=function(domNode){var container=helpers$1._getParentNode(domNode);if(!container){return domNode.clientHeight;}
var clientHeight=container.clientHeight;var paddingTop=helpers$1._calculatePadding(container,'padding-top',clientHeight);var paddingBottom=helpers$1._calculatePadding(container,'padding-bottom',clientHeight);var h=clientHeight-paddingTop-paddingBottom;var ch=helpers$1.getConstraintHeight(domNode);return isNaN(ch)?h:Math.min(h,ch);};helpers$1.getStyle=function(el,property){return el.currentStyle?el.currentStyle[property]:document.defaultView.getComputedStyle(el,null).getPropertyValue(property);};helpers$1.retinaScale=function(chart,forceRatio){var pixelRatio=chart.currentDevicePixelRatio=forceRatio||(typeof window!=='undefined'&&window.devicePixelRatio)||1;if(pixelRatio===1){return;}
var canvas=chart.canvas;var height=chart.height;var width=chart.width;canvas.height=height*pixelRatio;canvas.width=width*pixelRatio;chart.ctx.scale(pixelRatio,pixelRatio);if(!canvas.style.height&&!canvas.style.width){canvas.style.height=height+'px';canvas.style.width=width+'px';}};helpers$1.fontString=function(pixelSize,fontStyle,fontFamily){return fontStyle+' '+pixelSize+'px '+fontFamily;};helpers$1.longestText=function(ctx,font,arrayOfThings,cache){cache=cache||{};var data=cache.data=cache.data||{};var gc=cache.garbageCollect=cache.garbageCollect||[];if(cache.font!==font){data=cache.data={};gc=cache.garbageCollect=[];cache.font=font;}
ctx.font=font;var longest=0;var ilen=arrayOfThings.length;var i,j,jlen,thing,nestedThing;for(i=0;i<ilen;i++){thing=arrayOfThings[i];if(thing!==undefined&&thing!==null&&helpers$1.isArray(thing)!==true){longest=helpers$1.measureText(ctx,data,gc,longest,thing);}else if(helpers$1.isArray(thing)){for(j=0,jlen=thing.length;j<jlen;j++){nestedThing=thing[j];if(nestedThing!==undefined&&nestedThing!==null&&!helpers$1.isArray(nestedThing)){longest=helpers$1.measureText(ctx,data,gc,longest,nestedThing);}}}}
var gcLen=gc.length/2;if(gcLen>arrayOfThings.length){for(i=0;i<gcLen;i++){delete data[gc[i]];}
gc.splice(0,gcLen);}
return longest;};helpers$1.measureText=function(ctx,data,gc,longest,string){var textWidth=data[string];if(!textWidth){textWidth=data[string]=ctx.measureText(string).width;gc.push(string);}
if(textWidth>longest){longest=textWidth;}
return longest;};helpers$1.numberOfLabelLines=function(arrayOfThings){var numberOfLines=1;helpers$1.each(arrayOfThings,function(thing){if(helpers$1.isArray(thing)){if(thing.length>numberOfLines){numberOfLines=thing.length;}}});return numberOfLines;};helpers$1.color=!chartjsColor?function(value){console.error('Color.js not found!');return value;}:function(value){if(value instanceof CanvasGradient){value=core_defaults.global.defaultColor;}
return chartjsColor(value);};helpers$1.getHoverColor=function(colorValue){return(colorValue instanceof CanvasPattern||colorValue instanceof CanvasGradient)?colorValue:helpers$1.color(colorValue).saturate(0.5).darken(0.1).rgbString();};};function abstract(){throw new Error('This method is not implemented: either no adapter can '+'be found or an incomplete integration was provided.');}
function DateAdapter(options){this.options=options||{};}
helpers$1.extend(DateAdapter.prototype,{formats:abstract,parse:abstract,format:abstract,add:abstract,diff:abstract,startOf:abstract,endOf:abstract,_create:function(value){return value;}});DateAdapter.override=function(members){helpers$1.extend(DateAdapter.prototype,members);};var _date=DateAdapter;var core_adapters={_date:_date};var core_ticks={formatters:{values:function(value){return helpers$1.isArray(value)?value:''+value;},linear:function(tickValue,index,ticks){var delta=ticks.length>3?ticks[2]-ticks[1]:ticks[1]-ticks[0];if(Math.abs(delta)>1){if(tickValue!==Math.floor(tickValue)){delta=tickValue-Math.floor(tickValue);}}
var logDelta=helpers$1.log10(Math.abs(delta));var tickString='';if(tickValue!==0){var maxTick=Math.max(Math.abs(ticks[0]),Math.abs(ticks[ticks.length-1]));if(maxTick<1e-4){var logTick=helpers$1.log10(Math.abs(tickValue));var numExponential=Math.floor(logTick)-Math.floor(logDelta);numExponential=Math.max(Math.min(numExponential,20),0);tickString=tickValue.toExponential(numExponential);}else{var numDecimal=-1*Math.floor(logDelta);numDecimal=Math.max(Math.min(numDecimal,20),0);tickString=tickValue.toFixed(numDecimal);}}else{tickString='0';}
return tickString;},logarithmic:function(tickValue,index,ticks){var remain=tickValue/(Math.pow(10,Math.floor(helpers$1.log10(tickValue))));if(tickValue===0){return'0';}else if(remain===1||remain===2||remain===5||index===0||index===ticks.length-1){return tickValue.toExponential();}
return'';}}};var isArray=helpers$1.isArray;var isNullOrUndef=helpers$1.isNullOrUndef;var valueOrDefault$a=helpers$1.valueOrDefault;var valueAtIndexOrDefault=helpers$1.valueAtIndexOrDefault;core_defaults._set('scale',{display:true,position:'left',offset:false,gridLines:{display:true,color:'rgba(0,0,0,0.1)',lineWidth:1,drawBorder:true,drawOnChartArea:true,drawTicks:true,tickMarkLength:10,zeroLineWidth:1,zeroLineColor:'rgba(0,0,0,0.25)',zeroLineBorderDash:[],zeroLineBorderDashOffset:0.0,offsetGridLines:false,borderDash:[],borderDashOffset:0.0},scaleLabel:{display:false,labelString:'',padding:{top:4,bottom:4}},ticks:{beginAtZero:false,minRotation:0,maxRotation:50,mirror:false,padding:0,reverse:false,display:true,autoSkip:true,autoSkipPadding:0,labelOffset:0,callback:core_ticks.formatters.values,minor:{},major:{}}});function sample(arr,numItems){var result=[];var increment=arr.length/numItems;var i=0;var len=arr.length;for(;i<len;i+=increment){result.push(arr[Math.floor(i)]);}
return result;}
function getPixelForGridLine(scale,index,offsetGridLines){var length=scale.getTicks().length;var validIndex=Math.min(index,length-1);var lineValue=scale.getPixelForTick(validIndex);var start=scale._startPixel;var end=scale._endPixel;var epsilon=1e-6;var offset;if(offsetGridLines){if(length===1){offset=Math.max(lineValue-start,end-lineValue);}else if(index===0){offset=(scale.getPixelForTick(1)-lineValue)/2;}else{offset=(lineValue-scale.getPixelForTick(validIndex-1))/2;}
lineValue+=validIndex<index?offset:-offset;if(lineValue<start-epsilon||lineValue>end+epsilon){return;}}
return lineValue;}
function garbageCollect(caches,length){helpers$1.each(caches,function(cache){var gc=cache.gc;var gcLen=gc.length/2;var i;if(gcLen>length){for(i=0;i<gcLen;++i){delete cache.data[gc[i]];}
gc.splice(0,gcLen);}});}
function computeLabelSizes(ctx,tickFonts,ticks,caches){var length=ticks.length;var widths=[];var heights=[];var offsets=[];var i,j,jlen,label,tickFont,fontString,cache,lineHeight,width,height,nestedLabel,widest,highest;for(i=0;i<length;++i){label=ticks[i].label;tickFont=ticks[i].major?tickFonts.major:tickFonts.minor;ctx.font=fontString=tickFont.string;cache=caches[fontString]=caches[fontString]||{data:{},gc:[]};lineHeight=tickFont.lineHeight;width=height=0;if(!isNullOrUndef(label)&&!isArray(label)){width=helpers$1.measureText(ctx,cache.data,cache.gc,width,label);height=lineHeight;}else if(isArray(label)){for(j=0,jlen=label.length;j<jlen;++j){nestedLabel=label[j];if(!isNullOrUndef(nestedLabel)&&!isArray(nestedLabel)){width=helpers$1.measureText(ctx,cache.data,cache.gc,width,nestedLabel);height+=lineHeight;}}}
widths.push(width);heights.push(height);offsets.push(lineHeight/2);}
garbageCollect(caches,length);widest=widths.indexOf(Math.max.apply(null,widths));highest=heights.indexOf(Math.max.apply(null,heights));function valueAt(idx){return{width:widths[idx]||0,height:heights[idx]||0,offset:offsets[idx]||0};}
return{first:valueAt(0),last:valueAt(length-1),widest:valueAt(widest),highest:valueAt(highest)};}
function getTickMarkLength(options){return options.drawTicks?options.tickMarkLength:0;}
function getScaleLabelHeight(options){var font,padding;if(!options.display){return 0;}
font=helpers$1.options._parseFont(options);padding=helpers$1.options.toPadding(options.padding);return font.lineHeight+padding.height;}
function parseFontOptions(options,nestedOpts){return helpers$1.extend(helpers$1.options._parseFont({fontFamily:valueOrDefault$a(nestedOpts.fontFamily,options.fontFamily),fontSize:valueOrDefault$a(nestedOpts.fontSize,options.fontSize),fontStyle:valueOrDefault$a(nestedOpts.fontStyle,options.fontStyle),lineHeight:valueOrDefault$a(nestedOpts.lineHeight,options.lineHeight)}),{color:helpers$1.options.resolve([nestedOpts.fontColor,options.fontColor,core_defaults.global.defaultFontColor])});}
function parseTickFontOptions(options){var minor=parseFontOptions(options,options.minor);var major=options.major.enabled?parseFontOptions(options,options.major):minor;return{minor:minor,major:major};}
function nonSkipped(ticksToFilter){var filtered=[];var item,index,len;for(index=0,len=ticksToFilter.length;index<len;++index){item=ticksToFilter[index];if(typeof item._index!=='undefined'){filtered.push(item);}}
return filtered;}
function getEvenSpacing(arr){var len=arr.length;var i,diff;if(len<2){return false;}
for(diff=arr[0],i=1;i<len;++i){if(arr[i]-arr[i-1]!==diff){return false;}}
return diff;}
function calculateSpacing(majorIndices,ticks,axisLength,ticksLimit){var evenMajorSpacing=getEvenSpacing(majorIndices);var spacing=(ticks.length-1)/ticksLimit;var factors,factor,i,ilen;if(!evenMajorSpacing){return Math.max(spacing,1);}
factors=helpers$1.math._factorize(evenMajorSpacing);for(i=0,ilen=factors.length-1;i<ilen;i++){factor=factors[i];if(factor>spacing){return factor;}}
return Math.max(spacing,1);}
function getMajorIndices(ticks){var result=[];var i,ilen;for(i=0,ilen=ticks.length;i<ilen;i++){if(ticks[i].major){result.push(i);}}
return result;}
function skipMajors(ticks,majorIndices,spacing){var count=0;var next=majorIndices[0];var i,tick;spacing=Math.ceil(spacing);for(i=0;i<ticks.length;i++){tick=ticks[i];if(i===next){tick._index=i;count++;next=majorIndices[count*spacing];}else{delete tick.label;}}}
function skip(ticks,spacing,majorStart,majorEnd){var start=valueOrDefault$a(majorStart,0);var end=Math.min(valueOrDefault$a(majorEnd,ticks.length),ticks.length);var count=0;var length,i,tick,next;spacing=Math.ceil(spacing);if(majorEnd){length=majorEnd-majorStart;spacing=length/Math.floor(length/spacing);}
next=start;while(next<0){count++;next=Math.round(start+count*spacing);}
for(i=Math.max(start,0);i<end;i++){tick=ticks[i];if(i===next){tick._index=i;count++;next=Math.round(start+count*spacing);}else{delete tick.label;}}}
var Scale=core_element.extend({zeroLineIndex:0,getPadding:function(){var me=this;return{left:me.paddingLeft||0,top:me.paddingTop||0,right:me.paddingRight||0,bottom:me.paddingBottom||0};},getTicks:function(){return this._ticks;},_getLabels:function(){var data=this.chart.data;return this.options.labels||(this.isHorizontal()?data.xLabels:data.yLabels)||data.labels||[];},mergeTicksOptions:function(){},beforeUpdate:function(){helpers$1.callback(this.options.beforeUpdate,[this]);},update:function(maxWidth,maxHeight,margins){var me=this;var tickOpts=me.options.ticks;var sampleSize=tickOpts.sampleSize;var i,ilen,labels,ticks,samplingEnabled;me.beforeUpdate();me.maxWidth=maxWidth;me.maxHeight=maxHeight;me.margins=helpers$1.extend({left:0,right:0,top:0,bottom:0},margins);me._ticks=null;me.ticks=null;me._labelSizes=null;me._maxLabelLines=0;me.longestLabelWidth=0;me.longestTextCache=me.longestTextCache||{};me._gridLineItems=null;me._labelItems=null;me.beforeSetDimensions();me.setDimensions();me.afterSetDimensions();me.beforeDataLimits();me.determineDataLimits();me.afterDataLimits();me.beforeBuildTicks();ticks=me.buildTicks()||[];ticks=me.afterBuildTicks(ticks)||ticks;if((!ticks||!ticks.length)&&me.ticks){ticks=[];for(i=0,ilen=me.ticks.length;i<ilen;++i){ticks.push({value:me.ticks[i],major:false});}}
me._ticks=ticks;samplingEnabled=sampleSize<ticks.length;labels=me._convertTicksToLabels(samplingEnabled?sample(ticks,sampleSize):ticks);me._configure();me.beforeCalculateTickRotation();me.calculateTickRotation();me.afterCalculateTickRotation();me.beforeFit();me.fit();me.afterFit();me._ticksToDraw=tickOpts.display&&(tickOpts.autoSkip||tickOpts.source==='auto')?me._autoSkip(ticks):ticks;if(samplingEnabled){labels=me._convertTicksToLabels(me._ticksToDraw);}
me.ticks=labels;me.afterUpdate();return me.minSize;},_configure:function(){var me=this;var reversePixels=me.options.ticks.reverse;var startPixel,endPixel;if(me.isHorizontal()){startPixel=me.left;endPixel=me.right;}else{startPixel=me.top;endPixel=me.bottom;reversePixels=!reversePixels;}
me._startPixel=startPixel;me._endPixel=endPixel;me._reversePixels=reversePixels;me._length=endPixel-startPixel;},afterUpdate:function(){helpers$1.callback(this.options.afterUpdate,[this]);},beforeSetDimensions:function(){helpers$1.callback(this.options.beforeSetDimensions,[this]);},setDimensions:function(){var me=this;if(me.isHorizontal()){me.width=me.maxWidth;me.left=0;me.right=me.width;}else{me.height=me.maxHeight;me.top=0;me.bottom=me.height;}
me.paddingLeft=0;me.paddingTop=0;me.paddingRight=0;me.paddingBottom=0;},afterSetDimensions:function(){helpers$1.callback(this.options.afterSetDimensions,[this]);},beforeDataLimits:function(){helpers$1.callback(this.options.beforeDataLimits,[this]);},determineDataLimits:helpers$1.noop,afterDataLimits:function(){helpers$1.callback(this.options.afterDataLimits,[this]);},beforeBuildTicks:function(){helpers$1.callback(this.options.beforeBuildTicks,[this]);},buildTicks:helpers$1.noop,afterBuildTicks:function(ticks){var me=this;if(isArray(ticks)&&ticks.length){return helpers$1.callback(me.options.afterBuildTicks,[me,ticks]);}
me.ticks=helpers$1.callback(me.options.afterBuildTicks,[me,me.ticks])||me.ticks;return ticks;},beforeTickToLabelConversion:function(){helpers$1.callback(this.options.beforeTickToLabelConversion,[this]);},convertTicksToLabels:function(){var me=this;var tickOpts=me.options.ticks;me.ticks=me.ticks.map(tickOpts.userCallback||tickOpts.callback,this);},afterTickToLabelConversion:function(){helpers$1.callback(this.options.afterTickToLabelConversion,[this]);},beforeCalculateTickRotation:function(){helpers$1.callback(this.options.beforeCalculateTickRotation,[this]);},calculateTickRotation:function(){var me=this;var options=me.options;var tickOpts=options.ticks;var numTicks=me.getTicks().length;var minRotation=tickOpts.minRotation||0;var maxRotation=tickOpts.maxRotation;var labelRotation=minRotation;var labelSizes,maxLabelWidth,maxLabelHeight,maxWidth,tickWidth,maxHeight,maxLabelDiagonal;if(!me._isVisible()||!tickOpts.display||minRotation>=maxRotation||numTicks<=1||!me.isHorizontal()){me.labelRotation=minRotation;return;}
labelSizes=me._getLabelSizes();maxLabelWidth=labelSizes.widest.width;maxLabelHeight=labelSizes.highest.height-labelSizes.highest.offset;maxWidth=Math.min(me.maxWidth,me.chart.width-maxLabelWidth);tickWidth=options.offset?me.maxWidth/numTicks:maxWidth/(numTicks-1);if(maxLabelWidth+6>tickWidth){tickWidth=maxWidth/(numTicks-(options.offset?0.5:1));maxHeight=me.maxHeight-getTickMarkLength(options.gridLines)
-tickOpts.padding-getScaleLabelHeight(options.scaleLabel);maxLabelDiagonal=Math.sqrt(maxLabelWidth*maxLabelWidth+maxLabelHeight*maxLabelHeight);labelRotation=helpers$1.toDegrees(Math.min(Math.asin(Math.min((labelSizes.highest.height+6)/tickWidth,1)),Math.asin(Math.min(maxHeight/maxLabelDiagonal,1))-Math.asin(maxLabelHeight/maxLabelDiagonal)));labelRotation=Math.max(minRotation,Math.min(maxRotation,labelRotation));}
me.labelRotation=labelRotation;},afterCalculateTickRotation:function(){helpers$1.callback(this.options.afterCalculateTickRotation,[this]);},beforeFit:function(){helpers$1.callback(this.options.beforeFit,[this]);},fit:function(){var me=this;var minSize=me.minSize={width:0,height:0};var chart=me.chart;var opts=me.options;var tickOpts=opts.ticks;var scaleLabelOpts=opts.scaleLabel;var gridLineOpts=opts.gridLines;var display=me._isVisible();var isBottom=opts.position==='bottom';var isHorizontal=me.isHorizontal();if(isHorizontal){minSize.width=me.maxWidth;}else if(display){minSize.width=getTickMarkLength(gridLineOpts)+getScaleLabelHeight(scaleLabelOpts);}
if(!isHorizontal){minSize.height=me.maxHeight;}else if(display){minSize.height=getTickMarkLength(gridLineOpts)+getScaleLabelHeight(scaleLabelOpts);}
if(tickOpts.display&&display){var tickFonts=parseTickFontOptions(tickOpts);var labelSizes=me._getLabelSizes();var firstLabelSize=labelSizes.first;var lastLabelSize=labelSizes.last;var widestLabelSize=labelSizes.widest;var highestLabelSize=labelSizes.highest;var lineSpace=tickFonts.minor.lineHeight*0.4;var tickPadding=tickOpts.padding;if(isHorizontal){var isRotated=me.labelRotation!==0;var angleRadians=helpers$1.toRadians(me.labelRotation);var cosRotation=Math.cos(angleRadians);var sinRotation=Math.sin(angleRadians);var labelHeight=sinRotation*widestLabelSize.width
+cosRotation*(highestLabelSize.height-(isRotated?highestLabelSize.offset:0))
+(isRotated?0:lineSpace);minSize.height=Math.min(me.maxHeight,minSize.height+labelHeight+tickPadding);var offsetLeft=me.getPixelForTick(0)-me.left;var offsetRight=me.right-me.getPixelForTick(me.getTicks().length-1);var paddingLeft,paddingRight;if(isRotated){paddingLeft=isBottom?cosRotation*firstLabelSize.width+sinRotation*firstLabelSize.offset:sinRotation*(firstLabelSize.height-firstLabelSize.offset);paddingRight=isBottom?sinRotation*(lastLabelSize.height-lastLabelSize.offset):cosRotation*lastLabelSize.width+sinRotation*lastLabelSize.offset;}else{paddingLeft=firstLabelSize.width/2;paddingRight=lastLabelSize.width/2;}
me.paddingLeft=Math.max((paddingLeft-offsetLeft)*me.width/(me.width-offsetLeft),0)+3;me.paddingRight=Math.max((paddingRight-offsetRight)*me.width/(me.width-offsetRight),0)+3;}else{var labelWidth=tickOpts.mirror?0:widestLabelSize.width+tickPadding+lineSpace;minSize.width=Math.min(me.maxWidth,minSize.width+labelWidth);me.paddingTop=firstLabelSize.height/2;me.paddingBottom=lastLabelSize.height/2;}}
me.handleMargins();if(isHorizontal){me.width=me._length=chart.width-me.margins.left-me.margins.right;me.height=minSize.height;}else{me.width=minSize.width;me.height=me._length=chart.height-me.margins.top-me.margins.bottom;}},handleMargins:function(){var me=this;if(me.margins){me.margins.left=Math.max(me.paddingLeft,me.margins.left);me.margins.top=Math.max(me.paddingTop,me.margins.top);me.margins.right=Math.max(me.paddingRight,me.margins.right);me.margins.bottom=Math.max(me.paddingBottom,me.margins.bottom);}},afterFit:function(){helpers$1.callback(this.options.afterFit,[this]);},isHorizontal:function(){var pos=this.options.position;return pos==='top'||pos==='bottom';},isFullWidth:function(){return this.options.fullWidth;},getRightValue:function(rawValue){if(isNullOrUndef(rawValue)){return NaN;}
if((typeof rawValue==='number'||rawValue instanceof Number)&&!isFinite(rawValue)){return NaN;}
if(rawValue){if(this.isHorizontal()){if(rawValue.x!==undefined){return this.getRightValue(rawValue.x);}}else if(rawValue.y!==undefined){return this.getRightValue(rawValue.y);}}
return rawValue;},_convertTicksToLabels:function(ticks){var me=this;var labels,i,ilen;me.ticks=ticks.map(function(tick){return tick.value;});me.beforeTickToLabelConversion();labels=me.convertTicksToLabels(ticks)||me.ticks;me.afterTickToLabelConversion();for(i=0,ilen=ticks.length;i<ilen;++i){ticks[i].label=labels[i];}
return labels;},_getLabelSizes:function(){var me=this;var labelSizes=me._labelSizes;if(!labelSizes){me._labelSizes=labelSizes=computeLabelSizes(me.ctx,parseTickFontOptions(me.options.ticks),me.getTicks(),me.longestTextCache);me.longestLabelWidth=labelSizes.widest.width;}
return labelSizes;},_parseValue:function(value){var start,end,min,max;if(isArray(value)){start=+this.getRightValue(value[0]);end=+this.getRightValue(value[1]);min=Math.min(start,end);max=Math.max(start,end);}else{value=+this.getRightValue(value);start=undefined;end=value;min=value;max=value;}
return{min:min,max:max,start:start,end:end};},_getScaleLabel:function(rawValue){var v=this._parseValue(rawValue);if(v.start!==undefined){return'['+v.start+', '+v.end+']';}
return+this.getRightValue(rawValue);},getLabelForIndex:helpers$1.noop,getPixelForValue:helpers$1.noop,getValueForPixel:helpers$1.noop,getPixelForTick:function(index){var me=this;var offset=me.options.offset;var numTicks=me._ticks.length;var tickWidth=1/Math.max(numTicks-(offset?0:1),1);return index<0||index>numTicks-1?null:me.getPixelForDecimal(index*tickWidth+(offset?tickWidth/2:0));},getPixelForDecimal:function(decimal){var me=this;if(me._reversePixels){decimal=1-decimal;}
return me._startPixel+decimal*me._length;},getDecimalForPixel:function(pixel){var decimal=(pixel-this._startPixel)/this._length;return this._reversePixels?1-decimal:decimal;},getBasePixel:function(){return this.getPixelForValue(this.getBaseValue());},getBaseValue:function(){var me=this;var min=me.min;var max=me.max;return me.beginAtZero?0:min<0&&max<0?max:min>0&&max>0?min:0;},_autoSkip:function(ticks){var me=this;var tickOpts=me.options.ticks;var axisLength=me._length;var ticksLimit=tickOpts.maxTicksLimit||axisLength/me._tickSize()+1;var majorIndices=tickOpts.major.enabled?getMajorIndices(ticks):[];var numMajorIndices=majorIndices.length;var first=majorIndices[0];var last=majorIndices[numMajorIndices-1];var i,ilen,spacing,avgMajorSpacing;if(numMajorIndices>ticksLimit){skipMajors(ticks,majorIndices,numMajorIndices/ticksLimit);return nonSkipped(ticks);}
spacing=calculateSpacing(majorIndices,ticks,axisLength,ticksLimit);if(numMajorIndices>0){for(i=0,ilen=numMajorIndices-1;i<ilen;i++){skip(ticks,spacing,majorIndices[i],majorIndices[i+1]);}
avgMajorSpacing=numMajorIndices>1?(last-first)/(numMajorIndices-1):null;skip(ticks,spacing,helpers$1.isNullOrUndef(avgMajorSpacing)?0:first-avgMajorSpacing,first);skip(ticks,spacing,last,helpers$1.isNullOrUndef(avgMajorSpacing)?ticks.length:last+avgMajorSpacing);return nonSkipped(ticks);}
skip(ticks,spacing);return nonSkipped(ticks);},_tickSize:function(){var me=this;var optionTicks=me.options.ticks;var rot=helpers$1.toRadians(me.labelRotation);var cos=Math.abs(Math.cos(rot));var sin=Math.abs(Math.sin(rot));var labelSizes=me._getLabelSizes();var padding=optionTicks.autoSkipPadding||0;var w=labelSizes?labelSizes.widest.width+padding:0;var h=labelSizes?labelSizes.highest.height+padding:0;return me.isHorizontal()?h*cos>w*sin?w/cos:h/sin:h*sin<w*cos?h/cos:w/sin;},_isVisible:function(){var me=this;var chart=me.chart;var display=me.options.display;var i,ilen,meta;if(display!=='auto'){return!!display;}
for(i=0,ilen=chart.data.datasets.length;i<ilen;++i){if(chart.isDatasetVisible(i)){meta=chart.getDatasetMeta(i);if(meta.xAxisID===me.id||meta.yAxisID===me.id){return true;}}}
return false;},_computeGridLineItems:function(chartArea){var me=this;var chart=me.chart;var options=me.options;var gridLines=options.gridLines;var position=options.position;var offsetGridLines=gridLines.offsetGridLines;var isHorizontal=me.isHorizontal();var ticks=me._ticksToDraw;var ticksLength=ticks.length+(offsetGridLines?1:0);var tl=getTickMarkLength(gridLines);var items=[];var axisWidth=gridLines.drawBorder?valueAtIndexOrDefault(gridLines.lineWidth,0,0):0;var axisHalfWidth=axisWidth/2;var alignPixel=helpers$1._alignPixel;var alignBorderValue=function(pixel){return alignPixel(chart,pixel,axisWidth);};var borderValue,i,tick,lineValue,alignedLineValue;var tx1,ty1,tx2,ty2,x1,y1,x2,y2,lineWidth,lineColor,borderDash,borderDashOffset;if(position==='top'){borderValue=alignBorderValue(me.bottom);ty1=me.bottom-tl;ty2=borderValue-axisHalfWidth;y1=alignBorderValue(chartArea.top)+axisHalfWidth;y2=chartArea.bottom;}else if(position==='bottom'){borderValue=alignBorderValue(me.top);y1=chartArea.top;y2=alignBorderValue(chartArea.bottom)-axisHalfWidth;ty1=borderValue+axisHalfWidth;ty2=me.top+tl;}else if(position==='left'){borderValue=alignBorderValue(me.right);tx1=me.right-tl;tx2=borderValue-axisHalfWidth;x1=alignBorderValue(chartArea.left)+axisHalfWidth;x2=chartArea.right;}else{borderValue=alignBorderValue(me.left);x1=chartArea.left;x2=alignBorderValue(chartArea.right)-axisHalfWidth;tx1=borderValue+axisHalfWidth;tx2=me.left+tl;}
for(i=0;i<ticksLength;++i){tick=ticks[i]||{};if(isNullOrUndef(tick.label)&&i<ticks.length){continue;}
if(i===me.zeroLineIndex&&options.offset===offsetGridLines){lineWidth=gridLines.zeroLineWidth;lineColor=gridLines.zeroLineColor;borderDash=gridLines.zeroLineBorderDash||[];borderDashOffset=gridLines.zeroLineBorderDashOffset||0.0;}else{lineWidth=valueAtIndexOrDefault(gridLines.lineWidth,i,1);lineColor=valueAtIndexOrDefault(gridLines.color,i,'rgba(0,0,0,0.1)');borderDash=gridLines.borderDash||[];borderDashOffset=gridLines.borderDashOffset||0.0;}
lineValue=getPixelForGridLine(me,tick._index||i,offsetGridLines);if(lineValue===undefined){continue;}
alignedLineValue=alignPixel(chart,lineValue,lineWidth);if(isHorizontal){tx1=tx2=x1=x2=alignedLineValue;}else{ty1=ty2=y1=y2=alignedLineValue;}
items.push({tx1:tx1,ty1:ty1,tx2:tx2,ty2:ty2,x1:x1,y1:y1,x2:x2,y2:y2,width:lineWidth,color:lineColor,borderDash:borderDash,borderDashOffset:borderDashOffset,});}
items.ticksLength=ticksLength;items.borderValue=borderValue;return items;},_computeLabelItems:function(){var me=this;var options=me.options;var optionTicks=options.ticks;var position=options.position;var isMirrored=optionTicks.mirror;var isHorizontal=me.isHorizontal();var ticks=me._ticksToDraw;var fonts=parseTickFontOptions(optionTicks);var tickPadding=optionTicks.padding;var tl=getTickMarkLength(options.gridLines);var rotation=-helpers$1.toRadians(me.labelRotation);var items=[];var i,ilen,tick,label,x,y,textAlign,pixel,font,lineHeight,lineCount,textOffset;if(position==='top'){y=me.bottom-tl-tickPadding;textAlign=!rotation?'center':'left';}else if(position==='bottom'){y=me.top+tl+tickPadding;textAlign=!rotation?'center':'right';}else if(position==='left'){x=me.right-(isMirrored?0:tl)-tickPadding;textAlign=isMirrored?'left':'right';}else{x=me.left+(isMirrored?0:tl)+tickPadding;textAlign=isMirrored?'right':'left';}
for(i=0,ilen=ticks.length;i<ilen;++i){tick=ticks[i];label=tick.label;if(isNullOrUndef(label)){continue;}
pixel=me.getPixelForTick(tick._index||i)+optionTicks.labelOffset;font=tick.major?fonts.major:fonts.minor;lineHeight=font.lineHeight;lineCount=isArray(label)?label.length:1;if(isHorizontal){x=pixel;textOffset=position==='top'?((!rotation?0.5:1)-lineCount)*lineHeight:(!rotation?0.5:0)*lineHeight;}else{y=pixel;textOffset=(1-lineCount)*lineHeight/2;}
items.push({x:x,y:y,rotation:rotation,label:label,font:font,textOffset:textOffset,textAlign:textAlign});}
return items;},_drawGrid:function(chartArea){var me=this;var gridLines=me.options.gridLines;if(!gridLines.display){return;}
var ctx=me.ctx;var chart=me.chart;var alignPixel=helpers$1._alignPixel;var axisWidth=gridLines.drawBorder?valueAtIndexOrDefault(gridLines.lineWidth,0,0):0;var items=me._gridLineItems||(me._gridLineItems=me._computeGridLineItems(chartArea));var width,color,i,ilen,item;for(i=0,ilen=items.length;i<ilen;++i){item=items[i];width=item.width;color=item.color;if(width&&color){ctx.save();ctx.lineWidth=width;ctx.strokeStyle=color;if(ctx.setLineDash){ctx.setLineDash(item.borderDash);ctx.lineDashOffset=item.borderDashOffset;}
ctx.beginPath();if(gridLines.drawTicks){ctx.moveTo(item.tx1,item.ty1);ctx.lineTo(item.tx2,item.ty2);}
if(gridLines.drawOnChartArea){ctx.moveTo(item.x1,item.y1);ctx.lineTo(item.x2,item.y2);}
ctx.stroke();ctx.restore();}}
if(axisWidth){var firstLineWidth=axisWidth;var lastLineWidth=valueAtIndexOrDefault(gridLines.lineWidth,items.ticksLength-1,1);var borderValue=items.borderValue;var x1,x2,y1,y2;if(me.isHorizontal()){x1=alignPixel(chart,me.left,firstLineWidth)-firstLineWidth/2;x2=alignPixel(chart,me.right,lastLineWidth)+lastLineWidth/2;y1=y2=borderValue;}else{y1=alignPixel(chart,me.top,firstLineWidth)-firstLineWidth/2;y2=alignPixel(chart,me.bottom,lastLineWidth)+lastLineWidth/2;x1=x2=borderValue;}
ctx.lineWidth=axisWidth;ctx.strokeStyle=valueAtIndexOrDefault(gridLines.color,0);ctx.beginPath();ctx.moveTo(x1,y1);ctx.lineTo(x2,y2);ctx.stroke();}},_drawLabels:function(){var me=this;var optionTicks=me.options.ticks;if(!optionTicks.display){return;}
var ctx=me.ctx;var items=me._labelItems||(me._labelItems=me._computeLabelItems());var i,j,ilen,jlen,item,tickFont,label,y;for(i=0,ilen=items.length;i<ilen;++i){item=items[i];tickFont=item.font;ctx.save();ctx.translate(item.x,item.y);ctx.rotate(item.rotation);ctx.font=tickFont.string;ctx.fillStyle=tickFont.color;ctx.textBaseline='middle';ctx.textAlign=item.textAlign;label=item.label;y=item.textOffset;if(isArray(label)){for(j=0,jlen=label.length;j<jlen;++j){ctx.fillText(''+label[j],0,y);y+=tickFont.lineHeight;}}else{ctx.fillText(label,0,y);}
ctx.restore();}},_drawTitle:function(){var me=this;var ctx=me.ctx;var options=me.options;var scaleLabel=options.scaleLabel;if(!scaleLabel.display){return;}
var scaleLabelFontColor=valueOrDefault$a(scaleLabel.fontColor,core_defaults.global.defaultFontColor);var scaleLabelFont=helpers$1.options._parseFont(scaleLabel);var scaleLabelPadding=helpers$1.options.toPadding(scaleLabel.padding);var halfLineHeight=scaleLabelFont.lineHeight/2;var position=options.position;var rotation=0;var scaleLabelX,scaleLabelY;if(me.isHorizontal()){scaleLabelX=me.left+me.width/2;scaleLabelY=position==='bottom'?me.bottom-halfLineHeight-scaleLabelPadding.bottom:me.top+halfLineHeight+scaleLabelPadding.top;}else{var isLeft=position==='left';scaleLabelX=isLeft?me.left+halfLineHeight+scaleLabelPadding.top:me.right-halfLineHeight-scaleLabelPadding.top;scaleLabelY=me.top+me.height/2;rotation=isLeft?-0.5*Math.PI:0.5*Math.PI;}
ctx.save();ctx.translate(scaleLabelX,scaleLabelY);ctx.rotate(rotation);ctx.textAlign='center';ctx.textBaseline='middle';ctx.fillStyle=scaleLabelFontColor;ctx.font=scaleLabelFont.string;ctx.fillText(scaleLabel.labelString,0,0);ctx.restore();},draw:function(chartArea){var me=this;if(!me._isVisible()){return;}
me._drawGrid(chartArea);me._drawTitle();me._drawLabels();},_layers:function(){var me=this;var opts=me.options;var tz=opts.ticks&&opts.ticks.z||0;var gz=opts.gridLines&&opts.gridLines.z||0;if(!me._isVisible()||tz===gz||me.draw!==me._draw){return[{z:tz,draw:function(){me.draw.apply(me,arguments);}}];}
return[{z:gz,draw:function(){me._drawGrid.apply(me,arguments);me._drawTitle.apply(me,arguments);}},{z:tz,draw:function(){me._drawLabels.apply(me,arguments);}}];},_getMatchingVisibleMetas:function(type){var me=this;var isHorizontal=me.isHorizontal();return me.chart._getSortedVisibleDatasetMetas().filter(function(meta){return(!type||meta.type===type)&&(isHorizontal?meta.xAxisID===me.id:meta.yAxisID===me.id);});}});Scale.prototype._draw=Scale.prototype.draw;var core_scale=Scale;var isNullOrUndef$1=helpers$1.isNullOrUndef;var defaultConfig={position:'bottom'};var scale_category=core_scale.extend({determineDataLimits:function(){var me=this;var labels=me._getLabels();var ticksOpts=me.options.ticks;var min=ticksOpts.min;var max=ticksOpts.max;var minIndex=0;var maxIndex=labels.length-1;var findIndex;if(min!==undefined){findIndex=labels.indexOf(min);if(findIndex>=0){minIndex=findIndex;}}
if(max!==undefined){findIndex=labels.indexOf(max);if(findIndex>=0){maxIndex=findIndex;}}
me.minIndex=minIndex;me.maxIndex=maxIndex;me.min=labels[minIndex];me.max=labels[maxIndex];},buildTicks:function(){var me=this;var labels=me._getLabels();var minIndex=me.minIndex;var maxIndex=me.maxIndex;me.ticks=(minIndex===0&&maxIndex===labels.length-1)?labels:labels.slice(minIndex,maxIndex+1);},getLabelForIndex:function(index,datasetIndex){var me=this;var chart=me.chart;if(chart.getDatasetMeta(datasetIndex).controller._getValueScaleId()===me.id){return me.getRightValue(chart.data.datasets[datasetIndex].data[index]);}
return me._getLabels()[index];},_configure:function(){var me=this;var offset=me.options.offset;var ticks=me.ticks;core_scale.prototype._configure.call(me);if(!me.isHorizontal()){me._reversePixels=!me._reversePixels;}
if(!ticks){return;}
me._startValue=me.minIndex-(offset?0.5:0);me._valueRange=Math.max(ticks.length-(offset?0:1),1);},getPixelForValue:function(value,index,datasetIndex){var me=this;var valueCategory,labels,idx;if(!isNullOrUndef$1(index)&&!isNullOrUndef$1(datasetIndex)){value=me.chart.data.datasets[datasetIndex].data[index];}
if(!isNullOrUndef$1(value)){valueCategory=me.isHorizontal()?value.x:value.y;}
if(valueCategory!==undefined||(value!==undefined&&isNaN(index))){labels=me._getLabels();value=helpers$1.valueOrDefault(valueCategory,value);idx=labels.indexOf(value);index=idx!==-1?idx:index;if(isNaN(index)){index=value;}}
return me.getPixelForDecimal((index-me._startValue)/me._valueRange);},getPixelForTick:function(index){var ticks=this.ticks;return index<0||index>ticks.length-1?null:this.getPixelForValue(ticks[index],index+this.minIndex);},getValueForPixel:function(pixel){var me=this;var value=Math.round(me._startValue+me.getDecimalForPixel(pixel)*me._valueRange);return Math.min(Math.max(value,0),me.ticks.length-1);},getBasePixel:function(){return this.bottom;}});var _defaults=defaultConfig;scale_category._defaults=_defaults;var noop=helpers$1.noop;var isNullOrUndef$2=helpers$1.isNullOrUndef;function generateTicks(generationOptions,dataRange){var ticks=[];var MIN_SPACING=1e-14;var stepSize=generationOptions.stepSize;var unit=stepSize||1;var maxNumSpaces=generationOptions.maxTicks-1;var min=generationOptions.min;var max=generationOptions.max;var precision=generationOptions.precision;var rmin=dataRange.min;var rmax=dataRange.max;var spacing=helpers$1.niceNum((rmax-rmin)/maxNumSpaces/unit)*unit;var factor,niceMin,niceMax,numSpaces;if(spacing<MIN_SPACING&&isNullOrUndef$2(min)&&isNullOrUndef$2(max)){return[rmin,rmax];}
numSpaces=Math.ceil(rmax/spacing)-Math.floor(rmin/spacing);if(numSpaces>maxNumSpaces){spacing=helpers$1.niceNum(numSpaces*spacing/maxNumSpaces/unit)*unit;}
if(stepSize||isNullOrUndef$2(precision)){factor=Math.pow(10,helpers$1._decimalPlaces(spacing));}else{factor=Math.pow(10,precision);spacing=Math.ceil(spacing*factor)/factor;}
niceMin=Math.floor(rmin/spacing)*spacing;niceMax=Math.ceil(rmax/spacing)*spacing;if(stepSize){if(!isNullOrUndef$2(min)&&helpers$1.almostWhole(min/spacing,spacing/1000)){niceMin=min;}
if(!isNullOrUndef$2(max)&&helpers$1.almostWhole(max/spacing,spacing/1000)){niceMax=max;}}
numSpaces=(niceMax-niceMin)/spacing;if(helpers$1.almostEquals(numSpaces,Math.round(numSpaces),spacing/1000)){numSpaces=Math.round(numSpaces);}else{numSpaces=Math.ceil(numSpaces);}
niceMin=Math.round(niceMin*factor)/factor;niceMax=Math.round(niceMax*factor)/factor;ticks.push(isNullOrUndef$2(min)?niceMin:min);for(var j=1;j<numSpaces;++j){ticks.push(Math.round((niceMin+j*spacing)*factor)/factor);}
ticks.push(isNullOrUndef$2(max)?niceMax:max);return ticks;}
var scale_linearbase=core_scale.extend({getRightValue:function(value){if(typeof value==='string'){return+value;}
return core_scale.prototype.getRightValue.call(this,value);},handleTickRangeOptions:function(){var me=this;var opts=me.options;var tickOpts=opts.ticks;if(tickOpts.beginAtZero){var minSign=helpers$1.sign(me.min);var maxSign=helpers$1.sign(me.max);if(minSign<0&&maxSign<0){me.max=0;}else if(minSign>0&&maxSign>0){me.min=0;}}
var setMin=tickOpts.min!==undefined||tickOpts.suggestedMin!==undefined;var setMax=tickOpts.max!==undefined||tickOpts.suggestedMax!==undefined;if(tickOpts.min!==undefined){me.min=tickOpts.min;}else if(tickOpts.suggestedMin!==undefined){if(me.min===null){me.min=tickOpts.suggestedMin;}else{me.min=Math.min(me.min,tickOpts.suggestedMin);}}
if(tickOpts.max!==undefined){me.max=tickOpts.max;}else if(tickOpts.suggestedMax!==undefined){if(me.max===null){me.max=tickOpts.suggestedMax;}else{me.max=Math.max(me.max,tickOpts.suggestedMax);}}
if(setMin!==setMax){if(me.min>=me.max){if(setMin){me.max=me.min+1;}else{me.min=me.max-1;}}}
if(me.min===me.max){me.max++;if(!tickOpts.beginAtZero){me.min--;}}},getTickLimit:function(){var me=this;var tickOpts=me.options.ticks;var stepSize=tickOpts.stepSize;var maxTicksLimit=tickOpts.maxTicksLimit;var maxTicks;if(stepSize){maxTicks=Math.ceil(me.max/stepSize)-Math.floor(me.min/stepSize)+1;}else{maxTicks=me._computeTickLimit();maxTicksLimit=maxTicksLimit||11;}
if(maxTicksLimit){maxTicks=Math.min(maxTicksLimit,maxTicks);}
return maxTicks;},_computeTickLimit:function(){return Number.POSITIVE_INFINITY;},handleDirectionalChanges:noop,buildTicks:function(){var me=this;var opts=me.options;var tickOpts=opts.ticks;var maxTicks=me.getTickLimit();maxTicks=Math.max(2,maxTicks);var numericGeneratorOptions={maxTicks:maxTicks,min:tickOpts.min,max:tickOpts.max,precision:tickOpts.precision,stepSize:helpers$1.valueOrDefault(tickOpts.fixedStepSize,tickOpts.stepSize)};var ticks=me.ticks=generateTicks(numericGeneratorOptions,me);me.handleDirectionalChanges();me.max=helpers$1.max(ticks);me.min=helpers$1.min(ticks);if(tickOpts.reverse){ticks.reverse();me.start=me.max;me.end=me.min;}else{me.start=me.min;me.end=me.max;}},convertTicksToLabels:function(){var me=this;me.ticksAsNumbers=me.ticks.slice();me.zeroLineIndex=me.ticks.indexOf(0);core_scale.prototype.convertTicksToLabels.call(me);},_configure:function(){var me=this;var ticks=me.getTicks();var start=me.min;var end=me.max;var offset;core_scale.prototype._configure.call(me);if(me.options.offset&&ticks.length){offset=(end-start)/Math.max(ticks.length-1,1)/2;start-=offset;end+=offset;}
me._startValue=start;me._endValue=end;me._valueRange=end-start;}});var defaultConfig$1={position:'left',ticks:{callback:core_ticks.formatters.linear}};var DEFAULT_MIN=0;var DEFAULT_MAX=1;function getOrCreateStack(stacks,stacked,meta){var key=[meta.type,stacked===undefined&&meta.stack===undefined?meta.index:'',meta.stack].join('.');if(stacks[key]===undefined){stacks[key]={pos:[],neg:[]};}
return stacks[key];}
function stackData(scale,stacks,meta,data){var opts=scale.options;var stacked=opts.stacked;var stack=getOrCreateStack(stacks,stacked,meta);var pos=stack.pos;var neg=stack.neg;var ilen=data.length;var i,value;for(i=0;i<ilen;++i){value=scale._parseValue(data[i]);if(isNaN(value.min)||isNaN(value.max)||meta.data[i].hidden){continue;}
pos[i]=pos[i]||0;neg[i]=neg[i]||0;if(opts.relativePoints){pos[i]=100;}else if(value.min<0||value.max<0){neg[i]+=value.min;}else{pos[i]+=value.max;}}}
function updateMinMax(scale,meta,data){var ilen=data.length;var i,value;for(i=0;i<ilen;++i){value=scale._parseValue(data[i]);if(isNaN(value.min)||isNaN(value.max)||meta.data[i].hidden){continue;}
scale.min=Math.min(scale.min,value.min);scale.max=Math.max(scale.max,value.max);}}
var scale_linear=scale_linearbase.extend({determineDataLimits:function(){var me=this;var opts=me.options;var chart=me.chart;var datasets=chart.data.datasets;var metasets=me._getMatchingVisibleMetas();var hasStacks=opts.stacked;var stacks={};var ilen=metasets.length;var i,meta,data,values;me.min=Number.POSITIVE_INFINITY;me.max=Number.NEGATIVE_INFINITY;if(hasStacks===undefined){for(i=0;!hasStacks&&i<ilen;++i){meta=metasets[i];hasStacks=meta.stack!==undefined;}}
for(i=0;i<ilen;++i){meta=metasets[i];data=datasets[meta.index].data;if(hasStacks){stackData(me,stacks,meta,data);}else{updateMinMax(me,meta,data);}}
helpers$1.each(stacks,function(stackValues){values=stackValues.pos.concat(stackValues.neg);me.min=Math.min(me.min,helpers$1.min(values));me.max=Math.max(me.max,helpers$1.max(values));});me.min=helpers$1.isFinite(me.min)&&!isNaN(me.min)?me.min:DEFAULT_MIN;me.max=helpers$1.isFinite(me.max)&&!isNaN(me.max)?me.max:DEFAULT_MAX;me.handleTickRangeOptions();},_computeTickLimit:function(){var me=this;var tickFont;if(me.isHorizontal()){return Math.ceil(me.width/40);}
tickFont=helpers$1.options._parseFont(me.options.ticks);return Math.ceil(me.height/tickFont.lineHeight);},handleDirectionalChanges:function(){if(!this.isHorizontal()){this.ticks.reverse();}},getLabelForIndex:function(index,datasetIndex){return this._getScaleLabel(this.chart.data.datasets[datasetIndex].data[index]);},getPixelForValue:function(value){var me=this;return me.getPixelForDecimal((+me.getRightValue(value)-me._startValue)/me._valueRange);},getValueForPixel:function(pixel){return this._startValue+this.getDecimalForPixel(pixel)*this._valueRange;},getPixelForTick:function(index){var ticks=this.ticksAsNumbers;if(index<0||index>ticks.length-1){return null;}
return this.getPixelForValue(ticks[index]);}});var _defaults$1=defaultConfig$1;scale_linear._defaults=_defaults$1;var valueOrDefault$b=helpers$1.valueOrDefault;var log10=helpers$1.math.log10;function generateTicks$1(generationOptions,dataRange){var ticks=[];var tickVal=valueOrDefault$b(generationOptions.min,Math.pow(10,Math.floor(log10(dataRange.min))));var endExp=Math.floor(log10(dataRange.max));var endSignificand=Math.ceil(dataRange.max/Math.pow(10,endExp));var exp,significand;if(tickVal===0){exp=Math.floor(log10(dataRange.minNotZero));significand=Math.floor(dataRange.minNotZero/Math.pow(10,exp));ticks.push(tickVal);tickVal=significand*Math.pow(10,exp);}else{exp=Math.floor(log10(tickVal));significand=Math.floor(tickVal/Math.pow(10,exp));}
var precision=exp<0?Math.pow(10,Math.abs(exp)):1;do{ticks.push(tickVal);++significand;if(significand===10){significand=1;++exp;precision=exp>=0?1:precision;}
tickVal=Math.round(significand*Math.pow(10,exp)*precision)/precision;}while(exp<endExp||(exp===endExp&&significand<endSignificand));var lastTick=valueOrDefault$b(generationOptions.max,tickVal);ticks.push(lastTick);return ticks;}
var defaultConfig$2={position:'left',ticks:{callback:core_ticks.formatters.logarithmic}};function nonNegativeOrDefault(value,defaultValue){return helpers$1.isFinite(value)&&value>=0?value:defaultValue;}
var scale_logarithmic=core_scale.extend({determineDataLimits:function(){var me=this;var opts=me.options;var chart=me.chart;var datasets=chart.data.datasets;var isHorizontal=me.isHorizontal();function IDMatches(meta){return isHorizontal?meta.xAxisID===me.id:meta.yAxisID===me.id;}
var datasetIndex,meta,value,data,i,ilen;me.min=Number.POSITIVE_INFINITY;me.max=Number.NEGATIVE_INFINITY;me.minNotZero=Number.POSITIVE_INFINITY;var hasStacks=opts.stacked;if(hasStacks===undefined){for(datasetIndex=0;datasetIndex<datasets.length;datasetIndex++){meta=chart.getDatasetMeta(datasetIndex);if(chart.isDatasetVisible(datasetIndex)&&IDMatches(meta)&&meta.stack!==undefined){hasStacks=true;break;}}}
if(opts.stacked||hasStacks){var valuesPerStack={};for(datasetIndex=0;datasetIndex<datasets.length;datasetIndex++){meta=chart.getDatasetMeta(datasetIndex);var key=[meta.type,((opts.stacked===undefined&&meta.stack===undefined)?datasetIndex:''),meta.stack].join('.');if(chart.isDatasetVisible(datasetIndex)&&IDMatches(meta)){if(valuesPerStack[key]===undefined){valuesPerStack[key]=[];}
data=datasets[datasetIndex].data;for(i=0,ilen=data.length;i<ilen;i++){var values=valuesPerStack[key];value=me._parseValue(data[i]);if(isNaN(value.min)||isNaN(value.max)||meta.data[i].hidden||value.min<0||value.max<0){continue;}
values[i]=values[i]||0;values[i]+=value.max;}}}
helpers$1.each(valuesPerStack,function(valuesForType){if(valuesForType.length>0){var minVal=helpers$1.min(valuesForType);var maxVal=helpers$1.max(valuesForType);me.min=Math.min(me.min,minVal);me.max=Math.max(me.max,maxVal);}});}else{for(datasetIndex=0;datasetIndex<datasets.length;datasetIndex++){meta=chart.getDatasetMeta(datasetIndex);if(chart.isDatasetVisible(datasetIndex)&&IDMatches(meta)){data=datasets[datasetIndex].data;for(i=0,ilen=data.length;i<ilen;i++){value=me._parseValue(data[i]);if(isNaN(value.min)||isNaN(value.max)||meta.data[i].hidden||value.min<0||value.max<0){continue;}
me.min=Math.min(value.min,me.min);me.max=Math.max(value.max,me.max);if(value.min!==0){me.minNotZero=Math.min(value.min,me.minNotZero);}}}}}
me.min=helpers$1.isFinite(me.min)?me.min:null;me.max=helpers$1.isFinite(me.max)?me.max:null;me.minNotZero=helpers$1.isFinite(me.minNotZero)?me.minNotZero:null;this.handleTickRangeOptions();},handleTickRangeOptions:function(){var me=this;var tickOpts=me.options.ticks;var DEFAULT_MIN=1;var DEFAULT_MAX=10;me.min=nonNegativeOrDefault(tickOpts.min,me.min);me.max=nonNegativeOrDefault(tickOpts.max,me.max);if(me.min===me.max){if(me.min!==0&&me.min!==null){me.min=Math.pow(10,Math.floor(log10(me.min))-1);me.max=Math.pow(10,Math.floor(log10(me.max))+1);}else{me.min=DEFAULT_MIN;me.max=DEFAULT_MAX;}}
if(me.min===null){me.min=Math.pow(10,Math.floor(log10(me.max))-1);}
if(me.max===null){me.max=me.min!==0?Math.pow(10,Math.floor(log10(me.min))+1):DEFAULT_MAX;}
if(me.minNotZero===null){if(me.min>0){me.minNotZero=me.min;}else if(me.max<1){me.minNotZero=Math.pow(10,Math.floor(log10(me.max)));}else{me.minNotZero=DEFAULT_MIN;}}},buildTicks:function(){var me=this;var tickOpts=me.options.ticks;var reverse=!me.isHorizontal();var generationOptions={min:nonNegativeOrDefault(tickOpts.min),max:nonNegativeOrDefault(tickOpts.max)};var ticks=me.ticks=generateTicks$1(generationOptions,me);me.max=helpers$1.max(ticks);me.min=helpers$1.min(ticks);if(tickOpts.reverse){reverse=!reverse;me.start=me.max;me.end=me.min;}else{me.start=me.min;me.end=me.max;}
if(reverse){ticks.reverse();}},convertTicksToLabels:function(){this.tickValues=this.ticks.slice();core_scale.prototype.convertTicksToLabels.call(this);},getLabelForIndex:function(index,datasetIndex){return this._getScaleLabel(this.chart.data.datasets[datasetIndex].data[index]);},getPixelForTick:function(index){var ticks=this.tickValues;if(index<0||index>ticks.length-1){return null;}
return this.getPixelForValue(ticks[index]);},_getFirstTickValue:function(value){var exp=Math.floor(log10(value));var significand=Math.floor(value/Math.pow(10,exp));return significand*Math.pow(10,exp);},_configure:function(){var me=this;var start=me.min;var offset=0;core_scale.prototype._configure.call(me);if(start===0){start=me._getFirstTickValue(me.minNotZero);offset=valueOrDefault$b(me.options.ticks.fontSize,core_defaults.global.defaultFontSize)/me._length;}
me._startValue=log10(start);me._valueOffset=offset;me._valueRange=(log10(me.max)-log10(start))/(1-offset);},getPixelForValue:function(value){var me=this;var decimal=0;value=+me.getRightValue(value);if(value>me.min&&value>0){decimal=(log10(value)-me._startValue)/me._valueRange+me._valueOffset;}
return me.getPixelForDecimal(decimal);},getValueForPixel:function(pixel){var me=this;var decimal=me.getDecimalForPixel(pixel);return decimal===0&&me.min===0?0:Math.pow(10,me._startValue+(decimal-me._valueOffset)*me._valueRange);}});var _defaults$2=defaultConfig$2;scale_logarithmic._defaults=_defaults$2;var valueOrDefault$c=helpers$1.valueOrDefault;var valueAtIndexOrDefault$1=helpers$1.valueAtIndexOrDefault;var resolve$4=helpers$1.options.resolve;var defaultConfig$3={display:true,animate:true,position:'chartArea',angleLines:{display:true,color:'rgba(0,0,0,0.1)',lineWidth:1,borderDash:[],borderDashOffset:0.0},gridLines:{circular:false},ticks:{showLabelBackdrop:true,backdropColor:'rgba(255,255,255,0.75)',backdropPaddingY:2,backdropPaddingX:2,callback:core_ticks.formatters.linear},pointLabels:{display:true,fontSize:10,callback:function(label){return label;}}};function getTickBackdropHeight(opts){var tickOpts=opts.ticks;if(tickOpts.display&&opts.display){return valueOrDefault$c(tickOpts.fontSize,core_defaults.global.defaultFontSize)+tickOpts.backdropPaddingY*2;}
return 0;}
function measureLabelSize(ctx,lineHeight,label){if(helpers$1.isArray(label)){return{w:helpers$1.longestText(ctx,ctx.font,label),h:label.length*lineHeight};}
return{w:ctx.measureText(label).width,h:lineHeight};}
function determineLimits(angle,pos,size,min,max){if(angle===min||angle===max){return{start:pos-(size/2),end:pos+(size/2)};}else if(angle<min||angle>max){return{start:pos-size,end:pos};}
return{start:pos,end:pos+size};}
function fitWithPointLabels(scale){var plFont=helpers$1.options._parseFont(scale.options.pointLabels);var furthestLimits={l:0,r:scale.width,t:0,b:scale.height-scale.paddingTop};var furthestAngles={};var i,textSize,pointPosition;scale.ctx.font=plFont.string;scale._pointLabelSizes=[];var valueCount=scale.chart.data.labels.length;for(i=0;i<valueCount;i++){pointPosition=scale.getPointPosition(i,scale.drawingArea+5);textSize=measureLabelSize(scale.ctx,plFont.lineHeight,scale.pointLabels[i]);scale._pointLabelSizes[i]=textSize;var angleRadians=scale.getIndexAngle(i);var angle=helpers$1.toDegrees(angleRadians)%360;var hLimits=determineLimits(angle,pointPosition.x,textSize.w,0,180);var vLimits=determineLimits(angle,pointPosition.y,textSize.h,90,270);if(hLimits.start<furthestLimits.l){furthestLimits.l=hLimits.start;furthestAngles.l=angleRadians;}
if(hLimits.end>furthestLimits.r){furthestLimits.r=hLimits.end;furthestAngles.r=angleRadians;}
if(vLimits.start<furthestLimits.t){furthestLimits.t=vLimits.start;furthestAngles.t=angleRadians;}
if(vLimits.end>furthestLimits.b){furthestLimits.b=vLimits.end;furthestAngles.b=angleRadians;}}
scale.setReductions(scale.drawingArea,furthestLimits,furthestAngles);}
function getTextAlignForAngle(angle){if(angle===0||angle===180){return'center';}else if(angle<180){return'left';}
return'right';}
function fillText(ctx,text,position,lineHeight){var y=position.y+lineHeight/2;var i,ilen;if(helpers$1.isArray(text)){for(i=0,ilen=text.length;i<ilen;++i){ctx.fillText(text[i],position.x,y);y+=lineHeight;}}else{ctx.fillText(text,position.x,y);}}
function adjustPointPositionForLabelHeight(angle,textSize,position){if(angle===90||angle===270){position.y-=(textSize.h/2);}else if(angle>270||angle<90){position.y-=textSize.h;}}
function drawPointLabels(scale){var ctx=scale.ctx;var opts=scale.options;var pointLabelOpts=opts.pointLabels;var tickBackdropHeight=getTickBackdropHeight(opts);var outerDistance=scale.getDistanceFromCenterForValue(opts.ticks.reverse?scale.min:scale.max);var plFont=helpers$1.options._parseFont(pointLabelOpts);ctx.save();ctx.font=plFont.string;ctx.textBaseline='middle';for(var i=scale.chart.data.labels.length-1;i>=0;i--){var extra=(i===0?tickBackdropHeight/2:0);var pointLabelPosition=scale.getPointPosition(i,outerDistance+extra+5);var pointLabelFontColor=valueAtIndexOrDefault$1(pointLabelOpts.fontColor,i,core_defaults.global.defaultFontColor);ctx.fillStyle=pointLabelFontColor;var angleRadians=scale.getIndexAngle(i);var angle=helpers$1.toDegrees(angleRadians);ctx.textAlign=getTextAlignForAngle(angle);adjustPointPositionForLabelHeight(angle,scale._pointLabelSizes[i],pointLabelPosition);fillText(ctx,scale.pointLabels[i],pointLabelPosition,plFont.lineHeight);}
ctx.restore();}
function drawRadiusLine(scale,gridLineOpts,radius,index){var ctx=scale.ctx;var circular=gridLineOpts.circular;var valueCount=scale.chart.data.labels.length;var lineColor=valueAtIndexOrDefault$1(gridLineOpts.color,index-1);var lineWidth=valueAtIndexOrDefault$1(gridLineOpts.lineWidth,index-1);var pointPosition;if((!circular&&!valueCount)||!lineColor||!lineWidth){return;}
ctx.save();ctx.strokeStyle=lineColor;ctx.lineWidth=lineWidth;if(ctx.setLineDash){ctx.setLineDash(gridLineOpts.borderDash||[]);ctx.lineDashOffset=gridLineOpts.borderDashOffset||0.0;}
ctx.beginPath();if(circular){ctx.arc(scale.xCenter,scale.yCenter,radius,0,Math.PI*2);}else{pointPosition=scale.getPointPosition(0,radius);ctx.moveTo(pointPosition.x,pointPosition.y);for(var i=1;i<valueCount;i++){pointPosition=scale.getPointPosition(i,radius);ctx.lineTo(pointPosition.x,pointPosition.y);}}
ctx.closePath();ctx.stroke();ctx.restore();}
function numberOrZero(param){return helpers$1.isNumber(param)?param:0;}
var scale_radialLinear=scale_linearbase.extend({setDimensions:function(){var me=this;me.width=me.maxWidth;me.height=me.maxHeight;me.paddingTop=getTickBackdropHeight(me.options)/2;me.xCenter=Math.floor(me.width/2);me.yCenter=Math.floor((me.height-me.paddingTop)/2);me.drawingArea=Math.min(me.height-me.paddingTop,me.width)/2;},determineDataLimits:function(){var me=this;var chart=me.chart;var min=Number.POSITIVE_INFINITY;var max=Number.NEGATIVE_INFINITY;helpers$1.each(chart.data.datasets,function(dataset,datasetIndex){if(chart.isDatasetVisible(datasetIndex)){var meta=chart.getDatasetMeta(datasetIndex);helpers$1.each(dataset.data,function(rawValue,index){var value=+me.getRightValue(rawValue);if(isNaN(value)||meta.data[index].hidden){return;}
min=Math.min(value,min);max=Math.max(value,max);});}});me.min=(min===Number.POSITIVE_INFINITY?0:min);me.max=(max===Number.NEGATIVE_INFINITY?0:max);me.handleTickRangeOptions();},_computeTickLimit:function(){return Math.ceil(this.drawingArea/getTickBackdropHeight(this.options));},convertTicksToLabels:function(){var me=this;scale_linearbase.prototype.convertTicksToLabels.call(me);me.pointLabels=me.chart.data.labels.map(function(){var label=helpers$1.callback(me.options.pointLabels.callback,arguments,me);return label||label===0?label:'';});},getLabelForIndex:function(index,datasetIndex){return+this.getRightValue(this.chart.data.datasets[datasetIndex].data[index]);},fit:function(){var me=this;var opts=me.options;if(opts.display&&opts.pointLabels.display){fitWithPointLabels(me);}else{me.setCenterPoint(0,0,0,0);}},setReductions:function(largestPossibleRadius,furthestLimits,furthestAngles){var me=this;var radiusReductionLeft=furthestLimits.l/Math.sin(furthestAngles.l);var radiusReductionRight=Math.max(furthestLimits.r-me.width,0)/Math.sin(furthestAngles.r);var radiusReductionTop=-furthestLimits.t/Math.cos(furthestAngles.t);var radiusReductionBottom=-Math.max(furthestLimits.b-(me.height-me.paddingTop),0)/Math.cos(furthestAngles.b);radiusReductionLeft=numberOrZero(radiusReductionLeft);radiusReductionRight=numberOrZero(radiusReductionRight);radiusReductionTop=numberOrZero(radiusReductionTop);radiusReductionBottom=numberOrZero(radiusReductionBottom);me.drawingArea=Math.min(Math.floor(largestPossibleRadius-(radiusReductionLeft+radiusReductionRight)/2),Math.floor(largestPossibleRadius-(radiusReductionTop+radiusReductionBottom)/2));me.setCenterPoint(radiusReductionLeft,radiusReductionRight,radiusReductionTop,radiusReductionBottom);},setCenterPoint:function(leftMovement,rightMovement,topMovement,bottomMovement){var me=this;var maxRight=me.width-rightMovement-me.drawingArea;var maxLeft=leftMovement+me.drawingArea;var maxTop=topMovement+me.drawingArea;var maxBottom=(me.height-me.paddingTop)-bottomMovement-me.drawingArea;me.xCenter=Math.floor(((maxLeft+maxRight)/2)+me.left);me.yCenter=Math.floor(((maxTop+maxBottom)/2)+me.top+me.paddingTop);},getIndexAngle:function(index){var chart=this.chart;var angleMultiplier=360/chart.data.labels.length;var options=chart.options||{};var startAngle=options.startAngle||0;var angle=(index*angleMultiplier+startAngle)%360;return(angle<0?angle+360:angle)*Math.PI*2/360;},getDistanceFromCenterForValue:function(value){var me=this;if(helpers$1.isNullOrUndef(value)){return NaN;}
var scalingFactor=me.drawingArea/(me.max-me.min);if(me.options.ticks.reverse){return(me.max-value)*scalingFactor;}
return(value-me.min)*scalingFactor;},getPointPosition:function(index,distanceFromCenter){var me=this;var thisAngle=me.getIndexAngle(index)-(Math.PI/2);return{x:Math.cos(thisAngle)*distanceFromCenter+me.xCenter,y:Math.sin(thisAngle)*distanceFromCenter+me.yCenter};},getPointPositionForValue:function(index,value){return this.getPointPosition(index,this.getDistanceFromCenterForValue(value));},getBasePosition:function(index){var me=this;var min=me.min;var max=me.max;return me.getPointPositionForValue(index||0,me.beginAtZero?0:min<0&&max<0?max:min>0&&max>0?min:0);},_drawGrid:function(){var me=this;var ctx=me.ctx;var opts=me.options;var gridLineOpts=opts.gridLines;var angleLineOpts=opts.angleLines;var lineWidth=valueOrDefault$c(angleLineOpts.lineWidth,gridLineOpts.lineWidth);var lineColor=valueOrDefault$c(angleLineOpts.color,gridLineOpts.color);var i,offset,position;if(opts.pointLabels.display){drawPointLabels(me);}
if(gridLineOpts.display){helpers$1.each(me.ticks,function(label,index){if(index!==0){offset=me.getDistanceFromCenterForValue(me.ticksAsNumbers[index]);drawRadiusLine(me,gridLineOpts,offset,index);}});}
if(angleLineOpts.display&&lineWidth&&lineColor){ctx.save();ctx.lineWidth=lineWidth;ctx.strokeStyle=lineColor;if(ctx.setLineDash){ctx.setLineDash(resolve$4([angleLineOpts.borderDash,gridLineOpts.borderDash,[]]));ctx.lineDashOffset=resolve$4([angleLineOpts.borderDashOffset,gridLineOpts.borderDashOffset,0.0]);}
for(i=me.chart.data.labels.length-1;i>=0;i--){offset=me.getDistanceFromCenterForValue(opts.ticks.reverse?me.min:me.max);position=me.getPointPosition(i,offset);ctx.beginPath();ctx.moveTo(me.xCenter,me.yCenter);ctx.lineTo(position.x,position.y);ctx.stroke();}
ctx.restore();}},_drawLabels:function(){var me=this;var ctx=me.ctx;var opts=me.options;var tickOpts=opts.ticks;if(!tickOpts.display){return;}
var startAngle=me.getIndexAngle(0);var tickFont=helpers$1.options._parseFont(tickOpts);var tickFontColor=valueOrDefault$c(tickOpts.fontColor,core_defaults.global.defaultFontColor);var offset,width;ctx.save();ctx.font=tickFont.string;ctx.translate(me.xCenter,me.yCenter);ctx.rotate(startAngle);ctx.textAlign='center';ctx.textBaseline='middle';helpers$1.each(me.ticks,function(label,index){if(index===0&&!tickOpts.reverse){return;}
offset=me.getDistanceFromCenterForValue(me.ticksAsNumbers[index]);if(tickOpts.showLabelBackdrop){width=ctx.measureText(label).width;ctx.fillStyle=tickOpts.backdropColor;ctx.fillRect(-width/2-tickOpts.backdropPaddingX,-offset-tickFont.size/2-tickOpts.backdropPaddingY,width+tickOpts.backdropPaddingX*2,tickFont.size+tickOpts.backdropPaddingY*2);}
ctx.fillStyle=tickFontColor;ctx.fillText(label,0,-offset);});ctx.restore();},_drawTitle:helpers$1.noop});var _defaults$3=defaultConfig$3;scale_radialLinear._defaults=_defaults$3;var deprecated$1=helpers$1._deprecated;var resolve$5=helpers$1.options.resolve;var valueOrDefault$d=helpers$1.valueOrDefault;var MIN_INTEGER=Number.MIN_SAFE_INTEGER||-9007199254740991;var MAX_INTEGER=Number.MAX_SAFE_INTEGER||9007199254740991;var INTERVALS={millisecond:{common:true,size:1,steps:1000},second:{common:true,size:1000,steps:60},minute:{common:true,size:60000,steps:60},hour:{common:true,size:3600000,steps:24},day:{common:true,size:86400000,steps:30},week:{common:false,size:604800000,steps:4},month:{common:true,size:2.628e9,steps:12},quarter:{common:false,size:7.884e9,steps:4},year:{common:true,size:3.154e10}};var UNITS=Object.keys(INTERVALS);function sorter(a,b){return a-b;}
function arrayUnique(items){var hash={};var out=[];var i,ilen,item;for(i=0,ilen=items.length;i<ilen;++i){item=items[i];if(!hash[item]){hash[item]=true;out.push(item);}}
return out;}
function getMin(options){return helpers$1.valueOrDefault(options.time.min,options.ticks.min);}
function getMax(options){return helpers$1.valueOrDefault(options.time.max,options.ticks.max);}
function buildLookupTable(timestamps,min,max,distribution){if(distribution==='linear'||!timestamps.length){return[{time:min,pos:0},{time:max,pos:1}];}
var table=[];var items=[min];var i,ilen,prev,curr,next;for(i=0,ilen=timestamps.length;i<ilen;++i){curr=timestamps[i];if(curr>min&&curr<max){items.push(curr);}}
items.push(max);for(i=0,ilen=items.length;i<ilen;++i){next=items[i+1];prev=items[i-1];curr=items[i];if(prev===undefined||next===undefined||Math.round((next+prev)/2)!==curr){table.push({time:curr,pos:i/(ilen-1)});}}
return table;}
function lookup(table,key,value){var lo=0;var hi=table.length-1;var mid,i0,i1;while(lo>=0&&lo<=hi){mid=(lo+hi)>>1;i0=table[mid-1]||null;i1=table[mid];if(!i0){return{lo:null,hi:i1};}else if(i1[key]<value){lo=mid+1;}else if(i0[key]>value){hi=mid-1;}else{return{lo:i0,hi:i1};}}
return{lo:i1,hi:null};}
function interpolate$1(table,skey,sval,tkey){var range=lookup(table,skey,sval);var prev=!range.lo?table[0]:!range.hi?table[table.length-2]:range.lo;var next=!range.lo?table[1]:!range.hi?table[table.length-1]:range.hi;var span=next[skey]-prev[skey];var ratio=span?(sval-prev[skey])/span:0;var offset=(next[tkey]-prev[tkey])*ratio;return prev[tkey]+offset;}
function toTimestamp(scale,input){var adapter=scale._adapter;var options=scale.options.time;var parser=options.parser;var format=parser||options.format;var value=input;if(typeof parser==='function'){value=parser(value);}
if(!helpers$1.isFinite(value)){value=typeof format==='string'?adapter.parse(value,format):adapter.parse(value);}
if(value!==null){return+value;}
if(!parser&&typeof format==='function'){value=format(input);if(!helpers$1.isFinite(value)){value=adapter.parse(value);}}
return value;}
function parse(scale,input){if(helpers$1.isNullOrUndef(input)){return null;}
var options=scale.options.time;var value=toTimestamp(scale,scale.getRightValue(input));if(value===null){return value;}
if(options.round){value=+scale._adapter.startOf(value,options.round);}
return value;}
function determineUnitForAutoTicks(minUnit,min,max,capacity){var ilen=UNITS.length;var i,interval,factor;for(i=UNITS.indexOf(minUnit);i<ilen-1;++i){interval=INTERVALS[UNITS[i]];factor=interval.steps?interval.steps:MAX_INTEGER;if(interval.common&&Math.ceil((max-min)/(factor*interval.size))<=capacity){return UNITS[i];}}
return UNITS[ilen-1];}
function determineUnitForFormatting(scale,numTicks,minUnit,min,max){var i,unit;for(i=UNITS.length-1;i>=UNITS.indexOf(minUnit);i--){unit=UNITS[i];if(INTERVALS[unit].common&&scale._adapter.diff(max,min,unit)>=numTicks-1){return unit;}}
return UNITS[minUnit?UNITS.indexOf(minUnit):0];}
function determineMajorUnit(unit){for(var i=UNITS.indexOf(unit)+1,ilen=UNITS.length;i<ilen;++i){if(INTERVALS[UNITS[i]].common){return UNITS[i];}}}
function generate(scale,min,max,capacity){var adapter=scale._adapter;var options=scale.options;var timeOpts=options.time;var minor=timeOpts.unit||determineUnitForAutoTicks(timeOpts.minUnit,min,max,capacity);var stepSize=resolve$5([timeOpts.stepSize,timeOpts.unitStepSize,1]);var weekday=minor==='week'?timeOpts.isoWeekday:false;var first=min;var ticks=[];var time;if(weekday){first=+adapter.startOf(first,'isoWeek',weekday);}
first=+adapter.startOf(first,weekday?'day':minor);if(adapter.diff(max,min,minor)>100000*stepSize){throw min+' and '+max+' are too far apart with stepSize of '+stepSize+' '+minor;}
for(time=first;time<max;time=+adapter.add(time,stepSize,minor)){ticks.push(time);}
if(time===max||options.bounds==='ticks'){ticks.push(time);}
return ticks;}
function computeOffsets(table,ticks,min,max,options){var start=0;var end=0;var first,last;if(options.offset&&ticks.length){first=interpolate$1(table,'time',ticks[0],'pos');if(ticks.length===1){start=1-first;}else{start=(interpolate$1(table,'time',ticks[1],'pos')-first)/2;}
last=interpolate$1(table,'time',ticks[ticks.length-1],'pos');if(ticks.length===1){end=last;}else{end=(last-interpolate$1(table,'time',ticks[ticks.length-2],'pos'))/2;}}
return{start:start,end:end,factor:1/(start+1+end)};}
function setMajorTicks(scale,ticks,map,majorUnit){var adapter=scale._adapter;var first=+adapter.startOf(ticks[0].value,majorUnit);var last=ticks[ticks.length-1].value;var major,index;for(major=first;major<=last;major=+adapter.add(major,1,majorUnit)){index=map[major];if(index>=0){ticks[index].major=true;}}
return ticks;}
function ticksFromTimestamps(scale,values,majorUnit){var ticks=[];var map={};var ilen=values.length;var i,value;for(i=0;i<ilen;++i){value=values[i];map[value]=i;ticks.push({value:value,major:false});}
return(ilen===0||!majorUnit)?ticks:setMajorTicks(scale,ticks,map,majorUnit);}
var defaultConfig$4={position:'bottom',distribution:'linear',bounds:'data',adapters:{},time:{parser:false,unit:false,round:false,displayFormat:false,isoWeekday:false,minUnit:'millisecond',displayFormats:{}},ticks:{autoSkip:false,source:'auto',major:{enabled:false}}};var scale_time=core_scale.extend({initialize:function(){this.mergeTicksOptions();core_scale.prototype.initialize.call(this);},update:function(){var me=this;var options=me.options;var time=options.time||(options.time={});var adapter=me._adapter=new core_adapters._date(options.adapters.date);deprecated$1('time scale',time.format,'time.format','time.parser');deprecated$1('time scale',time.min,'time.min','ticks.min');deprecated$1('time scale',time.max,'time.max','ticks.max');helpers$1.mergeIf(time.displayFormats,adapter.formats());return core_scale.prototype.update.apply(me,arguments);},getRightValue:function(rawValue){if(rawValue&&rawValue.t!==undefined){rawValue=rawValue.t;}
return core_scale.prototype.getRightValue.call(this,rawValue);},determineDataLimits:function(){var me=this;var chart=me.chart;var adapter=me._adapter;var options=me.options;var unit=options.time.unit||'day';var min=MAX_INTEGER;var max=MIN_INTEGER;var timestamps=[];var datasets=[];var labels=[];var i,j,ilen,jlen,data,timestamp,labelsAdded;var dataLabels=me._getLabels();for(i=0,ilen=dataLabels.length;i<ilen;++i){labels.push(parse(me,dataLabels[i]));}
for(i=0,ilen=(chart.data.datasets||[]).length;i<ilen;++i){if(chart.isDatasetVisible(i)){data=chart.data.datasets[i].data;if(helpers$1.isObject(data[0])){datasets[i]=[];for(j=0,jlen=data.length;j<jlen;++j){timestamp=parse(me,data[j]);timestamps.push(timestamp);datasets[i][j]=timestamp;}}else{datasets[i]=labels.slice(0);if(!labelsAdded){timestamps=timestamps.concat(labels);labelsAdded=true;}}}else{datasets[i]=[];}}
if(labels.length){min=Math.min(min,labels[0]);max=Math.max(max,labels[labels.length-1]);}
if(timestamps.length){timestamps=ilen>1?arrayUnique(timestamps).sort(sorter):timestamps.sort(sorter);min=Math.min(min,timestamps[0]);max=Math.max(max,timestamps[timestamps.length-1]);}
min=parse(me,getMin(options))||min;max=parse(me,getMax(options))||max;min=min===MAX_INTEGER?+adapter.startOf(Date.now(),unit):min;max=max===MIN_INTEGER?+adapter.endOf(Date.now(),unit)+1:max;me.min=Math.min(min,max);me.max=Math.max(min+1,max);me._table=[];me._timestamps={data:timestamps,datasets:datasets,labels:labels};},buildTicks:function(){var me=this;var min=me.min;var max=me.max;var options=me.options;var tickOpts=options.ticks;var timeOpts=options.time;var timestamps=me._timestamps;var ticks=[];var capacity=me.getLabelCapacity(min);var source=tickOpts.source;var distribution=options.distribution;var i,ilen,timestamp;if(source==='data'||(source==='auto'&&distribution==='series')){timestamps=timestamps.data;}else if(source==='labels'){timestamps=timestamps.labels;}else{timestamps=generate(me,min,max,capacity);}
if(options.bounds==='ticks'&&timestamps.length){min=timestamps[0];max=timestamps[timestamps.length-1];}
min=parse(me,getMin(options))||min;max=parse(me,getMax(options))||max;for(i=0,ilen=timestamps.length;i<ilen;++i){timestamp=timestamps[i];if(timestamp>=min&&timestamp<=max){ticks.push(timestamp);}}
me.min=min;me.max=max;me._unit=timeOpts.unit||(tickOpts.autoSkip?determineUnitForAutoTicks(timeOpts.minUnit,me.min,me.max,capacity):determineUnitForFormatting(me,ticks.length,timeOpts.minUnit,me.min,me.max));me._majorUnit=!tickOpts.major.enabled||me._unit==='year'?undefined:determineMajorUnit(me._unit);me._table=buildLookupTable(me._timestamps.data,min,max,distribution);me._offsets=computeOffsets(me._table,ticks,min,max,options);if(tickOpts.reverse){ticks.reverse();}
return ticksFromTimestamps(me,ticks,me._majorUnit);},getLabelForIndex:function(index,datasetIndex){var me=this;var adapter=me._adapter;var data=me.chart.data;var timeOpts=me.options.time;var label=data.labels&&index<data.labels.length?data.labels[index]:'';var value=data.datasets[datasetIndex].data[index];if(helpers$1.isObject(value)){label=me.getRightValue(value);}
if(timeOpts.tooltipFormat){return adapter.format(toTimestamp(me,label),timeOpts.tooltipFormat);}
if(typeof label==='string'){return label;}
return adapter.format(toTimestamp(me,label),timeOpts.displayFormats.datetime);},tickFormatFunction:function(time,index,ticks,format){var me=this;var adapter=me._adapter;var options=me.options;var formats=options.time.displayFormats;var minorFormat=formats[me._unit];var majorUnit=me._majorUnit;var majorFormat=formats[majorUnit];var tick=ticks[index];var tickOpts=options.ticks;var major=majorUnit&&majorFormat&&tick&&tick.major;var label=adapter.format(time,format?format:major?majorFormat:minorFormat);var nestedTickOpts=major?tickOpts.major:tickOpts.minor;var formatter=resolve$5([nestedTickOpts.callback,nestedTickOpts.userCallback,tickOpts.callback,tickOpts.userCallback]);return formatter?formatter(label,index,ticks):label;},convertTicksToLabels:function(ticks){var labels=[];var i,ilen;for(i=0,ilen=ticks.length;i<ilen;++i){labels.push(this.tickFormatFunction(ticks[i].value,i,ticks));}
return labels;},getPixelForOffset:function(time){var me=this;var offsets=me._offsets;var pos=interpolate$1(me._table,'time',time,'pos');return me.getPixelForDecimal((offsets.start+pos)*offsets.factor);},getPixelForValue:function(value,index,datasetIndex){var me=this;var time=null;if(index!==undefined&&datasetIndex!==undefined){time=me._timestamps.datasets[datasetIndex][index];}
if(time===null){time=parse(me,value);}
if(time!==null){return me.getPixelForOffset(time);}},getPixelForTick:function(index){var ticks=this.getTicks();return index>=0&&index<ticks.length?this.getPixelForOffset(ticks[index].value):null;},getValueForPixel:function(pixel){var me=this;var offsets=me._offsets;var pos=me.getDecimalForPixel(pixel)/offsets.factor-offsets.end;var time=interpolate$1(me._table,'pos',pos,'time');return me._adapter._create(time);},_getLabelSize:function(label){var me=this;var ticksOpts=me.options.ticks;var tickLabelWidth=me.ctx.measureText(label).width;var angle=helpers$1.toRadians(me.isHorizontal()?ticksOpts.maxRotation:ticksOpts.minRotation);var cosRotation=Math.cos(angle);var sinRotation=Math.sin(angle);var tickFontSize=valueOrDefault$d(ticksOpts.fontSize,core_defaults.global.defaultFontSize);return{w:(tickLabelWidth*cosRotation)+(tickFontSize*sinRotation),h:(tickLabelWidth*sinRotation)+(tickFontSize*cosRotation)};},getLabelWidth:function(label){return this._getLabelSize(label).w;},getLabelCapacity:function(exampleTime){var me=this;var timeOpts=me.options.time;var displayFormats=timeOpts.displayFormats;var format=displayFormats[timeOpts.unit]||displayFormats.millisecond;var exampleLabel=me.tickFormatFunction(exampleTime,0,ticksFromTimestamps(me,[exampleTime],me._majorUnit),format);var size=me._getLabelSize(exampleLabel);var capacity=Math.floor(me.isHorizontal()?me.width/size.w:me.height/size.h);if(me.options.offset){capacity--;}
return capacity>0?capacity:1;}});var _defaults$4=defaultConfig$4;scale_time._defaults=_defaults$4;var scales={category:scale_category,linear:scale_linear,logarithmic:scale_logarithmic,radialLinear:scale_radialLinear,time:scale_time};var FORMATS={datetime:'MMM D, YYYY, h:mm:ss a',millisecond:'h:mm:ss.SSS a',second:'h:mm:ss a',minute:'h:mm a',hour:'hA',day:'MMM D',week:'ll',month:'MMM YYYY',quarter:'[Q]Q - YYYY',year:'YYYY'};core_adapters._date.override(typeof moment==='function'?{_id:'moment',formats:function(){return FORMATS;},parse:function(value,format){if(typeof value==='string'&&typeof format==='string'){value=moment(value,format);}else if(!(value instanceof moment)){value=moment(value);}
return value.isValid()?value.valueOf():null;},format:function(time,format){return moment(time).format(format);},add:function(time,amount,unit){return moment(time).add(amount,unit).valueOf();},diff:function(max,min,unit){return moment(max).diff(moment(min),unit);},startOf:function(time,unit,weekday){time=moment(time);if(unit==='isoWeek'){return time.isoWeekday(weekday).valueOf();}
return time.startOf(unit).valueOf();},endOf:function(time,unit){return moment(time).endOf(unit).valueOf();},_create:function(time){return moment(time);},}:{});core_defaults._set('global',{plugins:{filler:{propagate:true}}});var mappers={dataset:function(source){var index=source.fill;var chart=source.chart;var meta=chart.getDatasetMeta(index);var visible=meta&&chart.isDatasetVisible(index);var points=(visible&&meta.dataset._children)||[];var length=points.length||0;return!length?null:function(point,i){return(i<length&&points[i]._view)||null;};},boundary:function(source){var boundary=source.boundary;var x=boundary?boundary.x:null;var y=boundary?boundary.y:null;if(helpers$1.isArray(boundary)){return function(point,i){return boundary[i];};}
return function(point){return{x:x===null?point.x:x,y:y===null?point.y:y,};};}};function decodeFill(el,index,count){var model=el._model||{};var fill=model.fill;var target;if(fill===undefined){fill=!!model.backgroundColor;}
if(fill===false||fill===null){return false;}
if(fill===true){return'origin';}
target=parseFloat(fill,10);if(isFinite(target)&&Math.floor(target)===target){if(fill[0]==='-'||fill[0]==='+'){target=index+target;}
if(target===index||target<0||target>=count){return false;}
return target;}
switch(fill){case'bottom':return'start';case'top':return'end';case'zero':return'origin';case'origin':case'start':case'end':return fill;default:return false;}}
function computeLinearBoundary(source){var model=source.el._model||{};var scale=source.el._scale||{};var fill=source.fill;var target=null;var horizontal;if(isFinite(fill)){return null;}
if(fill==='start'){target=model.scaleBottom===undefined?scale.bottom:model.scaleBottom;}else if(fill==='end'){target=model.scaleTop===undefined?scale.top:model.scaleTop;}else if(model.scaleZero!==undefined){target=model.scaleZero;}else if(scale.getBasePixel){target=scale.getBasePixel();}
if(target!==undefined&&target!==null){if(target.x!==undefined&&target.y!==undefined){return target;}
if(helpers$1.isFinite(target)){horizontal=scale.isHorizontal();return{x:horizontal?target:null,y:horizontal?null:target};}}
return null;}
function computeCircularBoundary(source){var scale=source.el._scale;var options=scale.options;var length=scale.chart.data.labels.length;var fill=source.fill;var target=[];var start,end,center,i,point;if(!length){return null;}
start=options.ticks.reverse?scale.max:scale.min;end=options.ticks.reverse?scale.min:scale.max;center=scale.getPointPositionForValue(0,start);for(i=0;i<length;++i){point=fill==='start'||fill==='end'?scale.getPointPositionForValue(i,fill==='start'?start:end):scale.getBasePosition(i);if(options.gridLines.circular){point.cx=center.x;point.cy=center.y;point.angle=scale.getIndexAngle(i)-Math.PI/2;}
target.push(point);}
return target;}
function computeBoundary(source){var scale=source.el._scale||{};if(scale.getPointPositionForValue){return computeCircularBoundary(source);}
return computeLinearBoundary(source);}
function resolveTarget(sources,index,propagate){var source=sources[index];var fill=source.fill;var visited=[index];var target;if(!propagate){return fill;}
while(fill!==false&&visited.indexOf(fill)===-1){if(!isFinite(fill)){return fill;}
target=sources[fill];if(!target){return false;}
if(target.visible){return fill;}
visited.push(fill);fill=target.fill;}
return false;}
function createMapper(source){var fill=source.fill;var type='dataset';if(fill===false){return null;}
if(!isFinite(fill)){type='boundary';}
return mappers[type](source);}
function isDrawable(point){return point&&!point.skip;}
function drawArea(ctx,curve0,curve1,len0,len1){var i,cx,cy,r;if(!len0||!len1){return;}
ctx.moveTo(curve0[0].x,curve0[0].y);for(i=1;i<len0;++i){helpers$1.canvas.lineTo(ctx,curve0[i-1],curve0[i]);}
if(curve1[0].angle!==undefined){cx=curve1[0].cx;cy=curve1[0].cy;r=Math.sqrt(Math.pow(curve1[0].x-cx,2)+Math.pow(curve1[0].y-cy,2));for(i=len1-1;i>0;--i){ctx.arc(cx,cy,r,curve1[i].angle,curve1[i-1].angle,true);}
return;}
ctx.lineTo(curve1[len1-1].x,curve1[len1-1].y);for(i=len1-1;i>0;--i){helpers$1.canvas.lineTo(ctx,curve1[i],curve1[i-1],true);}}
function doFill(ctx,points,mapper,view,color,loop){var count=points.length;var span=view.spanGaps;var curve0=[];var curve1=[];var len0=0;var len1=0;var i,ilen,index,p0,p1,d0,d1,loopOffset;ctx.beginPath();for(i=0,ilen=count;i<ilen;++i){index=i%count;p0=points[index]._view;p1=mapper(p0,index,view);d0=isDrawable(p0);d1=isDrawable(p1);if(loop&&loopOffset===undefined&&d0){loopOffset=i+1;ilen=count+loopOffset;}
if(d0&&d1){len0=curve0.push(p0);len1=curve1.push(p1);}else if(len0&&len1){if(!span){drawArea(ctx,curve0,curve1,len0,len1);len0=len1=0;curve0=[];curve1=[];}else{if(d0){curve0.push(p0);}
if(d1){curve1.push(p1);}}}}
drawArea(ctx,curve0,curve1,len0,len1);ctx.closePath();ctx.fillStyle=color;ctx.fill();}
var plugin_filler={id:'filler',afterDatasetsUpdate:function(chart,options){var count=(chart.data.datasets||[]).length;var propagate=options.propagate;var sources=[];var meta,i,el,source;for(i=0;i<count;++i){meta=chart.getDatasetMeta(i);el=meta.dataset;source=null;if(el&&el._model&&el instanceof elements.Line){source={visible:chart.isDatasetVisible(i),fill:decodeFill(el,i,count),chart:chart,el:el};}
meta.$filler=source;sources.push(source);}
for(i=0;i<count;++i){source=sources[i];if(!source){continue;}
source.fill=resolveTarget(sources,i,propagate);source.boundary=computeBoundary(source);source.mapper=createMapper(source);}},beforeDatasetsDraw:function(chart){var metasets=chart._getSortedVisibleDatasetMetas();var ctx=chart.ctx;var meta,i,el,view,points,mapper,color;for(i=metasets.length-1;i>=0;--i){meta=metasets[i].$filler;if(!meta||!meta.visible){continue;}
el=meta.el;view=el._view;points=el._children||[];mapper=meta.mapper;color=view.backgroundColor||core_defaults.global.defaultColor;if(mapper&&color&&points.length){helpers$1.canvas.clipArea(ctx,chart.chartArea);doFill(ctx,points,mapper,view,color,el._loop);helpers$1.canvas.unclipArea(ctx);}}}};var getRtlHelper$1=helpers$1.rtl.getRtlAdapter;var noop$1=helpers$1.noop;var valueOrDefault$e=helpers$1.valueOrDefault;core_defaults._set('global',{legend:{display:true,position:'top',align:'center',fullWidth:true,reverse:false,weight:1000,onClick:function(e,legendItem){var index=legendItem.datasetIndex;var ci=this.chart;var meta=ci.getDatasetMeta(index);meta.hidden=meta.hidden===null?!ci.data.datasets[index].hidden:null;ci.update();},onHover:null,onLeave:null,labels:{boxWidth:40,padding:10,generateLabels:function(chart){var datasets=chart.data.datasets;var options=chart.options.legend||{};var usePointStyle=options.labels&&options.labels.usePointStyle;return chart._getSortedDatasetMetas().map(function(meta){var style=meta.controller.getStyle(usePointStyle?0:undefined);return{text:datasets[meta.index].label,fillStyle:style.backgroundColor,hidden:!chart.isDatasetVisible(meta.index),lineCap:style.borderCapStyle,lineDash:style.borderDash,lineDashOffset:style.borderDashOffset,lineJoin:style.borderJoinStyle,lineWidth:style.borderWidth,strokeStyle:style.borderColor,pointStyle:style.pointStyle,rotation:style.rotation,datasetIndex:meta.index};},this);}}},legendCallback:function(chart){var list=document.createElement('ul');var datasets=chart.data.datasets;var i,ilen,listItem,listItemSpan;list.setAttribute('class',chart.id+'-legend');for(i=0,ilen=datasets.length;i<ilen;i++){listItem=list.appendChild(document.createElement('li'));listItemSpan=listItem.appendChild(document.createElement('span'));listItemSpan.style.backgroundColor=datasets[i].backgroundColor;if(datasets[i].label){listItem.appendChild(document.createTextNode(datasets[i].label));}}
return list.outerHTML;}});function getBoxWidth(labelOpts,fontSize){return labelOpts.usePointStyle&&labelOpts.boxWidth>fontSize?fontSize:labelOpts.boxWidth;}
var Legend=core_element.extend({initialize:function(config){var me=this;helpers$1.extend(me,config);me.legendHitBoxes=[];me._hoveredItem=null;me.doughnutMode=false;},beforeUpdate:noop$1,update:function(maxWidth,maxHeight,margins){var me=this;me.beforeUpdate();me.maxWidth=maxWidth;me.maxHeight=maxHeight;me.margins=margins;me.beforeSetDimensions();me.setDimensions();me.afterSetDimensions();me.beforeBuildLabels();me.buildLabels();me.afterBuildLabels();me.beforeFit();me.fit();me.afterFit();me.afterUpdate();return me.minSize;},afterUpdate:noop$1,beforeSetDimensions:noop$1,setDimensions:function(){var me=this;if(me.isHorizontal()){me.width=me.maxWidth;me.left=0;me.right=me.width;}else{me.height=me.maxHeight;me.top=0;me.bottom=me.height;}
me.paddingLeft=0;me.paddingTop=0;me.paddingRight=0;me.paddingBottom=0;me.minSize={width:0,height:0};},afterSetDimensions:noop$1,beforeBuildLabels:noop$1,buildLabels:function(){var me=this;var labelOpts=me.options.labels||{};var legendItems=helpers$1.callback(labelOpts.generateLabels,[me.chart],me)||[];if(labelOpts.filter){legendItems=legendItems.filter(function(item){return labelOpts.filter(item,me.chart.data);});}
if(me.options.reverse){legendItems.reverse();}
me.legendItems=legendItems;},afterBuildLabels:noop$1,beforeFit:noop$1,fit:function(){var me=this;var opts=me.options;var labelOpts=opts.labels;var display=opts.display;var ctx=me.ctx;var labelFont=helpers$1.options._parseFont(labelOpts);var fontSize=labelFont.size;var hitboxes=me.legendHitBoxes=[];var minSize=me.minSize;var isHorizontal=me.isHorizontal();if(isHorizontal){minSize.width=me.maxWidth;minSize.height=display?10:0;}else{minSize.width=display?10:0;minSize.height=me.maxHeight;}
if(!display){me.width=minSize.width=me.height=minSize.height=0;return;}
ctx.font=labelFont.string;if(isHorizontal){var lineWidths=me.lineWidths=[0];var totalHeight=0;ctx.textAlign='left';ctx.textBaseline='middle';helpers$1.each(me.legendItems,function(legendItem,i){var boxWidth=getBoxWidth(labelOpts,fontSize);var width=boxWidth+(fontSize/2)+ctx.measureText(legendItem.text).width;if(i===0||lineWidths[lineWidths.length-1]+width+2*labelOpts.padding>minSize.width){totalHeight+=fontSize+labelOpts.padding;lineWidths[lineWidths.length-(i>0?0:1)]=0;}
hitboxes[i]={left:0,top:0,width:width,height:fontSize};lineWidths[lineWidths.length-1]+=width+labelOpts.padding;});minSize.height+=totalHeight;}else{var vPadding=labelOpts.padding;var columnWidths=me.columnWidths=[];var columnHeights=me.columnHeights=[];var totalWidth=labelOpts.padding;var currentColWidth=0;var currentColHeight=0;helpers$1.each(me.legendItems,function(legendItem,i){var boxWidth=getBoxWidth(labelOpts,fontSize);var itemWidth=boxWidth+(fontSize/2)+ctx.measureText(legendItem.text).width;if(i>0&&currentColHeight+fontSize+2*vPadding>minSize.height){totalWidth+=currentColWidth+labelOpts.padding;columnWidths.push(currentColWidth);columnHeights.push(currentColHeight);currentColWidth=0;currentColHeight=0;}
currentColWidth=Math.max(currentColWidth,itemWidth);currentColHeight+=fontSize+vPadding;hitboxes[i]={left:0,top:0,width:itemWidth,height:fontSize};});totalWidth+=currentColWidth;columnWidths.push(currentColWidth);columnHeights.push(currentColHeight);minSize.width+=totalWidth;}
me.width=minSize.width;me.height=minSize.height;},afterFit:noop$1,isHorizontal:function(){return this.options.position==='top'||this.options.position==='bottom';},draw:function(){var me=this;var opts=me.options;var labelOpts=opts.labels;var globalDefaults=core_defaults.global;var defaultColor=globalDefaults.defaultColor;var lineDefault=globalDefaults.elements.line;var legendHeight=me.height;var columnHeights=me.columnHeights;var legendWidth=me.width;var lineWidths=me.lineWidths;if(!opts.display){return;}
var rtlHelper=getRtlHelper$1(opts.rtl,me.left,me.minSize.width);var ctx=me.ctx;var fontColor=valueOrDefault$e(labelOpts.fontColor,globalDefaults.defaultFontColor);var labelFont=helpers$1.options._parseFont(labelOpts);var fontSize=labelFont.size;var cursor;ctx.textAlign=rtlHelper.textAlign('left');ctx.textBaseline='middle';ctx.lineWidth=0.5;ctx.strokeStyle=fontColor;ctx.fillStyle=fontColor;ctx.font=labelFont.string;var boxWidth=getBoxWidth(labelOpts,fontSize);var hitboxes=me.legendHitBoxes;var drawLegendBox=function(x,y,legendItem){if(isNaN(boxWidth)||boxWidth<=0){return;}
ctx.save();var lineWidth=valueOrDefault$e(legendItem.lineWidth,lineDefault.borderWidth);ctx.fillStyle=valueOrDefault$e(legendItem.fillStyle,defaultColor);ctx.lineCap=valueOrDefault$e(legendItem.lineCap,lineDefault.borderCapStyle);ctx.lineDashOffset=valueOrDefault$e(legendItem.lineDashOffset,lineDefault.borderDashOffset);ctx.lineJoin=valueOrDefault$e(legendItem.lineJoin,lineDefault.borderJoinStyle);ctx.lineWidth=lineWidth;ctx.strokeStyle=valueOrDefault$e(legendItem.strokeStyle,defaultColor);if(ctx.setLineDash){ctx.setLineDash(valueOrDefault$e(legendItem.lineDash,lineDefault.borderDash));}
if(labelOpts&&labelOpts.usePointStyle){var radius=boxWidth*Math.SQRT2/2;var centerX=rtlHelper.xPlus(x,boxWidth/2);var centerY=y+fontSize/2;helpers$1.canvas.drawPoint(ctx,legendItem.pointStyle,radius,centerX,centerY,legendItem.rotation);}else{ctx.fillRect(rtlHelper.leftForLtr(x,boxWidth),y,boxWidth,fontSize);if(lineWidth!==0){ctx.strokeRect(rtlHelper.leftForLtr(x,boxWidth),y,boxWidth,fontSize);}}
ctx.restore();};var fillText=function(x,y,legendItem,textWidth){var halfFontSize=fontSize/2;var xLeft=rtlHelper.xPlus(x,boxWidth+halfFontSize);var yMiddle=y+halfFontSize;ctx.fillText(legendItem.text,xLeft,yMiddle);if(legendItem.hidden){ctx.beginPath();ctx.lineWidth=2;ctx.moveTo(xLeft,yMiddle);ctx.lineTo(rtlHelper.xPlus(xLeft,textWidth),yMiddle);ctx.stroke();}};var alignmentOffset=function(dimension,blockSize){switch(opts.align){case'start':return labelOpts.padding;case'end':return dimension-blockSize;default:return(dimension-blockSize+labelOpts.padding)/2;}};var isHorizontal=me.isHorizontal();if(isHorizontal){cursor={x:me.left+alignmentOffset(legendWidth,lineWidths[0]),y:me.top+labelOpts.padding,line:0};}else{cursor={x:me.left+labelOpts.padding,y:me.top+alignmentOffset(legendHeight,columnHeights[0]),line:0};}
helpers$1.rtl.overrideTextDirection(me.ctx,opts.textDirection);var itemHeight=fontSize+labelOpts.padding;helpers$1.each(me.legendItems,function(legendItem,i){var textWidth=ctx.measureText(legendItem.text).width;var width=boxWidth+(fontSize/2)+textWidth;var x=cursor.x;var y=cursor.y;rtlHelper.setWidth(me.minSize.width);if(isHorizontal){if(i>0&&x+width+labelOpts.padding>me.left+me.minSize.width){y=cursor.y+=itemHeight;cursor.line++;x=cursor.x=me.left+alignmentOffset(legendWidth,lineWidths[cursor.line]);}}else if(i>0&&y+itemHeight>me.top+me.minSize.height){x=cursor.x=x+me.columnWidths[cursor.line]+labelOpts.padding;cursor.line++;y=cursor.y=me.top+alignmentOffset(legendHeight,columnHeights[cursor.line]);}
var realX=rtlHelper.x(x);drawLegendBox(realX,y,legendItem);hitboxes[i].left=rtlHelper.leftForLtr(realX,hitboxes[i].width);hitboxes[i].top=y;fillText(realX,y,legendItem,textWidth);if(isHorizontal){cursor.x+=width+labelOpts.padding;}else{cursor.y+=itemHeight;}});helpers$1.rtl.restoreTextDirection(me.ctx,opts.textDirection);},_getLegendItemAt:function(x,y){var me=this;var i,hitBox,lh;if(x>=me.left&&x<=me.right&&y>=me.top&&y<=me.bottom){lh=me.legendHitBoxes;for(i=0;i<lh.length;++i){hitBox=lh[i];if(x>=hitBox.left&&x<=hitBox.left+hitBox.width&&y>=hitBox.top&&y<=hitBox.top+hitBox.height){return me.legendItems[i];}}}
return null;},handleEvent:function(e){var me=this;var opts=me.options;var type=e.type==='mouseup'?'click':e.type;var hoveredItem;if(type==='mousemove'){if(!opts.onHover&&!opts.onLeave){return;}}else if(type==='click'){if(!opts.onClick){return;}}else{return;}
hoveredItem=me._getLegendItemAt(e.x,e.y);if(type==='click'){if(hoveredItem&&opts.onClick){opts.onClick.call(me,e.native,hoveredItem);}}else{if(opts.onLeave&&hoveredItem!==me._hoveredItem){if(me._hoveredItem){opts.onLeave.call(me,e.native,me._hoveredItem);}
me._hoveredItem=hoveredItem;}
if(opts.onHover&&hoveredItem){opts.onHover.call(me,e.native,hoveredItem);}}}});function createNewLegendAndAttach(chart,legendOpts){var legend=new Legend({ctx:chart.ctx,options:legendOpts,chart:chart});core_layouts.configure(chart,legend,legendOpts);core_layouts.addBox(chart,legend);chart.legend=legend;}
var plugin_legend={id:'legend',_element:Legend,beforeInit:function(chart){var legendOpts=chart.options.legend;if(legendOpts){createNewLegendAndAttach(chart,legendOpts);}},beforeUpdate:function(chart){var legendOpts=chart.options.legend;var legend=chart.legend;if(legendOpts){helpers$1.mergeIf(legendOpts,core_defaults.global.legend);if(legend){core_layouts.configure(chart,legend,legendOpts);legend.options=legendOpts;}else{createNewLegendAndAttach(chart,legendOpts);}}else if(legend){core_layouts.removeBox(chart,legend);delete chart.legend;}},afterEvent:function(chart,e){var legend=chart.legend;if(legend){legend.handleEvent(e);}}};var noop$2=helpers$1.noop;core_defaults._set('global',{title:{display:false,fontStyle:'bold',fullWidth:true,padding:10,position:'top',text:'',weight:2000}});var Title=core_element.extend({initialize:function(config){var me=this;helpers$1.extend(me,config);me.legendHitBoxes=[];},beforeUpdate:noop$2,update:function(maxWidth,maxHeight,margins){var me=this;me.beforeUpdate();me.maxWidth=maxWidth;me.maxHeight=maxHeight;me.margins=margins;me.beforeSetDimensions();me.setDimensions();me.afterSetDimensions();me.beforeBuildLabels();me.buildLabels();me.afterBuildLabels();me.beforeFit();me.fit();me.afterFit();me.afterUpdate();return me.minSize;},afterUpdate:noop$2,beforeSetDimensions:noop$2,setDimensions:function(){var me=this;if(me.isHorizontal()){me.width=me.maxWidth;me.left=0;me.right=me.width;}else{me.height=me.maxHeight;me.top=0;me.bottom=me.height;}
me.paddingLeft=0;me.paddingTop=0;me.paddingRight=0;me.paddingBottom=0;me.minSize={width:0,height:0};},afterSetDimensions:noop$2,beforeBuildLabels:noop$2,buildLabels:noop$2,afterBuildLabels:noop$2,beforeFit:noop$2,fit:function(){var me=this;var opts=me.options;var minSize=me.minSize={};var isHorizontal=me.isHorizontal();var lineCount,textSize;if(!opts.display){me.width=minSize.width=me.height=minSize.height=0;return;}
lineCount=helpers$1.isArray(opts.text)?opts.text.length:1;textSize=lineCount*helpers$1.options._parseFont(opts).lineHeight+opts.padding*2;me.width=minSize.width=isHorizontal?me.maxWidth:textSize;me.height=minSize.height=isHorizontal?textSize:me.maxHeight;},afterFit:noop$2,isHorizontal:function(){var pos=this.options.position;return pos==='top'||pos==='bottom';},draw:function(){var me=this;var ctx=me.ctx;var opts=me.options;if(!opts.display){return;}
var fontOpts=helpers$1.options._parseFont(opts);var lineHeight=fontOpts.lineHeight;var offset=lineHeight/2+opts.padding;var rotation=0;var top=me.top;var left=me.left;var bottom=me.bottom;var right=me.right;var maxWidth,titleX,titleY;ctx.fillStyle=helpers$1.valueOrDefault(opts.fontColor,core_defaults.global.defaultFontColor);ctx.font=fontOpts.string;if(me.isHorizontal()){titleX=left+((right-left)/2);titleY=top+offset;maxWidth=right-left;}else{titleX=opts.position==='left'?left+offset:right-offset;titleY=top+((bottom-top)/2);maxWidth=bottom-top;rotation=Math.PI*(opts.position==='left'?-0.5:0.5);}
ctx.save();ctx.translate(titleX,titleY);ctx.rotate(rotation);ctx.textAlign='center';ctx.textBaseline='middle';var text=opts.text;if(helpers$1.isArray(text)){var y=0;for(var i=0;i<text.length;++i){ctx.fillText(text[i],0,y,maxWidth);y+=lineHeight;}}else{ctx.fillText(text,0,0,maxWidth);}
ctx.restore();}});function createNewTitleBlockAndAttach(chart,titleOpts){var title=new Title({ctx:chart.ctx,options:titleOpts,chart:chart});core_layouts.configure(chart,title,titleOpts);core_layouts.addBox(chart,title);chart.titleBlock=title;}
var plugin_title={id:'title',_element:Title,beforeInit:function(chart){var titleOpts=chart.options.title;if(titleOpts){createNewTitleBlockAndAttach(chart,titleOpts);}},beforeUpdate:function(chart){var titleOpts=chart.options.title;var titleBlock=chart.titleBlock;if(titleOpts){helpers$1.mergeIf(titleOpts,core_defaults.global.title);if(titleBlock){core_layouts.configure(chart,titleBlock,titleOpts);titleBlock.options=titleOpts;}else{createNewTitleBlockAndAttach(chart,titleOpts);}}else if(titleBlock){core_layouts.removeBox(chart,titleBlock);delete chart.titleBlock;}}};var plugins={};var filler=plugin_filler;var legend=plugin_legend;var title=plugin_title;plugins.filler=filler;plugins.legend=legend;plugins.title=title;core_controller.helpers=helpers$1;core_helpers();core_controller._adapters=core_adapters;core_controller.Animation=core_animation;core_controller.animationService=core_animations;core_controller.controllers=controllers;core_controller.DatasetController=core_datasetController;core_controller.defaults=core_defaults;core_controller.Element=core_element;core_controller.elements=elements;core_controller.Interaction=core_interaction;core_controller.layouts=core_layouts;core_controller.platform=platform;core_controller.plugins=core_plugins;core_controller.Scale=core_scale;core_controller.scaleService=core_scaleService;core_controller.Ticks=core_ticks;core_controller.Tooltip=core_tooltip;core_controller.helpers.each(scales,function(scale,type){core_controller.scaleService.registerScaleType(type,scale,scale._defaults);});for(var k in plugins){if(plugins.hasOwnProperty(k)){core_controller.plugins.register(plugins[k]);}}
core_controller.platform.initialize();var src=core_controller;if(typeof window!=='undefined'){window.Chart=core_controller;}
core_controller.Chart=core_controller;core_controller.Legend=plugins.legend._element;core_controller.Title=plugins.title._element;core_controller.pluginService=core_controller.plugins;core_controller.PluginBase=core_controller.Element.extend({});core_controller.canvasHelpers=core_controller.helpers.canvas;core_controller.layoutService=core_controller.layouts;core_controller.LinearScaleBase=scale_linearbase;core_controller.helpers.each(['Bar','Bubble','Doughnut','Line','PolarArea','Radar','Scatter'],function(klass){core_controller[klass]=function(ctx,cfg){return new core_controller(ctx,core_controller.helpers.merge(cfg||{},{type:klass.charAt(0).toLowerCase()+klass.slice(1)}));};});return src;})));(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.markdownit=f()}})(function(){var define,module,exports;return(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){'use strict';module.exports=require('entities/maps/entities.json');},{"entities/maps/entities.json":52}],2:[function(require,module,exports){'use strict';module.exports=['address','article','aside','base','basefont','blockquote','body','caption','center','col','colgroup','dd','details','dialog','dir','div','dl','dt','fieldset','figcaption','figure','footer','form','frame','frameset','h1','h2','h3','h4','h5','h6','head','header','hr','html','iframe','legend','li','link','main','menu','menuitem','meta','nav','noframes','ol','optgroup','option','p','param','section','source','summary','table','tbody','td','tfoot','th','thead','title','tr','track','ul'];},{}],3:[function(require,module,exports){'use strict';var attr_name='[a-zA-Z_:][a-zA-Z0-9:._-]*';var unquoted='[^"\'=<>`\\x00-\\x20]+';var single_quoted="'[^']*'";var double_quoted='"[^"]*"';var attr_value='(?:'+unquoted+'|'+single_quoted+'|'+double_quoted+')';var attribute='(?:\\s+'+attr_name+'(?:\\s*=\\s*'+attr_value+')?)';var open_tag='<[A-Za-z][A-Za-z0-9\\-]*'+attribute+'*\\s*\\/?>';var close_tag='<\\/[A-Za-z][A-Za-z0-9\\-]*\\s*>';var comment='<!---->|<!--(?:-?[^>-])(?:-?[^-])*-->';var processing='<[?].*?[?]>';var declaration='<![A-Z]+\\s+[^>]*>';var cdata='<!\\[CDATA\\[[\\s\\S]*?\\]\\]>';var HTML_TAG_RE=new RegExp('^(?:'+open_tag+'|'+close_tag+'|'+comment+'|'+processing+'|'+declaration+'|'+cdata+')');var HTML_OPEN_CLOSE_TAG_RE=new RegExp('^(?:'+open_tag+'|'+close_tag+')');module.exports.HTML_TAG_RE=HTML_TAG_RE;module.exports.HTML_OPEN_CLOSE_TAG_RE=HTML_OPEN_CLOSE_TAG_RE;},{}],4:[function(require,module,exports){'use strict';function _class(obj){return Object.prototype.toString.call(obj);}
function isString(obj){return _class(obj)==='[object String]';}
var _hasOwnProperty=Object.prototype.hasOwnProperty;function has(object,key){return _hasOwnProperty.call(object,key);}
function assign(obj){var sources=Array.prototype.slice.call(arguments,1);sources.forEach(function(source){if(!source){return;}
if(typeof source!=='object'){throw new TypeError(source+'must be object');}
Object.keys(source).forEach(function(key){obj[key]=source[key];});});return obj;}
function arrayReplaceAt(src,pos,newElements){return[].concat(src.slice(0,pos),newElements,src.slice(pos+1));}
function isValidEntityCode(c){if(c>=0xD800&&c<=0xDFFF){return false;}
if(c>=0xFDD0&&c<=0xFDEF){return false;}
if((c&0xFFFF)===0xFFFF||(c&0xFFFF)===0xFFFE){return false;}
if(c>=0x00&&c<=0x08){return false;}
if(c===0x0B){return false;}
if(c>=0x0E&&c<=0x1F){return false;}
if(c>=0x7F&&c<=0x9F){return false;}
if(c>0x10FFFF){return false;}
return true;}
function fromCodePoint(c){if(c>0xffff){c-=0x10000;var surrogate1=0xd800+(c>>10),surrogate2=0xdc00+(c&0x3ff);return String.fromCharCode(surrogate1,surrogate2);}
return String.fromCharCode(c);}
var UNESCAPE_MD_RE=/\\([!"#$%&'()*+,\-.\/:;<=>?@[\\\]^_`{|}~])/g;var ENTITY_RE=/&([a-z#][a-z0-9]{1,31});/gi;var UNESCAPE_ALL_RE=new RegExp(UNESCAPE_MD_RE.source+'|'+ENTITY_RE.source,'gi');var DIGITAL_ENTITY_TEST_RE=/^#((?:x[a-f0-9]{1,8}|[0-9]{1,8}))/i;var entities=require('./entities');function replaceEntityPattern(match,name){var code=0;if(has(entities,name)){return entities[name];}
if(name.charCodeAt(0)===0x23&&DIGITAL_ENTITY_TEST_RE.test(name)){code=name[1].toLowerCase()==='x'?parseInt(name.slice(2),16):parseInt(name.slice(1),10);if(isValidEntityCode(code)){return fromCodePoint(code);}}
return match;}
function unescapeMd(str){if(str.indexOf('\\')<0){return str;}
return str.replace(UNESCAPE_MD_RE,'$1');}
function unescapeAll(str){if(str.indexOf('\\')<0&&str.indexOf('&')<0){return str;}
return str.replace(UNESCAPE_ALL_RE,function(match,escaped,entity){if(escaped){return escaped;}
return replaceEntityPattern(match,entity);});}
var HTML_ESCAPE_TEST_RE=/[&<>"]/;var HTML_ESCAPE_REPLACE_RE=/[&<>"]/g;var HTML_REPLACEMENTS={'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;'};function replaceUnsafeChar(ch){return HTML_REPLACEMENTS[ch];}
function escapeHtml(str){if(HTML_ESCAPE_TEST_RE.test(str)){return str.replace(HTML_ESCAPE_REPLACE_RE,replaceUnsafeChar);}
return str;}
var REGEXP_ESCAPE_RE=/[.?*+^$[\]\\(){}|-]/g;function escapeRE(str){return str.replace(REGEXP_ESCAPE_RE,'\\$&');}
function isSpace(code){switch(code){case 0x09:case 0x20:return true;}
return false;}
function isWhiteSpace(code){if(code>=0x2000&&code<=0x200A){return true;}
switch(code){case 0x09:case 0x0A:case 0x0B:case 0x0C:case 0x0D:case 0x20:case 0xA0:case 0x1680:case 0x202F:case 0x205F:case 0x3000:return true;}
return false;}
var UNICODE_PUNCT_RE=require('uc.micro/categories/P/regex');function isPunctChar(ch){return UNICODE_PUNCT_RE.test(ch);}
function isMdAsciiPunct(ch){switch(ch){case 0x21:case 0x22:case 0x23:case 0x24:case 0x25:case 0x26:case 0x27:case 0x28:case 0x29:case 0x2A:case 0x2B:case 0x2C:case 0x2D:case 0x2E:case 0x2F:case 0x3A:case 0x3B:case 0x3C:case 0x3D:case 0x3E:case 0x3F:case 0x40:case 0x5B:case 0x5C:case 0x5D:case 0x5E:case 0x5F:case 0x60:case 0x7B:case 0x7C:case 0x7D:case 0x7E:return true;default:return false;}}
function normalizeReference(str){return str.trim().replace(/\s+/g,' ').toUpperCase();}
exports.lib={};exports.lib.mdurl=require('mdurl');exports.lib.ucmicro=require('uc.micro');exports.assign=assign;exports.isString=isString;exports.has=has;exports.unescapeMd=unescapeMd;exports.unescapeAll=unescapeAll;exports.isValidEntityCode=isValidEntityCode;exports.fromCodePoint=fromCodePoint;exports.escapeHtml=escapeHtml;exports.arrayReplaceAt=arrayReplaceAt;exports.isSpace=isSpace;exports.isWhiteSpace=isWhiteSpace;exports.isMdAsciiPunct=isMdAsciiPunct;exports.isPunctChar=isPunctChar;exports.escapeRE=escapeRE;exports.normalizeReference=normalizeReference;},{"./entities":1,"mdurl":58,"uc.micro":65,"uc.micro/categories/P/regex":63}],5:[function(require,module,exports){'use strict';exports.parseLinkLabel=require('./parse_link_label');exports.parseLinkDestination=require('./parse_link_destination');exports.parseLinkTitle=require('./parse_link_title');},{"./parse_link_destination":6,"./parse_link_label":7,"./parse_link_title":8}],6:[function(require,module,exports){'use strict';var isSpace=require('../common/utils').isSpace;var unescapeAll=require('../common/utils').unescapeAll;module.exports=function parseLinkDestination(str,pos,max){var code,level,lines=0,start=pos,result={ok:false,pos:0,lines:0,str:''};if(str.charCodeAt(pos)===0x3C){pos++;while(pos<max){code=str.charCodeAt(pos);if(code===0x0A||isSpace(code)){return result;}
if(code===0x3E){result.pos=pos+1;result.str=unescapeAll(str.slice(start+1,pos));result.ok=true;return result;}
if(code===0x5C&&pos+1<max){pos+=2;continue;}
pos++;}
return result;}
level=0;while(pos<max){code=str.charCodeAt(pos);if(code===0x20){break;}
if(code<0x20||code===0x7F){break;}
if(code===0x5C&&pos+1<max){pos+=2;continue;}
if(code===0x28){level++;}
if(code===0x29){if(level===0){break;}
level--;}
pos++;}
if(start===pos){return result;}
if(level!==0){return result;}
result.str=unescapeAll(str.slice(start,pos));result.lines=lines;result.pos=pos;result.ok=true;return result;};},{"../common/utils":4}],7:[function(require,module,exports){'use strict';module.exports=function parseLinkLabel(state,start,disableNested){var level,found,marker,prevPos,labelEnd=-1,max=state.posMax,oldPos=state.pos;state.pos=start+1;level=1;while(state.pos<max){marker=state.src.charCodeAt(state.pos);if(marker===0x5D){level--;if(level===0){found=true;break;}}
prevPos=state.pos;state.md.inline.skipToken(state);if(marker===0x5B){if(prevPos===state.pos-1){level++;}else if(disableNested){state.pos=oldPos;return-1;}}}
if(found){labelEnd=state.pos;}
state.pos=oldPos;return labelEnd;};},{}],8:[function(require,module,exports){'use strict';var unescapeAll=require('../common/utils').unescapeAll;module.exports=function parseLinkTitle(str,pos,max){var code,marker,lines=0,start=pos,result={ok:false,pos:0,lines:0,str:''};if(pos>=max){return result;}
marker=str.charCodeAt(pos);if(marker!==0x22&&marker!==0x27&&marker!==0x28){return result;}
pos++;if(marker===0x28){marker=0x29;}
while(pos<max){code=str.charCodeAt(pos);if(code===marker){result.pos=pos+1;result.lines=lines;result.str=unescapeAll(str.slice(start+1,pos));result.ok=true;return result;}else if(code===0x0A){lines++;}else if(code===0x5C&&pos+1<max){pos++;if(str.charCodeAt(pos)===0x0A){lines++;}}
pos++;}
return result;};},{"../common/utils":4}],9:[function(require,module,exports){'use strict';var utils=require('./common/utils');var helpers=require('./helpers');var Renderer=require('./renderer');var ParserCore=require('./parser_core');var ParserBlock=require('./parser_block');var ParserInline=require('./parser_inline');var LinkifyIt=require('linkify-it');var mdurl=require('mdurl');var punycode=require('punycode');var config={'default':require('./presets/default'),zero:require('./presets/zero'),commonmark:require('./presets/commonmark')};var BAD_PROTO_RE=/^(vbscript|javascript|file|data):/;var GOOD_DATA_RE=/^data:image\/(gif|png|jpeg|webp);/;function validateLink(url){var str=url.trim().toLowerCase();return BAD_PROTO_RE.test(str)?(GOOD_DATA_RE.test(str)?true:false):true;}
var RECODE_HOSTNAME_FOR=['http:','https:','mailto:'];function normalizeLink(url){var parsed=mdurl.parse(url,true);if(parsed.hostname){if(!parsed.protocol||RECODE_HOSTNAME_FOR.indexOf(parsed.protocol)>=0){try{parsed.hostname=punycode.toASCII(parsed.hostname);}catch(er){}}}
return mdurl.encode(mdurl.format(parsed));}
function normalizeLinkText(url){var parsed=mdurl.parse(url,true);if(parsed.hostname){if(!parsed.protocol||RECODE_HOSTNAME_FOR.indexOf(parsed.protocol)>=0){try{parsed.hostname=punycode.toUnicode(parsed.hostname);}catch(er){}}}
return mdurl.decode(mdurl.format(parsed));}
function MarkdownIt(presetName,options){if(!(this instanceof MarkdownIt)){return new MarkdownIt(presetName,options);}
if(!options){if(!utils.isString(presetName)){options=presetName||{};presetName='default';}}
this.inline=new ParserInline();this.block=new ParserBlock();this.core=new ParserCore();this.renderer=new Renderer();this.linkify=new LinkifyIt();this.validateLink=validateLink;this.normalizeLink=normalizeLink;this.normalizeLinkText=normalizeLinkText;this.utils=utils;this.helpers=utils.assign({},helpers);this.options={};this.configure(presetName);if(options){this.set(options);}}
MarkdownIt.prototype.set=function(options){utils.assign(this.options,options);return this;};MarkdownIt.prototype.configure=function(presets){var self=this,presetName;if(utils.isString(presets)){presetName=presets;presets=config[presetName];if(!presets){throw new Error('Wrong `markdown-it` preset "'+presetName+'", check name');}}
if(!presets){throw new Error('Wrong `markdown-it` preset, can\'t be empty');}
if(presets.options){self.set(presets.options);}
if(presets.components){Object.keys(presets.components).forEach(function(name){if(presets.components[name].rules){self[name].ruler.enableOnly(presets.components[name].rules);}
if(presets.components[name].rules2){self[name].ruler2.enableOnly(presets.components[name].rules2);}});}
return this;};MarkdownIt.prototype.enable=function(list,ignoreInvalid){var result=[];if(!Array.isArray(list)){list=[list];}
['core','block','inline'].forEach(function(chain){result=result.concat(this[chain].ruler.enable(list,true));},this);result=result.concat(this.inline.ruler2.enable(list,true));var missed=list.filter(function(name){return result.indexOf(name)<0;});if(missed.length&&!ignoreInvalid){throw new Error('MarkdownIt. Failed to enable unknown rule(s): '+missed);}
return this;};MarkdownIt.prototype.disable=function(list,ignoreInvalid){var result=[];if(!Array.isArray(list)){list=[list];}
['core','block','inline'].forEach(function(chain){result=result.concat(this[chain].ruler.disable(list,true));},this);result=result.concat(this.inline.ruler2.disable(list,true));var missed=list.filter(function(name){return result.indexOf(name)<0;});if(missed.length&&!ignoreInvalid){throw new Error('MarkdownIt. Failed to disable unknown rule(s): '+missed);}
return this;};MarkdownIt.prototype.use=function(plugin){var args=[this].concat(Array.prototype.slice.call(arguments,1));plugin.apply(plugin,args);return this;};MarkdownIt.prototype.parse=function(src,env){if(typeof src!=='string'){throw new Error('Input data should be a String');}
var state=new this.core.State(src,this,env);this.core.process(state);return state.tokens;};MarkdownIt.prototype.render=function(src,env){env=env||{};return this.renderer.render(this.parse(src,env),this.options,env);};MarkdownIt.prototype.parseInline=function(src,env){var state=new this.core.State(src,this,env);state.inlineMode=true;this.core.process(state);return state.tokens;};MarkdownIt.prototype.renderInline=function(src,env){env=env||{};return this.renderer.render(this.parseInline(src,env),this.options,env);};module.exports=MarkdownIt;},{"./common/utils":4,"./helpers":5,"./parser_block":10,"./parser_core":11,"./parser_inline":12,"./presets/commonmark":13,"./presets/default":14,"./presets/zero":15,"./renderer":16,"linkify-it":53,"mdurl":58,"punycode":60}],10:[function(require,module,exports){'use strict';var Ruler=require('./ruler');var _rules=[['table',require('./rules_block/table'),['paragraph','reference']],['code',require('./rules_block/code')],['fence',require('./rules_block/fence'),['paragraph','reference','blockquote','list']],['blockquote',require('./rules_block/blockquote'),['paragraph','reference','blockquote','list']],['hr',require('./rules_block/hr'),['paragraph','reference','blockquote','list']],['list',require('./rules_block/list'),['paragraph','reference','blockquote']],['reference',require('./rules_block/reference')],['heading',require('./rules_block/heading'),['paragraph','reference','blockquote']],['lheading',require('./rules_block/lheading')],['html_block',require('./rules_block/html_block'),['paragraph','reference','blockquote']],['paragraph',require('./rules_block/paragraph')]];function ParserBlock(){this.ruler=new Ruler();for(var i=0;i<_rules.length;i++){this.ruler.push(_rules[i][0],_rules[i][1],{alt:(_rules[i][2]||[]).slice()});}}
ParserBlock.prototype.tokenize=function(state,startLine,endLine){var ok,i,rules=this.ruler.getRules(''),len=rules.length,line=startLine,hasEmptyLines=false,maxNesting=state.md.options.maxNesting;while(line<endLine){state.line=line=state.skipEmptyLines(line);if(line>=endLine){break;}
if(state.sCount[line]<state.blkIndent){break;}
if(state.level>=maxNesting){state.line=endLine;break;}
for(i=0;i<len;i++){ok=rules[i](state,line,endLine,false);if(ok){break;}}
state.tight=!hasEmptyLines;if(state.isEmpty(state.line-1)){hasEmptyLines=true;}
line=state.line;if(line<endLine&&state.isEmpty(line)){hasEmptyLines=true;line++;state.line=line;}}};ParserBlock.prototype.parse=function(src,md,env,outTokens){var state;if(!src){return;}
state=new this.State(src,md,env,outTokens);this.tokenize(state,state.line,state.lineMax);};ParserBlock.prototype.State=require('./rules_block/state_block');module.exports=ParserBlock;},{"./ruler":17,"./rules_block/blockquote":18,"./rules_block/code":19,"./rules_block/fence":20,"./rules_block/heading":21,"./rules_block/hr":22,"./rules_block/html_block":23,"./rules_block/lheading":24,"./rules_block/list":25,"./rules_block/paragraph":26,"./rules_block/reference":27,"./rules_block/state_block":28,"./rules_block/table":29}],11:[function(require,module,exports){'use strict';var Ruler=require('./ruler');var _rules=[['normalize',require('./rules_core/normalize')],['block',require('./rules_core/block')],['inline',require('./rules_core/inline')],['linkify',require('./rules_core/linkify')],['replacements',require('./rules_core/replacements')],['smartquotes',require('./rules_core/smartquotes')]];function Core(){this.ruler=new Ruler();for(var i=0;i<_rules.length;i++){this.ruler.push(_rules[i][0],_rules[i][1]);}}
Core.prototype.process=function(state){var i,l,rules;rules=this.ruler.getRules('');for(i=0,l=rules.length;i<l;i++){rules[i](state);}};Core.prototype.State=require('./rules_core/state_core');module.exports=Core;},{"./ruler":17,"./rules_core/block":30,"./rules_core/inline":31,"./rules_core/linkify":32,"./rules_core/normalize":33,"./rules_core/replacements":34,"./rules_core/smartquotes":35,"./rules_core/state_core":36}],12:[function(require,module,exports){'use strict';var Ruler=require('./ruler');var _rules=[['text',require('./rules_inline/text')],['newline',require('./rules_inline/newline')],['escape',require('./rules_inline/escape')],['backticks',require('./rules_inline/backticks')],['strikethrough',require('./rules_inline/strikethrough').tokenize],['emphasis',require('./rules_inline/emphasis').tokenize],['link',require('./rules_inline/link')],['image',require('./rules_inline/image')],['autolink',require('./rules_inline/autolink')],['html_inline',require('./rules_inline/html_inline')],['entity',require('./rules_inline/entity')]];var _rules2=[['balance_pairs',require('./rules_inline/balance_pairs')],['strikethrough',require('./rules_inline/strikethrough').postProcess],['emphasis',require('./rules_inline/emphasis').postProcess],['text_collapse',require('./rules_inline/text_collapse')]];function ParserInline(){var i;this.ruler=new Ruler();for(i=0;i<_rules.length;i++){this.ruler.push(_rules[i][0],_rules[i][1]);}
this.ruler2=new Ruler();for(i=0;i<_rules2.length;i++){this.ruler2.push(_rules2[i][0],_rules2[i][1]);}}
ParserInline.prototype.skipToken=function(state){var ok,i,pos=state.pos,rules=this.ruler.getRules(''),len=rules.length,maxNesting=state.md.options.maxNesting,cache=state.cache;if(typeof cache[pos]!=='undefined'){state.pos=cache[pos];return;}
if(state.level<maxNesting){for(i=0;i<len;i++){state.level++;ok=rules[i](state,true);state.level--;if(ok){break;}}}else{state.pos=state.posMax;}
if(!ok){state.pos++;}
cache[pos]=state.pos;};ParserInline.prototype.tokenize=function(state){var ok,i,rules=this.ruler.getRules(''),len=rules.length,end=state.posMax,maxNesting=state.md.options.maxNesting;while(state.pos<end){if(state.level<maxNesting){for(i=0;i<len;i++){ok=rules[i](state,false);if(ok){break;}}}
if(ok){if(state.pos>=end){break;}
continue;}
state.pending+=state.src[state.pos++];}
if(state.pending){state.pushPending();}};ParserInline.prototype.parse=function(str,md,env,outTokens){var i,rules,len;var state=new this.State(str,md,env,outTokens);this.tokenize(state);rules=this.ruler2.getRules('');len=rules.length;for(i=0;i<len;i++){rules[i](state);}};ParserInline.prototype.State=require('./rules_inline/state_inline');module.exports=ParserInline;},{"./ruler":17,"./rules_inline/autolink":37,"./rules_inline/backticks":38,"./rules_inline/balance_pairs":39,"./rules_inline/emphasis":40,"./rules_inline/entity":41,"./rules_inline/escape":42,"./rules_inline/html_inline":43,"./rules_inline/image":44,"./rules_inline/link":45,"./rules_inline/newline":46,"./rules_inline/state_inline":47,"./rules_inline/strikethrough":48,"./rules_inline/text":49,"./rules_inline/text_collapse":50}],13:[function(require,module,exports){'use strict';module.exports={options:{html:true,xhtmlOut:true,breaks:false,langPrefix:'language-',linkify:false,typographer:false,quotes:'\u201c\u201d\u2018\u2019',highlight:null,maxNesting:20},components:{core:{rules:['normalize','block','inline']},block:{rules:['blockquote','code','fence','heading','hr','html_block','lheading','list','reference','paragraph']},inline:{rules:['autolink','backticks','emphasis','entity','escape','html_inline','image','link','newline','text'],rules2:['balance_pairs','emphasis','text_collapse']}}};},{}],14:[function(require,module,exports){'use strict';module.exports={options:{html:false,xhtmlOut:false,breaks:false,langPrefix:'language-',linkify:false,typographer:false,quotes:'\u201c\u201d\u2018\u2019',highlight:null,maxNesting:100},components:{core:{},block:{},inline:{}}};},{}],15:[function(require,module,exports){'use strict';module.exports={options:{html:false,xhtmlOut:false,breaks:false,langPrefix:'language-',linkify:false,typographer:false,quotes:'\u201c\u201d\u2018\u2019',highlight:null,maxNesting:20},components:{core:{rules:['normalize','block','inline']},block:{rules:['paragraph']},inline:{rules:['text'],rules2:['balance_pairs','text_collapse']}}};},{}],16:[function(require,module,exports){'use strict';var assign=require('./common/utils').assign;var unescapeAll=require('./common/utils').unescapeAll;var escapeHtml=require('./common/utils').escapeHtml;var default_rules={};default_rules.code_inline=function(tokens,idx,options,env,slf){var token=tokens[idx];return'<code'+slf.renderAttrs(token)+'>'+
escapeHtml(tokens[idx].content)+'</code>';};default_rules.code_block=function(tokens,idx,options,env,slf){var token=tokens[idx];return'<pre'+slf.renderAttrs(token)+'><code>'+
escapeHtml(tokens[idx].content)+'</code></pre>\n';};default_rules.fence=function(tokens,idx,options,env,slf){var token=tokens[idx],info=token.info?unescapeAll(token.info).trim():'',langName='',highlighted,i,tmpAttrs,tmpToken;if(info){langName=info.split(/\s+/g)[0];}
if(options.highlight){highlighted=options.highlight(token.content,langName)||escapeHtml(token.content);}else{highlighted=escapeHtml(token.content);}
if(highlighted.indexOf('<pre')===0){return highlighted+'\n';}
if(info){i=token.attrIndex('class');tmpAttrs=token.attrs?token.attrs.slice():[];if(i<0){tmpAttrs.push(['class',options.langPrefix+langName]);}else{tmpAttrs[i][1]+=' '+options.langPrefix+langName;}
tmpToken={attrs:tmpAttrs};return'<pre><code'+slf.renderAttrs(tmpToken)+'>'
+highlighted
+'</code></pre>\n';}
return'<pre><code'+slf.renderAttrs(token)+'>'
+highlighted
+'</code></pre>\n';};default_rules.image=function(tokens,idx,options,env,slf){var token=tokens[idx];token.attrs[token.attrIndex('alt')][1]=slf.renderInlineAsText(token.children,options,env);return slf.renderToken(tokens,idx,options);};default_rules.hardbreak=function(tokens,idx,options){return options.xhtmlOut?'<br />\n':'<br>\n';};default_rules.softbreak=function(tokens,idx,options){return options.breaks?(options.xhtmlOut?'<br />\n':'<br>\n'):'\n';};default_rules.text=function(tokens,idx){return escapeHtml(tokens[idx].content);};default_rules.html_block=function(tokens,idx){return tokens[idx].content;};default_rules.html_inline=function(tokens,idx){return tokens[idx].content;};function Renderer(){this.rules=assign({},default_rules);}
Renderer.prototype.renderAttrs=function renderAttrs(token){var i,l,result;if(!token.attrs){return'';}
result='';for(i=0,l=token.attrs.length;i<l;i++){result+=' '+escapeHtml(token.attrs[i][0])+'="'+escapeHtml(token.attrs[i][1])+'"';}
return result;};Renderer.prototype.renderToken=function renderToken(tokens,idx,options){var nextToken,result='',needLf=false,token=tokens[idx];if(token.hidden){return'';}
if(token.block&&token.nesting!==-1&&idx&&tokens[idx-1].hidden){result+='\n';}
result+=(token.nesting===-1?'</':'<')+token.tag;result+=this.renderAttrs(token);if(token.nesting===0&&options.xhtmlOut){result+=' /';}
if(token.block){needLf=true;if(token.nesting===1){if(idx+1<tokens.length){nextToken=tokens[idx+1];if(nextToken.type==='inline'||nextToken.hidden){needLf=false;}else if(nextToken.nesting===-1&&nextToken.tag===token.tag){needLf=false;}}}}
result+=needLf?'>\n':'>';return result;};Renderer.prototype.renderInline=function(tokens,options,env){var type,result='',rules=this.rules;for(var i=0,len=tokens.length;i<len;i++){type=tokens[i].type;if(typeof rules[type]!=='undefined'){result+=rules[type](tokens,i,options,env,this);}else{result+=this.renderToken(tokens,i,options);}}
return result;};Renderer.prototype.renderInlineAsText=function(tokens,options,env){var result='';for(var i=0,len=tokens.length;i<len;i++){if(tokens[i].type==='text'){result+=tokens[i].content;}else if(tokens[i].type==='image'){result+=this.renderInlineAsText(tokens[i].children,options,env);}}
return result;};Renderer.prototype.render=function(tokens,options,env){var i,len,type,result='',rules=this.rules;for(i=0,len=tokens.length;i<len;i++){type=tokens[i].type;if(type==='inline'){result+=this.renderInline(tokens[i].children,options,env);}else if(typeof rules[type]!=='undefined'){result+=rules[tokens[i].type](tokens,i,options,env,this);}else{result+=this.renderToken(tokens,i,options,env);}}
return result;};module.exports=Renderer;},{"./common/utils":4}],17:[function(require,module,exports){'use strict';function Ruler(){this.__rules__=[];this.__cache__=null;}
Ruler.prototype.__find__=function(name){for(var i=0;i<this.__rules__.length;i++){if(this.__rules__[i].name===name){return i;}}
return-1;};Ruler.prototype.__compile__=function(){var self=this;var chains=[''];self.__rules__.forEach(function(rule){if(!rule.enabled){return;}
rule.alt.forEach(function(altName){if(chains.indexOf(altName)<0){chains.push(altName);}});});self.__cache__={};chains.forEach(function(chain){self.__cache__[chain]=[];self.__rules__.forEach(function(rule){if(!rule.enabled){return;}
if(chain&&rule.alt.indexOf(chain)<0){return;}
self.__cache__[chain].push(rule.fn);});});};Ruler.prototype.at=function(name,fn,options){var index=this.__find__(name);var opt=options||{};if(index===-1){throw new Error('Parser rule not found: '+name);}
this.__rules__[index].fn=fn;this.__rules__[index].alt=opt.alt||[];this.__cache__=null;};Ruler.prototype.before=function(beforeName,ruleName,fn,options){var index=this.__find__(beforeName);var opt=options||{};if(index===-1){throw new Error('Parser rule not found: '+beforeName);}
this.__rules__.splice(index,0,{name:ruleName,enabled:true,fn:fn,alt:opt.alt||[]});this.__cache__=null;};Ruler.prototype.after=function(afterName,ruleName,fn,options){var index=this.__find__(afterName);var opt=options||{};if(index===-1){throw new Error('Parser rule not found: '+afterName);}
this.__rules__.splice(index+1,0,{name:ruleName,enabled:true,fn:fn,alt:opt.alt||[]});this.__cache__=null;};Ruler.prototype.push=function(ruleName,fn,options){var opt=options||{};this.__rules__.push({name:ruleName,enabled:true,fn:fn,alt:opt.alt||[]});this.__cache__=null;};Ruler.prototype.enable=function(list,ignoreInvalid){if(!Array.isArray(list)){list=[list];}
var result=[];list.forEach(function(name){var idx=this.__find__(name);if(idx<0){if(ignoreInvalid){return;}
throw new Error('Rules manager: invalid rule name '+name);}
this.__rules__[idx].enabled=true;result.push(name);},this);this.__cache__=null;return result;};Ruler.prototype.enableOnly=function(list,ignoreInvalid){if(!Array.isArray(list)){list=[list];}
this.__rules__.forEach(function(rule){rule.enabled=false;});this.enable(list,ignoreInvalid);};Ruler.prototype.disable=function(list,ignoreInvalid){if(!Array.isArray(list)){list=[list];}
var result=[];list.forEach(function(name){var idx=this.__find__(name);if(idx<0){if(ignoreInvalid){return;}
throw new Error('Rules manager: invalid rule name '+name);}
this.__rules__[idx].enabled=false;result.push(name);},this);this.__cache__=null;return result;};Ruler.prototype.getRules=function(chainName){if(this.__cache__===null){this.__compile__();}
return this.__cache__[chainName]||[];};module.exports=Ruler;},{}],18:[function(require,module,exports){'use strict';var isSpace=require('../common/utils').isSpace;module.exports=function blockquote(state,startLine,endLine,silent){var adjustTab,ch,i,initial,l,lastLineEmpty,lines,nextLine,offset,oldBMarks,oldBSCount,oldIndent,oldParentType,oldSCount,oldTShift,spaceAfterMarker,terminate,terminatorRules,token,wasOutdented,oldLineMax=state.lineMax,pos=state.bMarks[startLine]+state.tShift[startLine],max=state.eMarks[startLine];if(state.sCount[startLine]-state.blkIndent>=4){return false;}
if(state.src.charCodeAt(pos++)!==0x3E){return false;}
if(silent){return true;}
initial=offset=state.sCount[startLine]+pos-(state.bMarks[startLine]+state.tShift[startLine]);if(state.src.charCodeAt(pos)===0x20){pos++;initial++;offset++;adjustTab=false;spaceAfterMarker=true;}else if(state.src.charCodeAt(pos)===0x09){spaceAfterMarker=true;if((state.bsCount[startLine]+offset)%4===3){pos++;initial++;offset++;adjustTab=false;}else{adjustTab=true;}}else{spaceAfterMarker=false;}
oldBMarks=[state.bMarks[startLine]];state.bMarks[startLine]=pos;while(pos<max){ch=state.src.charCodeAt(pos);if(isSpace(ch)){if(ch===0x09){offset+=4-(offset+state.bsCount[startLine]+(adjustTab?1:0))%4;}else{offset++;}}else{break;}
pos++;}
oldBSCount=[state.bsCount[startLine]];state.bsCount[startLine]=state.sCount[startLine]+1+(spaceAfterMarker?1:0);lastLineEmpty=pos>=max;oldSCount=[state.sCount[startLine]];state.sCount[startLine]=offset-initial;oldTShift=[state.tShift[startLine]];state.tShift[startLine]=pos-state.bMarks[startLine];terminatorRules=state.md.block.ruler.getRules('blockquote');oldParentType=state.parentType;state.parentType='blockquote';wasOutdented=false;for(nextLine=startLine+1;nextLine<endLine;nextLine++){if(state.sCount[nextLine]<state.blkIndent)wasOutdented=true;pos=state.bMarks[nextLine]+state.tShift[nextLine];max=state.eMarks[nextLine];if(pos>=max){break;}
if(state.src.charCodeAt(pos++)===0x3E&&!wasOutdented){initial=offset=state.sCount[nextLine]+pos-(state.bMarks[nextLine]+state.tShift[nextLine]);if(state.src.charCodeAt(pos)===0x20){pos++;initial++;offset++;adjustTab=false;spaceAfterMarker=true;}else if(state.src.charCodeAt(pos)===0x09){spaceAfterMarker=true;if((state.bsCount[nextLine]+offset)%4===3){pos++;initial++;offset++;adjustTab=false;}else{adjustTab=true;}}else{spaceAfterMarker=false;}
oldBMarks.push(state.bMarks[nextLine]);state.bMarks[nextLine]=pos;while(pos<max){ch=state.src.charCodeAt(pos);if(isSpace(ch)){if(ch===0x09){offset+=4-(offset+state.bsCount[nextLine]+(adjustTab?1:0))%4;}else{offset++;}}else{break;}
pos++;}
lastLineEmpty=pos>=max;oldBSCount.push(state.bsCount[nextLine]);state.bsCount[nextLine]=state.sCount[nextLine]+1+(spaceAfterMarker?1:0);oldSCount.push(state.sCount[nextLine]);state.sCount[nextLine]=offset-initial;oldTShift.push(state.tShift[nextLine]);state.tShift[nextLine]=pos-state.bMarks[nextLine];continue;}
if(lastLineEmpty){break;}
terminate=false;for(i=0,l=terminatorRules.length;i<l;i++){if(terminatorRules[i](state,nextLine,endLine,true)){terminate=true;break;}}
if(terminate){state.lineMax=nextLine;if(state.blkIndent!==0){oldBMarks.push(state.bMarks[nextLine]);oldBSCount.push(state.bsCount[nextLine]);oldTShift.push(state.tShift[nextLine]);oldSCount.push(state.sCount[nextLine]);state.sCount[nextLine]-=state.blkIndent;}
break;}
oldBMarks.push(state.bMarks[nextLine]);oldBSCount.push(state.bsCount[nextLine]);oldTShift.push(state.tShift[nextLine]);oldSCount.push(state.sCount[nextLine]);state.sCount[nextLine]=-1;}
oldIndent=state.blkIndent;state.blkIndent=0;token=state.push('blockquote_open','blockquote',1);token.markup='>';token.map=lines=[startLine,0];state.md.block.tokenize(state,startLine,nextLine);token=state.push('blockquote_close','blockquote',-1);token.markup='>';state.lineMax=oldLineMax;state.parentType=oldParentType;lines[1]=state.line;for(i=0;i<oldTShift.length;i++){state.bMarks[i+startLine]=oldBMarks[i];state.tShift[i+startLine]=oldTShift[i];state.sCount[i+startLine]=oldSCount[i];state.bsCount[i+startLine]=oldBSCount[i];}
state.blkIndent=oldIndent;return true;};},{"../common/utils":4}],19:[function(require,module,exports){'use strict';module.exports=function code(state,startLine,endLine){var nextLine,last,token;if(state.sCount[startLine]-state.blkIndent<4){return false;}
last=nextLine=startLine+1;while(nextLine<endLine){if(state.isEmpty(nextLine)){nextLine++;continue;}
if(state.sCount[nextLine]-state.blkIndent>=4){nextLine++;last=nextLine;continue;}
break;}
state.line=last;token=state.push('code_block','code',0);token.content=state.getLines(startLine,last,4+state.blkIndent,true);token.map=[startLine,state.line];return true;};},{}],20:[function(require,module,exports){'use strict';module.exports=function fence(state,startLine,endLine,silent){var marker,len,params,nextLine,mem,token,markup,haveEndMarker=false,pos=state.bMarks[startLine]+state.tShift[startLine],max=state.eMarks[startLine];if(state.sCount[startLine]-state.blkIndent>=4){return false;}
if(pos+3>max){return false;}
marker=state.src.charCodeAt(pos);if(marker!==0x7E&&marker!==0x60){return false;}
mem=pos;pos=state.skipChars(pos,marker);len=pos-mem;if(len<3){return false;}
markup=state.src.slice(mem,pos);params=state.src.slice(pos,max);if(params.indexOf(String.fromCharCode(marker))>=0){return false;}
if(silent){return true;}
nextLine=startLine;for(;;){nextLine++;if(nextLine>=endLine){break;}
pos=mem=state.bMarks[nextLine]+state.tShift[nextLine];max=state.eMarks[nextLine];if(pos<max&&state.sCount[nextLine]<state.blkIndent){break;}
if(state.src.charCodeAt(pos)!==marker){continue;}
if(state.sCount[nextLine]-state.blkIndent>=4){continue;}
pos=state.skipChars(pos,marker);if(pos-mem<len){continue;}
pos=state.skipSpaces(pos);if(pos<max){continue;}
haveEndMarker=true;break;}
len=state.sCount[startLine];state.line=nextLine+(haveEndMarker?1:0);token=state.push('fence','code',0);token.info=params;token.content=state.getLines(startLine+1,nextLine,len,true);token.markup=markup;token.map=[startLine,state.line];return true;};},{}],21:[function(require,module,exports){'use strict';var isSpace=require('../common/utils').isSpace;module.exports=function heading(state,startLine,endLine,silent){var ch,level,tmp,token,pos=state.bMarks[startLine]+state.tShift[startLine],max=state.eMarks[startLine];if(state.sCount[startLine]-state.blkIndent>=4){return false;}
ch=state.src.charCodeAt(pos);if(ch!==0x23||pos>=max){return false;}
level=1;ch=state.src.charCodeAt(++pos);while(ch===0x23&&pos<max&&level<=6){level++;ch=state.src.charCodeAt(++pos);}
if(level>6||(pos<max&&!isSpace(ch))){return false;}
if(silent){return true;}
max=state.skipSpacesBack(max,pos);tmp=state.skipCharsBack(max,0x23,pos);if(tmp>pos&&isSpace(state.src.charCodeAt(tmp-1))){max=tmp;}
state.line=startLine+1;token=state.push('heading_open','h'+String(level),1);token.markup='########'.slice(0,level);token.map=[startLine,state.line];token=state.push('inline','',0);token.content=state.src.slice(pos,max).trim();token.map=[startLine,state.line];token.children=[];token=state.push('heading_close','h'+String(level),-1);token.markup='########'.slice(0,level);return true;};},{"../common/utils":4}],22:[function(require,module,exports){'use strict';var isSpace=require('../common/utils').isSpace;module.exports=function hr(state,startLine,endLine,silent){var marker,cnt,ch,token,pos=state.bMarks[startLine]+state.tShift[startLine],max=state.eMarks[startLine];if(state.sCount[startLine]-state.blkIndent>=4){return false;}
marker=state.src.charCodeAt(pos++);if(marker!==0x2A&&marker!==0x2D&&marker!==0x5F){return false;}
cnt=1;while(pos<max){ch=state.src.charCodeAt(pos++);if(ch!==marker&&!isSpace(ch)){return false;}
if(ch===marker){cnt++;}}
if(cnt<3){return false;}
if(silent){return true;}
state.line=startLine+1;token=state.push('hr','hr',0);token.map=[startLine,state.line];token.markup=Array(cnt+1).join(String.fromCharCode(marker));return true;};},{"../common/utils":4}],23:[function(require,module,exports){'use strict';var block_names=require('../common/html_blocks');var HTML_OPEN_CLOSE_TAG_RE=require('../common/html_re').HTML_OPEN_CLOSE_TAG_RE;var HTML_SEQUENCES=[[/^<(script|pre|style)(?=(\s|>|$))/i,/<\/(script|pre|style)>/i,true],[/^<!--/,/-->/,true],[/^<\?/,/\?>/,true],[/^<![A-Z]/,/>/,true],[/^<!\[CDATA\[/,/\]\]>/,true],[new RegExp('^</?('+block_names.join('|')+')(?=(\\s|/?>|$))','i'),/^$/,true],[new RegExp(HTML_OPEN_CLOSE_TAG_RE.source+'\\s*$'),/^$/,false]];module.exports=function html_block(state,startLine,endLine,silent){var i,nextLine,token,lineText,pos=state.bMarks[startLine]+state.tShift[startLine],max=state.eMarks[startLine];if(state.sCount[startLine]-state.blkIndent>=4){return false;}
if(!state.md.options.html){return false;}
if(state.src.charCodeAt(pos)!==0x3C){return false;}
lineText=state.src.slice(pos,max);for(i=0;i<HTML_SEQUENCES.length;i++){if(HTML_SEQUENCES[i][0].test(lineText)){break;}}
if(i===HTML_SEQUENCES.length){return false;}
if(silent){return HTML_SEQUENCES[i][2];}
nextLine=startLine+1;if(!HTML_SEQUENCES[i][1].test(lineText)){for(;nextLine<endLine;nextLine++){if(state.sCount[nextLine]<state.blkIndent){break;}
pos=state.bMarks[nextLine]+state.tShift[nextLine];max=state.eMarks[nextLine];lineText=state.src.slice(pos,max);if(HTML_SEQUENCES[i][1].test(lineText)){if(lineText.length!==0){nextLine++;}
break;}}}
state.line=nextLine;token=state.push('html_block','',0);token.map=[startLine,nextLine];token.content=state.getLines(startLine,nextLine,state.blkIndent,true);return true;};},{"../common/html_blocks":2,"../common/html_re":3}],24:[function(require,module,exports){'use strict';module.exports=function lheading(state,startLine,endLine){var content,terminate,i,l,token,pos,max,level,marker,nextLine=startLine+1,oldParentType,terminatorRules=state.md.block.ruler.getRules('paragraph');if(state.sCount[startLine]-state.blkIndent>=4){return false;}
oldParentType=state.parentType;state.parentType='paragraph';for(;nextLine<endLine&&!state.isEmpty(nextLine);nextLine++){if(state.sCount[nextLine]-state.blkIndent>3){continue;}
if(state.sCount[nextLine]>=state.blkIndent){pos=state.bMarks[nextLine]+state.tShift[nextLine];max=state.eMarks[nextLine];if(pos<max){marker=state.src.charCodeAt(pos);if(marker===0x2D||marker===0x3D){pos=state.skipChars(pos,marker);pos=state.skipSpaces(pos);if(pos>=max){level=(marker===0x3D?1:2);break;}}}}
if(state.sCount[nextLine]<0){continue;}
terminate=false;for(i=0,l=terminatorRules.length;i<l;i++){if(terminatorRules[i](state,nextLine,endLine,true)){terminate=true;break;}}
if(terminate){break;}}
if(!level){return false;}
content=state.getLines(startLine,nextLine,state.blkIndent,false).trim();state.line=nextLine+1;token=state.push('heading_open','h'+String(level),1);token.markup=String.fromCharCode(marker);token.map=[startLine,state.line];token=state.push('inline','',0);token.content=content;token.map=[startLine,state.line-1];token.children=[];token=state.push('heading_close','h'+String(level),-1);token.markup=String.fromCharCode(marker);state.parentType=oldParentType;return true;};},{}],25:[function(require,module,exports){'use strict';var isSpace=require('../common/utils').isSpace;function skipBulletListMarker(state,startLine){var marker,pos,max,ch;pos=state.bMarks[startLine]+state.tShift[startLine];max=state.eMarks[startLine];marker=state.src.charCodeAt(pos++);if(marker!==0x2A&&marker!==0x2D&&marker!==0x2B){return-1;}
if(pos<max){ch=state.src.charCodeAt(pos);if(!isSpace(ch)){return-1;}}
return pos;}
function skipOrderedListMarker(state,startLine){var ch,start=state.bMarks[startLine]+state.tShift[startLine],pos=start,max=state.eMarks[startLine];if(pos+1>=max){return-1;}
ch=state.src.charCodeAt(pos++);if(ch<0x30||ch>0x39){return-1;}
for(;;){if(pos>=max){return-1;}
ch=state.src.charCodeAt(pos++);if(ch>=0x30&&ch<=0x39){if(pos-start>=10){return-1;}
continue;}
if(ch===0x29||ch===0x2e){break;}
return-1;}
if(pos<max){ch=state.src.charCodeAt(pos);if(!isSpace(ch)){return-1;}}
return pos;}
function markTightParagraphs(state,idx){var i,l,level=state.level+2;for(i=idx+2,l=state.tokens.length-2;i<l;i++){if(state.tokens[i].level===level&&state.tokens[i].type==='paragraph_open'){state.tokens[i+2].hidden=true;state.tokens[i].hidden=true;i+=2;}}}
module.exports=function list(state,startLine,endLine,silent){var ch,contentStart,i,indent,indentAfterMarker,initial,isOrdered,itemLines,l,listLines,listTokIdx,markerCharCode,markerValue,max,nextLine,offset,oldIndent,oldLIndent,oldParentType,oldTShift,oldTight,pos,posAfterMarker,prevEmptyEnd,start,terminate,terminatorRules,token,isTerminatingParagraph=false,tight=true;if(state.sCount[startLine]-state.blkIndent>=4){return false;}
if(silent&&state.parentType==='paragraph'){if(state.tShift[startLine]>=state.blkIndent){isTerminatingParagraph=true;}}
if((posAfterMarker=skipOrderedListMarker(state,startLine))>=0){isOrdered=true;start=state.bMarks[startLine]+state.tShift[startLine];markerValue=Number(state.src.substr(start,posAfterMarker-start-1));if(isTerminatingParagraph&&markerValue!==1)return false;}else if((posAfterMarker=skipBulletListMarker(state,startLine))>=0){isOrdered=false;}else{return false;}
if(isTerminatingParagraph){if(state.skipSpaces(posAfterMarker)>=state.eMarks[startLine])return false;}
markerCharCode=state.src.charCodeAt(posAfterMarker-1);if(silent){return true;}
listTokIdx=state.tokens.length;if(isOrdered){token=state.push('ordered_list_open','ol',1);if(markerValue!==1){token.attrs=[['start',markerValue]];}}else{token=state.push('bullet_list_open','ul',1);}
token.map=listLines=[startLine,0];token.markup=String.fromCharCode(markerCharCode);nextLine=startLine;prevEmptyEnd=false;terminatorRules=state.md.block.ruler.getRules('list');oldParentType=state.parentType;state.parentType='list';while(nextLine<endLine){pos=posAfterMarker;max=state.eMarks[nextLine];initial=offset=state.sCount[nextLine]+posAfterMarker-(state.bMarks[startLine]+state.tShift[startLine]);while(pos<max){ch=state.src.charCodeAt(pos);if(ch===0x09){offset+=4-(offset+state.bsCount[nextLine])%4;}else if(ch===0x20){offset++;}else{break;}
pos++;}
contentStart=pos;if(contentStart>=max){indentAfterMarker=1;}else{indentAfterMarker=offset-initial;}
if(indentAfterMarker>4){indentAfterMarker=1;}
indent=initial+indentAfterMarker;token=state.push('list_item_open','li',1);token.markup=String.fromCharCode(markerCharCode);token.map=itemLines=[startLine,0];oldIndent=state.blkIndent;oldTight=state.tight;oldTShift=state.tShift[startLine];oldLIndent=state.sCount[startLine];state.blkIndent=indent;state.tight=true;state.tShift[startLine]=contentStart-state.bMarks[startLine];state.sCount[startLine]=offset;if(contentStart>=max&&state.isEmpty(startLine+1)){state.line=Math.min(state.line+2,endLine);}else{state.md.block.tokenize(state,startLine,endLine,true);}
if(!state.tight||prevEmptyEnd){tight=false;}
prevEmptyEnd=(state.line-startLine)>1&&state.isEmpty(state.line-1);state.blkIndent=oldIndent;state.tShift[startLine]=oldTShift;state.sCount[startLine]=oldLIndent;state.tight=oldTight;token=state.push('list_item_close','li',-1);token.markup=String.fromCharCode(markerCharCode);nextLine=startLine=state.line;itemLines[1]=nextLine;contentStart=state.bMarks[startLine];if(nextLine>=endLine){break;}
if(state.sCount[nextLine]<state.blkIndent){break;}
terminate=false;for(i=0,l=terminatorRules.length;i<l;i++){if(terminatorRules[i](state,nextLine,endLine,true)){terminate=true;break;}}
if(terminate){break;}
if(isOrdered){posAfterMarker=skipOrderedListMarker(state,nextLine);if(posAfterMarker<0){break;}}else{posAfterMarker=skipBulletListMarker(state,nextLine);if(posAfterMarker<0){break;}}
if(markerCharCode!==state.src.charCodeAt(posAfterMarker-1)){break;}}
if(isOrdered){token=state.push('ordered_list_close','ol',-1);}else{token=state.push('bullet_list_close','ul',-1);}
token.markup=String.fromCharCode(markerCharCode);listLines[1]=nextLine;state.line=nextLine;state.parentType=oldParentType;if(tight){markTightParagraphs(state,listTokIdx);}
return true;};},{"../common/utils":4}],26:[function(require,module,exports){'use strict';module.exports=function paragraph(state,startLine){var content,terminate,i,l,token,oldParentType,nextLine=startLine+1,terminatorRules=state.md.block.ruler.getRules('paragraph'),endLine=state.lineMax;oldParentType=state.parentType;state.parentType='paragraph';for(;nextLine<endLine&&!state.isEmpty(nextLine);nextLine++){if(state.sCount[nextLine]-state.blkIndent>3){continue;}
if(state.sCount[nextLine]<0){continue;}
terminate=false;for(i=0,l=terminatorRules.length;i<l;i++){if(terminatorRules[i](state,nextLine,endLine,true)){terminate=true;break;}}
if(terminate){break;}}
content=state.getLines(startLine,nextLine,state.blkIndent,false).trim();state.line=nextLine;token=state.push('paragraph_open','p',1);token.map=[startLine,state.line];token=state.push('inline','',0);token.content=content;token.map=[startLine,state.line];token.children=[];token=state.push('paragraph_close','p',-1);state.parentType=oldParentType;return true;};},{}],27:[function(require,module,exports){'use strict';var normalizeReference=require('../common/utils').normalizeReference;var isSpace=require('../common/utils').isSpace;module.exports=function reference(state,startLine,_endLine,silent){var ch,destEndPos,destEndLineNo,endLine,href,i,l,label,labelEnd,oldParentType,res,start,str,terminate,terminatorRules,title,lines=0,pos=state.bMarks[startLine]+state.tShift[startLine],max=state.eMarks[startLine],nextLine=startLine+1;if(state.sCount[startLine]-state.blkIndent>=4){return false;}
if(state.src.charCodeAt(pos)!==0x5B){return false;}
while(++pos<max){if(state.src.charCodeAt(pos)===0x5D&&state.src.charCodeAt(pos-1)!==0x5C){if(pos+1===max){return false;}
if(state.src.charCodeAt(pos+1)!==0x3A){return false;}
break;}}
endLine=state.lineMax;terminatorRules=state.md.block.ruler.getRules('reference');oldParentType=state.parentType;state.parentType='reference';for(;nextLine<endLine&&!state.isEmpty(nextLine);nextLine++){if(state.sCount[nextLine]-state.blkIndent>3){continue;}
if(state.sCount[nextLine]<0){continue;}
terminate=false;for(i=0,l=terminatorRules.length;i<l;i++){if(terminatorRules[i](state,nextLine,endLine,true)){terminate=true;break;}}
if(terminate){break;}}
str=state.getLines(startLine,nextLine,state.blkIndent,false).trim();max=str.length;for(pos=1;pos<max;pos++){ch=str.charCodeAt(pos);if(ch===0x5B){return false;}else if(ch===0x5D){labelEnd=pos;break;}else if(ch===0x0A){lines++;}else if(ch===0x5C){pos++;if(pos<max&&str.charCodeAt(pos)===0x0A){lines++;}}}
if(labelEnd<0||str.charCodeAt(labelEnd+1)!==0x3A){return false;}
for(pos=labelEnd+2;pos<max;pos++){ch=str.charCodeAt(pos);if(ch===0x0A){lines++;}else if(isSpace(ch)){}else{break;}}
res=state.md.helpers.parseLinkDestination(str,pos,max);if(!res.ok){return false;}
href=state.md.normalizeLink(res.str);if(!state.md.validateLink(href)){return false;}
pos=res.pos;lines+=res.lines;destEndPos=pos;destEndLineNo=lines;start=pos;for(;pos<max;pos++){ch=str.charCodeAt(pos);if(ch===0x0A){lines++;}else if(isSpace(ch)){}else{break;}}
res=state.md.helpers.parseLinkTitle(str,pos,max);if(pos<max&&start!==pos&&res.ok){title=res.str;pos=res.pos;lines+=res.lines;}else{title='';pos=destEndPos;lines=destEndLineNo;}
while(pos<max){ch=str.charCodeAt(pos);if(!isSpace(ch)){break;}
pos++;}
if(pos<max&&str.charCodeAt(pos)!==0x0A){if(title){title='';pos=destEndPos;lines=destEndLineNo;while(pos<max){ch=str.charCodeAt(pos);if(!isSpace(ch)){break;}
pos++;}}}
if(pos<max&&str.charCodeAt(pos)!==0x0A){return false;}
label=normalizeReference(str.slice(1,labelEnd));if(!label){return false;}
if(silent){return true;}
if(typeof state.env.references==='undefined'){state.env.references={};}
if(typeof state.env.references[label]==='undefined'){state.env.references[label]={title:title,href:href};}
state.parentType=oldParentType;state.line=startLine+lines+1;return true;};},{"../common/utils":4}],28:[function(require,module,exports){'use strict';var Token=require('../token');var isSpace=require('../common/utils').isSpace;function StateBlock(src,md,env,tokens){var ch,s,start,pos,len,indent,offset,indent_found;this.src=src;this.md=md;this.env=env;this.tokens=tokens;this.bMarks=[];this.eMarks=[];this.tShift=[];this.sCount=[];this.bsCount=[];this.blkIndent=0;this.line=0;this.lineMax=0;this.tight=false;this.ddIndent=-1;this.parentType='root';this.level=0;this.result='';s=this.src;indent_found=false;for(start=pos=indent=offset=0,len=s.length;pos<len;pos++){ch=s.charCodeAt(pos);if(!indent_found){if(isSpace(ch)){indent++;if(ch===0x09){offset+=4-offset%4;}else{offset++;}
continue;}else{indent_found=true;}}
if(ch===0x0A||pos===len-1){if(ch!==0x0A){pos++;}
this.bMarks.push(start);this.eMarks.push(pos);this.tShift.push(indent);this.sCount.push(offset);this.bsCount.push(0);indent_found=false;indent=0;offset=0;start=pos+1;}}
this.bMarks.push(s.length);this.eMarks.push(s.length);this.tShift.push(0);this.sCount.push(0);this.bsCount.push(0);this.lineMax=this.bMarks.length-1;}
StateBlock.prototype.push=function(type,tag,nesting){var token=new Token(type,tag,nesting);token.block=true;if(nesting<0){this.level--;}
token.level=this.level;if(nesting>0){this.level++;}
this.tokens.push(token);return token;};StateBlock.prototype.isEmpty=function isEmpty(line){return this.bMarks[line]+this.tShift[line]>=this.eMarks[line];};StateBlock.prototype.skipEmptyLines=function skipEmptyLines(from){for(var max=this.lineMax;from<max;from++){if(this.bMarks[from]+this.tShift[from]<this.eMarks[from]){break;}}
return from;};StateBlock.prototype.skipSpaces=function skipSpaces(pos){var ch;for(var max=this.src.length;pos<max;pos++){ch=this.src.charCodeAt(pos);if(!isSpace(ch)){break;}}
return pos;};StateBlock.prototype.skipSpacesBack=function skipSpacesBack(pos,min){if(pos<=min){return pos;}
while(pos>min){if(!isSpace(this.src.charCodeAt(--pos))){return pos+1;}}
return pos;};StateBlock.prototype.skipChars=function skipChars(pos,code){for(var max=this.src.length;pos<max;pos++){if(this.src.charCodeAt(pos)!==code){break;}}
return pos;};StateBlock.prototype.skipCharsBack=function skipCharsBack(pos,code,min){if(pos<=min){return pos;}
while(pos>min){if(code!==this.src.charCodeAt(--pos)){return pos+1;}}
return pos;};StateBlock.prototype.getLines=function getLines(begin,end,indent,keepLastLF){var i,lineIndent,ch,first,last,queue,lineStart,line=begin;if(begin>=end){return'';}
queue=new Array(end-begin);for(i=0;line<end;line++,i++){lineIndent=0;lineStart=first=this.bMarks[line];if(line+1<end||keepLastLF){last=this.eMarks[line]+1;}else{last=this.eMarks[line];}
while(first<last&&lineIndent<indent){ch=this.src.charCodeAt(first);if(isSpace(ch)){if(ch===0x09){lineIndent+=4-(lineIndent+this.bsCount[line])%4;}else{lineIndent++;}}else if(first-lineStart<this.tShift[line]){lineIndent++;}else{break;}
first++;}
if(lineIndent>indent){queue[i]=new Array(lineIndent-indent+1).join(' ')+this.src.slice(first,last);}else{queue[i]=this.src.slice(first,last);}}
return queue.join('');};StateBlock.prototype.Token=Token;module.exports=StateBlock;},{"../common/utils":4,"../token":51}],29:[function(require,module,exports){'use strict';var isSpace=require('../common/utils').isSpace;function getLine(state,line){var pos=state.bMarks[line]+state.blkIndent,max=state.eMarks[line];return state.src.substr(pos,max-pos);}
function escapedSplit(str){var result=[],pos=0,max=str.length,ch,escapes=0,lastPos=0,backTicked=false,lastBackTick=0;ch=str.charCodeAt(pos);while(pos<max){if(ch===0x60){if(backTicked){backTicked=false;lastBackTick=pos;}else if(escapes%2===0){backTicked=true;lastBackTick=pos;}}else if(ch===0x7c&&(escapes%2===0)&&!backTicked){result.push(str.substring(lastPos,pos));lastPos=pos+1;}
if(ch===0x5c){escapes++;}else{escapes=0;}
pos++;if(pos===max&&backTicked){backTicked=false;pos=lastBackTick+1;}
ch=str.charCodeAt(pos);}
result.push(str.substring(lastPos));return result;}
module.exports=function table(state,startLine,endLine,silent){var ch,lineText,pos,i,nextLine,columns,columnCount,token,aligns,t,tableLines,tbodyLines;if(startLine+2>endLine){return false;}
nextLine=startLine+1;if(state.sCount[nextLine]<state.blkIndent){return false;}
if(state.sCount[nextLine]-state.blkIndent>=4){return false;}
pos=state.bMarks[nextLine]+state.tShift[nextLine];if(pos>=state.eMarks[nextLine]){return false;}
ch=state.src.charCodeAt(pos++);if(ch!==0x7C&&ch!==0x2D&&ch!==0x3A){return false;}
while(pos<state.eMarks[nextLine]){ch=state.src.charCodeAt(pos);if(ch!==0x7C&&ch!==0x2D&&ch!==0x3A&&!isSpace(ch)){return false;}
pos++;}
lineText=getLine(state,startLine+1);columns=lineText.split('|');aligns=[];for(i=0;i<columns.length;i++){t=columns[i].trim();if(!t){if(i===0||i===columns.length-1){continue;}else{return false;}}
if(!/^:?-+:?$/.test(t)){return false;}
if(t.charCodeAt(t.length-1)===0x3A){aligns.push(t.charCodeAt(0)===0x3A?'center':'right');}else if(t.charCodeAt(0)===0x3A){aligns.push('left');}else{aligns.push('');}}
lineText=getLine(state,startLine).trim();if(lineText.indexOf('|')===-1){return false;}
if(state.sCount[startLine]-state.blkIndent>=4){return false;}
columns=escapedSplit(lineText.replace(/^\||\|$/g,''));columnCount=columns.length;if(columnCount>aligns.length){return false;}
if(silent){return true;}
token=state.push('table_open','table',1);token.map=tableLines=[startLine,0];token=state.push('thead_open','thead',1);token.map=[startLine,startLine+1];token=state.push('tr_open','tr',1);token.map=[startLine,startLine+1];for(i=0;i<columns.length;i++){token=state.push('th_open','th',1);token.map=[startLine,startLine+1];if(aligns[i]){token.attrs=[['style','text-align:'+aligns[i]]];}
token=state.push('inline','',0);token.content=columns[i].trim();token.map=[startLine,startLine+1];token.children=[];token=state.push('th_close','th',-1);}
token=state.push('tr_close','tr',-1);token=state.push('thead_close','thead',-1);token=state.push('tbody_open','tbody',1);token.map=tbodyLines=[startLine+2,0];for(nextLine=startLine+2;nextLine<endLine;nextLine++){if(state.sCount[nextLine]<state.blkIndent){break;}
lineText=getLine(state,nextLine).trim();if(lineText.indexOf('|')===-1){break;}
if(state.sCount[nextLine]-state.blkIndent>=4){break;}
columns=escapedSplit(lineText.replace(/^\||\|$/g,''));token=state.push('tr_open','tr',1);for(i=0;i<columnCount;i++){token=state.push('td_open','td',1);if(aligns[i]){token.attrs=[['style','text-align:'+aligns[i]]];}
token=state.push('inline','',0);token.content=columns[i]?columns[i].trim():'';token.children=[];token=state.push('td_close','td',-1);}
token=state.push('tr_close','tr',-1);}
token=state.push('tbody_close','tbody',-1);token=state.push('table_close','table',-1);tableLines[1]=tbodyLines[1]=nextLine;state.line=nextLine;return true;};},{"../common/utils":4}],30:[function(require,module,exports){'use strict';module.exports=function block(state){var token;if(state.inlineMode){token=new state.Token('inline','',0);token.content=state.src;token.map=[0,1];token.children=[];state.tokens.push(token);}else{state.md.block.parse(state.src,state.md,state.env,state.tokens);}};},{}],31:[function(require,module,exports){'use strict';module.exports=function inline(state){var tokens=state.tokens,tok,i,l;for(i=0,l=tokens.length;i<l;i++){tok=tokens[i];if(tok.type==='inline'){state.md.inline.parse(tok.content,state.md,state.env,tok.children);}}};},{}],32:[function(require,module,exports){'use strict';var arrayReplaceAt=require('../common/utils').arrayReplaceAt;function isLinkOpen(str){return/^<a[>\s]/i.test(str);}
function isLinkClose(str){return/^<\/a\s*>/i.test(str);}
module.exports=function linkify(state){var i,j,l,tokens,token,currentToken,nodes,ln,text,pos,lastPos,level,htmlLinkLevel,url,fullUrl,urlText,blockTokens=state.tokens,links;if(!state.md.options.linkify){return;}
for(j=0,l=blockTokens.length;j<l;j++){if(blockTokens[j].type!=='inline'||!state.md.linkify.pretest(blockTokens[j].content)){continue;}
tokens=blockTokens[j].children;htmlLinkLevel=0;for(i=tokens.length-1;i>=0;i--){currentToken=tokens[i];if(currentToken.type==='link_close'){i--;while(tokens[i].level!==currentToken.level&&tokens[i].type!=='link_open'){i--;}
continue;}
if(currentToken.type==='html_inline'){if(isLinkOpen(currentToken.content)&&htmlLinkLevel>0){htmlLinkLevel--;}
if(isLinkClose(currentToken.content)){htmlLinkLevel++;}}
if(htmlLinkLevel>0){continue;}
if(currentToken.type==='text'&&state.md.linkify.test(currentToken.content)){text=currentToken.content;links=state.md.linkify.match(text);nodes=[];level=currentToken.level;lastPos=0;for(ln=0;ln<links.length;ln++){url=links[ln].url;fullUrl=state.md.normalizeLink(url);if(!state.md.validateLink(fullUrl)){continue;}
urlText=links[ln].text;if(!links[ln].schema){urlText=state.md.normalizeLinkText('http://'+urlText).replace(/^http:\/\//,'');}else if(links[ln].schema==='mailto:'&&!/^mailto:/i.test(urlText)){urlText=state.md.normalizeLinkText('mailto:'+urlText).replace(/^mailto:/,'');}else{urlText=state.md.normalizeLinkText(urlText);}
pos=links[ln].index;if(pos>lastPos){token=new state.Token('text','',0);token.content=text.slice(lastPos,pos);token.level=level;nodes.push(token);}
token=new state.Token('link_open','a',1);token.attrs=[['href',fullUrl]];token.level=level++;token.markup='linkify';token.info='auto';nodes.push(token);token=new state.Token('text','',0);token.content=urlText;token.level=level;nodes.push(token);token=new state.Token('link_close','a',-1);token.level=--level;token.markup='linkify';token.info='auto';nodes.push(token);lastPos=links[ln].lastIndex;}
if(lastPos<text.length){token=new state.Token('text','',0);token.content=text.slice(lastPos);token.level=level;nodes.push(token);}
blockTokens[j].children=tokens=arrayReplaceAt(tokens,i,nodes);}}}};},{"../common/utils":4}],33:[function(require,module,exports){'use strict';var NEWLINES_RE=/\r[\n\u0085]?|[\u2424\u2028\u0085]/g;var NULL_RE=/\u0000/g;module.exports=function inline(state){var str;str=state.src.replace(NEWLINES_RE,'\n');str=str.replace(NULL_RE,'\uFFFD');state.src=str;};},{}],34:[function(require,module,exports){'use strict';var RARE_RE=/\+-|\.\.|\?\?\?\?|!!!!|,,|--/;var SCOPED_ABBR_TEST_RE=/\((c|tm|r|p)\)/i;var SCOPED_ABBR_RE=/\((c|tm|r|p)\)/ig;var SCOPED_ABBR={c:'Â©',r:'Â®',p:'Â§',tm:'â„¢'};function replaceFn(match,name){return SCOPED_ABBR[name.toLowerCase()];}
function replace_scoped(inlineTokens){var i,token,inside_autolink=0;for(i=inlineTokens.length-1;i>=0;i--){token=inlineTokens[i];if(token.type==='text'&&!inside_autolink){token.content=token.content.replace(SCOPED_ABBR_RE,replaceFn);}
if(token.type==='link_open'&&token.info==='auto'){inside_autolink--;}
if(token.type==='link_close'&&token.info==='auto'){inside_autolink++;}}}
function replace_rare(inlineTokens){var i,token,inside_autolink=0;for(i=inlineTokens.length-1;i>=0;i--){token=inlineTokens[i];if(token.type==='text'&&!inside_autolink){if(RARE_RE.test(token.content)){token.content=token.content.replace(/\+-/g,'Â±').replace(/\.{2,}/g,'â€¦').replace(/([?!])â€¦/g,'$1..').replace(/([?!]){4,}/g,'$1$1$1').replace(/,{2,}/g,',').replace(/(^|[^-])---([^-]|$)/mg,'$1\u2014$2').replace(/(^|\s)--(\s|$)/mg,'$1\u2013$2').replace(/(^|[^-\s])--([^-\s]|$)/mg,'$1\u2013$2');}}
if(token.type==='link_open'&&token.info==='auto'){inside_autolink--;}
if(token.type==='link_close'&&token.info==='auto'){inside_autolink++;}}}
module.exports=function replace(state){var blkIdx;if(!state.md.options.typographer){return;}
for(blkIdx=state.tokens.length-1;blkIdx>=0;blkIdx--){if(state.tokens[blkIdx].type!=='inline'){continue;}
if(SCOPED_ABBR_TEST_RE.test(state.tokens[blkIdx].content)){replace_scoped(state.tokens[blkIdx].children);}
if(RARE_RE.test(state.tokens[blkIdx].content)){replace_rare(state.tokens[blkIdx].children);}}};},{}],35:[function(require,module,exports){'use strict';var isWhiteSpace=require('../common/utils').isWhiteSpace;var isPunctChar=require('../common/utils').isPunctChar;var isMdAsciiPunct=require('../common/utils').isMdAsciiPunct;var QUOTE_TEST_RE=/['"]/;var QUOTE_RE=/['"]/g;var APOSTROPHE='\u2019';function replaceAt(str,index,ch){return str.substr(0,index)+ch+str.substr(index+1);}
function process_inlines(tokens,state){var i,token,text,t,pos,max,thisLevel,item,lastChar,nextChar,isLastPunctChar,isNextPunctChar,isLastWhiteSpace,isNextWhiteSpace,canOpen,canClose,j,isSingle,stack,openQuote,closeQuote;stack=[];for(i=0;i<tokens.length;i++){token=tokens[i];thisLevel=tokens[i].level;for(j=stack.length-1;j>=0;j--){if(stack[j].level<=thisLevel){break;}}
stack.length=j+1;if(token.type!=='text'){continue;}
text=token.content;pos=0;max=text.length;OUTER:while(pos<max){QUOTE_RE.lastIndex=pos;t=QUOTE_RE.exec(text);if(!t){break;}
canOpen=canClose=true;pos=t.index+1;isSingle=(t[0]==="'");lastChar=0x20;if(t.index-1>=0){lastChar=text.charCodeAt(t.index-1);}else{for(j=i-1;j>=0;j--){if(tokens[j].type==='softbreak'||tokens[j].type==='hardbreak')break;if(tokens[j].type!=='text')continue;lastChar=tokens[j].content.charCodeAt(tokens[j].content.length-1);break;}}
nextChar=0x20;if(pos<max){nextChar=text.charCodeAt(pos);}else{for(j=i+1;j<tokens.length;j++){if(tokens[j].type==='softbreak'||tokens[j].type==='hardbreak')break;if(tokens[j].type!=='text')continue;nextChar=tokens[j].content.charCodeAt(0);break;}}
isLastPunctChar=isMdAsciiPunct(lastChar)||isPunctChar(String.fromCharCode(lastChar));isNextPunctChar=isMdAsciiPunct(nextChar)||isPunctChar(String.fromCharCode(nextChar));isLastWhiteSpace=isWhiteSpace(lastChar);isNextWhiteSpace=isWhiteSpace(nextChar);if(isNextWhiteSpace){canOpen=false;}else if(isNextPunctChar){if(!(isLastWhiteSpace||isLastPunctChar)){canOpen=false;}}
if(isLastWhiteSpace){canClose=false;}else if(isLastPunctChar){if(!(isNextWhiteSpace||isNextPunctChar)){canClose=false;}}
if(nextChar===0x22&&t[0]==='"'){if(lastChar>=0x30&&lastChar<=0x39){canClose=canOpen=false;}}
if(canOpen&&canClose){canOpen=false;canClose=isNextPunctChar;}
if(!canOpen&&!canClose){if(isSingle){token.content=replaceAt(token.content,t.index,APOSTROPHE);}
continue;}
if(canClose){for(j=stack.length-1;j>=0;j--){item=stack[j];if(stack[j].level<thisLevel){break;}
if(item.single===isSingle&&stack[j].level===thisLevel){item=stack[j];if(isSingle){openQuote=state.md.options.quotes[2];closeQuote=state.md.options.quotes[3];}else{openQuote=state.md.options.quotes[0];closeQuote=state.md.options.quotes[1];}
token.content=replaceAt(token.content,t.index,closeQuote);tokens[item.token].content=replaceAt(tokens[item.token].content,item.pos,openQuote);pos+=closeQuote.length-1;if(item.token===i){pos+=openQuote.length-1;}
text=token.content;max=text.length;stack.length=j;continue OUTER;}}}
if(canOpen){stack.push({token:i,pos:t.index,single:isSingle,level:thisLevel});}else if(canClose&&isSingle){token.content=replaceAt(token.content,t.index,APOSTROPHE);}}}}
module.exports=function smartquotes(state){var blkIdx;if(!state.md.options.typographer){return;}
for(blkIdx=state.tokens.length-1;blkIdx>=0;blkIdx--){if(state.tokens[blkIdx].type!=='inline'||!QUOTE_TEST_RE.test(state.tokens[blkIdx].content)){continue;}
process_inlines(state.tokens[blkIdx].children,state);}};},{"../common/utils":4}],36:[function(require,module,exports){'use strict';var Token=require('../token');function StateCore(src,md,env){this.src=src;this.env=env;this.tokens=[];this.inlineMode=false;this.md=md;}
StateCore.prototype.Token=Token;module.exports=StateCore;},{"../token":51}],37:[function(require,module,exports){'use strict';var EMAIL_RE=/^<([a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*)>/;var AUTOLINK_RE=/^<([a-zA-Z][a-zA-Z0-9+.\-]{1,31}):([^<>\x00-\x20]*)>/;module.exports=function autolink(state,silent){var tail,linkMatch,emailMatch,url,fullUrl,token,pos=state.pos;if(state.src.charCodeAt(pos)!==0x3C){return false;}
tail=state.src.slice(pos);if(tail.indexOf('>')<0){return false;}
if(AUTOLINK_RE.test(tail)){linkMatch=tail.match(AUTOLINK_RE);url=linkMatch[0].slice(1,-1);fullUrl=state.md.normalizeLink(url);if(!state.md.validateLink(fullUrl)){return false;}
if(!silent){token=state.push('link_open','a',1);token.attrs=[['href',fullUrl]];token.markup='autolink';token.info='auto';token=state.push('text','',0);token.content=state.md.normalizeLinkText(url);token=state.push('link_close','a',-1);token.markup='autolink';token.info='auto';}
state.pos+=linkMatch[0].length;return true;}
if(EMAIL_RE.test(tail)){emailMatch=tail.match(EMAIL_RE);url=emailMatch[0].slice(1,-1);fullUrl=state.md.normalizeLink('mailto:'+url);if(!state.md.validateLink(fullUrl)){return false;}
if(!silent){token=state.push('link_open','a',1);token.attrs=[['href',fullUrl]];token.markup='autolink';token.info='auto';token=state.push('text','',0);token.content=state.md.normalizeLinkText(url);token=state.push('link_close','a',-1);token.markup='autolink';token.info='auto';}
state.pos+=emailMatch[0].length;return true;}
return false;};},{}],38:[function(require,module,exports){'use strict';module.exports=function backtick(state,silent){var start,max,marker,matchStart,matchEnd,token,pos=state.pos,ch=state.src.charCodeAt(pos);if(ch!==0x60){return false;}
start=pos;pos++;max=state.posMax;while(pos<max&&state.src.charCodeAt(pos)===0x60){pos++;}
marker=state.src.slice(start,pos);matchStart=matchEnd=pos;while((matchStart=state.src.indexOf('`',matchEnd))!==-1){matchEnd=matchStart+1;while(matchEnd<max&&state.src.charCodeAt(matchEnd)===0x60){matchEnd++;}
if(matchEnd-matchStart===marker.length){if(!silent){token=state.push('code_inline','code',0);token.markup=marker;token.content=state.src.slice(pos,matchStart).replace(/[ \n]+/g,' ').trim();}
state.pos=matchEnd;return true;}}
if(!silent){state.pending+=marker;}
state.pos+=marker.length;return true;};},{}],39:[function(require,module,exports){'use strict';module.exports=function link_pairs(state){var i,j,lastDelim,currDelim,delimiters=state.delimiters,max=state.delimiters.length;for(i=0;i<max;i++){lastDelim=delimiters[i];if(!lastDelim.close){continue;}
j=i-lastDelim.jump-1;while(j>=0){currDelim=delimiters[j];if(currDelim.open&&currDelim.marker===lastDelim.marker&&currDelim.end<0&&currDelim.level===lastDelim.level){var odd_match=(currDelim.close||lastDelim.open)&&typeof currDelim.length!=='undefined'&&typeof lastDelim.length!=='undefined'&&(currDelim.length+lastDelim.length)%3===0;if(!odd_match){lastDelim.jump=i-j;lastDelim.open=false;currDelim.end=i;currDelim.jump=0;break;}}
j-=currDelim.jump+1;}}};},{}],40:[function(require,module,exports){'use strict';module.exports.tokenize=function emphasis(state,silent){var i,scanned,token,start=state.pos,marker=state.src.charCodeAt(start);if(silent){return false;}
if(marker!==0x5F&&marker!==0x2A){return false;}
scanned=state.scanDelims(state.pos,marker===0x2A);for(i=0;i<scanned.length;i++){token=state.push('text','',0);token.content=String.fromCharCode(marker);state.delimiters.push({marker:marker,length:scanned.length,jump:i,token:state.tokens.length-1,level:state.level,end:-1,open:scanned.can_open,close:scanned.can_close});}
state.pos+=scanned.length;return true;};module.exports.postProcess=function emphasis(state){var i,startDelim,endDelim,token,ch,isStrong,delimiters=state.delimiters,max=state.delimiters.length;for(i=max-1;i>=0;i--){startDelim=delimiters[i];if(startDelim.marker!==0x5F&&startDelim.marker!==0x2A){continue;}
if(startDelim.end===-1){continue;}
endDelim=delimiters[startDelim.end];isStrong=i>0&&delimiters[i-1].end===startDelim.end+1&&delimiters[i-1].token===startDelim.token-1&&delimiters[startDelim.end+1].token===endDelim.token+1&&delimiters[i-1].marker===startDelim.marker;ch=String.fromCharCode(startDelim.marker);token=state.tokens[startDelim.token];token.type=isStrong?'strong_open':'em_open';token.tag=isStrong?'strong':'em';token.nesting=1;token.markup=isStrong?ch+ch:ch;token.content='';token=state.tokens[endDelim.token];token.type=isStrong?'strong_close':'em_close';token.tag=isStrong?'strong':'em';token.nesting=-1;token.markup=isStrong?ch+ch:ch;token.content='';if(isStrong){state.tokens[delimiters[i-1].token].content='';state.tokens[delimiters[startDelim.end+1].token].content='';i--;}}};},{}],41:[function(require,module,exports){'use strict';var entities=require('../common/entities');var has=require('../common/utils').has;var isValidEntityCode=require('../common/utils').isValidEntityCode;var fromCodePoint=require('../common/utils').fromCodePoint;var DIGITAL_RE=/^&#((?:x[a-f0-9]{1,8}|[0-9]{1,8}));/i;var NAMED_RE=/^&([a-z][a-z0-9]{1,31});/i;module.exports=function entity(state,silent){var ch,code,match,pos=state.pos,max=state.posMax;if(state.src.charCodeAt(pos)!==0x26){return false;}
if(pos+1<max){ch=state.src.charCodeAt(pos+1);if(ch===0x23){match=state.src.slice(pos).match(DIGITAL_RE);if(match){if(!silent){code=match[1][0].toLowerCase()==='x'?parseInt(match[1].slice(1),16):parseInt(match[1],10);state.pending+=isValidEntityCode(code)?fromCodePoint(code):fromCodePoint(0xFFFD);}
state.pos+=match[0].length;return true;}}else{match=state.src.slice(pos).match(NAMED_RE);if(match){if(has(entities,match[1])){if(!silent){state.pending+=entities[match[1]];}
state.pos+=match[0].length;return true;}}}}
if(!silent){state.pending+='&';}
state.pos++;return true;};},{"../common/entities":1,"../common/utils":4}],42:[function(require,module,exports){'use strict';var isSpace=require('../common/utils').isSpace;var ESCAPED=[];for(var i=0;i<256;i++){ESCAPED.push(0);}'\\!"#$%&\'()*+,./:;<=>?@[]^_`{|}~-'.split('').forEach(function(ch){ESCAPED[ch.charCodeAt(0)]=1;});module.exports=function escape(state,silent){var ch,pos=state.pos,max=state.posMax;if(state.src.charCodeAt(pos)!==0x5C){return false;}
pos++;if(pos<max){ch=state.src.charCodeAt(pos);if(ch<256&&ESCAPED[ch]!==0){if(!silent){state.pending+=state.src[pos];}
state.pos+=2;return true;}
if(ch===0x0A){if(!silent){state.push('hardbreak','br',0);}
pos++;while(pos<max){ch=state.src.charCodeAt(pos);if(!isSpace(ch)){break;}
pos++;}
state.pos=pos;return true;}}
if(!silent){state.pending+='\\';}
state.pos++;return true;};},{"../common/utils":4}],43:[function(require,module,exports){'use strict';var HTML_TAG_RE=require('../common/html_re').HTML_TAG_RE;function isLetter(ch){var lc=ch|0x20;return(lc>=0x61)&&(lc<=0x7a);}
module.exports=function html_inline(state,silent){var ch,match,max,token,pos=state.pos;if(!state.md.options.html){return false;}
max=state.posMax;if(state.src.charCodeAt(pos)!==0x3C||pos+2>=max){return false;}
ch=state.src.charCodeAt(pos+1);if(ch!==0x21&&ch!==0x3F&&ch!==0x2F&&!isLetter(ch)){return false;}
match=state.src.slice(pos).match(HTML_TAG_RE);if(!match){return false;}
if(!silent){token=state.push('html_inline','',0);token.content=state.src.slice(pos,pos+match[0].length);}
state.pos+=match[0].length;return true;};},{"../common/html_re":3}],44:[function(require,module,exports){'use strict';var normalizeReference=require('../common/utils').normalizeReference;var isSpace=require('../common/utils').isSpace;module.exports=function image(state,silent){var attrs,code,content,label,labelEnd,labelStart,pos,ref,res,title,token,tokens,start,href='',oldPos=state.pos,max=state.posMax;if(state.src.charCodeAt(state.pos)!==0x21){return false;}
if(state.src.charCodeAt(state.pos+1)!==0x5B){return false;}
labelStart=state.pos+2;labelEnd=state.md.helpers.parseLinkLabel(state,state.pos+1,false);if(labelEnd<0){return false;}
pos=labelEnd+1;if(pos<max&&state.src.charCodeAt(pos)===0x28){pos++;for(;pos<max;pos++){code=state.src.charCodeAt(pos);if(!isSpace(code)&&code!==0x0A){break;}}
if(pos>=max){return false;}
start=pos;res=state.md.helpers.parseLinkDestination(state.src,pos,state.posMax);if(res.ok){href=state.md.normalizeLink(res.str);if(state.md.validateLink(href)){pos=res.pos;}else{href='';}}
start=pos;for(;pos<max;pos++){code=state.src.charCodeAt(pos);if(!isSpace(code)&&code!==0x0A){break;}}
res=state.md.helpers.parseLinkTitle(state.src,pos,state.posMax);if(pos<max&&start!==pos&&res.ok){title=res.str;pos=res.pos;for(;pos<max;pos++){code=state.src.charCodeAt(pos);if(!isSpace(code)&&code!==0x0A){break;}}}else{title='';}
if(pos>=max||state.src.charCodeAt(pos)!==0x29){state.pos=oldPos;return false;}
pos++;}else{if(typeof state.env.references==='undefined'){return false;}
if(pos<max&&state.src.charCodeAt(pos)===0x5B){start=pos+1;pos=state.md.helpers.parseLinkLabel(state,pos);if(pos>=0){label=state.src.slice(start,pos++);}else{pos=labelEnd+1;}}else{pos=labelEnd+1;}
if(!label){label=state.src.slice(labelStart,labelEnd);}
ref=state.env.references[normalizeReference(label)];if(!ref){state.pos=oldPos;return false;}
href=ref.href;title=ref.title;}
if(!silent){content=state.src.slice(labelStart,labelEnd);state.md.inline.parse(content,state.md,state.env,tokens=[]);token=state.push('image','img',0);token.attrs=attrs=[['src',href],['alt','']];token.children=tokens;token.content=content;if(title){attrs.push(['title',title]);}}
state.pos=pos;state.posMax=max;return true;};},{"../common/utils":4}],45:[function(require,module,exports){'use strict';var normalizeReference=require('../common/utils').normalizeReference;var isSpace=require('../common/utils').isSpace;module.exports=function link(state,silent){var attrs,code,label,labelEnd,labelStart,pos,res,ref,title,token,href='',oldPos=state.pos,max=state.posMax,start=state.pos,parseReference=true;if(state.src.charCodeAt(state.pos)!==0x5B){return false;}
labelStart=state.pos+1;labelEnd=state.md.helpers.parseLinkLabel(state,state.pos,true);if(labelEnd<0){return false;}
pos=labelEnd+1;if(pos<max&&state.src.charCodeAt(pos)===0x28){parseReference=false;pos++;for(;pos<max;pos++){code=state.src.charCodeAt(pos);if(!isSpace(code)&&code!==0x0A){break;}}
if(pos>=max){return false;}
start=pos;res=state.md.helpers.parseLinkDestination(state.src,pos,state.posMax);if(res.ok){href=state.md.normalizeLink(res.str);if(state.md.validateLink(href)){pos=res.pos;}else{href='';}}
start=pos;for(;pos<max;pos++){code=state.src.charCodeAt(pos);if(!isSpace(code)&&code!==0x0A){break;}}
res=state.md.helpers.parseLinkTitle(state.src,pos,state.posMax);if(pos<max&&start!==pos&&res.ok){title=res.str;pos=res.pos;for(;pos<max;pos++){code=state.src.charCodeAt(pos);if(!isSpace(code)&&code!==0x0A){break;}}}else{title='';}
if(pos>=max||state.src.charCodeAt(pos)!==0x29){parseReference=true;}
pos++;}
if(parseReference){if(typeof state.env.references==='undefined'){return false;}
if(pos<max&&state.src.charCodeAt(pos)===0x5B){start=pos+1;pos=state.md.helpers.parseLinkLabel(state,pos);if(pos>=0){label=state.src.slice(start,pos++);}else{pos=labelEnd+1;}}else{pos=labelEnd+1;}
if(!label){label=state.src.slice(labelStart,labelEnd);}
ref=state.env.references[normalizeReference(label)];if(!ref){state.pos=oldPos;return false;}
href=ref.href;title=ref.title;}
if(!silent){state.pos=labelStart;state.posMax=labelEnd;token=state.push('link_open','a',1);token.attrs=attrs=[['href',href]];if(title){attrs.push(['title',title]);}
state.md.inline.tokenize(state);token=state.push('link_close','a',-1);}
state.pos=pos;state.posMax=max;return true;};},{"../common/utils":4}],46:[function(require,module,exports){'use strict';var isSpace=require('../common/utils').isSpace;module.exports=function newline(state,silent){var pmax,max,pos=state.pos;if(state.src.charCodeAt(pos)!==0x0A){return false;}
pmax=state.pending.length-1;max=state.posMax;if(!silent){if(pmax>=0&&state.pending.charCodeAt(pmax)===0x20){if(pmax>=1&&state.pending.charCodeAt(pmax-1)===0x20){state.pending=state.pending.replace(/ +$/,'');state.push('hardbreak','br',0);}else{state.pending=state.pending.slice(0,-1);state.push('softbreak','br',0);}}else{state.push('softbreak','br',0);}}
pos++;while(pos<max&&isSpace(state.src.charCodeAt(pos))){pos++;}
state.pos=pos;return true;};},{"../common/utils":4}],47:[function(require,module,exports){'use strict';var Token=require('../token');var isWhiteSpace=require('../common/utils').isWhiteSpace;var isPunctChar=require('../common/utils').isPunctChar;var isMdAsciiPunct=require('../common/utils').isMdAsciiPunct;function StateInline(src,md,env,outTokens){this.src=src;this.env=env;this.md=md;this.tokens=outTokens;this.pos=0;this.posMax=this.src.length;this.level=0;this.pending='';this.pendingLevel=0;this.cache={};this.delimiters=[];}
StateInline.prototype.pushPending=function(){var token=new Token('text','',0);token.content=this.pending;token.level=this.pendingLevel;this.tokens.push(token);this.pending='';return token;};StateInline.prototype.push=function(type,tag,nesting){if(this.pending){this.pushPending();}
var token=new Token(type,tag,nesting);if(nesting<0){this.level--;}
token.level=this.level;if(nesting>0){this.level++;}
this.pendingLevel=this.level;this.tokens.push(token);return token;};StateInline.prototype.scanDelims=function(start,canSplitWord){var pos=start,lastChar,nextChar,count,can_open,can_close,isLastWhiteSpace,isLastPunctChar,isNextWhiteSpace,isNextPunctChar,left_flanking=true,right_flanking=true,max=this.posMax,marker=this.src.charCodeAt(start);lastChar=start>0?this.src.charCodeAt(start-1):0x20;while(pos<max&&this.src.charCodeAt(pos)===marker){pos++;}
count=pos-start;nextChar=pos<max?this.src.charCodeAt(pos):0x20;isLastPunctChar=isMdAsciiPunct(lastChar)||isPunctChar(String.fromCharCode(lastChar));isNextPunctChar=isMdAsciiPunct(nextChar)||isPunctChar(String.fromCharCode(nextChar));isLastWhiteSpace=isWhiteSpace(lastChar);isNextWhiteSpace=isWhiteSpace(nextChar);if(isNextWhiteSpace){left_flanking=false;}else if(isNextPunctChar){if(!(isLastWhiteSpace||isLastPunctChar)){left_flanking=false;}}
if(isLastWhiteSpace){right_flanking=false;}else if(isLastPunctChar){if(!(isNextWhiteSpace||isNextPunctChar)){right_flanking=false;}}
if(!canSplitWord){can_open=left_flanking&&(!right_flanking||isLastPunctChar);can_close=right_flanking&&(!left_flanking||isNextPunctChar);}else{can_open=left_flanking;can_close=right_flanking;}
return{can_open:can_open,can_close:can_close,length:count};};StateInline.prototype.Token=Token;module.exports=StateInline;},{"../common/utils":4,"../token":51}],48:[function(require,module,exports){'use strict';module.exports.tokenize=function strikethrough(state,silent){var i,scanned,token,len,ch,start=state.pos,marker=state.src.charCodeAt(start);if(silent){return false;}
if(marker!==0x7E){return false;}
scanned=state.scanDelims(state.pos,true);len=scanned.length;ch=String.fromCharCode(marker);if(len<2){return false;}
if(len%2){token=state.push('text','',0);token.content=ch;len--;}
for(i=0;i<len;i+=2){token=state.push('text','',0);token.content=ch+ch;state.delimiters.push({marker:marker,jump:i,token:state.tokens.length-1,level:state.level,end:-1,open:scanned.can_open,close:scanned.can_close});}
state.pos+=scanned.length;return true;};module.exports.postProcess=function strikethrough(state){var i,j,startDelim,endDelim,token,loneMarkers=[],delimiters=state.delimiters,max=state.delimiters.length;for(i=0;i<max;i++){startDelim=delimiters[i];if(startDelim.marker!==0x7E){continue;}
if(startDelim.end===-1){continue;}
endDelim=delimiters[startDelim.end];token=state.tokens[startDelim.token];token.type='s_open';token.tag='s';token.nesting=1;token.markup='~~';token.content='';token=state.tokens[endDelim.token];token.type='s_close';token.tag='s';token.nesting=-1;token.markup='~~';token.content='';if(state.tokens[endDelim.token-1].type==='text'&&state.tokens[endDelim.token-1].content==='~'){loneMarkers.push(endDelim.token-1);}}
while(loneMarkers.length){i=loneMarkers.pop();j=i+1;while(j<state.tokens.length&&state.tokens[j].type==='s_close'){j++;}
j--;if(i!==j){token=state.tokens[j];state.tokens[j]=state.tokens[i];state.tokens[i]=token;}}};},{}],49:[function(require,module,exports){'use strict';function isTerminatorChar(ch){switch(ch){case 0x0A:case 0x21:case 0x23:case 0x24:case 0x25:case 0x26:case 0x2A:case 0x2B:case 0x2D:case 0x3A:case 0x3C:case 0x3D:case 0x3E:case 0x40:case 0x5B:case 0x5C:case 0x5D:case 0x5E:case 0x5F:case 0x60:case 0x7B:case 0x7D:case 0x7E:return true;default:return false;}}
module.exports=function text(state,silent){var pos=state.pos;while(pos<state.posMax&&!isTerminatorChar(state.src.charCodeAt(pos))){pos++;}
if(pos===state.pos){return false;}
if(!silent){state.pending+=state.src.slice(state.pos,pos);}
state.pos=pos;return true;};},{}],50:[function(require,module,exports){'use strict';module.exports=function text_collapse(state){var curr,last,level=0,tokens=state.tokens,max=state.tokens.length;for(curr=last=0;curr<max;curr++){level+=tokens[curr].nesting;tokens[curr].level=level;if(tokens[curr].type==='text'&&curr+1<max&&tokens[curr+1].type==='text'){tokens[curr+1].content=tokens[curr].content+tokens[curr+1].content;}else{if(curr!==last){tokens[last]=tokens[curr];}
last++;}}
if(curr!==last){tokens.length=last;}};},{}],51:[function(require,module,exports){'use strict';function Token(type,tag,nesting){this.type=type;this.tag=tag;this.attrs=null;this.map=null;this.nesting=nesting;this.level=0;this.children=null;this.content='';this.markup='';this.info='';this.meta=null;this.block=false;this.hidden=false;}
Token.prototype.attrIndex=function attrIndex(name){var attrs,i,len;if(!this.attrs){return-1;}
attrs=this.attrs;for(i=0,len=attrs.length;i<len;i++){if(attrs[i][0]===name){return i;}}
return-1;};Token.prototype.attrPush=function attrPush(attrData){if(this.attrs){this.attrs.push(attrData);}else{this.attrs=[attrData];}};Token.prototype.attrSet=function attrSet(name,value){var idx=this.attrIndex(name),attrData=[name,value];if(idx<0){this.attrPush(attrData);}else{this.attrs[idx]=attrData;}};Token.prototype.attrGet=function attrGet(name){var idx=this.attrIndex(name),value=null;if(idx>=0){value=this.attrs[idx][1];}
return value;};Token.prototype.attrJoin=function attrJoin(name,value){var idx=this.attrIndex(name);if(idx<0){this.attrPush([name,value]);}else{this.attrs[idx][1]=this.attrs[idx][1]+' '+value;}};module.exports=Token;},{}],52:[function(require,module,exports){module.exports={"Aacute":"\u00C1","aacute":"\u00E1","Abreve":"\u0102","abreve":"\u0103","ac":"\u223E","acd":"\u223F","acE":"\u223E\u0333","Acirc":"\u00C2","acirc":"\u00E2","acute":"\u00B4","Acy":"\u0410","acy":"\u0430","AElig":"\u00C6","aelig":"\u00E6","af":"\u2061","Afr":"\uD835\uDD04","afr":"\uD835\uDD1E","Agrave":"\u00C0","agrave":"\u00E0","alefsym":"\u2135","aleph":"\u2135","Alpha":"\u0391","alpha":"\u03B1","Amacr":"\u0100","amacr":"\u0101","amalg":"\u2A3F","amp":"&","AMP":"&","andand":"\u2A55","And":"\u2A53","and":"\u2227","andd":"\u2A5C","andslope":"\u2A58","andv":"\u2A5A","ang":"\u2220","ange":"\u29A4","angle":"\u2220","angmsdaa":"\u29A8","angmsdab":"\u29A9","angmsdac":"\u29AA","angmsdad":"\u29AB","angmsdae":"\u29AC","angmsdaf":"\u29AD","angmsdag":"\u29AE","angmsdah":"\u29AF","angmsd":"\u2221","angrt":"\u221F","angrtvb":"\u22BE","angrtvbd":"\u299D","angsph":"\u2222","angst":"\u00C5","angzarr":"\u237C","Aogon":"\u0104","aogon":"\u0105","Aopf":"\uD835\uDD38","aopf":"\uD835\uDD52","apacir":"\u2A6F","ap":"\u2248","apE":"\u2A70","ape":"\u224A","apid":"\u224B","apos":"'","ApplyFunction":"\u2061","approx":"\u2248","approxeq":"\u224A","Aring":"\u00C5","aring":"\u00E5","Ascr":"\uD835\uDC9C","ascr":"\uD835\uDCB6","Assign":"\u2254","ast":"*","asymp":"\u2248","asympeq":"\u224D","Atilde":"\u00C3","atilde":"\u00E3","Auml":"\u00C4","auml":"\u00E4","awconint":"\u2233","awint":"\u2A11","backcong":"\u224C","backepsilon":"\u03F6","backprime":"\u2035","backsim":"\u223D","backsimeq":"\u22CD","Backslash":"\u2216","Barv":"\u2AE7","barvee":"\u22BD","barwed":"\u2305","Barwed":"\u2306","barwedge":"\u2305","bbrk":"\u23B5","bbrktbrk":"\u23B6","bcong":"\u224C","Bcy":"\u0411","bcy":"\u0431","bdquo":"\u201E","becaus":"\u2235","because":"\u2235","Because":"\u2235","bemptyv":"\u29B0","bepsi":"\u03F6","bernou":"\u212C","Bernoullis":"\u212C","Beta":"\u0392","beta":"\u03B2","beth":"\u2136","between":"\u226C","Bfr":"\uD835\uDD05","bfr":"\uD835\uDD1F","bigcap":"\u22C2","bigcirc":"\u25EF","bigcup":"\u22C3","bigodot":"\u2A00","bigoplus":"\u2A01","bigotimes":"\u2A02","bigsqcup":"\u2A06","bigstar":"\u2605","bigtriangledown":"\u25BD","bigtriangleup":"\u25B3","biguplus":"\u2A04","bigvee":"\u22C1","bigwedge":"\u22C0","bkarow":"\u290D","blacklozenge":"\u29EB","blacksquare":"\u25AA","blacktriangle":"\u25B4","blacktriangledown":"\u25BE","blacktriangleleft":"\u25C2","blacktriangleright":"\u25B8","blank":"\u2423","blk12":"\u2592","blk14":"\u2591","blk34":"\u2593","block":"\u2588","bne":"=\u20E5","bnequiv":"\u2261\u20E5","bNot":"\u2AED","bnot":"\u2310","Bopf":"\uD835\uDD39","bopf":"\uD835\uDD53","bot":"\u22A5","bottom":"\u22A5","bowtie":"\u22C8","boxbox":"\u29C9","boxdl":"\u2510","boxdL":"\u2555","boxDl":"\u2556","boxDL":"\u2557","boxdr":"\u250C","boxdR":"\u2552","boxDr":"\u2553","boxDR":"\u2554","boxh":"\u2500","boxH":"\u2550","boxhd":"\u252C","boxHd":"\u2564","boxhD":"\u2565","boxHD":"\u2566","boxhu":"\u2534","boxHu":"\u2567","boxhU":"\u2568","boxHU":"\u2569","boxminus":"\u229F","boxplus":"\u229E","boxtimes":"\u22A0","boxul":"\u2518","boxuL":"\u255B","boxUl":"\u255C","boxUL":"\u255D","boxur":"\u2514","boxuR":"\u2558","boxUr":"\u2559","boxUR":"\u255A","boxv":"\u2502","boxV":"\u2551","boxvh":"\u253C","boxvH":"\u256A","boxVh":"\u256B","boxVH":"\u256C","boxvl":"\u2524","boxvL":"\u2561","boxVl":"\u2562","boxVL":"\u2563","boxvr":"\u251C","boxvR":"\u255E","boxVr":"\u255F","boxVR":"\u2560","bprime":"\u2035","breve":"\u02D8","Breve":"\u02D8","brvbar":"\u00A6","bscr":"\uD835\uDCB7","Bscr":"\u212C","bsemi":"\u204F","bsim":"\u223D","bsime":"\u22CD","bsolb":"\u29C5","bsol":"\\","bsolhsub":"\u27C8","bull":"\u2022","bullet":"\u2022","bump":"\u224E","bumpE":"\u2AAE","bumpe":"\u224F","Bumpeq":"\u224E","bumpeq":"\u224F","Cacute":"\u0106","cacute":"\u0107","capand":"\u2A44","capbrcup":"\u2A49","capcap":"\u2A4B","cap":"\u2229","Cap":"\u22D2","capcup":"\u2A47","capdot":"\u2A40","CapitalDifferentialD":"\u2145","caps":"\u2229\uFE00","caret":"\u2041","caron":"\u02C7","Cayleys":"\u212D","ccaps":"\u2A4D","Ccaron":"\u010C","ccaron":"\u010D","Ccedil":"\u00C7","ccedil":"\u00E7","Ccirc":"\u0108","ccirc":"\u0109","Cconint":"\u2230","ccups":"\u2A4C","ccupssm":"\u2A50","Cdot":"\u010A","cdot":"\u010B","cedil":"\u00B8","Cedilla":"\u00B8","cemptyv":"\u29B2","cent":"\u00A2","centerdot":"\u00B7","CenterDot":"\u00B7","cfr":"\uD835\uDD20","Cfr":"\u212D","CHcy":"\u0427","chcy":"\u0447","check":"\u2713","checkmark":"\u2713","Chi":"\u03A7","chi":"\u03C7","circ":"\u02C6","circeq":"\u2257","circlearrowleft":"\u21BA","circlearrowright":"\u21BB","circledast":"\u229B","circledcirc":"\u229A","circleddash":"\u229D","CircleDot":"\u2299","circledR":"\u00AE","circledS":"\u24C8","CircleMinus":"\u2296","CirclePlus":"\u2295","CircleTimes":"\u2297","cir":"\u25CB","cirE":"\u29C3","cire":"\u2257","cirfnint":"\u2A10","cirmid":"\u2AEF","cirscir":"\u29C2","ClockwiseContourIntegral":"\u2232","CloseCurlyDoubleQuote":"\u201D","CloseCurlyQuote":"\u2019","clubs":"\u2663","clubsuit":"\u2663","colon":":","Colon":"\u2237","Colone":"\u2A74","colone":"\u2254","coloneq":"\u2254","comma":",","commat":"@","comp":"\u2201","compfn":"\u2218","complement":"\u2201","complexes":"\u2102","cong":"\u2245","congdot":"\u2A6D","Congruent":"\u2261","conint":"\u222E","Conint":"\u222F","ContourIntegral":"\u222E","copf":"\uD835\uDD54","Copf":"\u2102","coprod":"\u2210","Coproduct":"\u2210","copy":"\u00A9","COPY":"\u00A9","copysr":"\u2117","CounterClockwiseContourIntegral":"\u2233","crarr":"\u21B5","cross":"\u2717","Cross":"\u2A2F","Cscr":"\uD835\uDC9E","cscr":"\uD835\uDCB8","csub":"\u2ACF","csube":"\u2AD1","csup":"\u2AD0","csupe":"\u2AD2","ctdot":"\u22EF","cudarrl":"\u2938","cudarrr":"\u2935","cuepr":"\u22DE","cuesc":"\u22DF","cularr":"\u21B6","cularrp":"\u293D","cupbrcap":"\u2A48","cupcap":"\u2A46","CupCap":"\u224D","cup":"\u222A","Cup":"\u22D3","cupcup":"\u2A4A","cupdot":"\u228D","cupor":"\u2A45","cups":"\u222A\uFE00","curarr":"\u21B7","curarrm":"\u293C","curlyeqprec":"\u22DE","curlyeqsucc":"\u22DF","curlyvee":"\u22CE","curlywedge":"\u22CF","curren":"\u00A4","curvearrowleft":"\u21B6","curvearrowright":"\u21B7","cuvee":"\u22CE","cuwed":"\u22CF","cwconint":"\u2232","cwint":"\u2231","cylcty":"\u232D","dagger":"\u2020","Dagger":"\u2021","daleth":"\u2138","darr":"\u2193","Darr":"\u21A1","dArr":"\u21D3","dash":"\u2010","Dashv":"\u2AE4","dashv":"\u22A3","dbkarow":"\u290F","dblac":"\u02DD","Dcaron":"\u010E","dcaron":"\u010F","Dcy":"\u0414","dcy":"\u0434","ddagger":"\u2021","ddarr":"\u21CA","DD":"\u2145","dd":"\u2146","DDotrahd":"\u2911","ddotseq":"\u2A77","deg":"\u00B0","Del":"\u2207","Delta":"\u0394","delta":"\u03B4","demptyv":"\u29B1","dfisht":"\u297F","Dfr":"\uD835\uDD07","dfr":"\uD835\uDD21","dHar":"\u2965","dharl":"\u21C3","dharr":"\u21C2","DiacriticalAcute":"\u00B4","DiacriticalDot":"\u02D9","DiacriticalDoubleAcute":"\u02DD","DiacriticalGrave":"`","DiacriticalTilde":"\u02DC","diam":"\u22C4","diamond":"\u22C4","Diamond":"\u22C4","diamondsuit":"\u2666","diams":"\u2666","die":"\u00A8","DifferentialD":"\u2146","digamma":"\u03DD","disin":"\u22F2","div":"\u00F7","divide":"\u00F7","divideontimes":"\u22C7","divonx":"\u22C7","DJcy":"\u0402","djcy":"\u0452","dlcorn":"\u231E","dlcrop":"\u230D","dollar":"$","Dopf":"\uD835\uDD3B","dopf":"\uD835\uDD55","Dot":"\u00A8","dot":"\u02D9","DotDot":"\u20DC","doteq":"\u2250","doteqdot":"\u2251","DotEqual":"\u2250","dotminus":"\u2238","dotplus":"\u2214","dotsquare":"\u22A1","doublebarwedge":"\u2306","DoubleContourIntegral":"\u222F","DoubleDot":"\u00A8","DoubleDownArrow":"\u21D3","DoubleLeftArrow":"\u21D0","DoubleLeftRightArrow":"\u21D4","DoubleLeftTee":"\u2AE4","DoubleLongLeftArrow":"\u27F8","DoubleLongLeftRightArrow":"\u27FA","DoubleLongRightArrow":"\u27F9","DoubleRightArrow":"\u21D2","DoubleRightTee":"\u22A8","DoubleUpArrow":"\u21D1","DoubleUpDownArrow":"\u21D5","DoubleVerticalBar":"\u2225","DownArrowBar":"\u2913","downarrow":"\u2193","DownArrow":"\u2193","Downarrow":"\u21D3","DownArrowUpArrow":"\u21F5","DownBreve":"\u0311","downdownarrows":"\u21CA","downharpoonleft":"\u21C3","downharpoonright":"\u21C2","DownLeftRightVector":"\u2950","DownLeftTeeVector":"\u295E","DownLeftVectorBar":"\u2956","DownLeftVector":"\u21BD","DownRightTeeVector":"\u295F","DownRightVectorBar":"\u2957","DownRightVector":"\u21C1","DownTeeArrow":"\u21A7","DownTee":"\u22A4","drbkarow":"\u2910","drcorn":"\u231F","drcrop":"\u230C","Dscr":"\uD835\uDC9F","dscr":"\uD835\uDCB9","DScy":"\u0405","dscy":"\u0455","dsol":"\u29F6","Dstrok":"\u0110","dstrok":"\u0111","dtdot":"\u22F1","dtri":"\u25BF","dtrif":"\u25BE","duarr":"\u21F5","duhar":"\u296F","dwangle":"\u29A6","DZcy":"\u040F","dzcy":"\u045F","dzigrarr":"\u27FF","Eacute":"\u00C9","eacute":"\u00E9","easter":"\u2A6E","Ecaron":"\u011A","ecaron":"\u011B","Ecirc":"\u00CA","ecirc":"\u00EA","ecir":"\u2256","ecolon":"\u2255","Ecy":"\u042D","ecy":"\u044D","eDDot":"\u2A77","Edot":"\u0116","edot":"\u0117","eDot":"\u2251","ee":"\u2147","efDot":"\u2252","Efr":"\uD835\uDD08","efr":"\uD835\uDD22","eg":"\u2A9A","Egrave":"\u00C8","egrave":"\u00E8","egs":"\u2A96","egsdot":"\u2A98","el":"\u2A99","Element":"\u2208","elinters":"\u23E7","ell":"\u2113","els":"\u2A95","elsdot":"\u2A97","Emacr":"\u0112","emacr":"\u0113","empty":"\u2205","emptyset":"\u2205","EmptySmallSquare":"\u25FB","emptyv":"\u2205","EmptyVerySmallSquare":"\u25AB","emsp13":"\u2004","emsp14":"\u2005","emsp":"\u2003","ENG":"\u014A","eng":"\u014B","ensp":"\u2002","Eogon":"\u0118","eogon":"\u0119","Eopf":"\uD835\uDD3C","eopf":"\uD835\uDD56","epar":"\u22D5","eparsl":"\u29E3","eplus":"\u2A71","epsi":"\u03B5","Epsilon":"\u0395","epsilon":"\u03B5","epsiv":"\u03F5","eqcirc":"\u2256","eqcolon":"\u2255","eqsim":"\u2242","eqslantgtr":"\u2A96","eqslantless":"\u2A95","Equal":"\u2A75","equals":"=","EqualTilde":"\u2242","equest":"\u225F","Equilibrium":"\u21CC","equiv":"\u2261","equivDD":"\u2A78","eqvparsl":"\u29E5","erarr":"\u2971","erDot":"\u2253","escr":"\u212F","Escr":"\u2130","esdot":"\u2250","Esim":"\u2A73","esim":"\u2242","Eta":"\u0397","eta":"\u03B7","ETH":"\u00D0","eth":"\u00F0","Euml":"\u00CB","euml":"\u00EB","euro":"\u20AC","excl":"!","exist":"\u2203","Exists":"\u2203","expectation":"\u2130","exponentiale":"\u2147","ExponentialE":"\u2147","fallingdotseq":"\u2252","Fcy":"\u0424","fcy":"\u0444","female":"\u2640","ffilig":"\uFB03","fflig":"\uFB00","ffllig":"\uFB04","Ffr":"\uD835\uDD09","ffr":"\uD835\uDD23","filig":"\uFB01","FilledSmallSquare":"\u25FC","FilledVerySmallSquare":"\u25AA","fjlig":"fj","flat":"\u266D","fllig":"\uFB02","fltns":"\u25B1","fnof":"\u0192","Fopf":"\uD835\uDD3D","fopf":"\uD835\uDD57","forall":"\u2200","ForAll":"\u2200","fork":"\u22D4","forkv":"\u2AD9","Fouriertrf":"\u2131","fpartint":"\u2A0D","frac12":"\u00BD","frac13":"\u2153","frac14":"\u00BC","frac15":"\u2155","frac16":"\u2159","frac18":"\u215B","frac23":"\u2154","frac25":"\u2156","frac34":"\u00BE","frac35":"\u2157","frac38":"\u215C","frac45":"\u2158","frac56":"\u215A","frac58":"\u215D","frac78":"\u215E","frasl":"\u2044","frown":"\u2322","fscr":"\uD835\uDCBB","Fscr":"\u2131","gacute":"\u01F5","Gamma":"\u0393","gamma":"\u03B3","Gammad":"\u03DC","gammad":"\u03DD","gap":"\u2A86","Gbreve":"\u011E","gbreve":"\u011F","Gcedil":"\u0122","Gcirc":"\u011C","gcirc":"\u011D","Gcy":"\u0413","gcy":"\u0433","Gdot":"\u0120","gdot":"\u0121","ge":"\u2265","gE":"\u2267","gEl":"\u2A8C","gel":"\u22DB","geq":"\u2265","geqq":"\u2267","geqslant":"\u2A7E","gescc":"\u2AA9","ges":"\u2A7E","gesdot":"\u2A80","gesdoto":"\u2A82","gesdotol":"\u2A84","gesl":"\u22DB\uFE00","gesles":"\u2A94","Gfr":"\uD835\uDD0A","gfr":"\uD835\uDD24","gg":"\u226B","Gg":"\u22D9","ggg":"\u22D9","gimel":"\u2137","GJcy":"\u0403","gjcy":"\u0453","gla":"\u2AA5","gl":"\u2277","glE":"\u2A92","glj":"\u2AA4","gnap":"\u2A8A","gnapprox":"\u2A8A","gne":"\u2A88","gnE":"\u2269","gneq":"\u2A88","gneqq":"\u2269","gnsim":"\u22E7","Gopf":"\uD835\uDD3E","gopf":"\uD835\uDD58","grave":"`","GreaterEqual":"\u2265","GreaterEqualLess":"\u22DB","GreaterFullEqual":"\u2267","GreaterGreater":"\u2AA2","GreaterLess":"\u2277","GreaterSlantEqual":"\u2A7E","GreaterTilde":"\u2273","Gscr":"\uD835\uDCA2","gscr":"\u210A","gsim":"\u2273","gsime":"\u2A8E","gsiml":"\u2A90","gtcc":"\u2AA7","gtcir":"\u2A7A","gt":">","GT":">","Gt":"\u226B","gtdot":"\u22D7","gtlPar":"\u2995","gtquest":"\u2A7C","gtrapprox":"\u2A86","gtrarr":"\u2978","gtrdot":"\u22D7","gtreqless":"\u22DB","gtreqqless":"\u2A8C","gtrless":"\u2277","gtrsim":"\u2273","gvertneqq":"\u2269\uFE00","gvnE":"\u2269\uFE00","Hacek":"\u02C7","hairsp":"\u200A","half":"\u00BD","hamilt":"\u210B","HARDcy":"\u042A","hardcy":"\u044A","harrcir":"\u2948","harr":"\u2194","hArr":"\u21D4","harrw":"\u21AD","Hat":"^","hbar":"\u210F","Hcirc":"\u0124","hcirc":"\u0125","hearts":"\u2665","heartsuit":"\u2665","hellip":"\u2026","hercon":"\u22B9","hfr":"\uD835\uDD25","Hfr":"\u210C","HilbertSpace":"\u210B","hksearow":"\u2925","hkswarow":"\u2926","hoarr":"\u21FF","homtht":"\u223B","hookleftarrow":"\u21A9","hookrightarrow":"\u21AA","hopf":"\uD835\uDD59","Hopf":"\u210D","horbar":"\u2015","HorizontalLine":"\u2500","hscr":"\uD835\uDCBD","Hscr":"\u210B","hslash":"\u210F","Hstrok":"\u0126","hstrok":"\u0127","HumpDownHump":"\u224E","HumpEqual":"\u224F","hybull":"\u2043","hyphen":"\u2010","Iacute":"\u00CD","iacute":"\u00ED","ic":"\u2063","Icirc":"\u00CE","icirc":"\u00EE","Icy":"\u0418","icy":"\u0438","Idot":"\u0130","IEcy":"\u0415","iecy":"\u0435","iexcl":"\u00A1","iff":"\u21D4","ifr":"\uD835\uDD26","Ifr":"\u2111","Igrave":"\u00CC","igrave":"\u00EC","ii":"\u2148","iiiint":"\u2A0C","iiint":"\u222D","iinfin":"\u29DC","iiota":"\u2129","IJlig":"\u0132","ijlig":"\u0133","Imacr":"\u012A","imacr":"\u012B","image":"\u2111","ImaginaryI":"\u2148","imagline":"\u2110","imagpart":"\u2111","imath":"\u0131","Im":"\u2111","imof":"\u22B7","imped":"\u01B5","Implies":"\u21D2","incare":"\u2105","in":"\u2208","infin":"\u221E","infintie":"\u29DD","inodot":"\u0131","intcal":"\u22BA","int":"\u222B","Int":"\u222C","integers":"\u2124","Integral":"\u222B","intercal":"\u22BA","Intersection":"\u22C2","intlarhk":"\u2A17","intprod":"\u2A3C","InvisibleComma":"\u2063","InvisibleTimes":"\u2062","IOcy":"\u0401","iocy":"\u0451","Iogon":"\u012E","iogon":"\u012F","Iopf":"\uD835\uDD40","iopf":"\uD835\uDD5A","Iota":"\u0399","iota":"\u03B9","iprod":"\u2A3C","iquest":"\u00BF","iscr":"\uD835\uDCBE","Iscr":"\u2110","isin":"\u2208","isindot":"\u22F5","isinE":"\u22F9","isins":"\u22F4","isinsv":"\u22F3","isinv":"\u2208","it":"\u2062","Itilde":"\u0128","itilde":"\u0129","Iukcy":"\u0406","iukcy":"\u0456","Iuml":"\u00CF","iuml":"\u00EF","Jcirc":"\u0134","jcirc":"\u0135","Jcy":"\u0419","jcy":"\u0439","Jfr":"\uD835\uDD0D","jfr":"\uD835\uDD27","jmath":"\u0237","Jopf":"\uD835\uDD41","jopf":"\uD835\uDD5B","Jscr":"\uD835\uDCA5","jscr":"\uD835\uDCBF","Jsercy":"\u0408","jsercy":"\u0458","Jukcy":"\u0404","jukcy":"\u0454","Kappa":"\u039A","kappa":"\u03BA","kappav":"\u03F0","Kcedil":"\u0136","kcedil":"\u0137","Kcy":"\u041A","kcy":"\u043A","Kfr":"\uD835\uDD0E","kfr":"\uD835\uDD28","kgreen":"\u0138","KHcy":"\u0425","khcy":"\u0445","KJcy":"\u040C","kjcy":"\u045C","Kopf":"\uD835\uDD42","kopf":"\uD835\uDD5C","Kscr":"\uD835\uDCA6","kscr":"\uD835\uDCC0","lAarr":"\u21DA","Lacute":"\u0139","lacute":"\u013A","laemptyv":"\u29B4","lagran":"\u2112","Lambda":"\u039B","lambda":"\u03BB","lang":"\u27E8","Lang":"\u27EA","langd":"\u2991","langle":"\u27E8","lap":"\u2A85","Laplacetrf":"\u2112","laquo":"\u00AB","larrb":"\u21E4","larrbfs":"\u291F","larr":"\u2190","Larr":"\u219E","lArr":"\u21D0","larrfs":"\u291D","larrhk":"\u21A9","larrlp":"\u21AB","larrpl":"\u2939","larrsim":"\u2973","larrtl":"\u21A2","latail":"\u2919","lAtail":"\u291B","lat":"\u2AAB","late":"\u2AAD","lates":"\u2AAD\uFE00","lbarr":"\u290C","lBarr":"\u290E","lbbrk":"\u2772","lbrace":"{","lbrack":"[","lbrke":"\u298B","lbrksld":"\u298F","lbrkslu":"\u298D","Lcaron":"\u013D","lcaron":"\u013E","Lcedil":"\u013B","lcedil":"\u013C","lceil":"\u2308","lcub":"{","Lcy":"\u041B","lcy":"\u043B","ldca":"\u2936","ldquo":"\u201C","ldquor":"\u201E","ldrdhar":"\u2967","ldrushar":"\u294B","ldsh":"\u21B2","le":"\u2264","lE":"\u2266","LeftAngleBracket":"\u27E8","LeftArrowBar":"\u21E4","leftarrow":"\u2190","LeftArrow":"\u2190","Leftarrow":"\u21D0","LeftArrowRightArrow":"\u21C6","leftarrowtail":"\u21A2","LeftCeiling":"\u2308","LeftDoubleBracket":"\u27E6","LeftDownTeeVector":"\u2961","LeftDownVectorBar":"\u2959","LeftDownVector":"\u21C3","LeftFloor":"\u230A","leftharpoondown":"\u21BD","leftharpoonup":"\u21BC","leftleftarrows":"\u21C7","leftrightarrow":"\u2194","LeftRightArrow":"\u2194","Leftrightarrow":"\u21D4","leftrightarrows":"\u21C6","leftrightharpoons":"\u21CB","leftrightsquigarrow":"\u21AD","LeftRightVector":"\u294E","LeftTeeArrow":"\u21A4","LeftTee":"\u22A3","LeftTeeVector":"\u295A","leftthreetimes":"\u22CB","LeftTriangleBar":"\u29CF","LeftTriangle":"\u22B2","LeftTriangleEqual":"\u22B4","LeftUpDownVector":"\u2951","LeftUpTeeVector":"\u2960","LeftUpVectorBar":"\u2958","LeftUpVector":"\u21BF","LeftVectorBar":"\u2952","LeftVector":"\u21BC","lEg":"\u2A8B","leg":"\u22DA","leq":"\u2264","leqq":"\u2266","leqslant":"\u2A7D","lescc":"\u2AA8","les":"\u2A7D","lesdot":"\u2A7F","lesdoto":"\u2A81","lesdotor":"\u2A83","lesg":"\u22DA\uFE00","lesges":"\u2A93","lessapprox":"\u2A85","lessdot":"\u22D6","lesseqgtr":"\u22DA","lesseqqgtr":"\u2A8B","LessEqualGreater":"\u22DA","LessFullEqual":"\u2266","LessGreater":"\u2276","lessgtr":"\u2276","LessLess":"\u2AA1","lesssim":"\u2272","LessSlantEqual":"\u2A7D","LessTilde":"\u2272","lfisht":"\u297C","lfloor":"\u230A","Lfr":"\uD835\uDD0F","lfr":"\uD835\uDD29","lg":"\u2276","lgE":"\u2A91","lHar":"\u2962","lhard":"\u21BD","lharu":"\u21BC","lharul":"\u296A","lhblk":"\u2584","LJcy":"\u0409","ljcy":"\u0459","llarr":"\u21C7","ll":"\u226A","Ll":"\u22D8","llcorner":"\u231E","Lleftarrow":"\u21DA","llhard":"\u296B","lltri":"\u25FA","Lmidot":"\u013F","lmidot":"\u0140","lmoustache":"\u23B0","lmoust":"\u23B0","lnap":"\u2A89","lnapprox":"\u2A89","lne":"\u2A87","lnE":"\u2268","lneq":"\u2A87","lneqq":"\u2268","lnsim":"\u22E6","loang":"\u27EC","loarr":"\u21FD","lobrk":"\u27E6","longleftarrow":"\u27F5","LongLeftArrow":"\u27F5","Longleftarrow":"\u27F8","longleftrightarrow":"\u27F7","LongLeftRightArrow":"\u27F7","Longleftrightarrow":"\u27FA","longmapsto":"\u27FC","longrightarrow":"\u27F6","LongRightArrow":"\u27F6","Longrightarrow":"\u27F9","looparrowleft":"\u21AB","looparrowright":"\u21AC","lopar":"\u2985","Lopf":"\uD835\uDD43","lopf":"\uD835\uDD5D","loplus":"\u2A2D","lotimes":"\u2A34","lowast":"\u2217","lowbar":"_","LowerLeftArrow":"\u2199","LowerRightArrow":"\u2198","loz":"\u25CA","lozenge":"\u25CA","lozf":"\u29EB","lpar":"(","lparlt":"\u2993","lrarr":"\u21C6","lrcorner":"\u231F","lrhar":"\u21CB","lrhard":"\u296D","lrm":"\u200E","lrtri":"\u22BF","lsaquo":"\u2039","lscr":"\uD835\uDCC1","Lscr":"\u2112","lsh":"\u21B0","Lsh":"\u21B0","lsim":"\u2272","lsime":"\u2A8D","lsimg":"\u2A8F","lsqb":"[","lsquo":"\u2018","lsquor":"\u201A","Lstrok":"\u0141","lstrok":"\u0142","ltcc":"\u2AA6","ltcir":"\u2A79","lt":"<","LT":"<","Lt":"\u226A","ltdot":"\u22D6","lthree":"\u22CB","ltimes":"\u22C9","ltlarr":"\u2976","ltquest":"\u2A7B","ltri":"\u25C3","ltrie":"\u22B4","ltrif":"\u25C2","ltrPar":"\u2996","lurdshar":"\u294A","luruhar":"\u2966","lvertneqq":"\u2268\uFE00","lvnE":"\u2268\uFE00","macr":"\u00AF","male":"\u2642","malt":"\u2720","maltese":"\u2720","Map":"\u2905","map":"\u21A6","mapsto":"\u21A6","mapstodown":"\u21A7","mapstoleft":"\u21A4","mapstoup":"\u21A5","marker":"\u25AE","mcomma":"\u2A29","Mcy":"\u041C","mcy":"\u043C","mdash":"\u2014","mDDot":"\u223A","measuredangle":"\u2221","MediumSpace":"\u205F","Mellintrf":"\u2133","Mfr":"\uD835\uDD10","mfr":"\uD835\uDD2A","mho":"\u2127","micro":"\u00B5","midast":"*","midcir":"\u2AF0","mid":"\u2223","middot":"\u00B7","minusb":"\u229F","minus":"\u2212","minusd":"\u2238","minusdu":"\u2A2A","MinusPlus":"\u2213","mlcp":"\u2ADB","mldr":"\u2026","mnplus":"\u2213","models":"\u22A7","Mopf":"\uD835\uDD44","mopf":"\uD835\uDD5E","mp":"\u2213","mscr":"\uD835\uDCC2","Mscr":"\u2133","mstpos":"\u223E","Mu":"\u039C","mu":"\u03BC","multimap":"\u22B8","mumap":"\u22B8","nabla":"\u2207","Nacute":"\u0143","nacute":"\u0144","nang":"\u2220\u20D2","nap":"\u2249","napE":"\u2A70\u0338","napid":"\u224B\u0338","napos":"\u0149","napprox":"\u2249","natural":"\u266E","naturals":"\u2115","natur":"\u266E","nbsp":"\u00A0","nbump":"\u224E\u0338","nbumpe":"\u224F\u0338","ncap":"\u2A43","Ncaron":"\u0147","ncaron":"\u0148","Ncedil":"\u0145","ncedil":"\u0146","ncong":"\u2247","ncongdot":"\u2A6D\u0338","ncup":"\u2A42","Ncy":"\u041D","ncy":"\u043D","ndash":"\u2013","nearhk":"\u2924","nearr":"\u2197","neArr":"\u21D7","nearrow":"\u2197","ne":"\u2260","nedot":"\u2250\u0338","NegativeMediumSpace":"\u200B","NegativeThickSpace":"\u200B","NegativeThinSpace":"\u200B","NegativeVeryThinSpace":"\u200B","nequiv":"\u2262","nesear":"\u2928","nesim":"\u2242\u0338","NestedGreaterGreater":"\u226B","NestedLessLess":"\u226A","NewLine":"\n","nexist":"\u2204","nexists":"\u2204","Nfr":"\uD835\uDD11","nfr":"\uD835\uDD2B","ngE":"\u2267\u0338","nge":"\u2271","ngeq":"\u2271","ngeqq":"\u2267\u0338","ngeqslant":"\u2A7E\u0338","nges":"\u2A7E\u0338","nGg":"\u22D9\u0338","ngsim":"\u2275","nGt":"\u226B\u20D2","ngt":"\u226F","ngtr":"\u226F","nGtv":"\u226B\u0338","nharr":"\u21AE","nhArr":"\u21CE","nhpar":"\u2AF2","ni":"\u220B","nis":"\u22FC","nisd":"\u22FA","niv":"\u220B","NJcy":"\u040A","njcy":"\u045A","nlarr":"\u219A","nlArr":"\u21CD","nldr":"\u2025","nlE":"\u2266\u0338","nle":"\u2270","nleftarrow":"\u219A","nLeftarrow":"\u21CD","nleftrightarrow":"\u21AE","nLeftrightarrow":"\u21CE","nleq":"\u2270","nleqq":"\u2266\u0338","nleqslant":"\u2A7D\u0338","nles":"\u2A7D\u0338","nless":"\u226E","nLl":"\u22D8\u0338","nlsim":"\u2274","nLt":"\u226A\u20D2","nlt":"\u226E","nltri":"\u22EA","nltrie":"\u22EC","nLtv":"\u226A\u0338","nmid":"\u2224","NoBreak":"\u2060","NonBreakingSpace":"\u00A0","nopf":"\uD835\uDD5F","Nopf":"\u2115","Not":"\u2AEC","not":"\u00AC","NotCongruent":"\u2262","NotCupCap":"\u226D","NotDoubleVerticalBar":"\u2226","NotElement":"\u2209","NotEqual":"\u2260","NotEqualTilde":"\u2242\u0338","NotExists":"\u2204","NotGreater":"\u226F","NotGreaterEqual":"\u2271","NotGreaterFullEqual":"\u2267\u0338","NotGreaterGreater":"\u226B\u0338","NotGreaterLess":"\u2279","NotGreaterSlantEqual":"\u2A7E\u0338","NotGreaterTilde":"\u2275","NotHumpDownHump":"\u224E\u0338","NotHumpEqual":"\u224F\u0338","notin":"\u2209","notindot":"\u22F5\u0338","notinE":"\u22F9\u0338","notinva":"\u2209","notinvb":"\u22F7","notinvc":"\u22F6","NotLeftTriangleBar":"\u29CF\u0338","NotLeftTriangle":"\u22EA","NotLeftTriangleEqual":"\u22EC","NotLess":"\u226E","NotLessEqual":"\u2270","NotLessGreater":"\u2278","NotLessLess":"\u226A\u0338","NotLessSlantEqual":"\u2A7D\u0338","NotLessTilde":"\u2274","NotNestedGreaterGreater":"\u2AA2\u0338","NotNestedLessLess":"\u2AA1\u0338","notni":"\u220C","notniva":"\u220C","notnivb":"\u22FE","notnivc":"\u22FD","NotPrecedes":"\u2280","NotPrecedesEqual":"\u2AAF\u0338","NotPrecedesSlantEqual":"\u22E0","NotReverseElement":"\u220C","NotRightTriangleBar":"\u29D0\u0338","NotRightTriangle":"\u22EB","NotRightTriangleEqual":"\u22ED","NotSquareSubset":"\u228F\u0338","NotSquareSubsetEqual":"\u22E2","NotSquareSuperset":"\u2290\u0338","NotSquareSupersetEqual":"\u22E3","NotSubset":"\u2282\u20D2","NotSubsetEqual":"\u2288","NotSucceeds":"\u2281","NotSucceedsEqual":"\u2AB0\u0338","NotSucceedsSlantEqual":"\u22E1","NotSucceedsTilde":"\u227F\u0338","NotSuperset":"\u2283\u20D2","NotSupersetEqual":"\u2289","NotTilde":"\u2241","NotTildeEqual":"\u2244","NotTildeFullEqual":"\u2247","NotTildeTilde":"\u2249","NotVerticalBar":"\u2224","nparallel":"\u2226","npar":"\u2226","nparsl":"\u2AFD\u20E5","npart":"\u2202\u0338","npolint":"\u2A14","npr":"\u2280","nprcue":"\u22E0","nprec":"\u2280","npreceq":"\u2AAF\u0338","npre":"\u2AAF\u0338","nrarrc":"\u2933\u0338","nrarr":"\u219B","nrArr":"\u21CF","nrarrw":"\u219D\u0338","nrightarrow":"\u219B","nRightarrow":"\u21CF","nrtri":"\u22EB","nrtrie":"\u22ED","nsc":"\u2281","nsccue":"\u22E1","nsce":"\u2AB0\u0338","Nscr":"\uD835\uDCA9","nscr":"\uD835\uDCC3","nshortmid":"\u2224","nshortparallel":"\u2226","nsim":"\u2241","nsime":"\u2244","nsimeq":"\u2244","nsmid":"\u2224","nspar":"\u2226","nsqsube":"\u22E2","nsqsupe":"\u22E3","nsub":"\u2284","nsubE":"\u2AC5\u0338","nsube":"\u2288","nsubset":"\u2282\u20D2","nsubseteq":"\u2288","nsubseteqq":"\u2AC5\u0338","nsucc":"\u2281","nsucceq":"\u2AB0\u0338","nsup":"\u2285","nsupE":"\u2AC6\u0338","nsupe":"\u2289","nsupset":"\u2283\u20D2","nsupseteq":"\u2289","nsupseteqq":"\u2AC6\u0338","ntgl":"\u2279","Ntilde":"\u00D1","ntilde":"\u00F1","ntlg":"\u2278","ntriangleleft":"\u22EA","ntrianglelefteq":"\u22EC","ntriangleright":"\u22EB","ntrianglerighteq":"\u22ED","Nu":"\u039D","nu":"\u03BD","num":"#","numero":"\u2116","numsp":"\u2007","nvap":"\u224D\u20D2","nvdash":"\u22AC","nvDash":"\u22AD","nVdash":"\u22AE","nVDash":"\u22AF","nvge":"\u2265\u20D2","nvgt":">\u20D2","nvHarr":"\u2904","nvinfin":"\u29DE","nvlArr":"\u2902","nvle":"\u2264\u20D2","nvlt":"<\u20D2","nvltrie":"\u22B4\u20D2","nvrArr":"\u2903","nvrtrie":"\u22B5\u20D2","nvsim":"\u223C\u20D2","nwarhk":"\u2923","nwarr":"\u2196","nwArr":"\u21D6","nwarrow":"\u2196","nwnear":"\u2927","Oacute":"\u00D3","oacute":"\u00F3","oast":"\u229B","Ocirc":"\u00D4","ocirc":"\u00F4","ocir":"\u229A","Ocy":"\u041E","ocy":"\u043E","odash":"\u229D","Odblac":"\u0150","odblac":"\u0151","odiv":"\u2A38","odot":"\u2299","odsold":"\u29BC","OElig":"\u0152","oelig":"\u0153","ofcir":"\u29BF","Ofr":"\uD835\uDD12","ofr":"\uD835\uDD2C","ogon":"\u02DB","Ograve":"\u00D2","ograve":"\u00F2","ogt":"\u29C1","ohbar":"\u29B5","ohm":"\u03A9","oint":"\u222E","olarr":"\u21BA","olcir":"\u29BE","olcross":"\u29BB","oline":"\u203E","olt":"\u29C0","Omacr":"\u014C","omacr":"\u014D","Omega":"\u03A9","omega":"\u03C9","Omicron":"\u039F","omicron":"\u03BF","omid":"\u29B6","ominus":"\u2296","Oopf":"\uD835\uDD46","oopf":"\uD835\uDD60","opar":"\u29B7","OpenCurlyDoubleQuote":"\u201C","OpenCurlyQuote":"\u2018","operp":"\u29B9","oplus":"\u2295","orarr":"\u21BB","Or":"\u2A54","or":"\u2228","ord":"\u2A5D","order":"\u2134","orderof":"\u2134","ordf":"\u00AA","ordm":"\u00BA","origof":"\u22B6","oror":"\u2A56","orslope":"\u2A57","orv":"\u2A5B","oS":"\u24C8","Oscr":"\uD835\uDCAA","oscr":"\u2134","Oslash":"\u00D8","oslash":"\u00F8","osol":"\u2298","Otilde":"\u00D5","otilde":"\u00F5","otimesas":"\u2A36","Otimes":"\u2A37","otimes":"\u2297","Ouml":"\u00D6","ouml":"\u00F6","ovbar":"\u233D","OverBar":"\u203E","OverBrace":"\u23DE","OverBracket":"\u23B4","OverParenthesis":"\u23DC","para":"\u00B6","parallel":"\u2225","par":"\u2225","parsim":"\u2AF3","parsl":"\u2AFD","part":"\u2202","PartialD":"\u2202","Pcy":"\u041F","pcy":"\u043F","percnt":"%","period":".","permil":"\u2030","perp":"\u22A5","pertenk":"\u2031","Pfr":"\uD835\uDD13","pfr":"\uD835\uDD2D","Phi":"\u03A6","phi":"\u03C6","phiv":"\u03D5","phmmat":"\u2133","phone":"\u260E","Pi":"\u03A0","pi":"\u03C0","pitchfork":"\u22D4","piv":"\u03D6","planck":"\u210F","planckh":"\u210E","plankv":"\u210F","plusacir":"\u2A23","plusb":"\u229E","pluscir":"\u2A22","plus":"+","plusdo":"\u2214","plusdu":"\u2A25","pluse":"\u2A72","PlusMinus":"\u00B1","plusmn":"\u00B1","plussim":"\u2A26","plustwo":"\u2A27","pm":"\u00B1","Poincareplane":"\u210C","pointint":"\u2A15","popf":"\uD835\uDD61","Popf":"\u2119","pound":"\u00A3","prap":"\u2AB7","Pr":"\u2ABB","pr":"\u227A","prcue":"\u227C","precapprox":"\u2AB7","prec":"\u227A","preccurlyeq":"\u227C","Precedes":"\u227A","PrecedesEqual":"\u2AAF","PrecedesSlantEqual":"\u227C","PrecedesTilde":"\u227E","preceq":"\u2AAF","precnapprox":"\u2AB9","precneqq":"\u2AB5","precnsim":"\u22E8","pre":"\u2AAF","prE":"\u2AB3","precsim":"\u227E","prime":"\u2032","Prime":"\u2033","primes":"\u2119","prnap":"\u2AB9","prnE":"\u2AB5","prnsim":"\u22E8","prod":"\u220F","Product":"\u220F","profalar":"\u232E","profline":"\u2312","profsurf":"\u2313","prop":"\u221D","Proportional":"\u221D","Proportion":"\u2237","propto":"\u221D","prsim":"\u227E","prurel":"\u22B0","Pscr":"\uD835\uDCAB","pscr":"\uD835\uDCC5","Psi":"\u03A8","psi":"\u03C8","puncsp":"\u2008","Qfr":"\uD835\uDD14","qfr":"\uD835\uDD2E","qint":"\u2A0C","qopf":"\uD835\uDD62","Qopf":"\u211A","qprime":"\u2057","Qscr":"\uD835\uDCAC","qscr":"\uD835\uDCC6","quaternions":"\u210D","quatint":"\u2A16","quest":"?","questeq":"\u225F","quot":"\"","QUOT":"\"","rAarr":"\u21DB","race":"\u223D\u0331","Racute":"\u0154","racute":"\u0155","radic":"\u221A","raemptyv":"\u29B3","rang":"\u27E9","Rang":"\u27EB","rangd":"\u2992","range":"\u29A5","rangle":"\u27E9","raquo":"\u00BB","rarrap":"\u2975","rarrb":"\u21E5","rarrbfs":"\u2920","rarrc":"\u2933","rarr":"\u2192","Rarr":"\u21A0","rArr":"\u21D2","rarrfs":"\u291E","rarrhk":"\u21AA","rarrlp":"\u21AC","rarrpl":"\u2945","rarrsim":"\u2974","Rarrtl":"\u2916","rarrtl":"\u21A3","rarrw":"\u219D","ratail":"\u291A","rAtail":"\u291C","ratio":"\u2236","rationals":"\u211A","rbarr":"\u290D","rBarr":"\u290F","RBarr":"\u2910","rbbrk":"\u2773","rbrace":"}","rbrack":"]","rbrke":"\u298C","rbrksld":"\u298E","rbrkslu":"\u2990","Rcaron":"\u0158","rcaron":"\u0159","Rcedil":"\u0156","rcedil":"\u0157","rceil":"\u2309","rcub":"}","Rcy":"\u0420","rcy":"\u0440","rdca":"\u2937","rdldhar":"\u2969","rdquo":"\u201D","rdquor":"\u201D","rdsh":"\u21B3","real":"\u211C","realine":"\u211B","realpart":"\u211C","reals":"\u211D","Re":"\u211C","rect":"\u25AD","reg":"\u00AE","REG":"\u00AE","ReverseElement":"\u220B","ReverseEquilibrium":"\u21CB","ReverseUpEquilibrium":"\u296F","rfisht":"\u297D","rfloor":"\u230B","rfr":"\uD835\uDD2F","Rfr":"\u211C","rHar":"\u2964","rhard":"\u21C1","rharu":"\u21C0","rharul":"\u296C","Rho":"\u03A1","rho":"\u03C1","rhov":"\u03F1","RightAngleBracket":"\u27E9","RightArrowBar":"\u21E5","rightarrow":"\u2192","RightArrow":"\u2192","Rightarrow":"\u21D2","RightArrowLeftArrow":"\u21C4","rightarrowtail":"\u21A3","RightCeiling":"\u2309","RightDoubleBracket":"\u27E7","RightDownTeeVector":"\u295D","RightDownVectorBar":"\u2955","RightDownVector":"\u21C2","RightFloor":"\u230B","rightharpoondown":"\u21C1","rightharpoonup":"\u21C0","rightleftarrows":"\u21C4","rightleftharpoons":"\u21CC","rightrightarrows":"\u21C9","rightsquigarrow":"\u219D","RightTeeArrow":"\u21A6","RightTee":"\u22A2","RightTeeVector":"\u295B","rightthreetimes":"\u22CC","RightTriangleBar":"\u29D0","RightTriangle":"\u22B3","RightTriangleEqual":"\u22B5","RightUpDownVector":"\u294F","RightUpTeeVector":"\u295C","RightUpVectorBar":"\u2954","RightUpVector":"\u21BE","RightVectorBar":"\u2953","RightVector":"\u21C0","ring":"\u02DA","risingdotseq":"\u2253","rlarr":"\u21C4","rlhar":"\u21CC","rlm":"\u200F","rmoustache":"\u23B1","rmoust":"\u23B1","rnmid":"\u2AEE","roang":"\u27ED","roarr":"\u21FE","robrk":"\u27E7","ropar":"\u2986","ropf":"\uD835\uDD63","Ropf":"\u211D","roplus":"\u2A2E","rotimes":"\u2A35","RoundImplies":"\u2970","rpar":")","rpargt":"\u2994","rppolint":"\u2A12","rrarr":"\u21C9","Rrightarrow":"\u21DB","rsaquo":"\u203A","rscr":"\uD835\uDCC7","Rscr":"\u211B","rsh":"\u21B1","Rsh":"\u21B1","rsqb":"]","rsquo":"\u2019","rsquor":"\u2019","rthree":"\u22CC","rtimes":"\u22CA","rtri":"\u25B9","rtrie":"\u22B5","rtrif":"\u25B8","rtriltri":"\u29CE","RuleDelayed":"\u29F4","ruluhar":"\u2968","rx":"\u211E","Sacute":"\u015A","sacute":"\u015B","sbquo":"\u201A","scap":"\u2AB8","Scaron":"\u0160","scaron":"\u0161","Sc":"\u2ABC","sc":"\u227B","sccue":"\u227D","sce":"\u2AB0","scE":"\u2AB4","Scedil":"\u015E","scedil":"\u015F","Scirc":"\u015C","scirc":"\u015D","scnap":"\u2ABA","scnE":"\u2AB6","scnsim":"\u22E9","scpolint":"\u2A13","scsim":"\u227F","Scy":"\u0421","scy":"\u0441","sdotb":"\u22A1","sdot":"\u22C5","sdote":"\u2A66","searhk":"\u2925","searr":"\u2198","seArr":"\u21D8","searrow":"\u2198","sect":"\u00A7","semi":";","seswar":"\u2929","setminus":"\u2216","setmn":"\u2216","sext":"\u2736","Sfr":"\uD835\uDD16","sfr":"\uD835\uDD30","sfrown":"\u2322","sharp":"\u266F","SHCHcy":"\u0429","shchcy":"\u0449","SHcy":"\u0428","shcy":"\u0448","ShortDownArrow":"\u2193","ShortLeftArrow":"\u2190","shortmid":"\u2223","shortparallel":"\u2225","ShortRightArrow":"\u2192","ShortUpArrow":"\u2191","shy":"\u00AD","Sigma":"\u03A3","sigma":"\u03C3","sigmaf":"\u03C2","sigmav":"\u03C2","sim":"\u223C","simdot":"\u2A6A","sime":"\u2243","simeq":"\u2243","simg":"\u2A9E","simgE":"\u2AA0","siml":"\u2A9D","simlE":"\u2A9F","simne":"\u2246","simplus":"\u2A24","simrarr":"\u2972","slarr":"\u2190","SmallCircle":"\u2218","smallsetminus":"\u2216","smashp":"\u2A33","smeparsl":"\u29E4","smid":"\u2223","smile":"\u2323","smt":"\u2AAA","smte":"\u2AAC","smtes":"\u2AAC\uFE00","SOFTcy":"\u042C","softcy":"\u044C","solbar":"\u233F","solb":"\u29C4","sol":"/","Sopf":"\uD835\uDD4A","sopf":"\uD835\uDD64","spades":"\u2660","spadesuit":"\u2660","spar":"\u2225","sqcap":"\u2293","sqcaps":"\u2293\uFE00","sqcup":"\u2294","sqcups":"\u2294\uFE00","Sqrt":"\u221A","sqsub":"\u228F","sqsube":"\u2291","sqsubset":"\u228F","sqsubseteq":"\u2291","sqsup":"\u2290","sqsupe":"\u2292","sqsupset":"\u2290","sqsupseteq":"\u2292","square":"\u25A1","Square":"\u25A1","SquareIntersection":"\u2293","SquareSubset":"\u228F","SquareSubsetEqual":"\u2291","SquareSuperset":"\u2290","SquareSupersetEqual":"\u2292","SquareUnion":"\u2294","squarf":"\u25AA","squ":"\u25A1","squf":"\u25AA","srarr":"\u2192","Sscr":"\uD835\uDCAE","sscr":"\uD835\uDCC8","ssetmn":"\u2216","ssmile":"\u2323","sstarf":"\u22C6","Star":"\u22C6","star":"\u2606","starf":"\u2605","straightepsilon":"\u03F5","straightphi":"\u03D5","strns":"\u00AF","sub":"\u2282","Sub":"\u22D0","subdot":"\u2ABD","subE":"\u2AC5","sube":"\u2286","subedot":"\u2AC3","submult":"\u2AC1","subnE":"\u2ACB","subne":"\u228A","subplus":"\u2ABF","subrarr":"\u2979","subset":"\u2282","Subset":"\u22D0","subseteq":"\u2286","subseteqq":"\u2AC5","SubsetEqual":"\u2286","subsetneq":"\u228A","subsetneqq":"\u2ACB","subsim":"\u2AC7","subsub":"\u2AD5","subsup":"\u2AD3","succapprox":"\u2AB8","succ":"\u227B","succcurlyeq":"\u227D","Succeeds":"\u227B","SucceedsEqual":"\u2AB0","SucceedsSlantEqual":"\u227D","SucceedsTilde":"\u227F","succeq":"\u2AB0","succnapprox":"\u2ABA","succneqq":"\u2AB6","succnsim":"\u22E9","succsim":"\u227F","SuchThat":"\u220B","sum":"\u2211","Sum":"\u2211","sung":"\u266A","sup1":"\u00B9","sup2":"\u00B2","sup3":"\u00B3","sup":"\u2283","Sup":"\u22D1","supdot":"\u2ABE","supdsub":"\u2AD8","supE":"\u2AC6","supe":"\u2287","supedot":"\u2AC4","Superset":"\u2283","SupersetEqual":"\u2287","suphsol":"\u27C9","suphsub":"\u2AD7","suplarr":"\u297B","supmult":"\u2AC2","supnE":"\u2ACC","supne":"\u228B","supplus":"\u2AC0","supset":"\u2283","Supset":"\u22D1","supseteq":"\u2287","supseteqq":"\u2AC6","supsetneq":"\u228B","supsetneqq":"\u2ACC","supsim":"\u2AC8","supsub":"\u2AD4","supsup":"\u2AD6","swarhk":"\u2926","swarr":"\u2199","swArr":"\u21D9","swarrow":"\u2199","swnwar":"\u292A","szlig":"\u00DF","Tab":"\t","target":"\u2316","Tau":"\u03A4","tau":"\u03C4","tbrk":"\u23B4","Tcaron":"\u0164","tcaron":"\u0165","Tcedil":"\u0162","tcedil":"\u0163","Tcy":"\u0422","tcy":"\u0442","tdot":"\u20DB","telrec":"\u2315","Tfr":"\uD835\uDD17","tfr":"\uD835\uDD31","there4":"\u2234","therefore":"\u2234","Therefore":"\u2234","Theta":"\u0398","theta":"\u03B8","thetasym":"\u03D1","thetav":"\u03D1","thickapprox":"\u2248","thicksim":"\u223C","ThickSpace":"\u205F\u200A","ThinSpace":"\u2009","thinsp":"\u2009","thkap":"\u2248","thksim":"\u223C","THORN":"\u00DE","thorn":"\u00FE","tilde":"\u02DC","Tilde":"\u223C","TildeEqual":"\u2243","TildeFullEqual":"\u2245","TildeTilde":"\u2248","timesbar":"\u2A31","timesb":"\u22A0","times":"\u00D7","timesd":"\u2A30","tint":"\u222D","toea":"\u2928","topbot":"\u2336","topcir":"\u2AF1","top":"\u22A4","Topf":"\uD835\uDD4B","topf":"\uD835\uDD65","topfork":"\u2ADA","tosa":"\u2929","tprime":"\u2034","trade":"\u2122","TRADE":"\u2122","triangle":"\u25B5","triangledown":"\u25BF","triangleleft":"\u25C3","trianglelefteq":"\u22B4","triangleq":"\u225C","triangleright":"\u25B9","trianglerighteq":"\u22B5","tridot":"\u25EC","trie":"\u225C","triminus":"\u2A3A","TripleDot":"\u20DB","triplus":"\u2A39","trisb":"\u29CD","tritime":"\u2A3B","trpezium":"\u23E2","Tscr":"\uD835\uDCAF","tscr":"\uD835\uDCC9","TScy":"\u0426","tscy":"\u0446","TSHcy":"\u040B","tshcy":"\u045B","Tstrok":"\u0166","tstrok":"\u0167","twixt":"\u226C","twoheadleftarrow":"\u219E","twoheadrightarrow":"\u21A0","Uacute":"\u00DA","uacute":"\u00FA","uarr":"\u2191","Uarr":"\u219F","uArr":"\u21D1","Uarrocir":"\u2949","Ubrcy":"\u040E","ubrcy":"\u045E","Ubreve":"\u016C","ubreve":"\u016D","Ucirc":"\u00DB","ucirc":"\u00FB","Ucy":"\u0423","ucy":"\u0443","udarr":"\u21C5","Udblac":"\u0170","udblac":"\u0171","udhar":"\u296E","ufisht":"\u297E","Ufr":"\uD835\uDD18","ufr":"\uD835\uDD32","Ugrave":"\u00D9","ugrave":"\u00F9","uHar":"\u2963","uharl":"\u21BF","uharr":"\u21BE","uhblk":"\u2580","ulcorn":"\u231C","ulcorner":"\u231C","ulcrop":"\u230F","ultri":"\u25F8","Umacr":"\u016A","umacr":"\u016B","uml":"\u00A8","UnderBar":"_","UnderBrace":"\u23DF","UnderBracket":"\u23B5","UnderParenthesis":"\u23DD","Union":"\u22C3","UnionPlus":"\u228E","Uogon":"\u0172","uogon":"\u0173","Uopf":"\uD835\uDD4C","uopf":"\uD835\uDD66","UpArrowBar":"\u2912","uparrow":"\u2191","UpArrow":"\u2191","Uparrow":"\u21D1","UpArrowDownArrow":"\u21C5","updownarrow":"\u2195","UpDownArrow":"\u2195","Updownarrow":"\u21D5","UpEquilibrium":"\u296E","upharpoonleft":"\u21BF","upharpoonright":"\u21BE","uplus":"\u228E","UpperLeftArrow":"\u2196","UpperRightArrow":"\u2197","upsi":"\u03C5","Upsi":"\u03D2","upsih":"\u03D2","Upsilon":"\u03A5","upsilon":"\u03C5","UpTeeArrow":"\u21A5","UpTee":"\u22A5","upuparrows":"\u21C8","urcorn":"\u231D","urcorner":"\u231D","urcrop":"\u230E","Uring":"\u016E","uring":"\u016F","urtri":"\u25F9","Uscr":"\uD835\uDCB0","uscr":"\uD835\uDCCA","utdot":"\u22F0","Utilde":"\u0168","utilde":"\u0169","utri":"\u25B5","utrif":"\u25B4","uuarr":"\u21C8","Uuml":"\u00DC","uuml":"\u00FC","uwangle":"\u29A7","vangrt":"\u299C","varepsilon":"\u03F5","varkappa":"\u03F0","varnothing":"\u2205","varphi":"\u03D5","varpi":"\u03D6","varpropto":"\u221D","varr":"\u2195","vArr":"\u21D5","varrho":"\u03F1","varsigma":"\u03C2","varsubsetneq":"\u228A\uFE00","varsubsetneqq":"\u2ACB\uFE00","varsupsetneq":"\u228B\uFE00","varsupsetneqq":"\u2ACC\uFE00","vartheta":"\u03D1","vartriangleleft":"\u22B2","vartriangleright":"\u22B3","vBar":"\u2AE8","Vbar":"\u2AEB","vBarv":"\u2AE9","Vcy":"\u0412","vcy":"\u0432","vdash":"\u22A2","vDash":"\u22A8","Vdash":"\u22A9","VDash":"\u22AB","Vdashl":"\u2AE6","veebar":"\u22BB","vee":"\u2228","Vee":"\u22C1","veeeq":"\u225A","vellip":"\u22EE","verbar":"|","Verbar":"\u2016","vert":"|","Vert":"\u2016","VerticalBar":"\u2223","VerticalLine":"|","VerticalSeparator":"\u2758","VerticalTilde":"\u2240","VeryThinSpace":"\u200A","Vfr":"\uD835\uDD19","vfr":"\uD835\uDD33","vltri":"\u22B2","vnsub":"\u2282\u20D2","vnsup":"\u2283\u20D2","Vopf":"\uD835\uDD4D","vopf":"\uD835\uDD67","vprop":"\u221D","vrtri":"\u22B3","Vscr":"\uD835\uDCB1","vscr":"\uD835\uDCCB","vsubnE":"\u2ACB\uFE00","vsubne":"\u228A\uFE00","vsupnE":"\u2ACC\uFE00","vsupne":"\u228B\uFE00","Vvdash":"\u22AA","vzigzag":"\u299A","Wcirc":"\u0174","wcirc":"\u0175","wedbar":"\u2A5F","wedge":"\u2227","Wedge":"\u22C0","wedgeq":"\u2259","weierp":"\u2118","Wfr":"\uD835\uDD1A","wfr":"\uD835\uDD34","Wopf":"\uD835\uDD4E","wopf":"\uD835\uDD68","wp":"\u2118","wr":"\u2240","wreath":"\u2240","Wscr":"\uD835\uDCB2","wscr":"\uD835\uDCCC","xcap":"\u22C2","xcirc":"\u25EF","xcup":"\u22C3","xdtri":"\u25BD","Xfr":"\uD835\uDD1B","xfr":"\uD835\uDD35","xharr":"\u27F7","xhArr":"\u27FA","Xi":"\u039E","xi":"\u03BE","xlarr":"\u27F5","xlArr":"\u27F8","xmap":"\u27FC","xnis":"\u22FB","xodot":"\u2A00","Xopf":"\uD835\uDD4F","xopf":"\uD835\uDD69","xoplus":"\u2A01","xotime":"\u2A02","xrarr":"\u27F6","xrArr":"\u27F9","Xscr":"\uD835\uDCB3","xscr":"\uD835\uDCCD","xsqcup":"\u2A06","xuplus":"\u2A04","xutri":"\u25B3","xvee":"\u22C1","xwedge":"\u22C0","Yacute":"\u00DD","yacute":"\u00FD","YAcy":"\u042F","yacy":"\u044F","Ycirc":"\u0176","ycirc":"\u0177","Ycy":"\u042B","ycy":"\u044B","yen":"\u00A5","Yfr":"\uD835\uDD1C","yfr":"\uD835\uDD36","YIcy":"\u0407","yicy":"\u0457","Yopf":"\uD835\uDD50","yopf":"\uD835\uDD6A","Yscr":"\uD835\uDCB4","yscr":"\uD835\uDCCE","YUcy":"\u042E","yucy":"\u044E","yuml":"\u00FF","Yuml":"\u0178","Zacute":"\u0179","zacute":"\u017A","Zcaron":"\u017D","zcaron":"\u017E","Zcy":"\u0417","zcy":"\u0437","Zdot":"\u017B","zdot":"\u017C","zeetrf":"\u2128","ZeroWidthSpace":"\u200B","Zeta":"\u0396","zeta":"\u03B6","zfr":"\uD835\uDD37","Zfr":"\u2128","ZHcy":"\u0416","zhcy":"\u0436","zigrarr":"\u21DD","zopf":"\uD835\uDD6B","Zopf":"\u2124","Zscr":"\uD835\uDCB5","zscr":"\uD835\uDCCF","zwj":"\u200D","zwnj":"\u200C"}},{}],53:[function(require,module,exports){'use strict';function assign(obj){var sources=Array.prototype.slice.call(arguments,1);sources.forEach(function(source){if(!source){return;}
Object.keys(source).forEach(function(key){obj[key]=source[key];});});return obj;}
function _class(obj){return Object.prototype.toString.call(obj);}
function isString(obj){return _class(obj)==='[object String]';}
function isObject(obj){return _class(obj)==='[object Object]';}
function isRegExp(obj){return _class(obj)==='[object RegExp]';}
function isFunction(obj){return _class(obj)==='[object Function]';}
function escapeRE(str){return str.replace(/[.?*+^$[\]\\(){}|-]/g,'\\$&');}
var defaultOptions={fuzzyLink:true,fuzzyEmail:true,fuzzyIP:false};function isOptionsObj(obj){return Object.keys(obj||{}).reduce(function(acc,k){return acc||defaultOptions.hasOwnProperty(k);},false);}
var defaultSchemas={'http:':{validate:function(text,pos,self){var tail=text.slice(pos);if(!self.re.http){self.re.http=new RegExp('^\\/\\/'+self.re.src_auth+self.re.src_host_port_strict+self.re.src_path,'i');}
if(self.re.http.test(tail)){return tail.match(self.re.http)[0].length;}
return 0;}},'https:':'http:','ftp:':'http:','//':{validate:function(text,pos,self){var tail=text.slice(pos);if(!self.re.no_http){self.re.no_http=new RegExp('^'+
self.re.src_auth+'(?:localhost|(?:(?:'+self.re.src_domain+')\\.)+'+self.re.src_domain_root+')'+
self.re.src_port+
self.re.src_host_terminator+
self.re.src_path,'i');}
if(self.re.no_http.test(tail)){if(pos>=3&&text[pos-3]===':'){return 0;}
if(pos>=3&&text[pos-3]==='/'){return 0;}
return tail.match(self.re.no_http)[0].length;}
return 0;}},'mailto:':{validate:function(text,pos,self){var tail=text.slice(pos);if(!self.re.mailto){self.re.mailto=new RegExp('^'+self.re.src_email_name+'@'+self.re.src_host_strict,'i');}
if(self.re.mailto.test(tail)){return tail.match(self.re.mailto)[0].length;}
return 0;}}};var tlds_2ch_src_re='a[cdefgilmnoqrstuwxz]|b[abdefghijmnorstvwyz]|c[acdfghiklmnoruvwxyz]|d[ejkmoz]|e[cegrstu]|f[ijkmor]|g[abdefghilmnpqrstuwy]|h[kmnrtu]|i[delmnoqrst]|j[emop]|k[eghimnprwyz]|l[abcikrstuvy]|m[acdeghklmnopqrstuvwxyz]|n[acefgilopruz]|om|p[aefghklmnrstwy]|qa|r[eosuw]|s[abcdeghijklmnortuvxyz]|t[cdfghjklmnortvwz]|u[agksyz]|v[aceginu]|w[fs]|y[et]|z[amw]';var tlds_default='biz|com|edu|gov|net|org|pro|web|xxx|aero|asia|coop|info|museum|name|shop|Ñ€Ñ„'.split('|');function resetScanCache(self){self.__index__=-1;self.__text_cache__='';}
function createValidator(re){return function(text,pos){var tail=text.slice(pos);if(re.test(tail)){return tail.match(re)[0].length;}
return 0;};}
function createNormalizer(){return function(match,self){self.normalize(match);};}
function compile(self){var re=self.re=require('./lib/re')(self.__opts__);var tlds=self.__tlds__.slice();self.onCompile();if(!self.__tlds_replaced__){tlds.push(tlds_2ch_src_re);}
tlds.push(re.src_xn);re.src_tlds=tlds.join('|');function untpl(tpl){return tpl.replace('%TLDS%',re.src_tlds);}
re.email_fuzzy=RegExp(untpl(re.tpl_email_fuzzy),'i');re.link_fuzzy=RegExp(untpl(re.tpl_link_fuzzy),'i');re.link_no_ip_fuzzy=RegExp(untpl(re.tpl_link_no_ip_fuzzy),'i');re.host_fuzzy_test=RegExp(untpl(re.tpl_host_fuzzy_test),'i');var aliases=[];self.__compiled__={};function schemaError(name,val){throw new Error('(LinkifyIt) Invalid schema "'+name+'": '+val);}
Object.keys(self.__schemas__).forEach(function(name){var val=self.__schemas__[name];if(val===null){return;}
var compiled={validate:null,link:null};self.__compiled__[name]=compiled;if(isObject(val)){if(isRegExp(val.validate)){compiled.validate=createValidator(val.validate);}else if(isFunction(val.validate)){compiled.validate=val.validate;}else{schemaError(name,val);}
if(isFunction(val.normalize)){compiled.normalize=val.normalize;}else if(!val.normalize){compiled.normalize=createNormalizer();}else{schemaError(name,val);}
return;}
if(isString(val)){aliases.push(name);return;}
schemaError(name,val);});aliases.forEach(function(alias){if(!self.__compiled__[self.__schemas__[alias]]){return;}
self.__compiled__[alias].validate=self.__compiled__[self.__schemas__[alias]].validate;self.__compiled__[alias].normalize=self.__compiled__[self.__schemas__[alias]].normalize;});self.__compiled__['']={validate:null,normalize:createNormalizer()};var slist=Object.keys(self.__compiled__).filter(function(name){return name.length>0&&self.__compiled__[name];}).map(escapeRE).join('|');self.re.schema_test=RegExp('(^|(?!_)(?:[><\uff5c]|'+re.src_ZPCc+'))('+slist+')','i');self.re.schema_search=RegExp('(^|(?!_)(?:[><\uff5c]|'+re.src_ZPCc+'))('+slist+')','ig');self.re.pretest=RegExp('('+self.re.schema_test.source+')|'+'('+self.re.host_fuzzy_test.source+')|'+'@','i');resetScanCache(self);}
function Match(self,shift){var start=self.__index__,end=self.__last_index__,text=self.__text_cache__.slice(start,end);this.schema=self.__schema__.toLowerCase();this.index=start+shift;this.lastIndex=end+shift;this.raw=text;this.text=text;this.url=text;}
function createMatch(self,shift){var match=new Match(self,shift);self.__compiled__[match.schema].normalize(match,self);return match;}
function LinkifyIt(schemas,options){if(!(this instanceof LinkifyIt)){return new LinkifyIt(schemas,options);}
if(!options){if(isOptionsObj(schemas)){options=schemas;schemas={};}}
this.__opts__=assign({},defaultOptions,options);this.__index__=-1;this.__last_index__=-1;this.__schema__='';this.__text_cache__='';this.__schemas__=assign({},defaultSchemas,schemas);this.__compiled__={};this.__tlds__=tlds_default;this.__tlds_replaced__=false;this.re={};compile(this);}
LinkifyIt.prototype.add=function add(schema,definition){this.__schemas__[schema]=definition;compile(this);return this;};LinkifyIt.prototype.set=function set(options){this.__opts__=assign(this.__opts__,options);return this;};LinkifyIt.prototype.test=function test(text){this.__text_cache__=text;this.__index__=-1;if(!text.length){return false;}
var m,ml,me,len,shift,next,re,tld_pos,at_pos;if(this.re.schema_test.test(text)){re=this.re.schema_search;re.lastIndex=0;while((m=re.exec(text))!==null){len=this.testSchemaAt(text,m[2],re.lastIndex);if(len){this.__schema__=m[2];this.__index__=m.index+m[1].length;this.__last_index__=m.index+m[0].length+len;break;}}}
if(this.__opts__.fuzzyLink&&this.__compiled__['http:']){tld_pos=text.search(this.re.host_fuzzy_test);if(tld_pos>=0){if(this.__index__<0||tld_pos<this.__index__){if((ml=text.match(this.__opts__.fuzzyIP?this.re.link_fuzzy:this.re.link_no_ip_fuzzy))!==null){shift=ml.index+ml[1].length;if(this.__index__<0||shift<this.__index__){this.__schema__='';this.__index__=shift;this.__last_index__=ml.index+ml[0].length;}}}}}
if(this.__opts__.fuzzyEmail&&this.__compiled__['mailto:']){at_pos=text.indexOf('@');if(at_pos>=0){if((me=text.match(this.re.email_fuzzy))!==null){shift=me.index+me[1].length;next=me.index+me[0].length;if(this.__index__<0||shift<this.__index__||(shift===this.__index__&&next>this.__last_index__)){this.__schema__='mailto:';this.__index__=shift;this.__last_index__=next;}}}}
return this.__index__>=0;};LinkifyIt.prototype.pretest=function pretest(text){return this.re.pretest.test(text);};LinkifyIt.prototype.testSchemaAt=function testSchemaAt(text,schema,pos){if(!this.__compiled__[schema.toLowerCase()]){return 0;}
return this.__compiled__[schema.toLowerCase()].validate(text,pos,this);};LinkifyIt.prototype.match=function match(text){var shift=0,result=[];if(this.__index__>=0&&this.__text_cache__===text){result.push(createMatch(this,shift));shift=this.__last_index__;}
var tail=shift?text.slice(shift):text;while(this.test(tail)){result.push(createMatch(this,shift));tail=tail.slice(this.__last_index__);shift+=this.__last_index__;}
if(result.length){return result;}
return null;};LinkifyIt.prototype.tlds=function tlds(list,keepOld){list=Array.isArray(list)?list:[list];if(!keepOld){this.__tlds__=list.slice();this.__tlds_replaced__=true;compile(this);return this;}
this.__tlds__=this.__tlds__.concat(list).sort().filter(function(el,idx,arr){return el!==arr[idx-1];}).reverse();compile(this);return this;};LinkifyIt.prototype.normalize=function normalize(match){if(!match.schema){match.url='http://'+match.url;}
if(match.schema==='mailto:'&&!/^mailto:/i.test(match.url)){match.url='mailto:'+match.url;}};LinkifyIt.prototype.onCompile=function onCompile(){};module.exports=LinkifyIt;},{"./lib/re":54}],54:[function(require,module,exports){'use strict';module.exports=function(opts){var re={};re.src_Any=require('uc.micro/properties/Any/regex').source;re.src_Cc=require('uc.micro/categories/Cc/regex').source;re.src_Z=require('uc.micro/categories/Z/regex').source;re.src_P=require('uc.micro/categories/P/regex').source;re.src_ZPCc=[re.src_Z,re.src_P,re.src_Cc].join('|');re.src_ZCc=[re.src_Z,re.src_Cc].join('|');var text_separators='[><\uff5c]';re.src_pseudo_letter='(?:(?!'+text_separators+'|'+re.src_ZPCc+')'+re.src_Any+')';re.src_ip4='(?:(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)';re.src_auth='(?:(?:(?!'+re.src_ZCc+'|[@/\\[\\]()]).)+@)?';re.src_port='(?::(?:6(?:[0-4]\\d{3}|5(?:[0-4]\\d{2}|5(?:[0-2]\\d|3[0-5])))|[1-5]?\\d{1,4}))?';re.src_host_terminator='(?=$|'+text_separators+'|'+re.src_ZPCc+')(?!-|_|:\\d|\\.-|\\.(?!$|'+re.src_ZPCc+'))';re.src_path='(?:'+'[/?#]'+'(?:'+'(?!'+re.src_ZCc+'|'+text_separators+'|[()[\\]{}.,"\'?!\\-]).|'+'\\[(?:(?!'+re.src_ZCc+'|\\]).)*\\]|'+'\\((?:(?!'+re.src_ZCc+'|[)]).)*\\)|'+'\\{(?:(?!'+re.src_ZCc+'|[}]).)*\\}|'+'\\"(?:(?!'+re.src_ZCc+'|["]).)+\\"|'+"\\'(?:(?!"+re.src_ZCc+"|[']).)+\\'|"+"\\'(?="+re.src_pseudo_letter+'|[-]).|'+'\\.{2,3}[a-zA-Z0-9%/]|'+'\\.(?!'+re.src_ZCc+'|[.]).|'+
(opts&&opts['---']?'\\-(?!--(?:[^-]|$))(?:-*)|':'\\-+|')+'\\,(?!'+re.src_ZCc+').|'+'\\!(?!'+re.src_ZCc+'|[!]).|'+'\\?(?!'+re.src_ZCc+'|[?]).'+')+'+'|\\/'+')?';re.src_email_name='[\\-;:&=\\+\\$,\\"\\.a-zA-Z0-9_]+';re.src_xn='xn--[a-z0-9\\-]{1,59}';re.src_domain_root='(?:'+
re.src_xn+'|'+
re.src_pseudo_letter+'{1,63}'+')';re.src_domain='(?:'+
re.src_xn+'|'+'(?:'+re.src_pseudo_letter+')'+'|'+'(?:'+re.src_pseudo_letter+'(?:-(?!-)|'+re.src_pseudo_letter+'){0,61}'+re.src_pseudo_letter+')'+')';re.src_host='(?:'+'(?:(?:(?:'+re.src_domain+')\\.)*'+re.src_domain+')'+')';re.tpl_host_fuzzy='(?:'+
re.src_ip4+'|'+'(?:(?:(?:'+re.src_domain+')\\.)+(?:%TLDS%))'+')';re.tpl_host_no_ip_fuzzy='(?:(?:(?:'+re.src_domain+')\\.)+(?:%TLDS%))';re.src_host_strict=re.src_host+re.src_host_terminator;re.tpl_host_fuzzy_strict=re.tpl_host_fuzzy+re.src_host_terminator;re.src_host_port_strict=re.src_host+re.src_port+re.src_host_terminator;re.tpl_host_port_fuzzy_strict=re.tpl_host_fuzzy+re.src_port+re.src_host_terminator;re.tpl_host_port_no_ip_fuzzy_strict=re.tpl_host_no_ip_fuzzy+re.src_port+re.src_host_terminator;re.tpl_host_fuzzy_test='localhost|www\\.|\\.\\d{1,3}\\.|(?:\\.(?:%TLDS%)(?:'+re.src_ZPCc+'|>|$))';re.tpl_email_fuzzy='(^|'+text_separators+'|\\(|'+re.src_ZCc+')('+re.src_email_name+'@'+re.tpl_host_fuzzy_strict+')';re.tpl_link_fuzzy='(^|(?![.:/\\-_@])(?:[$+<=>^`|\uff5c]|'+re.src_ZPCc+'))'+'((?![$+<=>^`|\uff5c])'+re.tpl_host_port_fuzzy_strict+re.src_path+')';re.tpl_link_no_ip_fuzzy='(^|(?![.:/\\-_@])(?:[$+<=>^`|\uff5c]|'+re.src_ZPCc+'))'+'((?![$+<=>^`|\uff5c])'+re.tpl_host_port_no_ip_fuzzy_strict+re.src_path+')';return re;};},{"uc.micro/categories/Cc/regex":61,"uc.micro/categories/P/regex":63,"uc.micro/categories/Z/regex":64,"uc.micro/properties/Any/regex":66}],55:[function(require,module,exports){'use strict';var decodeCache={};function getDecodeCache(exclude){var i,ch,cache=decodeCache[exclude];if(cache){return cache;}
cache=decodeCache[exclude]=[];for(i=0;i<128;i++){ch=String.fromCharCode(i);cache.push(ch);}
for(i=0;i<exclude.length;i++){ch=exclude.charCodeAt(i);cache[ch]='%'+('0'+ch.toString(16).toUpperCase()).slice(-2);}
return cache;}
function decode(string,exclude){var cache;if(typeof exclude!=='string'){exclude=decode.defaultChars;}
cache=getDecodeCache(exclude);return string.replace(/(%[a-f0-9]{2})+/gi,function(seq){var i,l,b1,b2,b3,b4,chr,result='';for(i=0,l=seq.length;i<l;i+=3){b1=parseInt(seq.slice(i+1,i+3),16);if(b1<0x80){result+=cache[b1];continue;}
if((b1&0xE0)===0xC0&&(i+3<l)){b2=parseInt(seq.slice(i+4,i+6),16);if((b2&0xC0)===0x80){chr=((b1<<6)&0x7C0)|(b2&0x3F);if(chr<0x80){result+='\ufffd\ufffd';}else{result+=String.fromCharCode(chr);}
i+=3;continue;}}
if((b1&0xF0)===0xE0&&(i+6<l)){b2=parseInt(seq.slice(i+4,i+6),16);b3=parseInt(seq.slice(i+7,i+9),16);if((b2&0xC0)===0x80&&(b3&0xC0)===0x80){chr=((b1<<12)&0xF000)|((b2<<6)&0xFC0)|(b3&0x3F);if(chr<0x800||(chr>=0xD800&&chr<=0xDFFF)){result+='\ufffd\ufffd\ufffd';}else{result+=String.fromCharCode(chr);}
i+=6;continue;}}
if((b1&0xF8)===0xF0&&(i+9<l)){b2=parseInt(seq.slice(i+4,i+6),16);b3=parseInt(seq.slice(i+7,i+9),16);b4=parseInt(seq.slice(i+10,i+12),16);if((b2&0xC0)===0x80&&(b3&0xC0)===0x80&&(b4&0xC0)===0x80){chr=((b1<<18)&0x1C0000)|((b2<<12)&0x3F000)|((b3<<6)&0xFC0)|(b4&0x3F);if(chr<0x10000||chr>0x10FFFF){result+='\ufffd\ufffd\ufffd\ufffd';}else{chr-=0x10000;result+=String.fromCharCode(0xD800+(chr>>10),0xDC00+(chr&0x3FF));}
i+=9;continue;}}
result+='\ufffd';}
return result;});}
decode.defaultChars=';/?:@&=+$,#';decode.componentChars='';module.exports=decode;},{}],56:[function(require,module,exports){'use strict';var encodeCache={};function getEncodeCache(exclude){var i,ch,cache=encodeCache[exclude];if(cache){return cache;}
cache=encodeCache[exclude]=[];for(i=0;i<128;i++){ch=String.fromCharCode(i);if(/^[0-9a-z]$/i.test(ch)){cache.push(ch);}else{cache.push('%'+('0'+i.toString(16).toUpperCase()).slice(-2));}}
for(i=0;i<exclude.length;i++){cache[exclude.charCodeAt(i)]=exclude[i];}
return cache;}
function encode(string,exclude,keepEscaped){var i,l,code,nextCode,cache,result='';if(typeof exclude!=='string'){keepEscaped=exclude;exclude=encode.defaultChars;}
if(typeof keepEscaped==='undefined'){keepEscaped=true;}
cache=getEncodeCache(exclude);for(i=0,l=string.length;i<l;i++){code=string.charCodeAt(i);if(keepEscaped&&code===0x25&&i+2<l){if(/^[0-9a-f]{2}$/i.test(string.slice(i+1,i+3))){result+=string.slice(i,i+3);i+=2;continue;}}
if(code<128){result+=cache[code];continue;}
if(code>=0xD800&&code<=0xDFFF){if(code>=0xD800&&code<=0xDBFF&&i+1<l){nextCode=string.charCodeAt(i+1);if(nextCode>=0xDC00&&nextCode<=0xDFFF){result+=encodeURIComponent(string[i]+string[i+1]);i++;continue;}}
result+='%EF%BF%BD';continue;}
result+=encodeURIComponent(string[i]);}
return result;}
encode.defaultChars=";/?:@&=+$,-_.!~*'()#";encode.componentChars="-_.!~*'()";module.exports=encode;},{}],57:[function(require,module,exports){'use strict';module.exports=function format(url){var result='';result+=url.protocol||'';result+=url.slashes?'//':'';result+=url.auth?url.auth+'@':'';if(url.hostname&&url.hostname.indexOf(':')!==-1){result+='['+url.hostname+']';}else{result+=url.hostname||'';}
result+=url.port?':'+url.port:'';result+=url.pathname||'';result+=url.search||'';result+=url.hash||'';return result;};},{}],58:[function(require,module,exports){'use strict';module.exports.encode=require('./encode');module.exports.decode=require('./decode');module.exports.format=require('./format');module.exports.parse=require('./parse');},{"./decode":55,"./encode":56,"./format":57,"./parse":59}],59:[function(require,module,exports){'use strict';function Url(){this.protocol=null;this.slashes=null;this.auth=null;this.port=null;this.hostname=null;this.hash=null;this.search=null;this.pathname=null;}
var protocolPattern=/^([a-z0-9.+-]+:)/i,portPattern=/:[0-9]*$/,simplePathPattern=/^(\/\/?(?!\/)[^\?\s]*)(\?[^\s]*)?$/,delims=['<','>','"','`',' ','\r','\n','\t'],unwise=['{','}','|','\\','^','`'].concat(delims),autoEscape=['\''].concat(unwise),nonHostChars=['%','/','?',';','#'].concat(autoEscape),hostEndingChars=['/','?','#'],hostnameMaxLen=255,hostnamePartPattern=/^[+a-z0-9A-Z_-]{0,63}$/,hostnamePartStart=/^([+a-z0-9A-Z_-]{0,63})(.*)$/,hostlessProtocol={'javascript':true,'javascript:':true},slashedProtocol={'http':true,'https':true,'ftp':true,'gopher':true,'file':true,'http:':true,'https:':true,'ftp:':true,'gopher:':true,'file:':true};function urlParse(url,slashesDenoteHost){if(url&&url instanceof Url){return url;}
var u=new Url();u.parse(url,slashesDenoteHost);return u;}
Url.prototype.parse=function(url,slashesDenoteHost){var i,l,lowerProto,hec,slashes,rest=url;rest=rest.trim();if(!slashesDenoteHost&&url.split('#').length===1){var simplePath=simplePathPattern.exec(rest);if(simplePath){this.pathname=simplePath[1];if(simplePath[2]){this.search=simplePath[2];}
return this;}}
var proto=protocolPattern.exec(rest);if(proto){proto=proto[0];lowerProto=proto.toLowerCase();this.protocol=proto;rest=rest.substr(proto.length);}
if(slashesDenoteHost||proto||rest.match(/^\/\/[^@\/]+@[^@\/]+/)){slashes=rest.substr(0,2)==='//';if(slashes&&!(proto&&hostlessProtocol[proto])){rest=rest.substr(2);this.slashes=true;}}
if(!hostlessProtocol[proto]&&(slashes||(proto&&!slashedProtocol[proto]))){var hostEnd=-1;for(i=0;i<hostEndingChars.length;i++){hec=rest.indexOf(hostEndingChars[i]);if(hec!==-1&&(hostEnd===-1||hec<hostEnd)){hostEnd=hec;}}
var auth,atSign;if(hostEnd===-1){atSign=rest.lastIndexOf('@');}else{atSign=rest.lastIndexOf('@',hostEnd);}
if(atSign!==-1){auth=rest.slice(0,atSign);rest=rest.slice(atSign+1);this.auth=auth;}
hostEnd=-1;for(i=0;i<nonHostChars.length;i++){hec=rest.indexOf(nonHostChars[i]);if(hec!==-1&&(hostEnd===-1||hec<hostEnd)){hostEnd=hec;}}
if(hostEnd===-1){hostEnd=rest.length;}
if(rest[hostEnd-1]===':'){hostEnd--;}
var host=rest.slice(0,hostEnd);rest=rest.slice(hostEnd);this.parseHost(host);this.hostname=this.hostname||'';var ipv6Hostname=this.hostname[0]==='['&&this.hostname[this.hostname.length-1]===']';if(!ipv6Hostname){var hostparts=this.hostname.split(/\./);for(i=0,l=hostparts.length;i<l;i++){var part=hostparts[i];if(!part){continue;}
if(!part.match(hostnamePartPattern)){var newpart='';for(var j=0,k=part.length;j<k;j++){if(part.charCodeAt(j)>127){newpart+='x';}else{newpart+=part[j];}}
if(!newpart.match(hostnamePartPattern)){var validParts=hostparts.slice(0,i);var notHost=hostparts.slice(i+1);var bit=part.match(hostnamePartStart);if(bit){validParts.push(bit[1]);notHost.unshift(bit[2]);}
if(notHost.length){rest=notHost.join('.')+rest;}
this.hostname=validParts.join('.');break;}}}}
if(this.hostname.length>hostnameMaxLen){this.hostname='';}
if(ipv6Hostname){this.hostname=this.hostname.substr(1,this.hostname.length-2);}}
var hash=rest.indexOf('#');if(hash!==-1){this.hash=rest.substr(hash);rest=rest.slice(0,hash);}
var qm=rest.indexOf('?');if(qm!==-1){this.search=rest.substr(qm);rest=rest.slice(0,qm);}
if(rest){this.pathname=rest;}
if(slashedProtocol[lowerProto]&&this.hostname&&!this.pathname){this.pathname='';}
return this;};Url.prototype.parseHost=function(host){var port=portPattern.exec(host);if(port){port=port[0];if(port!==':'){this.port=port.substr(1);}
host=host.substr(0,host.length-port.length);}
if(host){this.hostname=host;}};module.exports=urlParse;},{}],60:[function(require,module,exports){(function(global){;(function(root){var freeExports=typeof exports=='object'&&exports&&!exports.nodeType&&exports;var freeModule=typeof module=='object'&&module&&!module.nodeType&&module;var freeGlobal=typeof global=='object'&&global;if(freeGlobal.global===freeGlobal||freeGlobal.window===freeGlobal||freeGlobal.self===freeGlobal){root=freeGlobal;}
var punycode,maxInt=2147483647,base=36,tMin=1,tMax=26,skew=38,damp=700,initialBias=72,initialN=128,delimiter='-',regexPunycode=/^xn--/,regexNonASCII=/[^\x20-\x7E]/,regexSeparators=/[\x2E\u3002\uFF0E\uFF61]/g,errors={'overflow':'Overflow: input needs wider integers to process','not-basic':'Illegal input >= 0x80 (not a basic code point)','invalid-input':'Invalid input'},baseMinusTMin=base-tMin,floor=Math.floor,stringFromCharCode=String.fromCharCode,key;function error(type){throw new RangeError(errors[type]);}
function map(array,fn){var length=array.length;var result=[];while(length--){result[length]=fn(array[length]);}
return result;}
function mapDomain(string,fn){var parts=string.split('@');var result='';if(parts.length>1){result=parts[0]+'@';string=parts[1];}
string=string.replace(regexSeparators,'\x2E');var labels=string.split('.');var encoded=map(labels,fn).join('.');return result+encoded;}
function ucs2decode(string){var output=[],counter=0,length=string.length,value,extra;while(counter<length){value=string.charCodeAt(counter++);if(value>=0xD800&&value<=0xDBFF&&counter<length){extra=string.charCodeAt(counter++);if((extra&0xFC00)==0xDC00){output.push(((value&0x3FF)<<10)+(extra&0x3FF)+0x10000);}else{output.push(value);counter--;}}else{output.push(value);}}
return output;}
function ucs2encode(array){return map(array,function(value){var output='';if(value>0xFFFF){value-=0x10000;output+=stringFromCharCode(value>>>10&0x3FF|0xD800);value=0xDC00|value&0x3FF;}
output+=stringFromCharCode(value);return output;}).join('');}
function basicToDigit(codePoint){if(codePoint-48<10){return codePoint-22;}
if(codePoint-65<26){return codePoint-65;}
if(codePoint-97<26){return codePoint-97;}
return base;}
function digitToBasic(digit,flag){return digit+22+75*(digit<26)-((flag!=0)<<5);}
function adapt(delta,numPoints,firstTime){var k=0;delta=firstTime?floor(delta/damp):delta>>1;delta+=floor(delta/numPoints);for(;delta>baseMinusTMin*tMax>>1;k+=base){delta=floor(delta/baseMinusTMin);}
return floor(k+(baseMinusTMin+1)*delta/(delta+skew));}
function decode(input){var output=[],inputLength=input.length,out,i=0,n=initialN,bias=initialBias,basic,j,index,oldi,w,k,digit,t,baseMinusT;basic=input.lastIndexOf(delimiter);if(basic<0){basic=0;}
for(j=0;j<basic;++j){if(input.charCodeAt(j)>=0x80){error('not-basic');}
output.push(input.charCodeAt(j));}
for(index=basic>0?basic+1:0;index<inputLength;){for(oldi=i,w=1,k=base;;k+=base){if(index>=inputLength){error('invalid-input');}
digit=basicToDigit(input.charCodeAt(index++));if(digit>=base||digit>floor((maxInt-i)/w)){error('overflow');}
i+=digit*w;t=k<=bias?tMin:(k>=bias+tMax?tMax:k-bias);if(digit<t){break;}
baseMinusT=base-t;if(w>floor(maxInt/baseMinusT)){error('overflow');}
w*=baseMinusT;}
out=output.length+1;bias=adapt(i-oldi,out,oldi==0);if(floor(i/out)>maxInt-n){error('overflow');}
n+=floor(i/out);i%=out;output.splice(i++,0,n);}
return ucs2encode(output);}
function encode(input){var n,delta,handledCPCount,basicLength,bias,j,m,q,k,t,currentValue,output=[],inputLength,handledCPCountPlusOne,baseMinusT,qMinusT;input=ucs2decode(input);inputLength=input.length;n=initialN;delta=0;bias=initialBias;for(j=0;j<inputLength;++j){currentValue=input[j];if(currentValue<0x80){output.push(stringFromCharCode(currentValue));}}
handledCPCount=basicLength=output.length;if(basicLength){output.push(delimiter);}
while(handledCPCount<inputLength){for(m=maxInt,j=0;j<inputLength;++j){currentValue=input[j];if(currentValue>=n&&currentValue<m){m=currentValue;}}
handledCPCountPlusOne=handledCPCount+1;if(m-n>floor((maxInt-delta)/handledCPCountPlusOne)){error('overflow');}
delta+=(m-n)*handledCPCountPlusOne;n=m;for(j=0;j<inputLength;++j){currentValue=input[j];if(currentValue<n&&++delta>maxInt){error('overflow');}
if(currentValue==n){for(q=delta,k=base;;k+=base){t=k<=bias?tMin:(k>=bias+tMax?tMax:k-bias);if(q<t){break;}
qMinusT=q-t;baseMinusT=base-t;output.push(stringFromCharCode(digitToBasic(t+qMinusT%baseMinusT,0)));q=floor(qMinusT/baseMinusT);}
output.push(stringFromCharCode(digitToBasic(q,0)));bias=adapt(delta,handledCPCountPlusOne,handledCPCount==basicLength);delta=0;++handledCPCount;}}
++delta;++n;}
return output.join('');}
function toUnicode(input){return mapDomain(input,function(string){return regexPunycode.test(string)?decode(string.slice(4).toLowerCase()):string;});}
function toASCII(input){return mapDomain(input,function(string){return regexNonASCII.test(string)?'xn--'+encode(string):string;});}
punycode={'version':'1.4.1','ucs2':{'decode':ucs2decode,'encode':ucs2encode},'decode':decode,'encode':encode,'toASCII':toASCII,'toUnicode':toUnicode};if(typeof define=='function'&&typeof define.amd=='object'&&define.amd){define('punycode',function(){return punycode;});}else if(freeExports&&freeModule){if(module.exports==freeExports){freeModule.exports=punycode;}else{for(key in punycode){punycode.hasOwnProperty(key)&&(freeExports[key]=punycode[key]);}}}else{root.punycode=punycode;}}(this));}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{}],61:[function(require,module,exports){module.exports=/[\0-\x1F\x7F-\x9F]/},{}],62:[function(require,module,exports){module.exports=/[\xAD\u0600-\u0605\u061C\u06DD\u070F\u08E2\u180E\u200B-\u200F\u202A-\u202E\u2060-\u2064\u2066-\u206F\uFEFF\uFFF9-\uFFFB]|\uD804\uDCBD|\uD82F[\uDCA0-\uDCA3]|\uD834[\uDD73-\uDD7A]|\uDB40[\uDC01\uDC20-\uDC7F]/},{}],63:[function(require,module,exports){module.exports=/[!-#%-\*,-/:;\?@\[-\]_\{\}\xA1\xA7\xAB\xB6\xB7\xBB\xBF\u037E\u0387\u055A-\u055F\u0589\u058A\u05BE\u05C0\u05C3\u05C6\u05F3\u05F4\u0609\u060A\u060C\u060D\u061B\u061E\u061F\u066A-\u066D\u06D4\u0700-\u070D\u07F7-\u07F9\u0830-\u083E\u085E\u0964\u0965\u0970\u09FD\u0AF0\u0DF4\u0E4F\u0E5A\u0E5B\u0F04-\u0F12\u0F14\u0F3A-\u0F3D\u0F85\u0FD0-\u0FD4\u0FD9\u0FDA\u104A-\u104F\u10FB\u1360-\u1368\u1400\u166D\u166E\u169B\u169C\u16EB-\u16ED\u1735\u1736\u17D4-\u17D6\u17D8-\u17DA\u1800-\u180A\u1944\u1945\u1A1E\u1A1F\u1AA0-\u1AA6\u1AA8-\u1AAD\u1B5A-\u1B60\u1BFC-\u1BFF\u1C3B-\u1C3F\u1C7E\u1C7F\u1CC0-\u1CC7\u1CD3\u2010-\u2027\u2030-\u2043\u2045-\u2051\u2053-\u205E\u207D\u207E\u208D\u208E\u2308-\u230B\u2329\u232A\u2768-\u2775\u27C5\u27C6\u27E6-\u27EF\u2983-\u2998\u29D8-\u29DB\u29FC\u29FD\u2CF9-\u2CFC\u2CFE\u2CFF\u2D70\u2E00-\u2E2E\u2E30-\u2E49\u3001-\u3003\u3008-\u3011\u3014-\u301F\u3030\u303D\u30A0\u30FB\uA4FE\uA4FF\uA60D-\uA60F\uA673\uA67E\uA6F2-\uA6F7\uA874-\uA877\uA8CE\uA8CF\uA8F8-\uA8FA\uA8FC\uA92E\uA92F\uA95F\uA9C1-\uA9CD\uA9DE\uA9DF\uAA5C-\uAA5F\uAADE\uAADF\uAAF0\uAAF1\uABEB\uFD3E\uFD3F\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE61\uFE63\uFE68\uFE6A\uFE6B\uFF01-\uFF03\uFF05-\uFF0A\uFF0C-\uFF0F\uFF1A\uFF1B\uFF1F\uFF20\uFF3B-\uFF3D\uFF3F\uFF5B\uFF5D\uFF5F-\uFF65]|\uD800[\uDD00-\uDD02\uDF9F\uDFD0]|\uD801\uDD6F|\uD802[\uDC57\uDD1F\uDD3F\uDE50-\uDE58\uDE7F\uDEF0-\uDEF6\uDF39-\uDF3F\uDF99-\uDF9C]|\uD804[\uDC47-\uDC4D\uDCBB\uDCBC\uDCBE-\uDCC1\uDD40-\uDD43\uDD74\uDD75\uDDC5-\uDDC9\uDDCD\uDDDB\uDDDD-\uDDDF\uDE38-\uDE3D\uDEA9]|\uD805[\uDC4B-\uDC4F\uDC5B\uDC5D\uDCC6\uDDC1-\uDDD7\uDE41-\uDE43\uDE60-\uDE6C\uDF3C-\uDF3E]|\uD806[\uDE3F-\uDE46\uDE9A-\uDE9C\uDE9E-\uDEA2]|\uD807[\uDC41-\uDC45\uDC70\uDC71]|\uD809[\uDC70-\uDC74]|\uD81A[\uDE6E\uDE6F\uDEF5\uDF37-\uDF3B\uDF44]|\uD82F\uDC9F|\uD836[\uDE87-\uDE8B]|\uD83A[\uDD5E\uDD5F]/},{}],64:[function(require,module,exports){module.exports=/[ \xA0\u1680\u2000-\u200A\u202F\u205F\u3000]/},{}],65:[function(require,module,exports){'use strict';exports.Any=require('./properties/Any/regex');exports.Cc=require('./categories/Cc/regex');exports.Cf=require('./categories/Cf/regex');exports.P=require('./categories/P/regex');exports.Z=require('./categories/Z/regex');},{"./categories/Cc/regex":61,"./categories/Cf/regex":62,"./categories/P/regex":63,"./categories/Z/regex":64,"./properties/Any/regex":66}],66:[function(require,module,exports){module.exports=/[\0-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/},{}],67:[function(require,module,exports){'use strict';module.exports=require('./lib/');},{"./lib/":9}]},{},[67])(67)});!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e(t.pell={})}(this,function(t){"use strict";var e=Object.assign||function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(t[r]=n[r])}return t},n=function(t,e,n){return t.addEventListener(e,n)},r=function(t,e){return t.appendChild(e)},i=function(t){return document.createElement(t)},o=function(t){return document.queryCommandState(t)},u=function(t){return document.queryCommandValue(t)},c=function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;return document.execCommand(t,!1,e)},l={bold:{icon:"<b>B</b>",title:"Bold",state:function(){return o("bold")},result:function(){return c("bold")}},italic:{icon:"<i>I</i>",title:"Italic",state:function(){return o("italic")},result:function(){return c("italic")}},underline:{icon:"<u>U</u>",title:"Underline",state:function(){return o("underline")},result:function(){return c("underline")}},strikethrough:{icon:"<strike>S</strike>",title:"Strike-through",state:function(){return o("strikeThrough")},result:function(){return c("strikeThrough")}},heading1:{icon:"<b>H<sub>1</sub></b>",title:"Heading 1",result:function(){return c("formatBlock","<h1>")}},heading2:{icon:"<b>H<sub>2</sub></b>",title:"Heading 2",result:function(){return c("formatBlock","<h2>")}},paragraph:{icon:"&#182;",title:"Paragraph",result:function(){return c("formatBlock","<p>")}},quote:{icon:"&#8220; &#8221;",title:"Quote",result:function(){return c("formatBlock","<blockquote>")}},olist:{icon:"&#35;",title:"Ordered List",result:function(){return c("insertOrderedList")}},ulist:{icon:"&#8226;",title:"Unordered List",result:function(){return c("insertUnorderedList")}},code:{icon:"&lt;/&gt;",title:"Code",result:function(){return c("formatBlock","<pre>")}},line:{icon:"&#8213;",title:"Horizontal Line",result:function(){return c("insertHorizontalRule")}},link:{icon:"&#128279;",title:"Link",result:function(){var t=window.prompt("Enter the link URL");t&&c("createLink",t)}},image:{icon:"&#128247;",title:"Image",result:function(){var t=window.prompt("Enter the image URL");t&&c("insertImage",t)}}},a={actionbar:"pell-actionbar",button:"pell-button",content:"pell-content",selected:"pell-button-selected"},s=function(t){var o=t.actions?t.actions.map(function(t){return"string"==typeof t?l[t]:l[t.name]?e({},l[t.name],t):t}):Object.keys(l).map(function(t){return l[t]}),s=e({},a,t.classes),f=t.defaultParagraphSeparator||"div",d=i("div");d.className=s.actionbar,r(t.element,d);var m=t.element.content=i("div");return m.contentEditable=!0,m.className=s.content,m.oninput=function(e){var n=e.target.firstChild;n&&3===n.nodeType?c("formatBlock","<"+f+">"):"<br>"===m.innerHTML&&(m.innerHTML=""),t.onChange(m.innerHTML)},m.onkeydown=function(t){"Tab"===t.key?t.preventDefault():"Enter"===t.key&&"blockquote"===u("formatBlock")&&setTimeout(function(){return c("formatBlock","<"+f+">")},0)},r(t.element,m),o.forEach(function(t){var e=i("button");if(e.className=s.button,e.innerHTML=t.icon,e.title=t.title,e.setAttribute("type","button"),e.onclick=function(){return t.result()&&m.focus()},t.state){var o=function(){return e.classList[t.state()?"add":"remove"](s.selected)};n(m,"keyup",o),n(m,"mouseup",o),n(e,"click",o)}r(d,e)}),t.styleWithCSS&&c("styleWithCSS"),c("defaultParagraphSeparator",f),t.element},f={exec:c,init:s};t.exec=c,t.init=s,t.default=f,Object.defineProperty(t,"__esModule",{value:!0})});var _self="undefined"!=typeof window?window:"undefined"!=typeof WorkerGlobalScope&&self instanceof WorkerGlobalScope?self:{},Prism=function(u){var c=/\blang(?:uage)?-([\w-]+)\b/i,n=0,M={manual:u.Prism&&u.Prism.manual,disableWorkerMessageHandler:u.Prism&&u.Prism.disableWorkerMessageHandler,util:{encode:function e(n){return n instanceof W?new W(n.type,e(n.content),n.alias):Array.isArray(n)?n.map(e):n.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/\u00a0/g," ")},type:function(e){return Object.prototype.toString.call(e).slice(8,-1)},objId:function(e){return e.__id||Object.defineProperty(e,"__id",{value:++n}),e.__id},clone:function r(e,t){var a,n;switch(t=t||{},M.util.type(e)){case"Object":if(n=M.util.objId(e),t[n])return t[n];for(var i in a={},t[n]=a,e)e.hasOwnProperty(i)&&(a[i]=r(e[i],t));return a;case"Array":return n=M.util.objId(e),t[n]?t[n]:(a=[],t[n]=a,e.forEach(function(e,n){a[n]=r(e,t)}),a);default:return e}},getLanguage:function(e){for(;e&&!c.test(e.className);)e=e.parentElement;return e?(e.className.match(c)||[,"none"])[1].toLowerCase():"none"},currentScript:function(){if("undefined"==typeof document)return null;if("currentScript"in document)return document.currentScript;try{throw new Error}catch(e){var n=(/at [^(\r\n]*\((.*):.+:.+\)$/i.exec(e.stack)||[])[1];if(n){var r=document.getElementsByTagName("script");for(var t in r)if(r[t].src==n)return r[t]}return null}},isActive:function(e,n,r){for(var t="no-"+n;e;){var a=e.classList;if(a.contains(n))return!0;if(a.contains(t))return!1;e=e.parentElement}return!!r}},languages:{extend:function(e,n){var r=M.util.clone(M.languages[e]);for(var t in n)r[t]=n[t];return r},insertBefore:function(r,e,n,t){var a=(t=t||M.languages)[r],i={};for(var l in a)if(a.hasOwnProperty(l)){if(l==e)for(var o in n)n.hasOwnProperty(o)&&(i[o]=n[o]);n.hasOwnProperty(l)||(i[l]=a[l])}var s=t[r];return t[r]=i,M.languages.DFS(M.languages,function(e,n){n===s&&e!=r&&(this[e]=i)}),i},DFS:function e(n,r,t,a){a=a||{};var i=M.util.objId;for(var l in n)if(n.hasOwnProperty(l)){r.call(n,l,n[l],t||l);var o=n[l],s=M.util.type(o);"Object"!==s||a[i(o)]?"Array"!==s||a[i(o)]||(a[i(o)]=!0,e(o,r,l,a)):(a[i(o)]=!0,e(o,r,null,a))}}},plugins:{},highlightAll:function(e,n){M.highlightAllUnder(document,e,n)},highlightAllUnder:function(e,n,r){var t={callback:r,container:e,selector:'code[class*="language-"], [class*="language-"] code, code[class*="lang-"], [class*="lang-"] code'};M.hooks.run("before-highlightall",t),t.elements=Array.prototype.slice.apply(t.container.querySelectorAll(t.selector)),M.hooks.run("before-all-elements-highlight",t);for(var a,i=0;a=t.elements[i++];)M.highlightElement(a,!0===n,t.callback)},highlightElement:function(e,n,r){var t=M.util.getLanguage(e),a=M.languages[t];e.className=e.className.replace(c,"").replace(/\s+/g," ")+" language-"+t;var i=e.parentElement;i&&"pre"===i.nodeName.toLowerCase()&&(i.className=i.className.replace(c,"").replace(/\s+/g," ")+" language-"+t);var l={element:e,language:t,grammar:a,code:e.textContent};function o(e){l.highlightedCode=e,M.hooks.run("before-insert",l),l.element.innerHTML=l.highlightedCode,M.hooks.run("after-highlight",l),M.hooks.run("complete",l),r&&r.call(l.element)}if(M.hooks.run("before-sanity-check",l),!l.code)return M.hooks.run("complete",l),void(r&&r.call(l.element));if(M.hooks.run("before-highlight",l),l.grammar)if(n&&u.Worker){var s=new Worker(M.filename);s.onmessage=function(e){o(e.data)},s.postMessage(JSON.stringify({language:l.language,code:l.code,immediateClose:!0}))}else o(M.highlight(l.code,l.grammar,l.language));else o(M.util.encode(l.code))},highlight:function(e,n,r){var t={code:e,grammar:n,language:r};return M.hooks.run("before-tokenize",t),t.tokens=M.tokenize(t.code,t.grammar),M.hooks.run("after-tokenize",t),W.stringify(M.util.encode(t.tokens),t.language)},tokenize:function(e,n){var r=n.rest;if(r){for(var t in r)n[t]=r[t];delete n.rest}var a=new i;return I(a,a.head,e),function e(n,r,t,a,i,l){for(var o in t)if(t.hasOwnProperty(o)&&t[o]){var s=t[o];s=Array.isArray(s)?s:[s];for(var u=0;u<s.length;++u){if(l&&l.cause==o+","+u)return;var c=s[u],g=c.inside,f=!!c.lookbehind,h=!!c.greedy,d=c.alias;if(h&&!c.pattern.global){var v=c.pattern.toString().match(/[imsuy]*$/)[0];c.pattern=RegExp(c.pattern.source,v+"g")}for(var p=c.pattern||c,m=a.next,y=i;m!==r.tail&&!(l&&y>=l.reach);y+=m.value.length,m=m.next){var k=m.value;if(r.length>n.length)return;if(!(k instanceof W)){var b,x=1;if(h){if(!(b=z(p,y,n,f)))break;var w=b.index,A=b.index+b[0].length,P=y;for(P+=m.value.length;P<=w;)m=m.next,P+=m.value.length;if(P-=m.value.length,y=P,m.value instanceof W)continue;for(var S=m;S!==r.tail&&(P<A||"string"==typeof S.value);S=S.next)x++,P+=S.value.length;x--,k=n.slice(y,P),b.index-=y}else if(!(b=z(p,0,k,f)))continue;var w=b.index,E=b[0],O=k.slice(0,w),L=k.slice(w+E.length),N=y+k.length;l&&N>l.reach&&(l.reach=N);var j=m.prev;O&&(j=I(r,j,O),y+=O.length),q(r,j,x);var C=new W(o,g?M.tokenize(E,g):E,d,E);if(m=I(r,j,C),L&&I(r,m,L),1<x){var _={cause:o+","+u,reach:N};e(n,r,t,m.prev,y,_),l&&_.reach>l.reach&&(l.reach=_.reach)}}}}}}(e,a,n,a.head,0),function(e){var n=[],r=e.head.next;for(;r!==e.tail;)n.push(r.value),r=r.next;return n}(a)},hooks:{all:{},add:function(e,n){var r=M.hooks.all;r[e]=r[e]||[],r[e].push(n)},run:function(e,n){var r=M.hooks.all[e];if(r&&r.length)for(var t,a=0;t=r[a++];)t(n)}},Token:W};function W(e,n,r,t){this.type=e,this.content=n,this.alias=r,this.length=0|(t||"").length}function z(e,n,r,t){e.lastIndex=n;var a=e.exec(r);if(a&&t&&a[1]){var i=a[1].length;a.index+=i,a[0]=a[0].slice(i)}return a}function i(){var e={value:null,prev:null,next:null},n={value:null,prev:e,next:null};e.next=n,this.head=e,this.tail=n,this.length=0}function I(e,n,r){var t=n.next,a={value:r,prev:n,next:t};return n.next=a,t.prev=a,e.length++,a}function q(e,n,r){for(var t=n.next,a=0;a<r&&t!==e.tail;a++)t=t.next;(n.next=t).prev=n,e.length-=a}if(u.Prism=M,W.stringify=function n(e,r){if("string"==typeof e)return e;if(Array.isArray(e)){var t="";return e.forEach(function(e){t+=n(e,r)}),t}var a={type:e.type,content:n(e.content,r),tag:"span",classes:["token",e.type],attributes:{},language:r},i=e.alias;i&&(Array.isArray(i)?Array.prototype.push.apply(a.classes,i):a.classes.push(i)),M.hooks.run("wrap",a);var l="";for(var o in a.attributes)l+=" "+o+'="'+(a.attributes[o]||"").replace(/"/g,"&quot;")+'"';return"<"+a.tag+' class="'+a.classes.join(" ")+'"'+l+">"+a.content+"</"+a.tag+">"},!u.document)return u.addEventListener&&(M.disableWorkerMessageHandler||u.addEventListener("message",function(e){var n=JSON.parse(e.data),r=n.language,t=n.code,a=n.immediateClose;u.postMessage(M.highlight(t,M.languages[r],r)),a&&u.close()},!1)),M;var e=M.util.currentScript();function r(){M.manual||M.highlightAll()}if(e&&(M.filename=e.src,e.hasAttribute("data-manual")&&(M.manual=!0)),!M.manual){var t=document.readyState;"loading"===t||"interactive"===t&&e&&e.defer?document.addEventListener("DOMContentLoaded",r):window.requestAnimationFrame?window.requestAnimationFrame(r):window.setTimeout(r,16)}return M}(_self);"undefined"!=typeof module&&module.exports&&(module.exports=Prism),"undefined"!=typeof global&&(global.Prism=Prism);Prism.languages.markup={comment:/<!--[\s\S]*?-->/,prolog:/<\?[\s\S]+?\?>/,doctype:{pattern:/<!DOCTYPE(?:[^>"'[\]]|"[^"]*"|'[^']*')+(?:\[(?:[^<"'\]]|"[^"]*"|'[^']*'|<(?!!--)|<!--(?:[^-]|-(?!->))*-->)*\]\s*)?>/i,greedy:!0,inside:{"internal-subset":{pattern:/(\[)[\s\S]+(?=\]>$)/,lookbehind:!0,greedy:!0,inside:null},string:{pattern:/"[^"]*"|'[^']*'/,greedy:!0},punctuation:/^<!|>$|[[\]]/,"doctype-tag":/^DOCTYPE/,name:/[^\s<>'"]+/}},cdata:/<!\[CDATA\[[\s\S]*?]]>/i,tag:{pattern:/<\/?(?!\d)[^\s>\/=$<%]+(?:\s(?:\s*[^\s>\/=]+(?:\s*=\s*(?:"[^"]*"|'[^']*'|[^\s'">=]+(?=[\s>]))|(?=[\s/>])))+)?\s*\/?>/,greedy:!0,inside:{tag:{pattern:/^<\/?[^\s>\/]+/,inside:{punctuation:/^<\/?/,namespace:/^[^\s>\/:]+:/}},"attr-value":{pattern:/=\s*(?:"[^"]*"|'[^']*'|[^\s'">=]+)/,inside:{punctuation:[{pattern:/^=/,alias:"attr-equals"},/"|'/]}},punctuation:/\/?>/,"attr-name":{pattern:/[^\s>\/]+/,inside:{namespace:/^[^\s>\/:]+:/}}}},entity:[{pattern:/&[\da-z]{1,8};/i,alias:"named-entity"},/&#x?[\da-f]{1,8};/i]},Prism.languages.markup.tag.inside["attr-value"].inside.entity=Prism.languages.markup.entity,Prism.languages.markup.doctype.inside["internal-subset"].inside=Prism.languages.markup,Prism.hooks.add("wrap",function(a){"entity"===a.type&&(a.attributes.title=a.content.replace(/&amp;/,"&"))}),Object.defineProperty(Prism.languages.markup.tag,"addInlined",{value:function(a,e){var s={};s["language-"+e]={pattern:/(^<!\[CDATA\[)[\s\S]+?(?=\]\]>$)/i,lookbehind:!0,inside:Prism.languages[e]},s.cdata=/^<!\[CDATA\[|\]\]>$/i;var n={"included-cdata":{pattern:/<!\[CDATA\[[\s\S]*?\]\]>/i,inside:s}};n["language-"+e]={pattern:/[\s\S]+/,inside:Prism.languages[e]};var t={};t[a]={pattern:RegExp("(<__[^>]*>)(?:<!\\[CDATA\\[(?:[^\\]]|\\](?!\\]>))*\\]\\]>|(?!<!\\[CDATA\\[)[^])*?(?=</__>)".replace(/__/g,function(){return a}),"i"),lookbehind:!0,greedy:!0,inside:n},Prism.languages.insertBefore("markup","cdata",t)}}),Prism.languages.html=Prism.languages.markup,Prism.languages.mathml=Prism.languages.markup,Prism.languages.svg=Prism.languages.markup,Prism.languages.xml=Prism.languages.extend("markup",{}),Prism.languages.ssml=Prism.languages.xml,Prism.languages.atom=Prism.languages.xml,Prism.languages.rss=Prism.languages.xml;!function(s){var e=/("|')(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/;s.languages.css={comment:/\/\*[\s\S]*?\*\//,atrule:{pattern:/@[\w-](?:[^;{\s]|\s+(?![\s{]))*(?:;|(?=\s*\{))/,inside:{rule:/^@[\w-]+/,"selector-function-argument":{pattern:/(\bselector\s*\(\s*(?![\s)]))(?:[^()\s]|\s+(?![\s)])|\((?:[^()]|\([^()]*\))*\))+(?=\s*\))/,lookbehind:!0,alias:"selector"},keyword:{pattern:/(^|[^\w-])(?:and|not|only|or)(?![\w-])/,lookbehind:!0}}},url:{pattern:RegExp("\\burl\\((?:"+e.source+"|(?:[^\\\\\r\n()\"']|\\\\[^])*)\\)","i"),greedy:!0,inside:{function:/^url/i,punctuation:/^\(|\)$/,string:{pattern:RegExp("^"+e.source+"$"),alias:"url"}}},selector:RegExp("[^{}\\s](?:[^{};\"'\\s]|\\s+(?![\\s{])|"+e.source+")*(?=\\s*\\{)"),string:{pattern:e,greedy:!0},property:/(?!\s)[-_a-z\xA0-\uFFFF](?:(?!\s)[-\w\xA0-\uFFFF])*(?=\s*:)/i,important:/!important\b/i,function:/[-a-z0-9]+(?=\()/i,punctuation:/[(){};:,]/},s.languages.css.atrule.inside.rest=s.languages.css;var t=s.languages.markup;t&&(t.tag.addInlined("style","css"),s.languages.insertBefore("inside","attr-value",{"style-attr":{pattern:/(^|["'\s])style\s*=\s*(?:"[^"]*"|'[^']*')/i,lookbehind:!0,inside:{"attr-value":{pattern:/=\s*(?:"[^"]*"|'[^']*'|[^\s'">=]+)/,inside:{style:{pattern:/(["'])[\s\S]+(?=["']$)/,lookbehind:!0,alias:"language-css",inside:s.languages.css},punctuation:[{pattern:/^=/,alias:"attr-equals"},/"|'/]}},"attr-name":/^style/i}}},t.tag))}(Prism);Prism.languages.clike={comment:[{pattern:/(^|[^\\])\/\*[\s\S]*?(?:\*\/|$)/,lookbehind:!0,greedy:!0},{pattern:/(^|[^\\:])\/\/.*/,lookbehind:!0,greedy:!0}],string:{pattern:/(["'])(?:\\(?:\r\n|[\s\S])|(?!\1)[^\\\r\n])*\1/,greedy:!0},"class-name":{pattern:/(\b(?:class|interface|extends|implements|trait|instanceof|new)\s+|\bcatch\s+\()[\w.\\]+/i,lookbehind:!0,inside:{punctuation:/[.\\]/}},keyword:/\b(?:if|else|while|do|for|return|in|instanceof|function|new|try|throw|catch|finally|null|break|continue)\b/,boolean:/\b(?:true|false)\b/,function:/\w+(?=\()/,number:/\b0x[\da-f]+\b|(?:\b\d+(?:\.\d*)?|\B\.\d+)(?:e[+-]?\d+)?/i,operator:/[<>]=?|[!=]=?=?|--?|\+\+?|&&?|\|\|?|[?*/~^%]/,punctuation:/[{}[\];(),.:]/};Prism.languages.javascript=Prism.languages.extend("clike",{"class-name":[Prism.languages.clike["class-name"],{pattern:/(^|[^$\w\xA0-\uFFFF])(?!\s)[_$A-Z\xA0-\uFFFF](?:(?!\s)[$\w\xA0-\uFFFF])*(?=\.(?:prototype|constructor))/,lookbehind:!0}],keyword:[{pattern:/((?:^|})\s*)catch\b/,lookbehind:!0},{pattern:/(^|[^.]|\.\.\.\s*)\b(?:as|async(?=\s*(?:function\b|\(|[$\w\xA0-\uFFFF]|$))|await|break|case|class|const|continue|debugger|default|delete|do|else|enum|export|extends|finally(?=\s*(?:\{|$))|for|from(?=\s*(?:['"]|$))|function|(?:get|set)(?=\s*(?:[\[$\w\xA0-\uFFFF]|$))|if|implements|import|in|instanceof|interface|let|new|null|of|package|private|protected|public|return|static|super|switch|this|throw|try|typeof|undefined|var|void|while|with|yield)\b/,lookbehind:!0}],function:/#?(?!\s)[_$a-zA-Z\xA0-\uFFFF](?:(?!\s)[$\w\xA0-\uFFFF])*(?=\s*(?:\.\s*(?:apply|bind|call)\s*)?\()/,number:/\b(?:(?:0[xX](?:[\dA-Fa-f](?:_[\dA-Fa-f])?)+|0[bB](?:[01](?:_[01])?)+|0[oO](?:[0-7](?:_[0-7])?)+)n?|(?:\d(?:_\d)?)+n|NaN|Infinity)\b|(?:\b(?:\d(?:_\d)?)+\.?(?:\d(?:_\d)?)*|\B\.(?:\d(?:_\d)?)+)(?:[Ee][+-]?(?:\d(?:_\d)?)+)?/,operator:/--|\+\+|\*\*=?|=>|&&=?|\|\|=?|[!=]==|<<=?|>>>?=?|[-+*/%&|^!=<>]=?|\.{3}|\?\?=?|\?\.?|[~:]/}),Prism.languages.javascript["class-name"][0].pattern=/(\b(?:class|interface|extends|implements|instanceof|new)\s+)[\w.\\]+/,Prism.languages.insertBefore("javascript","keyword",{regex:{pattern:/((?:^|[^$\w\xA0-\uFFFF."'\])\s]|\b(?:return|yield))\s*)\/(?:\[(?:[^\]\\\r\n]|\\.)*]|\\.|[^/\\\[\r\n])+\/[gimyus]{0,6}(?=(?:\s|\/\*(?:[^*]|\*(?!\/))*\*\/)*(?:$|[\r\n,.;:})\]]|\/\/))/,lookbehind:!0,greedy:!0,inside:{"regex-source":{pattern:/^(\/)[\s\S]+(?=\/[a-z]*$)/,lookbehind:!0,alias:"language-regex",inside:Prism.languages.regex},"regex-flags":/[a-z]+$/,"regex-delimiter":/^\/|\/$/}},"function-variable":{pattern:/#?(?!\s)[_$a-zA-Z\xA0-\uFFFF](?:(?!\s)[$\w\xA0-\uFFFF])*(?=\s*[=:]\s*(?:async\s*)?(?:\bfunction\b|(?:\((?:[^()]|\([^()]*\))*\)|(?!\s)[_$a-zA-Z\xA0-\uFFFF](?:(?!\s)[$\w\xA0-\uFFFF])*)\s*=>))/,alias:"function"},parameter:[{pattern:/(function(?:\s+(?!\s)[_$a-zA-Z\xA0-\uFFFF](?:(?!\s)[$\w\xA0-\uFFFF])*)?\s*\(\s*)(?!\s)(?:[^()\s]|\s+(?![\s)])|\([^()]*\))+(?=\s*\))/,lookbehind:!0,inside:Prism.languages.javascript},{pattern:/(?!\s)[_$a-zA-Z\xA0-\uFFFF](?:(?!\s)[$\w\xA0-\uFFFF])*(?=\s*=>)/i,inside:Prism.languages.javascript},{pattern:/(\(\s*)(?!\s)(?:[^()\s]|\s+(?![\s)])|\([^()]*\))+(?=\s*\)\s*=>)/,lookbehind:!0,inside:Prism.languages.javascript},{pattern:/((?:\b|\s|^)(?!(?:as|async|await|break|case|catch|class|const|continue|debugger|default|delete|do|else|enum|export|extends|finally|for|from|function|get|if|implements|import|in|instanceof|interface|let|new|null|of|package|private|protected|public|return|set|static|super|switch|this|throw|try|typeof|undefined|var|void|while|with|yield)(?![$\w\xA0-\uFFFF]))(?:(?!\s)[_$a-zA-Z\xA0-\uFFFF](?:(?!\s)[$\w\xA0-\uFFFF])*\s*)\(\s*|\]\s*\(\s*)(?!\s)(?:[^()\s]|\s+(?![\s)])|\([^()]*\))+(?=\s*\)\s*\{)/,lookbehind:!0,inside:Prism.languages.javascript}],constant:/\b[A-Z](?:[A-Z_]|\dx?)*\b/}),Prism.languages.insertBefore("javascript","string",{"template-string":{pattern:/`(?:\\[\s\S]|\${(?:[^{}]|{(?:[^{}]|{[^}]*})*})+}|(?!\${)[^\\`])*`/,greedy:!0,inside:{"template-punctuation":{pattern:/^`|`$/,alias:"string"},interpolation:{pattern:/((?:^|[^\\])(?:\\{2})*)\${(?:[^{}]|{(?:[^{}]|{[^}]*})*})+}/,lookbehind:!0,inside:{"interpolation-punctuation":{pattern:/^\${|}$/,alias:"punctuation"},rest:Prism.languages.javascript}},string:/[\s\S]+/}}}),Prism.languages.markup&&Prism.languages.markup.tag.addInlined("script","javascript"),Prism.languages.js=Prism.languages.javascript;!function(e){var t="\\b(?:BASH|BASHOPTS|BASH_ALIASES|BASH_ARGC|BASH_ARGV|BASH_CMDS|BASH_COMPLETION_COMPAT_DIR|BASH_LINENO|BASH_REMATCH|BASH_SOURCE|BASH_VERSINFO|BASH_VERSION|COLORTERM|COLUMNS|COMP_WORDBREAKS|DBUS_SESSION_BUS_ADDRESS|DEFAULTS_PATH|DESKTOP_SESSION|DIRSTACK|DISPLAY|EUID|GDMSESSION|GDM_LANG|GNOME_KEYRING_CONTROL|GNOME_KEYRING_PID|GPG_AGENT_INFO|GROUPS|HISTCONTROL|HISTFILE|HISTFILESIZE|HISTSIZE|HOME|HOSTNAME|HOSTTYPE|IFS|INSTANCE|JOB|LANG|LANGUAGE|LC_ADDRESS|LC_ALL|LC_IDENTIFICATION|LC_MEASUREMENT|LC_MONETARY|LC_NAME|LC_NUMERIC|LC_PAPER|LC_TELEPHONE|LC_TIME|LESSCLOSE|LESSOPEN|LINES|LOGNAME|LS_COLORS|MACHTYPE|MAILCHECK|MANDATORY_PATH|NO_AT_BRIDGE|OLDPWD|OPTERR|OPTIND|ORBIT_SOCKETDIR|OSTYPE|PAPERSIZE|PATH|PIPESTATUS|PPID|PS1|PS2|PS3|PS4|PWD|RANDOM|REPLY|SECONDS|SELINUX_INIT|SESSION|SESSIONTYPE|SESSION_MANAGER|SHELL|SHELLOPTS|SHLVL|SSH_AUTH_SOCK|TERM|UID|UPSTART_EVENTS|UPSTART_INSTANCE|UPSTART_JOB|UPSTART_SESSION|USER|WINDOWID|XAUTHORITY|XDG_CONFIG_DIRS|XDG_CURRENT_DESKTOP|XDG_DATA_DIRS|XDG_GREETER_DATA_DIR|XDG_MENU_PREFIX|XDG_RUNTIME_DIR|XDG_SEAT|XDG_SEAT_PATH|XDG_SESSION_DESKTOP|XDG_SESSION_ID|XDG_SESSION_PATH|XDG_SESSION_TYPE|XDG_VTNR|XMODIFIERS)\\b",n={pattern:/(^(["']?)\w+\2)[ \t]+\S.*/,lookbehind:!0,alias:"punctuation",inside:null},a={bash:n,environment:{pattern:RegExp("\\$"+t),alias:"constant"},variable:[{pattern:/\$?\(\([\s\S]+?\)\)/,greedy:!0,inside:{variable:[{pattern:/(^\$\(\([\s\S]+)\)\)/,lookbehind:!0},/^\$\(\(/],number:/\b0x[\dA-Fa-f]+\b|(?:\b\d+(?:\.\d*)?|\B\.\d+)(?:[Ee]-?\d+)?/,operator:/--?|-=|\+\+?|\+=|!=?|~|\*\*?|\*=|\/=?|%=?|<<=?|>>=?|<=?|>=?|==?|&&?|&=|\^=?|\|\|?|\|=|\?|:/,punctuation:/\(\(?|\)\)?|,|;/}},{pattern:/\$\((?:\([^)]+\)|[^()])+\)|`[^`]+`/,greedy:!0,inside:{variable:/^\$\(|^`|\)$|`$/}},{pattern:/\$\{[^}]+\}/,greedy:!0,inside:{operator:/:[-=?+]?|[!\/]|##?|%%?|\^\^?|,,?/,punctuation:/[\[\]]/,environment:{pattern:RegExp("(\\{)"+t),lookbehind:!0,alias:"constant"}}},/\$(?:\w+|[#?*!@$])/],entity:/\\(?:[abceEfnrtv\\"]|O?[0-7]{1,3}|x[0-9a-fA-F]{1,2}|u[0-9a-fA-F]{4}|U[0-9a-fA-F]{8})/};e.languages.bash={shebang:{pattern:/^#!\s*\/.*/,alias:"important"},comment:{pattern:/(^|[^"{\\$])#.*/,lookbehind:!0},"function-name":[{pattern:/(\bfunction\s+)\w+(?=(?:\s*\(?:\s*\))?\s*\{)/,lookbehind:!0,alias:"function"},{pattern:/\b\w+(?=\s*\(\s*\)\s*\{)/,alias:"function"}],"for-or-select":{pattern:/(\b(?:for|select)\s+)\w+(?=\s+in\s)/,alias:"variable",lookbehind:!0},"assign-left":{pattern:/(^|[\s;|&]|[<>]\()\w+(?=\+?=)/,inside:{environment:{pattern:RegExp("(^|[\\s;|&]|[<>]\\()"+t),lookbehind:!0,alias:"constant"}},alias:"variable",lookbehind:!0},string:[{pattern:/((?:^|[^<])<<-?\s*)(\w+?)\s[\s\S]*?(?:\r?\n|\r)\2/,lookbehind:!0,greedy:!0,inside:a},{pattern:/((?:^|[^<])<<-?\s*)(["'])(\w+)\2\s[\s\S]*?(?:\r?\n|\r)\3/,lookbehind:!0,greedy:!0,inside:{bash:n}},{pattern:/(^|[^\\](?:\\\\)*)(["'])(?:\\[\s\S]|\$\([^)]+\)|\$(?!\()|`[^`]+`|(?!\2)[^\\`$])*\2/,lookbehind:!0,greedy:!0,inside:a}],environment:{pattern:RegExp("\\$?"+t),alias:"constant"},variable:a.variable,function:{pattern:/(^|[\s;|&]|[<>]\()(?:add|apropos|apt|aptitude|apt-cache|apt-get|aspell|automysqlbackup|awk|basename|bash|bc|bconsole|bg|bzip2|cal|cat|cfdisk|chgrp|chkconfig|chmod|chown|chroot|cksum|clear|cmp|column|comm|composer|cp|cron|crontab|csplit|curl|cut|date|dc|dd|ddrescue|debootstrap|df|diff|diff3|dig|dir|dircolors|dirname|dirs|dmesg|du|egrep|eject|env|ethtool|expand|expect|expr|fdformat|fdisk|fg|fgrep|file|find|fmt|fold|format|free|fsck|ftp|fuser|gawk|git|gparted|grep|groupadd|groupdel|groupmod|groups|grub-mkconfig|gzip|halt|head|hg|history|host|hostname|htop|iconv|id|ifconfig|ifdown|ifup|import|install|ip|jobs|join|kill|killall|less|link|ln|locate|logname|logrotate|look|lpc|lpr|lprint|lprintd|lprintq|lprm|ls|lsof|lynx|make|man|mc|mdadm|mkconfig|mkdir|mke2fs|mkfifo|mkfs|mkisofs|mknod|mkswap|mmv|more|most|mount|mtools|mtr|mutt|mv|nano|nc|netstat|nice|nl|nohup|notify-send|npm|nslookup|op|open|parted|passwd|paste|pathchk|ping|pkill|pnpm|popd|pr|printcap|printenv|ps|pushd|pv|quota|quotacheck|quotactl|ram|rar|rcp|reboot|remsync|rename|renice|rev|rm|rmdir|rpm|rsync|scp|screen|sdiff|sed|sendmail|seq|service|sftp|sh|shellcheck|shuf|shutdown|sleep|slocate|sort|split|ssh|stat|strace|su|sudo|sum|suspend|swapon|sync|tac|tail|tar|tee|time|timeout|top|touch|tr|traceroute|tsort|tty|umount|uname|unexpand|uniq|units|unrar|unshar|unzip|update-grub|uptime|useradd|userdel|usermod|users|uudecode|uuencode|v|vdir|vi|vim|virsh|vmstat|wait|watch|wc|wget|whereis|which|who|whoami|write|xargs|xdg-open|yarn|yes|zenity|zip|zsh|zypper)(?=$|[)\s;|&])/,lookbehind:!0},keyword:{pattern:/(^|[\s;|&]|[<>]\()(?:if|then|else|elif|fi|for|while|in|case|esac|function|select|do|done|until)(?=$|[)\s;|&])/,lookbehind:!0},builtin:{pattern:/(^|[\s;|&]|[<>]\()(?:\.|:|break|cd|continue|eval|exec|exit|export|getopts|hash|pwd|readonly|return|shift|test|times|trap|umask|unset|alias|bind|builtin|caller|command|declare|echo|enable|help|let|local|logout|mapfile|printf|read|readarray|source|type|typeset|ulimit|unalias|set|shopt)(?=$|[)\s;|&])/,lookbehind:!0,alias:"class-name"},boolean:{pattern:/(^|[\s;|&]|[<>]\()(?:true|false)(?=$|[)\s;|&])/,lookbehind:!0},"file-descriptor":{pattern:/\B&\d\b/,alias:"important"},operator:{pattern:/\d?<>|>\||\+=|==?|!=?|=~|<<[<-]?|[&\d]?>>|\d?[<>]&?|&[>&]?|\|[&|]?|<=?|>=?/,inside:{"file-descriptor":{pattern:/^\d/,alias:"important"}}},punctuation:/\$?\(\(?|\)\)?|\.\.|[{}[\];\\]/,number:{pattern:/(^|\s)(?:[1-9]\d*|0)(?:[.,]\d+)?\b/,lookbehind:!0}},n.inside=e.languages.bash;for(var s=["comment","function-name","for-or-select","assign-left","string","environment","function","keyword","builtin","boolean","file-descriptor","operator","punctuation","number"],i=a.variable[1].inside,o=0;o<s.length;o++)i[s[o]]=e.languages.bash[s[o]];e.languages.shell=e.languages.bash}(Prism);!function(s){function a(e,s){return e.replace(/<<(\d+)>>/g,function(e,n){return"(?:"+s[+n]+")"})}function t(e,n,s){return RegExp(a(e,n),s||"")}function e(e,n){for(var s=0;s<n;s++)e=e.replace(/<<self>>/g,function(){return"(?:"+e+")"});return e.replace(/<<self>>/g,"[^\\s\\S]")}var n="bool byte char decimal double dynamic float int long object sbyte short string uint ulong ushort var void",i="class enum interface struct",r="add alias and ascending async await by descending from get global group into join let nameof not notnull on or orderby partial remove select set unmanaged value when where",o="abstract as base break case catch checked const continue default delegate do else event explicit extern finally fixed for foreach goto if implicit in internal is lock namespace new null operator out override params private protected public readonly ref return sealed sizeof stackalloc static switch this throw try typeof unchecked unsafe using virtual volatile while yield";function l(e){return"\\b(?:"+e.trim().replace(/ /g,"|")+")\\b"}var d=l(i),p=RegExp(l(n+" "+i+" "+r+" "+o)),c=l(i+" "+r+" "+o),u=l(n+" "+i+" "+o),g=e("<(?:[^<>;=+\\-*/%&|^]|<<self>>)*>",2),b=e("\\((?:[^()]|<<self>>)*\\)",2),h="@?\\b[A-Za-z_]\\w*\\b",f=a("<<0>>(?:\\s*<<1>>)?",[h,g]),m=a("(?!<<0>>)<<1>>(?:\\s*\\.\\s*<<1>>)*",[c,f]),k="\\[\\s*(?:,\\s*)*\\]",y=a("<<0>>(?:\\s*(?:\\?\\s*)?<<1>>)*(?:\\s*\\?)?",[m,k]),w=a("(?:<<0>>|<<1>>)(?:\\s*(?:\\?\\s*)?<<2>>)*(?:\\s*\\?)?",[a("\\(<<0>>+(?:,<<0>>+)+\\)",[a("[^,()<>[\\];=+\\-*/%&|^]|<<0>>|<<1>>|<<2>>",[g,b,k])]),m,k]),v={keyword:p,punctuation:/[<>()?,.:[\]]/},x="'(?:[^\r\n'\\\\]|\\\\.|\\\\[Uux][\\da-fA-F]{1,8})'",$='"(?:\\\\.|[^\\\\"\r\n])*"';s.languages.csharp=s.languages.extend("clike",{string:[{pattern:t("(^|[^$\\\\])<<0>>",['@"(?:""|\\\\[^]|[^\\\\"])*"(?!")']),lookbehind:!0,greedy:!0},{pattern:t("(^|[^@$\\\\])<<0>>",[$]),lookbehind:!0,greedy:!0},{pattern:RegExp(x),greedy:!0,alias:"character"}],"class-name":[{pattern:t("(\\busing\\s+static\\s+)<<0>>(?=\\s*;)",[m]),lookbehind:!0,inside:v},{pattern:t("(\\busing\\s+<<0>>\\s*=\\s*)<<1>>(?=\\s*;)",[h,w]),lookbehind:!0,inside:v},{pattern:t("(\\busing\\s+)<<0>>(?=\\s*=)",[h]),lookbehind:!0},{pattern:t("(\\b<<0>>\\s+)<<1>>",[d,f]),lookbehind:!0,inside:v},{pattern:t("(\\bcatch\\s*\\(\\s*)<<0>>",[m]),lookbehind:!0,inside:v},{pattern:t("(\\bwhere\\s+)<<0>>",[h]),lookbehind:!0},{pattern:t("(\\b(?:is(?:\\s+not)?|as)\\s+)<<0>>",[y]),lookbehind:!0,inside:v},{pattern:t("\\b<<0>>(?=\\s+(?!<<1>>)<<2>>(?:\\s*[=,;:{)\\]]|\\s+(?:in|when)\\b))",[w,u,h]),inside:v}],keyword:p,number:/(?:\b0(?:x[\da-f_]*[\da-f]|b[01_]*[01])|(?:\B\.\d+(?:_+\d+)*|\b\d+(?:_+\d+)*(?:\.\d+(?:_+\d+)*)?)(?:e[-+]?\d+(?:_+\d+)*)?)(?:ul|lu|[dflmu])?\b/i,operator:/>>=?|<<=?|[-=]>|([-+&|])\1|~|\?\?=?|[-+*/%&|^!=<>]=?/,punctuation:/\?\.?|::|[{}[\];(),.:]/}),s.languages.insertBefore("csharp","number",{range:{pattern:/\.\./,alias:"operator"}}),s.languages.insertBefore("csharp","punctuation",{"named-parameter":{pattern:t("([(,]\\s*)<<0>>(?=\\s*:)",[h]),lookbehind:!0,alias:"punctuation"}}),s.languages.insertBefore("csharp","class-name",{namespace:{pattern:t("(\\b(?:namespace|using)\\s+)<<0>>(?:\\s*\\.\\s*<<0>>)*(?=\\s*[;{])",[h]),lookbehind:!0,inside:{punctuation:/\./}},"type-expression":{pattern:t("(\\b(?:default|typeof|sizeof)\\s*\\(\\s*(?!\\s))(?:[^()\\s]|\\s(?!\\s)|<<0>>)*(?=\\s*\\))",[b]),lookbehind:!0,alias:"class-name",inside:v},"return-type":{pattern:t("<<0>>(?=\\s+(?:<<1>>\\s*(?:=>|[({]|\\.\\s*this\\s*\\[)|this\\s*\\[))",[w,m]),inside:v,alias:"class-name"},"constructor-invocation":{pattern:t("(\\bnew\\s+)<<0>>(?=\\s*[[({])",[w]),lookbehind:!0,inside:v,alias:"class-name"},"generic-method":{pattern:t("<<0>>\\s*<<1>>(?=\\s*\\()",[h,g]),inside:{function:t("^<<0>>",[h]),generic:{pattern:RegExp(g),alias:"class-name",inside:v}}},"type-list":{pattern:t("\\b((?:<<0>>\\s+<<1>>|where\\s+<<2>>)\\s*:\\s*)(?:<<3>>|<<4>>)(?:\\s*,\\s*(?:<<3>>|<<4>>))*(?=\\s*(?:where|[{;]|=>|$))",[d,f,h,w,p.source]),lookbehind:!0,inside:{keyword:p,"class-name":{pattern:RegExp(w),greedy:!0,inside:v},punctuation:/,/}},preprocessor:{pattern:/(^\s*)#.*/m,lookbehind:!0,alias:"property",inside:{directive:{pattern:/(\s*#)\b(?:define|elif|else|endif|endregion|error|if|line|pragma|region|undef|warning)\b/,lookbehind:!0,alias:"keyword"}}}});var _=$+"|"+x,B=a("/(?![*/])|//[^\r\n]*[\r\n]|/\\*(?:[^*]|\\*(?!/))*\\*/|<<0>>",[_]),E=e(a("[^\"'/()]|<<0>>|\\(<<self>>*\\)",[B]),2),R="\\b(?:assembly|event|field|method|module|param|property|return|type)\\b",P=a("<<0>>(?:\\s*\\(<<1>>*\\))?",[m,E]);s.languages.insertBefore("csharp","class-name",{attribute:{pattern:t("((?:^|[^\\s\\w>)?])\\s*\\[\\s*)(?:<<0>>\\s*:\\s*)?<<1>>(?:\\s*,\\s*<<1>>)*(?=\\s*\\])",[R,P]),lookbehind:!0,greedy:!0,inside:{target:{pattern:t("^<<0>>(?=\\s*:)",[R]),alias:"keyword"},"attribute-arguments":{pattern:t("\\(<<0>>*\\)",[E]),inside:s.languages.csharp},"class-name":{pattern:RegExp(m),inside:{punctuation:/\./}},punctuation:/[:,]/}}});var z=":[^}\r\n]+",S=e(a("[^\"'/()]|<<0>>|\\(<<self>>*\\)",[B]),2),j=a("\\{(?!\\{)(?:(?![}:])<<0>>)*<<1>>?\\}",[S,z]),A=e(a("[^\"'/()]|/(?!\\*)|/\\*(?:[^*]|\\*(?!/))*\\*/|<<0>>|\\(<<self>>*\\)",[_]),2),F=a("\\{(?!\\{)(?:(?![}:])<<0>>)*<<1>>?\\}",[A,z]);function U(e,n){return{interpolation:{pattern:t("((?:^|[^{])(?:\\{\\{)*)<<0>>",[e]),lookbehind:!0,inside:{"format-string":{pattern:t("(^\\{(?:(?![}:])<<0>>)*)<<1>>(?=\\}$)",[n,z]),lookbehind:!0,inside:{punctuation:/^:/}},punctuation:/^\{|\}$/,expression:{pattern:/[\s\S]+/,alias:"language-csharp",inside:s.languages.csharp}}},string:/[\s\S]+/}}s.languages.insertBefore("csharp","string",{"interpolation-string":[{pattern:t('(^|[^\\\\])(?:\\$@|@\\$)"(?:""|\\\\[^]|\\{\\{|<<0>>|[^\\\\{"])*"',[j]),lookbehind:!0,greedy:!0,inside:U(j,S)},{pattern:t('(^|[^@\\\\])\\$"(?:\\\\.|\\{\\{|<<0>>|[^\\\\"{])*"',[F]),lookbehind:!0,greedy:!0,inside:U(F,A)}]})}(Prism),Prism.languages.dotnet=Prism.languages.cs=Prism.languages.csharp;Prism.languages.dart=Prism.languages.extend("clike",{string:[{pattern:/r?("""|''')[\s\S]*?\1/,greedy:!0},{pattern:/r?("|')(?:\\.|(?!\1)[^\\\r\n])*\1/,greedy:!0}],keyword:[/\b(?:async|sync|yield)\*/,/\b(?:abstract|assert|async|await|break|case|catch|class|const|continue|covariant|default|deferred|do|dynamic|else|enum|export|extension|external|extends|factory|final|finally|for|Function|get|hide|if|implements|interface|import|in|library|mixin|new|null|on|operator|part|rethrow|return|set|show|static|super|switch|sync|this|throw|try|typedef|var|void|while|with|yield)\b/],operator:/\bis!|\b(?:as|is)\b|\+\+|--|&&|\|\||<<=?|>>=?|~(?:\/=?)?|[+\-*\/%&^|=!<>]=?|\?/}),Prism.languages.insertBefore("dart","function",{metadata:{pattern:/@\w+/,alias:"symbol"}});Prism.languages.go=Prism.languages.extend("clike",{string:{pattern:/(["'`])(?:\\[\s\S]|(?!\1)[^\\])*\1/,greedy:!0},keyword:/\b(?:break|case|chan|const|continue|default|defer|else|fallthrough|for|func|go(?:to)?|if|import|interface|map|package|range|return|select|struct|switch|type|var)\b/,boolean:/\b(?:_|iota|nil|true|false)\b/,number:/(?:\b0x[a-f\d]+|(?:\b\d+(?:\.\d*)?|\B\.\d+)(?:e[-+]?\d+)?)i?/i,operator:/[*\/%^!=]=?|\+[=+]?|-[=-]?|\|[=|]?|&(?:=|&|\^=?)?|>(?:>=?|=)?|<(?:<=?|=|-)?|:=|\.\.\./,builtin:/\b(?:bool|byte|complex(?:64|128)|error|float(?:32|64)|rune|string|u?int(?:8|16|32|64)?|uintptr|append|cap|close|complex|copy|delete|imag|len|make|new|panic|print(?:ln)?|real|recover)\b/}),delete Prism.languages.go["class-name"];Prism.languages.graphql={comment:/#.*/,description:{pattern:/(?:"""(?:[^"]|(?!""")")*"""|"(?:\\.|[^\\"\r\n])*")(?=\s*[a-z_])/i,greedy:!0,alias:"string",inside:{"language-markdown":{pattern:/(^"(?:"")?)(?!\1)[\s\S]+(?=\1$)/,lookbehind:!0,inside:Prism.languages.markdown}}},string:{pattern:/"""(?:[^"]|(?!""")")*"""|"(?:\\.|[^\\"\r\n])*"/,greedy:!0},number:/(?:\B-|\b)\d+(?:\.\d+)?(?:e[+-]?\d+)?\b/i,boolean:/\b(?:true|false)\b/,variable:/\$[a-z_]\w*/i,directive:{pattern:/@[a-z_]\w*/i,alias:"function"},"attr-name":{pattern:/[a-z_]\w*(?=\s*(?:\((?:[^()"]|"(?:\\.|[^\\"\r\n])*")*\))?:)/i,greedy:!0},"class-name":{pattern:/(\b(?:enum|implements|interface|on|scalar|type|union)\s+|&\s*)[a-zA-Z_]\w*/,lookbehind:!0},fragment:{pattern:/(\bfragment\s+|\.{3}\s*(?!on\b))[a-zA-Z_]\w*/,lookbehind:!0,alias:"function"},keyword:/\b(?:directive|enum|extend|fragment|implements|input|interface|mutation|on|query|repeatable|scalar|schema|subscription|type|union)\b/,operator:/[!=|&]|\.{3}/,punctuation:/[!(){}\[\]:=,]/,constant:/\b(?!ID\b)[A-Z][A-Z_\d]*\b/};!function(t){t.languages.http={"request-line":{pattern:/^(?:GET|HEAD|POST|PUT|DELETE|CONNECT|OPTIONS|TRACE|PATCH|PRI|SEARCH)\s(?:https?:\/\/|\/)\S*\sHTTP\/[0-9.]+/m,inside:{method:{pattern:/^[A-Z]+\b/,alias:"property"},"request-target":{pattern:/^(\s)(?:https?:\/\/|\/)\S*(?=\s)/,lookbehind:!0,alias:"url",inside:t.languages.uri},"http-version":{pattern:/^(\s)HTTP\/[0-9.]+/,lookbehind:!0,alias:"property"}}},"response-status":{pattern:/^HTTP\/[0-9.]+ \d+ .+/m,inside:{"http-version":{pattern:/^HTTP\/[0-9.]+/,alias:"property"},"status-code":{pattern:/^(\s)\d+(?=\s)/,lookbehind:!0,alias:"number"},"reason-phrase":{pattern:/^(\s).+/,lookbehind:!0,alias:"string"}}},"header-name":{pattern:/^[\w-]+:(?=.)/m,alias:"keyword"}};var a,e,s,n=t.languages,i={"application/javascript":n.javascript,"application/json":n.json||n.javascript,"application/xml":n.xml,"text/xml":n.xml,"text/html":n.html,"text/css":n.css},r={"application/json":!0,"application/xml":!0};for(var p in i)if(i[p]){a=a||{};var o=r[p]?(void 0,s=(e=p).replace(/^[a-z]+\//,""),"(?:"+e+"|\\w+/(?:[\\w.-]+\\+)+"+s+"(?![+\\w.-]))"):p;a[p.replace(/\//g,"-")]={pattern:RegExp("(content-type:\\s*"+o+".*)(?:\\r?\\n|\\r){2}[\\s\\S]*","i"),lookbehind:!0,inside:i[p]}}a&&t.languages.insertBefore("http","header-name",a)}(Prism);!function(e){var t=/\b(?:abstract|assert|boolean|break|byte|case|catch|char|class|const|continue|default|do|double|else|enum|exports|extends|final|finally|float|for|goto|if|implements|import|instanceof|int|interface|long|module|native|new|non-sealed|null|open|opens|package|permits|private|protected|provides|public|record|requires|return|sealed|short|static|strictfp|super|switch|synchronized|this|throw|throws|to|transient|transitive|try|uses|var|void|volatile|while|with|yield)\b/,n="(^|[^\\w.])(?:[a-z]\\w*\\s*\\.\\s*)*(?:[A-Z]\\w*\\s*\\.\\s*)*",a={pattern:RegExp(n+"[A-Z](?:[\\d_A-Z]*[a-z]\\w*)?\\b"),lookbehind:!0,inside:{namespace:{pattern:/^[a-z]\w*(?:\s*\.\s*[a-z]\w*)*(?:\s*\.)?/,inside:{punctuation:/\./}},punctuation:/\./}};e.languages.java=e.languages.extend("clike",{"class-name":[a,{pattern:RegExp(n+"[A-Z]\\w*(?=\\s+\\w+\\s*[;,=())])"),lookbehind:!0,inside:a.inside}],keyword:t,function:[e.languages.clike.function,{pattern:/(\:\:\s*)[a-z_]\w*/,lookbehind:!0}],number:/\b0b[01][01_]*L?\b|\b0x(?:\.[\da-f_p+-]+|[\da-f_]+(?:\.[\da-f_p+-]+)?)\b|(?:\b\d[\d_]*(?:\.[\d_]*)?|\B\.\d[\d_]*)(?:e[+-]?\d[\d_]*)?[dfl]?/i,operator:{pattern:/(^|[^.])(?:<<=?|>>>?=?|->|--|\+\+|&&|\|\||::|[?:~]|[-+*/%&|^!=<>]=?)/m,lookbehind:!0}}),e.languages.insertBefore("java","string",{"triple-quoted-string":{pattern:/"""[ \t]*[\r\n](?:(?:"|"")?(?:\\.|[^"\\]))*"""/,greedy:!0,alias:"string"}}),e.languages.insertBefore("java","class-name",{annotation:{pattern:/(^|[^.])@\w+(?:\s*\.\s*\w+)*/,lookbehind:!0,alias:"punctuation"},generics:{pattern:/<(?:[\w\s,.&?]|<(?:[\w\s,.&?]|<(?:[\w\s,.&?]|<[\w\s,.&?]*>)*>)*>)*>/,inside:{"class-name":a,keyword:t,punctuation:/[<>(),.:]/,operator:/[?&|]/}},namespace:{pattern:RegExp("(\\b(?:exports|import(?:\\s+static)?|module|open|opens|package|provides|requires|to|transitive|uses|with)\\s+)(?!<keyword>)[a-z]\\w*(?:\\.[a-z]\\w*)*\\.?".replace(/<keyword>/g,function(){return t.source})),lookbehind:!0,inside:{punctuation:/\./}}})}(Prism);Prism.languages.json={property:{pattern:/(^|[^\\])"(?:\\.|[^\\"\r\n])*"(?=\s*:)/,lookbehind:!0,greedy:!0},string:{pattern:/(^|[^\\])"(?:\\.|[^\\"\r\n])*"(?!\s*:)/,lookbehind:!0,greedy:!0},comment:{pattern:/\/\/.*|\/\*[\s\S]*?(?:\*\/|$)/,greedy:!0},number:/-?\b\d+(?:\.\d+)?(?:e[+-]?\d+)?\b/i,punctuation:/[{}[\],]/,operator:/:/,boolean:/\b(?:true|false)\b/,null:{pattern:/\bnull\b/,alias:"keyword"}},Prism.languages.webmanifest=Prism.languages.json;!function(e){e.languages.kotlin=e.languages.extend("clike",{keyword:{pattern:/(^|[^.])\b(?:abstract|actual|annotation|as|break|by|catch|class|companion|const|constructor|continue|crossinline|data|do|dynamic|else|enum|expect|external|final|finally|for|fun|get|if|import|in|infix|init|inline|inner|interface|internal|is|lateinit|noinline|null|object|open|operator|out|override|package|private|protected|public|reified|return|sealed|set|super|suspend|tailrec|this|throw|to|try|typealias|val|var|vararg|when|where|while)\b/,lookbehind:!0},function:[{pattern:/(?:`[^\r\n`]+`|\w+)(?=\s*\()/,greedy:!0},{pattern:/(\.)(?:`[^\r\n`]+`|\w+)(?=\s*\{)/,lookbehind:!0,greedy:!0}],number:/\b(?:0[xX][\da-fA-F]+(?:_[\da-fA-F]+)*|0[bB][01]+(?:_[01]+)*|\d+(?:_\d+)*(?:\.\d+(?:_\d+)*)?(?:[eE][+-]?\d+(?:_\d+)*)?[fFL]?)\b/,operator:/\+[+=]?|-[-=>]?|==?=?|!(?:!|==?)?|[\/*%<>]=?|[?:]:?|\.\.|&&|\|\||\b(?:and|inv|or|shl|shr|ushr|xor)\b/}),delete e.languages.kotlin["class-name"],e.languages.insertBefore("kotlin","string",{"raw-string":{pattern:/("""|''')[\s\S]*?\1/,alias:"string"}}),e.languages.insertBefore("kotlin","keyword",{annotation:{pattern:/\B@(?:\w+:)?(?:[A-Z]\w*|\[[^\]]+\])/,alias:"builtin"}}),e.languages.insertBefore("kotlin","function",{label:{pattern:/\w+@|@\w+/,alias:"symbol"}});var n=[{pattern:/\$\{[^}]+\}/,inside:{delimiter:{pattern:/^\$\{|\}$/,alias:"variable"},rest:e.languages.kotlin}},{pattern:/\$\w+/,alias:"variable"}];e.languages.kotlin.string.inside=e.languages.kotlin["raw-string"].inside={interpolation:n},e.languages.kt=e.languages.kotlin,e.languages.kts=e.languages.kotlin}(Prism);!function(h){function v(e,n){return"___"+e.toUpperCase()+n+"___"}Object.defineProperties(h.languages["markup-templating"]={},{buildPlaceholders:{value:function(a,r,e,o){if(a.language===r){var c=a.tokenStack=[];a.code=a.code.replace(e,function(e){if("function"==typeof o&&!o(e))return e;for(var n,t=c.length;-1!==a.code.indexOf(n=v(r,t));)++t;return c[t]=e,n}),a.grammar=h.languages.markup}}},tokenizePlaceholders:{value:function(p,k){if(p.language===k&&p.tokenStack){p.grammar=h.languages[k];var m=0,d=Object.keys(p.tokenStack);!function e(n){for(var t=0;t<n.length&&!(m>=d.length);t++){var a=n[t];if("string"==typeof a||a.content&&"string"==typeof a.content){var r=d[m],o=p.tokenStack[r],c="string"==typeof a?a:a.content,i=v(k,r),u=c.indexOf(i);if(-1<u){++m;var g=c.substring(0,u),l=new h.Token(k,h.tokenize(o,p.grammar),"language-"+k,o),s=c.substring(u+i.length),f=[];g&&f.push.apply(f,e([g])),f.push(l),s&&f.push.apply(f,e([s])),"string"==typeof a?n.splice.apply(n,[t,1].concat(f)):a.content=f}}else a.content&&e(a.content)}return n}(p.tokens)}}}})}(Prism);!function(a){var e=/\/\*[\s\S]*?\*\/|\/\/.*|#(?!\[).*/,t=[{pattern:/\b(?:false|true)\b/i,alias:"boolean"},/\b[A-Z_][A-Z0-9_]*\b(?!\s*\()/,/\b(?:null)\b/i],i=/\b0b[01]+(?:_[01]+)*\b|\b0o[0-7]+(?:_[0-7]+)*\b|\b0x[\da-f]+(?:_[\da-f]+)*\b|(?:\b\d+(?:_\d+)*\.?(?:\d+(?:_\d+)*)?|\B\.\d+)(?:e[+-]?\d+)?/i,n=/<?=>|\?\?=?|\.{3}|\??->|[!=]=?=?|::|\*\*=?|--|\+\+|&&|\|\||<<|>>|[?~]|[/^|%*&<>.+-]=?/,s=/[{}\[\](),:;]/;a.languages.php={delimiter:{pattern:/\?>$|^<\?(?:php(?=\s)|=)?/i,alias:"important"},comment:e,variable:/\$+(?:\w+\b|(?={))/i,package:{pattern:/(namespace\s+|use\s+(?:function\s+)?)(?:\\?\b[a-z_]\w*)+\b(?!\\)/i,lookbehind:!0,inside:{punctuation:/\\/}},"class-name-definition":{pattern:/(\b(?:class|interface|trait)\s+)\b[a-z_]\w*(?!\\)\b/i,lookbehind:!0,alias:"class-name"},keyword:[{pattern:/(\(\s*)\b(?:bool|boolean|int|integer|float|string|object|array)\b(?=\s*\))/i,alias:"type-casting",greedy:!0,lookbehind:!0},{pattern:/([(,?]\s*)\b(?:bool|int|float|string|object|array(?!\s*\()|mixed|self|static|callable|iterable|(?:null|false)(?=\s*\|))\b(?=\s*\$)/i,alias:"type-hint",greedy:!0,lookbehind:!0},{pattern:/([(,?]\s*[a-z0-9_|]\|\s*)(?:null|false)\b(?=\s*\$)/i,alias:"type-hint",greedy:!0,lookbehind:!0},{pattern:/(\)\s*:\s*(?:\?\s*)?)\b(?:bool|int|float|string|object|void|array(?!\s*\()|mixed|self|static|callable|iterable|(?:null|false)(?=\s*\|))\b/i,alias:"return-type",greedy:!0,lookbehind:!0},{pattern:/(\)\s*:\s*(?:\?\s*)?[a-z0-9_|]\|\s*)(?:null|false)\b/i,alias:"return-type",greedy:!0,lookbehind:!0},{pattern:/\b(?:bool|int|float|string|object|void|array(?!\s*\()|mixed|iterable|(?:null|false)(?=\s*\|))\b/i,alias:"type-declaration",greedy:!0},{pattern:/(\|\s*)(?:null|false)\b/i,alias:"type-declaration",greedy:!0,lookbehind:!0},{pattern:/\b(?:parent|self|static)(?=\s*::)/i,alias:"static-context",greedy:!0},/\b(?:__halt_compiler|abstract|and|array|as|break|callable|case|catch|class|clone|const|continue|declare|default|die|do|echo|else|elseif|empty|enddeclare|endfor|endforeach|endif|endswitch|endwhile|eval|exit|extends|final|finally|for|foreach|function|global|goto|if|implements|include|include_once|instanceof|insteadof|interface|isset|list|namespace|match|new|or|parent|print|private|protected|public|require|require_once|return|self|static|switch|throw|trait|try|unset|use|var|while|xor|yield)\b/i],"argument-name":/\b[a-z_]\w*(?=\s*:(?!:))/i,"class-name":[{pattern:/(\b(?:extends|implements|instanceof|new(?!\s+self|\s+static))\s+|\bcatch\s*\()\b[a-z_]\w*(?!\\)\b/i,greedy:!0,lookbehind:!0},{pattern:/(\|\s*)\b[a-z_]\w*(?!\\)\b/i,greedy:!0,lookbehind:!0},{pattern:/\b[a-z_]\w*(?!\\)\b(?=\s*\|)/i,greedy:!0},{pattern:/(\|\s*)(?:\\?\b[a-z_]\w*)+\b/i,alias:"class-name-fully-qualified",greedy:!0,lookbehind:!0,inside:{punctuation:/\\/}},{pattern:/(?:\\?\b[a-z_]\w*)+\b(?=\s*\|)/i,alias:"class-name-fully-qualified",greedy:!0,inside:{punctuation:/\\/}},{pattern:/(\b(?:extends|implements|instanceof|new(?!\s+self\b|\s+static\b))\s+|\bcatch\s*\()(?:\\?\b[a-z_]\w*)+\b(?!\\)/i,alias:"class-name-fully-qualified",greedy:!0,lookbehind:!0,inside:{punctuation:/\\/}},{pattern:/\b[a-z_]\w*(?=\s*\$)/i,alias:"type-declaration",greedy:!0},{pattern:/(?:\\?\b[a-z_]\w*)+(?=\s*\$)/i,alias:["class-name-fully-qualified","type-declaration"],greedy:!0,inside:{punctuation:/\\/}},{pattern:/\b[a-z_]\w*(?=\s*::)/i,alias:"static-context",greedy:!0},{pattern:/(?:\\?\b[a-z_]\w*)+(?=\s*::)/i,alias:["class-name-fully-qualified","static-context"],greedy:!0,inside:{punctuation:/\\/}},{pattern:/([(,?]\s*)[a-z_]\w*(?=\s*\$)/i,alias:"type-hint",greedy:!0,lookbehind:!0},{pattern:/([(,?]\s*)(?:\\?\b[a-z_]\w*)+(?=\s*\$)/i,alias:["class-name-fully-qualified","type-hint"],greedy:!0,lookbehind:!0,inside:{punctuation:/\\/}},{pattern:/(\)\s*:\s*(?:\?\s*)?)\b[a-z_]\w*(?!\\)\b/i,alias:"return-type",greedy:!0,lookbehind:!0},{pattern:/(\)\s*:\s*(?:\?\s*)?)(?:\\?\b[a-z_]\w*)+\b(?!\\)/i,alias:["class-name-fully-qualified","return-type"],greedy:!0,lookbehind:!0,inside:{punctuation:/\\/}}],constant:t,function:/\w+\s*(?=\()/,property:{pattern:/(->)[\w]+/,lookbehind:!0},number:i,operator:n,punctuation:s};var l={pattern:/{\$(?:{(?:{[^{}]+}|[^{}]+)}|[^{}])+}|(^|[^\\{])\$+(?:\w+(?:\[[^\r\n\[\]]+\]|->\w+)*)/,lookbehind:!0,inside:a.languages.php},r=[{pattern:/<<<'([^']+)'[\r\n](?:.*[\r\n])*?\1;/,alias:"nowdoc-string",greedy:!0,inside:{delimiter:{pattern:/^<<<'[^']+'|[a-z_]\w*;$/i,alias:"symbol",inside:{punctuation:/^<<<'?|[';]$/}}}},{pattern:/<<<(?:"([^"]+)"[\r\n](?:.*[\r\n])*?\1;|([a-z_]\w*)[\r\n](?:.*[\r\n])*?\2;)/i,alias:"heredoc-string",greedy:!0,inside:{delimiter:{pattern:/^<<<(?:"[^"]+"|[a-z_]\w*)|[a-z_]\w*;$/i,alias:"symbol",inside:{punctuation:/^<<<"?|[";]$/}},interpolation:l}},{pattern:/`(?:\\[\s\S]|[^\\`])*`/,alias:"backtick-quoted-string",greedy:!0},{pattern:/'(?:\\[\s\S]|[^\\'])*'/,alias:"single-quoted-string",greedy:!0},{pattern:/"(?:\\[\s\S]|[^\\"])*"/,alias:"double-quoted-string",greedy:!0,inside:{interpolation:l}}];a.languages.insertBefore("php","variable",{string:r}),a.languages.insertBefore("php","variable",{attribute:{pattern:/#\[(?:[^"'\/#]|\/(?![*/])|\/\/.*$|#(?!\[).*$|\/\*(?:[^*]|\*(?!\/))*\*\/|"(?:\\[\s\S]|[^\\"])*"|'(?:\\[\s\S]|[^\\'])*')+\](?=\s*[a-z$#])/im,greedy:!0,inside:{"attribute-content":{pattern:/^(#\[)[\s\S]+(?=]$)/,lookbehind:!0,inside:{comment:e,string:r,"attribute-class-name":[{pattern:/([^:]|^)\b[a-z_]\w*(?!\\)\b/i,alias:"class-name",greedy:!0,lookbehind:!0},{pattern:/([^:]|^)(?:\\?\b[a-z_]\w*)+/i,alias:["class-name","class-name-fully-qualified"],greedy:!0,lookbehind:!0,inside:{punctuation:/\\/}}],constant:t,number:i,operator:n,punctuation:s}},delimiter:{pattern:/^#\[|]$/,alias:"punctuation"}}}}),a.hooks.add("before-tokenize",function(e){if(/<\?/.test(e.code)){a.languages["markup-templating"].buildPlaceholders(e,"php",/<\?(?:[^"'/#]|\/(?![*/])|("|')(?:\\[\s\S]|(?!\1)[^\\])*\1|(?:\/\/|#(?!\[))(?:[^?\n\r]|\?(?!>))*(?=$|\?>|[\r\n])|#\[|\/\*(?:[^*]|\*(?!\/))*(?:\*\/|$))*?(?:\?>|$)/gi)}}),a.hooks.add("after-tokenize",function(e){a.languages["markup-templating"].tokenizePlaceholders(e,"php")})}(Prism);!function(e){var i=Prism.languages.powershell={comment:[{pattern:/(^|[^`])<#[\s\S]*?#>/,lookbehind:!0},{pattern:/(^|[^`])#.*/,lookbehind:!0}],string:[{pattern:/"(?:`[\s\S]|[^`"])*"/,greedy:!0,inside:{function:{pattern:/(^|[^`])\$\((?:\$\([^\r\n()]*\)|(?!\$\()[^\r\n)])*\)/,lookbehind:!0,inside:{}}}},{pattern:/'(?:[^']|'')*'/,greedy:!0}],namespace:/\[[a-z](?:\[(?:\[[^\]]*]|[^\[\]])*]|[^\[\]])*]/i,boolean:/\$(?:true|false)\b/i,variable:/\$\w+\b/,function:[/\b(?:Add|Approve|Assert|Backup|Block|Checkpoint|Clear|Close|Compare|Complete|Compress|Confirm|Connect|Convert|ConvertFrom|ConvertTo|Copy|Debug|Deny|Disable|Disconnect|Dismount|Edit|Enable|Enter|Exit|Expand|Export|Find|ForEach|Format|Get|Grant|Group|Hide|Import|Initialize|Install|Invoke|Join|Limit|Lock|Measure|Merge|Move|New|Open|Optimize|Out|Ping|Pop|Protect|Publish|Push|Read|Receive|Redo|Register|Remove|Rename|Repair|Request|Reset|Resize|Resolve|Restart|Restore|Resume|Revoke|Save|Search|Select|Send|Set|Show|Skip|Sort|Split|Start|Step|Stop|Submit|Suspend|Switch|Sync|Tee|Test|Trace|Unblock|Undo|Uninstall|Unlock|Unprotect|Unpublish|Unregister|Update|Use|Wait|Watch|Where|Write)-[a-z]+\b/i,/\b(?:ac|cat|chdir|clc|cli|clp|clv|compare|copy|cp|cpi|cpp|cvpa|dbp|del|diff|dir|ebp|echo|epal|epcsv|epsn|erase|fc|fl|ft|fw|gal|gbp|gc|gci|gcs|gdr|gi|gl|gm|gp|gps|group|gsv|gu|gv|gwmi|iex|ii|ipal|ipcsv|ipsn|irm|iwmi|iwr|kill|lp|ls|measure|mi|mount|move|mp|mv|nal|ndr|ni|nv|ogv|popd|ps|pushd|pwd|rbp|rd|rdr|ren|ri|rm|rmdir|rni|rnp|rp|rv|rvpa|rwmi|sal|saps|sasv|sbp|sc|select|set|shcm|si|sl|sleep|sls|sort|sp|spps|spsv|start|sv|swmi|tee|trcm|type|write)\b/i],keyword:/\b(?:Begin|Break|Catch|Class|Continue|Data|Define|Do|DynamicParam|Else|ElseIf|End|Exit|Filter|Finally|For|ForEach|From|Function|If|InlineScript|Parallel|Param|Process|Return|Sequence|Switch|Throw|Trap|Try|Until|Using|Var|While|Workflow)\b/i,operator:{pattern:/(\W?)(?:!|-(?:eq|ne|gt|ge|lt|le|sh[lr]|not|b?(?:and|x?or)|(?:Not)?(?:Like|Match|Contains|In)|Replace|Join|is(?:Not)?|as)\b|-[-=]?|\+[+=]?|[*\/%]=?)/i,lookbehind:!0},punctuation:/[|{}[\];(),.]/},r=i.string[0].inside;r.boolean=i.boolean,r.variable=i.variable,r.function.inside=i}();Prism.languages.python={comment:{pattern:/(^|[^\\])#.*/,lookbehind:!0},"string-interpolation":{pattern:/(?:f|rf|fr)(?:("""|''')[\s\S]*?\1|("|')(?:\\.|(?!\2)[^\\\r\n])*\2)/i,greedy:!0,inside:{interpolation:{pattern:/((?:^|[^{])(?:{{)*){(?!{)(?:[^{}]|{(?!{)(?:[^{}]|{(?!{)(?:[^{}])+})+})+}/,lookbehind:!0,inside:{"format-spec":{pattern:/(:)[^:(){}]+(?=}$)/,lookbehind:!0},"conversion-option":{pattern:/![sra](?=[:}]$)/,alias:"punctuation"},rest:null}},string:/[\s\S]+/}},"triple-quoted-string":{pattern:/(?:[rub]|rb|br)?("""|''')[\s\S]*?\1/i,greedy:!0,alias:"string"},string:{pattern:/(?:[rub]|rb|br)?("|')(?:\\.|(?!\1)[^\\\r\n])*\1/i,greedy:!0},function:{pattern:/((?:^|\s)def[ \t]+)[a-zA-Z_]\w*(?=\s*\()/g,lookbehind:!0},"class-name":{pattern:/(\bclass\s+)\w+/i,lookbehind:!0},decorator:{pattern:/(^\s*)@\w+(?:\.\w+)*/im,lookbehind:!0,alias:["annotation","punctuation"],inside:{punctuation:/\./}},keyword:/\b(?:and|as|assert|async|await|break|class|continue|def|del|elif|else|except|exec|finally|for|from|global|if|import|in|is|lambda|nonlocal|not|or|pass|print|raise|return|try|while|with|yield)\b/,builtin:/\b(?:__import__|abs|all|any|apply|ascii|basestring|bin|bool|buffer|bytearray|bytes|callable|chr|classmethod|cmp|coerce|compile|complex|delattr|dict|dir|divmod|enumerate|eval|execfile|file|filter|float|format|frozenset|getattr|globals|hasattr|hash|help|hex|id|input|int|intern|isinstance|issubclass|iter|len|list|locals|long|map|max|memoryview|min|next|object|oct|open|ord|pow|property|range|raw_input|reduce|reload|repr|reversed|round|set|setattr|slice|sorted|staticmethod|str|sum|super|tuple|type|unichr|unicode|vars|xrange|zip)\b/,boolean:/\b(?:True|False|None)\b/,number:/(?:\b(?=\d)|\B(?=\.))(?:0[bo])?(?:(?:\d|0x[\da-f])[\da-f]*(?:\.\d*)?|\.\d+)(?:e[+-]?\d+)?j?\b/i,operator:/[-+%=]=?|!=|\*\*?=?|\/\/?=?|<[<=>]?|>[=>]?|[&|^~]/,punctuation:/[{}[\];(),.:]/},Prism.languages.python["string-interpolation"].inside.interpolation.inside.rest=Prism.languages.python,Prism.languages.py=Prism.languages.python;!function(e){e.languages.ruby=e.languages.extend("clike",{comment:[/#.*/,{pattern:/^=begin\s[\s\S]*?^=end/m,greedy:!0}],"class-name":{pattern:/(\b(?:class)\s+|\bcatch\s+\()[\w.\\]+/i,lookbehind:!0,inside:{punctuation:/[.\\]/}},keyword:/\b(?:alias|and|BEGIN|begin|break|case|class|def|define_method|defined|do|each|else|elsif|END|end|ensure|extend|for|if|in|include|module|new|next|nil|not|or|prepend|protected|private|public|raise|redo|require|rescue|retry|return|self|super|then|throw|undef|unless|until|when|while|yield)\b/});var n={pattern:/#\{[^}]+\}/,inside:{delimiter:{pattern:/^#\{|\}$/,alias:"tag"},rest:e.languages.ruby}};delete e.languages.ruby.function,e.languages.insertBefore("ruby","keyword",{regex:[{pattern:RegExp("%r(?:"+["([^a-zA-Z0-9\\s{(\\[<])(?:(?!\\1)[^\\\\]|\\\\[^])*\\1[gim]{0,3}","\\((?:[^()\\\\]|\\\\[^])*\\)[gim]{0,3}","\\{(?:[^#{}\\\\]|#(?:\\{[^}]+\\})?|\\\\[^])*\\}[gim]{0,3}","\\[(?:[^\\[\\]\\\\]|\\\\[^])*\\][gim]{0,3}","<(?:[^<>\\\\]|\\\\[^])*>[gim]{0,3}"].join("|")+")"),greedy:!0,inside:{interpolation:n}},{pattern:/(^|[^/])\/(?!\/)(?:\[[^\r\n\]]+\]|\\.|[^[/\\\r\n])+\/[gim]{0,3}(?=\s*(?:$|[\r\n,.;})]))/,lookbehind:!0,greedy:!0}],variable:/[@$]+[a-zA-Z_]\w*(?:[?!]|\b)/,symbol:{pattern:/(^|[^:]):[a-zA-Z_]\w*(?:[?!]|\b)/,lookbehind:!0},"method-definition":{pattern:/(\bdef\s+)[\w.]+/,lookbehind:!0,inside:{function:/\w+$/,rest:e.languages.ruby}}}),e.languages.insertBefore("ruby","number",{builtin:/\b(?:Array|Bignum|Binding|Class|Continuation|Dir|Exception|FalseClass|File|Stat|Fixnum|Float|Hash|Integer|IO|MatchData|Method|Module|NilClass|Numeric|Object|Proc|Range|Regexp|String|Struct|TMS|Symbol|ThreadGroup|Thread|Time|TrueClass)\b/,constant:/\b[A-Z]\w*(?:[?!]|\b)/}),e.languages.ruby.string=[{pattern:RegExp("%[qQiIwWxs]?(?:"+["([^a-zA-Z0-9\\s{(\\[<])(?:(?!\\1)[^\\\\]|\\\\[^])*\\1","\\((?:[^()\\\\]|\\\\[^])*\\)","\\{(?:[^#{}\\\\]|#(?:\\{[^}]+\\})?|\\\\[^])*\\}","\\[(?:[^\\[\\]\\\\]|\\\\[^])*\\]","<(?:[^<>\\\\]|\\\\[^])*>"].join("|")+")"),greedy:!0,inside:{interpolation:n}},{pattern:/("|')(?:#\{[^}]+\}|#(?!\{)|\\(?:\r\n|[\s\S])|(?!\1)[^\\#\r\n])*\1/,greedy:!0,inside:{interpolation:n}}],e.languages.rb=e.languages.ruby}(Prism);Prism.languages.swift=Prism.languages.extend("clike",{string:{pattern:/("|')(?:\\(?:\((?:[^()]|\([^)]+\))+\)|\r\n|[^(])|(?!\1)[^\\\r\n])*\1/,greedy:!0,inside:{interpolation:{pattern:/\\\((?:[^()]|\([^)]+\))+\)/,inside:{delimiter:{pattern:/^\\\(|\)$/,alias:"variable"}}}}},keyword:/\b(?:as|associativity|break|case|catch|class|continue|convenience|default|defer|deinit|didSet|do|dynamic(?:Type)?|else|enum|extension|fallthrough|final|for|func|get|guard|if|import|in|infix|init|inout|internal|is|lazy|left|let|mutating|new|none|nonmutating|operator|optional|override|postfix|precedence|prefix|private|protocol|public|repeat|required|rethrows|return|right|safe|self|Self|set|static|struct|subscript|super|switch|throws?|try|Type|typealias|unowned|unsafe|var|weak|where|while|willSet|__(?:COLUMN__|FILE__|FUNCTION__|LINE__))\b/,number:/\b(?:[\d_]+(?:\.[\de_]+)?|0x[a-f0-9_]+(?:\.[a-f0-9p_]+)?|0b[01_]+|0o[0-7_]+)\b/i,constant:/\b(?:nil|[A-Z_]{2,}|k[A-Z][A-Za-z_]+)\b/,atrule:/@\b(?:IB(?:Outlet|Designable|Action|Inspectable)|class_protocol|exported|noreturn|NS(?:Copying|Managed)|objc|UIApplicationMain|auto_closure)\b/,builtin:/\b(?:[A-Z]\S+|abs|advance|alignof(?:Value)?|assert|contains|count(?:Elements)?|debugPrint(?:ln)?|distance|drop(?:First|Last)|dump|enumerate|equal|filter|find|first|getVaList|indices|isEmpty|join|last|lexicographicalCompare|map|max(?:Element)?|min(?:Element)?|numericCast|overlaps|partition|print(?:ln)?|reduce|reflect|reverse|sizeof(?:Value)?|sort(?:ed)?|split|startsWith|stride(?:of(?:Value)?)?|suffix|swap|toDebugString|toString|transcode|underestimateCount|unsafeBitCast|with(?:ExtendedLifetime|Unsafe(?:MutablePointers?|Pointers?)|VaList))\b/}),Prism.languages.swift.string.inside.interpolation.inside.rest=Prism.languages.swift;!function(e){e.languages.typescript=e.languages.extend("javascript",{"class-name":{pattern:/(\b(?:class|extends|implements|instanceof|interface|new|type)\s+)(?!keyof\b)(?!\s)[_$a-zA-Z\xA0-\uFFFF](?:(?!\s)[$\w\xA0-\uFFFF])*(?:\s*<(?:[^<>]|<(?:[^<>]|<[^<>]*>)*>)*>)?/,lookbehind:!0,greedy:!0,inside:null},keyword:/\b(?:abstract|as|asserts|async|await|break|case|catch|class|const|constructor|continue|debugger|declare|default|delete|do|else|enum|export|extends|finally|for|from|function|get|if|implements|import|in|instanceof|interface|is|keyof|let|module|namespace|new|null|of|package|private|protected|public|readonly|return|require|set|static|super|switch|this|throw|try|type|typeof|undefined|var|void|while|with|yield)\b/,builtin:/\b(?:string|Function|any|number|boolean|Array|symbol|console|Promise|unknown|never)\b/}),delete e.languages.typescript.parameter;var n=e.languages.extend("typescript",{});delete n["class-name"],e.languages.typescript["class-name"].inside=n,e.languages.insertBefore("typescript","function",{"generic-function":{pattern:/#?(?!\s)[_$a-zA-Z\xA0-\uFFFF](?:(?!\s)[$\w\xA0-\uFFFF])*\s*<(?:[^<>]|<(?:[^<>]|<[^<>]*>)*>)*>(?=\s*\()/,greedy:!0,inside:{function:/^#?(?!\s)[_$a-zA-Z\xA0-\uFFFF](?:(?!\s)[$\w\xA0-\uFFFF])*/,generic:{pattern:/<[\s\S]+/,alias:"class-name",inside:n}}}}),e.languages.ts=e.languages.typescript}(Prism);!function(e){var n=/[*&][^\s[\]{},]+/,r=/!(?:<[\w\-%#;/?:@&=+$,.!~*'()[\]]+>|(?:[a-zA-Z\d-]*!)?[\w\-%#;/?:@&=+$.~*'()]+)?/,t="(?:"+r.source+"(?:[ \t]+"+n.source+")?|"+n.source+"(?:[ \t]+"+r.source+")?)",a="(?:[^\\s\\x00-\\x08\\x0e-\\x1f!\"#%&'*,\\-:>?@[\\]`{|}\\x7f-\\x84\\x86-\\x9f\\ud800-\\udfff\\ufffe\\uffff]|[?:-]<PLAIN>)(?:[ \t]*(?:(?![#:])<PLAIN>|:<PLAIN>))*".replace(/<PLAIN>/g,function(){return"[^\\s\\x00-\\x08\\x0e-\\x1f,[\\]{}\\x7f-\\x84\\x86-\\x9f\\ud800-\\udfff\\ufffe\\uffff]"}),d="\"(?:[^\"\\\\\r\n]|\\\\.)*\"|'(?:[^'\\\\\r\n]|\\\\.)*'";function o(e,n){n=(n||"").replace(/m/g,"")+"m";var r="([:\\-,[{]\\s*(?:\\s<<prop>>[ \t]+)?)(?:<<value>>)(?=[ \t]*(?:$|,|]|}|(?:[\r\n]\\s*)?#))".replace(/<<prop>>/g,function(){return t}).replace(/<<value>>/g,function(){return e});return RegExp(r,n)}e.languages.yaml={scalar:{pattern:RegExp("([\\-:]\\s*(?:\\s<<prop>>[ \t]+)?[|>])[ \t]*(?:((?:\r?\n|\r)[ \t]+)\\S[^\r\n]*(?:\\2[^\r\n]+)*)".replace(/<<prop>>/g,function(){return t})),lookbehind:!0,alias:"string"},comment:/#.*/,key:{pattern:RegExp("((?:^|[:\\-,[{\r\n?])[ \t]*(?:<<prop>>[ \t]+)?)<<key>>(?=\\s*:\\s)".replace(/<<prop>>/g,function(){return t}).replace(/<<key>>/g,function(){return"(?:"+a+"|"+d+")"})),lookbehind:!0,greedy:!0,alias:"atrule"},directive:{pattern:/(^[ \t]*)%.+/m,lookbehind:!0,alias:"important"},datetime:{pattern:o("\\d{4}-\\d\\d?-\\d\\d?(?:[tT]|[ \t]+)\\d\\d?:\\d{2}:\\d{2}(?:\\.\\d*)?(?:[ \t]*(?:Z|[-+]\\d\\d?(?::\\d{2})?))?|\\d{4}-\\d{2}-\\d{2}|\\d\\d?:\\d{2}(?::\\d{2}(?:\\.\\d*)?)?"),lookbehind:!0,alias:"number"},boolean:{pattern:o("true|false","i"),lookbehind:!0,alias:"important"},null:{pattern:o("null|~","i"),lookbehind:!0,alias:"important"},string:{pattern:o(d),lookbehind:!0,greedy:!0},number:{pattern:o("[+-]?(?:0x[\\da-f]+|0o[0-7]+|(?:\\d+(?:\\.\\d*)?|\\.?\\d+)(?:e[+-]?\\d+)?|\\.inf|\\.nan)","i"),lookbehind:!0},tag:r,important:n,punctuation:/---|[:[\]{}\-,|>?]|\.\.\./},e.languages.yml=e.languages.yaml}(Prism);!function(){if("undefined"!=typeof self&&self.Prism&&self.document){var o="line-numbers",a=/\n(?!$)/g,e=Prism.plugins.lineNumbers={getLine:function(e,n){if("PRE"===e.tagName&&e.classList.contains(o)){var t=e.querySelector(".line-numbers-rows");if(t){var i=parseInt(e.getAttribute("data-start"),10)||1,r=i+(t.children.length-1);n<i&&(n=i),r<n&&(n=r);var s=n-i;return t.children[s]}}},resize:function(e){u([e])},assumeViewportIndependence:!0},t=function(e){return e?window.getComputedStyle?getComputedStyle(e):e.currentStyle||null:null},n=void 0;window.addEventListener("resize",function(){e.assumeViewportIndependence&&n===window.innerWidth||(n=window.innerWidth,u(Array.prototype.slice.call(document.querySelectorAll("pre."+o))))}),Prism.hooks.add("complete",function(e){if(e.code){var n=e.element,t=n.parentNode;if(t&&/pre/i.test(t.nodeName)&&!n.querySelector(".line-numbers-rows")&&Prism.util.isActive(n,o)){n.classList.remove(o),t.classList.add(o);var i,r=e.code.match(a),s=r?r.length+1:1,l=new Array(s+1).join("<span></span>");(i=document.createElement("span")).setAttribute("aria-hidden","true"),i.className="line-numbers-rows",i.innerHTML=l,t.hasAttribute("data-start")&&(t.style.counterReset="linenumber "+(parseInt(t.getAttribute("data-start"),10)-1)),e.element.appendChild(i),u([t]),Prism.hooks.run("line-numbers",e)}}}),Prism.hooks.add("line-numbers",function(e){e.plugins=e.plugins||{},e.plugins.lineNumbers=!0})}function u(e){if(0!=(e=e.filter(function(e){var n=t(e)["white-space"];return"pre-wrap"===n||"pre-line"===n})).length){var n=e.map(function(e){var n=e.querySelector("code"),t=e.querySelector(".line-numbers-rows");if(n&&t){var i=e.querySelector(".line-numbers-sizer"),r=n.textContent.split(a);i||((i=document.createElement("span")).className="line-numbers-sizer",n.appendChild(i)),i.innerHTML="0",i.style.display="block";var s=i.getBoundingClientRect().height;return i.innerHTML="",{element:e,lines:r,lineHeights:[],oneLinerHeight:s,sizer:i}}}).filter(Boolean);n.forEach(function(e){var i=e.sizer,n=e.lines,r=e.lineHeights,s=e.oneLinerHeight;r[n.length-1]=void 0,n.forEach(function(e,n){if(e&&1<e.length){var t=i.appendChild(document.createElement("span"));t.style.display="block",t.textContent=e}else r[n]=s})}),n.forEach(function(e){for(var n=e.sizer,t=e.lineHeights,i=0,r=0;r<t.length;r++)void 0===t[r]&&(t[r]=n.children[i++].getBoundingClientRect().height)}),n.forEach(function(e){var n=e.sizer,t=e.element.querySelector(".line-numbers-rows");n.style.display="none",n.innerHTML="",e.lineHeights.forEach(function(e,n){t.children[n].style.height=e+"px"})})}}}();var TurndownService=(function(){'use strict';function extend(destination){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(source.hasOwnProperty(key))destination[key]=source[key];}}
return destination}
function repeat(character,count){return Array(count+1).join(character)}
var blockElements=['address','article','aside','audio','blockquote','body','canvas','center','dd','dir','div','dl','dt','fieldset','figcaption','figure','footer','form','frameset','h1','h2','h3','h4','h5','h6','header','hgroup','hr','html','isindex','li','main','menu','nav','noframes','noscript','ol','output','p','pre','section','table','tbody','td','tfoot','th','thead','tr','ul'];function isBlock(node){return blockElements.indexOf(node.nodeName.toLowerCase())!==-1}
var voidElements=['area','base','br','col','command','embed','hr','img','input','keygen','link','meta','param','source','track','wbr'];function isVoid(node){return voidElements.indexOf(node.nodeName.toLowerCase())!==-1}
var voidSelector=voidElements.join();function hasVoid(node){return node.querySelector&&node.querySelector(voidSelector)}
var rules={};rules.paragraph={filter:'p',replacement:function(content){return'\n\n'+content+'\n\n'}};rules.lineBreak={filter:'br',replacement:function(content,node,options){return options.br+'\n'}};rules.heading={filter:['h1','h2','h3','h4','h5','h6'],replacement:function(content,node,options){var hLevel=Number(node.nodeName.charAt(1));if(options.headingStyle==='setext'&&hLevel<3){var underline=repeat((hLevel===1?'=':'-'),content.length);return('\n\n'+content+'\n'+underline+'\n\n')}else{return'\n\n'+repeat('#',hLevel)+' '+content+'\n\n'}}};rules.blockquote={filter:'blockquote',replacement:function(content){content=content.replace(/^\n+|\n+$/g,'');content=content.replace(/^/gm,'> ');return'\n\n'+content+'\n\n'}};rules.list={filter:['ul','ol'],replacement:function(content,node){var parent=node.parentNode;if(parent.nodeName==='LI'&&parent.lastElementChild===node){return'\n'+content}else{return'\n\n'+content+'\n\n'}}};rules.listItem={filter:'li',replacement:function(content,node,options){content=content.replace(/^\n+/,'').replace(/\n+$/,'\n').replace(/\n/gm,'\n    ');var prefix=options.bulletListMarker+'   ';var parent=node.parentNode;if(parent.nodeName==='OL'){var start=parent.getAttribute('start');var index=Array.prototype.indexOf.call(parent.children,node);prefix=(start?Number(start)+index:index+1)+'.  ';}
return(prefix+content+(node.nextSibling&&!/\n$/.test(content)?'\n':''))}};rules.indentedCodeBlock={filter:function(node,options){return(options.codeBlockStyle==='indented'&&node.nodeName==='PRE'&&node.firstChild&&node.firstChild.nodeName==='CODE')},replacement:function(content,node,options){return('\n\n    '+
node.firstChild.textContent.replace(/\n/g,'\n    ')+'\n\n')}};rules.fencedCodeBlock={filter:function(node,options){return(options.codeBlockStyle==='fenced'&&node.nodeName==='PRE'&&node.firstChild&&node.firstChild.nodeName==='CODE')},replacement:function(content,node,options){var className=node.firstChild.className||'';var language=(className.match(/language-(\S+)/)||[null,''])[1];return('\n\n'+options.fence+language+'\n'+
node.firstChild.textContent+'\n'+options.fence+'\n\n')}};rules.horizontalRule={filter:'hr',replacement:function(content,node,options){return'\n\n'+options.hr+'\n\n'}};rules.inlineLink={filter:function(node,options){return(options.linkStyle==='inlined'&&node.nodeName==='A'&&node.getAttribute('href'))},replacement:function(content,node){var href=node.getAttribute('href');var title=node.title?' "'+node.title+'"':'';return'['+content+']('+href+title+')'}};rules.referenceLink={filter:function(node,options){return(options.linkStyle==='referenced'&&node.nodeName==='A'&&node.getAttribute('href'))},replacement:function(content,node,options){var href=node.getAttribute('href');var title=node.title?' "'+node.title+'"':'';var replacement;var reference;switch(options.linkReferenceStyle){case'collapsed':replacement='['+content+'][]';reference='['+content+']: '+href+title;break
case'shortcut':replacement='['+content+']';reference='['+content+']: '+href+title;break
default:var id=this.references.length+1;replacement='['+content+']['+id+']';reference='['+id+']: '+href+title;}
this.references.push(reference);return replacement},references:[],append:function(options){var references='';if(this.references.length){references='\n\n'+this.references.join('\n')+'\n\n';this.references=[];}
return references}};rules.emphasis={filter:['em','i'],replacement:function(content,node,options){if(!content.trim())return''
return options.emDelimiter+content+options.emDelimiter}};rules.strong={filter:['strong','b'],replacement:function(content,node,options){if(!content.trim())return''
return options.strongDelimiter+content+options.strongDelimiter}};rules.code={filter:function(node){var hasSiblings=node.previousSibling||node.nextSibling;var isCodeBlock=node.parentNode.nodeName==='PRE'&&!hasSiblings;return node.nodeName==='CODE'&&!isCodeBlock},replacement:function(content){if(!content.trim())return''
var delimiter='`';var leadingSpace='';var trailingSpace='';var matches=content.match(/`+/gm);if(matches){if(/^`/.test(content))leadingSpace=' ';if(/`$/.test(content))trailingSpace=' ';while(matches.indexOf(delimiter)!==-1)delimiter=delimiter+'`';}
return delimiter+leadingSpace+content+trailingSpace+delimiter}};rules.image={filter:'img',replacement:function(content,node){var alt=node.alt||'';var src=node.getAttribute('src')||'';var title=node.title||'';var titlePart=title?' "'+title+'"':'';return src?'!['+alt+']'+'('+src+titlePart+')':''}};function Rules(options){this.options=options;this._keep=[];this._remove=[];this.blankRule={replacement:options.blankReplacement};this.keepReplacement=options.keepReplacement;this.defaultRule={replacement:options.defaultReplacement};this.array=[];for(var key in options.rules)this.array.push(options.rules[key]);}
Rules.prototype={add:function(key,rule){this.array.unshift(rule);},keep:function(filter){this._keep.unshift({filter:filter,replacement:this.keepReplacement});},remove:function(filter){this._remove.unshift({filter:filter,replacement:function(){return''}});},forNode:function(node){if(node.isBlank)return this.blankRule
var rule;if((rule=findRule(this.array,node,this.options)))return rule
if((rule=findRule(this._keep,node,this.options)))return rule
if((rule=findRule(this._remove,node,this.options)))return rule
return this.defaultRule},forEach:function(fn){for(var i=0;i<this.array.length;i++)fn(this.array[i],i);}};function findRule(rules,node,options){for(var i=0;i<rules.length;i++){var rule=rules[i];if(filterValue(rule,node,options))return rule}
return void 0}
function filterValue(rule,node,options){var filter=rule.filter;if(typeof filter==='string'){if(filter===node.nodeName.toLowerCase())return true}else if(Array.isArray(filter)){if(filter.indexOf(node.nodeName.toLowerCase())>-1)return true}else if(typeof filter==='function'){if(filter.call(rule,node,options))return true}else{throw new TypeError('`filter` needs to be a string, array, or function')}}
function collapseWhitespace(options){var element=options.element;var isBlock=options.isBlock;var isVoid=options.isVoid;var isPre=options.isPre||function(node){return node.nodeName==='PRE'};if(!element.firstChild||isPre(element))return
var prevText=null;var prevVoid=false;var prev=null;var node=next(prev,element,isPre);while(node!==element){if(node.nodeType===3||node.nodeType===4){var text=node.data.replace(/[ \r\n\t]+/g,' ');if((!prevText||/ $/.test(prevText.data))&&!prevVoid&&text[0]===' '){text=text.substr(1);}
if(!text){node=remove(node);continue}
node.data=text;prevText=node;}else if(node.nodeType===1){if(isBlock(node)||node.nodeName==='BR'){if(prevText){prevText.data=prevText.data.replace(/ $/,'');}
prevText=null;prevVoid=false;}else if(isVoid(node)){prevText=null;prevVoid=true;}}else{node=remove(node);continue}
var nextNode=next(prev,node,isPre);prev=node;node=nextNode;}
if(prevText){prevText.data=prevText.data.replace(/ $/,'');if(!prevText.data){remove(prevText);}}}
function remove(node){var next=node.nextSibling||node.parentNode;node.parentNode.removeChild(node);return next}
function next(prev,current,isPre){if((prev&&prev.parentNode===current)||isPre(current)){return current.nextSibling||current.parentNode}
return current.firstChild||current.nextSibling||current.parentNode}
var root=(typeof window!=='undefined'?window:{});function canParseHTMLNatively(){var Parser=root.DOMParser;var canParse=false;try{if(new Parser().parseFromString('','text/html')){canParse=true;}}catch(e){}
return canParse}
function createHTMLParser(){var Parser=function(){};{if(shouldUseActiveX()){Parser.prototype.parseFromString=function(string){var doc=new window.ActiveXObject('htmlfile');doc.designMode='on';doc.open();doc.write(string);doc.close();return doc};}else{Parser.prototype.parseFromString=function(string){var doc=document.implementation.createHTMLDocument('');doc.open();doc.write(string);doc.close();return doc};}}
return Parser}
function shouldUseActiveX(){var useActiveX=false;try{document.implementation.createHTMLDocument('').open();}catch(e){if(window.ActiveXObject)useActiveX=true;}
return useActiveX}
var HTMLParser=canParseHTMLNatively()?root.DOMParser:createHTMLParser();function RootNode(input){var root;if(typeof input==='string'){var doc=htmlParser().parseFromString('<x-turndown id="turndown-root">'+input+'</x-turndown>','text/html');root=doc.getElementById('turndown-root');}else{root=input.cloneNode(true);}
collapseWhitespace({element:root,isBlock:isBlock,isVoid:isVoid});return root}
var _htmlParser;function htmlParser(){_htmlParser=_htmlParser||new HTMLParser();return _htmlParser}
function Node(node){node.isBlock=isBlock(node);node.isCode=node.nodeName.toLowerCase()==='code'||node.parentNode.isCode;node.isBlank=isBlank(node);node.flankingWhitespace=flankingWhitespace(node);return node}
function isBlank(node){return(['A','TH','TD'].indexOf(node.nodeName)===-1&&/^\s*$/i.test(node.textContent)&&!isVoid(node)&&!hasVoid(node))}
function flankingWhitespace(node){var leading='';var trailing='';if(!node.isBlock){var hasLeading=/^[ \r\n\t]/.test(node.textContent);var hasTrailing=/[ \r\n\t]$/.test(node.textContent);if(hasLeading&&!isFlankedByWhitespace('left',node)){leading=' ';}
if(hasTrailing&&!isFlankedByWhitespace('right',node)){trailing=' ';}}
return{leading:leading,trailing:trailing}}
function isFlankedByWhitespace(side,node){var sibling;var regExp;var isFlanked;if(side==='left'){sibling=node.previousSibling;regExp=/ $/;}else{sibling=node.nextSibling;regExp=/^ /;}
if(sibling){if(sibling.nodeType===3){isFlanked=regExp.test(sibling.nodeValue);}else if(sibling.nodeType===1&&!isBlock(sibling)){isFlanked=regExp.test(sibling.textContent);}}
return isFlanked}
var reduce=Array.prototype.reduce;var leadingNewLinesRegExp=/^\n*/;var trailingNewLinesRegExp=/\n*$/;function TurndownService(options){if(!(this instanceof TurndownService))return new TurndownService(options)
var defaults={rules:rules,headingStyle:'setext',hr:'* * *',bulletListMarker:'*',codeBlockStyle:'indented',fence:'```',emDelimiter:'_',strongDelimiter:'**',linkStyle:'inlined',linkReferenceStyle:'full',br:'  ',blankReplacement:function(content,node){return node.isBlock?'\n\n':''},keepReplacement:function(content,node){return node.isBlock?'\n\n'+node.outerHTML+'\n\n':node.outerHTML},defaultReplacement:function(content,node){return node.isBlock?'\n\n'+content+'\n\n':content}};this.options=extend({},defaults,options);this.rules=new Rules(this.options);}
TurndownService.prototype={turndown:function(input){if(!canConvert(input)){throw new TypeError(input+' is not a string, or an element/document/fragment node.')}
if(input==='')return''
var output=process.call(this,new RootNode(input));return postProcess.call(this,output)},use:function(plugin){if(Array.isArray(plugin)){for(var i=0;i<plugin.length;i++)this.use(plugin[i]);}else if(typeof plugin==='function'){plugin(this);}else{throw new TypeError('plugin must be a Function or an Array of Functions')}
return this},addRule:function(key,rule){this.rules.add(key,rule);return this},keep:function(filter){this.rules.keep(filter);return this},remove:function(filter){this.rules.remove(filter);return this},escape:function(string){return(string.replace(/\\(\S)/g,'\\\\$1').replace(/^(#{1,6} )/gm,'\\$1').replace(/^([-*_] *){3,}$/gm,function(match,character){return match.split(character).join('\\'+character)}).replace(/^(\W* {0,3})(\d+)\. /gm,'$1$2\\. ').replace(/^([^\\\w]*)[*+-] /gm,function(match){return match.replace(/([*+-])/g,'\\$1')}).replace(/^(\W* {0,3})> /gm,'$1\\> ').replace(/\*+(?![*\s\W]).+?\*+/g,function(match){return match.replace(/\*/g,'\\*')}).replace(/_+(?![_\s\W]).+?_+/g,function(match){return match.replace(/_/g,'\\_')}).replace(/`+(?![`\s\W]).+?`+/g,function(match){return match.replace(/`/g,'\\`')}).replace(/[\[\]]/g,'\\$&'))}};function process(parentNode){var self=this;return reduce.call(parentNode.childNodes,function(output,node){node=new Node(node);var replacement='';if(node.nodeType===3){replacement=node.isCode?node.nodeValue:self.escape(node.nodeValue);}else if(node.nodeType===1){replacement=replacementForNode.call(self,node);}
return join(output,replacement)},'')}
function postProcess(output){var self=this;this.rules.forEach(function(rule){if(typeof rule.append==='function'){output=join(output,rule.append(self.options));}});return output.replace(/^[\t\r\n]+/,'').replace(/[\t\r\n\s]+$/,'')}
function replacementForNode(node){var rule=this.rules.forNode(node);var content=process.call(this,node);var whitespace=node.flankingWhitespace;if(whitespace.leading||whitespace.trailing)content=content.trim();return(whitespace.leading+
rule.replacement(content,node,this.options)+
whitespace.trailing)}
function separatingNewlines(output,replacement){var newlines=[output.match(trailingNewLinesRegExp)[0],replacement.match(leadingNewLinesRegExp)[0]].sort();var maxNewlines=newlines[newlines.length-1];return maxNewlines.length<2?maxNewlines:'\n\n'}
function join(string1,string2){var separator=separatingNewlines(string1,string2);string1=string1.replace(trailingNewLinesRegExp,'');string2=string2.replace(leadingNewLinesRegExp,'');return string1+separator+string2}
function canConvert(input){return(input!=null&&(typeof input==='string'||(input.nodeType&&(input.nodeType===1||input.nodeType===9||input.nodeType===11))))}
return TurndownService;}());

window.ls=window.ls||{};window.ls.container=(function(){let stock={};let listeners={};let namespaces={};let set=function(name,object,singleton,watch=true){if(typeof name!=="string"){throw new Error("var name must be of type string");}
if(typeof singleton!=="boolean"){throw new Error('var singleton "'+
singleton+'" of service "'+
name+'" must be of type boolean');}
stock[name]={name:name,object:object,singleton:singleton,instance:null,watch:watch,};if(!watch){return this;}
let binds=listeners[name]||{};for(let key in binds){if(binds.hasOwnProperty(key)){document.dispatchEvent(new CustomEvent(key));}}
return this;};let get=function(name){let service=undefined!==stock[name]?stock[name]:null;if(null==service){return null;}
if(service.instance){return service.instance;}
let instance=typeof service.object==="function"?this.resolve(service.object):service.object;let skip=false;if(service.watch&&name!=="window"&&name!=="document"&&name!=="element"&&typeof instance==="object"&&instance!==null){let handler={name:service.name,watch:function(){},get:function(target,key){if(key==="__name"){return this.name;}
if(key==="__watch"){return this.watch;}
if(key==="__proxy"){return true;}
if(typeof target[key]==="object"&&target[key]!==null&&!target[key].__proxy){let handler=Object.assign({},this);handler.name=handler.name+"."+key;return new Proxy(target[key],handler);}else{return target[key];}},set:function(target,key,value,receiver){if(key==="__name"){return(this.name=value);}
if(key==="__watch"){return(this.watch=value);}
target[key]=value;let path=receiver.__name+"."+key;document.dispatchEvent(new CustomEvent(path+".changed"));if(skip){return true;}
skip=true;container.set("$prop",key,true);container.set("$value",value,true);container.resolve(this.watch);container.set("$key",null,true);container.set("$value",null,true);skip=false;return true;},};instance=new Proxy(instance,handler);}
if(service.singleton){service.instance=instance;}
return instance;};let resolve=function(target){if(!target){return()=>{};}
let self=this;const REGEX_COMMENTS=/((\/\/.*$)|(\/\*[\s\S]*?\*\/))/gm;const REGEX_FUNCTION_PARAMS=/(?:\s*(?:function\s*[^(]*)?\s*)((?:[^'"]|(?:(?:(['"])(?:(?:.*?[^\\]\2)|\2))))*?)\s*(?=(?:=>)|{)/m;const REGEX_PARAMETERS_VALUES=/\s*([\w\\$]+)\s*(?:=\s*((?:(?:(['"])(?:\3|(?:.*?[^\\]\3)))((\s*\+\s*)(?:(?:(['"])(?:\6|(?:.*?[^\\]\6)))|(?:[\w$]*)))*)|.*?))?\s*(?:,|$)/gm;function getParams(func){let functionAsString=func.toString();let params=[];let match;functionAsString=functionAsString.replace(REGEX_COMMENTS,"");functionAsString=functionAsString.match(REGEX_FUNCTION_PARAMS)[1];if(functionAsString.charAt(0)==="("){functionAsString=functionAsString.slice(1,-1);}
while((match=REGEX_PARAMETERS_VALUES.exec(functionAsString))){params.push(match[1]);}
return params;}
let args=getParams(target);return target.apply(target,args.map(function(value){return self.get(value.trim());}));};let path=function(path,value,type){type=type?type:"assign";path=container.scope(path).split(".");let name=path.shift();let object=container.get(name);let result=null;while(path.length>1){if(!object){return null;}
object=object[path.shift()];}
let shift=path.shift();if(value!==null&&value!==undefined&&object&&shift&&(object[shift]!==undefined||object[shift]!==null)){switch(type){case"append":if(!Array.isArray(object[shift])){object[shift]=[];}
object[shift].push(value);break;case"prepend":if(!Array.isArray(object[shift])){object[shift]=[];}
object[shift].unshift(value);break;case"splice":if(!Array.isArray(object[shift])){object[shift]=[];}
object[shift].splice(value,1);break;default:object[shift]=value;}
return true;}
if(!object){return null;}
if(!shift){result=object;}else{return object[shift];}
return result;};let bind=function(element,path,callback){let event=container.scope(path)+".changed";let service=event.split(".").slice(0,1).pop();let debug=element.getAttribute("data-debug")||false;listeners[service]=listeners[service]||{};listeners[service][event]=true;let printer=(function(x){return function(){if(!document.body.contains(element)){element=null;document.removeEventListener(event,printer,false);return false;}
let oldNamespaces=namespaces;namespaces=x;callback();namespaces=oldNamespaces;};})(Object.assign({},namespaces));document.addEventListener(event,printer);};let addNamespace=function(key,scope){namespaces[key]=scope;return this;};let removeNamespace=function(key){delete namespaces[key];return this;};let scope=function(path){for(let[key,value]of Object.entries(namespaces)){path=path.indexOf(".")>-1?path.replace(key+".",value+"."):path.replace(key,value);}
return path;};let container={set:set,get:get,resolve:resolve,path:path,bind:bind,scope:scope,addNamespace:addNamespace,removeNamespace:removeNamespace,stock:stock,listeners:listeners,namespaces:namespaces,};set("container",container,true,false);return container;})();window.ls.container.set("http",function(document){let globalParams=[],globalHeaders=[];let addParam=function(url,param,value){param=encodeURIComponent(param);let a=document.createElement("a");param+=value?"="+encodeURIComponent(value):"";a.href=url;a.search+=(a.search?"&":"")+param;return a.href;};let request=function(method,url,headers,payload,progress){let i;if(-1===["GET","POST","PUT","DELETE","TRACE","HEAD","OPTIONS","CONNECT","PATCH",].indexOf(method)){throw new Error("var method must contain a valid HTTP method name");}
if(typeof url!=="string"){throw new Error("var url must be of type string");}
if(typeof headers!=="object"){throw new Error("var headers must be of type object");}
if(typeof url!=="string"){throw new Error("var url must be of type string");}
for(i=0;i<globalParams.length;i++){url=addParam(url,globalParams[i].key,globalParams[i].value);}
return new Promise(function(resolve,reject){let xmlhttp=new XMLHttpRequest();xmlhttp.open(method,url,true);for(i=0;i<globalHeaders.length;i++){xmlhttp.setRequestHeader(globalHeaders[i].key,globalHeaders[i].value);}
for(let key in headers){if(headers.hasOwnProperty(key)){xmlhttp.setRequestHeader(key,headers[key]);}}
xmlhttp.onload=function(){if(4===xmlhttp.readyState&&200===xmlhttp.status){resolve(xmlhttp.response);}else{document.dispatchEvent(new CustomEvent("http-"+method.toLowerCase()+"-"+xmlhttp.status));reject(new Error(xmlhttp.statusText));}};if(progress){xmlhttp.addEventListener("progress",progress);xmlhttp.upload.addEventListener("progress",progress,false);}
xmlhttp.onerror=function(){reject(new Error("Network Error"));};xmlhttp.send(payload);});};return{get:function(url){return request("GET",url,{},"");},post:function(url,headers,payload){return request("POST",url,headers,payload);},put:function(url,headers,payload){return request("PUT",url,headers,payload);},patch:function(url,headers,payload){return request("PATCH",url,headers,payload);},delete:function(url){return request("DELETE",url,{},"");},addGlobalParam:function(key,value){globalParams.push({key:key,value:value});},addGlobalHeader:function(key,value){globalHeaders.push({key:key,value:value});},};},true,false);window.ls.container.set("cookie",function(document){function get(name){let value="; "+document.cookie,parts=value.split("; "+name+"=");if(parts.length===2){return parts.pop().split(";").shift();}
return null;}
function set(name,value,days){let date=new Date();date.setTime(date.getTime()+days*24*60*60*1000);let expires=0<days?"expires="+date.toUTCString():"expires=0";document.cookie=name+"="+value+";"+expires+";path=/";return this;}
return{get:get,set:set};},true,false);window.ls.container.set("view",function(http,container){let stock={};let execute=function(view,node,container){container.set("element",node,true,false);container.resolve(view.controller);if(true!==view.repeat){node.removeAttribute(view.selector);}};let parse=function(node,skip,callback){if(node.tagName==="SCRIPT"){return;}
if(node.attributes&&skip!==true){let attrs=[];let attrsLen=node.attributes.length;for(let x=0;x<attrsLen;x++){attrs.push(node.attributes[x].nodeName);}
if(1!==node.nodeType){return;}
if(attrs&&attrsLen){for(let x=0;x<attrsLen;x++){if(node.$lsSkip===true){break;}
let pointer=!/Edge/.test(navigator.userAgent)?x:attrsLen-1-x;let length=attrsLen;let attr=attrs[pointer];if(!stock[attr]){continue;}
let comp=stock[attr];if(typeof comp.template==="function"){comp.template=container.resolve(comp.template);}
if(!comp.template){(function(comp,node,container){execute(comp,node,container);})(comp,node,container);if(length!==attrsLen){x--;}
if(callback){callback();}
continue;}
node.classList.remove("load-end");node.classList.add("load-start");node.$lsSkip=true;http.get(comp.template).then((function(node,comp){return function(data){node.$lsSkip=false;node.innerHTML=data;node.classList.remove("load-start");node.classList.add("load-end");(function(comp,node,container){execute(comp,node,container);})(comp,node,container);parse(node,true);if(callback){callback();}};})(node,comp),function(error){throw new Error("Failed to load comp template: "+error.message);});}}}
if(true===node.$lsSkip){return;}
let list=node?node.childNodes:[];if(node.$lsSkip===true){list=[];}
for(let i=0;i<list.length;i++){let child=list[i];parse(child);}};return{stock:stock,add:function(object){if(typeof object!=="object"){throw new Error("object must be of type object");}
let defaults={selector:"",controller:function(){},template:"",repeat:false,protected:false,};for(let prop in defaults){if(!defaults.hasOwnProperty(prop)){continue;}
if(prop in object){continue;}
object[prop]=defaults[prop];}
if(!object.selector){throw new Error("View component is missing a selector attribute");}
stock[object.selector]=object;return this;},render:function(element,callback){parse(element,false,callback);element.dispatchEvent(new window.Event("rendered",{bubbles:false}));},};},true,false);window.ls.container.set("router",function(window){let getJsonFromUrl=function(URL){let query;if(URL){let pos=location.search.indexOf("?");if(pos===-1)return[];query=location.search.substr(pos+1);}else{query=location.search.substr(1);}
let result={};query.split("&").forEach(function(part){if(!part){return;}
part=part.split("+").join(" ");let eq=part.indexOf("=");let key=eq>-1?part.substr(0,eq):part;let val=eq>-1?decodeURIComponent(part.substr(eq+1)):"";let from=key.indexOf("[");if(from===-1){result[decodeURIComponent(key)]=val;}else{let to=key.indexOf("]");let index=decodeURIComponent(key.substring(from+1,to));key=decodeURIComponent(key.substring(0,from));if(!result[key]){result[key]=[];}
if(!index){result[key].push(val);}else{result[key][index]=val;}}});return result;};let states=[];let params=getJsonFromUrl(window.location.search);let hash=window.location.hash;let current=null;let previous=null;let getPrevious=()=>previous;let getCurrent=()=>current;let setPrevious=(value)=>{previous=value;return this;};let setCurrent=(value)=>{current=value;return this;};let setParam=function(key,value){params[key]=value;return this;};let getParam=function(key,def){if(key in params){return params[key];}
return def;};let getParams=function(){return params;};let getURL=function(){return window.location.href;};let add=function(path,view){if(typeof path!=="string"){throw new Error("path must be of type string");}
if(typeof view!=="object"){throw new Error("view must be of type object");}
states[states.length++]={path:path,view:view};return this;};let match=function(location){let url=location.pathname;states.sort(function(a,b){return b.path.length-a.path.length;});states.sort(function(a,b){let n=b.path.split("/").length-a.path.split("/").length;if(n!==0){return n;}
return b.path.length-a.path.length;});for(let i=0;i<states.length;i++){let value=states[i];value.path=value.path.substring(0,1)!=="/"?location.pathname+value.path:value.path;let match=new RegExp("^"+value.path.replace(/:[^\s/]+/g,"([\\w-]+)")+"$");let found=url.match(match);if(found){previous=current;current=value;return value;}}
return null;};let change=function(URL,replace){if(!replace){window.history.pushState({},"",URL);}else{window.history.replaceState({},"",URL);}
window.dispatchEvent(new PopStateEvent("popstate",{}));return this;};let reload=function(){return change(window.location.href);};return{setParam:setParam,getParam:getParam,getParams:getParams,getURL:getURL,add:add,change:change,reload:reload,match:match,getCurrent:getCurrent,setCurrent:setCurrent,getPrevious:getPrevious,setPrevious:setPrevious,params:params,hash:hash,reset:function(){this.params=getJsonFromUrl(window.location.search);this.hash=window.location.hash;},};},true,true);window.ls.container.set("expression",function(container,filter){let paths=[];return{regex:/(\{{.*?\}})/gi,parse:function(string,def,cast=false){def=def||"";paths=[];return string.replace(this.regex,(match)=>{let reference=match.substring(2,match.length-2).replace("['",".").replace("']","").trim();reference=reference.split("|");let path=container.scope(reference[0]||"");let result=container.path(path);path=container.scope(path);if(!paths.includes(path)){paths.push(path);}
if(reference.length>=2){for(let i=1;i<reference.length;i++){result=filter.apply(reference[i],result);}}
if(null===result||undefined===result){result=def;}else if(typeof result==="object"){result=JSON.stringify(result,null,4);}else if((typeof result==="object"||typeof result==="string")&&cast){result="'"+result+"'";}
return result;}).replace(/\\{/g,"{").replace(/\\}/g,"}");},getPaths:()=>paths,};},true,false);window.ls.container.set("filter",function(container){let filters={};let add=function(name,callback){filters[name]=callback;return this;};let apply=function(name,value){container.set("$value",value,true,false);return container.resolve(filters[name]);};add("uppercase",($value)=>{if(typeof $value!=="string"){return $value;}
return $value.toUpperCase();});add("lowercase",($value)=>{if(typeof $value!=="string"){return $value;}
return $value.toLowerCase();});return{add:add,apply:apply};},true,false);window.ls.container.get("filter").add("escape",($value)=>{if(typeof $value!=="string"){return $value;}
return $value.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/\"/g,"&quot;").replace(/\'/g,"&#39;").replace(/\//g,"&#x2F;");});window.ls=window.ls||{};window.ls.container.set("window",window,true,false).set("document",window.document,true,false).set("element",window.document,true,false);window.ls.run=function(window){try{this.view.render(window.document);}catch(error){let handler=window.ls.container.resolve(this.error);handler(error);}};window.ls.error=()=>{return(error)=>{console.error("ls-error",error.message,error.stack,error.toString());};};window.ls.router=window.ls.container.get("router");window.ls.view=window.ls.container.get("view");window.ls.filter=window.ls.container.get("filter");window.ls.container.get("view").add({selector:"data-ls-router",controller:function(element,window,document,view,router){let firstFromServer=element.getAttribute("data-first-from-server")==="true";let scope={selector:"data-ls-scope",template:false,repeat:true,controller:function(){},};let init=function(route){let count=parseInt(element.getAttribute("data-ls-scope-count")||0);element.setAttribute("data-ls-scope-count",count+1);window.scrollTo(0,0);if(window.document.body.scrollTo){window.document.body.scrollTo(0,0);}
router.reset();if(null===route){return;}
scope.template=undefined!==route.view.template?route.view.template:null;scope.controller=undefined!==route.view.controller?route.view.controller:function(){};document.dispatchEvent(new CustomEvent("state-change"));if(firstFromServer&&null===router.getPrevious()){scope.template="";document.dispatchEvent(new CustomEvent("state-changed"));}else if(count===1){view.render(element,function(){document.dispatchEvent(new CustomEvent("state-changed"));});}else if(null!==router.getPrevious()){view.render(element,function(){document.dispatchEvent(new CustomEvent("state-changed"));});}};let findParent=function(tagName,el){if((el.nodeName||el.tagName).toLowerCase()===tagName.toLowerCase()){return el;}
while((el=el.parentNode)){if((el.nodeName||el.tagName).toLowerCase()===tagName.toLowerCase()){return el;}}
return null;};element.removeAttribute("data-ls-router");element.setAttribute("data-ls-scope","");element.setAttribute("data-ls-scope-count",1);view.add(scope);document.addEventListener("click",function(event){let target=findParent("a",event.target);if(!target){return false;}
if(!target.href){return false;}
if(event.metaKey){return false;}
if(target.hasAttribute("target")&&"_blank"===target.getAttribute("target")){return false;}
if(target.hostname!==window.location.hostname){return false;}
let route=router.match(target);if(null===route){return false;}
event.preventDefault();if(window.location===target.href){return false;}
route.view.state=undefined===route.view.state?true:route.view.state;if(true===route.view.state){if(router.getPrevious()&&router.getPrevious().view&&router.getPrevious().view.scope!==route.view.scope){window.location.href=target.href;return false;}
window.history.pushState({},"Unknown",target.href);}
init(route);return true;});window.addEventListener("popstate",function(){init(router.match(window.location));});window.addEventListener("hashchange",function(){init(router.match(window.location));});init(router.match(window.location));},});window.ls.container.get("view").add({selector:"data-ls-attrs",controller:function(element,expression,container){let attrs=element.getAttribute("data-ls-attrs").trim().split(",");let paths=[];let debug=element.getAttribute("data-debug")||false;let check=()=>{container.set("element",element,true,false);if(debug){console.info("debug-ls-attrs attributes:",attrs);}
for(let i=0;i<attrs.length;i++){let attr=attrs[i];let key=expression.parse(attr.substring(0,attr.indexOf("="))||attr);paths=paths.concat(expression.getPaths());let value="";if(attr.indexOf("=")>-1){value=expression.parse(attr.substring(attr.indexOf("=")+1))||"";paths=paths.concat(expression.getPaths());}
if(!key){return null;}
element.setAttribute(key,value);}};check();for(let i=0;i<paths.length;i++){let path=paths[i].split(".");while(path.length){container.bind(element,path.join("."),check);path.pop();}}},});window.ls.container.get("view").add({selector:"data-ls-bind",controller:function(element,expression,container){let debug=element.getAttribute("data-debug")||false;let echo=function(value,bind=true){if(element.tagName==="INPUT"||element.tagName==="SELECT"||element.tagName==="BUTTON"||element.tagName==="TEXTAREA"){let type=element.getAttribute("type");if("radio"===type){if(value.toString()===element.value){element.setAttribute("checked","checked");}else{element.removeAttribute("checked");}
if(bind){element.addEventListener("change",()=>{for(let i=0;i<paths.length;i++){if(element.checked){value=element.value;}
container.path(paths[i],value);}});}
return;}
if("checkbox"===type){if(typeof value==="boolean"||value==="true"||value==="false"){if(value===true||value==="true"){element.setAttribute("checked","checked");element.checked=true;}else{element.removeAttribute("checked");element.checked=false;}}else{try{value=JSON.parse(value);element.checked=Array.isArray(value)&&value.indexOf(element.value)>-1;value=element.value;}catch{return null;}}
if(bind){element.addEventListener("change",()=>{for(let i=0;i<paths.length;i++){let value=container.path(paths[i]);let index=value.indexOf(element.value);if(element.checked&&index<0){value.push(element.value);}
if(!element.checked&&index>-1){value.splice(index,1);}
container.path(paths[i],value);}});}
return;}
if(element.value!==value){element.value=value;element.dispatchEvent(new Event("change"));}
if(bind){element.addEventListener("input",sync);element.addEventListener("change",sync);}}else{if(element.textContent!=value){element.textContent=value;}}};let sync=(()=>{return()=>{if(debug){console.info("debug-ls-bind","sync-path",paths);console.info("debug-ls-bind","sync-syntax",syntax);console.info("debug-ls-bind","sync-syntax-parsed",parsedSyntax);console.info("debug-ls-bind","sync-value",element.value);}
for(let i=0;i<paths.length;i++){if("{{"+paths[i]+"}}"!==parsedSyntax){if(debug){console.info("debug-ls-bind","sync-skipped-path",paths[i]);console.info("debug-ls-bind","sync-skipped-syntax",syntax);console.info("debug-ls-bind","sync-skipped-syntax-parsed",parsedSyntax);}
continue;}
if(debug){console.info("debug-ls-bind","sync-loop-path",paths[i]);console.info("debug-ls-bind","sync-loop-syntax",parsedSyntax);}
container.path(paths[i],element.value);}};})();let syntax=element.getAttribute("data-ls-bind");let parsedSyntax=container.scope(syntax);let unsync=!!element.getAttribute("data-unsync")||false;let result=expression.parse(syntax);let paths=expression.getPaths();echo(result,!unsync);element.addEventListener("looped",function(){echo(expression.parse(parsedSyntax),false);});for(let i=0;i<paths.length;i++){let path=paths[i].split(".");if(debug){console.info("debug-ls-bind","bind-path",path);console.info("debug-ls-bind","bind-syntax",syntax);}
while(path.length){container.bind(element,path.join("."),()=>{echo(expression.parse(parsedSyntax),false);});path.pop();}}},});window.ls.container.get("view").add({selector:"data-ls-if",controller:function(element,expression,container,view){let result="";let syntax=element.getAttribute("data-ls-if")||"";let debug=element.getAttribute("data-debug")||false;let paths=[];let check=()=>{if(debug){console.info("debug-ls-if",expression.parse(syntax.replace(/(\r\n|\n|\r)/gm," "),"undefined",true));}
try{result=eval(expression.parse(syntax.replace(/(\r\n|\n|\r)/gm," "),"undefined",true));}catch(error){throw new Error('Failed to evaluate expression "'+
syntax+' (resulted with: "'+
result+'")": '+
error);}
if(debug){console.info("debug-ls-if result:",result);}
paths=expression.getPaths();let prv=element.$lsSkip;element.$lsSkip=!result;if(!result){element.style.visibility="hidden";element.style.display="none";}else{element.style.removeProperty("display");element.style.removeProperty("visibility");}
if(prv===true&&element.$lsSkip===false){view.render(element);}};check();for(let i=0;i<paths.length;i++){let path=paths[i].split(".");while(path.length){container.bind(element,path.join("."),check);path.pop();}}},});window.ls.container.get("view").add({selector:"data-ls-loop",template:false,nested:false,controller:function(element,view,container,window,expression){let expr=expression.parse(element.getAttribute("data-ls-loop"));let as=element.getAttribute("data-ls-as");let key=element.getAttribute("data-ls-key")||"$index";let limit=parseInt(expression.parse(element.getAttribute("data-limit")||"")||-1);let debug=element.getAttribute("data-debug")||false;let echo=function(){let array=container.path(expr);let counter=0;array=!array?[]:array;let watch=!!(array&&array.__proxy);while(element.hasChildNodes()){element.removeChild(element.lastChild);element.lastChild=null;}
if(array instanceof Array&&typeof array!=="object"){throw new Error("Reference value must be array or object. "+typeof array+" given");}
let children=[];element.$lsSkip=true;element.style.visibility=0===array.length&&element.style.visibility==""?"hidden":"visible";for(let prop in array){if(counter==limit){break;}
counter++;if(!array.hasOwnProperty(prop)){continue;}
children[prop]=template.cloneNode(true);element.appendChild(children[prop]);((index)=>{let context=expr+"."+index;container.addNamespace(as,context);if(debug){console.info("debug-ls-loop","index",index);console.info("debug-ls-loop","context",context);console.info("debug-ls-loop","context-path",container.path(context).name);console.info("debug-ls-loop","namespaces",container.namespaces);}
container.set(as,container.path(context),true,watch);container.set(key,index,true,false);view.render(children[prop]);container.removeNamespace(as);})(prop);}
element.dispatchEvent(new Event("looped"));};let template=element.children.length===1?element.children[0]:window.document.createElement("li");echo();container.bind(element,expr+".length",echo);let path=(expr+".length").split(".");while(path.length){container.bind(element,path.join("."),echo);path.pop();}},});window.ls.container.get("view").add({selector:"data-ls-template",template:false,controller:function(element,view,http,expression,document,container){let template=element.getAttribute("data-ls-template")||"";let type=element.getAttribute("data-type")||"url";let debug=element.getAttribute("data-debug")||false;let paths=[];let check=function(init=false){let source=expression.parse(template);paths=expression.getPaths();element.innerHTML="";if("script"===type){let inlineTemplate=document.getElementById(source);if(inlineTemplate&&inlineTemplate.innerHTML){element.innerHTML=inlineTemplate.innerHTML;element.dispatchEvent(new CustomEvent("template-loaded",{bubbles:true,cancelable:false,}));}else{if(debug){console.error('Missing template "'+source+'"');}}
if(!init){view.render(element);}
return;}
http.get(source).then((function(element){return function(data){element.innerHTML=data;view.render(element);element.dispatchEvent(new CustomEvent("template-loaded",{bubbles:true,cancelable:false,}));};})(element),function(){throw new Error("Failed loading template");});};check(true);for(let i=0;i<paths.length;i++){let path=paths[i].split(".");while(path.length){container.bind(element,path.join("."),check);path.pop();}}},});window.ls.error=function(){return function(error){window.console.error(error);if(window.location.pathname!=='/console'){window.location='/console';}};};window.addEventListener("error",function(event){console.error("ERROR-EVENT:",event.error.message,event.error.stack);});document.addEventListener("account.deleteSession",function(){window.location="/auth/signin";});document.addEventListener("account.create",function(){let container=window.ls.container;let form=container.get('serviceForm');let sdk=container.get('console');let promise=sdk.account.createSession(form.email,form.password);container.set("serviceForm",{},true,true);promise.then(function(){var subscribe=document.getElementById('newsletter').checked;if(subscribe){let alerts=container.get('alerts');let loaderId=alerts.add({text:'Loading...',class:""},0);fetch('https://appwrite.io/v1/newsletter/subscribe',{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({name:form.name,email:form.email,}),}).finally(function(){alerts.remove(loaderId);window.location='/console';});}else{window.location='/console';}},function(error){window.location='/auth/signup?failure=1';});});window.addEventListener("load",async()=>{const bars=12;const realtime=window.ls.container.get('realtime');const sleep=ms=>new Promise(resolve=>setTimeout(resolve,ms));let current={};window.ls.container.get('console').subscribe('project',event=>{for(let project in event.payload){current[project]=event.payload[project]??0;}});while(true){let newHistory={};let createdHistory=false;for(const project in current){let history=realtime?.history??{};if(!(project in history)){history[project]=new Array(bars).fill({percentage:0,value:0});}
history=history[project];history.push({percentage:0,value:current[project]});if(history.length>=bars){history.shift();}
const highest=history.reduce((prev,curr)=>{return(curr.value>prev)?curr.value:prev;},0);history=history.map(({percentage,value})=>{createdHistory=true;percentage=value===0?0:((Math.round((value/highest)*10)/10)*100);if(percentage>100)percentage=100;else if(percentage==0&&value!=0)percentage=5;return{percentage:percentage,value:value};})
newHistory[project]=history;}
let currentSnapshot={...current};for(let index=.1;index<=1;index+=.05){let currentTransition={...currentSnapshot};for(const project in current){if(project in newHistory){let base=newHistory[project][bars-2].value;let cur=currentSnapshot[project];let offset=(cur-base)*index;currentTransition[project]=base+Math.floor(offset);}}
realtime.setCurrent(currentTransition);await sleep(250);}
realtime.setHistory(newHistory);}});(function(window){"use strict";window.ls.container.set('alerts',function(window){return{list:[],ids:0,counter:0,max:5,add:function(message,time){var scope=this;message.id=scope.ids++;message.remove=function(){scope.remove(message.id);};scope.counter++;scope.list.unshift(message);if(scope.counter>scope.max){scope.list.pop();scope.counter--;}
if(time>0){window.setTimeout(function(message){return function(){scope.remove(message.id)}}(message),time);}
return message.id;},remove:function(id){let scope=this;for(let index=0;index<scope.list.length;index++){let obj=scope.list[index];if(obj.id===parseInt(id)){scope.counter--;if(typeof obj.callback==="function"){obj.callback();}
scope.list.splice(index,1);};}}};},true,true);})(window);(function(window){"use strict";window.ls.container.set('appwrite',function(window,env){let config={endpoint:'https://appwrite.io/v1',};let http=function(document,env){let globalParams=[],globalHeaders=[];let addParam=function(url,param,value){let a=document.createElement('a'),regex=/(?:\?|&amp;|&)+([^=]+)(?:=([^&]*))*/g;let match,str=[];a.href=url;param=encodeURIComponent(param);while(match=regex.exec(a.search))if(param!==match[1])str.push(match[1]+(match[2]?"="+match[2]:""));str.push(param+(value?"="+encodeURIComponent(value):""));a.search=str.join("&");return a.href;};let buildQuery=function(params){let str=[];for(let p in params){if(params.hasOwnProperty(p)){str.push(encodeURIComponent(p)+"="+encodeURIComponent(params[p]));}}
return str.join("&");};let addGlobalHeader=function(key,value){globalHeaders[key]={key:key.toLowerCase(),value:value.toLowerCase()};};let addGlobalParam=function(key,value){globalParams.push({key:key,value:value});};addGlobalHeader('content-type','');let call=function(method,path,headers={},params={},progress=null){let i;path=config.endpoint+path;if(-1===['GET','POST','PUT','DELETE','TRACE','HEAD','OPTIONS','CONNECT','PATCH'].indexOf(method)){throw new Error('var method must contain a valid HTTP method name');}
if(typeof path!=='string'){throw new Error('var path must be of type string');}
if(typeof headers!=='object'){throw new Error('var headers must be of type object');}
for(i=0;i<globalParams.length;i++){path=addParam(path,globalParams[i].key,globalParams[i].value);}
for(let key in globalHeaders){if(globalHeaders.hasOwnProperty(key)){if(!headers[globalHeaders[key].key]){headers[globalHeaders[key].key]=globalHeaders[key].value;}}}
if(method==='GET'){for(let param in params){if(param.hasOwnProperty(key)){path=addParam(path,key,params[key]);}}}
switch(headers['content-type']){case'application/json':params=JSON.stringify(params);break;case'multipart/form-data':let formData=new FormData();for(let param in params){if(param.hasOwnProperty(key)){formData.append(key,param[key]);}}
params=formData;break;}
return new Promise(function(resolve,reject){let request=new XMLHttpRequest(),key;request.withCredentials=true;request.open(method,path,true);for(key in headers){if(headers.hasOwnProperty(key)){request.setRequestHeader(key,headers[key]);}}
request.onload=function(){if(4===request.readyState&&399>=request.status){let data=request.response;let contentType=this.getResponseHeader('content-type');contentType=contentType.substring(0,contentType.indexOf(';'));switch(contentType){case'application/json':data=JSON.parse(data);break;}
resolve(data);}else{reject(new Error(request.statusText));}};if(progress){request.addEventListener('progress',progress);request.upload.addEventListener('progress',progress,false);}
request.onerror=function(){reject(new Error("Network Error"));};request.send(params);})};return{'get':function(path,headers={},params={}){return call('GET',path+((params.length>0)?'?'+buildQuery(params):''),headers,{});},'post':function(path,headers={},params={},progress=null){return call('POST',path,headers,params,progress);},'put':function(path,headers={},params={},progress=null){return call('PUT',headers,params,progress);},'patch':function(path,headers={},params={},progress=null){return call('PATCH',path,headers,params,progress);},'delete':function(path,headers={},params={},progress=null){return call('DELETE',path,headers,params,progress);},'addGlobalParam':addGlobalParam,'addGlobalHeader':addGlobalHeader}}(window.document);let analytics={create:function(id,source,activity,url){return http.post('/analytics',{'content-type':'application/json'},{id:id,source:source,activity:activity,url:url,version:env.VERSION,setup:env.SETUP});},};return{analytics:analytics,};},true);})(window);(function(window){"use strict";window.ls.container.set('console',function(window){var sdk=new window.Appwrite();var endpoint=window.location.origin+'/v1';sdk.setEndpoint(endpoint).setProject('console').setLocale(APP_ENV.LOCALE);return sdk;},true);})(window);(function(window){"use strict";window.ls.container.set('date',function(){function format(format,timestamp){var jsdate,f
var txtWords=['Sun','Mon','Tues','Wednes','Thurs','Fri','Satur','January','February','March','April','May','June','July','August','September','October','November','December']
var formatChr=/\\?(.?)/gi
var formatChrCb=function(t,s){return f[t]?f[t]():s}
var _pad=function(n,c){n=String(n)
while(n.length<c){n='0'+n}
return n}
f={d:function(){return _pad(f.j(),2)},D:function(){return f.l().slice(0,3)},j:function(){return jsdate.getDate()},l:function(){return txtWords[f.w()]+'day'},N:function(){return f.w()||7},S:function(){var j=f.j()
var i=j%10
if(i<=3&&parseInt((j%100)/10,10)===1){i=0}
return['st','nd','rd'][i-1]||'th'},w:function(){return jsdate.getDay()},z:function(){var a=new Date(f.Y(),f.n()-1,f.j())
var b=new Date(f.Y(),0,1)
return Math.round((a-b)/864e5)},W:function(){var a=new Date(f.Y(),f.n()-1,f.j()-f.N()+3)
var b=new Date(a.getFullYear(),0,4)
return _pad(1+Math.round((a-b)/864e5/7),2)},F:function(){return txtWords[6+f.n()]},m:function(){return _pad(f.n(),2)},M:function(){return f.F().slice(0,3)},n:function(){return jsdate.getMonth()+1},t:function(){return(new Date(f.Y(),f.n(),0)).getDate()},L:function(){var j=f.Y()
return j%4===0&j%100!==0|j%400===0},o:function(){var n=f.n()
var W=f.W()
var Y=f.Y()
return Y+(n===12&&W<9?1:n===1&&W>9?-1:0)},Y:function(){return jsdate.getFullYear()},y:function(){return f.Y().toString().slice(-2)},a:function(){return jsdate.getHours()>11?'pm':'am'},A:function(){return f.a().toUpperCase()},B:function(){var H=jsdate.getUTCHours()*36e2
var i=jsdate.getUTCMinutes()*60
var s=jsdate.getUTCSeconds()
return _pad(Math.floor((H+i+s+36e2)/86.4)%1e3,3)},g:function(){return f.G()%12||12},G:function(){return jsdate.getHours()},h:function(){return _pad(f.g(),2)},H:function(){return _pad(f.G(),2)},i:function(){return _pad(jsdate.getMinutes(),2)},s:function(){return _pad(jsdate.getSeconds(),2)},u:function(){return _pad(jsdate.getMilliseconds()*1000,6)},e:function(){var msg='Not supported (see source code of date() for timezone on how to add support)'
throw new Error(msg)},I:function(){var a=new Date(f.Y(),0)
var c=Date.UTC(f.Y(),0)
var b=new Date(f.Y(),6)
var d=Date.UTC(f.Y(),6)
return((a-c)!==(b-d))?1:0},O:function(){var tzo=jsdate.getTimezoneOffset()
var a=Math.abs(tzo)
return(tzo>0?'-':'+')+_pad(Math.floor(a/60)*100+a%60,4)},P:function(){var O=f.O()
return(O.substr(0,3)+':'+O.substr(3,2))},T:function(){return'UTC'},Z:function(){return-jsdate.getTimezoneOffset()*60},c:function(){return'Y-m-d\\TH:i:sP'.replace(formatChr,formatChrCb)},r:function(){return'D, d M Y H:i:s O'.replace(formatChr,formatChrCb)},U:function(){return jsdate/1000|0}}
var _date=function(format,timestamp){jsdate=(timestamp===undefined?new Date():(timestamp instanceof Date)?new Date(timestamp):new Date(timestamp*1000))
return format.replace(formatChr,formatChrCb)}
return _date(format,timestamp)}
function strtotime(text,now){var parsed
var match
var today
var year
var date
var days
var ranges
var len
var times
var regex
var i
var fail=false
if(!text){return fail}
text=text.replace(/^\s+|\s+$/g,'').replace(/\s{2,}/g,' ').replace(/[\t\r\n]/g,'').toLowerCase()
var pattern=new RegExp(['^(\\d{1,4})','([\\-\\.\\/:])','(\\d{1,2})','([\\-\\.\\/:])','(\\d{1,4})','(?:\\s(\\d{1,2}):(\\d{2})?:?(\\d{2})?)?','(?:\\s([A-Z]+)?)?$'].join(''))
match=text.match(pattern)
if(match&&match[2]===match[4]){if(match[1]>1901){switch(match[2]){case'-':if(match[3]>12||match[5]>31){return fail}
return new Date(match[1],parseInt(match[3],10)-1,match[5],match[6]||0,match[7]||0,match[8]||0,match[9]||0)/1000
case'.':return fail
case'/':if(match[3]>12||match[5]>31){return fail}
return new Date(match[1],parseInt(match[3],10)-1,match[5],match[6]||0,match[7]||0,match[8]||0,match[9]||0)/1000}}else if(match[5]>1901){switch(match[2]){case'-':if(match[3]>12||match[1]>31){return fail}
return new Date(match[5],parseInt(match[3],10)-1,match[1],match[6]||0,match[7]||0,match[8]||0,match[9]||0)/1000
case'.':if(match[3]>12||match[1]>31){return fail}
return new Date(match[5],parseInt(match[3],10)-1,match[1],match[6]||0,match[7]||0,match[8]||0,match[9]||0)/1000
case'/':if(match[1]>12||match[3]>31){return fail}
return new Date(match[5],parseInt(match[1],10)-1,match[3],match[6]||0,match[7]||0,match[8]||0,match[9]||0)/1000}}else{switch(match[2]){case'-':if(match[3]>12||match[5]>31||(match[1]<70&&match[1]>38)){return fail}
year=match[1]>=0&&match[1]<=38?+match[1]+2000:match[1]
return new Date(year,parseInt(match[3],10)-1,match[5],match[6]||0,match[7]||0,match[8]||0,match[9]||0)/1000
case'.':if(match[5]>=70){if(match[3]>12||match[1]>31){return fail}
return new Date(match[5],parseInt(match[3],10)-1,match[1],match[6]||0,match[7]||0,match[8]||0,match[9]||0)/1000}
if(match[5]<60&&!match[6]){if(match[1]>23||match[3]>59){return fail}
today=new Date()
return new Date(today.getFullYear(),today.getMonth(),today.getDate(),match[1]||0,match[3]||0,match[5]||0,match[9]||0)/1000}
return fail
case'/':if(match[1]>12||match[3]>31||(match[5]<70&&match[5]>38)){return fail}
year=match[5]>=0&&match[5]<=38?+match[5]+2000:match[5]
return new Date(year,parseInt(match[1],10)-1,match[3],match[6]||0,match[7]||0,match[8]||0,match[9]||0)/1000
case':':if(match[1]>23||match[3]>59||match[5]>59){return fail}
today=new Date()
return new Date(today.getFullYear(),today.getMonth(),today.getDate(),match[1]||0,match[3]||0,match[5]||0)/1000}}}
if(text==='now'){return now===null||isNaN(now)?new Date().getTime()/1000|0:now|0}
if(!isNaN(parsed=Date.parse(text))){return parsed/1000|0}
pattern=new RegExp(['^([0-9]{4}-[0-9]{2}-[0-9]{2})','[ t]','([0-9]{2}:[0-9]{2}:[0-9]{2}(\\.[0-9]+)?)','([\\+-][0-9]{2}(:[0-9]{2})?|z)'].join(''))
match=text.match(pattern)
if(match){if(match[4]==='z'){match[4]='Z'}else if(match[4].match(/^([+-][0-9]{2})$/)){match[4]=match[4]+':00'}
if(!isNaN(parsed=Date.parse(match[1]+'T'+match[2]+match[4]))){return parsed/1000|0}}
date=now?new Date(now*1000):new Date()
days={'sun':0,'mon':1,'tue':2,'wed':3,'thu':4,'fri':5,'sat':6}
ranges={'yea':'FullYear','mon':'Month','day':'Date','hou':'Hours','min':'Minutes','sec':'Seconds'}
function lastNext(type,range,modifier){var diff
var day=days[range]
if(typeof day!=='undefined'){diff=day-date.getDay()
if(diff===0){diff=7*modifier}else if(diff>0&&type==='last'){diff-=7}else if(diff<0&&type==='next'){diff+=7}
date.setDate(date.getDate()+diff)}}
function process(val){var splt=val.split(' ')
var type=splt[0]
var range=splt[1].substring(0,3)
var typeIsNumber=/\d+/.test(type)
var ago=splt[2]==='ago'
var num=(type==='last'?-1:1)*(ago?-1:1)
if(typeIsNumber){num*=parseInt(type,10)}
if(ranges.hasOwnProperty(range)&&!splt[1].match(/^mon(day|\.)?$/i)){return date['set'+ranges[range]](date['get'+ranges[range]]()+num)}
if(range==='wee'){return date.setDate(date.getDate()+(num*7))}
if(type==='next'||type==='last'){lastNext(type,range,num)}else if(!typeIsNumber){return false}
return true}
times='(years?|months?|weeks?|days?|hours?|minutes?|min|seconds?|sec'+'|sunday|sun\\.?|monday|mon\\.?|tuesday|tue\\.?|wednesday|wed\\.?'+'|thursday|thu\\.?|friday|fri\\.?|saturday|sat\\.?)'
regex='([+-]?\\d+\\s'+times+'|'+'(last|next)\\s'+times+')(\\sago)?'
match=text.match(new RegExp(regex,'gi'))
if(!match){return fail}
for(i=0,len=match.length;i<len;i++){if(!process(match[i])){return fail}}
return(date.getTime()/1000)}
return{format:format,strtotime:strtotime}}(),true);})(window);(function(window){"use strict";window.ls.container.set('env',function(){return APP_ENV;},true);})(window);(function(window){"use strict";window.ls.container.set('form',function(){function cast(value,to){if(value&&Array.isArray(value)&&to!=='array'){value=value.map(element=>cast(element,to));return value;}
switch(to){case'int':case'integer':value=parseInt(value);break;case'numeric':value=Number(value);break;case'string':value=value.toString();break;case'json':value=(value)?JSON.parse(value):[];break;case'array':value=(value&&value.constructor&&value.constructor===Array)?value:[value];break;case'array-empty':value=[];break;case'bool':case'boolean':value=(value==='false')?false:value;value=!!value;break;}
return value;}
function toJson(element,json){json=json||{};let name=element.getAttribute('name');let type=element.getAttribute('type');let castTo=element.getAttribute('data-cast-to');let ref=json;if(name&&'FORM'!==element.tagName){if(name.startsWith('[')){let splitName=name.split('.');if(splitName.length>1&&splitName[0].endsWith(']')){name=splitName[splitName.length-1];}}
if('FIELDSET'===element.tagName){if(castTo==='object'){if(json[name]===undefined){json[name]={};}
ref=json[name];}
else{if(!Array.isArray(json[name])){json[name]=[];}
json[name].push({});ref=json[name][json[name].length-1];}}
else if(undefined!==element.value){if('SELECT'===element.tagName&&element.children>0){json[name]=element.children[element.selectedIndex].value;}
else if('radio'===type){if(element.checked){json[name]=element.value;}}
else if('checkbox'===type){if(!Array.isArray(json[name])){json[name]=[];}
if(element.checked){json[name].push(element.value);}}
else if('file'===type){json[name]=element.files[0];}
else if(undefined!==element.value){if((json[name]!==undefined)&&(!Array.isArray(json[name]))){json[name]=[json[name]];}
if(Array.isArray(json[name])){json[name].push(element.value);}
else{json[name]=element.value;}}
json[name]=cast(json[name],castTo);}}
for(let i=0;i<element.children.length;i++){if(Array.isArray(ref)){ref.push({});toJson(element.children[i],ref[ref.length]);}
else{toJson(element.children[i],ref);}}
return json;}
return{'toJson':toJson}},true,false);})(window);(function(window){"use strict";window.ls.container.set('markdown',function(window){var md=window.markdownit();function renderEm(tokens,idx,opts,_,slf){var token=tokens[idx];if(token.markup==='__'){token.tag='u';}
return slf.renderToken(tokens,idx,opts);}
md.renderer.rules.strong_open=renderEm;md.renderer.rules.strong_close=renderEm;return md;},true);})(window);(function(window){"use strict";window.ls.container.set('rtl',function(){var rtlStock="^ا^ب^ت^ث^ج^ح^خ^د^ذ^ر^ز^س^ش^ص^ض^ط^ظ^ع^غ^ف^ق^ك^ل^م^ن^ه^و^ي^א^ב^ג^ד^ה^ו^ז^ח^ט^י^כ^ך^ל^מ^ם^נ^ן^ס^ע^פ^ף^צ^ץ^ק^ר^ש^ת^";var special=["\n"," "," ","״",'"',"_","'","!","@","#","$","^","&","%","*","(",")","+","=","-","[","]","\\","/","{","}","|",":","<",">","?",",",".","0","1","2","3","4","5","6","7","8","9"];var isRTL=function(value){for(var i=0;i<value.length;i++){if(/\s/g.test(value[i])){continue;}
if(-1===special.indexOf(value[i])){var firstChar=value[i];break;}}
if(-1<rtlStock.indexOf("^"+firstChar+"^")){return true;}
return false;};return{isRTL:isRTL,};},true);})(window);(function(window){"use strict";window.ls.container.set('sdk',function(window,router){var sdk=new window.Appwrite();var endpoint=window.location.origin+'/v1';sdk.setEndpoint(endpoint).setProject(router.params.project||'').setLocale(APP_ENV.LOCALE).setMode('admin');return sdk;},false);})(window);(function(window){"use strict";window.ls.container.set('search',function(window){return{params:{},path:'',pointer:'',selected:'',};},true,true);})(window);(function(window){"use strict";window.ls.container.set('timezone',function(){return{convert:function(unixTime){var timezoneMinutes=new Date().getTimezoneOffset();timezoneMinutes=(timezoneMinutes===0)?0:-timezoneMinutes;return parseInt(unixTime)+(timezoneMinutes*60);}};},true);})(window);(function(window){"use strict";window.ls.container.set('realtime',()=>{return{current:null,history:null,setCurrent:function(currentConnections){var scope=this;scope.current=currentConnections;return scope.current;},setHistory:function(history){var scope=this;scope.history=history;return scope.history;}};},true,true);})(window);window.ls.router.add("/auth/signin",{template:"/auth/signin?version="+APP_ENV.CACHEBUSTER,scope:"home"}).add("/auth/signup",{template:"/auth/signup?version="+APP_ENV.CACHEBUSTER,scope:"home"}).add("/auth/recovery",{template:"/auth/recovery?version="+APP_ENV.CACHEBUSTER,scope:"home"}).add("/auth/recovery/reset",{template:"/auth/recovery/reset?version="+APP_ENV.CACHEBUSTER,scope:"home"}).add("/auth/confirm",{template:"/auth/confirm?version="+APP_ENV.CACHEBUSTER,scope:"home"}).add("/auth/join",{template:"/auth/join?version="+APP_ENV.CACHEBUSTER,scope:"home"}).add("/auth/magic-url",{template:"/auth/magic-url?version="+APP_ENV.CACHEBUSTER,scope:"home"}).add("/auth/oauth2/success",{template:"/auth/oauth2/success?version="+APP_ENV.CACHEBUSTER,scope:"home"}).add("/auth/oauth2/failure",{template:"/auth/oauth2/failure?version="+APP_ENV.CACHEBUSTER,scope:"home"}).add("/console",{template:"/console?version="+APP_ENV.CACHEBUSTER,scope:"console"}).add("/console/account",{template:"/console/account?version="+APP_ENV.CACHEBUSTER,scope:"console"}).add("/console/account/:tab",{template:"/console/account?version="+APP_ENV.CACHEBUSTER,scope:"console"}).add("/console/home",{template:"/console/home?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/home/:tab",{template:"/console/home?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/platforms/:platform",{template:function(window){return window.location.pathname+"?version="+APP_ENV.CACHEBUSTER;},scope:"console",project:true}).add("/console/notifications",{template:"/console/notifications?version="+APP_ENV.CACHEBUSTER,scope:"console"}).add("/console/settings",{template:"/console/settings?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/settings/:tab",{template:"/console/settings?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/webhooks",{template:"/console/webhooks?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/webhooks/:tab",{template:"/console/webhooks?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/keys",{template:"/console/keys?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/keys/:tab",{template:"/console/keys?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/tasks",{template:"/console/tasks?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/tasks/:tab",{template:"/console/tasks?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/database",{template:"/console/database?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/database/collection",{template:function(window){return window.location.pathname+window.location.search+'&version='+APP_ENV.CACHEBUSTER;},scope:"console",project:true}).add("/console/database/collection/:tab",{template:function(window){return window.location.pathname+window.location.search+'&version='+APP_ENV.CACHEBUSTER;},scope:"console",project:true}).add("/console/database/document",{template:function(window){return window.location.pathname+window.location.search+'&version='+APP_ENV.CACHEBUSTER;},scope:"console",project:true}).add("/console/database/document/:tab",{template:function(window){return window.location.pathname+window.location.search+'&version='+APP_ENV.CACHEBUSTER;},scope:"console",project:true}).add("/console/storage",{template:"/console/storage?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/storage/:tab",{template:"/console/storage?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/users",{template:"/console/users?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/users/user",{template:"/console/users/user?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/users/user/:tab",{template:"/console/users/user?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/users/teams/team",{template:"/console/users/teams/team?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/users/teams/team/:tab",{template:"/console/users/teams/team?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/users/:tab",{template:"/console/users?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/functions",{template:"/console/functions?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/functions/function",{template:"/console/functions/function?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/functions/function/:tab",{template:"/console/functions/function?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true}).add("/console/functions/:tab",{template:"/console/functions?version="+APP_ENV.CACHEBUSTER,scope:"console",project:true});window.ls.filter.add("avatar",function($value,element){if(!$value){return"";}
let size=element.dataset["size"]||80;let name=$value.name||$value||"";name=(typeof name!=='string')?'--':name;return def="/v1/avatars/initials?project=console"+"&name="+
encodeURIComponent(name)+"&width="+
size+"&height="+
size;}).add("selectedCollection",function($value,router){return $value===router.params.collectionId?"selected":"";}).add("selectedDocument",function($value,router){return $value===router.params.documentId?"selected":"";}).add("localeString",function($value){$value=parseInt($value);return!Number.isNaN($value)?$value.toLocaleString():"";}).add("date",function($value,date){return date.format("Y-m-d",$value);}).add("dateTime",function($value,date){return date.format("Y-m-d H:i",$value);}).add("dateText",function($value,date){return date.format("d M Y",$value);}).add("timeSince",function($value){$value=$value*1000;let seconds=Math.floor((Date.now()-$value)/1000);let unit="second";let direction="ago";if(seconds<0){seconds=-seconds;direction="from now";}
let value=seconds;if(seconds>=31536000){value=Math.floor(seconds/31536000);unit="year";}
else if(seconds>=86400){value=Math.floor(seconds/86400);unit="day";}
else if(seconds>=3600){value=Math.floor(seconds/3600);unit="hour";}
else if(seconds>=60){value=Math.floor(seconds/60);unit="minute";}
if(value!=1){unit=unit+"s";}
return value+" "+unit+" "+direction;}).add("ms2hum",function($value){let temp=$value;const years=Math.floor(temp/31536000),days=Math.floor((temp%=31536000)/86400),hours=Math.floor((temp%=86400)/3600),minutes=Math.floor((temp%=3600)/60),seconds=temp%60;if(days||hours||seconds||minutes){return((years?years+"y ":"")+
(days?days+"d ":"")+
(hours?hours+"h ":"")+
(minutes?minutes+"m ":"")+
Number.parseFloat(seconds).toFixed(0)+"s");}
return"< 1s";}).add("seconds2hum",function($value){var seconds=($value).toFixed(3);var minutes=($value/(60)).toFixed(1);var hours=($value/(60*60)).toFixed(1);var days=($value/(60*60*24)).toFixed(1);if(seconds<60){return seconds+"s";}else if(minutes<60){return minutes+"m";}else if(hours<24){return hours+"h";}else{return days+"d"}}).add("markdown",function($value,markdown){return markdown.render($value);}).add("pageCurrent",function($value,env){return Math.ceil(parseInt($value||0)/env.PAGING_LIMIT)+1;}).add("pageTotal",function($value,env){let total=Math.ceil(parseInt($value||0)/env.PAGING_LIMIT);return total?total:1;}).add("humanFileSize",function($value){if(!$value){return 0;}
let thresh=1000;if(Math.abs($value)<thresh){return $value;}
let units=["kB","MB","GB","TB","PB","EB","ZB","YB"];let u=-1;do{$value/=thresh;++u;}while(Math.abs($value)>=thresh&&u<units.length-1);return $value.toFixed(1);}).add("humanFileUnit",function($value){if(!$value){return'';}
let thresh=1000;if(Math.abs($value)<thresh){return'B';}
let units=["kB","MB","GB","TB","PB","EB","ZB","YB"];let u=-1;do{$value/=thresh;++u;}while(Math.abs($value)>=thresh&&u<units.length-1);return units[u];}).add("statsTotal",function($value){if(!$value){return 0;}
$value=abbreviate($value,0,false,false);return $value==="0"?"N/A":$value;}).add("isEmpty",function($value){return(!!$value);}).add("isEmptyObject",function($value){return((Object.keys($value).length===0&&$value.constructor===Object)||$value.length===0)}).add("activeDomainsCount",function($value){let result=[];if(Array.isArray($value)){result=$value.filter(function(node){return(node.verification&&node.certificateId);});}
return result.length;}).add("documentAction",function(container){let collection=container.get('project-collection');let document=container.get('project-document');if(collection&&document&&!document.$id){return'database.createDocument';}
return'database.updateDocument';}).add("documentSuccess",function(container){let document=container.get('project-document');if(document&&!document.$id){return',redirect';}
return'';}).add("firstElement",function($value){if($value&&$value[0]){return $value[0];}
return $value;}).add("platformsLimit",function($value){return $value;}).add("limit",function($value){let postfix=($value.length>=50)?'...':'';return $value.substring(0,50)+postfix;;}).add("arraySentence",function($value){if(!Array.isArray($value)){return'';}
return $value.join(", ").replace(/,\s([^,]+)$/,' and $1');}).add("runtimeName",function($value,env){if(env&&env.RUNTIMES&&env.RUNTIMES[$value]){return env.RUNTIMES[$value].name;}
return'';}).add("runtimeLogo",function($value,env){if(env&&env.RUNTIMES&&env.RUNTIMES[$value]){return env.RUNTIMES[$value].logo;}
return'';}).add("runtimeVersion",function($value,env){if(env&&env.RUNTIMES&&env.RUNTIMES[$value]){return env.RUNTIMES[$value].version;}
return'';}).add("accessProject",function($value,router){return($value&&$value.hasOwnProperty(router.params.project))?$value[router.params.project]:0;});function abbreviate(number,maxPlaces,forcePlaces,forceLetter){number=Number(number);forceLetter=forceLetter||false;if(forceLetter!==false){return annotate(number,maxPlaces,forcePlaces,forceLetter);}
let abbr;if(number>=1e12){abbr="T";}else if(number>=1e9){abbr="B";}else if(number>=1e6){abbr="M";}else if(number>=1e3){abbr="K";}else{abbr="";}
return annotate(number,maxPlaces,forcePlaces,abbr);}
function annotate(number,maxPlaces,forcePlaces,abbr){let rounded=0;switch(abbr){case"T":rounded=number/1e12;break;case"B":rounded=number/1e9;break;case"M":rounded=number/1e6;break;case"K":rounded=number/1e3;break;case"":rounded=number;break;}
if(maxPlaces!==false){let test=new RegExp("\\.\\d{"+(maxPlaces+1)+",}$");if(test.test(""+rounded)){rounded=rounded.toFixed(maxPlaces);}}
if(forcePlaces!==false){rounded=Number(rounded).toFixed(forcePlaces);}
return rounded+abbr;}
window.ls.container.get("view").add({selector:"data-acl",controller:function(element,document,router,alerts){document.body.classList.remove("console");document.body.classList.remove("home");document.body.classList.add(router.getCurrent().view.scope);if(!router.getCurrent().view.project){document.body.classList.add("hide-nav");document.body.classList.remove("show-nav");}else{document.body.classList.add("show-nav");document.body.classList.remove("hide-nav");}
if("/console"===router.getCurrent().path){document.body.classList.add("index");}else{document.body.classList.remove("index");}}}).add({selector:"data-prism",controller:function(window,document,element,alerts){Prism.highlightElement(element);let copy=document.createElement("i");copy.className="icon-docs copy";copy.title="Copy to Clipboard";copy.textContent="Click Here to Copy";copy.addEventListener("click",function(){window.getSelection().removeAllRanges();let range=document.createRange();range.selectNode(element);window.getSelection().addRange(range);try{document.execCommand("copy");alerts.add({text:"Copied to clipboard",class:""},3000);}catch(err){alerts.add({text:"Failed to copy text ",class:"error"},3000);}
window.getSelection().removeAllRanges();});element.parentNode.parentNode.appendChild(copy);}});(function(window){"use strict";window.ls.view.add({selector:"data-service",controller:function(element,view,container,form,alerts,expression,window){let action=element.dataset["service"];let service=element.dataset["name"]||null;let event=expression.parse(element.dataset["event"]);let confirm=element.dataset["confirm"]||"";let loading=element.dataset["loading"]||"";let loaderId=null;let scope=element.dataset["scope"]||"sdk";let success=element.dataset["success"]||"";let failure=element.dataset["failure"]||"";let running=false;let callbacks={hide:function(){return function(){return element.style.opacity='0';};},reset:function(){return function(){if("FORM"===element.tagName){return element.reset();}
throw new Error("This callback is only valid for forms");};},alert:function(text,classname){return function(alerts){alerts.add({text:text,class:classname||"success"},3000);};},redirect:function(url){return function(router){window.location=url||"/";};},reload:function(){return function(router){router.reload();};},state:function(keys){let updateQueryString=function(key,value,url){var re=new RegExp("([?&])"+key+"=.*?(&|#|$)(.*)","gi"),hash;if(re.test(url)){if(typeof value!=="undefined"&&value!==null){return url.replace(re,"$1"+key+"="+value+"$2$3");}else{hash=url.split("#");url=hash[0].replace(re,"$1$3").replace(/(&|\?)$/,"");if(typeof hash[1]!=="undefined"&&hash[1]!==null){url+="#"+hash[1];}
return url;}}else{if(typeof value!=="undefined"&&value!==null){var separator=url.indexOf("?")!==-1?"&":"?";hash=url.split("#");url=hash[0]+separator+key+"="+value;if(typeof hash[1]!=="undefined"&&hash[1]!==null){url+="#"+hash[1];}
return url;}else{return url;}}};keys=keys.split(",").map(element=>element.trim());return function(serviceForm,router,window){let url=window.location.href;keys.map(node=>{node=node.split("=");let key=node[0]||"";let name=node[1]||key;let value=getValue(key,"param",serviceForm);url=updateQueryString(name,value?value:null,url);});if(url!==window.location.href){window.history.pushState({},"",url);router.reset();}};},trigger:function(events){return function(document){events=events.trim().split(",");for(let i=0;i<events.length;i++){if(""===events[i]){continue;}
document.dispatchEvent(new CustomEvent(events[i]));}};},setId:function name(params){},default:function(){let collection=container.get('project-collection');let document=container.get('project-document');if(collection&&document&&collection.$id===document.$id){for(const[key,value]of Object.entries(document)){delete document[key];}
if(collection.rules){for(let index=0;index<collection.rules.length;index++){const element=collection.rules[index];switch(element.type){case'text':case'email':case'url':case'ip':document[element.key]=element.default||'';break;case'numeric':document[element.key]=element.default||'0';break;case'boolean':document[element.key]=element.default||false;break;case'document':document[element.key]=element.default||{'$id':'','$collection':'','$permissions':{}};break;default:document[element.key]=null;break;}
if(element.array){document[element.key]=[];}}}}}};let getParams=function getParams(func){const REGEX_COMMENTS=/((\/\/.*$)|(\/\*[\s\S]*?\*\/))/gm;const REGEX_FUNCTION_PARAMS=/(?:\s*(?:function\s*[^(]*)?\s*)((?:[^'"]|(?:(?:(['"])(?:(?:.*?[^\\]\2)|\2))))*?)\s*(?=(?:=>)|{)/m;const REGEX_PARAMETERS_VALUES=/\s*([\w\\$]+)\s*(?:=\s*((?:(?:(['"])(?:\3|(?:.*?[^\\]\3)))((\s*\+\s*)(?:(?:(['"])(?:\6|(?:.*?[^\\]\6)))|(?:[\w$]*)))*)|.*?))?\s*(?:,|$)/gm;let functionAsString=func.toString();let params=[];let match;functionAsString=functionAsString.replaceAll('={}',"");functionAsString=functionAsString.replaceAll('=[]',"");functionAsString=functionAsString.replace(REGEX_COMMENTS,"");functionAsString=functionAsString.match(REGEX_FUNCTION_PARAMS)[1];if(functionAsString.charAt(0)==="("){functionAsString=functionAsString.slice(1,-1);}
while((match=REGEX_PARAMETERS_VALUES.exec(functionAsString))){params.push(match[1]);}
return params;};let getValue=function(key,prefix,data){let result=null;if(!key){return null;}
let attrKey=prefix+key.charAt(0).toUpperCase()+key.slice(1);if(element.dataset[attrKey]){result=expression.parse(element.dataset[attrKey]);if(element.dataset[attrKey+"CastTo"]==="array"){result=result.split(",");}}
if(typeof data[key]!=='undefined'){result=data[key];}
if(typeof result==='undefined'){result="";}
return result;};let resolve=function(target,prefix="param",data={}){if(!target){return function(){};}
let args=getParams(target);return target.apply(target,args.map(function(value){let result=getValue(value,prefix,data);return result??undefined;}));};let exec=function(event){let parsedSuccess=expression.parse(success);let parsedFailure=expression.parse(failure);let parsedAction=expression.parse(action);parsedSuccess=parsedSuccess&&parsedSuccess!=""?parsedSuccess.split(",").map(element=>element.trim()):[];parsedFailure=parsedFailure&&parsedFailure!=""?parsedFailure.split(",").map(element=>element.trim()):[];element.$lsSkip=true;element.classList.add("load-service-start");if(!document.body.contains(element)){element=undefined;return false;}
if(event){event.preventDefault();}
if(running){return false;}
running=true;element.style.backgroud='red';if(confirm){if(window.confirm(confirm)!==true){element.classList.add("load-service-end");element.$lsSkip=false;running=false;return false;}}
if(loading){loaderId=alerts.add({text:loading,class:""},0);}
let method=container.path(scope+"."+parsedAction);if(!method){throw new Error('Method "'+scope+"."+parsedAction+'" not found');}
let formData="FORM"===element.tagName?form.toJson(element):{};let result=resolve(method,"param",formData);if(!result){return;}
if(Promise.resolve(result)!=result){result=new Promise((resolve,reject)=>{resolve(result);});}
result.then(function(data){if(loaderId!==null){alerts.remove(loaderId);}
if(!element){return;}
running=false;element.style.backgroud='transparent';element.classList.add("load-service-end");if(service){container.set(service.replace(".","-"),data,true,true);}
container.set("serviceData",data,true,true);container.set("serviceForm",formData,true,true);for(let i=0;i<parsedSuccess.length;i++){container.resolve(resolve(callbacks[parsedSuccess[i]],"successParam"+
parsedSuccess[i].charAt(0).toUpperCase()+
parsedSuccess[i].slice(1),{}));}
container.set("serviceData",null,true,true);container.set("serviceForm",null,true,true);element.$lsSkip=false;view.render(element);},function(exception){if(loaderId!==null){alerts.remove(loaderId);}
if(!element){return;}
running=false;element.style.backgroud='transparent';element.classList.add("load-service-end");for(let i=0;i<parsedFailure.length;i++){container.resolve(resolve(callbacks[parsedFailure[i]],"failureParam"+
parsedFailure[i].charAt(0).toUpperCase()+
parsedFailure[i].slice(1),{}));}
element.$lsSkip=false;view.render(element);});};let events=event.trim().split(",");for(let y=0;y<events.length;y++){if(""===events[y]){continue;}
switch(events[y].trim()){case"load":exec();break;case"none":break;case"click":case"change":case"keypress":case"keydown":case"keyup":case"input":case"submit":element.addEventListener(events[y],exec);break;default:document.addEventListener(events[y],exec);}}}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-analytics",controller:function(element){let action=element.getAttribute("data-analytics-event")||"click";let doNotTrack=window.navigator.doNotTrack;if(doNotTrack=='1'){return;}
element.addEventListener(action,function(){let category=element.getAttribute("data-analytics-category")||"undefined";let label=element.getAttribute("data-analytics-label")||"undefined";if(!ga){console.error("Google Analytics ga object is not available");}
ga("send",{hitType:"event",eventCategory:category,eventAction:action,eventLabel:label});});}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-analytics-activity",controller:function(window,element,appwrite,container){let action=element.getAttribute("data-analytics-event")||"click";let activity=element.getAttribute("data-analytics-label")||"None";let doNotTrack=window.navigator.doNotTrack;if(doNotTrack=='1'){return;}
element.addEventListener(action,function(){let account=container.get('account');let email=account?.email||element?.elements['email']?.value||'';appwrite.analytics.create(email,'console',activity,window.location.href)});}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-analytics-pageview",controller:function(window,router,env){if(!ga){console.error("Google Analytics ga object is not available");}
let doNotTrack=window.navigator.doNotTrack;if(doNotTrack=='1'){return;}
let project=router.params["project"]||'None';ga("set","page",window.location.pathname);ga("set","dimension1",project);ga('set','dimension2',env.VERSION);ga('set','dimension3',env.SETUP);ga("send","pageview");}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-clone",controller:function(element,document,view){var template=element.innerHTML.toString();var label=element.dataset["label"]||"Add";var icon=element.dataset["icon"]||null;var target=element.dataset["target"]||null;var first=parseInt(element.dataset["first"]||1);var button=document.createElement("button");button.type="button";button.innerText=" "+label+" ";button.classList.add("margin-end");button.classList.add("margin-bottom-small");button.classList.add("reverse");if(icon){var iconElement=document.createElement("i");iconElement.className=icon;button.insertBefore(iconElement,button.firstChild);}
if(target){target=document.getElementById(target);}
button.addEventListener("click",function(){var clone=document.createElement(element.tagName);if(element.name){clone.name=element.name;}
clone.innerHTML=template;clone.className=element.className;view.render(clone);if(target){target.appendChild(clone);}else{button.parentNode.insertBefore(clone,button);}
clone.querySelector("input").focus();Array.prototype.slice.call(clone.querySelectorAll("[data-remove]")).map(function(obj){obj.addEventListener("click",function(){clone.parentNode.removeChild(clone);obj.scrollIntoView({behavior:"smooth"});});});Array.prototype.slice.call(clone.querySelectorAll("[data-up]")).map(function(obj){obj.addEventListener("click",function(){if(clone.previousElementSibling){clone.parentNode.insertBefore(clone,clone.previousElementSibling);obj.scrollIntoView({behavior:"smooth"});}});});Array.prototype.slice.call(clone.querySelectorAll("[data-down]")).map(function(obj){obj.addEventListener("click",function(){if(clone.nextElementSibling){clone.parentNode.insertBefore(clone.nextElementSibling,clone);obj.scrollIntoView({behavior:"smooth"});}});});});element.parentNode.insertBefore(button,element.nextSibling);element.parentNode.removeChild(element);if(first){button.click();}}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-add",repeat:false,controller:function(element,view,container,document){for(var i=0;i<element.children.length;i++){let button=document.createElement("button");let template=element.children[i].cloneNode(true);let as=element.getAttribute('data-ls-as');let counter=0;button.type="button";button.innerText="Add";button.classList.add("reverse");button.classList.add("margin-end-small");button.addEventListener('click',function(){container.addNamespace(as,'new-'+counter++);console.log(container.namespaces,container.get(as),as);container.set(as,null,true,true);let child=template.cloneNode(true);view.render(child);element.appendChild(child);element.style.visibility='visible';let inputs=child.querySelectorAll('input,textarea');for(let index=0;index<inputs.length;++index){if(inputs[index].type!=='hidden'){inputs[index].focus();break;}}});element.after(button);}}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-chart",controller:function(element,container,date,document){let wrapper=document.createElement("div");let child=document.createElement("canvas");let sources=element.getAttribute('data-forms-chart');let width=element.getAttribute('data-width')||500;let height=element.getAttribute('data-height')||175;let colors=(element.getAttribute('data-colors')||'blue,green,orange,red').split(',');let themes={'blue':'#29b5d9','green':'#4eb55b','orange':'#fba233','red':'#dc3232',};let range={'24h':'H:i','7d':'d F Y','30d':'d F Y','90d':'d F Y'}
element.parentNode.insertBefore(wrapper,element.nextSibling);wrapper.classList.add('content');child.width=width;child.height=height;sources=sources.split(',');wrapper.appendChild(child);let chart=null;let check=function(){let config={type:"line",data:{labels:[],datasets:[]},options:{responsive:true,title:{display:false,text:"Stats"},legend:{display:false},tooltips:{mode:"index",intersect:false,caretPadding:0},hover:{mode:"nearest",intersect:true},scales:{xAxes:[{display:false}],yAxes:[{display:false}]}}};for(let i=0;i<sources.length;i++){let label=sources[i].substring(0,sources[i].indexOf('='));let path=sources[i].substring(sources[i].indexOf('=')+1);let data=container.path(path);let value=JSON.parse(element.value);config.data.labels[i]=label;config.data.datasets[i]={};config.data.datasets[i].label=label;config.data.datasets[i].borderColor=themes[colors[i]];config.data.datasets[i].backgroundColor=themes[colors[i]]+'36';config.data.datasets[i].borderWidth=2;config.data.datasets[i].data=[0,0,0,0,0,0,0];config.data.datasets[i].fill=true;if(!data){return;}
let dateFormat=(value.range&&range[value.range])?range[value.range]:'d F Y';for(let x=0;x<data.length;x++){config.data.datasets[i].data[x]=data[x].value;config.data.labels[x]=date.format(dateFormat,data[x].date);}}
if(chart){chart.destroy();}
else{}
chart=new Chart(child.getContext("2d"),config);wrapper.dataset["canvas"]=true;}
check();element.addEventListener('change',check);}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-chart-bars",controller:(element)=>{let observer=null;let populateChart=()=>{let history=element.dataset?.history;if(history==0){history=new Array(12).fill({percentage:0,value:0});}else{history=JSON.parse(history);}
element.innerHTML='';history.forEach(({percentage,value},index)=>{const seconds=60-(index*5);const bar=document.createElement('span');bar.classList.add('bar');bar.classList.add(`bar-${percentage}`);bar.classList.add('tooltip');bar.classList.add('down');bar.setAttribute('data-tooltip',`${value} (${seconds} seconds ago)`);element.appendChild(bar);})}
if(observer){observer.disconnect();}else{observer=new MutationObserver(populateChart);observer.observe(element,{attributes:true,attributeFilter:['data-history']});}
populateChart();}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-code",controller:function(element,alerts){let lang=element.dataset["formsCode"]||"json";let div=document.createElement("div");let pre=document.createElement("pre");let code=document.createElement("code");let copy=document.createElement("i");div.appendChild(pre);div.appendChild(copy);pre.appendChild(code);element.parentNode.appendChild(div);element.style.display='none';div.className="ide";div.dataset['langLabel']=element.dataset["langLabel"]||'JSON';div.dataset['lang']=element.dataset["lang"]||'json';pre.className="line-numbers";code.className="prism language-"+lang;copy.className="icon-docs copy";copy.textContent="Click Here to Copy";copy.title="Copy to Clipboard";copy.addEventListener("click",function(){window.getSelection().removeAllRanges();let range=document.createRange();range.selectNode(code);window.getSelection().addRange(range);try{document.execCommand("copy");alerts.add({text:"Copied to clipboard",class:""},3000);}catch(err){alerts.add({text:"Failed to copy text ",class:"error"},3000);}
window.getSelection().removeAllRanges();});let check=function(){if(!element.value){return;}
let value=null;try{value=JSON.stringify(JSON.parse(element.value),null,4);}catch(error){value=element.value;}
code.innerHTML=value;Prism.highlightElement(code);div.scrollTop=0;};element.addEventListener("change",check);check();}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-color",controller:function(element){var preview=document.createElement("div");var picker=document.createElement("input");picker.type="color";preview.className="color-preview";preview.appendChild(picker);picker.addEventListener("change",syncA);picker.addEventListener("input",syncA);element.addEventListener("input",update);element.addEventListener("change",update);function update(){if(element.validity.valid){preview.style.background=element.value;syncB();}}
function syncA(){element.value=picker.value;update();}
function syncB(){picker.value=element.value;}
element.parentNode.insertBefore(preview,element);update();syncB();}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-copy",controller:function(element,alerts,document,window){var button=window.document.createElement("i");button.type="button";button.className="icon-docs note copy";button.style.cursor="pointer";element.parentNode.insertBefore(button,element.nextSibling);var copy=function(event){let disabled=element.disabled;element.disabled=false;element.focus();element.select();document.execCommand("Copy");if(document.selection){document.selection.empty();}else if(window.getSelection){window.getSelection().removeAllRanges();}
element.disabled=disabled;element.blur();alerts.add({text:"Copied to clipboard",class:""},3000);};button.addEventListener("click",copy);}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-document",controller:function(element,container,search){var formsDocument=(element.dataset["formsDocument"]||'');var searchButton=(element.dataset["search"]||0);let path=container.scope(searchButton);element.addEventListener('click',function(){search.selected=element.value;search.path=path;document.dispatchEvent(new CustomEvent(formsDocument,{bubbles:false,cancelable:true}));});}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-document-preview",controller:function(element,container,search){element.addEventListener('change',function(){console.log(element.value);});}});})(window);(function(window){window.ls.container.get("view").add({selector:"data-forms-filter",controller:function(document,container,expression,element,form,di){let name=element.dataset["formsFilter"]||"";let events=element.dataset["event"]||"";let serialize=function(obj,prefix){let str=[],p;for(p in obj){if(obj.hasOwnProperty(p)){let k=prefix?prefix+"["+p+"]":p,v=obj[p];if(v===""){continue;}
str.push(v!==null&&typeof v==="object"?serialize(v,k):encodeURIComponent(k)+"="+encodeURIComponent(v));}}
return str.join("&");};let parse=function(filter){if(filter===""){return null;}
let operatorsMap=["!=",">=","<=","=",">","<"];let operator=null;for(let key=0;key<operatorsMap.length;key++){if(filter.indexOf(operatorsMap[key])>-1){operator=operatorsMap[key];}}
if(operator===null){throw new Error("Invalid operator");}
filter=filter.split(operator);if(filter.length!==2){throw new Error("Invalid filter expression");}
return{key:filter[0],value:filter[1],operator:operator};};let flatten=function(params){let list={};for(let key in params){if(params.hasOwnProperty(key)){if(key!=="filters"){list[key]=params[key];}else{for(let i=0;i<params[key].length;i++){let filter=parse(params[key][i]);if(null===filter){continue;}
list["filters-"+filter.key]=params[key][i];}}}}
return list;};let apply=function(params){let cached=container.get(name);cached=cached?cached.params:[];params=Object.assign(cached,params);container.set(name,{name:name,params:params,query:serialize(params),forward:parseInt(params.offset)+parseInt(params.limit),backward:parseInt(params.offset)-parseInt(params.limit),keys:flatten(params)},true,name);document.dispatchEvent(new CustomEvent(name+"-changed",{bubbles:false,cancelable:true}));};switch(element.tagName){case"INPUT":break;case"TEXTAREA":break;case"BUTTON":element.addEventListener("click",function(){apply(JSON.parse(expression.parse(element.dataset["params"]||"{}")));});break;case"FORM":element.addEventListener("input",function(){apply(form.toJson(element));});element.addEventListener("change",function(){apply(form.toJson(element));});element.addEventListener("reset",function(){setTimeout(function(){apply(form.toJson(element));},0);});events=events.trim().split(",");for(let y=0;y<events.length;y++){if(events[y]==="init"){element.addEventListener("rendered",function(){apply(form.toJson(element));},{once:true});}else{}
element.setAttribute("data-event","none");}
break;default:break;}}});})(window);(function(window){window.ls.container.get("view").add({selector:"data-forms-headers",controller:function(element){let key=document.createElement("input");let value=document.createElement("input");let wrap=document.createElement("div");let cell1=document.createElement("div");let cell2=document.createElement("div");key.type="text";key.className="margin-bottom-no";key.placeholder="Key";value.type="text";value.className="margin-bottom-no";value.placeholder="Value";wrap.className="row thin margin-bottom-small";cell1.className="col span-6";cell2.className="col span-6";element.parentNode.insertBefore(wrap,element);cell1.appendChild(key);cell2.appendChild(value);wrap.appendChild(cell1);wrap.appendChild(cell2);key.addEventListener("input",function(){syncA();});value.addEventListener("input",function(){syncA();});element.addEventListener("change",function(){syncB();});let syncA=function(){element.value=key.value.toLowerCase()+":"+value.value.toLowerCase();};let syncB=function(){let split=element.value.toLowerCase().split(":");key.value=split[0]||"";value.value=split[1]||"";key.value=key.value.trim();value.value=value.value.trim();};syncB();}});})(window);(function(window){window.ls.container.get("view").add({selector:"data-forms-key-value",controller:function(element){let key=document.createElement("input");let value=document.createElement("input");let wrap=document.createElement("div");let cell1=document.createElement("div");let cell2=document.createElement("div");key.type="text";key.className="margin-bottom-no";key.placeholder="Key";key.required=true;value.type="text";value.className="margin-bottom-no";value.placeholder="Value";value.required=true;wrap.className="row thin margin-bottom-small";cell1.className="col span-6";cell2.className="col span-6";element.parentNode.insertBefore(wrap,element);cell1.appendChild(key);cell2.appendChild(value);wrap.appendChild(cell1);wrap.appendChild(cell2);key.addEventListener("input",function(){syncA();});value.addEventListener("input",function(){syncA();});element.addEventListener("change",function(){syncB();});let syncA=function(){element.name=key.value;element.value=value.value;};let syncB=function(){key.value=element.name||"";value.value=element.value||"";};syncB();}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-move-down",controller:function(element){Array.prototype.slice.call(element.querySelectorAll("[data-move-down]")).map(function(obj){obj.addEventListener("click",function(){if(element.nextElementSibling){console.log('down',element.offsetHeight);element.parentNode.insertBefore(element.nextElementSibling,element);element.scrollIntoView({block:'center'});}});});}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-move-up",controller:function(element){Array.prototype.slice.call(element.querySelectorAll("[data-move-up]")).map(function(obj){obj.addEventListener("click",function(){if(element.previousElementSibling){console.log('up',element);element.parentNode.insertBefore(element,element.previousElementSibling);element.scrollIntoView({block:'center'});}});});}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-nav",repeat:false,controller:function(element,view,container,document){let titles=document.querySelectorAll('[data-forms-nav-anchor]');let links=element.querySelectorAll('[data-forms-nav-link]');let minLink=null;let check=function(){let minDistance=null;let minElement=null;for(let i=0;i<titles.length;++i){let title=titles[i];let distance=title.getBoundingClientRect().top;console.log(i);if((minDistance===null||minDistance>=distance)&&(distance>=0)){if(minLink){minLink.classList.remove('selected');}
console.log('old',minLink);minDistance=distance;minElement=title;minLink=links[i];minLink.classList.add('selected');console.log('new',minLink);}}};window.addEventListener('scroll',check);check();}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-oauth-apple",controller:function(element){let container=document.createElement("div");let row=document.createElement("div");let col1=document.createElement("div");let col2=document.createElement("div");let keyID=document.createElement("input");let keyLabel=document.createElement("label");let teamID=document.createElement("input");let teamLabel=document.createElement("label");let p8=document.createElement("textarea");let p8Label=document.createElement("label");keyLabel.textContent='Key ID';teamLabel.textContent='Team ID';p8Label.textContent='P8 File';row.classList.add('row');row.classList.add('thin');container.appendChild(row);container.appendChild(p8Label);container.appendChild(p8);row.appendChild(col1);row.appendChild(col2);col1.classList.add('col');col1.classList.add('span-6');col1.appendChild(keyLabel);col1.appendChild(keyID);col2.classList.add('col');col2.classList.add('span-6');col2.appendChild(teamLabel);col2.appendChild(teamID);keyID.type='text';keyID.placeholder='SHAB13ROFN';teamID.type='text';teamID.placeholder='ELA2CD3AED';p8.accept='.p8';p8.classList.add('margin-bottom-no');element.parentNode.insertBefore(container,element.nextSibling);element.addEventListener('change',sync);keyID.addEventListener('change',update);teamID.addEventListener('change',update);p8.addEventListener('change',update);function update(){let json={};json.keyID=keyID.value;json.teamID=teamID.value;json.p8=p8.value;element.value=JSON.stringify(json);}
function sync(){if(!element.value){return;}
let json={};try{json=JSON.parse(element.value);}catch(error){console.error('Failed to parse secret key');}
teamID.value=json.teamID||'';keyID.value=json.keyID||'';p8.value=json.p8||'';}
sync();}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-password-meter",controller:function(element,window){var calc=function(password){var score=0;if(!password)return score;var letters=new window.Object();for(var i=0;i<password.length;i++){letters[password[i]]=(letters[password[i]]||0)+1;score+=5.0/letters[password[i]];}
var variations={digits:/\d/.test(password),lower:/[a-z]/.test(password),upper:/[A-Z]/.test(password),nonWords:/\W/.test(password)};var variationCount=0;for(var check in variations){if(variations.hasOwnProperty(check)){variationCount+=variations[check]===true?1:0;}}
score+=(variationCount-1)*10;return parseInt(score);};var callback=function(){var score=calc(this.value);if(""===this.value)return(meter.className="password-meter");if(score>60)return(meter.className="password-meter strong");if(score>30)return(meter.className="password-meter medium");if(score>=0)return(meter.className="password-meter weak");};var meter=window.document.createElement("div");meter.className="password-meter";element.parentNode.insertBefore(meter,element.nextSibling);element.addEventListener("change",callback);element.addEventListener("keypress",callback);element.addEventListener("keyup",callback);element.addEventListener("keydown",callback);}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-pell",controller:function(element,window,document,markdown,rtl){var div=document.createElement("div");element.className="pell hide";div.className="input pell";element.parentNode.insertBefore(div,element);element.tabIndex=-1;var turndownService=new TurndownService();turndownService.addRule("underline",{filter:["u"],replacement:function(content){return"__"+content+"__";}});var editor=window.pell.init({element:div,onChange:function onChange(html){alignText();element.value=turndownService.turndown(html);},defaultParagraphSeparator:"p",actions:[{name:"bold",icon:'<i class="icon-bold"></i>'},{name:"underline",icon:'<i class="icon-underline"></i>'},{name:"italic",icon:'<i class="icon-italic"></i>'},{name:"olist",icon:'<i class="icon-list-numbered"></i>'},{name:"ulist",icon:'<i class="icon-list-bullet"></i>'},{name:"link",icon:'<i class="icon-link"></i>'}]});var clean=function(e){e.stopPropagation();e.preventDefault();var clipboardData=e.clipboardData||window.clipboardData;console.log(clipboardData.getData("Text"));window.pell.exec("insertText",clipboardData.getData("Text"));return true;};var alignText=function(){let paragraphs=editor.content.querySelectorAll('p,li');let last='';for(let paragraph of paragraphs){var content=paragraph.textContent;if(content.trim()===''){content=last.textContent;}
if(rtl.isRTL(content)){paragraph.style.direction='rtl';paragraph.style.textAlign='right';}
else{paragraph.style.direction='ltr';paragraph.style.textAlign='left';}
last=paragraph;}};var santize=function(e){clean(e);alignText(e);};element.addEventListener("change",function(){editor.content.innerHTML=markdown.render(element.value);alignText();});editor.content.setAttribute("placeholder",element.placeholder);editor.content.innerHTML=markdown.render(element.value);editor.content.tabIndex=0;alignText();editor.content.onkeydown=function preventTab(event){if(event.which===9){event.preventDefault();if(document.activeElement){var focussable=Array.prototype.filter.call(document.querySelectorAll('a:not([disabled]), button:not([disabled]), select:not([disabled]), input[type=text]:not([disabled]), input[type=checkbox]:not([disabled]), [tabindex]:not([disabled]):not([tabindex="-1"])'),function(element){return(element.offsetWidth>0||element.offsetHeight>0||element===document.activeElement);});var index=focussable.indexOf(document.activeElement);if(index>-1){if(event.shiftKey){var prevElement=focussable[index-1]||focussable[focussable.length-1];prevElement.focus();}else{var nextElement=focussable[index+1]||focussable[0];nextElement.focus();}}}}};div.addEventListener("paste",santize);div.addEventListener("drop",santize);}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-remove",controller:function(element){Array.prototype.slice.call(element.querySelectorAll("[data-remove]")).map(function(obj){obj.addEventListener("click",function(){element.parentNode.removeChild(element);});});}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-run",repeat:false,controller:function(element,expression,container){let action=expression.parse(element.dataset["formsRun"]||'');element.addEventListener('click',function(){return container.path(action)();});}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-select-all",controller:function(element){let select=document.createElement("button");let unselect=document.createElement("button");select.textContent='Select All';unselect.textContent='Unselect All';select.classList.add('link');select.classList.add('margin-top-tiny');select.classList.add('margin-start-small');select.classList.add('text-size-small');select.classList.add('pull-end');unselect.classList.add('link');unselect.classList.add('margin-top-tiny');unselect.classList.add('margin-start-small');unselect.classList.add('text-size-small');unselect.classList.add('pull-end');select.type='button';unselect.type='button';element.parentNode.insertBefore(select,element);element.parentNode.insertBefore(unselect,element);select.addEventListener('click',function(){let checkboxes=element.querySelectorAll("input[type='checkbox']");for(var i=0;i<checkboxes.length;i++){checkboxes[i].checked=true;checkboxes[i].dispatchEvent(new Event('change'));}})
unselect.addEventListener('click',function(){let checkboxes=element.querySelectorAll("input[type='checkbox']");for(var i=0;i<checkboxes.length;i++){checkboxes[i].checked=false;checkboxes[i].dispatchEvent(new Event('change'));}})}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-show-secret",controller:function(element,document){let button=document.createElement('span');button.className="link pull-end text-size-small margin-top-negative icon-eye";button.innerHTML=(element.type=='password')?'Show Secret':'Hide Secret';button.style.visibility=(element.value=='')?'hidden':'visible';element.insertAdjacentElement("beforebegin",button);button.addEventListener("click",function(event){switch(element.type){case"password":element.type="text";button.innerHTML='Hide Secret';break;case"text":element.type="password";button.innerHTML='Show Secret';break;default:console.warn("data-forms-show-secret: element.type NOT text NOR password");}});let sync=function(event){button.style.visibility=(element.value=='')?'hidden':'visible';};element.addEventListener("keyup",sync);element.addEventListener("change",sync);},});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-switch",controller:function(element){let input=window.document.createElement("input");input.type="checkbox";input.className="button switch "+element.className;let syncA=function(){let value=input.checked?"true":"false"
let old=element.value;element.value=value;if(value!==old){element.dispatchEvent(new Event('change'));}};let syncB=function(){input.checked=(element.value==="true");};input.addEventListener("input",syncA);input.addEventListener("change",syncA);element.addEventListener("input",syncB);element.addEventListener("change",syncB);syncA();element.parentNode.insertBefore(input,element);}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-tags",controller:function(element){let array=[];let tags=window.document.createElement("div");let preview=window.document.createElement("ul");let add=window.document.createElement("input");let listen=function(event){if((event.key==="Enter"||event.key===" "||event.key==="Tab")&&add.value.length>0){array.push(add.value);add.value="";element.value=JSON.stringify(array);check();if(event.key!=="Tab"){event.preventDefault();}}
if((event.key==="Backspace"||event.key==="Delete")&&add.value===""){array.splice(-1,1);element.value=JSON.stringify(array);check();}
return false;};let check=function(){try{array=JSON.parse(element.value)||[];}catch(error){array=[];}
if(!Array.isArray(array)){array=[];}
preview.innerHTML="";for(let index=0;index<array.length;index++){let value=array[index];let tag=window.document.createElement("li");if(!value||value===' '){continue;}
tag.className="tag";tag.textContent=value;tag.addEventListener("click",function(){array.splice(index,1);element.value=JSON.stringify(array);check();});preview.appendChild(tag);}
if(element.required&&array.length===0){add.setCustomValidity("Please add permissions");}else{add.setCustomValidity("");}};tags.className="tags";preview.className="tags-list";add.type="text";add.className="add";add.placeholder=element.placeholder;tags.addEventListener("click",function(){add.focus();});add.addEventListener("keydown",listen);add.addEventListener("blur",function(event){if(add.value!==''){array.push(add.value);add.value="";element.value=JSON.stringify(array);check();}});tags.appendChild(preview);tags.appendChild(add);element.parentNode.insertBefore(tags,element);element.addEventListener("change",check);check();}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-text-count",controller:function(element){var counter=document.createElement("div");counter.className="counter";element.parentNode.insertBefore(counter,element.nextSibling);var count=function(){if(0<=element.maxLength){counter.innerText=(element.maxLength-element.value.length).toString()+" / "+
element.maxLength;}else{var words=element.value!==""?element.value.trim().split(" ").length:0;counter.innerText=words+" words and "+element.value.length.toString()+" chars";}};element.addEventListener("keyup",count);element.addEventListener("change",count);element.addEventListener("cut",count);element.addEventListener("paste",count);element.addEventListener("drop",count);count();}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-text-direction",controller:function(element,rtl){var setDirection=function(){var value=element.value[0]?element.value:"";var direction="ltr";var align="left";if(rtl.isRTL(value)){direction="rtl";align="right";}
element.style.direction=direction;element.style.textAlign=align;};element.addEventListener("keyup",setDirection);element.addEventListener("change",setDirection);element.addEventListener("cut",setDirection);element.addEventListener("paste",setDirection);element.addEventListener("drop",setDirection);setDirection();}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-text-resize",controller:function(element,window){function resize(){var scrollLeft=window.pageXOffset||(window.document.documentElement||window.document.body.parentNode||window.document.body).scrollLeft;var scrollTop=window.pageYOffset||(window.document.documentElement||window.document.body.parentNode||window.document.body).scrollTop;var offset=element.offsetHeight-element.clientHeight;element.style.height="auto";element.style.height=element.scrollHeight+offset+"px";window.scrollTo(scrollLeft,scrollTop);}
element.addEventListener("keyup",resize);element.addEventListener("change",resize);element.addEventListener("cut",resize);element.addEventListener("paste",resize);element.addEventListener("drop",resize);window.addEventListener("resize",resize);resize();}});})(window);(function(window){"use strict";window.ls.container.get("view").add({selector:"data-forms-upload",controller:function(element,container,alerts,expression,env,search){var scope=element.dataset["scope"];var project=expression.parse(element.dataset["project"]||"console");var labelButton=element.dataset["labelButton"]||"Upload";var labelLoading=element.dataset["labelLoading"]||"Uploading...";var previewWidth=element.dataset["previewWidth"]||200;var previewHeight=element.dataset["previewHeight"]||200;var previewAlt=element.dataset["previewAlt"]||200;var accept=element.dataset["accept"]||"";var searchButton=(element.dataset["search"]||0);var required=element.dataset["required"]||false;var className=element.dataset["class"]||"upload";var max=parseInt(element.dataset["max"]||4);var sdk=scope==="sdk"?container.get("sdk"):container.get("console");var output=element.value||null;var wrapper=document.createElement("div");var input=document.createElement("input");var upload=document.createElement("div");var preview=document.createElement("ul");var progress=document.createElement("div");var count=document.createElement("div");wrapper.className=className;input.type="file";input.accept=accept;input.required=required;input.tabIndex=-1;count.className="count";upload.className="button reverse margin-bottom-small";upload.innerHTML='<i class="icon icon-upload"></i> '+labelButton;upload.tabIndex=0;preview.className="preview";progress.className="progress";progress.style.width="0%";progress.style.display="none";var onComplete=function(message){alerts.remove(message);input.disabled=false;upload.classList.remove("disabled");progress.style.width="0%";progress.style.display="none";};var render=function(result){preview.innerHTML="";count.innerHTML="0 / "+max;if(!result){return;}
var file=document.createElement("li");var image=document.createElement("img");image.src=image.src=env.API+"/storage/files/"+
result+"/preview?width="+
previewWidth+"&height="+
previewHeight+"&project="+project+"&mode=admin";image.alt=previewAlt;file.className="file avatar";file.tabIndex=0;file.appendChild(image);preview.appendChild(file);var remove=(function(result){return function(event){render(result.$id);element.value='';};})(result);file.addEventListener("click",remove);file.addEventListener("keypress",remove);element.value=result;};input.addEventListener("change",function(){var message=alerts.add({text:labelLoading,class:""},0);var files=input.files;var read=JSON.parse(expression.parse(element.dataset["read"]||"[]"));var write=JSON.parse(expression.parse(element.dataset["write"]||"[]"));sdk.storage.createFile(files[0],read,write,1).then(function(response){onComplete(message);render(response.$id);},function(error){alerts.add({text:"An error occurred!",class:""},3000);onComplete(message);});input.disabled=true;});element.addEventListener("change",function(){if(!element.value){return;}
render(element.value);wrapper.scrollIntoView();});upload.addEventListener("keypress",function(){input.click();});element.parentNode.insertBefore(wrapper,element);wrapper.appendChild(preview);wrapper.appendChild(progress);wrapper.appendChild(upload);upload.appendChild(input);render(output);if(searchButton){let searchOpen=document.createElement("button");searchOpen.type='button';searchOpen.innerHTML='<i class="icon icon-search"></i> Search';searchOpen.classList.add('reverse');let path=container.scope(searchButton);searchOpen.addEventListener('click',function(){search.selected=element.value;search.path=path;document.dispatchEvent(new CustomEvent("open-file-serach",{bubbles:false,cancelable:true}));});wrapper.appendChild(searchOpen);}}});})(window);(function(window){window.ls.container.get("view").add({selector:"data-cookies",controller:function(element,alerts,cookie,env){if(!cookie.get("cookie-alert")){let text=element.dataset["cookies"]||"";alerts.add({text:text,class:"cookie-alert",link:env.HOME+"/policy/cookies",label:'Learn More',callback:function(){cookie.set("cookie-alert","true",365*10);}},0);}}});})(window);(function(window){window.ls.container.get("view").add({selector:"data-page-title",repeat:true,controller:function(element,document,expression){document.title=expression.parse(element.getAttribute("data-page-title"))||document.title;}});})(window);(function(window){"use strict";window.ls.view.add({selector:'data-general-scroll-to',repeat:false,controller:function(element,window){let button=window.document.createElement('button');button.className='scroll-to icon-up-dir';button.alt='Back To Top';button.title='Back To Top';button.addEventListener('click',function(){element.scrollIntoView(true,{behavior:'smooth'});button.blur();},false);element.appendChild(button);}});})(window);(function(window){"use strict";window.ls.view.add({selector:'data-general-scroll-direction',repeat:false,controller:function(element,window){let position=0;let check=function(){let direction=window.document.documentElement.scrollTop;if(direction>position){element.classList.remove('scroll-to-top')
element.classList.add('scroll-to-bottom')}
else{element.classList.remove('scroll-to-bottom')
element.classList.add('scroll-to-top')}
position=direction;let current=Math.ceil(direction/window.innerHeight);element.setAttribute('data-views-total',Math.ceil(element.scrollHeight/window.innerHeight));element.setAttribute('data-views-current',current);if(element.scrollHeight<=(direction+element.offsetHeight+300)&&direction>0){element.classList.add('scroll-end')}
else{element.classList.remove('scroll-end')}};window.addEventListener('scroll',check,false);window.addEventListener('resize',check,false);check();}});})(window);(function(window){window.ls.container.get("view").add({selector:"data-setup",controller:function(element,console,form,alerts,router){element.addEventListener("submit",function(event){event.preventDefault();let loaderId=alerts.add({text:'Creating new project...',class:""},0);let formData=form.toJson(element);formData["name"]=formData["name"]||(element.dataset["defaultName"]||"");console.teams.create(formData["name"]||"").then(function(data){let team=data["$id"];formData=JSON.parse(JSON.stringify(formData).replace(new RegExp("{{teamId}}","g"),team));console.projects.create(formData["name"],team).then(function(project){alerts.remove(loaderId);window.location.href="/console/home?project="+project["$id"];},function(){throw new Error("Failed to setup project");});},function(){throw new Error("Setup failed creating project team");});});}});})(window);(function(window){window.ls.container.get("view").add({selector:"data-switch",controller:function(element,router,document){let check=function(c){if(!element.value){return;}
if(element.value===router.params.project){return;}
return router.change("/console/home?project="+element.value);};element.addEventListener("change",function(){check();});}});})(window);(function(window){window.ls.container.get("view").add({selector:"data-general-theme",controller:function(element,router,document){let toggle=function(c){if(document.body.classList.contains('theme-light')){document.body.classList.remove('theme-light');document.body.classList.add('theme-dark');window.localStorage.setItem('user-theme','theme-dark')}
else{document.body.classList.remove('theme-dark');document.body.classList.add('theme-light');window.localStorage.setItem('user-theme','theme-light')}};element.addEventListener("click",function(){toggle();});}});})(window);(function(window){window.ls.container.get("view").add({selector:"data-version",controller:function(alerts,env,cookie){let cookieName="version-update-"+env.VERSION.replace(/\./g,"_");if(!cookie.get(cookieName)){var xhr=new XMLHttpRequest();xhr.open('GET','/console/version',true);xhr.onload=function(){if(this.readyState==4&&this.status==200){let data=JSON.parse(this.responseText);let text='Appwrite version '+data.version+' is avaliable, check the';if(isNewerVersion(env.VERSION,data.version)){alerts.add({text:text,class:"success",link:"https://github.com/appwrite/appwrite/releases",label:'release notes',callback:function(){cookie.set(cookieName,"true",365*10);}},0);}}};xhr.send(null);function isNewerVersion(oldVer,newVer){const oldParts=oldVer.split('.')
const newParts=newVer.split('.')
for(var i=0;i<newParts.length;i++){const a=parseInt(newParts[i])||0
const b=parseInt(oldParts[i])||0
if(a>b)return true
if(a<b)return false}
return false}}}});})(window);(function(window){window.ls.container.get("view").add({selector:"data-paging-back",controller:function(element,container,expression,env){let paths=[];let limit=env.PAGING_LIMIT;let check=function(){let offset=parseInt(expression.parse(element.dataset["offset"])||"0");paths=paths.concat(expression.getPaths());if(offset-limit<0){element.disabled=true;}else{element.disabled=false;element.value=offset-limit;}};check();for(let i=0;i<paths.length;i++){let path=paths[i].split(".");while(path.length){container.bind(element,path.join("."),check);path.pop();}}}});})(window);(function(window){window.ls.container.get("view").add({selector:"data-paging-next",controller:function(element,container,expression,env){let paths=[];let limit=env.PAGING_LIMIT;let check=function(){let offset=parseInt(expression.parse(element.dataset["offset"])||"0");paths=paths.concat(expression.getPaths());let sum=parseInt(expression.parse(element.dataset["sum"])||"0");paths=paths.concat(expression.getPaths());if(offset+limit>=sum){element.disabled=true;}else{element.disabled=false;element.value=offset+limit;}};check();for(let i=0;i<paths.length;i++){let path=paths[i].split(".");while(path.length){container.bind(element,path.join("."),check);path.pop();}}}});})(window);(function(window){window.ls.container.get("view").add({selector:"data-ui-highlight",controller:function(element,expression,document){let check=function(){let links=element.getElementsByTagName("a");let selected=null;let list=[];for(let i=0;i<links.length;i++){list.push(links[i]);}
list.sort(function(a,b){return a.pathname.length-b.pathname.length;});if(selected&&list[selected].dataset["selected"]){let parent=element.querySelector("a[href='"+list[selected].dataset["selected"]+"']");if(parent){parent.classList.remove("selected");}}
for(let i=0;i<list.length;i++){let path=list[i].pathname;if(path===window.location.pathname.substring(0,path.length)){list[i].classList.add("selected");if(selected!==null){list[selected].classList.remove("selected");}
selected=i;}else{list[i].classList.remove("selected");}}
if(selected&&list[selected].dataset["selected"]){let parent=element.querySelector("a[href='"+list[selected].dataset["selected"]+"']");if(parent){parent.classList.add("selected");}}};document.addEventListener("state-changed",check);check();},});})(window);(function(window){window.ls.container.get("view").add({selector:"data-ls-ui-loader",controller:function(element,document){document.addEventListener('account.get',function(){element.classList.add('loaded');});}});})(window);(function(window){window.ls.container.get("view").add({selector:"data-ui-modal",controller:function(document,element,expression){let name=expression.parse(element.dataset["name"]||'');let buttonText=expression.parse(element.dataset["buttonText"]||"");let buttonElement=expression.parse(element.dataset["buttonElement"]||"button");let buttonClass=expression.parse(element.dataset["buttonClass"]||"button-class");let buttonIcon=expression.parse(element.dataset["buttonIcon"]||'');let buttonEvent=expression.parse(element.dataset["buttonEvent"]||"");let buttonHide=expression.parse(element.dataset["buttonHide"]||"");let buttonAlias=expression.parse(element.dataset["buttonAlias"]||"");let buttonElements=!buttonAlias?[document.createElement(buttonElement)]:document.querySelectorAll(buttonAlias);let openEvent=expression.parse(element.dataset["openEvent"]||'');let closeEvent=expression.parse(element.dataset["closeEvent"]||'submit');let background=document.getElementById("modal-bg");if(!background){background=document.createElement("div");background.id="modal-bg";background.className="modal-bg";document.body.appendChild(background);background.addEventListener("click",function(){document.dispatchEvent(new CustomEvent("modal-close",{bubbles:false,cancelable:true}));});}
if(!buttonAlias){buttonElements.forEach(button=>{button.innerText=buttonText;button.className=buttonClass;button.type=buttonElement;if(buttonIcon){let iconElement=document.createElement("i");iconElement.className=buttonIcon;button.insertBefore(iconElement,button.firstChild);}});}
if(buttonEvent){buttonElements.forEach(button=>{button.addEventListener("click",function(){document.dispatchEvent(new CustomEvent(buttonEvent,{bubbles:false,cancelable:true}));});});}
element.classList.add("modal");if(!buttonAlias&&!buttonHide){buttonElements.forEach(button=>{element.parentNode.insertBefore(button,element);});}
let open=function(){document.documentElement.classList.add("modal-open");document.dispatchEvent(new CustomEvent("modal-open",{bubbles:false,cancelable:true}));element.classList.add("open");element.classList.remove("close");let form=element.querySelector('form');let elements=(form&&form.elements)?[...form.elements]:[];for(let index=0;index<elements.length;index++){let element=elements[index];if(element.type!=='hidden'&&element.type!=='button'&&element.type!=='submit'){element.focus();break;}}};let close=function(event){document.documentElement.classList.remove("modal-open");element.classList.add("close");element.classList.remove("open");};if(name){document.querySelectorAll("[data-ui-modal-ref='"+name+"']").forEach(function(elem){elem.addEventListener("click",open);});}
if(openEvent){document.addEventListener(openEvent,open);}
buttonElements.forEach(button=>{button.addEventListener("click",open);});document.addEventListener("keydown",function(event){if(event.which===27){close();}});element.addEventListener("blur",close);let closeButtons=element.querySelectorAll("[data-ui-modal-close]");for(let i=0;i<closeButtons.length;i++){closeButtons[i].addEventListener("click",close);}
document.addEventListener("modal-close",close);element.addEventListener(closeEvent,close);}});})(window);(function(window){window.ls.container.get("view").add({selector:"data-ls-ui-open",controller:function(element,window){let def=element.classList.contains("open")?"open":"close";let buttonClass=element.dataset["buttonClass"]||"ls-ui-open";let buttonText=element.dataset["buttonText"]||"";let buttonIcon=element.dataset["buttonIcon"]||"";let buttonAria=element.dataset["buttonAria"]||"Open";let buttonSelector=element.dataset["buttonSelector"]||"";let hover=element.hasAttribute("data-hover");let blur=element.hasAttribute("data-blur");let button=window.document.createElement("button");let isTouch=function(){return("ontouchstart"in window||navigator.maxTouchPoints);};button.innerText=buttonText;button.className=buttonClass;button.type="button";if(buttonIcon){let icon=window.document.createElement("i");icon.className=buttonIcon;button.insertBefore(icon,button.firstChild);}
if(buttonAria){button.setAttribute('aria-label',buttonAria);}
if(def==="close"){element.classList.add("close");element.classList.remove("open");}else{element.classList.add("open");element.classList.remove("close");}
button.addEventListener("click",function(){element.classList.toggle("open");element.classList.toggle("close");});if(hover&&!isTouch()){element.addEventListener("mouseover",function(){element.classList.add("open");element.classList.remove("close");});element.addEventListener("mouseout",function(){element.classList.add("close");element.classList.remove("open");});}
let close=function(){element.classList.add("close");element.classList.remove("open");};let closeDelay=function(){window.setTimeout(function(){close();},400);};let findParent=function(tagName,el){if((el.nodeName||el.tagName).toLowerCase()===tagName.toLowerCase()){return el;}
while((el=el.parentNode)){if((el.nodeName||el.tagName).toLowerCase()===tagName.toLowerCase()){return el;}}
return null;};if(blur){button.addEventListener("blur",closeDelay);}
if(buttonSelector){let buttonElements=element.querySelectorAll(buttonSelector);buttonElements.forEach(node=>{node.addEventListener("click",function(){element.classList.toggle("open");element.classList.toggle("close");});if(blur){node.addEventListener("blur",closeDelay);}});}
element.addEventListener('click',function(event){let targetA=findParent('a',event.target);let targetB=findParent('button',event.target);if(!targetA&&!targetB){return false;}
if(targetA&&!targetA.href){return false;}
if(targetB&&!targetB.classList.contains('link')){return false;}
closeDelay();});element.insertBefore(button,element.firstChild);}});})(window);(function(window){window.ls.container.get("view").add({selector:"data-ui-phases",controller:function(element,window,document,expression,router){var tabs=document.createElement("ul");var container=document.createElement("div");var titles=Array.prototype.slice.call(element.querySelectorAll("li > h1"));var next=Array.prototype.slice.call(element.querySelectorAll("[data-next]"));var previous=Array.prototype.slice.call(element.querySelectorAll("[data-previous]"));var position=0;var init=false;if(titles.length===0){titles=Array.prototype.slice.call(element.querySelectorAll("li > h2"));}
if(titles.length===0){titles=Array.prototype.slice.call(element.querySelectorAll("li > h3"));}
if(titles.length===0){titles=Array.prototype.slice.call(element.querySelectorAll("li > h4"));}
if(titles.length===0){titles=Array.prototype.slice.call(element.querySelectorAll("li > h5"));}
if(titles.length===0){titles=Array.prototype.slice.call(element.querySelectorAll("li > h6"));}
for(var i=0;i<element.children.length;i++){var tabState=expression.parse(element.children[i].dataset["state"]||"");if(tabState&&tabState===(window.location.pathname+window.location.search).substring(0,tabState.length)){position=i;}}
var setTab=function(index){var tabState=expression.parse(element.children[index].dataset["state"]||"");var url="";if(tabState!==""&&tabState!==window.location.pathname+window.location.search){var parser=document.createElement("a");parser.href=tabState;url=!init?parser.pathname+window.location.search:tabState;if(position!=index){window.history.pushState({},"",url);router.reset();}}
element.children[position].classList.remove("selected");element.children[index].classList.add("selected");tabs.children[position].classList.remove("selected");tabs.children[index].classList.add("selected");position=index;document.dispatchEvent(new CustomEvent("tab-changed"));init=true;};tabs.classList.add("tabs");container.classList.add("container");container.classList.add("close");container.dataset["lsUiOpen"]="";container.dataset["buttonClass"]="icon icon-down-dir";titles.map(function(obj,i){var title=document.createElement("li");title.innerHTML=obj.innerHTML;title.className=obj.className;title.tabIndex=0;tabs.appendChild(title);title.addEventListener("click",function(){setTab(i);});title.addEventListener("keyup",function(){if(event.which===13){setTab(i);}});});next.map(function(obj){obj.addEventListener("click",function(){setTab(position+1);});});previous.map(function(obj){obj.addEventListener("click",function(){setTab(position-1);});});setTab(position);container.appendChild(tabs);element.parentNode.insertBefore(container,element);}});})(window);(function(window){window.ls.container.get("view").add({selector:"data-ls-ui-trigger",controller:function(element,document,expression){let trigger=expression.parse(element.dataset["lsUiTrigger"]||'').trim().split(',');let event=expression.parse(element.dataset["event"]||'click');let debug=element.getAttribute('data-debug')||false;for(let index=0;index<trigger.length;index++){let name=trigger[index];element.addEventListener(event,function(){if(debug){console.log('Debug: event triggered: '+name);}
document.dispatchEvent(new CustomEvent(name));});}}});})(window);