/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.ObjectStreamField;
import sandbox.java.io.Serializable;
import sandbox.java.io.StreamCorruptedException;
import sandbox.java.util.Spliterator;
import sandbox.java.util.concurrent.atomic.AtomicLong;
import sandbox.java.util.function.DoubleConsumer;
import sandbox.java.util.function.IntConsumer;
import sandbox.java.util.function.LongConsumer;
import sandbox.java.util.stream.DoubleStream;
import sandbox.java.util.stream.IntStream;
import sandbox.java.util.stream.LongStream;
import sandbox.java.util.stream.StreamSupport;
import sandbox.sun.misc.Unsafe;

public class Random
implements Serializable {
    static final long serialVersionUID = 3905348978240129619L;
    private final AtomicLong seed;
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    static final String BadBound = "bound must be positive";
    static final String BadRange = "bound must be greater than origin";
    static final String BadSize = "size must be non-negative";
    private static final AtomicLong seedUniquifier;
    private double nextNextGaussian;
    private boolean haveNextNextGaussian;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final Unsafe unsafe;
    private static final long seedOffset;

    public Random() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.seedUniquifier:()J");
        long l = Random.seedUniquifier();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
        long l2 = l ^ System.nanoTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.<init>:(J)V");
        this(l2);
    }

    private static long seedUniquifier() {
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.get:()J");
            long l = seedUniquifier.get();
            long l2 = l * 181783497276652981L;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.compareAndSet:(JJ)Z");
            boolean bl = seedUniquifier.compareAndSet(l, l2);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return l2;
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    public Random(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.haveNextNextGaussian = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = this.getClass();
        RuntimeCostAccounter.recordJump();
        if (clazz == Random.class) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicLong");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.initialScramble:(J)J");
            long l2 = Random.initialScramble(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.<init>:(J)V");
            this.seed = new AtomicLong(l2);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicLong");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.<init>:()V");
            this.seed = new AtomicLong();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.setSeed:(J)V");
            this.setSeed(l);
        }
    }

    private static long initialScramble(long l) {
        return (l ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    public synchronized void setSeed(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.initialScramble:(J)J");
        long l2 = Random.initialScramble(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.set:(J)V");
        this.seed.set(l2);
        this.haveNextNextGaussian = false;
    }

    protected int next(int n) {
        long l;
        boolean bl;
        AtomicLong atomicLong = this.seed;
        do {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.get:()J");
            long l2 = atomicLong.get();
            l = l2 * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.compareAndSet:(JJ)Z");
            bl = atomicLong.compareAndSet(l2, l);
            RuntimeCostAccounter.recordJump();
        } while (!bl);
        return (int)(l >>> 48 - n);
    }

    public void nextBytes(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.nextInt:()I");
            int n3 = this.nextInt();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
            int n4 = Math.min(n2 - n, 4);
            while (true) {
                int n5 = n4--;
                RuntimeCostAccounter.recordJump();
                if (n5 <= 0) break;
                byArray[n++] = (byte)n3;
                n3 >>= 8;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
        }
    }

    final long internalNextLong(long l, long l2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.nextLong:()J");
        long l3 = this.nextLong();
        RuntimeCostAccounter.recordJump();
        if (l < l2) {
            long l4 = l2 - l;
            long l5 = l4 - 1L;
            RuntimeCostAccounter.recordJump();
            if ((l4 & l5) == 0L) {
                l3 = (l3 & l5) + l;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (l4 > 0L) {
                    long l6 = l3 >>> 1;
                    while (true) {
                        l3 = l6 % l4;
                        RuntimeCostAccounter.recordJump();
                        if (l6 + l5 - l3 >= 0L) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.nextLong:()J");
                        l6 = this.nextLong() >>> 1;
                        RuntimeCostAccounter.recordJump();
                    }
                    l3 += l;
                    RuntimeCostAccounter.recordJump();
                } else {
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (l3 >= l) {
                            RuntimeCostAccounter.recordJump();
                            if (l3 < l2) break;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.nextLong:()J");
                        l3 = this.nextLong();
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
        }
        return l3;
    }

    final int internalNextInt(int n, int n2) {
        RuntimeCostAccounter.recordJump();
        if (n < n2) {
            int n3;
            int n4 = n2 - n;
            RuntimeCostAccounter.recordJump();
            if (n4 > 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.nextInt:(I)I");
                return this.nextInt(n4) + n;
            }
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.nextInt:()I");
                n3 = this.nextInt();
                RuntimeCostAccounter.recordJump();
                if (n3 < n) continue;
                RuntimeCostAccounter.recordJump();
                if (n3 < n2) break;
            }
            return n3;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.nextInt:()I");
        return this.nextInt();
    }

    final double internalNextDouble(double d, double d2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.nextDouble:()D");
        double d3 = this.nextDouble();
        RuntimeCostAccounter.recordJump();
        if (d < d2) {
            d3 = d3 * (d2 - d) + d;
            RuntimeCostAccounter.recordJump();
            if (d3 >= d2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.doubleToLongBits:(D)J");
                long l = Double.doubleToLongBits(d2) - 1L;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.longBitsToDouble:(J)D");
                d3 = Double.longBitsToDouble(l);
            }
        }
        return d3;
    }

    public int nextInt() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.next:(I)I");
        return this.next(32);
    }

    public int nextInt(int n) {
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadBound);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.next:(I)I");
        int n2 = this.next(31);
        int n3 = n - 1;
        RuntimeCostAccounter.recordJump();
        if ((n & n3) == 0) {
            n2 = (int)((long)n * (long)n2 >> 31);
            RuntimeCostAccounter.recordJump();
        } else {
            int n4 = n2;
            while (true) {
                n2 = n4 % n;
                RuntimeCostAccounter.recordJump();
                if (n4 - n2 + n3 >= 0) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.next:(I)I");
                n4 = this.next(31);
                RuntimeCostAccounter.recordJump();
            }
        }
        return n2;
    }

    public long nextLong() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.next:(I)I");
        long l = (long)this.next(32) << 32;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.next:(I)I");
        return l + (long)this.next(32);
    }

    public boolean nextBoolean() {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.next:(I)I");
        int n = this.next(1);
        RuntimeCostAccounter.recordJump();
        if (n != 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    public float nextFloat() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.next:(I)I");
        return (float)this.next(24) / 1.6777216E7f;
    }

    public double nextDouble() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.next:(I)I");
        long l = (long)this.next(26) << 27;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.next:(I)I");
        return (double)(l + (long)this.next(27)) * (double)1.110223E-16f;
    }

    public synchronized double nextGaussian() {
        double d;
        double d2;
        double d3;
        RuntimeCostAccounter.recordJump();
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.nextDouble:()D");
            d3 = 2.0 * this.nextDouble() - 1.0;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.nextDouble:()D");
            d2 = 2.0 * this.nextDouble() - 1.0;
            d = d3 * d3 + d2 * d2;
            RuntimeCostAccounter.recordJump();
            if (d >= 1.0) continue;
            RuntimeCostAccounter.recordJump();
            if (d != 0.0) break;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StrictMath.log:(D)D");
        double d4 = -2.0 * StrictMath.log(d) / d;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StrictMath.sqrt:(D)D");
        double d5 = StrictMath.sqrt(d4);
        this.nextNextGaussian = d2 * d5;
        this.haveNextNextGaussian = true;
        return d3 * d5;
    }

    public IntStream ints(long l) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadSize);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/Random$RandomIntsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random$RandomIntsSpliterator.<init>:(Ljava/util/Random;JJII)V");
        RandomIntsSpliterator randomIntsSpliterator = new RandomIntsSpliterator(this, 0L, l, Integer.MAX_VALUE, 0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(randomIntsSpliterator, false);
    }

    public IntStream ints() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Random$RandomIntsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random$RandomIntsSpliterator.<init>:(Ljava/util/Random;JJII)V");
        RandomIntsSpliterator randomIntsSpliterator = new RandomIntsSpliterator(this, 0L, Long.MAX_VALUE, Integer.MAX_VALUE, 0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(randomIntsSpliterator, false);
    }

    public IntStream ints(long l, int n, int n2) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadSize);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (n >= n2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/Random$RandomIntsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random$RandomIntsSpliterator.<init>:(Ljava/util/Random;JJII)V");
        RandomIntsSpliterator randomIntsSpliterator = new RandomIntsSpliterator(this, 0L, l, n, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(randomIntsSpliterator, false);
    }

    public IntStream ints(int n, int n2) {
        RuntimeCostAccounter.recordJump();
        if (n >= n2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/Random$RandomIntsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random$RandomIntsSpliterator.<init>:(Ljava/util/Random;JJII)V");
        RandomIntsSpliterator randomIntsSpliterator = new RandomIntsSpliterator(this, 0L, Long.MAX_VALUE, n, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(randomIntsSpliterator, false);
    }

    public LongStream longs(long l) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadSize);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/Random$RandomLongsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random$RandomLongsSpliterator.<init>:(Ljava/util/Random;JJJJ)V");
        RandomLongsSpliterator randomLongsSpliterator = new RandomLongsSpliterator(this, 0L, l, Long.MAX_VALUE, 0L);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        return StreamSupport.longStream(randomLongsSpliterator, false);
    }

    public LongStream longs() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Random$RandomLongsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random$RandomLongsSpliterator.<init>:(Ljava/util/Random;JJJJ)V");
        RandomLongsSpliterator randomLongsSpliterator = new RandomLongsSpliterator(this, 0L, Long.MAX_VALUE, Long.MAX_VALUE, 0L);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        return StreamSupport.longStream(randomLongsSpliterator, false);
    }

    public LongStream longs(long l, long l2, long l3) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadSize);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (l2 >= l3) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/Random$RandomLongsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random$RandomLongsSpliterator.<init>:(Ljava/util/Random;JJJJ)V");
        RandomLongsSpliterator randomLongsSpliterator = new RandomLongsSpliterator(this, 0L, l, l2, l3);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        return StreamSupport.longStream(randomLongsSpliterator, false);
    }

    public LongStream longs(long l, long l2) {
        RuntimeCostAccounter.recordJump();
        if (l >= l2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/Random$RandomLongsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random$RandomLongsSpliterator.<init>:(Ljava/util/Random;JJJJ)V");
        RandomLongsSpliterator randomLongsSpliterator = new RandomLongsSpliterator(this, 0L, Long.MAX_VALUE, l, l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        return StreamSupport.longStream(randomLongsSpliterator, false);
    }

    public DoubleStream doubles(long l) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadSize);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/Random$RandomDoublesSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random$RandomDoublesSpliterator.<init>:(Ljava/util/Random;JJDD)V");
        RandomDoublesSpliterator randomDoublesSpliterator = new RandomDoublesSpliterator(this, 0L, l, Double.MAX_VALUE, 0.0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.doubleStream:(Ljava/util/Spliterator$OfDouble;Z)Ljava/util/stream/DoubleStream;");
        return StreamSupport.doubleStream(randomDoublesSpliterator, false);
    }

    public DoubleStream doubles() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/Random$RandomDoublesSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random$RandomDoublesSpliterator.<init>:(Ljava/util/Random;JJDD)V");
        RandomDoublesSpliterator randomDoublesSpliterator = new RandomDoublesSpliterator(this, 0L, Long.MAX_VALUE, Double.MAX_VALUE, 0.0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.doubleStream:(Ljava/util/Spliterator$OfDouble;Z)Ljava/util/stream/DoubleStream;");
        return StreamSupport.doubleStream(randomDoublesSpliterator, false);
    }

    public DoubleStream doubles(long l, double d, double d2) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadSize);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (!(d < d2)) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/Random$RandomDoublesSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random$RandomDoublesSpliterator.<init>:(Ljava/util/Random;JJDD)V");
        RandomDoublesSpliterator randomDoublesSpliterator = new RandomDoublesSpliterator(this, 0L, l, d, d2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.doubleStream:(Ljava/util/Spliterator$OfDouble;Z)Ljava/util/stream/DoubleStream;");
        return StreamSupport.doubleStream(randomDoublesSpliterator, false);
    }

    public DoubleStream doubles(double d, double d2) {
        RuntimeCostAccounter.recordJump();
        if (!(d < d2)) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/Random$RandomDoublesSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random$RandomDoublesSpliterator.<init>:(Ljava/util/Random;JJDD)V");
        RandomDoublesSpliterator randomDoublesSpliterator = new RandomDoublesSpliterator(this, 0L, Long.MAX_VALUE, d, d2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.doubleStream:(Ljava/util/Spliterator$OfDouble;Z)Ljava/util/stream/DoubleStream;");
        return StreamSupport.doubleStream(randomDoublesSpliterator, false);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readFields:()Ljava/io/ObjectInputStream$GetField;");
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetField.get:(Ljava/lang/String;J)J");
        long l = getField.get("seed", -1L);
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException("Random: invalid seed");
            RuntimeCostAccounter.recordThrow();
            throw streamCorruptedException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.resetSeed:(J)V");
        this.resetSeed(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetField.get:(Ljava/lang/String;D)D");
        this.nextNextGaussian = getField.get("nextNextGaussian", 0.0);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream$GetField.get:(Ljava/lang/String;Z)Z");
        this.haveNextNextGaussian = getField.get("haveNextNextGaussian", false);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.putFields:()Ljava/io/ObjectOutputStream$PutField;");
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.get:()J");
        long l = this.seed.get();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutField.put:(Ljava/lang/String;J)V");
        putField.put("seed", l);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutField.put:(Ljava/lang/String;D)V");
        putField.put("nextNextGaussian", this.nextNextGaussian);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutField.put:(Ljava/lang/String;Z)V");
        putField.put("haveNextNextGaussian", this.haveNextNextGaussian);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeFields:()V");
        objectOutputStream.writeFields();
    }

    private void resetSeed(long l) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicLong");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.<init>:(J)V");
        AtomicLong atomicLong = new AtomicLong(l);
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putObjectVolatile:(Ljava/lang/Object;JLjava/lang/Object;)V");
        unsafe.putObjectVolatile((Object)this, seedOffset, (Object)atomicLong);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicLong");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.<init>:(J)V");
        seedUniquifier = new AtomicLong(8682522807148012L);
        RuntimeCostAccounter.recordArrayAllocation((int)3, (int)8);
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[3];
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectStreamField");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.<init>:(Ljava/lang/String;Ljava/lang/Class;)V");
        objectStreamFieldArray[0] = new ObjectStreamField("seed", Long.TYPE);
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectStreamField");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.<init>:(Ljava/lang/String;Ljava/lang/Class;)V");
        objectStreamFieldArray[1] = new ObjectStreamField("nextNextGaussian", Double.TYPE);
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectStreamField");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.<init>:(Ljava/lang/String;Ljava/lang/Class;)V");
        objectStreamFieldArray[2] = new ObjectStreamField("haveNextNextGaussian", Boolean.TYPE);
        serialPersistentFields = objectStreamFieldArray;
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
        unsafe = Unsafe.getUnsafe();
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = Random.class.getDeclaredField("seed");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            seedOffset = unsafe.objectFieldOffset(field);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(exception);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
    }

    static final class RandomDoublesSpliterator
    implements Spliterator.OfDouble {
        final Random rng;
        long index;
        final long fence;
        final double origin;
        final double bound;

        RandomDoublesSpliterator(Random random, long l, long l2, double d, double d2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.rng = random;
            this.index = l;
            this.fence = l2;
            this.origin = d;
            this.bound = d2;
        }

        @Override
        public RandomDoublesSpliterator trySplit() {
            RandomDoublesSpliterator randomDoublesSpliterator;
            long l = this.index;
            long l2 = l + this.fence >>> 1;
            RuntimeCostAccounter.recordJump();
            if (l2 <= l) {
                randomDoublesSpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Random$RandomDoublesSpliterator");
                this.index = l2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Random$RandomDoublesSpliterator.<init>:(Ljava/util/Random;JJDD)V");
                RandomDoublesSpliterator randomDoublesSpliterator2 = new RandomDoublesSpliterator(this.rng, l, this.index, this.origin, this.bound);
                randomDoublesSpliterator = randomDoublesSpliterator2;
            }
            return randomDoublesSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer doubleConsumer) {
            RuntimeCostAccounter.recordJump();
            if (doubleConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long l = this.index;
            long l2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.internalNextDouble:(DD)D");
                double d = this.rng.internalNextDouble(this.origin, this.bound);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleConsumer.accept:(D)V");
                doubleConsumer.accept(d);
                this.index = l + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
            RuntimeCostAccounter.recordJump();
            if (doubleConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long l = this.index;
            long l2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                this.index = l2;
                Random random = this.rng;
                double d = this.origin;
                double d2 = this.bound;
                do {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.internalNextDouble:(DD)D");
                    double d3 = random.internalNextDouble(d, d2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleConsumer.accept:(D)V");
                    doubleConsumer.accept(d3);
                    RuntimeCostAccounter.recordJump();
                } while (++l < l2);
            }
        }
    }

    static final class RandomLongsSpliterator
    implements Spliterator.OfLong {
        final Random rng;
        long index;
        final long fence;
        final long origin;
        final long bound;

        RandomLongsSpliterator(Random random, long l, long l2, long l3, long l4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.rng = random;
            this.index = l;
            this.fence = l2;
            this.origin = l3;
            this.bound = l4;
        }

        @Override
        public RandomLongsSpliterator trySplit() {
            RandomLongsSpliterator randomLongsSpliterator;
            long l = this.index;
            long l2 = l + this.fence >>> 1;
            RuntimeCostAccounter.recordJump();
            if (l2 <= l) {
                randomLongsSpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Random$RandomLongsSpliterator");
                this.index = l2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Random$RandomLongsSpliterator.<init>:(Ljava/util/Random;JJJJ)V");
                RandomLongsSpliterator randomLongsSpliterator2 = new RandomLongsSpliterator(this.rng, l, this.index, this.origin, this.bound);
                randomLongsSpliterator = randomLongsSpliterator2;
            }
            return randomLongsSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(LongConsumer longConsumer) {
            RuntimeCostAccounter.recordJump();
            if (longConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long l = this.index;
            long l2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.internalNextLong:(JJ)J");
                long l3 = this.rng.internalNextLong(this.origin, this.bound);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongConsumer.accept:(J)V");
                longConsumer.accept(l3);
                this.index = l + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
            RuntimeCostAccounter.recordJump();
            if (longConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long l = this.index;
            long l2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                this.index = l2;
                Random random = this.rng;
                long l3 = this.origin;
                long l4 = this.bound;
                do {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.internalNextLong:(JJ)J");
                    long l5 = random.internalNextLong(l3, l4);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongConsumer.accept:(J)V");
                    longConsumer.accept(l5);
                    RuntimeCostAccounter.recordJump();
                } while (++l < l2);
            }
        }
    }

    static final class RandomIntsSpliterator
    implements Spliterator.OfInt {
        final Random rng;
        long index;
        final long fence;
        final int origin;
        final int bound;

        RandomIntsSpliterator(Random random, long l, long l2, int n, int n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.rng = random;
            this.index = l;
            this.fence = l2;
            this.origin = n;
            this.bound = n2;
        }

        @Override
        public RandomIntsSpliterator trySplit() {
            RandomIntsSpliterator randomIntsSpliterator;
            long l = this.index;
            long l2 = l + this.fence >>> 1;
            RuntimeCostAccounter.recordJump();
            if (l2 <= l) {
                randomIntsSpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/Random$RandomIntsSpliterator");
                this.index = l2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Random$RandomIntsSpliterator.<init>:(Ljava/util/Random;JJII)V");
                RandomIntsSpliterator randomIntsSpliterator2 = new RandomIntsSpliterator(this.rng, l, this.index, this.origin, this.bound);
                randomIntsSpliterator = randomIntsSpliterator2;
            }
            return randomIntsSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            RuntimeCostAccounter.recordJump();
            if (intConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long l = this.index;
            long l2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.internalNextInt:(II)I");
                int n = this.rng.internalNextInt(this.origin, this.bound);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntConsumer.accept:(I)V");
                intConsumer.accept(n);
                this.index = l + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            RuntimeCostAccounter.recordJump();
            if (intConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long l = this.index;
            long l2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                this.index = l2;
                Random random = this.rng;
                int n = this.origin;
                int n2 = this.bound;
                do {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.internalNextInt:(II)I");
                    int n3 = random.internalNextInt(n, n2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntConsumer.accept:(I)V");
                    intConsumer.accept(n3);
                    RuntimeCostAccounter.recordJump();
                } while (++l < l2);
            }
        }
    }
}

