/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.function.DoubleConsumer;
import sandbox.java.util.function.DoubleSupplier;
import sandbox.java.util.function.Supplier;

public final class OptionalDouble {
    private static final OptionalDouble EMPTY;
    private final boolean isPresent;
    private final double value;

    private OptionalDouble() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.isPresent = false;
        this.value = Double.NaN;
    }

    public static OptionalDouble empty() {
        return EMPTY;
    }

    private OptionalDouble(double d) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.isPresent = true;
        this.value = d;
    }

    public static OptionalDouble of(double d) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/OptionalDouble");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/OptionalDouble.<init>:(D)V");
        return new OptionalDouble(d);
    }

    public double getAsDouble() {
        RuntimeCostAccounter.recordJump();
        if (!this.isPresent) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:(Ljava/lang/String;)V");
            NoSuchElementException noSuchElementException = new NoSuchElementException("No value present");
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void ifPresent(DoubleConsumer doubleConsumer) {
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleConsumer.accept:(D)V");
            doubleConsumer.accept(this.value);
        }
    }

    public double orElse(double d) {
        double d2;
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            d2 = this.value;
            RuntimeCostAccounter.recordJump();
        } else {
            d2 = d;
        }
        return d2;
    }

    public double orElseGet(DoubleSupplier doubleSupplier) {
        double d;
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            d = this.value;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleSupplier.getAsDouble:()D");
            d = doubleSupplier.getAsDouble();
        }
        return d;
    }

    public <X extends Throwable> double orElseThrow(Supplier<X> supplier) throws X {
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            return this.value;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Supplier.get:()Ljava/lang/Object;");
        Throwable throwable = (Throwable)supplier.get();
        RuntimeCostAccounter.recordThrow();
        throw throwable;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        boolean bl;
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl2 = object instanceof OptionalDouble;
        RuntimeCostAccounter.recordJump();
        if (!bl2) {
            return false;
        }
        OptionalDouble optionalDouble = (OptionalDouble)object;
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            boolean bl3 = optionalDouble.isPresent;
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                double d = optionalDouble.value;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.compare:(DD)I");
                int n = Double.compare(this.value, d);
                RuntimeCostAccounter.recordJump();
                if (n == 0) {
                    bl = true;
                    RuntimeCostAccounter.recordJump();
                    return bl;
                }
                bl = false;
                RuntimeCostAccounter.recordJump();
                return bl;
            }
        }
        boolean bl4 = optionalDouble.isPresent;
        RuntimeCostAccounter.recordJump();
        if (this.isPresent != bl4) return false;
        bl = true;
        RuntimeCostAccounter.recordJump();
        return bl;
    }

    public int hashCode() {
        int n;
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.hashCode:(D)I");
            n = Double.hashCode(this.value);
            RuntimeCostAccounter.recordJump();
        } else {
            n = 0;
        }
        return n;
    }

    public String toString() {
        String string;
        RuntimeCostAccounter.recordJump();
        if (this.isPresent) {
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
            Object[] objectArray = new Object[1];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.valueOf:(D)Ljava/lang/Double;");
            objectArray[0] = this.value;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
            string = String.format("OptionalDouble[%s]", objectArray);
            RuntimeCostAccounter.recordJump();
        } else {
            string = "OptionalDouble.empty";
        }
        return string;
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/OptionalDouble");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/OptionalDouble.<init>:()V");
        EMPTY = new OptionalDouble();
    }
}

