/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.temporal;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.time.LocalDate;
import sandbox.java.time.LocalTime;
import sandbox.java.time.ZoneId;
import sandbox.java.time.ZoneOffset;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.TemporalUnit;

public final class TemporalQueries {
    static final TemporalQuery<ZoneId> ZONE_ID = temporalAccessor -> {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return temporalAccessor.query(ZONE_ID);
    };
    static final TemporalQuery<Chronology> CHRONO = temporalAccessor -> {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return temporalAccessor.query(CHRONO);
    };
    static final TemporalQuery<TemporalUnit> PRECISION = temporalAccessor -> {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return temporalAccessor.query(PRECISION);
    };
    static final TemporalQuery<ZoneOffset> OFFSET = temporalAccessor -> {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.isSupported:(Ljava/time/temporal/TemporalField;)Z");
        boolean bl = temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.get:(Ljava/time/temporal/TemporalField;)I");
            int n = temporalAccessor.get(ChronoField.OFFSET_SECONDS);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
            return ZoneOffset.ofTotalSeconds(n);
        }
        return null;
    };
    static final TemporalQuery<ZoneId> ZONE = temporalAccessor -> {
        ZoneId zoneId;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        ZoneId zoneId2 = temporalAccessor.query(ZONE_ID);
        RuntimeCostAccounter.recordJump();
        if (zoneId2 != null) {
            zoneId = zoneId2;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
            zoneId = temporalAccessor.query(OFFSET);
        }
        return zoneId;
    };
    static final TemporalQuery<LocalDate> LOCAL_DATE = temporalAccessor -> {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.isSupported:(Ljava/time/temporal/TemporalField;)Z");
        boolean bl = temporalAccessor.isSupported(ChronoField.EPOCH_DAY);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.getLong:(Ljava/time/temporal/TemporalField;)J");
            long l = temporalAccessor.getLong(ChronoField.EPOCH_DAY);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.ofEpochDay:(J)Ljava/time/LocalDate;");
            return LocalDate.ofEpochDay(l);
        }
        return null;
    };
    static final TemporalQuery<LocalTime> LOCAL_TIME = temporalAccessor -> {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.isSupported:(Ljava/time/temporal/TemporalField;)Z");
        boolean bl = temporalAccessor.isSupported(ChronoField.NANO_OF_DAY);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.getLong:(Ljava/time/temporal/TemporalField;)J");
            long l = temporalAccessor.getLong(ChronoField.NANO_OF_DAY);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.ofNanoOfDay:(J)Ljava/time/LocalTime;");
            return LocalTime.ofNanoOfDay(l);
        }
        return null;
    };

    private TemporalQueries() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    public static TemporalQuery<ZoneId> zoneId() {
        return ZONE_ID;
    }

    public static TemporalQuery<Chronology> chronology() {
        return CHRONO;
    }

    public static TemporalQuery<TemporalUnit> precision() {
        return PRECISION;
    }

    public static TemporalQuery<ZoneId> zone() {
        return ZONE;
    }

    public static TemporalQuery<ZoneOffset> offset() {
        return OFFSET;
    }

    public static TemporalQuery<LocalDate> localDate() {
        return LOCAL_DATE;
    }

    public static TemporalQuery<LocalTime> localTime() {
        return LOCAL_TIME;
    }
}

