/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInput;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.Clock;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.DayOfWeek;
import sandbox.java.time.Instant;
import sandbox.java.time.LocalDate;
import sandbox.java.time.LocalDateTime;
import sandbox.java.time.LocalTime;
import sandbox.java.time.Month;
import sandbox.java.time.OffsetDateTime;
import sandbox.java.time.Period;
import sandbox.java.time.Ser;
import sandbox.java.time.ZoneId;
import sandbox.java.time.ZoneOffset;
import sandbox.java.time.chrono.ChronoZonedDateTime;
import sandbox.java.time.format.DateTimeFormatter;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.time.zone.ZoneOffsetTransition;
import sandbox.java.time.zone.ZoneRules;
import sandbox.java.util.Objects;

public final class ZonedDateTime
implements Temporal,
ChronoZonedDateTime<LocalDate>,
Serializable {
    private static final long serialVersionUID = -6260982410461394882L;
    private final LocalDateTime dateTime;
    private final ZoneOffset offset;
    private final ZoneId zone;

    public static ZonedDateTime now() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemDefaultZone:()Ljava/time/Clock;");
        Clock clock = Clock.systemDefaultZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.now:(Ljava/time/Clock;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.now(clock);
    }

    public static ZonedDateTime now(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.now:(Ljava/time/Clock;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.now(clock);
    }

    public static ZonedDateTime now(Clock clock) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(clock, "clock");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.instant:()Ljava/time/Instant;");
        Instant instant = clock.instant();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.getZone:()Ljava/time/ZoneId;");
        ZoneId zoneId = clock.getZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.ofInstant:(Ljava/time/Instant;Ljava/time/ZoneId;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.ofInstant(instant, zoneId);
    }

    public static ZonedDateTime of(LocalDate localDate, LocalTime localTime, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.of:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.of:(Ljava/time/LocalDateTime;Ljava/time/ZoneId;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.of(localDateTime, zoneId);
    }

    public static ZonedDateTime of(LocalDateTime localDateTime, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.ofLocal:(Ljava/time/LocalDateTime;Ljava/time/ZoneId;Ljava/time/ZoneOffset;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.ofLocal(localDateTime, zoneId, null);
    }

    public static ZonedDateTime of(int n, int n2, int n3, int n4, int n5, int n6, int n7, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.of:(IIIIIII)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = LocalDateTime.of(n, n2, n3, n4, n5, n6, n7);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.ofLocal:(Ljava/time/LocalDateTime;Ljava/time/ZoneId;Ljava/time/ZoneOffset;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.ofLocal(localDateTime, zoneId, null);
    }

    /*
     * Unable to fully structure code
     */
    public static ZonedDateTime ofLocal(LocalDateTime var0, ZoneId var1_1, ZoneOffset var2_2) {
        block4: {
            block5: {
                block3: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                    Objects.requireNonNull(var0, "localDateTime");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                    Objects.requireNonNull(var1_1, "zone");
                    v0 = var1_1 instanceof ZoneOffset;
                    RuntimeCostAccounter.recordJump();
                    if (v0) {
                        RuntimeCostAccounter.recordAllocation((String)"java/time/ZonedDateTime");
                        v1 = (ZoneOffset)var1_1;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneId;)V");
                        return new ZonedDateTime(var0, v1, var1_1);
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getRules:()Ljava/time/zone/ZoneRules;");
                    var3_3 = var1_1.getRules();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getValidOffsets:(Ljava/time/LocalDateTime;)Ljava/util/List;");
                    var4_4 = var3_3.getValidOffsets(var0);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
                    v2 = var4_4.size();
                    RuntimeCostAccounter.recordJump();
                    if (v2 != 1) break block3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
                    var5_5 = var4_4.get(0);
                    RuntimeCostAccounter.recordJump();
                    break block4;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
                v3 = var4_4.size();
                RuntimeCostAccounter.recordJump();
                if (v3 != 0) break block5;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getTransition:(Ljava/time/LocalDateTime;)Ljava/time/zone/ZoneOffsetTransition;");
                var6_6 = var3_3.getTransition(var0);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getDuration:()Ljava/time/Duration;");
                v4 = var6_6.getDuration();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/Duration.getSeconds:()J");
                v5 = v4.getSeconds();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusSeconds:(J)Ljava/time/LocalDateTime;");
                var0 = var0.plusSeconds(v5);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetAfter:()Ljava/time/ZoneOffset;");
                var5_5 = var6_6.getOffsetAfter();
                RuntimeCostAccounter.recordJump();
                break block4;
            }
            RuntimeCostAccounter.recordJump();
            if (var2_2 == null) ** GOTO lbl-1000
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.contains:(Ljava/lang/Object;)Z");
            v6 = var4_4.contains(var2_2);
            RuntimeCostAccounter.recordJump();
            if (v6) {
                var5_5 = var2_2;
                RuntimeCostAccounter.recordJump();
            } else lbl-1000:
            // 2 sources

            {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
                v7 = var4_4.get(0);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                var5_5 = Objects.requireNonNull(v7, "offset");
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/ZonedDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneId;)V");
        return new ZonedDateTime(var0, var5_5, var1_1);
    }

    public static ZonedDateTime ofInstant(Instant instant, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(instant, "instant");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneId, "zone");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getEpochSecond:()J");
        long l = instant.getEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getNano:()I");
        int n = instant.getNano();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.create:(JILjava/time/ZoneId;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.create(l, n, zoneId);
    }

    public static ZonedDateTime ofInstant(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(localDateTime, "localDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneOffset, "offset");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneId, "zone");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getRules:()Ljava/time/zone/ZoneRules;");
        ZoneRules zoneRules = zoneId.getRules();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.isValidOffset:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Z");
        boolean bl = zoneRules.isValidOffset(localDateTime, zoneOffset);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/ZonedDateTime");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneId;)V");
            return new ZonedDateTime(localDateTime, zoneOffset, zoneId);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.toEpochSecond:(Ljava/time/ZoneOffset;)J");
        long l = localDateTime.toEpochSecond(zoneOffset);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getNano:()I");
        int n = localDateTime.getNano();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.create:(JILjava/time/ZoneId;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.create(l, n, zoneId);
    }

    private static ZonedDateTime create(long l, int n, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getRules:()Ljava/time/zone/ZoneRules;");
        ZoneRules zoneRules = zoneId.getRules();
        long l2 = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.ofEpochSecond:(JJ)Ljava/time/Instant;");
        Instant instant = Instant.ofEpochSecond(l, l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getOffset:(Ljava/time/Instant;)Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.ofEpochSecond:(JILjava/time/ZoneOffset;)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(l, n, zoneOffset);
        RuntimeCostAccounter.recordAllocation((String)"java/time/ZonedDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneId;)V");
        return new ZonedDateTime(localDateTime, zoneOffset, zoneId);
    }

    public static ZonedDateTime ofStrict(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(localDateTime, "localDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneOffset, "offset");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneId, "zone");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getRules:()Ljava/time/zone/ZoneRules;");
        ZoneRules zoneRules = zoneId.getRules();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.isValidOffset:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Z");
        boolean bl = zoneRules.isValidOffset(localDateTime, zoneOffset);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getTransition:(Ljava/time/LocalDateTime;)Ljava/time/zone/ZoneOffsetTransition;");
            ZoneOffsetTransition zoneOffsetTransition = zoneRules.getTransition(localDateTime);
            RuntimeCostAccounter.recordJump();
            if (zoneOffsetTransition != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.isGap:()Z");
                boolean bl2 = zoneOffsetTransition.isGap();
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("LocalDateTime '");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(localDateTime);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder4 = stringBuilder3.append("' does not exist in zone '");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder5 = stringBuilder4.append(zoneId);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder6 = stringBuilder5.append("' due to a gap in the local time-line, typically caused by daylight savings");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder6.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                    DateTimeException dateTimeException = new DateTimeException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw dateTimeException;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder.append("ZoneOffset '");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder8 = stringBuilder7.append(zoneOffset);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder9 = stringBuilder8.append("' is not valid for LocalDateTime '");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder10 = stringBuilder9.append(localDateTime);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder11 = stringBuilder10.append("' in zone '");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder12 = stringBuilder11.append(zoneId);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder13 = stringBuilder12.append("'");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder13.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/ZonedDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneId;)V");
        return new ZonedDateTime(localDateTime, zoneOffset, zoneId);
    }

    private static ZonedDateTime ofLenient(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(localDateTime, "localDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneOffset, "offset");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneId, "zone");
        boolean bl = zoneId instanceof ZoneOffset;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
            boolean bl2 = zoneOffset.equals(zoneId);
            RuntimeCostAccounter.recordJump();
            if (!bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("ZoneId must match ZoneOffset");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/ZonedDateTime");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneId;)V");
        return new ZonedDateTime(localDateTime, zoneOffset, zoneId);
    }

    public static ZonedDateTime from(TemporalAccessor temporalAccessor) {
        boolean bl = temporalAccessor instanceof ZonedDateTime;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return (ZonedDateTime)temporalAccessor;
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/ZoneId;");
            ZoneId zoneId = ZoneId.from(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.isSupported:(Ljava/time/temporal/TemporalField;)Z");
            boolean bl2 = temporalAccessor.isSupported(ChronoField.INSTANT_SECONDS);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.getLong:(Ljava/time/temporal/TemporalField;)J");
                long l = temporalAccessor.getLong(ChronoField.INSTANT_SECONDS);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.get:(Ljava/time/temporal/TemporalField;)I");
                int n = temporalAccessor.get(ChronoField.NANO_OF_SECOND);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.create:(JILjava/time/ZoneId;)Ljava/time/ZonedDateTime;");
                return ZonedDateTime.create(l, n, zoneId);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalDate;");
            LocalDate localDate = LocalDate.from(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalTime;");
            LocalTime localTime = LocalTime.from(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.of:(Ljava/time/LocalDate;Ljava/time/LocalTime;Ljava/time/ZoneId;)Ljava/time/ZonedDateTime;");
            return ZonedDateTime.of(localDate, localTime, zoneId);
        }
        catch (DateTimeException dateTimeException) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unable to obtain ZonedDateTime from TemporalAccessor: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" of type ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = temporalAccessor.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
            String string = clazz.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            DateTimeException dateTimeException2 = new DateTimeException(string2, dateTimeException);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException2;
        }
    }

    public static ZonedDateTime parse(CharSequence charSequence) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.parse:(Ljava/lang/CharSequence;Ljava/time/format/DateTimeFormatter;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.parse(charSequence, DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    public static ZonedDateTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        TemporalQuery<ZonedDateTime> temporalQuery = ZonedDateTime::from;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parse:(Ljava/lang/CharSequence;Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return dateTimeFormatter.parse(charSequence, temporalQuery);
    }

    private ZonedDateTime(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.dateTime = localDateTime;
        this.offset = zoneOffset;
        this.zone = zoneId;
    }

    private ZonedDateTime resolveLocal(LocalDateTime localDateTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.ofLocal:(Ljava/time/LocalDateTime;Ljava/time/ZoneId;Ljava/time/ZoneOffset;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.ofLocal(localDateTime, this.zone, this.offset);
    }

    private ZonedDateTime resolveInstant(LocalDateTime localDateTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.ofInstant:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneId;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.ofInstant(localDateTime, this.offset, this.zone);
    }

    private ZonedDateTime resolveOffset(ZoneOffset zoneOffset) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
        boolean bl = zoneOffset.equals(this.offset);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getRules:()Ljava/time/zone/ZoneRules;");
            ZoneRules zoneRules = this.zone.getRules();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.isValidOffset:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Z");
            boolean bl2 = zoneRules.isValidOffset(this.dateTime, zoneOffset);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/ZonedDateTime");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneId;)V");
                return new ZonedDateTime(this.dateTime, zoneOffset, this.zone);
            }
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupported(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordJump();
            if (temporalField == null) return false;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.isSupportedBy:(Ljava/time/temporal/TemporalAccessor;)Z");
            boolean bl2 = temporalField.isSupportedBy(this);
            RuntimeCostAccounter.recordJump();
            if (!bl2) return false;
        }
        boolean bl3 = true;
        RuntimeCostAccounter.recordJump();
        return bl3;
    }

    @Override
    public boolean isSupported(TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.isSupported:(Ljava/time/temporal/TemporalUnit;)Z");
        return ChronoZonedDateTime.super.isSupported(temporalUnit);
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        block2: {
            block4: {
                block3: {
                    boolean bl = temporalField instanceof ChronoField;
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block2;
                    RuntimeCostAccounter.recordJump();
                    if (temporalField == ChronoField.INSTANT_SECONDS) break block3;
                    RuntimeCostAccounter.recordJump();
                    if (temporalField != ChronoField.OFFSET_SECONDS) break block4;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.range:()Ljava/time/temporal/ValueRange;");
                return temporalField.range();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.range:(Ljava/time/temporal/TemporalField;)Ljava/time/temporal/ValueRange;");
            return this.dateTime.range(temporalField);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.rangeRefinedBy:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/temporal/ValueRange;");
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
                    UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException("Invalid field 'InstantSeconds' for get() method, use getLong() instead");
                    RuntimeCostAccounter.recordThrow();
                    throw unsupportedTemporalTypeException;
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.getOffset:()Ljava/time/ZoneOffset;");
                    ZoneOffset zoneOffset = this.getOffset();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
                    return zoneOffset.getTotalSeconds();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.get:(Ljava/time/temporal/TemporalField;)I");
            return this.dateTime.get(temporalField);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.get:(Ljava/time/temporal/TemporalField;)I");
        return ChronoZonedDateTime.super.get(temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.toEpochSecond:()J");
                    return this.toEpochSecond();
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.getOffset:()Ljava/time/ZoneOffset;");
                    ZoneOffset zoneOffset = this.getOffset();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
                    return zoneOffset.getTotalSeconds();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getLong:(Ljava/time/temporal/TemporalField;)J");
            return this.dateTime.getLong(temporalField);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.getFrom:(Ljava/time/temporal/TemporalAccessor;)J");
        return temporalField.getFrom(this);
    }

    @Override
    public ZoneOffset getOffset() {
        return this.offset;
    }

    public ZonedDateTime withEarlierOffsetAtOverlap() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.getZone:()Ljava/time/ZoneId;");
        ZoneId zoneId = this.getZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getRules:()Ljava/time/zone/ZoneRules;");
        ZoneRules zoneRules = zoneId.getRules();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getTransition:(Ljava/time/LocalDateTime;)Ljava/time/zone/ZoneOffsetTransition;");
        ZoneOffsetTransition zoneOffsetTransition = zoneRules.getTransition(this.dateTime);
        RuntimeCostAccounter.recordJump();
        if (zoneOffsetTransition != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.isOverlap:()Z");
            boolean bl = zoneOffsetTransition.isOverlap();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetBefore:()Ljava/time/ZoneOffset;");
                ZoneOffset zoneOffset = zoneOffsetTransition.getOffsetBefore();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
                boolean bl2 = zoneOffset.equals(this.offset);
                RuntimeCostAccounter.recordJump();
                if (!bl2) {
                    RuntimeCostAccounter.recordAllocation((String)"java/time/ZonedDateTime");
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneId;)V");
                    return new ZonedDateTime(this.dateTime, zoneOffset, this.zone);
                }
            }
        }
        return this;
    }

    public ZonedDateTime withLaterOffsetAtOverlap() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.getZone:()Ljava/time/ZoneId;");
        ZoneId zoneId = this.getZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getRules:()Ljava/time/zone/ZoneRules;");
        ZoneRules zoneRules = zoneId.getRules();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.toLocalDateTime:()Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.toLocalDateTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getTransition:(Ljava/time/LocalDateTime;)Ljava/time/zone/ZoneOffsetTransition;");
        ZoneOffsetTransition zoneOffsetTransition = zoneRules.getTransition(localDateTime);
        RuntimeCostAccounter.recordJump();
        if (zoneOffsetTransition != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getOffsetAfter:()Ljava/time/ZoneOffset;");
            ZoneOffset zoneOffset = zoneOffsetTransition.getOffsetAfter();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
            boolean bl = zoneOffset.equals(this.offset);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/ZonedDateTime");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneId;)V");
                return new ZonedDateTime(this.dateTime, zoneOffset, this.zone);
            }
        }
        return this;
    }

    @Override
    public ZoneId getZone() {
        return this.zone;
    }

    public ZonedDateTime withZoneSameLocal(ZoneId zoneId) {
        ZonedDateTime zonedDateTime;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneId, "zone");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.equals:(Ljava/lang/Object;)Z");
        boolean bl = this.zone.equals(zoneId);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            zonedDateTime = this;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.ofLocal:(Ljava/time/LocalDateTime;Ljava/time/ZoneId;Ljava/time/ZoneOffset;)Ljava/time/ZonedDateTime;");
            zonedDateTime = ZonedDateTime.ofLocal(this.dateTime, zoneId, this.offset);
        }
        return zonedDateTime;
    }

    public ZonedDateTime withZoneSameInstant(ZoneId zoneId) {
        ZonedDateTime zonedDateTime;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneId, "zone");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.equals:(Ljava/lang/Object;)Z");
        boolean bl = this.zone.equals(zoneId);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            zonedDateTime = this;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.toEpochSecond:(Ljava/time/ZoneOffset;)J");
            long l = this.dateTime.toEpochSecond(this.offset);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getNano:()I");
            int n = this.dateTime.getNano();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.create:(JILjava/time/ZoneId;)Ljava/time/ZonedDateTime;");
            zonedDateTime = ZonedDateTime.create(l, n, zoneId);
        }
        return zonedDateTime;
    }

    public ZonedDateTime withFixedOffsetZone() {
        ZonedDateTime zonedDateTime;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.equals:(Ljava/lang/Object;)Z");
        boolean bl = this.zone.equals(this.offset);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            zonedDateTime = this;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordAllocation((String)"java/time/ZonedDateTime");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.<init>:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneId;)V");
            zonedDateTime = new ZonedDateTime(this.dateTime, this.offset, this.offset);
        }
        return zonedDateTime;
    }

    public LocalDateTime toLocalDateTime() {
        return this.dateTime;
    }

    @Override
    public LocalDate toLocalDate() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.toLocalDate:()Ljava/time/LocalDate;");
        return this.dateTime.toLocalDate();
    }

    public int getYear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getYear:()I");
        return this.dateTime.getYear();
    }

    public int getMonthValue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getMonthValue:()I");
        return this.dateTime.getMonthValue();
    }

    public Month getMonth() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getMonth:()Ljava/time/Month;");
        return this.dateTime.getMonth();
    }

    public int getDayOfMonth() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getDayOfMonth:()I");
        return this.dateTime.getDayOfMonth();
    }

    public int getDayOfYear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getDayOfYear:()I");
        return this.dateTime.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getDayOfWeek:()Ljava/time/DayOfWeek;");
        return this.dateTime.getDayOfWeek();
    }

    @Override
    public LocalTime toLocalTime() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
        return this.dateTime.toLocalTime();
    }

    public int getHour() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getHour:()I");
        return this.dateTime.getHour();
    }

    public int getMinute() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getMinute:()I");
        return this.dateTime.getMinute();
    }

    public int getSecond() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getSecond:()I");
        return this.dateTime.getSecond();
    }

    public int getNano() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getNano:()I");
        return this.dateTime.getNano();
    }

    @Override
    public ZonedDateTime with(TemporalAdjuster temporalAdjuster) {
        boolean bl = temporalAdjuster instanceof LocalDate;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            LocalDate localDate = (LocalDate)temporalAdjuster;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.toLocalTime:()Ljava/time/LocalTime;");
            LocalTime localTime = this.dateTime.toLocalTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.of:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
            return this.resolveLocal(localDateTime);
        }
        boolean bl2 = temporalAdjuster instanceof LocalTime;
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.toLocalDate:()Ljava/time/LocalDate;");
            LocalDate localDate = this.dateTime.toLocalDate();
            LocalTime localTime = (LocalTime)temporalAdjuster;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.of:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
            return this.resolveLocal(localDateTime);
        }
        boolean bl3 = temporalAdjuster instanceof LocalDateTime;
        RuntimeCostAccounter.recordJump();
        if (bl3) {
            LocalDateTime localDateTime = (LocalDateTime)temporalAdjuster;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
            return this.resolveLocal(localDateTime);
        }
        boolean bl4 = temporalAdjuster instanceof OffsetDateTime;
        RuntimeCostAccounter.recordJump();
        if (bl4) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)temporalAdjuster;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.toLocalDateTime:()Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime = offsetDateTime.toLocalDateTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.getOffset:()Ljava/time/ZoneOffset;");
            ZoneOffset zoneOffset = offsetDateTime.getOffset();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.ofLocal:(Ljava/time/LocalDateTime;Ljava/time/ZoneId;Ljava/time/ZoneOffset;)Ljava/time/ZonedDateTime;");
            return ZonedDateTime.ofLocal(localDateTime, this.zone, zoneOffset);
        }
        boolean bl5 = temporalAdjuster instanceof Instant;
        RuntimeCostAccounter.recordJump();
        if (bl5) {
            Instant instant = (Instant)temporalAdjuster;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getEpochSecond:()J");
            long l = instant.getEpochSecond();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getNano:()I");
            int n = instant.getNano();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.create:(JILjava/time/ZoneId;)Ljava/time/ZonedDateTime;");
            return ZonedDateTime.create(l, n, this.zone);
        }
        boolean bl6 = temporalAdjuster instanceof ZoneOffset;
        RuntimeCostAccounter.recordJump();
        if (bl6) {
            ZoneOffset zoneOffset = (ZoneOffset)temporalAdjuster;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveOffset:(Ljava/time/ZoneOffset;)Ljava/time/ZonedDateTime;");
            return this.resolveOffset(zoneOffset);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjuster.adjustInto:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (ZonedDateTime)temporalAdjuster.adjustInto(this);
    }

    @Override
    public ZonedDateTime with(TemporalField temporalField, long l) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.getNano:()I");
                    int n = this.getNano();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.create:(JILjava/time/ZoneId;)Ljava/time/ZonedDateTime;");
                    return ZonedDateTime.create(l, n, this.zone);
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
                    int n = chronoField.checkValidIntValue(l);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
                    ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveOffset:(Ljava/time/ZoneOffset;)Ljava/time/ZonedDateTime;");
                    return this.resolveOffset(zoneOffset);
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime = this.dateTime.with(temporalField, l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
            return this.resolveLocal(localDateTime);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.adjustInto:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        return temporalField.adjustInto(this, l);
    }

    public ZonedDateTime withYear(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.withYear:(I)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.withYear(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
        return this.resolveLocal(localDateTime);
    }

    public ZonedDateTime withMonth(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.withMonth:(I)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.withMonth(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
        return this.resolveLocal(localDateTime);
    }

    public ZonedDateTime withDayOfMonth(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.withDayOfMonth:(I)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.withDayOfMonth(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
        return this.resolveLocal(localDateTime);
    }

    public ZonedDateTime withDayOfYear(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.withDayOfYear:(I)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.withDayOfYear(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
        return this.resolveLocal(localDateTime);
    }

    public ZonedDateTime withHour(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.withHour:(I)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.withHour(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
        return this.resolveLocal(localDateTime);
    }

    public ZonedDateTime withMinute(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.withMinute:(I)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.withMinute(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
        return this.resolveLocal(localDateTime);
    }

    public ZonedDateTime withSecond(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.withSecond:(I)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.withSecond(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
        return this.resolveLocal(localDateTime);
    }

    public ZonedDateTime withNano(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.withNano:(I)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.withNano(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
        return this.resolveLocal(localDateTime);
    }

    public ZonedDateTime truncatedTo(TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.truncatedTo:(Ljava/time/temporal/TemporalUnit;)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.truncatedTo(temporalUnit);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
        return this.resolveLocal(localDateTime);
    }

    @Override
    public ZonedDateTime plus(TemporalAmount temporalAmount) {
        boolean bl = temporalAmount instanceof Period;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            Period period = (Period)temporalAmount;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime = this.dateTime.plus(period);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
            return this.resolveLocal(localDateTime);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAmount, "amountToAdd");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.addTo:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (ZonedDateTime)temporalAmount.addTo(this);
    }

    @Override
    public ZonedDateTime plus(long l, TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.isDateBased:()Z");
            boolean bl2 = temporalUnit.isDateBased();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/LocalDateTime;");
                LocalDateTime localDateTime = this.dateTime.plus(l, temporalUnit);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
                return this.resolveLocal(localDateTime);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime = this.dateTime.plus(l, temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveInstant:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
            return this.resolveInstant(localDateTime);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.addTo:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        return temporalUnit.addTo(this, l);
    }

    public ZonedDateTime plusYears(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusYears:(J)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.plusYears(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
        return this.resolveLocal(localDateTime);
    }

    public ZonedDateTime plusMonths(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusMonths:(J)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.plusMonths(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
        return this.resolveLocal(localDateTime);
    }

    public ZonedDateTime plusWeeks(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusWeeks:(J)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.plusWeeks(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
        return this.resolveLocal(localDateTime);
    }

    public ZonedDateTime plusDays(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusDays:(J)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.plusDays(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
        return this.resolveLocal(localDateTime);
    }

    public ZonedDateTime plusHours(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusHours:(J)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.plusHours(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveInstant:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
        return this.resolveInstant(localDateTime);
    }

    public ZonedDateTime plusMinutes(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusMinutes:(J)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.plusMinutes(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveInstant:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
        return this.resolveInstant(localDateTime);
    }

    public ZonedDateTime plusSeconds(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusSeconds:(J)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.plusSeconds(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveInstant:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
        return this.resolveInstant(localDateTime);
    }

    public ZonedDateTime plusNanos(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusNanos:(J)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.dateTime.plusNanos(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveInstant:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
        return this.resolveInstant(localDateTime);
    }

    @Override
    public ZonedDateTime minus(TemporalAmount temporalAmount) {
        boolean bl = temporalAmount instanceof Period;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            Period period = (Period)temporalAmount;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.minus:(Ljava/time/temporal/TemporalAmount;)Ljava/time/LocalDateTime;");
            LocalDateTime localDateTime = this.dateTime.minus(period);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.resolveLocal:(Ljava/time/LocalDateTime;)Ljava/time/ZonedDateTime;");
            return this.resolveLocal(localDateTime);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAmount, "amountToSubtract");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.subtractFrom:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (ZonedDateTime)temporalAmount.subtractFrom(this);
    }

    @Override
    public ZonedDateTime minus(long l, TemporalUnit temporalUnit) {
        ZonedDateTime zonedDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/ZonedDateTime;");
            ZonedDateTime zonedDateTime2 = this.plus(Long.MAX_VALUE, temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/ZonedDateTime;");
            zonedDateTime = zonedDateTime2.plus(1L, temporalUnit);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/ZonedDateTime;");
            zonedDateTime = this.plus(l2, temporalUnit);
        }
        return zonedDateTime;
    }

    public ZonedDateTime minusYears(long l) {
        ZonedDateTime zonedDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusYears:(J)Ljava/time/ZonedDateTime;");
            ZonedDateTime zonedDateTime2 = this.plusYears(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusYears:(J)Ljava/time/ZonedDateTime;");
            zonedDateTime = zonedDateTime2.plusYears(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusYears:(J)Ljava/time/ZonedDateTime;");
            zonedDateTime = this.plusYears(l2);
        }
        return zonedDateTime;
    }

    public ZonedDateTime minusMonths(long l) {
        ZonedDateTime zonedDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusMonths:(J)Ljava/time/ZonedDateTime;");
            ZonedDateTime zonedDateTime2 = this.plusMonths(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusMonths:(J)Ljava/time/ZonedDateTime;");
            zonedDateTime = zonedDateTime2.plusMonths(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusMonths:(J)Ljava/time/ZonedDateTime;");
            zonedDateTime = this.plusMonths(l2);
        }
        return zonedDateTime;
    }

    public ZonedDateTime minusWeeks(long l) {
        ZonedDateTime zonedDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusWeeks:(J)Ljava/time/ZonedDateTime;");
            ZonedDateTime zonedDateTime2 = this.plusWeeks(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusWeeks:(J)Ljava/time/ZonedDateTime;");
            zonedDateTime = zonedDateTime2.plusWeeks(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusWeeks:(J)Ljava/time/ZonedDateTime;");
            zonedDateTime = this.plusWeeks(l2);
        }
        return zonedDateTime;
    }

    public ZonedDateTime minusDays(long l) {
        ZonedDateTime zonedDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusDays:(J)Ljava/time/ZonedDateTime;");
            ZonedDateTime zonedDateTime2 = this.plusDays(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusDays:(J)Ljava/time/ZonedDateTime;");
            zonedDateTime = zonedDateTime2.plusDays(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusDays:(J)Ljava/time/ZonedDateTime;");
            zonedDateTime = this.plusDays(l2);
        }
        return zonedDateTime;
    }

    public ZonedDateTime minusHours(long l) {
        ZonedDateTime zonedDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusHours:(J)Ljava/time/ZonedDateTime;");
            ZonedDateTime zonedDateTime2 = this.plusHours(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusHours:(J)Ljava/time/ZonedDateTime;");
            zonedDateTime = zonedDateTime2.plusHours(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusHours:(J)Ljava/time/ZonedDateTime;");
            zonedDateTime = this.plusHours(l2);
        }
        return zonedDateTime;
    }

    public ZonedDateTime minusMinutes(long l) {
        ZonedDateTime zonedDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusMinutes:(J)Ljava/time/ZonedDateTime;");
            ZonedDateTime zonedDateTime2 = this.plusMinutes(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusMinutes:(J)Ljava/time/ZonedDateTime;");
            zonedDateTime = zonedDateTime2.plusMinutes(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusMinutes:(J)Ljava/time/ZonedDateTime;");
            zonedDateTime = this.plusMinutes(l2);
        }
        return zonedDateTime;
    }

    public ZonedDateTime minusSeconds(long l) {
        ZonedDateTime zonedDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusSeconds:(J)Ljava/time/ZonedDateTime;");
            ZonedDateTime zonedDateTime2 = this.plusSeconds(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusSeconds:(J)Ljava/time/ZonedDateTime;");
            zonedDateTime = zonedDateTime2.plusSeconds(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusSeconds:(J)Ljava/time/ZonedDateTime;");
            zonedDateTime = this.plusSeconds(l2);
        }
        return zonedDateTime;
    }

    public ZonedDateTime minusNanos(long l) {
        ZonedDateTime zonedDateTime;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusNanos:(J)Ljava/time/ZonedDateTime;");
            ZonedDateTime zonedDateTime2 = this.plusNanos(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusNanos:(J)Ljava/time/ZonedDateTime;");
            zonedDateTime = zonedDateTime2.plusNanos(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.plusNanos:(J)Ljava/time/ZonedDateTime;");
            zonedDateTime = this.plusNanos(l2);
        }
        return zonedDateTime;
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localDate:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<LocalDate> temporalQuery2 = TemporalQueries.localDate();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.toLocalDate:()Ljava/time/LocalDate;");
            return (R)this.toLocalDate();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoZonedDateTime.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return ChronoZonedDateTime.super.query(temporalQuery);
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/ZonedDateTime;");
        ZonedDateTime zonedDateTime = ZonedDateTime.from(temporal);
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.withZoneSameInstant:(Ljava/time/ZoneId;)Ljava/time/ZonedDateTime;");
            zonedDateTime = zonedDateTime.withZoneSameInstant(this.zone);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.isDateBased:()Z");
            boolean bl2 = temporalUnit.isDateBased();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                LocalDateTime localDateTime = zonedDateTime.dateTime;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.until:(Ljava/time/temporal/Temporal;Ljava/time/temporal/TemporalUnit;)J");
                return this.dateTime.until(localDateTime, temporalUnit);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.toOffsetDateTime:()Ljava/time/OffsetDateTime;");
            OffsetDateTime offsetDateTime = this.toOffsetDateTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.toOffsetDateTime:()Ljava/time/OffsetDateTime;");
            OffsetDateTime offsetDateTime2 = zonedDateTime.toOffsetDateTime();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.until:(Ljava/time/temporal/Temporal;Ljava/time/temporal/TemporalUnit;)J");
            return offsetDateTime.until(offsetDateTime2, temporalUnit);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.between:(Ljava/time/temporal/Temporal;Ljava/time/temporal/Temporal;)J");
        return temporalUnit.between(this, zonedDateTime);
    }

    @Override
    public String format(DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.format:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/String;");
        return dateTimeFormatter.format(this);
    }

    public OffsetDateTime toOffsetDateTime() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.of:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return OffsetDateTime.of(this.dateTime, this.offset);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof ZonedDateTime;
        RuntimeCostAccounter.recordJump();
        if (!bl) return false;
        ZonedDateTime zonedDateTime = (ZonedDateTime)object;
        LocalDateTime localDateTime = zonedDateTime.dateTime;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.equals:(Ljava/lang/Object;)Z");
        boolean bl2 = this.dateTime.equals(localDateTime);
        RuntimeCostAccounter.recordJump();
        if (!bl2) return false;
        ZoneOffset zoneOffset = zonedDateTime.offset;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.equals:(Ljava/lang/Object;)Z");
        boolean bl3 = this.offset.equals(zoneOffset);
        RuntimeCostAccounter.recordJump();
        if (!bl3) return false;
        ZoneId zoneId = zonedDateTime.zone;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.equals:(Ljava/lang/Object;)Z");
        boolean bl4 = this.zone.equals(zoneId);
        RuntimeCostAccounter.recordJump();
        if (!bl4) return false;
        boolean bl5 = true;
        RuntimeCostAccounter.recordJump();
        return bl5;
    }

    @Override
    public int hashCode() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.hashCode:()I");
        int n = this.dateTime.hashCode();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.hashCode:()I");
        int n2 = n ^ this.offset.hashCode();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.hashCode:()I");
        int n3 = this.zone.hashCode();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.rotateLeft:(II)I");
        return n2 ^ Integer.rotateLeft(n3, 3);
    }

    @Override
    public String toString() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.toString:()Ljava/lang/String;");
        String string = this.dateTime.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.toString:()Ljava/lang/String;");
        String string2 = this.offset.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string3 = stringBuilder3.toString();
        RuntimeCostAccounter.recordJump();
        if (this.offset != this.zone) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder4 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append('[');
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.toString:()Ljava/lang/String;");
            String string4 = this.zone.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder6.append(string4);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder8 = stringBuilder7.append(']');
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            string3 = stringBuilder8.toString();
        }
        return string3;
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(6, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.writeExternal:(Ljava/io/DataOutput;)V");
        this.dateTime.writeExternal(dataOutput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.writeExternal:(Ljava/io/DataOutput;)V");
        this.offset.writeExternal(dataOutput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.write:(Ljava/io/DataOutput;)V");
        this.zone.write(dataOutput);
    }

    static ZonedDateTime readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.readExternal:(Ljava/io/DataInput;)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = LocalDateTime.readExternal(objectInput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.readExternal:(Ljava/io/DataInput;)Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = ZoneOffset.readExternal(objectInput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Ser.read:(Ljava/io/ObjectInput;)Ljava/lang/Object;");
        ZoneId zoneId = (ZoneId)Ser.read(objectInput);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.ofLenient:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;Ljava/time/ZoneId;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.ofLenient(localDateTime, zoneOffset, zoneId);
    }
}

