/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.DataInput;
import sandbox.java.io.DataOutput;
import sandbox.java.io.IOException;
import sandbox.java.io.InvalidObjectException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.Serializable;
import sandbox.java.time.Clock;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.DayOfWeek;
import sandbox.java.time.Instant;
import sandbox.java.time.LocalDateTime;
import sandbox.java.time.LocalTime;
import sandbox.java.time.Month;
import sandbox.java.time.OffsetDateTime;
import sandbox.java.time.OffsetTime;
import sandbox.java.time.Period;
import sandbox.java.time.Ser;
import sandbox.java.time.ZoneId;
import sandbox.java.time.ZoneOffset;
import sandbox.java.time.ZonedDateTime;
import sandbox.java.time.chrono.ChronoLocalDate;
import sandbox.java.time.chrono.Era;
import sandbox.java.time.chrono.IsoChronology;
import sandbox.java.time.format.DateTimeFormatter;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.ChronoUnit;
import sandbox.java.time.temporal.Temporal;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalAdjuster;
import sandbox.java.time.temporal.TemporalAmount;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.TemporalUnit;
import sandbox.java.time.temporal.UnsupportedTemporalTypeException;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.time.zone.ZoneOffsetTransition;
import sandbox.java.time.zone.ZoneRules;
import sandbox.java.util.Objects;

public final class LocalDate
implements Temporal,
TemporalAdjuster,
ChronoLocalDate,
Serializable {
    public static final LocalDate MIN;
    public static final LocalDate MAX;
    private static final long serialVersionUID = 2942565459149668126L;
    private static final int DAYS_PER_CYCLE = 146097;
    static final long DAYS_0000_TO_1970 = 719528L;
    private final int year;
    private final short month;
    private final short day;

    public static LocalDate now() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.systemDefaultZone:()Ljava/time/Clock;");
        Clock clock = Clock.systemDefaultZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.now:(Ljava/time/Clock;)Ljava/time/LocalDate;");
        return LocalDate.now(clock);
    }

    public static LocalDate now(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.system:(Ljava/time/ZoneId;)Ljava/time/Clock;");
        Clock clock = Clock.system(zoneId);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.now:(Ljava/time/Clock;)Ljava/time/LocalDate;");
        return LocalDate.now(clock);
    }

    public static LocalDate now(Clock clock) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(clock, "clock");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.instant:()Ljava/time/Instant;");
        Instant instant = clock.instant();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Clock.getZone:()Ljava/time/ZoneId;");
        ZoneId zoneId = clock.getZone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getRules:()Ljava/time/zone/ZoneRules;");
        ZoneRules zoneRules = zoneId.getRules();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getOffset:(Ljava/time/Instant;)Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.getEpochSecond:()J");
        long l = instant.getEpochSecond();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.getTotalSeconds:()I");
        long l2 = l + (long)zoneOffset.getTotalSeconds();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorDiv:(JJ)J");
        long l3 = Math.floorDiv(l2, 86400L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.ofEpochDay:(J)Ljava/time/LocalDate;");
        return LocalDate.ofEpochDay(l3);
    }

    public static LocalDate of(int n, Month month, int n2) {
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.YEAR.checkValidValue(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(month, "month");
        long l2 = n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.DAY_OF_MONTH.checkValidValue(l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.getValue:()I");
        int n3 = month.getValue();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.create:(III)Ljava/time/LocalDate;");
        return LocalDate.create(n, n3, n2);
    }

    public static LocalDate of(int n, int n2, int n3) {
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.YEAR.checkValidValue(l);
        long l2 = n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.MONTH_OF_YEAR.checkValidValue(l2);
        long l3 = n3;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.DAY_OF_MONTH.checkValidValue(l3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.create:(III)Ljava/time/LocalDate;");
        return LocalDate.create(n, n2, n3);
    }

    public static LocalDate ofYearDay(int n, int n2) {
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.YEAR.checkValidValue(l);
        long l2 = n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.DAY_OF_YEAR.checkValidValue(l2);
        long l3 = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.isLeapYear:(J)Z");
        boolean bl = IsoChronology.INSTANCE.isLeapYear(l3);
        RuntimeCostAccounter.recordJump();
        if (n2 == 366) {
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Invalid date 'DayOfYear 366' as '");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append("' is not a leap year");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder4.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                DateTimeException dateTimeException = new DateTimeException(string);
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
        }
        int n3 = (n2 - 1) / 31 + 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.of:(I)Ljava/time/Month;");
        Month month = Month.of(n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.firstDayOfYear:(Z)I");
        int n4 = month.firstDayOfYear(bl);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.length:(Z)I");
        int n5 = n4 + month.length(bl) - 1;
        RuntimeCostAccounter.recordJump();
        if (n2 > n5) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.plus:(J)Ljava/time/Month;");
            month = month.plus(1L);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.firstDayOfYear:(Z)I");
        int n6 = n2 - month.firstDayOfYear(bl) + 1;
        RuntimeCostAccounter.recordAllocation((String)"java/time/LocalDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.getValue:()I");
        int n7 = month.getValue();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.<init>:(III)V");
        return new LocalDate(n, n7, n6);
    }

    public static LocalDate ofEpochDay(long l) {
        long l2;
        long l3 = l + 719528L;
        long l4 = 0L;
        RuntimeCostAccounter.recordJump();
        if ((l3 -= 60L) < 0L) {
            l2 = (l3 + 1L) / 146097L - 1L;
            l4 = l2 * 400L;
            l3 += -l2 * 146097L;
        }
        l2 = (400L * l3 + 591L) / 146097L;
        long l5 = l3 - (365L * l2 + l2 / 4L - l2 / 100L + l2 / 400L);
        RuntimeCostAccounter.recordJump();
        if (l5 < 0L) {
            l5 = l3 - (365L * --l2 + l2 / 4L - l2 / 100L + l2 / 400L);
        }
        l2 += l4;
        int n = (int)l5;
        int n2 = (n * 5 + 2) / 153;
        int n3 = (n2 + 2) % 12 + 1;
        int n4 = n - (n2 * 306 + 5) / 10 + 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
        int n5 = ChronoField.YEAR.checkValidIntValue(l2 += (long)(n2 / 10));
        RuntimeCostAccounter.recordAllocation((String)"java/time/LocalDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.<init>:(III)V");
        return new LocalDate(n5, n3, n4);
    }

    public static LocalDate from(TemporalAccessor temporalAccessor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAccessor, "temporal");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localDate:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<LocalDate> temporalQuery = TemporalQueries.localDate();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        LocalDate localDate = temporalAccessor.query(temporalQuery);
        RuntimeCostAccounter.recordJump();
        if (localDate == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unable to obtain LocalDate from TemporalAccessor: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(" of type ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = temporalAccessor.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
            String string = clazz.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
            DateTimeException dateTimeException = new DateTimeException(string2);
            RuntimeCostAccounter.recordThrow();
            throw dateTimeException;
        }
        return localDate;
    }

    public static LocalDate parse(CharSequence charSequence) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.parse:(Ljava/lang/CharSequence;Ljava/time/format/DateTimeFormatter;)Ljava/time/LocalDate;");
        return LocalDate.parse(charSequence, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static LocalDate parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        TemporalQuery<LocalDate> temporalQuery = LocalDate::from;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.parse:(Ljava/lang/CharSequence;Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return dateTimeFormatter.parse(charSequence, temporalQuery);
    }

    private static LocalDate create(int n, int n2, int n3) {
        RuntimeCostAccounter.recordJump();
        if (n3 > 28) {
            int n4 = 31;
            switch (n2) {
                case 2: {
                    int n5;
                    long l = n;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.isLeapYear:(J)Z");
                    boolean bl = IsoChronology.INSTANCE.isLeapYear(l);
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        n5 = 29;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n5 = 28;
                    }
                    n4 = n5;
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    n4 = 30;
                }
            }
            RuntimeCostAccounter.recordJump();
            if (n3 > n4) {
                RuntimeCostAccounter.recordJump();
                if (n3 == 29) {
                    RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("Invalid date 'February 29' as '");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(n);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder4 = stringBuilder3.append("' is not a leap year");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder4.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                    DateTimeException dateTimeException = new DateTimeException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw dateTimeException;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder.append("Invalid date '");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.of:(I)Ljava/time/Month;");
                Month month = Month.of(n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.name:()Ljava/lang/String;");
                String string = month.name();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder5.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder7 = stringBuilder6.append(" ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder8 = stringBuilder7.append(n3);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder9 = stringBuilder8.append("'");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string2 = stringBuilder9.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                DateTimeException dateTimeException = new DateTimeException(string2);
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/LocalDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.<init>:(III)V");
        return new LocalDate(n, n2, n3);
    }

    private static LocalDate resolvePreviousValid(int n, int n2, int n3) {
        switch (n2) {
            case 2: {
                int n4;
                long l = n;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.isLeapYear:(J)Z");
                boolean bl = IsoChronology.INSTANCE.isLeapYear(l);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    n4 = 29;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n4 = 28;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                n3 = Math.min(n3, n4);
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                n3 = Math.min(n3, 30);
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/LocalDate");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.<init>:(III)V");
        return new LocalDate(n, n2, n3);
    }

    private LocalDate(int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.year = n;
        this.month = (short)n2;
        this.day = (short)n3;
    }

    @Override
    public boolean isSupported(TemporalField temporalField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.isSupported:(Ljava/time/temporal/TemporalField;)Z");
        return ChronoLocalDate.super.isSupported(temporalField);
    }

    @Override
    public boolean isSupported(TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.isSupported:(Ljava/time/temporal/TemporalUnit;)Z");
        return ChronoLocalDate.super.isSupported(temporalUnit);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ValueRange range(TemporalField var1_1) {
        block10: {
            block11: {
                v0 = var1_1 instanceof ChronoField;
                RuntimeCostAccounter.recordJump();
                if (!v0) break block10;
                var2_2 = (ChronoField)var1_1;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.isDateBased:()Z");
                v1 = var2_2.isDateBased();
                RuntimeCostAccounter.recordJump();
                if (!v1) break block11;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
                switch (1.$SwitchMap$java$time$temporal$ChronoField[var2_2.ordinal()]) {
                    case 1: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.lengthOfMonth:()I");
                        v2 = this.lengthOfMonth();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                        return ValueRange.of(1L, v2);
                    }
                    case 2: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.lengthOfYear:()I");
                        v3 = this.lengthOfYear();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                        return ValueRange.of(1L, v3);
                    }
                    case 3: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getMonth:()Ljava/time/Month;");
                        v4 = this.getMonth();
                        RuntimeCostAccounter.recordJump();
                        if (v4 != Month.FEBRUARY) ** GOTO lbl-1000
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.isLeapYear:()Z");
                        v5 = this.isLeapYear();
                        RuntimeCostAccounter.recordJump();
                        if (!v5) {
                            v6 = 4L;
                            RuntimeCostAccounter.recordJump();
                        } else lbl-1000:
                        // 2 sources

                        {
                            v6 = 5L;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                        return ValueRange.of(1L, v6);
                    }
                    case 4: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getYear:()I");
                        v7 = this.getYear();
                        RuntimeCostAccounter.recordJump();
                        if (v7 <= 0) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                            v8 = ValueRange.of(1L, 1000000000L);
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.of:(JJ)Ljava/time/temporal/ValueRange;");
                            v8 = ValueRange.of(1L, 999999999L);
                        }
                        return v8;
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.range:()Ljava/time/temporal/ValueRange;");
                return var1_1.range();
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            v9 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            v10 = v9.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            v11 = v10.append(var1_1);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            v12 = v11.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            v13 = new UnsupportedTemporalTypeException(v12);
            RuntimeCostAccounter.recordThrow();
            throw v13;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.rangeRefinedBy:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/temporal/ValueRange;");
        return var1_1.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.get0:(Ljava/time/temporal/TemporalField;)I");
            return this.get0(temporalField);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.get:(Ljava/time/temporal/TemporalField;)I");
        return ChronoLocalDate.super.get(temporalField);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordJump();
            if (temporalField == ChronoField.EPOCH_DAY) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.toEpochDay:()J");
                return this.toEpochDay();
            }
            RuntimeCostAccounter.recordJump();
            if (temporalField == ChronoField.PROLEPTIC_MONTH) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getProlepticMonth:()J");
                return this.getProlepticMonth();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.get0:(Ljava/time/temporal/TemporalField;)I");
            return this.get0(temporalField);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.getFrom:(Ljava/time/temporal/TemporalAccessor;)J");
        return temporalField.getFrom(this);
    }

    private int get0(TemporalField temporalField) {
        ChronoField chronoField = (ChronoField)temporalField;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
        switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
            case 5: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getDayOfWeek:()Ljava/time/DayOfWeek;");
                DayOfWeek dayOfWeek = this.getDayOfWeek();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.getValue:()I");
                return dayOfWeek.getValue();
            }
            case 6: {
                return (this.day - 1) % 7 + 1;
            }
            case 7: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getDayOfYear:()I");
                return (this.getDayOfYear() - 1) % 7 + 1;
            }
            case 1: {
                return this.day;
            }
            case 2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getDayOfYear:()I");
                return this.getDayOfYear();
            }
            case 8: {
                RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
                UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException("Invalid field 'EpochDay' for get() method, use getLong() instead");
                RuntimeCostAccounter.recordThrow();
                throw unsupportedTemporalTypeException;
            }
            case 3: {
                return (this.day - 1) / 7 + 1;
            }
            case 9: {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getDayOfYear:()I");
                return (this.getDayOfYear() - 1) / 7 + 1;
            }
            case 10: {
                return this.month;
            }
            case 11: {
                RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
                UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException("Invalid field 'ProlepticMonth' for get() method, use getLong() instead");
                RuntimeCostAccounter.recordThrow();
                throw unsupportedTemporalTypeException;
            }
            case 4: {
                int n;
                RuntimeCostAccounter.recordJump();
                if (this.year >= 1) {
                    n = this.year;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n = 1 - this.year;
                }
                return n;
            }
            case 12: {
                return this.year;
            }
            case 13: {
                int n;
                RuntimeCostAccounter.recordJump();
                if (this.year >= 1) {
                    n = 1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n = 0;
                }
                return n;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string = stringBuilder3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
        UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
        RuntimeCostAccounter.recordThrow();
        throw unsupportedTemporalTypeException;
    }

    private long getProlepticMonth() {
        return (long)this.year * 12L + (long)this.month - 1L;
    }

    @Override
    public IsoChronology getChronology() {
        return IsoChronology.INSTANCE;
    }

    @Override
    public Era getEra() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.getEra:()Ljava/time/chrono/Era;");
        return ChronoLocalDate.super.getEra();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonthValue() {
        return this.month;
    }

    public Month getMonth() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.of:(I)Ljava/time/Month;");
        return Month.of(this.month);
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getDayOfYear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getMonth:()Ljava/time/Month;");
        Month month = this.getMonth();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.isLeapYear:()Z");
        boolean bl = this.isLeapYear();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Month.firstDayOfYear:(Z)I");
        return month.firstDayOfYear(bl) + this.day - 1;
    }

    public DayOfWeek getDayOfWeek() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.toEpochDay:()J");
        long l = this.toEpochDay() + 3L;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
        int n = (int)Math.floorMod(l, 7L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.of:(I)Ljava/time/DayOfWeek;");
        return DayOfWeek.of(n + 1);
    }

    @Override
    public boolean isLeapYear() {
        long l = this.year;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/IsoChronology.isLeapYear:(J)Z");
        return IsoChronology.INSTANCE.isLeapYear(l);
    }

    @Override
    public int lengthOfMonth() {
        switch (this.month) {
            case 2: {
                int n;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.isLeapYear:()Z");
                boolean bl = this.isLeapYear();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    n = 29;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n = 28;
                }
                return n;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    @Override
    public int lengthOfYear() {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.isLeapYear:()Z");
        boolean bl = this.isLeapYear();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            n = 366;
            RuntimeCostAccounter.recordJump();
        } else {
            n = 365;
        }
        return n;
    }

    @Override
    public LocalDate with(TemporalAdjuster temporalAdjuster) {
        boolean bl = temporalAdjuster instanceof LocalDate;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            return (LocalDate)temporalAdjuster;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAdjuster.adjustInto:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (LocalDate)temporalAdjuster.adjustInto(this);
    }

    @Override
    public LocalDate with(TemporalField temporalField, long l) {
        boolean bl = temporalField instanceof ChronoField;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoField chronoField = (ChronoField)temporalField;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
            chronoField.checkValidValue(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoField[chronoField.ordinal()]) {
                case 5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getDayOfWeek:()Ljava/time/DayOfWeek;");
                    DayOfWeek dayOfWeek = this.getDayOfWeek();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/DayOfWeek.getValue:()I");
                    long l2 = l - (long)dayOfWeek.getValue();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusDays:(J)Ljava/time/LocalDate;");
                    return this.plusDays(l2);
                }
                case 6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l3 = l - this.getLong(ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusDays:(J)Ljava/time/LocalDate;");
                    return this.plusDays(l3);
                }
                case 7: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l4 = l - this.getLong(ChronoField.ALIGNED_DAY_OF_WEEK_IN_YEAR);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusDays:(J)Ljava/time/LocalDate;");
                    return this.plusDays(l4);
                }
                case 1: {
                    int n = (int)l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.withDayOfMonth:(I)Ljava/time/LocalDate;");
                    return this.withDayOfMonth(n);
                }
                case 2: {
                    int n = (int)l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.withDayOfYear:(I)Ljava/time/LocalDate;");
                    return this.withDayOfYear(n);
                }
                case 8: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.ofEpochDay:(J)Ljava/time/LocalDate;");
                    return LocalDate.ofEpochDay(l);
                }
                case 3: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l5 = l - this.getLong(ChronoField.ALIGNED_WEEK_OF_MONTH);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusWeeks:(J)Ljava/time/LocalDate;");
                    return this.plusWeeks(l5);
                }
                case 9: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l6 = l - this.getLong(ChronoField.ALIGNED_WEEK_OF_YEAR);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusWeeks:(J)Ljava/time/LocalDate;");
                    return this.plusWeeks(l6);
                }
                case 10: {
                    int n = (int)l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.withMonth:(I)Ljava/time/LocalDate;");
                    return this.withMonth(n);
                }
                case 11: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getProlepticMonth:()J");
                    long l7 = l - this.getProlepticMonth();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusMonths:(J)Ljava/time/LocalDate;");
                    return this.plusMonths(l7);
                }
                case 4: {
                    long l8;
                    RuntimeCostAccounter.recordJump();
                    if (this.year >= 1) {
                        l8 = l;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        l8 = 1L - l;
                    }
                    int n = (int)l8;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.withYear:(I)Ljava/time/LocalDate;");
                    return this.withYear(n);
                }
                case 12: {
                    int n = (int)l;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.withYear:(I)Ljava/time/LocalDate;");
                    return this.withYear(n);
                }
                case 13: {
                    LocalDate localDate;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l9 = this.getLong(ChronoField.ERA) - l;
                    long l10 = l9 == 0L ? 0 : (l9 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l10 == false) {
                        localDate = this;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.withYear:(I)Ljava/time/LocalDate;");
                        localDate = this.withYear(1 - this.year);
                    }
                    return localDate;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported field: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.adjustInto:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        return temporalField.adjustInto(this, l);
    }

    public LocalDate withYear(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.year == n) {
            return this;
        }
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.YEAR.checkValidValue(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.resolvePreviousValid:(III)Ljava/time/LocalDate;");
        return LocalDate.resolvePreviousValid(n, this.month, this.day);
    }

    public LocalDate withMonth(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.month == n) {
            return this;
        }
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidValue:(J)J");
        ChronoField.MONTH_OF_YEAR.checkValidValue(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.resolvePreviousValid:(III)Ljava/time/LocalDate;");
        return LocalDate.resolvePreviousValid(this.year, n, this.day);
    }

    public LocalDate withDayOfMonth(int n) {
        RuntimeCostAccounter.recordJump();
        if (this.day == n) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        return LocalDate.of(this.year, this.month, n);
    }

    public LocalDate withDayOfYear(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getDayOfYear:()I");
        int n2 = this.getDayOfYear();
        RuntimeCostAccounter.recordJump();
        if (n2 == n) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.ofYearDay:(II)Ljava/time/LocalDate;");
        return LocalDate.ofYearDay(this.year, n);
    }

    @Override
    public LocalDate plus(TemporalAmount temporalAmount) {
        boolean bl = temporalAmount instanceof Period;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            Period period = (Period)temporalAmount;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.toTotalMonths:()J");
            long l = period.toTotalMonths();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusMonths:(J)Ljava/time/LocalDate;");
            LocalDate localDate = this.plusMonths(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.getDays:()I");
            long l2 = period.getDays();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusDays:(J)Ljava/time/LocalDate;");
            return localDate.plusDays(l2);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAmount, "amountToAdd");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.addTo:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (LocalDate)temporalAmount.addTo(this);
    }

    @Override
    public LocalDate plus(long l, TemporalUnit temporalUnit) {
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoUnit.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoUnit[chronoUnit.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusDays:(J)Ljava/time/LocalDate;");
                    return this.plusDays(l);
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusWeeks:(J)Ljava/time/LocalDate;");
                    return this.plusWeeks(l);
                }
                case 3: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusMonths:(J)Ljava/time/LocalDate;");
                    return this.plusMonths(l);
                }
                case 4: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusYears:(J)Ljava/time/LocalDate;");
                    return this.plusYears(l);
                }
                case 5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                    long l2 = Math.multiplyExact(l, 10L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusYears:(J)Ljava/time/LocalDate;");
                    return this.plusYears(l2);
                }
                case 6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                    long l3 = Math.multiplyExact(l, 100L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusYears:(J)Ljava/time/LocalDate;");
                    return this.plusYears(l3);
                }
                case 7: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
                    long l4 = Math.multiplyExact(l, 1000L);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusYears:(J)Ljava/time/LocalDate;");
                    return this.plusYears(l4);
                }
                case 8: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l5 = this.getLong(ChronoField.ERA);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
                    long l6 = Math.addExact(l5, l);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.with:(Ljava/time/temporal/TemporalField;J)Ljava/time/LocalDate;");
                    return this.with(ChronoField.ERA, l6);
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported unit: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.addTo:(Ljava/time/temporal/Temporal;J)Ljava/time/temporal/Temporal;");
        return temporalUnit.addTo(this, l);
    }

    public LocalDate plusYears(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return this;
        }
        long l2 = (long)this.year + l;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
        int n = ChronoField.YEAR.checkValidIntValue(l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.resolvePreviousValid:(III)Ljava/time/LocalDate;");
        return LocalDate.resolvePreviousValid(n, this.month, this.day);
    }

    public LocalDate plusMonths(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return this;
        }
        long l2 = (long)this.year * 12L + (long)(this.month - 1);
        long l3 = l2 + l;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorDiv:(JJ)J");
        long l4 = Math.floorDiv(l3, 12L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
        int n = ChronoField.YEAR.checkValidIntValue(l4);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
        int n2 = (int)Math.floorMod(l3, 12L) + 1;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.resolvePreviousValid:(III)Ljava/time/LocalDate;");
        return LocalDate.resolvePreviousValid(n, n2, this.day);
    }

    public LocalDate plusWeeks(long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
        long l2 = Math.multiplyExact(l, 7L);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusDays:(J)Ljava/time/LocalDate;");
        return this.plusDays(l2);
    }

    public LocalDate plusDays(long l) {
        RuntimeCostAccounter.recordJump();
        if (l == 0L) {
            return this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.toEpochDay:()J");
        long l2 = this.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.addExact:(JJ)J");
        long l3 = Math.addExact(l2, l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.ofEpochDay:(J)Ljava/time/LocalDate;");
        return LocalDate.ofEpochDay(l3);
    }

    @Override
    public LocalDate minus(TemporalAmount temporalAmount) {
        boolean bl = temporalAmount instanceof Period;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            Period period = (Period)temporalAmount;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.toTotalMonths:()J");
            long l = period.toTotalMonths();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.minusMonths:(J)Ljava/time/LocalDate;");
            LocalDate localDate = this.minusMonths(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.getDays:()I");
            long l2 = period.getDays();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.minusDays:(J)Ljava/time/LocalDate;");
            return localDate.minusDays(l2);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalAmount, "amountToSubtract");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAmount.subtractFrom:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return (LocalDate)temporalAmount.subtractFrom(this);
    }

    @Override
    public LocalDate minus(long l, TemporalUnit temporalUnit) {
        LocalDate localDate;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/LocalDate;");
            LocalDate localDate2 = this.plus(Long.MAX_VALUE, temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/LocalDate;");
            localDate = localDate2.plus(1L, temporalUnit);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plus:(JLjava/time/temporal/TemporalUnit;)Ljava/time/LocalDate;");
            localDate = this.plus(l2, temporalUnit);
        }
        return localDate;
    }

    public LocalDate minusYears(long l) {
        LocalDate localDate;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusYears:(J)Ljava/time/LocalDate;");
            LocalDate localDate2 = this.plusYears(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusYears:(J)Ljava/time/LocalDate;");
            localDate = localDate2.plusYears(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusYears:(J)Ljava/time/LocalDate;");
            localDate = this.plusYears(l2);
        }
        return localDate;
    }

    public LocalDate minusMonths(long l) {
        LocalDate localDate;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusMonths:(J)Ljava/time/LocalDate;");
            LocalDate localDate2 = this.plusMonths(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusMonths:(J)Ljava/time/LocalDate;");
            localDate = localDate2.plusMonths(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusMonths:(J)Ljava/time/LocalDate;");
            localDate = this.plusMonths(l2);
        }
        return localDate;
    }

    public LocalDate minusWeeks(long l) {
        LocalDate localDate;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusWeeks:(J)Ljava/time/LocalDate;");
            LocalDate localDate2 = this.plusWeeks(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusWeeks:(J)Ljava/time/LocalDate;");
            localDate = localDate2.plusWeeks(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusWeeks:(J)Ljava/time/LocalDate;");
            localDate = this.plusWeeks(l2);
        }
        return localDate;
    }

    public LocalDate minusDays(long l) {
        LocalDate localDate;
        RuntimeCostAccounter.recordJump();
        if (l == Long.MIN_VALUE) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusDays:(J)Ljava/time/LocalDate;");
            LocalDate localDate2 = this.plusDays(Long.MAX_VALUE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusDays:(J)Ljava/time/LocalDate;");
            localDate = localDate2.plusDays(1L);
            RuntimeCostAccounter.recordJump();
        } else {
            long l2 = -l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusDays:(J)Ljava/time/LocalDate;");
            localDate = this.plusDays(l2);
        }
        return localDate;
    }

    @Override
    public <R> R query(TemporalQuery<R> temporalQuery) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.localDate:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<LocalDate> temporalQuery2 = TemporalQueries.localDate();
        RuntimeCostAccounter.recordJump();
        if (temporalQuery == temporalQuery2) {
            return (R)this;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        return ChronoLocalDate.super.query(temporalQuery);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.adjustInto:(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;");
        return ChronoLocalDate.super.adjustInto(temporal);
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalDate;");
        LocalDate localDate = LocalDate.from(temporal);
        boolean bl = temporalUnit instanceof ChronoUnit;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ChronoUnit chronoUnit = (ChronoUnit)temporalUnit;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoUnit.ordinal:()I");
            switch (1.$SwitchMap$java$time$temporal$ChronoUnit[chronoUnit.ordinal()]) {
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.daysUntil:(Ljava/time/LocalDate;)J");
                    return this.daysUntil(localDate);
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.daysUntil:(Ljava/time/LocalDate;)J");
                    return this.daysUntil(localDate) / 7L;
                }
                case 3: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.monthsUntil:(Ljava/time/LocalDate;)J");
                    return this.monthsUntil(localDate);
                }
                case 4: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.monthsUntil:(Ljava/time/LocalDate;)J");
                    return this.monthsUntil(localDate) / 12L;
                }
                case 5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.monthsUntil:(Ljava/time/LocalDate;)J");
                    return this.monthsUntil(localDate) / 120L;
                }
                case 6: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.monthsUntil:(Ljava/time/LocalDate;)J");
                    return this.monthsUntil(localDate) / 1200L;
                }
                case 7: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.monthsUntil:(Ljava/time/LocalDate;)J");
                    return this.monthsUntil(localDate) / 12000L;
                }
                case 8: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                    long l = localDate.getLong(ChronoField.ERA);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getLong:(Ljava/time/temporal/TemporalField;)J");
                    return l - this.getLong(ChronoField.ERA);
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/temporal/UnsupportedTemporalTypeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unsupported unit: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(temporalUnit);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/UnsupportedTemporalTypeException.<init>:(Ljava/lang/String;)V");
            UnsupportedTemporalTypeException unsupportedTemporalTypeException = new UnsupportedTemporalTypeException(string);
            RuntimeCostAccounter.recordThrow();
            throw unsupportedTemporalTypeException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalUnit.between:(Ljava/time/temporal/Temporal;Ljava/time/temporal/Temporal;)J");
        return temporalUnit.between(this, localDate);
    }

    long daysUntil(LocalDate localDate) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.toEpochDay:()J");
        long l = localDate.toEpochDay();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.toEpochDay:()J");
        return l - this.toEpochDay();
    }

    private long monthsUntil(LocalDate localDate) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getProlepticMonth:()J");
        long l = this.getProlepticMonth() * 32L;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getDayOfMonth:()I");
        long l2 = l + (long)this.getDayOfMonth();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getProlepticMonth:()J");
        long l3 = localDate.getProlepticMonth() * 32L;
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getDayOfMonth:()I");
        long l4 = l3 + (long)localDate.getDayOfMonth();
        return (l4 - l2) / 32L;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Period until(ChronoLocalDate var1_1) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/LocalDate;");
        var2_2 = LocalDate.from(var1_1);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getProlepticMonth:()J");
        v0 = var2_2.getProlepticMonth();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.getProlepticMonth:()J");
        var3_3 = v0 - this.getProlepticMonth();
        var5_4 = var2_2.day - this.day;
        RuntimeCostAccounter.recordJump();
        if (var3_3 <= 0L) ** GOTO lbl-1000
        RuntimeCostAccounter.recordJump();
        if (var5_4 < 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.plusMonths:(J)Ljava/time/LocalDate;");
            var6_5 = this.plusMonths(--var3_3);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.toEpochDay:()J");
            v1 = var2_2.toEpochDay();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.toEpochDay:()J");
            var5_4 = (int)(v1 - var6_5.toEpochDay());
            RuntimeCostAccounter.recordJump();
        } else lbl-1000:
        // 2 sources

        {
            RuntimeCostAccounter.recordJump();
            if (var3_3 < 0L) {
                RuntimeCostAccounter.recordJump();
                if (var5_4 > 0) {
                    ++var3_3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.lengthOfMonth:()I");
                    var5_4 -= var2_2.lengthOfMonth();
                }
            }
        }
        var7_6 = var3_3 / 12L;
        var9_7 = (int)(var3_3 % 12L);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.toIntExact:(J)I");
        v2 = Math.toIntExact(var7_6);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Period.of:(III)Ljava/time/Period;");
        return Period.of(v2, var9_7, var5_4);
    }

    @Override
    public String format(DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.format:(Ljava/time/temporal/TemporalAccessor;)Ljava/lang/String;");
        return dateTimeFormatter.format(this);
    }

    public LocalDateTime atTime(LocalTime localTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.of:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return LocalDateTime.of(this, localTime);
    }

    public LocalDateTime atTime(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.of:(II)Ljava/time/LocalTime;");
        LocalTime localTime = LocalTime.of(n, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.atTime:(Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return this.atTime(localTime);
    }

    public LocalDateTime atTime(int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.of:(III)Ljava/time/LocalTime;");
        LocalTime localTime = LocalTime.of(n, n2, n3);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.atTime:(Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return this.atTime(localTime);
    }

    public LocalDateTime atTime(int n, int n2, int n3, int n4) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalTime.of:(IIII)Ljava/time/LocalTime;");
        LocalTime localTime = LocalTime.of(n, n2, n3, n4);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.atTime:(Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return this.atTime(localTime);
    }

    public OffsetDateTime atTime(OffsetTime offsetTime) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.toLocalTime:()Ljava/time/LocalTime;");
        LocalTime localTime = offsetTime.toLocalTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.of:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = LocalDateTime.of(this, localTime);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetTime.getOffset:()Ljava/time/ZoneOffset;");
        ZoneOffset zoneOffset = offsetTime.getOffset();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/OffsetDateTime.of:(Ljava/time/LocalDateTime;Ljava/time/ZoneOffset;)Ljava/time/OffsetDateTime;");
        return OffsetDateTime.of(localDateTime, zoneOffset);
    }

    public LocalDateTime atStartOfDay() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.of:(Ljava/time/LocalDate;Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        return LocalDateTime.of(this, LocalTime.MIDNIGHT);
    }

    public ZonedDateTime atStartOfDay(ZoneId zoneId) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(zoneId, "zone");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.atTime:(Ljava/time/LocalTime;)Ljava/time/LocalDateTime;");
        LocalDateTime localDateTime = this.atTime(LocalTime.MIDNIGHT);
        boolean bl = zoneId instanceof ZoneOffset;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getRules:()Ljava/time/zone/ZoneRules;");
            ZoneRules zoneRules = zoneId.getRules();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.getTransition:(Ljava/time/LocalDateTime;)Ljava/time/zone/ZoneOffsetTransition;");
            ZoneOffsetTransition zoneOffsetTransition = zoneRules.getTransition(localDateTime);
            RuntimeCostAccounter.recordJump();
            if (zoneOffsetTransition != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.isGap:()Z");
                boolean bl2 = zoneOffsetTransition.isGap();
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneOffsetTransition.getDateTimeAfter:()Ljava/time/LocalDateTime;");
                    localDateTime = zoneOffsetTransition.getDateTimeAfter();
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZonedDateTime.of:(Ljava/time/LocalDateTime;Ljava/time/ZoneId;)Ljava/time/ZonedDateTime;");
        return ZonedDateTime.of(localDateTime, zoneId);
    }

    @Override
    public long toEpochDay() {
        long l = this.year;
        long l2 = this.month;
        long l3 = 0L;
        l3 += 365L * l;
        RuntimeCostAccounter.recordJump();
        if (l >= 0L) {
            l3 += (l + 3L) / 4L - (l + 99L) / 100L + (l + 399L) / 400L;
            RuntimeCostAccounter.recordJump();
        } else {
            l3 -= l / -4L - l / -100L + l / -400L;
        }
        l3 += (367L * l2 - 362L) / 12L;
        l3 += (long)(this.day - 1);
        RuntimeCostAccounter.recordJump();
        if (l2 > 2L) {
            --l3;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.isLeapYear:()Z");
            boolean bl = this.isLeapYear();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                --l3;
            }
        }
        return l3 - 719528L;
    }

    @Override
    public int compareTo(ChronoLocalDate chronoLocalDate) {
        boolean bl = chronoLocalDate instanceof LocalDate;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            LocalDate localDate = (LocalDate)chronoLocalDate;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.compareTo0:(Ljava/time/LocalDate;)I");
            return this.compareTo0(localDate);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.compareTo:(Ljava/time/chrono/ChronoLocalDate;)I");
        return ChronoLocalDate.super.compareTo(chronoLocalDate);
    }

    int compareTo0(LocalDate localDate) {
        int n = this.year - localDate.year;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            n = this.month - localDate.month;
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                n = this.day - localDate.day;
            }
        }
        return n;
    }

    @Override
    public boolean isAfter(ChronoLocalDate chronoLocalDate) {
        boolean bl = chronoLocalDate instanceof LocalDate;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            boolean bl2;
            LocalDate localDate = (LocalDate)chronoLocalDate;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.compareTo0:(Ljava/time/LocalDate;)I");
            int n = this.compareTo0(localDate);
            RuntimeCostAccounter.recordJump();
            if (n > 0) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            return bl2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.isAfter:(Ljava/time/chrono/ChronoLocalDate;)Z");
        return ChronoLocalDate.super.isAfter(chronoLocalDate);
    }

    @Override
    public boolean isBefore(ChronoLocalDate chronoLocalDate) {
        boolean bl = chronoLocalDate instanceof LocalDate;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            boolean bl2;
            LocalDate localDate = (LocalDate)chronoLocalDate;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.compareTo0:(Ljava/time/LocalDate;)I");
            int n = this.compareTo0(localDate);
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            return bl2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.isBefore:(Ljava/time/chrono/ChronoLocalDate;)Z");
        return ChronoLocalDate.super.isBefore(chronoLocalDate);
    }

    @Override
    public boolean isEqual(ChronoLocalDate chronoLocalDate) {
        boolean bl = chronoLocalDate instanceof LocalDate;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            boolean bl2;
            LocalDate localDate = (LocalDate)chronoLocalDate;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.compareTo0:(Ljava/time/LocalDate;)I");
            int n = this.compareTo0(localDate);
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            return bl2;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.isEqual:(Ljava/time/chrono/ChronoLocalDate;)Z");
        return ChronoLocalDate.super.isEqual(chronoLocalDate);
    }

    @Override
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (this == object) {
            return true;
        }
        boolean bl = object instanceof LocalDate;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            boolean bl2;
            LocalDate localDate = (LocalDate)object;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.compareTo0:(Ljava/time/LocalDate;)I");
            int n = this.compareTo0(localDate);
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                bl2 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl2 = false;
            }
            return bl2;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = this.year;
        short s = this.month;
        short s2 = this.day;
        return n & 0xFFFFF800 ^ (n << 11) + (s << 6) + s2;
    }

    @Override
    public String toString() {
        String string;
        String string2;
        int n = this.year;
        short s = this.month;
        short s2 = this.day;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
        int n2 = Math.abs(n);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:(I)V");
        StringBuilder stringBuilder = new StringBuilder(10);
        RuntimeCostAccounter.recordJump();
        if (n2 < 1000) {
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(n - 10000);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.deleteCharAt:(I)Ljava/lang/StringBuilder;");
                stringBuilder2.deleteCharAt(1);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder.append(n + 10000);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.deleteCharAt:(I)Ljava/lang/StringBuilder;");
                stringBuilder3.deleteCharAt(0);
                RuntimeCostAccounter.recordJump();
            }
        } else {
            RuntimeCostAccounter.recordJump();
            if (n > 9999) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                stringBuilder.append('+');
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            stringBuilder.append(n);
        }
        RuntimeCostAccounter.recordJump();
        if (s < 10) {
            string2 = "-0";
            RuntimeCostAccounter.recordJump();
        } else {
            string2 = "-";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder.append(string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(s);
        RuntimeCostAccounter.recordJump();
        if (s2 < 10) {
            string = "-0";
            RuntimeCostAccounter.recordJump();
        } else {
            string = "-";
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder7 = stringBuilder6.append(s2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder7.toString();
    }

    private Object writeReplace() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/Ser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/Ser.<init>:(BLjava/lang/Object;)V");
        return new Ser(3, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/InvalidObjectException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InvalidObjectException.<init>:(Ljava/lang/String;)V");
        InvalidObjectException invalidObjectException = new InvalidObjectException("Deserialization via serialization delegate");
        RuntimeCostAccounter.recordThrow();
        throw invalidObjectException;
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeInt:(I)V");
        dataOutput.writeInt(this.year);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
        dataOutput.writeByte(this.month);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataOutput.writeByte:(I)V");
        dataOutput.writeByte(this.day);
    }

    static LocalDate readExternal(DataInput dataInput) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readInt:()I");
        int n = dataInput.readInt();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
        byte by = dataInput.readByte();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInput.readByte:()B");
        byte by2 = dataInput.readByte();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        return LocalDate.of(n, by, (int)by2);
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        MIN = LocalDate.of(-999999999, 1, 1);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
        MAX = LocalDate.of(999999999, 12, 31);
    }
}

