/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.Closeable;
import sandbox.java.io.File;
import sandbox.java.io.FileDescriptor;
import sandbox.java.io.FileNotFoundException;
import sandbox.java.io.IOException;
import sandbox.java.io.OutputStream;
import sandbox.java.nio.channels.FileChannel;
import sandbox.sun.nio.ch.FileChannelImpl;

public class FileOutputStream
extends OutputStream {
    private final FileDescriptor fd;
    private final boolean append;
    private FileChannel channel;
    private final String path;
    private final Object closeLock;
    private volatile boolean closed;

    public FileOutputStream(String string) throws FileNotFoundException {
        File file;
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/File");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
            file = new File(string);
            RuntimeCostAccounter.recordJump();
        } else {
            file = null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.<init>:(Ljava/io/File;Z)V");
        this(file, false);
    }

    public FileOutputStream(String string, boolean bl) throws FileNotFoundException {
        File file;
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/File");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
            file = new File(string);
            RuntimeCostAccounter.recordJump();
        } else {
            file = null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.<init>:(Ljava/io/File;Z)V");
        this(file, bl);
    }

    public FileOutputStream(File file) throws FileNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.<init>:(Ljava/io/File;Z)V");
        this(file, false);
    }

    public FileOutputStream(File file, boolean bl) throws FileNotFoundException {
        String string;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/Object");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.closeLock = new Object();
        this.closed = false;
        RuntimeCostAccounter.recordJump();
        if (file != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/File.getPath:()Ljava/lang/String;");
            string = file.getPath();
            RuntimeCostAccounter.recordJump();
        } else {
            string = null;
        }
        String string2 = string;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkWrite:(Ljava/lang/String;)V");
            securityManager.checkWrite(string2);
        }
        RuntimeCostAccounter.recordJump();
        if (string2 == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.isInvalid:()Z");
        boolean bl2 = file.isInvalid();
        RuntimeCostAccounter.recordJump();
        if (bl2) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/FileNotFoundException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/FileNotFoundException.<init>:(Ljava/lang/String;)V");
            FileNotFoundException fileNotFoundException = new FileNotFoundException("Invalid file path");
            RuntimeCostAccounter.recordThrow();
            throw fileNotFoundException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/io/FileDescriptor");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileDescriptor.<init>:()V");
        this.fd = new FileDescriptor();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileDescriptor.attach:(Ljava/io/Closeable;)V");
        this.fd.attach(this);
        this.append = bl;
        this.path = string2;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.open:(Ljava/lang/String;Z)V");
        this.open(string2, bl);
    }

    public FileOutputStream(FileDescriptor fileDescriptor) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/OutputStream.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/lang/Object");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.closeLock = new Object();
        this.closed = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getSecurityManager:()Ljava/lang/SecurityManager;");
        SecurityManager securityManager = System.getSecurityManager();
        RuntimeCostAccounter.recordJump();
        if (fileDescriptor == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (securityManager != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/SecurityManager.checkWrite:(Ljava/io/FileDescriptor;)V");
            securityManager.checkWrite(fileDescriptor);
        }
        this.fd = fileDescriptor;
        this.append = false;
        this.path = null;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileDescriptor.attach:(Ljava/io/Closeable;)V");
        this.fd.attach(this);
    }

    private native void open(String var1, boolean var2) throws FileNotFoundException;

    private native void write(int var1, boolean var2) throws IOException;

    @Override
    public void write(int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.write:(IZ)V");
        this.write(n, this.append);
    }

    private native void writeBytes(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    @Override
    public void write(byte[] byArray) throws IOException {
        int n = byArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.writeBytes:([BIIZ)V");
        this.writeBytes(byArray, 0, n, this.append);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.writeBytes:([BIIZ)V");
        this.writeBytes(byArray, n, n2, this.append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        try {
            RuntimeCostAccounter.recordJump();
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordJump();
        if (this.channel != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/nio/channels/FileChannel.close:()V");
            this.channel.close();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/io/FileOutputStream$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream$1.<init>:(Ljava/io/FileOutputStream;)V");
        Closeable closeable = new Closeable(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public void close() throws IOException {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.access$000:(Ljava/io/FileOutputStream;)V");
                FileOutputStream.access$000(FileOutputStream.this);
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileDescriptor.closeAll:(Ljava/io/Closeable;)V");
        this.fd.closeAll(closeable);
    }

    public final FileDescriptor getFD() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.fd != null) {
            return this.fd;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:()V");
        IOException iOException = new IOException();
        RuntimeCostAccounter.recordThrow();
        throw iOException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileOutputStream fileOutputStream = this;
        try {
            RuntimeCostAccounter.recordJump();
            if (this.channel == null) {
                RuntimeCostAccounter.recordMethodCall((String)"sun/nio/ch/FileChannelImpl.open:(Ljava/io/FileDescriptor;Ljava/lang/String;ZZZLjava/lang/Object;)Ljava/nio/channels/FileChannel;");
                this.channel = FileChannelImpl.open((FileDescriptor)this.fd, (String)this.path, (boolean)false, (boolean)true, (boolean)this.append, (Object)this);
            }
            return this.channel;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void finalize() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.fd == null) return;
        RuntimeCostAccounter.recordJump();
        if (this.fd != FileDescriptor.out) {
            RuntimeCostAccounter.recordJump();
            if (this.fd != FileDescriptor.err) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.close:()V");
                this.close();
                return;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.flush:()V");
        this.flush();
        RuntimeCostAccounter.recordJump();
    }

    private native void close0() throws IOException;

    private static native void initIDs();

    static /* synthetic */ void access$000(FileOutputStream fileOutputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.close0:()V");
        fileOutputStream.close0();
    }

    static {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FileOutputStream.initIDs:()V");
        FileOutputStream.initIDs();
    }
}

