/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.Writer;
import sandbox.java.security.AccessController;
import sandbox.java.security.PrivilegedAction;
import sandbox.sun.security.action.GetPropertyAction;

public class BufferedWriter
extends Writer {
    private Writer out;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static int defaultCharBufferSize = 8192;
    private String lineSeparator;

    public BufferedWriter(Writer writer) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.<init>:(Ljava/io/Writer;I)V");
        this(writer, defaultCharBufferSize);
    }

    public BufferedWriter(Writer writer, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.<init>:(Ljava/lang/Object;)V");
        super(writer);
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Buffer size <= 0");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        this.out = writer;
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)2);
        this.cb = new char[n2];
        this.nChars = n;
        this.nextChar = 0;
        RuntimeCostAccounter.recordAllocation((String)"sun/security/action/GetPropertyAction");
        RuntimeCostAccounter.recordMethodCall((String)"sun/security/action/GetPropertyAction.<init>:(Ljava/lang/String;)V");
        GetPropertyAction getPropertyAction = new GetPropertyAction("line.separator");
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        this.lineSeparator = (String)AccessController.doPrivileged((PrivilegedAction)getPropertyAction);
    }

    private void ensureOpen() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.out == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Stream closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBuffer() throws IOException {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.ensureOpen:()V");
            this.ensureOpen();
            RuntimeCostAccounter.recordJump();
            if (this.nextChar == 0) {
                return;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.write:([CII)V");
            this.out.write(this.cb, 0, this.nextChar);
            this.nextChar = 0;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.ensureOpen:()V");
            this.ensureOpen();
            RuntimeCostAccounter.recordJump();
            if (this.nextChar >= this.nChars) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.flushBuffer:()V");
                this.flushBuffer();
            }
            this.cb[this.nextChar++] = (char)n;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    private int min(int n, int n2) {
        RuntimeCostAccounter.recordJump();
        if (n < n2) {
            return n;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        try {
            block10: {
                block9: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.ensureOpen:()V");
                    this.ensureOpen();
                    RuntimeCostAccounter.recordJump();
                    if (n < 0) break block9;
                    int n3 = cArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n > n3) break block9;
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 0) break block9;
                    int n4 = cArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n + n2 > n4) break block9;
                    RuntimeCostAccounter.recordJump();
                    if (n + n2 >= 0) break block10;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
                RuntimeCostAccounter.recordThrow();
                throw indexOutOfBoundsException;
            }
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                return;
            }
            RuntimeCostAccounter.recordJump();
            if (n2 >= this.nChars) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.flushBuffer:()V");
                this.flushBuffer();
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.write:([CII)V");
                this.out.write(cArray, n, n2);
                return;
            }
            int n5 = n;
            int n6 = n + n2;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n5 >= n6) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.min:(II)I");
                int n7 = this.min(this.nChars - this.nextChar, n6 - n5);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                System.arraycopy(cArray, n5, this.cb, this.nextChar, n7);
                n5 += n7;
                this.nextChar += n7;
                RuntimeCostAccounter.recordJump();
                if (this.nextChar >= this.nChars) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.flushBuffer:()V");
                    this.flushBuffer();
                }
                RuntimeCostAccounter.recordJump();
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int n, int n2) throws IOException {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.ensureOpen:()V");
            this.ensureOpen();
            int n3 = n;
            int n4 = n + n2;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n4) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.min:(II)I");
                int n5 = this.min(this.nChars - this.nextChar, n4 - n3);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.getChars:(II[CI)V");
                string.getChars(n3, n3 + n5, this.cb, this.nextChar);
                n3 += n5;
                this.nextChar += n5;
                RuntimeCostAccounter.recordJump();
                if (this.nextChar >= this.nChars) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.flushBuffer:()V");
                    this.flushBuffer();
                }
                RuntimeCostAccounter.recordJump();
            }
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    public void newLine() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.write:(Ljava/lang/String;)V");
        this.write(this.lineSeparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.flushBuffer:()V");
            this.flushBuffer();
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.flush:()V");
            this.out.flush();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordJump();
            if (this.out == null) {
                return;
            }
            try {
                block20: {
                    Writer writer = this.out;
                    Throwable throwable = null;
                    try {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedWriter.flushBuffer:()V");
                        this.flushBuffer();
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            RuntimeCostAccounter.recordThrow();
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            block19: {
                                RuntimeCostAccounter.recordJump();
                                if (writer != null) {
                                    RuntimeCostAccounter.recordJump();
                                    if (throwable != null) {
                                        try {
                                            RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.close:()V");
                                            writer.close();
                                        }
                                        catch (Throwable throwable5) {
                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Throwable.addSuppressed:(Ljava/lang/Throwable;)V");
                                            throwable.addSuppressed(throwable5);
                                            RuntimeCostAccounter.recordJump();
                                            break block19;
                                        }
                                        RuntimeCostAccounter.recordJump();
                                    } else {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.close:()V");
                                        writer.close();
                                    }
                                }
                            }
                            RuntimeCostAccounter.recordThrow();
                            throw throwable4;
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    if (writer != null) {
                        RuntimeCostAccounter.recordJump();
                        if (throwable != null) {
                            try {
                                RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.close:()V");
                                writer.close();
                            }
                            catch (Throwable throwable2) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Throwable.addSuppressed:(Ljava/lang/Throwable;)V");
                                throwable.addSuppressed(throwable2);
                                RuntimeCostAccounter.recordJump();
                                break block20;
                            }
                            RuntimeCostAccounter.recordJump();
                        } else {
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/Writer.close:()V");
                            writer.close();
                            RuntimeCostAccounter.recordJump();
                        }
                    }
                }
                this.out = null;
                this.cb = null;
            }
            catch (Throwable throwable) {
                this.out = null;
                this.cb = null;
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }
}

