/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix.freebsd;

import com.pty4j.WinSize;
import com.pty4j.unix.PtyHelpers;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.StringArray;
import com.sun.jna.ptr.IntByReference;
import jtermios.JTermios;

public class OSFacadeImpl
implements PtyHelpers.OSFacade {
    private static final long TIOCGWINSZ = 1074295912L;
    private static final long TIOCSWINSZ = 2148037735L;
    private static FreeBSD_C_lib m_Clib = (FreeBSD_C_lib)Native.loadLibrary((String)"c", FreeBSD_C_lib.class);
    private static FreeBSD_Util_lib m_Utillib = (FreeBSD_Util_lib)Native.loadLibrary((String)"util", FreeBSD_Util_lib.class);

    public OSFacadeImpl() {
        PtyHelpers.ONLCR = 2;
        PtyHelpers.VERASE = 3;
        PtyHelpers.VWERASE = 4;
        PtyHelpers.VKILL = 5;
        PtyHelpers.VREPRINT = 6;
        PtyHelpers.VINTR = 8;
        PtyHelpers.VQUIT = 9;
        PtyHelpers.VSUSP = 10;
        PtyHelpers.ECHOKE = 1;
        PtyHelpers.ECHOCTL = 64;
    }

    public int execve(String command, String[] argv, String[] env) {
        StringArray argvp = argv == null ? new StringArray(new String[]{command}) : new StringArray(argv);
        StringArray envp = env == null ? null : new StringArray(env);
        return m_Clib.execve(command, argvp, envp);
    }

    public int getWinSize(int fd, WinSize winSize) {
        PtyHelpers.winsize ws = new PtyHelpers.winsize();
        int r = m_Clib.ioctl(fd, new NativeLong(1074295912L), ws);
        if (r < 0) {
            return r;
        }
        ws.update(winSize);
        return r;
    }

    public int kill(int pid, int signal) {
        return m_Clib.kill(pid, signal);
    }

    public int setWinSize(int fd, WinSize winSize) {
        PtyHelpers.winsize ws = new PtyHelpers.winsize(winSize);
        return m_Clib.ioctl(fd, new NativeLong(2148037735L), ws);
    }

    public int waitpid(int pid, int[] stat, int options) {
        return m_Clib.waitpid(pid, stat, options);
    }

    public int sigprocmask(int how, IntByReference set, IntByReference oldset) {
        return m_Clib.sigprocmask(how, set, oldset);
    }

    public String strerror(int errno) {
        return m_Clib.strerror(errno);
    }

    public int getpt() {
        return m_Clib.posix_openpt(JTermios.O_RDWR | JTermios.O_NOCTTY);
    }

    public int grantpt(int fd) {
        return m_Clib.grantpt(fd);
    }

    public int unlockpt(int fd) {
        return m_Clib.unlockpt(fd);
    }

    public int close(int fd) {
        return m_Clib.close(fd);
    }

    public String ptsname(int fd) {
        return m_Clib.ptsname(fd);
    }

    public int killpg(int pid, int sig) {
        return m_Clib.killpg(pid, sig);
    }

    public int fork() {
        return m_Clib.fork();
    }

    public int pipe(int[] pipe2) {
        return JTermios.pipe((int[])pipe2);
    }

    public int setsid() {
        return m_Clib.setsid();
    }

    public void execv(String path, String[] argv) {
        StringArray argvp = argv == null ? new StringArray(new String[]{path}) : new StringArray(argv);
        m_Clib.execv(path, argvp);
    }

    public int getpid() {
        return m_Clib.getpid();
    }

    public int setpgid(int pid, int pgid) {
        return m_Clib.setpgid(pid, pgid);
    }

    public void dup2(int fds, int fileno) {
        m_Clib.dup2(fds, fileno);
    }

    public int getppid() {
        return m_Clib.getppid();
    }

    public void unsetenv(String s) {
        m_Clib.unsetenv(s);
    }

    public int login_tty(int fd) {
        return m_Utillib.login_tty(fd);
    }

    public void chdir(String dirpath) {
        m_Clib.chdir(dirpath);
    }

    public static interface FreeBSD_Util_lib
    extends Library {
        public int login_tty(int var1);
    }

    public static interface FreeBSD_C_lib
    extends Library {
        public int posix_openpt(int var1);

        public int execv(String var1, StringArray var2);

        public int execve(String var1, StringArray var2, StringArray var3);

        public int ioctl(int var1, NativeLong var2, PtyHelpers.winsize var3);

        public int kill(int var1, int var2);

        public int waitpid(int var1, int[] var2, int var3);

        public int sigprocmask(int var1, IntByReference var2, IntByReference var3);

        public String strerror(int var1);

        public int grantpt(int var1);

        public int unlockpt(int var1);

        public int close(int var1);

        public String ptsname(int var1);

        public int open(String var1, int var2);

        public int killpg(int var1, int var2);

        public int fork();

        public int setsid();

        public int getpid();

        public int setpgid(int var1, int var2);

        public void dup2(int var1, int var2);

        public int getppid();

        public void unsetenv(String var1);

        public int login_tty(int var1);

        public void chdir(String var1);
    }
}

