/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.jar;

import java.lang.ref.SoftReference;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.ByteArrayInputStream;
import sandbox.java.io.File;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.net.URL;
import sandbox.java.security.AccessController;
import sandbox.java.security.CodeSigner;
import sandbox.java.security.CodeSource;
import sandbox.java.security.PrivilegedAction;
import sandbox.java.security.cert.Certificate;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Enumeration;
import sandbox.java.util.Iterator;
import sandbox.java.util.List;
import sandbox.java.util.Locale;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Spliterator;
import sandbox.java.util.Spliterators;
import sandbox.java.util.jar.Attributes;
import sandbox.java.util.jar.JarEntry;
import sandbox.java.util.jar.JarException;
import sandbox.java.util.jar.JarVerifier;
import sandbox.java.util.jar.JavaUtilJarAccessImpl;
import sandbox.java.util.jar.Manifest;
import sandbox.java.util.stream.Stream;
import sandbox.java.util.stream.StreamSupport;
import sandbox.java.util.zip.ZipEntry;
import sandbox.java.util.zip.ZipFile;
import sandbox.sun.misc.IOUtils;
import sandbox.sun.misc.JavaUtilJarAccess;
import sandbox.sun.misc.SharedSecrets;
import sandbox.sun.security.action.GetPropertyAction;
import sandbox.sun.security.util.ManifestEntryVerifier;
import sandbox.sun.security.util.SignatureFileVerifier;

public class JarFile
extends ZipFile {
    private SoftReference<Manifest> manRef;
    private JarEntry manEntry;
    private JarVerifier jv;
    private boolean jvInitialized;
    private boolean verify;
    private boolean hasClassPathAttribute;
    private volatile boolean hasCheckedSpecialAttributes;
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final char[] CLASSPATH_CHARS;
    private static final int[] CLASSPATH_LASTOCC;
    private static final int[] CLASSPATH_OPTOSFT;
    private static String javaHome;
    private static volatile String[] jarNames;

    public JarFile(String string) throws IOException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/File");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
        File file = new File(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.<init>:(Ljava/io/File;ZI)V");
        this(file, true, 1);
    }

    public JarFile(String string, boolean bl) throws IOException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/File");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;)V");
        File file = new File(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.<init>:(Ljava/io/File;ZI)V");
        this(file, bl, 1);
    }

    public JarFile(File file) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.<init>:(Ljava/io/File;ZI)V");
        this(file, true, 1);
    }

    public JarFile(File file, boolean bl) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.<init>:(Ljava/io/File;ZI)V");
        this(file, bl, 1);
    }

    public JarFile(File file, boolean bl, int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.<init>:(Ljava/io/File;I)V");
        super(file, n);
        this.verify = bl;
    }

    public Manifest getManifest() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getManifestFromReference:()Ljava/util/jar/Manifest;");
        return this.getManifestFromReference();
    }

    private Manifest getManifestFromReference() throws IOException {
        Manifest manifest;
        RuntimeCostAccounter.recordJump();
        if (this.manRef != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/SoftReference.get:()Ljava/lang/Object;");
            manifest = this.manRef.get();
            RuntimeCostAccounter.recordJump();
        } else {
            manifest = null;
        }
        Manifest manifest2 = manifest;
        RuntimeCostAccounter.recordJump();
        if (manifest2 == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getManEntry:()Ljava/util/jar/JarEntry;");
            JarEntry jarEntry = this.getManEntry();
            RuntimeCostAccounter.recordJump();
            if (jarEntry != null) {
                RuntimeCostAccounter.recordJump();
                if (this.verify) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getBytes:(Ljava/util/zip/ZipEntry;)[B");
                    byte[] byArray = this.getBytes(jarEntry);
                    RuntimeCostAccounter.recordAllocation((String)"java/util/jar/Manifest");
                    RuntimeCostAccounter.recordAllocation((String)"java/io/ByteArrayInputStream");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/ByteArrayInputStream.<init>:([B)V");
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.<init>:(Ljava/io/InputStream;)V");
                    manifest2 = new Manifest(byteArrayInputStream);
                    RuntimeCostAccounter.recordJump();
                    if (!this.jvInitialized) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarVerifier");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.<init>:([B)V");
                        this.jv = new JarVerifier(byArray);
                    }
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/jar/Manifest");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getInputStream:(Ljava/util/zip/ZipEntry;)Ljava/io/InputStream;");
                    InputStream inputStream = super.getInputStream(jarEntry);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.<init>:(Ljava/io/InputStream;)V");
                    manifest2 = new Manifest(inputStream);
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/ref/SoftReference");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/SoftReference.<init>:(Ljava/lang/Object;)V");
                this.manRef = new SoftReference<Manifest>(manifest2);
            }
        }
        return manifest2;
    }

    private native String[] getMetaInfEntryNames();

    public JarEntry getJarEntry(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getEntry:(Ljava/lang/String;)Ljava/util/zip/ZipEntry;");
        return (JarEntry)this.getEntry(string);
    }

    @Override
    public ZipEntry getEntry(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getEntry:(Ljava/lang/String;)Ljava/util/zip/ZipEntry;");
        ZipEntry zipEntry = super.getEntry(string);
        RuntimeCostAccounter.recordJump();
        if (zipEntry != null) {
            RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarFile$JarFileEntry");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile$JarFileEntry.<init>:(Ljava/util/jar/JarFile;Ljava/util/zip/ZipEntry;)V");
            return new JarFileEntry(zipEntry);
        }
        return null;
    }

    public Enumeration<JarEntry> entries() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarFile$JarEntryIterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile$JarEntryIterator.<init>:(Ljava/util/jar/JarFile;Ljava/util/jar/JarFile$1;)V");
        return new JarEntryIterator(this, null);
    }

    public Stream<JarEntry> stream() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarFile$JarEntryIterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile$JarEntryIterator.<init>:(Ljava/util/jar/JarFile;Ljava/util/jar/JarFile$1;)V");
        JarEntryIterator jarEntryIterator = new JarEntryIterator(this, null);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.size:()I");
        long l = this.size();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.spliterator:(Ljava/util/Iterator;JI)Ljava/util/Spliterator;");
        Spliterator<JarEntry> spliterator = Spliterators.spliterator(jarEntryIterator, l, 1297);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.stream:(Ljava/util/Spliterator;Z)Ljava/util/stream/Stream;");
        return StreamSupport.stream(spliterator, false);
    }

    private void maybeInstantiateVerifier() throws IOException {
        block5: {
            block6: {
                RuntimeCostAccounter.recordJump();
                if (this.jv != null) {
                    return;
                }
                RuntimeCostAccounter.recordJump();
                if (!this.verify) break block5;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getMetaInfEntryNames:()[Ljava/lang/String;");
                String[] stringArray = this.getMetaInfEntryNames();
                RuntimeCostAccounter.recordJump();
                if (stringArray == null) break block6;
                int n = 0;
                while (true) {
                    block8: {
                        block7: {
                            int n2 = stringArray.length;
                            RuntimeCostAccounter.recordJump();
                            if (n >= n2) break;
                            String string = stringArray[n];
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.toUpperCase:(Ljava/util/Locale;)Ljava/lang/String;");
                            String string2 = string.toUpperCase(Locale.ENGLISH);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.endsWith:(Ljava/lang/String;)Z");
                            boolean bl = string2.endsWith(".DSA");
                            RuntimeCostAccounter.recordJump();
                            if (bl) break block7;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.endsWith:(Ljava/lang/String;)Z");
                            boolean bl2 = string2.endsWith(".RSA");
                            RuntimeCostAccounter.recordJump();
                            if (bl2) break block7;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.endsWith:(Ljava/lang/String;)Z");
                            boolean bl3 = string2.endsWith(".EC");
                            RuntimeCostAccounter.recordJump();
                            if (bl3) break block7;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.endsWith:(Ljava/lang/String;)Z");
                            boolean bl4 = string2.endsWith(".SF");
                            RuntimeCostAccounter.recordJump();
                            if (!bl4) break block8;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getManifest:()Ljava/util/jar/Manifest;");
                        this.getManifest();
                        return;
                    }
                    ++n;
                    RuntimeCostAccounter.recordJump();
                }
            }
            this.verify = false;
        }
    }

    private void initializeVerifier() {
        block15: {
            block14: {
                ManifestEntryVerifier manifestEntryVerifier = null;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getMetaInfEntryNames:()[Ljava/lang/String;");
                    String[] stringArray = this.getMetaInfEntryNames();
                    RuntimeCostAccounter.recordJump();
                    if (stringArray == null) break block14;
                    int n = 0;
                    while (true) {
                        block17: {
                            block16: {
                                int n2 = stringArray.length;
                                RuntimeCostAccounter.recordJump();
                                if (n >= n2) break;
                                String string = stringArray[n];
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.toUpperCase:(Ljava/util/Locale;)Ljava/lang/String;");
                                String string2 = string.toUpperCase(Locale.ENGLISH);
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                                boolean bl = MANIFEST_NAME.equals(string2);
                                RuntimeCostAccounter.recordJump();
                                if (bl) break block16;
                                RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/SignatureFileVerifier.isBlockOrSF:(Ljava/lang/String;)Z");
                                boolean bl2 = SignatureFileVerifier.isBlockOrSF((String)string2);
                                RuntimeCostAccounter.recordJump();
                                if (!bl2) break block17;
                            }
                            String string = stringArray[n];
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getJarEntry:(Ljava/lang/String;)Ljava/util/jar/JarEntry;");
                            JarEntry jarEntry = this.getJarEntry(string);
                            RuntimeCostAccounter.recordJump();
                            if (jarEntry == null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarException");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarException.<init>:(Ljava/lang/String;)V");
                                JarException jarException = new JarException("corrupted jar file");
                                RuntimeCostAccounter.recordThrow();
                                throw jarException;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (manifestEntryVerifier == null) {
                                RuntimeCostAccounter.recordAllocation((String)"sun/security/util/ManifestEntryVerifier");
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getManifestFromReference:()Ljava/util/jar/Manifest;");
                                Manifest manifest = this.getManifestFromReference();
                                RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/ManifestEntryVerifier.<init>:(Ljava/util/jar/Manifest;)V");
                                manifestEntryVerifier = new ManifestEntryVerifier(manifest);
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getBytes:(Ljava/util/zip/ZipEntry;)[B");
                            byte[] byArray = this.getBytes(jarEntry);
                            RuntimeCostAccounter.recordJump();
                            if (byArray != null) {
                                int n3 = byArray.length;
                                RuntimeCostAccounter.recordJump();
                                if (n3 > 0) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.beginEntry:(Ljava/util/jar/JarEntry;Lsun/security/util/ManifestEntryVerifier;)V");
                                    this.jv.beginEntry(jarEntry, manifestEntryVerifier);
                                    int n4 = byArray.length;
                                    int n5 = byArray.length;
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.update:(I[BIILsun/security/util/ManifestEntryVerifier;)V");
                                    this.jv.update(n4, byArray, 0, n5, manifestEntryVerifier);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.update:(I[BIILsun/security/util/ManifestEntryVerifier;)V");
                                    this.jv.update(-1, null, 0, 0, manifestEntryVerifier);
                                }
                            }
                        }
                        ++n;
                        RuntimeCostAccounter.recordJump();
                    }
                }
                catch (IOException iOException) {
                    this.jv = null;
                    this.verify = false;
                    RuntimeCostAccounter.recordJump();
                    if (JarVerifier.debug == null) break block15;
                    RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/Debug.println:(Ljava/lang/String;)V");
                    JarVerifier.debug.println("jarfile parsing error!");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.printStackTrace:()V");
                    iOException.printStackTrace();
                }
            }
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (this.jv != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.doneWithMeta:()V");
            this.jv.doneWithMeta();
            RuntimeCostAccounter.recordJump();
            if (JarVerifier.debug != null) {
                RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/Debug.println:(Ljava/lang/String;)V");
                JarVerifier.debug.println("done with meta!");
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.nothingToVerify:()Z");
            boolean bl = this.jv.nothingToVerify();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordJump();
                if (JarVerifier.debug != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"sun/security/util/Debug.println:(Ljava/lang/String;)V");
                    JarVerifier.debug.println("nothing to verify!");
                }
                this.jv = null;
                this.verify = false;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] getBytes(ZipEntry zipEntry) throws IOException {
        byte[] byArray;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getInputStream:(Ljava/util/zip/ZipEntry;)Ljava/io/InputStream;");
        InputStream inputStream = super.getInputStream(zipEntry);
        Throwable throwable = null;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.getSize:()J");
            int n = (int)zipEntry.getSize();
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/IOUtils.readFully:(Ljava/io/InputStream;IZ)[B");
            byArray = IOUtils.readFully((InputStream)inputStream, (int)n, (boolean)true);
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                RuntimeCostAccounter.recordThrow();
                throw throwable3;
            }
            catch (Throwable throwable4) {
                block9: {
                    block10: {
                        RuntimeCostAccounter.recordJump();
                        if (inputStream == null) break block9;
                        RuntimeCostAccounter.recordJump();
                        if (throwable == null) break block10;
                        try {
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                            inputStream.close();
                        }
                        catch (Throwable throwable5) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Throwable.addSuppressed:(Ljava/lang/Throwable;)V");
                            throwable.addSuppressed(throwable5);
                            RuntimeCostAccounter.recordJump();
                        }
                        RuntimeCostAccounter.recordJump();
                        break block9;
                        break block9;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                    inputStream.close();
                }
                RuntimeCostAccounter.recordThrow();
                throw throwable4;
            }
        }
        RuntimeCostAccounter.recordJump();
        if (inputStream == null) return byArray;
        RuntimeCostAccounter.recordJump();
        if (throwable != null) {
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
                inputStream.close();
            }
            catch (Throwable throwable2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Throwable.addSuppressed:(Ljava/lang/Throwable;)V");
                throwable.addSuppressed(throwable2);
                RuntimeCostAccounter.recordJump();
                return byArray;
            }
            RuntimeCostAccounter.recordJump();
            return byArray;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
        inputStream.close();
        return byArray;
    }

    @Override
    public synchronized InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        JarEntry jarEntry;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.maybeInstantiateVerifier:()V");
        this.maybeInstantiateVerifier();
        RuntimeCostAccounter.recordJump();
        if (this.jv == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getInputStream:(Ljava/util/zip/ZipEntry;)Ljava/io/InputStream;");
            return super.getInputStream(zipEntry);
        }
        RuntimeCostAccounter.recordJump();
        if (!this.jvInitialized) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.initializeVerifier:()V");
            this.initializeVerifier();
            this.jvInitialized = true;
            RuntimeCostAccounter.recordJump();
            if (this.jv == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getInputStream:(Ljava/util/zip/ZipEntry;)Ljava/io/InputStream;");
                return super.getInputStream(zipEntry);
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarVerifier$VerifierStream");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getManifestFromReference:()Ljava/util/jar/Manifest;");
        Manifest manifest = this.getManifestFromReference();
        boolean bl = zipEntry instanceof JarFileEntry;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            jarEntry = (JarEntry)zipEntry;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.getName:()Ljava/lang/String;");
            String string = zipEntry.getName();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getJarEntry:(Ljava/lang/String;)Ljava/util/jar/JarEntry;");
            jarEntry = this.getJarEntry(string);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.getInputStream:(Ljava/util/zip/ZipEntry;)Ljava/io/InputStream;");
        InputStream inputStream = super.getInputStream(zipEntry);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier$VerifierStream.<init>:(Ljava/util/jar/Manifest;Ljava/util/jar/JarEntry;Ljava/io/InputStream;Ljava/util/jar/JarVerifier;)V");
        return new JarVerifier.VerifierStream(manifest, jarEntry, inputStream, this.jv);
    }

    private JarEntry getManEntry() {
        RuntimeCostAccounter.recordJump();
        if (this.manEntry == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getJarEntry:(Ljava/lang/String;)Ljava/util/jar/JarEntry;");
            this.manEntry = this.getJarEntry(MANIFEST_NAME);
            RuntimeCostAccounter.recordJump();
            if (this.manEntry == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getMetaInfEntryNames:()[Ljava/lang/String;");
                String[] stringArray = this.getMetaInfEntryNames();
                RuntimeCostAccounter.recordJump();
                if (stringArray != null) {
                    int n = 0;
                    while (true) {
                        int n2 = stringArray.length;
                        RuntimeCostAccounter.recordJump();
                        if (n >= n2) break;
                        String string = stringArray[n];
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.toUpperCase:(Ljava/util/Locale;)Ljava/lang/String;");
                        String string2 = string.toUpperCase(Locale.ENGLISH);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                        boolean bl = MANIFEST_NAME.equals(string2);
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            String string3 = stringArray[n];
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getJarEntry:(Ljava/lang/String;)Ljava/util/jar/JarEntry;");
                            this.manEntry = this.getJarEntry(string3);
                            RuntimeCostAccounter.recordJump();
                            break;
                        }
                        ++n;
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
        }
        return this.manEntry;
    }

    boolean hasClassPathAttribute() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.checkForSpecialAttributes:()V");
        this.checkForSpecialAttributes();
        return this.hasClassPathAttribute;
    }

    private boolean match(char[] cArray, byte[] byArray, int[] nArray, int[] nArray2) {
        block5: {
            int n = cArray.length;
            int n2 = byArray.length - n;
            int n3 = 0;
            block0: while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 > n2) break block5;
                int n4 = n - 1;
                while (true) {
                    char c;
                    RuntimeCostAccounter.recordJump();
                    if (n4 < 0) break block0;
                    char c2 = (char)byArray[n3 + n4];
                    RuntimeCostAccounter.recordJump();
                    if ((c2 - 65 | 90 - c2) >= 0) {
                        c = (char)(c2 + 32);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        c = c2;
                    }
                    c2 = c;
                    char c3 = cArray[n4];
                    RuntimeCostAccounter.recordJump();
                    if (c2 != c3) {
                        int n5 = n4 + 1 - nArray[c2 & 0x7F];
                        int n6 = nArray2[n4];
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
                        n3 += Math.max(n5, n6);
                        RuntimeCostAccounter.recordJump();
                        continue block0;
                    }
                    --n4;
                    RuntimeCostAccounter.recordJump();
                }
                break;
            }
            return true;
        }
        return false;
    }

    private void checkForSpecialAttributes() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.hasCheckedSpecialAttributes) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.isKnownNotToHaveSpecialAttributes:()Z");
        boolean bl = this.isKnownNotToHaveSpecialAttributes();
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getManEntry:()Ljava/util/jar/JarEntry;");
            JarEntry jarEntry = this.getManEntry();
            RuntimeCostAccounter.recordJump();
            if (jarEntry != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getBytes:(Ljava/util/zip/ZipEntry;)[B");
                byte[] byArray = this.getBytes(jarEntry);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.match:([C[B[I[I)Z");
                boolean bl2 = this.match(CLASSPATH_CHARS, byArray, CLASSPATH_LASTOCC, CLASSPATH_OPTOSFT);
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    this.hasClassPathAttribute = true;
                }
            }
        }
        this.hasCheckedSpecialAttributes = true;
    }

    private boolean isKnownNotToHaveSpecialAttributes() {
        String string;
        String[] stringArray;
        RuntimeCostAccounter.recordJump();
        if (javaHome == null) {
            RuntimeCostAccounter.recordAllocation((String)"sun/security/action/GetPropertyAction");
            RuntimeCostAccounter.recordMethodCall((String)"sun/security/action/GetPropertyAction.<init>:(Ljava/lang/String;)V");
            GetPropertyAction getPropertyAction = new GetPropertyAction("java.home");
            RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
            javaHome = (String)AccessController.doPrivileged((PrivilegedAction)getPropertyAction);
        }
        RuntimeCostAccounter.recordJump();
        if (jarNames == null) {
            RuntimeCostAccounter.recordArrayAllocation((int)11, (int)8);
            stringArray = new String[11];
            string = File.separator;
            int n = 0;
            int n2 = n++;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append("rt.jar");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            stringArray[n2] = stringBuilder3.toString();
            int n3 = n++;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder4 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append("jsse.jar");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            stringArray[n3] = stringBuilder6.toString();
            int n4 = n++;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder7 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder8 = stringBuilder7.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder9 = stringBuilder8.append("jce.jar");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            stringArray[n4] = stringBuilder9.toString();
            int n5 = n++;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder10 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder11 = stringBuilder10.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder12 = stringBuilder11.append("charsets.jar");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            stringArray[n5] = stringBuilder12.toString();
            int n6 = n++;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder13 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder14 = stringBuilder13.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder15 = stringBuilder14.append("dnsns.jar");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            stringArray[n6] = stringBuilder15.toString();
            int n7 = n++;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder16 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder17 = stringBuilder16.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder18 = stringBuilder17.append("zipfs.jar");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            stringArray[n7] = stringBuilder18.toString();
            int n8 = n++;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder19 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder20 = stringBuilder19.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder21 = stringBuilder20.append("localedata.jar");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            stringArray[n8] = stringBuilder21.toString();
            int n9 = n++;
            string = "cldrdata.jar";
            stringArray[n9] = "cldrdata.jar";
            int n10 = n++;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder22 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder23 = stringBuilder22.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder24 = stringBuilder23.append("sunjce_provider.jar");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            stringArray[n10] = stringBuilder24.toString();
            int n11 = n++;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder25 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder26 = stringBuilder25.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder27 = stringBuilder26.append("sunpkcs11.jar");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            stringArray[n11] = stringBuilder27.toString();
            int n12 = n++;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder28 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder29 = stringBuilder28.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder30 = stringBuilder29.append("sunec.jar");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            stringArray[n12] = stringBuilder30.toString();
            jarNames = stringArray;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getName:()Ljava/lang/String;");
        stringArray = this.getName();
        string = javaHome;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;)Z");
        boolean bl = stringArray.startsWith(string);
        RuntimeCostAccounter.recordJump();
        if (bl) {
            String[] stringArray2 = jarNames;
            int n = 0;
            while (true) {
                int n13 = stringArray2.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n13) break;
                String string2 = stringArray2[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.endsWith:(Ljava/lang/String;)Z");
                boolean bl2 = stringArray.endsWith(string2);
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    return true;
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }
        return false;
    }

    private synchronized void ensureInitialization() {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.maybeInstantiateVerifier:()V");
            this.maybeInstantiateVerifier();
        }
        catch (IOException iOException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimeException.<init>:(Ljava/lang/Throwable;)V");
            RuntimeException runtimeException = new RuntimeException(iOException);
            RuntimeCostAccounter.recordThrow();
            throw runtimeException;
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordJump();
        if (this.jv != null) {
            RuntimeCostAccounter.recordJump();
            if (!this.jvInitialized) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.initializeVerifier:()V");
                this.initializeVerifier();
                this.jvInitialized = true;
            }
        }
    }

    JarEntry newEntry(ZipEntry zipEntry) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarFile$JarFileEntry");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile$JarFileEntry.<init>:(Ljava/util/jar/JarFile;Ljava/util/zip/ZipEntry;)V");
        return new JarFileEntry(zipEntry);
    }

    Enumeration<String> entryNames(CodeSource[] codeSourceArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.ensureInitialization:()V");
        this.ensureInitialization();
        RuntimeCostAccounter.recordJump();
        if (this.jv != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.entryNames:(Ljava/util/jar/JarFile;[Ljava/security/CodeSource;)Ljava/util/Enumeration;");
            return this.jv.entryNames(this, codeSourceArray);
        }
        boolean bl = false;
        int n = 0;
        while (true) {
            int n2 = codeSourceArray.length;
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            CodeSource codeSource = codeSourceArray[n];
            RuntimeCostAccounter.recordMethodCall((String)"java/security/CodeSource.getCodeSigners:()[Ljava/security/CodeSigner;");
            CodeSigner[] codeSignerArray = codeSource.getCodeSigners();
            RuntimeCostAccounter.recordJump();
            if (codeSignerArray == null) {
                bl = true;
                RuntimeCostAccounter.recordJump();
                break;
            }
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.unsignedEntryNames:()Ljava/util/Enumeration;");
            return this.unsignedEntryNames();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarFile$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile$1.<init>:(Ljava/util/jar/JarFile;)V");
        return new Enumeration<String>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public String nextElement() {
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
        };
    }

    Enumeration<JarEntry> entries2() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.ensureInitialization:()V");
        this.ensureInitialization();
        RuntimeCostAccounter.recordJump();
        if (this.jv != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.entries:()Ljava/util/Enumeration;");
            Enumeration<? extends ZipEntry> enumeration = super.entries();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.entries2:(Ljava/util/jar/JarFile;Ljava/util/Enumeration;)Ljava/util/Enumeration;");
            return this.jv.entries2(this, enumeration);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.entries:()Ljava/util/Enumeration;");
        final Enumeration<? extends ZipEntry> enumeration = super.entries();
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarFile$2");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile$2.<init>:(Ljava/util/jar/JarFile;Ljava/util/Enumeration;)V");
        return new Enumeration<JarEntry>(){
            ZipEntry entry;
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public boolean hasMoreElements() {
                block2: {
                    ZipEntry zipEntry;
                    RuntimeCostAccounter.recordJump();
                    if (this.entry != null) {
                        return true;
                    }
                    while (true) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.hasMoreElements:()Z");
                        boolean bl = enumeration.hasMoreElements();
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break block2;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.nextElement:()Ljava/lang/Object;");
                        zipEntry = (ZipEntry)enumeration.nextElement();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.getName:()Ljava/lang/String;");
                        String string = zipEntry.getName();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.isSigningRelated:(Ljava/lang/String;)Z");
                        boolean bl2 = JarVerifier.isSigningRelated(string);
                        RuntimeCostAccounter.recordJump();
                        if (!bl2) break;
                        RuntimeCostAccounter.recordJump();
                    }
                    this.entry = zipEntry;
                    return true;
                }
                return false;
            }

            @Override
            public JarFileEntry nextElement() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile$2.hasMoreElements:()Z");
                boolean bl = this.hasMoreElements();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    ZipEntry zipEntry = this.entry;
                    this.entry = null;
                    RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarFile$JarFileEntry");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile$JarFileEntry.<init>:(Ljava/util/jar/JarFile;Ljava/util/zip/ZipEntry;)V");
                    return new JarFileEntry(zipEntry);
                }
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
        };
    }

    CodeSource[] getCodeSources(URL uRL) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.ensureInitialization:()V");
        this.ensureInitialization();
        RuntimeCostAccounter.recordJump();
        if (this.jv != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.getCodeSources:(Ljava/util/jar/JarFile;Ljava/net/URL;)[Ljava/security/CodeSource;");
            return this.jv.getCodeSources(this, uRL);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.unsignedEntryNames:()Ljava/util/Enumeration;");
        Enumeration<String> enumeration = this.unsignedEntryNames();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.hasMoreElements:()Z");
        boolean bl = enumeration.hasMoreElements();
        RuntimeCostAccounter.recordJump();
        if (bl) {
            RuntimeCostAccounter.recordArrayAllocation((int)1, (int)8);
            CodeSource[] codeSourceArray = new CodeSource[1];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.getUnsignedCS:(Ljava/net/URL;)Ljava/security/CodeSource;");
            codeSourceArray[0] = JarVerifier.getUnsignedCS(uRL);
            return codeSourceArray;
        }
        return null;
    }

    private Enumeration<String> unsignedEntryNames() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.entries:()Ljava/util/Enumeration;");
        final Enumeration<JarEntry> enumeration = this.entries();
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarFile$3");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile$3.<init>:(Ljava/util/jar/JarFile;Ljava/util/Enumeration;)V");
        return new Enumeration<String>(){
            String name;
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public boolean hasMoreElements() {
                block2: {
                    String string;
                    RuntimeCostAccounter.recordJump();
                    if (this.name != null) {
                        return true;
                    }
                    while (true) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.hasMoreElements:()Z");
                        boolean bl = enumeration.hasMoreElements();
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break block2;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.nextElement:()Ljava/lang/Object;");
                        ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.getName:()Ljava/lang/String;");
                        string = zipEntry.getName();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipEntry.isDirectory:()Z");
                        boolean bl2 = zipEntry.isDirectory();
                        RuntimeCostAccounter.recordJump();
                        if (bl2) continue;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.isSigningRelated:(Ljava/lang/String;)Z");
                        boolean bl3 = JarVerifier.isSigningRelated(string);
                        RuntimeCostAccounter.recordJump();
                        if (!bl3) break;
                        RuntimeCostAccounter.recordJump();
                    }
                    this.name = string;
                    return true;
                }
                return false;
            }

            @Override
            public String nextElement() {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile$3.hasMoreElements:()Z");
                boolean bl = this.hasMoreElements();
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    String string = this.name;
                    this.name = null;
                    return string;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
        };
    }

    CodeSource getCodeSource(URL uRL, String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.ensureInitialization:()V");
        this.ensureInitialization();
        RuntimeCostAccounter.recordJump();
        if (this.jv != null) {
            boolean bl = this.jv.eagerValidation;
            RuntimeCostAccounter.recordJump();
            if (bl) {
                CodeSource codeSource = null;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getJarEntry:(Ljava/lang/String;)Ljava/util/jar/JarEntry;");
                JarEntry jarEntry = this.getJarEntry(string);
                RuntimeCostAccounter.recordJump();
                if (jarEntry != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.getCodeSource:(Ljava/net/URL;Ljava/util/jar/JarFile;Ljava/util/jar/JarEntry;)Ljava/security/CodeSource;");
                    codeSource = this.jv.getCodeSource(uRL, this, jarEntry);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.getCodeSource:(Ljava/net/URL;Ljava/lang/String;)Ljava/security/CodeSource;");
                    codeSource = this.jv.getCodeSource(uRL, string);
                }
                return codeSource;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.getCodeSource:(Ljava/net/URL;Ljava/lang/String;)Ljava/security/CodeSource;");
            return this.jv.getCodeSource(uRL, string);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.getUnsignedCS:(Ljava/net/URL;)Ljava/security/CodeSource;");
        return JarVerifier.getUnsignedCS(uRL);
    }

    void setEagerValidation(boolean bl) {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.maybeInstantiateVerifier:()V");
            this.maybeInstantiateVerifier();
        }
        catch (IOException iOException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimeException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimeException.<init>:(Ljava/lang/Throwable;)V");
            RuntimeException runtimeException = new RuntimeException(iOException);
            RuntimeCostAccounter.recordThrow();
            throw runtimeException;
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordJump();
        if (this.jv != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.setEagerValidation:(Z)V");
            this.jv.setEagerValidation(bl);
        }
    }

    List<Object> getManifestDigests() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.ensureInitialization:()V");
        this.ensureInitialization();
        RuntimeCostAccounter.recordJump();
        if (this.jv != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarVerifier.getManifestDigests:()Ljava/util/List;");
            return this.jv.getManifestDigests();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        return new ArrayList<Object>();
    }

    static /* synthetic */ Enumeration access$001(JarFile jarFile) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipFile.entries:()Ljava/util/Enumeration;");
        return super.entries();
    }

    static /* synthetic */ void access$200(JarFile jarFile) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.maybeInstantiateVerifier:()V");
        jarFile.maybeInstantiateVerifier();
    }

    static /* synthetic */ JarVerifier access$300(JarFile jarFile) {
        return jarFile.jv;
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JavaUtilJarAccessImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JavaUtilJarAccessImpl.<init>:()V");
        JavaUtilJarAccessImpl javaUtilJarAccessImpl = new JavaUtilJarAccessImpl();
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/SharedSecrets.setJavaUtilJarAccess:(Lsun/misc/JavaUtilJarAccess;)V");
        SharedSecrets.setJavaUtilJarAccess((JavaUtilJarAccess)javaUtilJarAccessImpl);
        RuntimeCostAccounter.recordArrayAllocation((int)10, (int)2);
        CLASSPATH_CHARS = new char[]{'c', 'l', 'a', 's', 's', '-', 'p', 'a', 't', 'h'};
        RuntimeCostAccounter.recordArrayAllocation((int)128, (int)4);
        CLASSPATH_LASTOCC = new int[128];
        RuntimeCostAccounter.recordArrayAllocation((int)10, (int)4);
        CLASSPATH_OPTOSFT = new int[10];
        JarFile.CLASSPATH_LASTOCC[99] = 1;
        JarFile.CLASSPATH_LASTOCC[108] = 2;
        JarFile.CLASSPATH_LASTOCC[115] = 5;
        JarFile.CLASSPATH_LASTOCC[45] = 6;
        JarFile.CLASSPATH_LASTOCC[112] = 7;
        JarFile.CLASSPATH_LASTOCC[97] = 8;
        JarFile.CLASSPATH_LASTOCC[116] = 9;
        JarFile.CLASSPATH_LASTOCC[104] = 10;
        int n = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= 9) break;
            JarFile.CLASSPATH_OPTOSFT[n] = 10;
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        JarFile.CLASSPATH_OPTOSFT[9] = 1;
    }

    private class JarFileEntry
    extends JarEntry {
        JarFileEntry(ZipEntry zipEntry) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarEntry.<init>:(Ljava/util/zip/ZipEntry;)V");
            super(zipEntry);
        }

        @Override
        public Attributes getAttributes() throws IOException {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.getManifest:()Ljava/util/jar/Manifest;");
            Manifest manifest = JarFile.this.getManifest();
            RuntimeCostAccounter.recordJump();
            if (manifest != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile$JarFileEntry.getName:()Ljava/lang/String;");
                String string = this.getName();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/Manifest.getAttributes:(Ljava/lang/String;)Ljava/util/jar/Attributes;");
                return manifest.getAttributes(string);
            }
            return null;
        }

        /*
         * Exception decompiling
         */
        @Override
        public Certificate[] getCertificates() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Invalid type string [s
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolUtils.decodeTypeTok(ConstantPoolUtils.java:101)
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryClass.convertFromString(ConstantPoolEntryClass.java:52)
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryClass.getTypeInstance(ConstantPoolEntryClass.java:61)
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryMethodRef.getMethodPrototype(ConstantPoolEntryMethodRef.java:72)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvoke(Op02WithProcessedDataAndRefs.java:331)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1224)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        public CodeSigner[] getCodeSigners() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Invalid type string [s
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolUtils.decodeTypeTok(ConstantPoolUtils.java:101)
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryClass.convertFromString(ConstantPoolEntryClass.java:52)
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryClass.getTypeInstance(ConstantPoolEntryClass.java:61)
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryMethodRef.getMethodPrototype(ConstantPoolEntryMethodRef.java:72)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvoke(Op02WithProcessedDataAndRefs.java:331)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1224)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class JarEntryIterator
    implements Enumeration<JarEntry>,
    Iterator<JarEntry> {
        final Enumeration<? extends ZipEntry> e;
        final /* synthetic */ JarFile this$0;

        private JarEntryIterator(JarFile jarFile) {
            this.this$0 = jarFile;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile.access$001:(Ljava/util/jar/JarFile;)Ljava/util/Enumeration;");
            this.e = JarFile.access$001(this.this$0);
        }

        @Override
        public boolean hasNext() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.hasMoreElements:()Z");
            return this.e.hasMoreElements();
        }

        @Override
        public JarEntry next() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.nextElement:()Ljava/lang/Object;");
            ZipEntry zipEntry = this.e.nextElement();
            RuntimeCostAccounter.recordAllocation((String)"java/util/jar/JarFile$JarFileEntry");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile$JarFileEntry.<init>:(Ljava/util/jar/JarFile;Ljava/util/zip/ZipEntry;)V");
            return this.this$0.new JarFileEntry(zipEntry);
        }

        @Override
        public boolean hasMoreElements() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile$JarEntryIterator.hasNext:()Z");
            return this.hasNext();
        }

        @Override
        public JarEntry nextElement() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile$JarEntryIterator.next:()Ljava/util/jar/JarEntry;");
            return this.next();
        }

        /* synthetic */ JarEntryIterator(JarFile jarFile, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/jar/JarFile$JarEntryIterator.<init>:(Ljava/util/jar/JarFile;)V");
            this(jarFile);
        }
    }
}

