---
sidebarDepth: 0
---

# Community

We welcome issues, contributions and discussion from all users, regardless of background or experience level. In order to create a positive and welcoming environment, all interactions are governed by Prefect's [Code of Conduct](code_of_conduct.md).

Please consider [Chris White](https://github.com/cicdw) the main point of contact for the Prefect repo.

# Prefect Community Discourse

[Prefect Discourse](https://discourse.prefect.io/) is a collaborative space to share knowledge, discuss ideas, find answers to common questions and get support. It's an online forum that allows you to easily find:
- information about Prefect features,
- information about Prefect integrations,
- troubleshooting tips,
- detailed solutions to common data engineering problems,
- resources to learn more about Prefect including blog posts, videos and code examples,
- announcements about new releases and events.


[Sign up](https://discourse.prefect.io/) and check out the [Getting started with Prefect Discourse](https://discourse.prefect.io/t/getting-started-with-prefect-discourse/25) guide.


# Slack

We have a public [Slack](https://prefect.io/slack) for chatting about Prefect, asking questions, and sharing tips.

## Slack Guidelines

Whether it's giving us feedback, raising a question, or showing your Prefect-related work, we are looking forward to hearing from you. The Prefect community is vibrant because of the quality of its members and the discussions they bring. To keep the workspace inviting and helpful for everyone, there are a few guidelines that we ask all members to follow.

**Rule 1: Assume Positive Intent**

Being nice is the most important pillar of the Prefect community. We are considerate to each other's effort and time. It's also easy to misinterpret people through Slack, so we make an extra effort to chat in a positive tone. We assume that you are here to learn and exchange ideas, and we ask that you contribute to making a welcoming community.

If someone is helping you, be mindful of the effort they are putting in. While we are always happy to help users, we can not help users with step-by-step debugging. Use your professional judgment in discerning whether requests are unreasonable. 

The Prefect team always tries to listen to the community. Please be understanding if your issue or feature request is not deemed an immediate priority.

**Rule 2: Use threads for larger messages**

Because of the size of our community and frequency of posts, it's easy for large messages to drown out smaller messages. Using threads helps people see more messages on their screen. Larger code blocks should be posted in threads.

**Rule 3: Avoid posting sensitive information**

Community members sometimes need to post code snippets as they ask for help. Be sure to remove sensitive information from posts to the public channels. If your Prefect account information is needed to help you, we will ask you to direct message such information. Be cautious of anyone asking for information through direct messages.

**Rule 4: Write high quality questions**

The Prefect community is here to support you. That said, it is significantly easier to answer well-researched and clearly-written questions. Even adding potentially relevant links to a post helps tremendously.
Informative Slack threads are archived by our resident bot Marvin. Having well-written threads helps future users encountering the same problem.

Oftentimes your question may have been answered somewhere else; some good resources to start looking before asking a question:
* [Previous Slack messages](https://github.com/PrefectHQ/prefect/issues?q=is%3Aopen+is%3Aissue+label%3A%22Prefect+Slack+Community%22) (we do our best to archive relevant threads to GitHub!)
* [Prefect documentation](https://docs.prefect.io/core/development/documentation.html)
* [Github issues](https://github.com/PrefectHQ/prefect/issues)
* [StackOverflow](https://stackoverflow.com/questions/tagged/prefect)

**Rule 5: Don't abuse tagging users**

Requests for help will be seen by the Prefect team, and will be directed to the appropriate person. Tagging individual users is highly discouraged unless it is in the context of a conversation thread.

**Rule 6: Avoid using DMs to ask for help**

Prefect employees should not be sent questions in DMs unless we specifically ask you to send us private information.

There are times when it makes sense to directly message another community member experiencing a similar issue, or working with similar technologies. Just be aware that some people may not want to be messaged.

It also helps other people if you post your question publicly. Similar to above, informative Slack threads are archived. Having conversations in public channels drives better quality discussions that can be referenced in the future.

**Rule 7: Don't advertise material unrelated to Prefect**

Our community is in the channel to learn more about Prefect. Showing us Prefect-related stuff that you're working on is highly encouraged. Advertising products and events unrelated to Prefect will be removed.
