---
sidebarDepth: 0
---

# Contents

These tutorials are intended to help the reader get acquainted with the many features of Prefect and its vocabulary. All code examples
are locally executable in any Python version supported by Prefect (3.7+). Note that all features presented here are run without
the Prefect server.

## [ETL](etl.md)

The "hello, world!" of data engineering

## [Using Prefect as a Calculator](calculator.md)

Can your data engineering framework do this?

## [Flow Visualization](visualization.md)

Visualize your Prefect flows with `flow.visualize()`

## [Local Debugging](local-debugging.md)

Learn some useful tips and tricks for how to debug common situations!

## [Advanced Features](advanced-mapping.md)<Badge text="advanced" type="warn"/>

Dynamically create large numbers of tasks using `task.map()`! Using a real-world web-scraping project as an example, walks through the more advanced features of Prefect including advanced parameter usage, task mapping, and parallelism.

## [Prefect Slack Integration](slack-notifications.md)

Install the Prefect Slack integration and get real time notifications on the state of your tasks and flows -- all within the convenience of Slack!

## [Prefect Deployment: Dask](dask-cluster.md)

Learn how to deploy your Prefect flow to a Dask cluster.

## [Prefect Deployment: Logging](custom-logs.md)

Learn how to customize and enhance your Prefect logs.
